/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.Matrix;
import java.io.Serializable;

public class LUDecomposition
implements Serializable {
    private double[][] LU;
    private int m;
    private int n;
    private int pivsign;
    private int[] piv;

    public LUDecomposition(Matrix matrix) {
        this.LU = matrix.getArrayCopy();
        this.m = matrix.getRowDimension();
        this.n = matrix.getColumnDimension();
        this.piv = new int[this.m];
        for (int j = 0; j < this.m; ++j) {
            this.piv[j] = j;
        }
        this.pivsign = 1;
        double[] dArray = new double[this.m];
        for (int j = 0; j < this.n; ++j) {
            double d;
            int n;
            int n2;
            for (n2 = 0; n2 < this.m; ++n2) {
                dArray[n2] = this.LU[n2][j];
            }
            n2 = 0;
            while (n2 < this.m) {
                double[] dArray2 = this.LU[n2];
                n = Math.min(n2, j);
                d = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += dArray2[k] * dArray[k];
                }
                int n3 = n2++;
                double d2 = dArray[n3] - d;
                dArray[n3] = d2;
                dArray2[j] = d2;
            }
            n2 = j;
            for (n = j + 1; n < this.m; ++n) {
                if (!(Math.abs(dArray[n]) > Math.abs(dArray[n2]))) continue;
                n2 = n;
            }
            if (n2 != j) {
                for (n = 0; n < this.n; ++n) {
                    d = this.LU[n2][n];
                    this.LU[n2][n] = this.LU[j][n];
                    this.LU[j][n] = d;
                }
                n = this.piv[n2];
                this.piv[n2] = this.piv[j];
                this.piv[j] = n;
                this.pivsign = -this.pivsign;
            }
            if (!(j < this.m & this.LU[j][j] != 0.0)) continue;
            for (n = j + 1; n < this.m; ++n) {
                double[] dArray3 = this.LU[n];
                int n4 = j;
                dArray3[n4] = dArray3[n4] / this.LU[j][j];
            }
        }
    }

    public boolean isNonsingular() {
        for (int j = 0; j < this.n; ++j) {
            if (this.LU[j][j] != 0.0) continue;
            return false;
        }
        return true;
    }

    public Matrix getL() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        for (int j = 0; j < this.m; ++j) {
            for (int k = 0; k < this.n; ++k) {
                dArray[j][k] = j > k ? this.LU[j][k] : (j == k ? 1.0 : 0.0);
            }
        }
        return matrix;
    }

    public Matrix getU() {
        Matrix matrix = new Matrix(this.n, this.n);
        double[][] dArray = matrix.getArray();
        for (int j = 0; j < this.n; ++j) {
            for (int k = 0; k < this.n; ++k) {
                dArray[j][k] = j <= k ? this.LU[j][k] : 0.0;
            }
        }
        return matrix;
    }

    public int[] getPivot() {
        int[] nArray = new int[this.m];
        for (int j = 0; j < this.m; ++j) {
            nArray[j] = this.piv[j];
        }
        return nArray;
    }

    public double[] getDoublePivot() {
        double[] dArray = new double[this.m];
        for (int j = 0; j < this.m; ++j) {
            dArray[j] = this.piv[j];
        }
        return dArray;
    }

    public double det() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d = this.pivsign;
        for (int j = 0; j < this.n; ++j) {
            d *= this.LU[j][j];
        }
        return d;
    }

    public Matrix solve(Matrix matrix) {
        int n;
        int n2;
        int n3;
        if (matrix.getRowDimension() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        int n4 = matrix.getColumnDimension();
        Matrix matrix2 = matrix.getMatrix(this.piv, 0, n4 - 1);
        double[][] dArray = matrix2.getArray();
        for (n3 = 0; n3 < this.n; ++n3) {
            for (n2 = n3 + 1; n2 < this.n; ++n2) {
                for (n = 0; n < n4; ++n) {
                    double[] dArray2 = dArray[n2];
                    int n5 = n;
                    dArray2[n5] = dArray2[n5] - dArray[n3][n] * this.LU[n2][n3];
                }
            }
        }
        for (n3 = this.n - 1; n3 >= 0; --n3) {
            n2 = 0;
            while (n2 < n4) {
                double[] dArray3 = dArray[n3];
                int n6 = n2++;
                dArray3[n6] = dArray3[n6] / this.LU[n3][n3];
            }
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n4; ++n) {
                    double[] dArray4 = dArray[n2];
                    int n7 = n;
                    dArray4[n7] = dArray4[n7] - dArray[n3][n] * this.LU[n2][n3];
                }
            }
        }
        return matrix2;
    }
}

