/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.CholeskyDecomposition;
import Jama.EigenvalueDecomposition;
import Jama.LUDecomposition;
import Jama.QRDecomposition;
import Jama.SingularValueDecomposition;
import Jama.util.Maths;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;

public class Matrix
implements Cloneable,
Serializable {
    private double[][] A;
    private int m;
    private int n;

    public Matrix(int n, int n2) {
        this.m = n;
        this.n = n2;
        this.A = new double[n][n2];
    }

    public Matrix(int n, int n2, double d) {
        this.m = n;
        this.n = n2;
        this.A = new double[n][n2];
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                this.A[j][k] = d;
            }
        }
    }

    public Matrix(double[][] dArray) {
        this.m = dArray.length;
        this.n = dArray[0].length;
        for (int j = 0; j < this.m; ++j) {
            if (dArray[j].length == this.n) continue;
            throw new IllegalArgumentException("All rows must have the same length.");
        }
        this.A = dArray;
    }

    public Matrix(double[][] dArray, int n, int n2) {
        this.A = dArray;
        this.m = n;
        this.n = n2;
    }

    public Matrix(double[] dArray, int n) {
        this.m = n;
        int n2 = this.n = n != 0 ? dArray.length / n : 0;
        if (n * this.n != dArray.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        this.A = new double[n][this.n];
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < this.n; ++k) {
                this.A[j][k] = dArray[j + k * n];
            }
        }
    }

    public static Matrix constructWithCopy(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        Matrix matrix = new Matrix(n, n2);
        double[][] dArray2 = matrix.getArray();
        for (int j = 0; j < n; ++j) {
            if (dArray[j].length != n2) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            for (int k = 0; k < n2; ++k) {
                dArray2[j][k] = dArray[j][k];
            }
        }
        return matrix;
    }

    public Matrix copy() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        for (int j = 0; j < this.m; ++j) {
            for (int k = 0; k < this.n; ++k) {
                dArray[j][k] = this.A[j][k];
            }
        }
        return matrix;
    }

    public Object clone() {
        return this.copy();
    }

    public double[][] getArray() {
        return this.A;
    }

    public double[][] getArrayCopy() {
        double[][] dArray = new double[this.m][this.n];
        for (int j = 0; j < this.m; ++j) {
            for (int k = 0; k < this.n; ++k) {
                dArray[j][k] = this.A[j][k];
            }
        }
        return dArray;
    }

    public double[] getColumnPackedCopy() {
        double[] dArray = new double[this.m * this.n];
        for (int j = 0; j < this.m; ++j) {
            for (int k = 0; k < this.n; ++k) {
                dArray[j + k * this.m] = this.A[j][k];
            }
        }
        return dArray;
    }

    public double[] getRowPackedCopy() {
        double[] dArray = new double[this.m * this.n];
        for (int j = 0; j < this.m; ++j) {
            for (int k = 0; k < this.n; ++k) {
                dArray[j * this.n + k] = this.A[j][k];
            }
        }
        return dArray;
    }

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public double get(int n, int n2) {
        return this.A[n][n2];
    }

    public Matrix getMatrix(int n, int n2, int n3, int n4) {
        Matrix matrix = new Matrix(n2 - n + 1, n4 - n3 + 1);
        double[][] dArray = matrix.getArray();
        try {
            for (int j = n; j <= n2; ++j) {
                for (int k = n3; k <= n4; ++k) {
                    dArray[j - n][k - n3] = this.A[j][k];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getMatrix(int[] nArray, int[] nArray2) {
        Matrix matrix = new Matrix(nArray.length, nArray2.length);
        double[][] dArray = matrix.getArray();
        try {
            for (int j = 0; j < nArray.length; ++j) {
                for (int k = 0; k < nArray2.length; ++k) {
                    dArray[j][k] = this.A[nArray[j]][nArray2[k]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getMatrix(int n, int n2, int[] nArray) {
        Matrix matrix = new Matrix(n2 - n + 1, nArray.length);
        double[][] dArray = matrix.getArray();
        try {
            for (int j = n; j <= n2; ++j) {
                for (int k = 0; k < nArray.length; ++k) {
                    dArray[j - n][k] = this.A[j][nArray[k]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getMatrix(int[] nArray, int n, int n2) {
        Matrix matrix = new Matrix(nArray.length, n2 - n + 1);
        double[][] dArray = matrix.getArray();
        try {
            for (int j = 0; j < nArray.length; ++j) {
                for (int k = n; k <= n2; ++k) {
                    dArray[j][k - n] = this.A[nArray[j]][k];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public void set(int n, int n2, double d) {
        this.A[n][n2] = d;
    }

    public void setMatrix(int n, int n2, int n3, int n4, Matrix matrix) {
        try {
            for (int j = n; j <= n2; ++j) {
                for (int k = n3; k <= n4; ++k) {
                    this.A[j][k] = matrix.get(j - n, k - n3);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] nArray, int[] nArray2, Matrix matrix) {
        try {
            for (int j = 0; j < nArray.length; ++j) {
                for (int k = 0; k < nArray2.length; ++k) {
                    this.A[nArray[j]][nArray2[k]] = matrix.get(j, k);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] nArray, int n, int n2, Matrix matrix) {
        try {
            for (int j = 0; j < nArray.length; ++j) {
                for (int k = n; k <= n2; ++k) {
                    this.A[nArray[j]][k] = matrix.get(j, k - n);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int n, int n2, int[] nArray, Matrix matrix) {
        try {
            for (int j = n; j <= n2; ++j) {
                for (int k = 0; k < nArray.length; ++k) {
                    this.A[j][nArray[k]] = matrix.get(j - n, k);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public Matrix transpose() {
        Matrix matrix = new Matrix(this.n, this.m);
        double[][] dArray = matrix.getArray();
        for (int j = 0; j < this.m; ++j) {
            for (int k = 0; k < this.n; ++k) {
                dArray[k][j] = this.A[j][k];
            }
        }
        return matrix;
    }

    public double norm1() {
        double d = 0.0;
        for (int j = 0; j < this.n; ++j) {
            double d2 = 0.0;
            for (int k = 0; k < this.m; ++k) {
                d2 += Math.abs(this.A[k][j]);
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public double norm2() {
        return new SingularValueDecomposition(this).norm2();
    }

    public double normInf() {
        double d = 0.0;
        for (int j = 0; j < this.m; ++j) {
            double d2 = 0.0;
            for (int k = 0; k < this.n; ++k) {
                d2 += Math.abs(this.A[j][k]);
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public double normF() {
        double d = 0.0;
        for (int j = 0; j < this.m; ++j) {
            for (int k = 0; k < this.n; ++k) {
                d = Maths.hypot(d, this.A[j][k]);
            }
        }
        return d;
    }

    public Matrix uminus() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        for (int j = 0; j < this.m; ++j) {
            for (int k = 0; k < this.n; ++k) {
                dArray[j][k] = -this.A[j][k];
            }
        }
        return matrix;
    }

    public Matrix plus(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        for (int j = 0; j < this.m; ++j) {
            for (int k = 0; k < this.n; ++k) {
                dArray[j][k] = this.A[j][k] + matrix.A[j][k];
            }
        }
        return matrix2;
    }

    public Matrix plusEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        for (int j = 0; j < this.m; ++j) {
            for (int k = 0; k < this.n; ++k) {
                this.A[j][k] = this.A[j][k] + matrix.A[j][k];
            }
        }
        return this;
    }

    public Matrix minus(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        for (int j = 0; j < this.m; ++j) {
            for (int k = 0; k < this.n; ++k) {
                dArray[j][k] = this.A[j][k] - matrix.A[j][k];
            }
        }
        return matrix2;
    }

    public Matrix minusEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        for (int j = 0; j < this.m; ++j) {
            for (int k = 0; k < this.n; ++k) {
                this.A[j][k] = this.A[j][k] - matrix.A[j][k];
            }
        }
        return this;
    }

    public Matrix arrayTimes(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        for (int j = 0; j < this.m; ++j) {
            for (int k = 0; k < this.n; ++k) {
                dArray[j][k] = this.A[j][k] * matrix.A[j][k];
            }
        }
        return matrix2;
    }

    public Matrix arrayTimesEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        for (int j = 0; j < this.m; ++j) {
            for (int k = 0; k < this.n; ++k) {
                this.A[j][k] = this.A[j][k] * matrix.A[j][k];
            }
        }
        return this;
    }

    public Matrix arrayRightDivide(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        for (int j = 0; j < this.m; ++j) {
            for (int k = 0; k < this.n; ++k) {
                dArray[j][k] = this.A[j][k] / matrix.A[j][k];
            }
        }
        return matrix2;
    }

    public Matrix arrayRightDivideEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        for (int j = 0; j < this.m; ++j) {
            for (int k = 0; k < this.n; ++k) {
                this.A[j][k] = this.A[j][k] / matrix.A[j][k];
            }
        }
        return this;
    }

    public Matrix arrayLeftDivide(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        for (int j = 0; j < this.m; ++j) {
            for (int k = 0; k < this.n; ++k) {
                dArray[j][k] = matrix.A[j][k] / this.A[j][k];
            }
        }
        return matrix2;
    }

    public Matrix arrayLeftDivideEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        for (int j = 0; j < this.m; ++j) {
            for (int k = 0; k < this.n; ++k) {
                this.A[j][k] = matrix.A[j][k] / this.A[j][k];
            }
        }
        return this;
    }

    public Matrix times(double d) {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        for (int j = 0; j < this.m; ++j) {
            for (int k = 0; k < this.n; ++k) {
                dArray[j][k] = d * this.A[j][k];
            }
        }
        return matrix;
    }

    public Matrix timesEquals(double d) {
        for (int j = 0; j < this.m; ++j) {
            for (int k = 0; k < this.n; ++k) {
                this.A[j][k] = d * this.A[j][k];
            }
        }
        return this;
    }

    public Matrix times(Matrix matrix) {
        if (matrix.m != this.n) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        Matrix matrix2 = new Matrix(this.m, matrix.n);
        double[][] dArray = matrix2.getArray();
        double[] dArray2 = new double[this.n];
        for (int j = 0; j < matrix.n; ++j) {
            int n;
            for (n = 0; n < this.n; ++n) {
                dArray2[n] = matrix.A[n][j];
            }
            for (n = 0; n < this.m; ++n) {
                double[] dArray3 = this.A[n];
                double d = 0.0;
                for (int k = 0; k < this.n; ++k) {
                    d += dArray3[k] * dArray2[k];
                }
                dArray[n][j] = d;
            }
        }
        return matrix2;
    }

    public LUDecomposition lu() {
        return new LUDecomposition(this);
    }

    public QRDecomposition qr() {
        return new QRDecomposition(this);
    }

    public CholeskyDecomposition chol() {
        return new CholeskyDecomposition(this);
    }

    public SingularValueDecomposition svd() {
        return new SingularValueDecomposition(this);
    }

    public EigenvalueDecomposition eig() {
        return new EigenvalueDecomposition(this);
    }

    public Matrix solve(Matrix matrix) {
        return this.m == this.n ? new LUDecomposition(this).solve(matrix) : new QRDecomposition(this).solve(matrix);
    }

    public Matrix solveTranspose(Matrix matrix) {
        return this.transpose().solve(matrix.transpose());
    }

    public Matrix inverse() {
        return this.solve(Matrix.identity(this.m, this.m));
    }

    public double det() {
        return new LUDecomposition(this).det();
    }

    public int rank() {
        return new SingularValueDecomposition(this).rank();
    }

    public double cond() {
        return new SingularValueDecomposition(this).cond();
    }

    public double trace() {
        double d = 0.0;
        for (int j = 0; j < Math.min(this.m, this.n); ++j) {
            d += this.A[j][j];
        }
        return d;
    }

    public static Matrix random(int n, int n2) {
        Matrix matrix = new Matrix(n, n2);
        double[][] dArray = matrix.getArray();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                dArray[j][k] = Math.random();
            }
        }
        return matrix;
    }

    public static Matrix identity(int n, int n2) {
        Matrix matrix = new Matrix(n, n2);
        double[][] dArray = matrix.getArray();
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                dArray[j][k] = j == k ? 1.0 : 0.0;
            }
        }
        return matrix;
    }

    public void print(int n, int n2) {
        this.print(new PrintWriter(System.out, true), n, n2);
    }

    public void print(PrintWriter printWriter, int n, int n2) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        decimalFormat.setMinimumIntegerDigits(1);
        decimalFormat.setMaximumFractionDigits(n2);
        decimalFormat.setMinimumFractionDigits(n2);
        decimalFormat.setGroupingUsed(false);
        this.print(printWriter, decimalFormat, n + 2);
    }

    public void print(NumberFormat numberFormat, int n) {
        this.print(new PrintWriter(System.out, true), numberFormat, n);
    }

    public void print(PrintWriter printWriter, NumberFormat numberFormat, int n) {
        printWriter.println();
        for (int j = 0; j < this.m; ++j) {
            for (int k = 0; k < this.n; ++k) {
                String string = numberFormat.format(this.A[j][k]);
                int n2 = Math.max(1, n - string.length());
                for (int i2 = 0; i2 < n2; ++i2) {
                    printWriter.print(' ');
                }
                printWriter.print(string);
            }
            printWriter.println();
        }
        printWriter.println();
    }

    public static Matrix read(BufferedReader bufferedReader) throws IOException {
        int n;
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(0, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.eolIsSignificant(true);
        Vector<Object> vector = new Vector<Object>();
        while (streamTokenizer.nextToken() == 10) {
        }
        if (streamTokenizer.ttype == -1) {
            throw new IOException("Unexpected EOF on matrix read.");
        }
        do {
            vector.addElement(Double.valueOf(streamTokenizer.sval));
        } while (streamTokenizer.nextToken() == -3);
        int n2 = vector.size();
        double[] dArray = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = (Double)vector.elementAt(n);
        }
        vector.removeAllElements();
        vector.addElement(dArray);
        while (streamTokenizer.nextToken() == -3) {
            dArray = new double[n2];
            vector.addElement(dArray);
            n = 0;
            do {
                if (n >= n2) {
                    throw new IOException("Row " + vector.size() + " is too long.");
                }
                dArray[n++] = Double.valueOf(streamTokenizer.sval);
            } while (streamTokenizer.nextToken() == -3);
            if (n >= n2) continue;
            throw new IOException("Row " + vector.size() + " is too short.");
        }
        n = vector.size();
        double[][] dArrayArray = new double[n][];
        vector.copyInto((Object[])dArrayArray);
        return new Matrix(dArrayArray);
    }

    private void checkMatrixDimensions(Matrix matrix) {
        if (matrix.m != this.m || matrix.n != this.n) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
    }
}

