/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.Matrix;
import Jama.util.Maths;
import java.io.Serializable;

public class QRDecomposition
implements Serializable {
    private double[][] QR;
    private int m;
    private int n;
    private double[] Rdiag;

    public QRDecomposition(Matrix matrix) {
        this.QR = matrix.getArrayCopy();
        this.m = matrix.getRowDimension();
        this.n = matrix.getColumnDimension();
        this.Rdiag = new double[this.n];
        for (int j = 0; j < this.n; ++j) {
            int n;
            double d = 0.0;
            for (n = j; n < this.m; ++n) {
                d = Maths.hypot(d, this.QR[n][j]);
            }
            if (d != 0.0) {
                if (this.QR[j][j] < 0.0) {
                    d = -d;
                }
                for (n = j; n < this.m; ++n) {
                    double[] dArray = this.QR[n];
                    int n2 = j;
                    dArray[n2] = dArray[n2] / d;
                }
                double[] dArray = this.QR[j];
                int n3 = j;
                dArray[n3] = dArray[n3] + 1.0;
                for (n = j + 1; n < this.n; ++n) {
                    int n4;
                    double d2 = 0.0;
                    for (n4 = j; n4 < this.m; ++n4) {
                        d2 += this.QR[n4][j] * this.QR[n4][n];
                    }
                    d2 = -d2 / this.QR[j][j];
                    for (n4 = j; n4 < this.m; ++n4) {
                        double[] dArray2 = this.QR[n4];
                        int n5 = n;
                        dArray2[n5] = dArray2[n5] + d2 * this.QR[n4][j];
                    }
                }
            }
            this.Rdiag[j] = -d;
        }
    }

    public boolean isFullRank() {
        for (int j = 0; j < this.n; ++j) {
            if (this.Rdiag[j] != 0.0) continue;
            return false;
        }
        return true;
    }

    public Matrix getH() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        for (int j = 0; j < this.m; ++j) {
            for (int k = 0; k < this.n; ++k) {
                dArray[j][k] = j >= k ? this.QR[j][k] : 0.0;
            }
        }
        return matrix;
    }

    public Matrix getR() {
        Matrix matrix = new Matrix(this.n, this.n);
        double[][] dArray = matrix.getArray();
        for (int j = 0; j < this.n; ++j) {
            for (int k = 0; k < this.n; ++k) {
                dArray[j][k] = j < k ? this.QR[j][k] : (j == k ? this.Rdiag[j] : 0.0);
            }
        }
        return matrix;
    }

    public Matrix getQ() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        for (int j = this.n - 1; j >= 0; --j) {
            int n;
            for (n = 0; n < this.m; ++n) {
                dArray[n][j] = 0.0;
            }
            dArray[j][j] = 1.0;
            for (n = j; n < this.n; ++n) {
                int n2;
                if (this.QR[j][j] == 0.0) continue;
                double d = 0.0;
                for (n2 = j; n2 < this.m; ++n2) {
                    d += this.QR[n2][j] * dArray[n2][n];
                }
                d = -d / this.QR[j][j];
                for (n2 = j; n2 < this.m; ++n2) {
                    double[] dArray2 = dArray[n2];
                    int n3 = n;
                    dArray2[n3] = dArray2[n3] + d * this.QR[n2][j];
                }
            }
        }
        return matrix;
    }

    public Matrix solve(Matrix matrix) {
        int n;
        int n2;
        if (matrix.getRowDimension() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isFullRank()) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        int n3 = matrix.getColumnDimension();
        double[][] dArray = matrix.getArrayCopy();
        for (n2 = 0; n2 < this.n; ++n2) {
            for (n = 0; n < n3; ++n) {
                int n4;
                double d = 0.0;
                for (n4 = n2; n4 < this.m; ++n4) {
                    d += this.QR[n4][n2] * dArray[n4][n];
                }
                d = -d / this.QR[n2][n2];
                for (n4 = n2; n4 < this.m; ++n4) {
                    double[] dArray2 = dArray[n4];
                    int n5 = n;
                    dArray2[n5] = dArray2[n5] + d * this.QR[n4][n2];
                }
            }
        }
        for (n2 = this.n - 1; n2 >= 0; --n2) {
            n = 0;
            while (n < n3) {
                double[] dArray3 = dArray[n2];
                int n6 = n++;
                dArray3[n6] = dArray3[n6] / this.Rdiag[n2];
            }
            for (n = 0; n < n2; ++n) {
                for (int j = 0; j < n3; ++j) {
                    double[] dArray4 = dArray[n];
                    int n7 = j;
                    dArray4[n7] = dArray4[n7] - dArray[n2][j] * this.QR[n][n2];
                }
            }
        }
        return new Matrix(dArray, this.n, n3).getMatrix(0, this.n - 1, 0, n3 - 1);
    }
}

