/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.util.Trace;
import com.sun.javaws.MacOSLocalInstallHandler;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class ICNSEncoder {
    public static String getIconPath(LaunchDesc launchDesc) {
        String string;
        IconDesc iconDesc = ICNSEncoder.getIconDescriptionFrom(launchDesc);
        if (iconDesc == null) {
            return null;
        }
        URL uRL = iconDesc.getLocation();
        File file = ICNSEncoder.getCachedFile(uRL, string = iconDesc.getVersion());
        if (file == null) {
            return null;
        }
        File file2 = ICNSEncoder.getIconFileFromCachedFile(file, uRL);
        if (file2.exists()) {
            return file2.getAbsolutePath();
        }
        String string2 = file.getPath();
        return MacOSLocalInstallHandler.ConvertImageToICNSFile(string2, string2 + ".icns");
    }

    static IconDesc getIconDescriptionFrom(LaunchDesc launchDesc) {
        InformationDesc informationDesc = launchDesc.getInformation();
        IconDesc iconDesc = informationDesc.getIconLocation(512, 5);
        if (iconDesc != null) {
            return iconDesc;
        }
        return informationDesc.getIconLocation(512, 0);
    }

    static File getCachedFile(URL uRL, String string) {
        try {
            File file = DownloadEngine.getCachedShortcutImage((URL)uRL, (String)string);
            if (file != null) {
                return file;
            }
            return DownloadEngine.getUpdatedShortcutImage((URL)uRL, (String)string);
        }
        catch (IOException iOException) {
            Trace.ignored((Throwable)iOException);
            return null;
        }
    }

    static File getIconFileFromCachedFile(File file, URL uRL) {
        if (Config.getInstance().isPlatformIconType(uRL.toString())) {
            return file;
        }
        return new File(file.getPath() + ".icns");
    }
}

