/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.LocalApplicationProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.perf.DeployPerfUtil;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.Globals;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.FailedDownloadingResourceException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.exceptions.MultipleHostsException;
import com.sun.javaws.exceptions.NativeLibViolationException;
import com.sun.javaws.exceptions.UnsignedAccessViolationException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.ApplicationDesc;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InstallerDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.progress.CustomProgress;
import com.sun.javaws.progress.Progress;
import com.sun.javaws.progress.ProgressListener;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.security.SigningInfo;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sun.awt.AppContext;

public class LaunchDownload {
    private static boolean updateAvailable = false;
    private static int _numThread = 0;
    private static JNLPException _exception = null;
    private static final Object syncObj = new Object();
    public static final int CONCURRENT_DOWNLOADS_DEF = Config.getIntProperty((String)"deployment.javaws.concurrentDownloads") == -1 ? 4 : Config.getIntProperty((String)"deployment.javaws.concurrentDownloads");
    public static final String APPCONTEXT_THREADPOOL_KEY = Config.getAppContextKeyPrefix() + "launchdownloadthreadpoolinappcontext";
    private static final String SIGNED_JNLP_ENTRY = "JNLP-INF/APPLICATION.JNLP";

    public static boolean updateNoHrefLaunchDescInCache(LaunchDesc launchDesc) {
        if (!Cache.isCacheEnabled()) {
            return false;
        }
        URL uRL = launchDesc.getCanonicalHome();
        File file = null;
        try {
            file = DownloadEngine.getCachedFile((URL)uRL);
            if (file == null) {
                Cache.createNoHrefCacheEntry((URL)uRL, (byte[])launchDesc.getBytes());
                return true;
            }
            Trace.println((String)("Loaded descriptor from cache at: " + uRL), (TraceLevel)TraceLevel.BASIC);
            byte[] byArray = LaunchDescFactory.readBytes(new FileInputStream(file), file.length());
            if (launchDesc.hasIdenticalContent(byArray)) {
                return false;
            }
            Cache.createNoHrefCacheEntry((URL)uRL, (byte[])launchDesc.getBytes());
            return true;
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
            return false;
        }
    }

    public static LaunchDesc getUpdatedLaunchDesc(URL uRL, URL uRL2) throws JNLPException, IOException {
        boolean bl;
        if (uRL == null) {
            return null;
        }
        try {
            bl = DownloadEngine.isUpdateAvailable((URL)uRL, null);
        }
        catch (IOException iOException) {
            Trace.ignored((Throwable)iOException);
            bl = false;
        }
        if (!bl) {
            Trace.println((String)("Update JNLP: no update for: " + uRL), (TraceLevel)TraceLevel.BASIC);
            return null;
        }
        Trace.println((String)("Update JNLP: " + uRL + ", thisCodebase: " + uRL2), (TraceLevel)TraceLevel.BASIC);
        File file = null;
        try {
            DownloadEngine.getResource((URL)uRL, null, null, null, (boolean)true);
            file = DownloadEngine.getCachedFile((URL)uRL);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Trace.ignoredException((Exception)fileNotFoundException);
        }
        if (file != null) {
            LaunchDesc launchDesc = null;
            try {
                launchDesc = LaunchDescFactory.buildDescriptor(file, uRL2, uRL, uRL);
                return launchDesc;
            }
            catch (LaunchDescException launchDescException) {
                launchDesc = LaunchDescFactory.buildDescriptor(file);
                if (launchDesc == null) {
                    throw launchDescException;
                }
                return launchDesc;
            }
        }
        return LaunchDescFactory.buildDescriptor(uRL, uRL);
    }

    public static boolean isJnlpCached(LaunchDesc launchDesc) {
        try {
            return DownloadEngine.isResourceCached((URL)launchDesc.getCanonicalHome(), null, null);
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
            return false;
        }
    }

    public static boolean isInCache(LaunchDesc launchDesc) {
        return LaunchDownload.isInCache(launchDesc, false);
    }

    public static boolean isInCache(LaunchDesc launchDesc, boolean bl) {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return true;
        }
        try {
            boolean bl2;
            if (launchDesc.getLocation() != null && !DownloadEngine.isResourceCached((URL)launchDesc.getLocation(), null, null)) {
                return false;
            }
            if (!bl && !(bl2 = LaunchDownload.getCachedExtensions(launchDesc))) {
                return false;
            }
            JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(false);
            for (int j = 0; j < jARDescArray.length; ++j) {
                if (!DownloadEngine.isResourceCached((URL)jARDescArray[j].getLocation(), null, (String)jARDescArray[j].getVersion(), (int)(jARDescArray[j].isNativeLib() ? 272 : 1))) {
                    return false;
                }
                if (!DownloadEngine.isJarFileCorrupted((URL)jARDescArray[j].getLocation(), (String)jARDescArray[j].getVersion())) continue;
                DownloadEngine.removeCachedResource((URL)jARDescArray[j].getLocation(), null, (String)jARDescArray[j].getVersion());
                return false;
            }
        }
        catch (JNLPException jNLPException) {
            Trace.ignoredException((Exception)jNLPException);
            return false;
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
            return false;
        }
        return true;
    }

    private static void updateCheck(URL uRL, String string, boolean bl) {
        LaunchDownload.updateCheck(uRL, string, bl, false);
    }

    private static void updateCheck(URL uRL, String string, boolean bl, boolean bl2) {
        LaunchDownload.updateCheck(uRL, string, bl, bl2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateCheck(final URL uRL, final String string, boolean bl, final boolean bl2, final boolean bl3) {
        if (string != null) {
            return;
        }
        Object object = syncObj;
        synchronized (object) {
            ++_numThread;
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FailedDownloadingResourceException failedDownloadingResourceException = null;
                try {
                    boolean bl = DownloadEngine.isUpdateAvailable((URL)uRL, (String)string, (boolean)bl3);
                    if (bl2 && bl) {
                        Globals.setIconImageUpdated(true);
                    }
                    Object object = syncObj;
                    synchronized (object) {
                        if (bl && !updateAvailable) {
                            updateAvailable = true;
                        }
                    }
                }
                catch (IOException iOException) {
                    try {
                        failedDownloadingResourceException = new FailedDownloadingResourceException(uRL, string, iOException);
                    }
                    catch (Throwable throwable) {
                        Object object = syncObj;
                        synchronized (object) {
                            if (_exception == null) {
                                _exception = failedDownloadingResourceException;
                            }
                            _numThread--;
                        }
                        throw throwable;
                    }
                    Object object = syncObj;
                    synchronized (object) {
                        if (_exception == null) {
                            _exception = failedDownloadingResourceException;
                        }
                        _numThread--;
                    }
                }
                Object object = syncObj;
                synchronized (object) {
                    if (_exception == null) {
                        _exception = failedDownloadingResourceException;
                    }
                    _numThread--;
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUpdateAvailable(LaunchDesc launchDesc) throws JNLPException {
        Object object;
        ResourcesDesc resourcesDesc;
        URL uRL = launchDesc.getLocation();
        if (uRL != null) {
            try {
                boolean bl = DownloadEngine.isUpdateAvailable((URL)uRL, null);
                if (bl) {
                    return true;
                }
            }
            catch (IOException iOException) {
                throw new FailedDownloadingResourceException(uRL, null, iOException);
            }
        }
        if ((resourcesDesc = launchDesc.getResources()) == null) {
            return false;
        }
        ExtensionDesc[] extensionDescArray = resourcesDesc.getExtensionDescs();
        for (int j = 0; j < extensionDescArray.length; ++j) {
            URL uRL2 = extensionDescArray[j].getLocation();
            if (uRL2 == null) continue;
            LaunchDownload.updateCheck(uRL2, extensionDescArray[j].getVersion(), false);
        }
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        for (int j = 0; j < jARDescArray.length; ++j) {
            URL uRL3 = jARDescArray[j].getLocation();
            object = jARDescArray[j].getVersion();
            try {
                if (!DownloadEngine.isResourceCached((URL)uRL3, null, (String)object)) continue;
                LaunchDownload.updateCheck(uRL3, (String)object, jARDescArray[j].isLazyDownload(), false, jARDescArray[j].isPack200Enabled());
                continue;
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        IconDesc[] iconDescArray = launchDesc.getInformation().getIcons();
        if (iconDescArray != null) {
            for (int j = 0; j < iconDescArray.length; ++j) {
                object = iconDescArray[j].getLocation();
                String string = iconDescArray[j].getVersion();
                try {
                    if (DownloadEngine.getCachedFile((URL)object, (String)string) == null) continue;
                    LaunchDownload.updateCheck((URL)object, string, false, true);
                    continue;
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
            }
        }
        while (_numThread > 0) {
            Object object2 = syncObj;
            synchronized (object2) {
                if (updateAvailable) {
                    break;
                }
                if (_exception != null) {
                    throw _exception;
                }
            }
        }
        return updateAvailable;
    }

    public static void downloadExtensions(LaunchDesc launchDesc, ProgressListener progressListener, int n, ArrayList arrayList) throws IOException, JNLPException {
        LaunchDownload.downloadExtensionsHelper(launchDesc, progressListener, n, false, arrayList);
    }

    public static boolean getCachedExtensions(LaunchDesc launchDesc) throws IOException, JNLPException {
        return LaunchDownload.downloadExtensionsHelper(launchDesc, null, 0, true, null);
    }

    private static boolean downloadExtensionsHelper(LaunchDesc launchDesc, ProgressListener progressListener, int n, boolean bl, ArrayList arrayList) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return true;
        }
        String string = JREInfo.getKnownPlatforms();
        final ArrayList arrayList2 = new ArrayList();
        resourcesDesc.visit(new ResourceVisitor(){

            @Override
            public void visitJARDesc(JARDesc jARDesc) {
            }

            @Override
            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }

            @Override
            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            @Override
            public void visitJREDesc(JREDesc jREDesc) {
            }

            @Override
            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                arrayList2.add(extensionDesc);
            }
        });
        n += arrayList2.size();
        for (int j = 0; j < arrayList2.size(); ++j) {
            int n2;
            ExtensionDesc extensionDesc = (ExtensionDesc)arrayList2.get(j);
            String string2 = extensionDesc.getName();
            if (string2 == null && (n2 = (string2 = extensionDesc.getLocation().toString()).lastIndexOf(47)) > 0) {
                string2 = string2.substring(n2 + 1, string2.length());
            }
            --n;
            if (progressListener != null) {
                progressListener.extensionDownload(string2, n);
            }
            File file = DownloadEngine.getCachedFile((URL)extensionDesc.getLocation(), (String)extensionDesc.getVersion(), (!bl ? 1 : 0) != 0, (boolean)false, (String)JREInfo.getKnownPlatforms());
            Trace.println((String)("Downloaded extension: " + extensionDesc.getLocation() + "\n\tcodebase: " + extensionDesc.getCodebase() + "\n\tld parentCodebase: " + launchDesc.getCodebase() + "\n\tfile: " + file), (TraceLevel)TraceLevel.NETWORK);
            if (file == null) {
                return false;
            }
            LaunchDesc launchDesc2 = LaunchDescFactory.buildDescriptor(file, extensionDesc.getCodebase(), extensionDesc.getLocation(), extensionDesc.getLocation());
            boolean bl2 = false;
            if (launchDesc2.getLaunchType() == 3) {
                bl2 = true;
            } else if (launchDesc2.getLaunchType() == 4) {
                LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((URL)extensionDesc.getLocation(), (String)extensionDesc.getVersion(), (boolean)false);
                boolean bl3 = bl2 = !localApplicationProperties.isLocallyInstalled();
                if (arrayList != null && (LaunchDownload.isUpdateAvailable(launchDesc2) || bl2)) {
                    arrayList.add(file);
                }
                if (bl && bl2) {
                    return false;
                }
            } else {
                throw new MissingFieldException(launchDesc2.getSource(), "<component-desc>|<installer-desc>");
            }
            if (!bl2) continue;
            extensionDesc.setExtensionDesc(launchDesc2);
            boolean bl4 = LaunchDownload.downloadExtensionsHelper(launchDesc2, progressListener, n, bl, arrayList);
            if (bl4) continue;
            return false;
        }
        return true;
    }

    public static void downloadJRE(LaunchDesc launchDesc, ProgressListener progressListener, ArrayList arrayList) throws JNLPException, IOException {
        File file;
        LaunchDesc launchDesc2;
        String string;
        boolean bl;
        JREDesc jREDesc = launchDesc.getResources().getSelectedJRE();
        String string2 = jREDesc.getVersion();
        URL uRL = jREDesc.getHref();
        boolean bl2 = bl = uRL == null;
        if (uRL == null && (string = Config.getProperty((String)"deployment.javaws.installURL")) != null) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (progressListener != null) {
            progressListener.jreDownload(string2, uRL);
        }
        if ((launchDesc2 = LaunchDescFactory.buildDescriptor(file = DownloadEngine.getUpdatedFile((URL)uRL, (String)string2, (boolean)bl, (String)(string = JREInfo.getKnownPlatforms())), null, null, null)).getLaunchType() != 4) {
            throw new MissingFieldException(launchDesc2.getSource(), "<installer-desc>");
        }
        if (arrayList != null) {
            arrayList.add(file);
        }
        jREDesc.setExtensionDesc(launchDesc2);
        LaunchDownload.downloadExtensionsHelper(launchDesc2, progressListener, 0, false, arrayList);
    }

    public static void downloadResource(LaunchDesc launchDesc, URL uRL, String string, ProgressListener progressListener, boolean bl) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        int n = resourcesDesc.getConcurrentDownloads();
        JARDesc[] jARDescArray = resourcesDesc.getResource(uRL, string);
        LaunchDownload.downloadJarFiles(jARDescArray, progressListener, bl, n);
    }

    public static void downloadParts(LaunchDesc launchDesc, String[] stringArray, ProgressListener progressListener, boolean bl) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        int n = resourcesDesc.getConcurrentDownloads();
        JARDesc[] jARDescArray = resourcesDesc.getPartJars(stringArray);
        LaunchDownload.downloadJarFiles(jARDescArray, progressListener, bl, n);
    }

    public static void downloadExtensionPart(LaunchDesc launchDesc, URL uRL, String string, String[] stringArray, ProgressListener progressListener, boolean bl) throws IOException, JNLPException {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        int n = resourcesDesc.getConcurrentDownloads();
        JARDesc[] jARDescArray = resourcesDesc.getExtensionPart(uRL, string, stringArray);
        LaunchDownload.downloadJarFiles(jARDescArray, progressListener, bl, n);
    }

    public static void downloadEagerorAll(LaunchDesc launchDesc, boolean bl, ProgressListener progressListener, boolean bl2) throws IOException, JNLPException {
        Object object;
        JARDesc[] jARDescArray;
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc[] jARDescArray2 = resourcesDesc.getEagerOrAllJarDescs(bl);
        if (!bl && (jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true)).length != jARDescArray2.length) {
            object = new HashSet<JARDesc>(Arrays.asList(jARDescArray2));
            int n = 0;
            for (int j = 0; j < jARDescArray.length; ++j) {
                URL uRL = jARDescArray[j].getLocation();
                String string = jARDescArray[j].getVersion();
                if (!((HashSet)object).contains(jARDescArray[j]) && DownloadEngine.getCachedJarFile((URL)uRL, (String)string) != null) {
                    if (jARDescArray[j].isLazyDownload()) {
                        boolean bl3 = DownloadEngine.isUpdateAvailable((URL)uRL, (String)string, (boolean)jARDescArray[j].isPack200Enabled());
                        if (bl3) {
                            DownloadEngine.removeCachedResource((URL)uRL, null, (String)string);
                        }
                        jARDescArray[j] = null;
                        continue;
                    }
                    ++n;
                    continue;
                }
                jARDescArray[j] = null;
            }
            if (n > 0) {
                JARDesc[] jARDescArray3 = new JARDesc[jARDescArray2.length + n];
                System.arraycopy(jARDescArray2, 0, jARDescArray3, 0, jARDescArray2.length);
                int n2 = jARDescArray2.length;
                for (int j = 0; j < jARDescArray.length; ++j) {
                    if (jARDescArray[j] == null) continue;
                    jARDescArray3[n2++] = jARDescArray[j];
                }
                jARDescArray2 = jARDescArray3;
            }
        }
        int n = launchDesc.getResources().getConcurrentDownloads();
        Trace.println((String)("LaunchDownload: concurrent downloads from LD: " + n), (TraceLevel)TraceLevel.NETWORK);
        LaunchDownload.downloadJarFiles(jARDescArray2, progressListener, bl2, n);
        object = launchDesc.getInformation().getIconLocation(48, 0);
        if (object != null) {
            try {
                DownloadEngine.getResource((URL)((IconDesc)object).getLocation(), null, (String)((IconDesc)object).getVersion(), null, (boolean)true, (int)1);
                Trace.println((String)("Downloaded " + ((IconDesc)object).getLocation()), (TraceLevel)TraceLevel.NETWORK);
            }
            catch (Exception exception) {
                Trace.ignored((Throwable)exception);
            }
        }
    }

    public static void reverse(JARDesc[] jARDescArray) {
        int n = 0;
        for (int j = jARDescArray.length - 1; n < j; ++n, --j) {
            JARDesc jARDesc = jARDescArray[n];
            jARDescArray[n] = jARDescArray[j];
            jARDescArray[j] = jARDesc;
        }
    }

    private static void downloadJarFiles(JARDesc[] jARDescArray, ProgressListener progressListener, boolean bl) throws JNLPException, IOException {
        LaunchDownload.downloadJarFiles(jARDescArray, progressListener, bl, CONCURRENT_DOWNLOADS_DEF);
    }

    private static int getDownloadType(JARDesc jARDesc) {
        int n = 256;
        if (jARDesc.isNativeLib()) {
            n |= 0x10;
        }
        if (jARDesc.isPack200Enabled()) {
            n |= 0x1000;
        }
        if (jARDesc.isVersionEnabled()) {
            n |= 0x10000;
        }
        return n;
    }

    public static void downloadProgressJars(LaunchDesc launchDesc) throws IOException, JNLPException {
        ExecutorService executorService = null;
        List list = null;
        CustomProgress customProgress = Progress.getCustomProgress();
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            customProgress.markLoaded(null);
            return;
        }
        executorService = LaunchDownload.getThreadPool(2);
        if (executorService == null) {
            customProgress.markLoaded(null);
            return;
        }
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(false);
        ArrayList<DownloadTask> arrayList = new ArrayList<DownloadTask>(2);
        for (int j = 0; j < jARDescArray.length; ++j) {
            DownloadTask downloadTask;
            JARDesc jARDesc = jARDescArray[j];
            if (!jARDesc.isProgressJar() || arrayList.contains(downloadTask = new DownloadTask(jARDesc.getLocation(), null, jARDesc.getVersion(), null, true, LaunchDownload.getDownloadType(jARDesc), null, null, null))) continue;
            arrayList.add(downloadTask);
        }
        try {
            list = executorService.invokeAll(arrayList);
        }
        catch (InterruptedException interruptedException) {
            Trace.ignored((Throwable)interruptedException);
            executorService.shutdownNow();
        }
        executorService.shutdown();
        try {
            LaunchDownload.validateResults(list, null);
        }
        catch (Exception exception) {
            Trace.ignoredException((Exception)exception);
            if (customProgress != null) {
                customProgress.markLoaded(exception);
            }
            throw new RuntimeException(exception);
        }
        customProgress.markLoaded(null);
    }

    private static void downloadJarFiles(JARDesc[] jARDescArray, ProgressListener progressListener, boolean bl, int n) throws JNLPException, IOException {
        int n2;
        int n3;
        if (jARDescArray == null) {
            return;
        }
        DeployPerfUtil.put((String)"LaunchDownload.downloadJarFiles - begin");
        if (Globals.isReverseMode()) {
            LaunchDownload.reverse(jARDescArray);
        }
        long l = 0L;
        DownloadCallbackHelper downloadCallbackHelper = new DownloadCallbackHelper(progressListener);
        int n4 = 0;
        boolean bl2 = true;
        for (n3 = 0; n3 < jARDescArray.length; ++n3) {
            n2 = jARDescArray[n3].getSize();
            if (Progress.getCustomProgress() != null && jARDescArray[n3].isProgressJar()) continue;
            if (n2 > 0) {
                ++n4;
                l += (long)n2;
                continue;
            }
            bl2 = false;
        }
        n3 = 0;
        for (n2 = 0; n2 < jARDescArray.length; ++n2) {
            int n5 = jARDescArray[n2].getSize();
            if (Progress.getCustomProgress() != null && jARDescArray[n2].isProgressJar()) continue;
            if (n5 <= 0) {
                downloadCallbackHelper.register(jARDescArray[n2].getLocation().toString(), jARDescArray[n2].getVersion(), 0, 1.0);
            } else if (n5 > 0) {
                downloadCallbackHelper.register(jARDescArray[n2].getLocation().toString(), jARDescArray[n2].getVersion(), n5, 0.5 + (double)(n5 * n4) / (double)l);
            }
            ++n3;
        }
        if (!bl2) {
            l = -1L;
        }
        Trace.println((String)("Total size to download: " + l), (TraceLevel)TraceLevel.NETWORK);
        if (l == 0L) {
            return;
        }
        downloadCallbackHelper.setTotalSize(l);
        downloadCallbackHelper.setNumOfJars(jARDescArray.length);
        int[] nArray = new int[]{0};
        ExecutorService executorService = LaunchDownload.getThreadPool(n);
        if (executorService != null) {
            AppContext.getAppContext().put(APPCONTEXT_THREADPOOL_KEY, executorService);
            downloadCallbackHelper.setNumOfJars(n3);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(jARDescArray.length);
        for (int j = 0; j < jARDescArray.length; ++j) {
            JARDesc jARDesc = jARDescArray[j];
            try {
                Object object;
                int n6 = LaunchDownload.getDownloadType(jARDesc);
                if (executorService == null) {
                    object = DownloadEngine.getResource((URL)jARDesc.getLocation(), null, (String)jARDesc.getVersion(), (DownloadEngine.DownloadDelegate)downloadCallbackHelper, (boolean)true, (int)n6);
                    Trace.println((String)("Downloaded " + jARDesc.getLocation() + ": " + object), (TraceLevel)TraceLevel.NETWORK);
                    nArray[0] = nArray[0] + 1;
                    downloadCallbackHelper.setJarsDone(nArray[0]);
                    if (!Cache.isCacheEnabled() || object != null || Environment.isImportMode()) continue;
                    throw new FailedDownloadingResourceException(null, jARDesc.getLocation(), jARDesc.getVersion(), null);
                }
                if (Progress.getCustomProgress() != null && jARDesc.isProgressJar() || arrayList.contains(object = new DownloadTask(jARDesc.getLocation(), null, jARDesc.getVersion(), downloadCallbackHelper, true, n6, progressListener, nArray, downloadCallbackHelper))) continue;
                arrayList.add(object);
                continue;
            }
            catch (JNLPException jNLPException) {
                if (progressListener != null) {
                    progressListener.downloadFailed(jARDesc.getLocation(), jARDesc.getVersion());
                }
                throw jNLPException;
            }
        }
        List list = null;
        try {
            if (executorService != null) {
                list = executorService.invokeAll(arrayList);
            }
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
        }
        if (executorService != null) {
            AppContext.getAppContext().remove(APPCONTEXT_THREADPOOL_KEY);
            executorService.shutdown();
            LaunchDownload.validateResults(list, progressListener);
        }
        DeployPerfUtil.put((String)"LaunchDownload.downloadJarFiles - end");
    }

    private static void validateResults(List list, ProgressListener progressListener) throws IOException, JNLPException {
        if (list != null) {
            for (Future future : list) {
                try {
                    future.get();
                }
                catch (ExecutionException executionException) {
                    Throwable throwable = executionException.getCause();
                    if (null == throwable) continue;
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    if (throwable instanceof JNLPException) {
                        if (progressListener != null) {
                            progressListener.downloadFailed(null, null);
                        }
                        throw (JNLPException)throwable;
                    }
                    throw new IOException("JNLP Jar download failure.");
                }
                catch (InterruptedException interruptedException) {
                    Trace.ignored((Throwable)interruptedException);
                }
            }
        }
    }

    private static synchronized void notifyProgress(DownloadCallbackHelper downloadCallbackHelper, int[] nArray, URL uRL) {
        if (nArray != null && downloadCallbackHelper != null) {
            nArray[0] = nArray[0] + 1;
            Trace.println((String)("Download Progress: jarsDone: " + nArray[0]), (TraceLevel)TraceLevel.NETWORK);
            downloadCallbackHelper.jarDone(uRL);
            downloadCallbackHelper.setJarsDone(nArray[0]);
        }
    }

    private static ExecutorService getThreadPool(int n) {
        if (Config.isJavaVersionAtLeast15()) {
            ExecutorService executorService = Executors.newFixedThreadPool(n, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable);
                    thread.setDaemon(true);
                    return thread;
                }
            });
            return executorService;
        }
        return null;
    }

    public static void checkJNLPSecurity(LaunchDesc launchDesc) throws MultipleHostsException, NativeLibViolationException {
        boolean[] blArray = new boolean[1];
        boolean[] blArray2 = new boolean[1];
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc jARDesc = launchDesc.getResources().getMainJar(true);
        if (jARDesc == null) {
            return;
        }
        LaunchDownload.checkJNLPSecurityHelper(launchDesc, jARDesc.getLocation().getHost(), blArray2, blArray);
        if (blArray2[0]) {
            throw new MultipleHostsException();
        }
        if (blArray[0]) {
            throw new NativeLibViolationException();
        }
    }

    private static void checkJNLPSecurityHelper(LaunchDesc launchDesc, final String string, final boolean[] blArray, final boolean[] blArray2) {
        if (launchDesc.getSecurityModel() != 0) {
            return;
        }
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        resourcesDesc.visit(new ResourceVisitor(){

            @Override
            public void visitJARDesc(JARDesc jARDesc) {
                String string2 = jARDesc.getLocation().getHost();
                blArray[0] = blArray[0] || !string.equals(string2);
                blArray2[0] = blArray2[0] || jARDesc.isNativeLib();
            }

            @Override
            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                if (!blArray[0] && !blArray2[0]) {
                    LaunchDesc launchDesc = extensionDesc.getExtensionDesc();
                    String string2 = extensionDesc.getLocation().getHost();
                    if (launchDesc != null && launchDesc.getSecurityModel() == 0 && !blArray[0]) {
                        LaunchDownload.checkJNLPSecurityHelper(launchDesc, string2, blArray, blArray2);
                    }
                }
            }

            @Override
            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }

            @Override
            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            @Override
            public void visitJREDesc(JREDesc jREDesc) {
            }
        });
    }

    public static long getCachedSize(LaunchDesc launchDesc) {
        long l = 0L;
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return l;
        }
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        for (int j = 0; j < jARDescArray.length; ++j) {
            try {
                l += DownloadEngine.getCachedSize((URL)jARDescArray[j].getLocation(), null, (String)jARDescArray[j].getVersion(), null, (boolean)false);
                continue;
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        IconDesc[] iconDescArray = launchDesc.getInformation().getIcons();
        if (iconDescArray != null) {
            for (int j = 0; j < iconDescArray.length; ++j) {
                try {
                    l += DownloadEngine.getCachedSize((URL)iconDescArray[j].getLocation(), null, (String)iconDescArray[j].getVersion(), null, (boolean)false);
                    continue;
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getMainClassName(LaunchDesc launchDesc, boolean bl) throws IOException, JNLPException, LaunchDescException {
        AppletDesc appletDesc;
        InstallerDesc installerDesc;
        String string = null;
        ApplicationDesc applicationDesc = launchDesc.getApplicationDescriptor();
        if (applicationDesc != null) {
            string = applicationDesc.getMainClass();
        }
        if ((installerDesc = launchDesc.getInstallerDescriptor()) != null) {
            string = installerDesc.getMainClass();
        }
        if ((appletDesc = launchDesc.getAppletDescriptor()) != null) {
            string = appletDesc.getAppletClass();
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string != null) {
            return string;
        }
        if (launchDesc.getResources() == null) {
            return null;
        }
        JARDesc jARDesc = launchDesc.getResources().getMainJar(bl);
        if (jARDesc == null) {
            return null;
        }
        ZipFile zipFile = null;
        try {
            Object object;
            zipFile = new JarFile(DownloadEngine.getCachedResourceFilePath((URL)jARDesc.getLocation(), (String)jARDesc.getVersion()), false);
            if (zipFile != null && string == null && launchDesc.getLaunchType() != 2) {
                object = ((JarFile)zipFile).getManifest();
                String string2 = string = object != null ? ((Manifest)object).getMainAttributes().getValue("Main-Class") : null;
            }
            if (string == null) {
                throw new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.nomainclassspec"), null);
            }
            object = string.replace('.', '/') + ".class";
            if (((JarFile)zipFile).getEntry((String)object) == null) {
                throw new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.nomainclass", (String)string, (String)jARDesc.getLocation().toString()), null);
            }
            String string3 = string;
            return string3;
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    public static void checkSignedLaunchDesc(LaunchDesc launchDesc) throws IOException, JNLPException {
        ArrayList arrayList = new ArrayList();
        LaunchDownload.addExtensions(arrayList, launchDesc);
        for (int j = 0; j < arrayList.size(); ++j) {
            LaunchDesc launchDesc2 = (LaunchDesc)arrayList.get(j);
            LaunchDownload.checkSignedLaunchDescHelper(launchDesc2);
        }
    }

    public static boolean checkSignedResources(LaunchDesc launchDesc) throws IOException, JNLPException, ExitException {
        ArrayList arrayList = new ArrayList();
        LaunchDownload.addExtensions(arrayList, launchDesc);
        boolean bl = true;
        for (int j = 0; j < arrayList.size(); ++j) {
            LaunchDesc launchDesc2 = (LaunchDesc)arrayList.get(j);
            bl = LaunchDownload.checkSignedResourcesHelper(launchDesc2) && bl;
        }
        return bl;
    }

    private static void addExtensions(final ArrayList arrayList, LaunchDesc launchDesc) {
        arrayList.add(launchDesc);
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc != null) {
            resourcesDesc.visit(new ResourceVisitor(){

                @Override
                public void visitJARDesc(JARDesc jARDesc) {
                }

                @Override
                public void visitPropertyDesc(PropertyDesc propertyDesc) {
                }

                @Override
                public void visitPackageDesc(PackageDesc packageDesc) {
                }

                @Override
                public void visitJREDesc(JREDesc jREDesc) {
                }

                @Override
                public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                    if (!extensionDesc.isInstaller()) {
                        LaunchDownload.addExtensions(arrayList, extensionDesc.getExtensionDesc());
                    }
                }
            });
        }
    }

    private static void checkSignedLaunchDescHelper(LaunchDesc launchDesc) throws IOException, JNLPException {
        boolean bl = launchDesc.isApplicationDescriptor();
        byte[] byArray = null;
        try {
            byArray = LaunchDownload.getSignedJNLPFile(launchDesc, bl);
            if (byArray != null) {
                LaunchDesc launchDesc2 = LaunchDescFactory.buildDescriptor(byArray, null, launchDesc.getLocation(), launchDesc.getLocation());
                if (Trace.isTraceLevelEnabled((TraceLevel)TraceLevel.BASIC)) {
                    Trace.println((String)"Signed JNLP file: ", (TraceLevel)TraceLevel.BASIC);
                    Trace.println((String)launchDesc2.toString(), (TraceLevel)TraceLevel.BASIC);
                }
                launchDesc.checkSigning(launchDesc2);
                byArray = null;
            }
        }
        catch (LaunchDescException launchDescException) {
            launchDescException.setIsSignedLaunchDesc();
            throw launchDescException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (JNLPException jNLPException) {
            throw jNLPException;
        }
    }

    private static boolean checkSignedResourcesHelper(LaunchDesc launchDesc) throws IOException, JNLPException, ExitException {
        Object object;
        JARDesc jARDesc;
        int n;
        boolean bl;
        Object object2;
        if (launchDesc.isSecure()) {
            return launchDesc.isSecureJVMArgs();
        }
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return true;
        }
        JARDesc[] jARDescArray = resourcesDesc.getLocalJarDescs();
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = true;
        List list = null;
        URL uRL = launchDesc.getCanonicalHome();
        int n2 = 0;
        URL uRL2 = null;
        SigningInfo signingInfo = null;
        Map map = null;
        Trace.println((String)("Validating signatures for " + launchDesc.getLocation() + " " + launchDesc.getSourceURL()), (TraceLevel)TraceLevel.SECURITY);
        if (launchDesc.getLocation() != null) {
            object2 = launchDesc.getSourceURL();
            if (object2 == null) {
                object2 = launchDesc.getLocation();
            }
            signingInfo = new SigningInfo((URL)object2, launchDesc.getVersion());
            map = signingInfo.getTrustedEntries();
            Trace.println((String)("TustedSet " + (map != null ? Integer.toString(map.size()) : "null")), (TraceLevel)TraceLevel.SECURITY);
        }
        object2 = new SigningInfo[jARDescArray.length];
        HashMap<Object, Long> hashMap = new HashMap<Object, Long>();
        boolean bl5 = false;
        if (map == null) {
            bl = false;
            Trace.println((String)("Empty trusted set for [" + uRL + "]"), (TraceLevel)TraceLevel.SECURITY);
        } else {
            bl = true;
        }
        for (n = 0; !bl5 && n < jARDescArray.length; ++n) {
            jARDesc = jARDescArray[n];
            object2[n] = new SigningInfo(jARDesc.getLocation(), jARDesc.getVersion());
            Trace.println((String)("Round 1 (" + n + " out of " + jARDescArray.length + "):" + jARDesc.getLocation()), (TraceLevel)TraceLevel.SECURITY);
            if (object2[n].isFileKnownToBeNotCached()) {
                Trace.println((String)("    Skip: " + jARDesc.getLocation()), (TraceLevel)TraceLevel.SECURITY);
                bl3 = true;
                continue;
            }
            if (object2[n].isKnownToBeValidated()) {
                long l = object2[n].getCachedVerificationTimestampt();
                String string = jARDesc.getLocation().toString();
                if (!object2[n].isKnownToBeSigned()) {
                    bl5 = true;
                    bl = false;
                    continue;
                }
                if (bl && ((object = (Long)map.get(string)) == null || (Long)object != l)) {
                    Trace.println((String)("Entry [" + string + ", " + object + "] does not match trusted set. Revert to full validation of JNLP."), (TraceLevel)TraceLevel.SECURITY);
                    bl = false;
                }
                hashMap.put(string, new Long(l));
                continue;
            }
            bl5 = true;
            bl = false;
            Trace.println((String)("Entry [" + jARDesc.getLocation().toString() + "] is not prevalidated. Revert to full validation of this JAR."), (TraceLevel)TraceLevel.SECURITY);
        }
        if (!bl) {
            long l;
            for (n = 0; n < jARDescArray.length && bl4; ++n) {
                jARDesc = jARDescArray[n];
                Trace.println((String)("Round 2 (" + n + " out of " + jARDescArray.length + "):" + jARDesc.getLocation()), (TraceLevel)TraceLevel.SECURITY);
                if (object2[n] == null) {
                    object2[n] = new SigningInfo(jARDesc.getLocation(), jARDesc.getVersion());
                }
                if (object2[n].isFileKnownToBeNotCached()) {
                    Trace.println((String)("    Skip " + jARDesc.getLocation()), (TraceLevel)TraceLevel.SECURITY);
                    bl3 = true;
                    continue;
                }
                List list2 = null;
                list2 = object2[n].isKnownToBeValidated() ? object2[n].getCertificates() : object2[n].check();
                if (object2[n].isJarKnownToBeEmpty()) continue;
                if (list2 == null) {
                    bl2 = false;
                    uRL2 = jARDesc.getLocation();
                    if (launchDesc.getSecurityModel() == 0) break;
                    DownloadEngine.removeCachedResource((URL)jARDesc.getLocation(), null, (String)jARDesc.getVersion());
                    break;
                }
                if (list == null) {
                    list = list2;
                } else {
                    list = SigningInfo.overlapChainLists(list2, list);
                    Trace.println((String)("Have " + (list == null ? 0 : list.size()) + " common certificates after processing " + jARDesc.getLocation()), (TraceLevel)TraceLevel.SECURITY);
                    if (list == null) {
                        bl4 = false;
                        if (launchDesc.getSecurityModel() != 0) {
                            DownloadEngine.removeCachedResource((URL)jARDesc.getLocation(), null, (String)jARDesc.getVersion());
                        }
                    }
                }
                l = object2[n].getCachedVerificationTimestampt();
                object = jARDesc.getLocation().toString();
                hashMap.put(object, new Long(l));
                ++n2;
            }
            if (!launchDesc.isSecure()) {
                if (!bl2) {
                    throw new UnsignedAccessViolationException(launchDesc, uRL2, true);
                }
                if (!bl4) {
                    throw new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.singlecertviolation"), null);
                }
                if (n2 > 0) {
                    long l2;
                    CodeSource codeSource = null;
                    codeSource = Globals.isJavaVersionAtLeast15() ? new CodeSource(launchDesc.getLocation(), list.toArray(new CodeSigner[0])) : new CodeSource(launchDesc.getLocation(), SigningInfo.toCertificateArray(list));
                    if (bl) {
                        launchDesc.setTrusted();
                    }
                    if ((l2 = AppPolicy.getInstance().grantUnrestrictedAccess(launchDesc, codeSource)) > 0L) {
                        l = System.currentTimeMillis();
                        for (int j = 0; j < ((SigningInfo[])object2).length; ++j) {
                            object2[j].updateCacheIfNeeded(true, null, l, l2);
                            String string = jARDescArray[j].getLocation().toString();
                            if (!hashMap.containsKey(string)) continue;
                            hashMap.put(string, new Long(object2[j].getCachedVerificationTimestampt()));
                        }
                        if (signingInfo != null) {
                            signingInfo.updateCache(true, hashMap, System.currentTimeMillis(), l2);
                        }
                    }
                    bl = true;
                } else {
                    if (signingInfo != null) {
                        signingInfo.updateCache(true, hashMap, System.currentTimeMillis(), Long.MAX_VALUE);
                    }
                    bl = true;
                }
            }
        }
        if (bl && !bl3) {
            launchDesc.setTrusted();
        }
        Trace.println((String)("LD - All JAR files signed: " + uRL), (TraceLevel)TraceLevel.BASIC);
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getSignedJNLPFile(LaunchDesc launchDesc, boolean bl) throws IOException, JNLPException {
        if (launchDesc.getResources() == null) {
            return null;
        }
        JARDesc jARDesc = launchDesc.getResources().getMainJar(bl);
        if (jARDesc == null) {
            return null;
        }
        ZipFile zipFile = null;
        try {
            Object object;
            Object object2;
            zipFile = new JarFile(DownloadEngine.getCachedResourceFilePath((URL)jARDesc.getLocation(), (String)jARDesc.getVersion()), false);
            Object object3 = ((JarFile)zipFile).getJarEntry(SIGNED_JNLP_ENTRY);
            if (object3 == null) {
                object2 = ((JarFile)zipFile).entries();
                while (object2.hasMoreElements() && object3 == null) {
                    object = (JarEntry)object2.nextElement();
                    if (!((ZipEntry)object).getName().equalsIgnoreCase(SIGNED_JNLP_ENTRY)) continue;
                    object3 = object;
                }
            }
            if (object3 == null) {
                object2 = null;
                return object2;
            }
            object2 = new byte[(int)((ZipEntry)object3).getSize()];
            object = new DataInputStream(((JarFile)zipFile).getInputStream((ZipEntry)object3));
            ((DataInputStream)object).readFully((byte[])object2, 0, (int)((ZipEntry)object3).getSize());
            ((FilterInputStream)object).close();
            Object object4 = object2;
            return object4;
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    private static class DownloadTask
    implements Callable {
        private URL url;
        private int downloadType;
        private String resourceID;
        private String versionString;
        private DownloadEngine.DownloadDelegate dd;
        private boolean doDownload;
        private ProgressListener dp;
        private int[] counterBox;
        private DownloadCallbackHelper dch;

        public DownloadTask(URL uRL, String string, String string2, DownloadEngine.DownloadDelegate downloadDelegate, boolean bl, int n, ProgressListener progressListener, int[] nArray, DownloadCallbackHelper downloadCallbackHelper) {
            this.url = uRL;
            this.downloadType = n;
            this.resourceID = string;
            this.versionString = string2;
            this.dd = downloadDelegate;
            this.doDownload = bl;
            this.dp = progressListener;
            this.counterBox = nArray;
            this.dch = downloadCallbackHelper;
        }

        public URL getURL() {
            return this.url;
        }

        public String getVersion() {
            return this.versionString;
        }

        public int hashCode() {
            if (this.url == null) {
                return 0;
            }
            return this.url.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof DownloadTask) {
                DownloadTask downloadTask = (DownloadTask)object;
                URL uRL = downloadTask.getURL();
                String string = downloadTask.getVersion();
                if (this.url.toString().equals(uRL.toString())) {
                    if (this.versionString == null && string == null) {
                        return true;
                    }
                    if (this.versionString != null && string != null & this.versionString.equals(string)) {
                        return true;
                    }
                }
            }
            return false;
        }

        public Object call() throws IOException, JNLPException {
            URL uRL = DownloadEngine.getResource((URL)this.url, (String)this.resourceID, (String)this.versionString, (DownloadEngine.DownloadDelegate)this.dd, (boolean)this.doDownload, (int)this.downloadType);
            Trace.println((String)("Downloaded " + this.url + ": " + uRL), (TraceLevel)TraceLevel.NETWORK);
            if (Cache.isCacheEnabled() && uRL == null && !Environment.isImportMode()) {
                throw new FailedDownloadingResourceException(null, this.url, this.versionString, null);
            }
            LaunchDownload.notifyProgress(this.dch, this.counterBox, this.url);
            return null;
        }
    }

    private static class DownloadCallbackHelper
    implements DownloadEngine.DownloadDelegate {
        ProgressListener _progressListener;
        long _totalSize = -1L;
        final ArrayList _records;
        int _numOfJars = 1;
        int _jarsDone = 0;

        public DownloadCallbackHelper(ProgressListener progressListener) {
            this._progressListener = progressListener;
            this._records = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(String string, String string2, int n, double d) {
            ProgressRecord progressRecord = this.getProgressRecord(string);
            if (progressRecord == null) {
                progressRecord = new ProgressRecord(string, string2, n);
                progressRecord.setWeight(d);
                ArrayList arrayList = this._records;
                synchronized (arrayList) {
                    this._records.add(progressRecord);
                }
            } else {
                progressRecord.setWeight(d);
                progressRecord.setSize(n);
            }
        }

        public void setTotalSize(long l) {
            this._totalSize = l;
        }

        public void setNumOfJars(int n) {
            this._numOfJars = n;
        }

        public void setJarsDone(int n) {
            this._jarsDone = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void downloading(URL uRL, String string, int n, int n2, boolean bl) {
            if (this._progressListener != null) {
                String string2 = uRL.toString();
                ProgressRecord progressRecord = this.getProgressRecord(string2);
                if (progressRecord == null) {
                    progressRecord = new ProgressRecord(string2, string, n2);
                    ArrayList arrayList = this._records;
                    synchronized (arrayList) {
                        this._records.add(progressRecord);
                    }
                } else {
                    progressRecord.setSize(n2);
                }
                progressRecord.downloadProgress(n);
                int n3 = this.getOverallPercent();
                this._progressListener.progress(uRL, string, n, this._totalSize, n3);
            }
        }

        public void patching(URL uRL, String string, int n) {
            String string2;
            ProgressRecord progressRecord;
            if (this._progressListener != null && (progressRecord = this.getProgressRecord(string2 = uRL.toString())) != null) {
                progressRecord.patchProgress(n);
                int n2 = this.getOverallPercent();
                this._progressListener.upgradingArchive(uRL, string, n, n2);
            }
        }

        public void validating(URL uRL, int n, int n2) {
            String string;
            ProgressRecord progressRecord;
            if (this._progressListener != null && (progressRecord = this.getProgressRecord(string = uRL.toString())) != null) {
                progressRecord.validateProgress(n, n2);
                int n3 = this.getOverallPercent();
                this._progressListener.validating(uRL, null, n, n2, n3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ProgressRecord getProgressRecord(String string) {
            ArrayList arrayList = this._records;
            synchronized (arrayList) {
                for (ProgressRecord progressRecord : this._records) {
                    if (string == null || !string.equals(progressRecord.getUrl())) continue;
                    return progressRecord;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getOverallPercent() {
            double d = 0.0;
            double d2 = 0.0;
            ArrayList arrayList = this._records;
            synchronized (arrayList) {
                for (ProgressRecord progressRecord : this._records) {
                    d += progressRecord.getPercent() * progressRecord.getWeight();
                    d2 += progressRecord.getWeight();
                }
            }
            int n = (int)(d * 100.0 / d2);
            if (n > 100) {
                n = 100;
            }
            return n;
        }

        public void downloadFailed(URL uRL, String string) {
            if (this._progressListener != null) {
                this._progressListener.downloadFailed(uRL, string);
            }
        }

        void jarDone(URL uRL) {
            String string;
            ProgressRecord progressRecord;
            if (this._progressListener != null && (progressRecord = this.getProgressRecord(string = uRL.toString())) != null && progressRecord.getPercent() < 1.0) {
                progressRecord.markComplete();
                int n = this.getOverallPercent();
            }
        }
    }

    private static class ProgressRecord {
        private String _url;
        private String _ver;
        private int _size;
        private double _percent;
        private double _weight;

        public ProgressRecord(String string, String string2, int n) {
            this._url = string;
            this._ver = string2;
            this._size = n;
            this._weight = 1.0;
            this._percent = 0.0;
        }

        public void setWeight(double d) {
            this._weight = d;
        }

        public void setSize(int n) {
            this._size = n;
        }

        public double getPercent() {
            return this._percent;
        }

        public String getUrl() {
            return this._url;
        }

        public int hashCode() {
            int n = 7;
            n = 79 * n + (this._url != null ? this._url.hashCode() : 0);
            return n;
        }

        public boolean equals(Object object) {
            return this._url.equals(((ProgressRecord)object)._url);
        }

        public double getWeight() {
            return this._weight;
        }

        public void downloadProgress(int n) {
            this._percent = (double)n / (double)this._size * 0.8;
        }

        public void patchProgress(int n) {
            this._percent = (double)n / 100.0 * 0.1 + 0.8;
        }

        public void validateProgress(int n, int n2) {
            this._percent = (double)n / (double)n2 * 0.05 + 0.9;
        }

        private void markComplete() {
            this._percent = 1.0;
        }
    }
}

