/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.apple.eio.FileManager;
import com.sun.deploy.association.Association;
import com.sun.deploy.association.AssociationAlreadyRegisteredException;
import com.sun.deploy.association.AssociationNotRegisteredException;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.cache.AssociationDesc;
import com.sun.deploy.cache.LocalApplicationProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.MacOSXConfig;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.Globals;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchSelection;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import sun.security.action.GetPropertyAction;

public class MacOSLocalInstallHandler
extends LocalInstallHandler {
    private static final String INSTALLED_APPLICATION_KEY = "macos.installedApplication";

    private static native int CreateJNLPApplicationPackage(String var0, String var1, String var2, String var3, boolean var4, String var5, String var6, String var7, Object[] var8, Object[] var9, Object[] var10, Object[] var11, String var12, long var13, long var15, String[] var17);

    static native String ConvertImageToICNSFile(String var0, String var1);

    private static native String GetDownloadLocationDirectory(boolean var0);

    @Override
    public boolean isLocalInstallSupported() {
        return true;
    }

    @Override
    public boolean isAssociationSupported() {
        return false;
    }

    @Override
    boolean isAssociationFileExtSupported(String string) {
        return true;
    }

    public void associationCompleted() {
    }

    @Override
    public String getAssociationOpenCommand(String string) {
        return "open " + string;
    }

    @Override
    public String getAssociationPrintCommand(String string) {
        return "";
    }

    @Override
    public boolean hasAssociation(Association association) {
        return false;
    }

    @Override
    public void registerAssociationInternal(Association association) throws AssociationAlreadyRegisteredException, RegisterFailedException {
    }

    @Override
    public void unregisterAssociationInternal(Association association) throws AssociationNotRegisteredException, RegisterFailedException {
    }

    @Override
    public String getDefaultIconPath() {
        return "/System/Library/CoreServices/CoreTypes.bundle/Contents/Resources/GenericDocumentIcon.icns";
    }

    @Override
    public boolean isShortcutExists(LocalApplicationProperties localApplicationProperties) {
        boolean bl = false;
        String string = localApplicationProperties.get(INSTALLED_APPLICATION_KEY);
        if (string != null) {
            File file = new File(string);
            Trace.println((String)("Looking for " + string), (TraceLevel)TraceLevel.BASIC);
            if (file.exists() && file.isDirectory()) {
                bl = true;
                Trace.println((String)"Yes, it exists.", (TraceLevel)TraceLevel.BASIC);
            }
        }
        return bl;
    }

    @Override
    public boolean[] whichShortcutsExist(LocalApplicationProperties localApplicationProperties) {
        return new boolean[]{this.isShortcutExists(localApplicationProperties), false};
    }

    private boolean removeDirectory(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int j = 0; j < stringArray.length; ++j) {
                boolean bl = this.removeDirectory(new File(file, stringArray[j]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    private File makeUniqueAppName(File file) {
        int n = 2;
        if (file == null) {
            return null;
        }
        String string = file.getAbsolutePath();
        if (string == null || string.length() < 3) {
            return file;
        }
        int n2 = string.lastIndexOf(".app");
        if (n2 == -1) {
            return file;
        }
        File file2 = file;
        while (file2.exists()) {
            file2 = new File(string.substring(0, n2) + " " + n + ".app");
            ++n;
        }
        return file2;
    }

    private File attemptToRenameOldApp(File file) {
        if (file == null) {
            return null;
        }
        String string = file.getAbsolutePath();
        if (string == null || string.length() < 3) {
            return null;
        }
        int n = string.lastIndexOf(".app");
        if (n == -1) {
            return null;
        }
        File file2 = new File(string.substring(0, n) + " (old)" + ".app");
        if (file.renameTo(file2 = this.makeUniqueAppName(file2))) {
            return file2;
        }
        return null;
    }

    @Override
    protected boolean createShortcuts(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean[] blArray) {
        Object object;
        File file;
        try {
            file = DownloadEngine.getCachedFile((URL)launchDesc.getCanonicalHome());
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
            this.installFailed(launchDesc);
            return false;
        }
        InformationDesc informationDesc = launchDesc.getInformation();
        String string = informationDesc.getTitle();
        ShortcutDesc shortcutDesc = informationDesc.getShortcut();
        boolean bl = !informationDesc.supportsOfflineOperation() || shortcutDesc == null || shortcutDesc.getOnline();
        boolean bl2 = shortcutDesc == null ? false : shortcutDesc.getDesktop();
        Object object2 = MacOSLocalInstallHandler.getSavedFile(localApplicationProperties, string, bl2);
        if (object2 == null) {
            return false;
        }
        if (((File)object2).exists()) {
            boolean bl3 = false;
            if (Config.isJavaVersionAtLeast15()) {
                try {
                    bl3 = FileManager.moveToTrash((File)object2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Trace.ignoredException((Exception)fileNotFoundException);
                }
            } else {
                object = this.attemptToRenameOldApp((File)object2);
                if (object != null) {
                    bl3 = true;
                    this.removeDirectory((File)object);
                }
            }
            if (!bl3) {
                object = this.makeUniqueAppName((File)object2);
                this.failedToReplaceOldShortcut(((File)object2).getName(), ((File)object).getName());
                object2 = object;
                Trace.println((String)("Error removing old shortcut, renaming to " + object2), (TraceLevel)TraceLevel.DEFAULT);
            }
        }
        try {
            String string2;
            object = informationDesc.getIconLocation(512, 0);
            String string3 = object == null ? null : ((IconDesc)object).getLocation().toExternalForm();
            AssociationDesc[] associationDescArray = informationDesc.getAssociations();
            StringBuffer stringBuffer = new StringBuffer(30);
            StringBuffer stringBuffer2 = new StringBuffer(30);
            ArrayList arrayList = new ArrayList(30);
            ArrayList arrayList2 = new ArrayList(10);
            MacOSLocalInstallHandler.buildAssociationLists(associationDescArray, stringBuffer, stringBuffer2, arrayList, arrayList2);
            String string4 = stringBuffer.toString();
            if (string4.length() == 0) {
                string4 = null;
            }
            if ((string2 = stringBuffer2.toString()).length() == 0) {
                string2 = null;
            }
            Object[] objectArray = arrayList.toArray();
            Object[] objectArray2 = arrayList2.toArray();
            ResourcesDesc resourcesDesc = launchDesc.getResources();
            Properties properties = resourcesDesc.getResourceProperties();
            ArrayList arrayList3 = new ArrayList(10);
            ArrayList arrayList4 = new ArrayList(10);
            MacOSLocalInstallHandler.buildPropertyNameAndValuesLists(properties, arrayList3, arrayList4);
            Object[] objectArray3 = arrayList3.toArray();
            Object[] objectArray4 = arrayList4.toArray();
            JREInfo jREInfo = LaunchSelection.selectJRE(launchDesc, launchDesc.getJREMatcher());
            String string5 = resourcesDesc.getSelectedJRE().getVmArgs();
            String string6 = MacOSLocalInstallHandler.createSafeVMOptionsWithoutArchModifier(string5);
            long l = resourcesDesc.getSelectedJRE().getMinHeap();
            long l2 = resourcesDesc.getSelectedJRE().getMaxHeap();
            String string7 = resourcesDesc.getSelectedJRE().getVersion();
            String[] stringArray = null;
            if (string5 != null) {
                if (string5.indexOf("-d32") != -1) {
                    stringArray = new String[]{"i386", "x86_64", "ppc", "ppc64"};
                } else if (string5.indexOf("-d64") != -1) {
                    stringArray = new String[]{"x86_64", "i386", "ppc64", "ppc"};
                }
            }
            if (stringArray == null) {
                String string8 = AccessController.doPrivileged(new GetPropertyAction("os.arch"));
                if (string8.equals("i386") || string8.equals("ppc")) {
                    stringArray = new String[]{"i386", "x86_64", "ppc", "ppc64"};
                } else if (string8.equals("x86_64")) {
                    stringArray = new String[]{"x86_64", "i386", "ppc64", "ppc"};
                }
            }
            MacOSLocalInstallHandler.CreateJNLPApplicationPackage(launchDesc.getCanonicalHome(), file, (File)object2, string7, bl, string3, string4, string2, objectArray, objectArray2, objectArray3, objectArray4, string6, l, l2, stringArray);
            localApplicationProperties.put(INSTALLED_APPLICATION_KEY, ((File)object2).getCanonicalPath());
            localApplicationProperties.setLocallyInstalled(true);
            MacOSLocalInstallHandler.save(localApplicationProperties);
            return true;
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
            this.installFailed(launchDesc);
            return false;
        }
    }

    private static File getSavedFile(LocalApplicationProperties localApplicationProperties, String string, boolean bl) {
        if (localApplicationProperties.get(INSTALLED_APPLICATION_KEY) != null) {
            String string2 = localApplicationProperties.get(INSTALLED_APPLICATION_KEY);
            return new File(string2);
        }
        String string3 = MacOSLocalInstallHandler.GetDownloadLocationDirectory(bl);
        if (string3 == null) {
            string3 = System.getProperty("user.home");
        }
        if (Globals.isSilentMode()) {
            string3 = string3 + File.separator + string + ".app";
            return new File(string3);
        }
        Frame frame = new Frame();
        String string4 = ResourceManager.getString((String)"jnlp.localInstall.saveAs", (String)string);
        FileDialog fileDialog = new FileDialog(frame, string4, 1);
        fileDialog.setFile(string + ".app");
        fileDialog.setDirectory(string3);
        fileDialog.show();
        frame.dispose();
        if (fileDialog.getFile() == null) {
            return null;
        }
        String string5 = fileDialog.getFile();
        if (!string5.endsWith(".app")) {
            string5 = string5 + ".app";
        }
        return new File(fileDialog.getDirectory() + File.separator + string5);
    }

    private static void buildAssociationLists(AssociationDesc[] associationDescArray, StringBuffer stringBuffer, StringBuffer stringBuffer2, ArrayList arrayList, ArrayList arrayList2) throws IOException {
        if (associationDescArray == null || associationDescArray.length <= 0) {
            return;
        }
        for (int j = 0; j < associationDescArray.length; ++j) {
            if (j != 0) {
                stringBuffer.append("@");
                stringBuffer2.append("@");
            }
            stringBuffer.append(associationDescArray[j].getMimeType());
            stringBuffer2.append(associationDescArray[j].getExtensions());
            arrayList.add(associationDescArray[j].getMimeDescription());
            URL uRL = associationDescArray[j].getIconUrl();
            String string = "";
            if (uRL != null) {
                File file = DownloadEngine.getCachedShortcutImage((URL)uRL, null);
                try {
                    if (file == null) {
                        file = DownloadEngine.getUpdatedShortcutImage((URL)uRL, null);
                    }
                    String string2 = file.getCanonicalPath();
                    string = MacOSLocalInstallHandler.ConvertImageToICNSFile(string2, uRL.getFile());
                }
                catch (IOException iOException) {
                    Trace.println((String)("exception downloading icon file: " + iOException), (TraceLevel)TraceLevel.BASIC);
                }
            }
            arrayList2.add(string);
        }
    }

    private static void buildPropertyNameAndValuesLists(Properties properties, ArrayList arrayList, ArrayList arrayList2) {
        if (properties == null) {
            return;
        }
        Enumeration<Object> enumeration = properties.keys();
        String[] stringArray = Config.getSecureProperties();
        ArrayList<String> arrayList3 = new ArrayList<String>(stringArray.length);
        for (int j = 0; j < stringArray.length; ++j) {
            arrayList3.add(stringArray[j]);
        }
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!arrayList3.contains(string) && !string.startsWith("apple.laf") && !string.startsWith("apple.awt")) continue;
            arrayList.add(string);
            arrayList2.add(properties.get(string));
        }
    }

    private static String createSafeVMOptionsWithoutArchModifier(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f\"");
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (!Config.isSecureVmArg((String)string3) || "-d32".equals(string3) || "-d64".equals(string3)) continue;
            if (string2.length() == 0) {
                string2 = string3;
                continue;
            }
            string2 = string2 + " " + string3;
        }
        return string2;
    }

    @Override
    protected boolean removeShortcuts(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl) {
        Trace.println((String)"removeShortcuts called in MacOSInstallHandler", (TraceLevel)TraceLevel.BASIC);
        String string = localApplicationProperties.get(INSTALLED_APPLICATION_KEY);
        if (string != null) {
            File file = new File(string);
            this.deleteFiles(file);
            if (!localApplicationProperties.getBoolean("updating.shortcut")) {
                localApplicationProperties.put(INSTALLED_APPLICATION_KEY, null);
            }
        }
        localApplicationProperties.setLocallyInstalled(false);
        MacOSLocalInstallHandler.save(localApplicationProperties);
        return true;
    }

    @Override
    protected boolean removePathShortcut(String string) {
        File file = new File(string);
        this.deleteFiles(file);
        return true;
    }

    @Override
    protected void registerWithInstallPanel(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
    }

    @Override
    protected void removeFromInstallPanel(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
    }

    private void installFailed(final LaunchDesc launchDesc) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, ResourceManager.getString((String)"install.installFailed", (String)launchDesc.getInformation().getTitle()), ResourceManager.getString((String)"install.installFailedTitle"), 2);
            }
        };
        MacOSLocalInstallHandler.invokeRunnable(runnable);
    }

    private void failedToReplaceOldShortcut(final String string, final String string2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, ResourceManager.getString((String)"install.replaceShortcutFailed", (String)string, (String)string2), ResourceManager.getString((String)"install.replaceShortcutFailedTitle"), 2);
            }
        };
        MacOSLocalInstallHandler.invokeRunnable(runnable);
    }

    private void deleteFiles(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int j = 0; j < fileArray.length; ++j) {
                this.deleteFiles(fileArray[j]);
            }
        }
        file.delete();
    }

    private static void CreateJNLPApplicationPackage(URL uRL, File file, File file2, String string, boolean bl, String string2, String string3, String string4, Object[] objectArray, Object[] objectArray2, Object[] objectArray3, Object[] objectArray4, String string5, long l, long l2, String[] stringArray) throws IOException {
        int n = MacOSLocalInstallHandler.CreateJNLPApplicationPackage(uRL.toString(), file.getCanonicalPath(), file2.getCanonicalPath(), string, bl, string2, string3, string4, objectArray, objectArray2, objectArray3, objectArray4, string5, l, l2, stringArray);
        if (n != 0) {
            Trace.println((String)("JNLP application creation failed with error = " + n), (TraceLevel)TraceLevel.BASIC);
            throw new IOException("could not create JNLP application, error = " + n);
        }
    }

    static {
        MacOSXConfig.loadNativeLibrary((String)"macjavaws");
    }
}

