/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.VersionString;
import com.sun.javaws.jnl.DefaultMatchJRE;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.LaunchSelectionMacOSX;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;

public class LaunchSelection {
    private static final String anyJREVersion = "0+";

    public static MatchJREIf createDefaultMatchJRE() {
        return new DefaultMatchJRE();
    }

    public static JREInfo selectJRE(LaunchDesc launchDesc, MatchJREIf matchJREIf) {
        matchJREIf.beginTraversal(launchDesc);
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc != null) {
            LaunchSelection.selectJREDescHelper(launchDesc, matchJREIf);
            JREDesc jREDesc = matchJREIf.getSelectedJREDesc();
            if (jREDesc != null) {
                jREDesc.markAsSelected();
                resourcesDesc.addNested(jREDesc.getNestedResources());
            }
            LaunchSelection.selectJREExtensionHelper(launchDesc, matchJREIf);
        }
        matchJREIf.endTraversal(launchDesc);
        return matchJREIf.getSelectedJREInfo();
    }

    private static void selectJREDescHelper(final LaunchDesc launchDesc, MatchJREIf matchJREIf) {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        final ArrayList arrayList = new ArrayList();
        resourcesDesc.visit(new ResourceVisitor(){

            @Override
            public void visitJARDesc(JARDesc jARDesc) {
            }

            @Override
            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }

            @Override
            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            @Override
            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
            }

            @Override
            public void visitJREDesc(JREDesc jREDesc) {
                if (launchDesc.isLibrary()) {
                    Trace.println((String)("JNLP JREDesc in Component ignored: " + launchDesc.getLocation()));
                } else {
                    arrayList.add(jREDesc);
                }
            }
        });
        JREDesc jREDesc = null;
        JREInfo jREInfo = null;
        if (arrayList.size() > 0) {
            for (int j = 0; jREInfo == null && j < arrayList.size(); ++j) {
                jREDesc = (JREDesc)arrayList.get(j);
                URL uRL = jREDesc.getHref();
                jREInfo = LaunchSelection.selectJRE(uRL, jREDesc.getVersion(), launchDesc);
            }
            if (jREInfo == null) {
                jREDesc = (JREDesc)arrayList.get(0);
            }
        } else {
            jREDesc = new JREDesc(anyJREVersion, -1L, -1L, null, null, new ResourcesDesc());
            resourcesDesc.addResource(jREDesc);
            jREInfo = LaunchSelection.selectJRE(jREDesc.getHref(), jREDesc.getVersion(), launchDesc);
        }
        matchJREIf.digest(jREDesc, jREInfo);
    }

    private static void selectJREExtensionHelper(LaunchDesc launchDesc, MatchJREIf matchJREIf) {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        final ArrayList arrayList = new ArrayList();
        resourcesDesc.visit(new ResourceVisitor(){

            @Override
            public void visitJARDesc(JARDesc jARDesc) {
            }

            @Override
            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }

            @Override
            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            @Override
            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                arrayList.add(extensionDesc);
            }

            @Override
            public void visitJREDesc(JREDesc jREDesc) {
            }
        });
        matchJREIf.digest(launchDesc);
        if (launchDesc.isInstaller()) {
            return;
        }
        for (int j = 0; j < arrayList.size(); ++j) {
            ExtensionDesc extensionDesc = (ExtensionDesc)arrayList.get(j);
            LaunchDesc launchDesc2 = extensionDesc.getExtensionDesc();
            if (launchDesc2 == null) {
                try {
                    File file = DownloadEngine.getCachedFile((URL)extensionDesc.getLocation(), (String)extensionDesc.getVersion(), (boolean)false, (boolean)false, null);
                    if (null != file) {
                        launchDesc2 = LaunchDescFactory.buildDescriptor(file, extensionDesc.getCodebase(), extensionDesc.getLocation(), extensionDesc.getLocation());
                    }
                }
                catch (Exception exception) {
                    Trace.ignoredException((Exception)exception);
                }
            }
            if (null == launchDesc2 || launchDesc2.isInstaller()) continue;
            extensionDesc.setExtensionDesc(launchDesc2);
            LaunchSelection.selectJREExtensionHelper(launchDesc2, matchJREIf);
        }
    }

    public static JREInfo selectJRE(URL uRL, String string) {
        return LaunchSelection.selectJRE(uRL, string, null);
    }

    public static JREInfo selectJRE(URL uRL, String string, LaunchDesc launchDesc) {
        JREInfo[] jREInfoArray = JREInfo.getAll();
        if (jREInfoArray == null) {
            return null;
        }
        if (launchDesc != null) {
            jREInfoArray = LaunchSelectionMacOSX.reorderJREsByArch(jREInfoArray, launchDesc.getArches());
        }
        VersionString versionString = new VersionString(string);
        for (int j = 0; j < jREInfoArray.length; ++j) {
            if (!jREInfoArray[j].isOsInfoMatch(Config.getOSName(), Config.getOSArch()) || !jREInfoArray[j].isEnabled() || !(uRL == null ? LaunchSelection.isPlatformMatch(jREInfoArray[j], versionString) : LaunchSelection.isProductMatch(jREInfoArray[j], uRL, versionString))) continue;
            return jREInfoArray[j];
        }
        return null;
    }

    public static boolean isPlatformMatch(JREInfo jREInfo, VersionString versionString) {
        if (new File(jREInfo.getPath()).exists()) {
            return versionString.contains(jREInfo.getPlatform());
        }
        return false;
    }

    public static boolean isProductMatch(JREInfo jREInfo, URL uRL, VersionString versionString) {
        if (new File(jREInfo.getPath()).exists()) {
            return jREInfo.getLocation().equals(uRL.toString()) && versionString.contains(jREInfo.getProduct());
        }
        return false;
    }

    public static boolean isInstallJRE(JREInfo jREInfo) {
        File file = new File(Config.getJavaHome());
        File file2 = new File(jREInfo.getPath());
        File file3 = file2.getParentFile();
        return file.equals(file3.getParentFile());
    }

    public static interface MatchJREIf {
        public boolean hasBeenRun();

        public void beginTraversal(LaunchDesc var1);

        public void digest(JREDesc var1, JREInfo var2);

        public void digest(LaunchDesc var1);

        public void endTraversal(LaunchDesc var1);

        public JREInfo getSelectedJREInfo();

        public JREDesc getSelectedJREDesc();

        public JVMParameters getSelectedJVMParameters();

        public String getSelectedJVMParameterString();

        public long getSelectedInitHeapSize();

        public long getSelectedMaxHeapSize();

        public boolean isRunningJVMSatisfying(boolean var1);

        public boolean isRunningJVMVersionSatisfying();

        public boolean isRunningJVMArgsSatisfying(boolean var1);

        public String toString();
    }
}

