/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui;

import apple.awt.ProcessUI;
import com.apple.eawt.Application;
import com.sun.deploy.Environment;
import com.sun.deploy.net.DownloadException;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.ui.UITextArea;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.Globals;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.ui.SplashScreen;
import com.sun.javaws.util.JavawsConsoleController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Document;

public class LaunchErrorDialog {
    private static JPanel getDetailPanel(Throwable throwable) {
        Object object;
        Object object2;
        JPanel jPanel = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(480, 300);
            }
        };
        jPanel.setLayout(new BorderLayout());
        JNLPException jNLPException = null;
        DownloadException downloadException = null;
        Throwable throwable2 = null;
        if (throwable instanceof JNLPException) {
            jNLPException = (JNLPException)throwable;
            throwable2 = jNLPException.getWrappedException();
        } else if (throwable instanceof DownloadException) {
            downloadException = (DownloadException)throwable;
            throwable2 = downloadException.getWrappedException();
        } else if (throwable instanceof ExitException) {
            throwable2 = ((ExitException)throwable).getException();
        }
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, "Center");
        jTabbedPane.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        String string = LaunchErrorDialog.getErrorCategory(throwable);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(ResourceManager.getString((String)"launcherrordialog.error.label"));
        Font font = jLabel.getFont().deriveFont(1);
        jLabel.setFont(font);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 2));
        jPanel3.add(jLabel);
        ComponentOrientation componentOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        UITextArea uITextArea = new UITextArea();
        uITextArea.setComponentOrientation(componentOrientation);
        uITextArea.setText(LaunchErrorDialog.getErrorDescription(throwable));
        uITextArea.setBorder(new EmptyBorder(componentOrientation.isLeftToRight() ? new Insets(0, 5, 0, 0) : new Insets(0, 0, 0, 5)));
        jPanel3.add((Component)uITextArea);
        jPanel2.add((Component)jPanel3, "Before");
        jPanel.add((Component)jPanel2, "North");
        jPanel.applyComponentOrientation(componentOrientation);
        String string2 = null;
        String string3 = null;
        if (jNLPException != null) {
            string2 = jNLPException.getLaunchDescSource();
            if (string2 == null) {
                object2 = jNLPException.getDefaultLaunchDesc();
                if (object2 != null) {
                    string2 = ((LaunchDesc)object2).getSource();
                }
            }
        } else if (JNLPException.getDefaultLaunchDesc() != null) {
            string2 = JNLPException.getDefaultLaunchDesc().getSource();
        }
        if (JNLPException.getDefaultLaunchDesc() != null) {
            string3 = JNLPException.getDefaultLaunchDesc().getSource();
        }
        if (string3 != null && string3.equals(string2)) {
            string3 = null;
        }
        if (string2 != null) {
            jTabbedPane.add(ResourceManager.getString((String)"launcherrordialog.jnlpTab"), LaunchErrorDialog.createDetailScrollPane(LaunchErrorDialog.filter(string2), true, componentOrientation));
        }
        if (string3 != null) {
            jTabbedPane.add(ResourceManager.getString((String)"launcherrordialog.jnlpMainTab"), LaunchErrorDialog.createDetailScrollPane(LaunchErrorDialog.filter(string3), true, componentOrientation));
        }
        if (throwable != null) {
            object2 = new StringWriter();
            object = new PrintWriter((Writer)object2);
            throwable.printStackTrace((PrintWriter)object);
            jTabbedPane.add(ResourceManager.getString((String)"launcherrordialog.exceptionTab"), LaunchErrorDialog.createDetailScrollPane(((StringWriter)object2).toString(), false, componentOrientation));
        }
        if (throwable2 != null) {
            object2 = new StringWriter();
            object = new PrintWriter((Writer)object2);
            throwable2.printStackTrace((PrintWriter)object);
            jTabbedPane.add(ResourceManager.getString((String)"launcherrordialog.wrappedExceptionTab"), LaunchErrorDialog.createDetailScrollPane(((StringWriter)object2).toString(), false, componentOrientation));
        }
        object2 = null;
        object = JavawsConsoleController.getInstance().getConsole();
        if (object != null) {
            object2 = object.getTextArea().getDocument();
        }
        if (object2 != null) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setDocument((Document)object2);
            jTextArea.setFont(ResourceManager.getUIFont());
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            jScrollPane.setComponentOrientation(componentOrientation);
            jTabbedPane.add(ResourceManager.getString((String)"launcherrordialog.consoleTab"), jScrollPane);
        }
        return jPanel;
    }

    private static JScrollPane createDetailScrollPane(String string, boolean bl, ComponentOrientation componentOrientation) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(ResourceManager.getUIFont());
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setText(string);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setComponentOrientation(componentOrientation);
        return jScrollPane;
    }

    private static String filter(String string) {
        if (string.length() > 10240) {
            return string.substring(0, 10239) + "\njnlp file truncated after 10K\n";
        }
        return string;
    }

    public static void show(final Component component, final Throwable throwable, boolean bl) {
        boolean bl2;
        ProcessUI processUI = ProcessUI.getInstance();
        if (!processUI.isInflated()) {
            processUI.inflateDockIcon();
            Application application = Application.getApplication();
            application.setDockIconImage(application.getDockIconImage());
            application.requestForeground(true);
        }
        SplashScreen.hide();
        System.err.println("#### Java Web Start Error:");
        System.err.println("#### " + LaunchErrorDialog.getMessage(throwable));
        boolean bl3 = bl2 = !Globals.TCKHarnessRun && !Environment.isSilentMode();
        if (bl2) {
            DeploySysAction deploySysAction = new DeploySysAction(){

                public Object execute() {
                    try {
                        String string = null;
                        String string2 = LaunchErrorDialog.getErrorCategory(throwable);
                        if (throwable instanceof JNLPException) {
                            string = ((JNLPException)throwable).getBriefMessage();
                        }
                        if (string == null) {
                            string = Environment.isImportMode() ? (Environment.isInstallMode() ? ResourceManager.getString((String)"launcherrordialog.uninstall.brief.message") : ResourceManager.getString((String)"launcherrordialog.import.brief.message")) : ResourceManager.getString((String)"launcherrordialog.brief.message");
                        }
                        AppInfo appInfo = LaunchErrorDialog.getLaunchDesc() == null ? new AppInfo() : LaunchErrorDialog.getLaunchDesc().getAppInfo();
                        String string3 = ResourceManager.getString((String)"launcherrordialog.brief.ok");
                        String string4 = ResourceManager.getString((String)"launcherrordialog.brief.details");
                        String string5 = ResourceManager.getString((String)"error.default.title", (String)string2);
                        UIFactory.showErrorDialog((Component)component, (AppInfo)appInfo, (String)string5, (String)string, null, (String)string3, (String)string4, null, (JPanel)LaunchErrorDialog.getDetailPanel(throwable), null);
                    }
                    catch (Exception exception) {
                        Trace.ignored((Throwable)exception);
                    }
                    return null;
                }
            };
            DeploySysRun.execute((DeploySysAction)deploySysAction, null);
        }
        if (bl) {
            try {
                Main.systemExit(-1);
            }
            catch (ExitException exitException) {
                Trace.println((String)("systemExit: " + exitException), (TraceLevel)TraceLevel.BASIC);
                Trace.ignoredException((Exception)exitException);
            }
        }
    }

    private static String getErrorCategory(Throwable throwable) {
        String string = ResourceManager.getString((String)"launch.error.category.unexpected");
        if (throwable instanceof JNLPException) {
            JNLPException jNLPException = (JNLPException)throwable;
            string = jNLPException.getCategory();
        } else if (throwable instanceof SecurityException || throwable instanceof GeneralSecurityException) {
            string = ResourceManager.getString((String)"launch.error.category.security");
        } else if (throwable instanceof OutOfMemoryError) {
            string = ResourceManager.getString((String)"launch.error.category.memory");
        } else if (throwable instanceof DownloadException) {
            string = ResourceManager.getString((String)"launch.error.category.download");
        }
        return string;
    }

    private static String getErrorDescription(Throwable throwable) {
        String string = LaunchErrorDialog.getMessage(throwable);
        if (string == null) {
            string = ResourceManager.getString((String)"launcherrordialog.genericerror", (String)throwable.getClass().getName());
        }
        return string;
    }

    private static String getMessage(Throwable throwable) {
        if (throwable instanceof Exception) {
            return throwable.getMessage();
        }
        return throwable.getClass().getName() + ": " + throwable.getMessage();
    }

    private static LaunchDesc getLaunchDesc() {
        return JNLPException.getDefaultLaunchDesc();
    }
}

