/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.util.PerfLogger;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.BrowserSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jnlp.BasicService;
import sun.awt.DesktopBrowse;

public final class BasicServiceImpl
implements BasicService {
    private URL _codebase = null;
    private String _codebaseProtocol = null;
    private boolean _isWebBrowserSupported;
    private static BasicServiceImpl _sharedInstance = null;

    private BasicServiceImpl(URL uRL, boolean bl, String string) {
        this._codebaseProtocol = string;
        this._codebase = uRL;
        this._isWebBrowserSupported = bl;
        if (Config.isJavaVersionAtLeast16() && DesktopBrowse.getInstance() == null) {
            try {
                DesktopBrowse.setInstance((DesktopBrowse)new BasicServiceBrowser());
            }
            catch (Throwable throwable) {
                Trace.ignored((Throwable)throwable);
            }
        }
    }

    public static BasicServiceImpl getInstance() {
        return _sharedInstance;
    }

    public static void initialize(URL uRL, boolean bl, String string) {
        if (_sharedInstance == null) {
            _sharedInstance = new BasicServiceImpl(uRL, bl, string);
        }
    }

    @Override
    public URL getCodeBase() {
        return this._codebase;
    }

    @Override
    public boolean isOffline() {
        return DeployOfflineManager.isGlobalOffline();
    }

    private boolean isFileProtocolCodebase() {
        return this._codebaseProtocol != null && this._codebaseProtocol.equalsIgnoreCase("file");
    }

    static boolean isArgumentOkay(String string) {
        for (int j = 0; j < string.length(); ++j) {
            char c = string.charAt(j);
            if (' ' >= c || c >= '~') {
                return false;
            }
            if (c != '\\' && c != '\"') continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean showDocument(URL uRL) {
        URL uRL2;
        if (uRL == null) {
            return false;
        }
        try {
            uRL.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return false;
        }
        if (!URLUtil.checkTargetURL((URL)this._codebase, (URL)uRL)) {
            uRL2 = uRL;
            boolean bl = false;
            if ("jar".equals(uRL.getProtocol())) {
                try {
                    uRL2 = new URL(uRL.toString().substring(4));
                }
                catch (MalformedURLException malformedURLException) {
                    Trace.ignoredException((Exception)malformedURLException);
                    return bl;
                }
            }
            if ("file".equals(uRL2.getProtocol())) {
                try {
                    File file = new File(uRL2.getFile());
                    file.canRead();
                    bl = true;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if (!bl) {
                throw new SecurityException("ShowDocument url permission denied");
            }
        }
        if (Config.isJavaVersionAtLeast16() && (uRL2 = DesktopBrowse.getInstance()) != null && !(uRL2 instanceof BasicServiceBrowser)) {
            if (!this.isWebBrowserSupported()) {
                return false;
            }
            try {
                uRL = new URL(this._codebase, uRL.toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            uRL2.browse(uRL);
            return true;
        }
        return this.showDocumentHelper(uRL);
    }

    private boolean showDocumentHelper(final URL uRL) {
        Comparable<File> comparable;
        boolean bl = uRL.toString().toLowerCase().endsWith(".jnlp");
        boolean bl2 = false;
        try {
            comparable = DownloadEngine.getCachedFile((URL)uRL);
            bl2 = comparable != null;
        }
        catch (Exception exception) {
            Trace.ignoredException((Exception)exception);
        }
        if ((bl || bl2) && (comparable = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (DownloadEngine.isJnlpURL((URL)uRL)) {
                    try {
                        String string = DownloadEngine.getCachedResourceFilePath((URL)uRL, null);
                        if (string != null && BasicServiceImpl.isArgumentOkay(string)) {
                            String[] stringArray = new String[]{Config.getJavawsCommand(), "-Xnosplash", string};
                            Runtime.getRuntime().exec(stringArray);
                            return new Boolean(true);
                        }
                    }
                    catch (Exception exception) {
                        Trace.ignored((Throwable)exception);
                        return new Boolean(false);
                    }
                }
                return new Boolean(false);
            }
        })) != null && ((Boolean)comparable).booleanValue()) {
            return true;
        }
        if (!this.isWebBrowserSupported()) {
            return false;
        }
        comparable = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL uRL3 = uRL;
                try {
                    URL uRL2;
                    uRL3 = uRL2 = new URL(BasicServiceImpl.this._codebase, uRL3.toString());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                return new Boolean(BrowserSupport.showDocument(uRL3));
            }
        });
        return comparable == null ? false : (Boolean)comparable;
    }

    @Override
    public boolean isWebBrowserSupported() {
        PerfLogger.setEndTime((String)"BasicService.isWebBrowserSupported called");
        PerfLogger.outputLog();
        return this._isWebBrowserSupported;
    }

    private class BasicServiceBrowser
    extends DesktopBrowse {
        private BasicServiceBrowser() {
        }

        public void browse(URL uRL) {
            BasicServiceImpl.this.showDocument(uRL);
        }
    }
}

