/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.resources.ResourceManager;
import com.sun.javaws.JnlpxArgs;
import com.sun.jnlp.ApiDialog;
import com.sun.jnlp.CheckServicePermission;
import com.sun.jnlp.FileContentsImpl;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jnlp.ExtendedService;
import javax.jnlp.FileContents;

public final class ExtendedServiceImpl
implements ExtendedService {
    private static ExtendedServiceImpl _sharedInstance = null;
    private static int DEFAULT_FILESIZE = Integer.MAX_VALUE;

    private ExtendedServiceImpl() {
    }

    public static synchronized ExtendedServiceImpl getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new ExtendedServiceImpl();
        }
        return _sharedInstance;
    }

    @Override
    public FileContents openFile(File file) throws IOException {
        if (file == null) {
            return null;
        }
        final File file2 = new File(file.getPath());
        if (!(CheckServicePermission.hasFileAccessPermissions(file2.toString()) || JnlpxArgs.getFileReadWriteList().contains(file2.toString()) || this.askUser(file2.getPath()))) {
            return null;
        }
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return new FileContentsImpl(file2, DEFAULT_FILESIZE);
                }
                catch (IOException iOException) {
                    return iOException;
                }
            }
        });
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        return (FileContents)t;
    }

    synchronized boolean askUser(String string) {
        if (CheckServicePermission.hasFileAccessPermissions()) {
            return true;
        }
        ApiDialog apiDialog = new ApiDialog();
        String string2 = ResourceManager.getString((String)"api.extended.open.title");
        String string3 = ResourceManager.getString((String)"api.extended.open.message");
        String string4 = ResourceManager.getString((String)"api.extended.open.label");
        return apiDialog.askUser(string2, string3, null, string4, string, false);
    }

    @Override
    public FileContents[] openFiles(File[] fileArray) throws IOException {
        int n;
        if (fileArray == null || fileArray.length <= 0) {
            return null;
        }
        final File[] fileArray2 = new File[fileArray.length];
        for (n = 0; n < fileArray.length; ++n) {
            fileArray2[n] = new File(fileArray[n].getPath());
        }
        n = 1;
        for (int j = 0; j < fileArray2.length; ++j) {
            if (CheckServicePermission.hasFileAccessPermissions(fileArray2[j].toString())) continue;
            n = 0;
            break;
        }
        String string = "";
        for (int j = 0; j < fileArray2.length; ++j) {
            string = string + fileArray2[j].getPath() + "\n";
        }
        if (n == 0 && !this.askUser(string)) {
            return null;
        }
        Object[] objectArray = (Object[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                FileContents[] fileContentsArray = new FileContents[fileArray2.length];
                try {
                    for (int j = 0; j < fileArray2.length; ++j) {
                        fileContentsArray[j] = new FileContentsImpl(fileArray2[j], DEFAULT_FILESIZE);
                    }
                }
                catch (IOException iOException) {
                    fileContentsArray[0] = iOException;
                }
                return fileContentsArray;
            }
        });
        if (objectArray[0] instanceof IOException) {
            throw (IOException)objectArray[0];
        }
        return (FileContents[])objectArray;
    }
}

