/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.config.Config;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.ArrayList;

public final class PreverificationClassLoader
extends URLClassLoader {
    private ArrayList _jarsInURLClassLoader = new ArrayList();
    private ArrayList _jarsNotInURLClassLoader = new ArrayList();

    public PreverificationClassLoader(ClassLoader classLoader) {
        super(new URL[0], classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        permissionCollection.add(new AllPermission());
        return permissionCollection;
    }

    public void preverifyJARs() {
        if (!Cache.isCacheEnabled()) {
            return;
        }
        long l = System.currentTimeMillis();
        for (int j = 0; j < this._jarsInURLClassLoader.size(); ++j) {
            JARDesc jARDesc = (JARDesc)this._jarsInURLClassLoader.get(j);
            StringBuilder stringBuilder = new StringBuilder();
            Config.getInstance();
            File file = new File(stringBuilder.append(Config.getSystemCacheDirectory()).append(File.separator).append(Cache.getCacheVersionString()).toString());
            CacheEntry cacheEntry = Cache.getCacheEntry((URL)jARDesc.getLocation(), null, (String)jARDesc.getVersion(), (File)file);
            if (cacheEntry == null || cacheEntry.getClassesVerificationStatus() != 0) continue;
            cacheEntry.verifyJAR((URLClassLoader)this);
        }
        long l2 = System.currentTimeMillis();
        Trace.println((String)("PreverificationCL, Cached JAR preverification took (ms): " + (l2 - l)), (TraceLevel)TraceLevel.CACHE);
    }

    public void initialize(LaunchDesc launchDesc) {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc != null) {
            this.sortDescriptors(resourcesDesc);
            for (int j = 0; j < this._jarsInURLClassLoader.size(); ++j) {
                JARDesc jARDesc = (JARDesc)this._jarsInURLClassLoader.get(j);
                this.addURL(jARDesc.getLocation());
            }
        }
    }

    private void addLoadedJarsEntry(JARDesc jARDesc) {
        if (!this._jarsInURLClassLoader.contains(jARDesc)) {
            this._jarsInURLClassLoader.add(jARDesc);
        }
    }

    private void sortDescriptors(ResourcesDesc resourcesDesc) {
        int n;
        ArrayList<JARDesc> arrayList = new ArrayList<JARDesc>();
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        JARDesc jARDesc = resourcesDesc.getMainJar(true);
        JARDesc jARDesc2 = resourcesDesc.getProgressJar();
        if (jARDesc2 != null) {
            this.addLoadedJarsEntry(jARDesc2);
        }
        if (jARDesc != null) {
            this.addLoadedJarsEntry(jARDesc);
        }
        for (n = 0; n < jARDescArray.length; ++n) {
            if (jARDescArray[n] == jARDesc || jARDescArray[n] == jARDesc2) continue;
            if (!jARDescArray[n].isLazyDownload()) {
                this.addLoadedJarsEntry(jARDescArray[n]);
                continue;
            }
            if (!resourcesDesc.isPackagePart(jARDescArray[n].getPartName())) {
                arrayList.add(jARDescArray[n]);
                continue;
            }
            this._jarsNotInURLClassLoader.add(jARDescArray[n]);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.addLoadedJarsEntry((JARDesc)arrayList.get(n));
        }
    }
}

