/*
 * Decompiled with CFR 0.152.
 */
package controller.globalCommands;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import util.MyResourceBundle;
import util.languages.LanguageManager;

public abstract class ActionCommand
extends AbstractAction {
    MyResourceBundle bundle;

    public ActionCommand() {
        this.init("", "", "", "");
    }

    public ActionCommand(String actionCommand) {
        this.init(actionCommand, "", "", "");
    }

    public ActionCommand(String actionCommand, String name) {
        this.init(actionCommand, name, "", "");
    }

    public ActionCommand(String actionCommand, Icon icon) {
        this.init(actionCommand, icon, "", "");
    }

    public ActionCommand(String actionCommand, String name, String shortDescription, String longDescription) {
        this.init(actionCommand, name, shortDescription, longDescription);
    }

    public ActionCommand(String actionCommand, Icon icon, String shortDescription, String longDescription) {
        this.init(actionCommand, icon, shortDescription, longDescription);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public String formatToolTip(String s) {
        String s2 = "<html><span style = \"font-size : 11pt\">" + s + "</span></html>";
        return s2;
    }

    public String getActionCommand() {
        return (String)this.getValue("ActionCommandKey");
    }

    public String getLongDescription() {
        return (String)this.getValue("LongDescription");
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public String getShortDescription() {
        return (String)this.getValue("ShortDescription");
    }

    public void init(String actionCommand, String name, String shortDescription, String longDescription) {
        this.putValue("ActionCommandKey", actionCommand);
        this.putValue("Name", name);
        this.putValue("LongDescription", longDescription);
        this.putValue("ShortDescription", this.formatToolTip(shortDescription));
    }

    public void init(String actionCommand, Icon icon, String shortDescription, String longDescription) {
        this.putValue("ActionCommandKey", actionCommand);
        this.putValue("SwingLargeIconKey", icon);
        this.putValue("LongDescription", longDescription);
        this.putValue("ShortDescription", this.formatToolTip(shortDescription));
    }

    public void init(String actionCommand) {
        this.putValue("ActionCommandKey", actionCommand);
        this.putValue("LongDescription", "");
        this.putValue("ShortDescription", "");
    }

    public void updateLanguage() {
    }

    public void setLang(String name, String shortDescription, String longDescription) {
        this.bundle = LanguageManager.getInstance().getResource("ActionsApp");
        this.putValue("Name", name);
        this.putValue("LongDescription", longDescription);
        this.putValue("ShortDescription", this.formatToolTip(shortDescription));
    }

    public void setLang(Icon icon, String shortDescription, String longDescription) {
        this.bundle = LanguageManager.getInstance().getResource("ActionsApp");
        this.putValue("SwingLargeIconKey", icon);
        this.putValue("LongDescription", longDescription);
        this.putValue("ShortDescription", this.formatToolTip(shortDescription));
    }
}

