/*
 * Decompiled with CFR 0.152.
 */
package controller.globalCommands;

import controller.globalCommands.ActionCommand;
import java.util.HashMap;

public class ActionCommandRegistry {
    private HashMap<String, ActionCommand> lstActions = new HashMap();
    private static ActionCommandRegistry instance = null;

    public static ActionCommandRegistry getInstance() {
        if (instance == null) {
            instance = new ActionCommandRegistry();
        }
        return instance;
    }

    private ActionCommandRegistry() {
    }

    public void add(ActionCommand action) {
        this.lstActions.put(action.getActionCommand(), action);
    }

    public ActionCommand get(String actionCommand) {
        return this.lstActions.get(actionCommand);
    }

    public void disableAll() {
        if (this.lstActions == null) {
            return;
        }
        for (ActionCommand action : this.lstActions.values()) {
            action.setEnabled(false);
        }
    }

    public void enableAll() {
        if (this.lstActions == null) {
            return;
        }
        for (ActionCommand action : this.lstActions.values()) {
            action.setEnabled(true);
        }
    }

    public void updateLanguage() {
        if (this.lstActions == null) {
            return;
        }
        for (ActionCommand action : this.lstActions.values()) {
            action.updateLanguage();
        }
    }

    public static void clear() {
        ActionCommandRegistry.instance.lstActions.clear();
        instance = null;
    }
}

