/*
 * Decompiled with CFR 0.152.
 */
package controller.globalCommands;

import controller.globalCommands.ActionCommand;
import controller.globalCommands.EnableActionManager;
import controller.globalCommands.ICommand;
import controller.globalCommands.IGlobalCommands;
import java.awt.event.ActionEvent;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.exception.CoupleException;
import org.ctom.hulis.huckel.exception.IMethodException;
import org.ctom.hulis.huckel.exception.MesomeryDelocalizedStructureNotExistsException;
import org.ctom.hulis.huckel.exception.MesomeryNoStructureLocalizedException;
import org.ctom.hulis.huckel.exception.SelectionException;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import util.MyJOptionPane;
import util.MyResourceBundle;
import util.io.SwingIO;
import util.languages.LanguageManager;
import views.FrameApp;

public class ActionDuplicate
extends ActionCommand
implements ICommand,
IGlobalCommands {
    FrameApp app;

    public ActionDuplicate(FrameApp app) {
        super("14");
        this.updateLanguage();
        this.app = app;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.execute();
    }

    @Override
    public void updateLanguage() {
        MyResourceBundle rb2 = LanguageManager.getInstance().getResource("ToolBarMesomery");
        MyResourceBundle bundle = LanguageManager.getInstance().getResource("ActionsApp");
        this.setLang(rb2.getString("kcreate1"), bundle.getString("kcreate11"), bundle.getString("kcreate12"));
    }

    @Override
    public void execute() {
        Mesomery mesomery = this.app.getCurrentMesomeryView().getMesomery();
        if (!mesomery.getDelocalizedStructure().areCorrectAtomsSeqNum()) {
            MyJOptionPane.showMessageDialog(this.app, this.bundle.getString("krerrorseqnum"), this.bundle.getString("kerrtitle"), 0);
            return;
        }
        if (mesomery.getDelocalizedStructure().countAtoms() != 0) {
            try {
                this.app.getStateManager().initNewState();
                StructureLocalized s = mesomery.createLocalizedStructure();
                SwingIO.log(this.getClass().getName(), "execute", "create a localized structure : structure" + s.getName());
                if (mesomery.getStructureSelector().isCurrentValueLowerThanTreshold(s)) {
                    mesomery.setSelectionTreshold(mesomery.getStructureSelector().getCurrentValue(s));
                    this.app.getCurrentMesomeryView().setCurrentStructure(s);
                    this.app.toolBarMesomery.adjustSlider(-((Double)mesomery.getSelectionTreshold()).doubleValue());
                }
                EnableActionManager.getInstance().updateActionsToEnable(this.app);
                this.app.statusBar.setTxtState(this.bundle.getString("kcreate12"));
                this.app.toolBarMesomery.btChangeElectrons.doClick();
                this.app.getStateManager().saveState();
            }
            catch (MesomeryDelocalizedStructureNotExistsException e) {
                SwingIO.error(this.getClass().getName(), "execute", e.getMessage(), e);
                SwingIO.reportError(this.app);
            }
            catch (CoupleException e) {
                SwingIO.error(this.getClass().getName(), "execute", e.getMessage(), e);
                SwingIO.reportError(this.app);
            }
            catch (IMethodException e) {
                SwingIO.error(this.getClass().getName(), "execute", e.getMessage(), e);
                SwingIO.reportError(this.app);
            }
            catch (MesomeryNoStructureLocalizedException e) {
                SwingIO.error(this.getClass().getName(), "execute", e.getMessage(), e);
                SwingIO.reportError(this.app);
            }
            catch (SelectionException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isSucceed() {
        return true;
    }

    @Override
    public String getFailReason() {
        return "";
    }
}

