/*
 * Decompiled with CFR 0.152.
 */
package controller.globalCommands;

import controller.globalCommands.ActionCommand;
import controller.globalCommands.ActionCommandRegistry;
import controller.globalCommands.EnableActionManager;
import controller.globalCommands.ICommand;
import controller.globalCommands.IGlobalCommands;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.ctom.hulis.huckel.BlocDelocalized;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import util.MyJOptionPane;
import util.MyResourceBundle;
import util.io.SwingIO;
import util.languages.LanguageManager;
import views.FrameApp;
import views.StructureView;

public class ActionEndBloc
extends ActionCommand
implements ICommand,
IGlobalCommands {
    FrameApp app;
    private JComponent parent;

    public ActionEndBloc(FrameApp app) {
        super("10");
        this.updateLanguage();
        this.app = app;
        this.parent = app.getCurrentMesomeryView();
    }

    public ActionEndBloc(FrameApp app, JComponent parent) {
        super("10");
        this.updateLanguage();
        this.app = app;
        this.parent = parent;
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        this.execute();
    }

    public static boolean checkCurrentBlocInCurrentStructure(FrameApp app) {
        Structure s;
        MyResourceBundle bundle = LanguageManager.getInstance().getResource("ActionsApp");
        String msgboxTitle = bundle.getString("kTitleMsgboxEndBloc");
        StructureView sv = app.getCurrentMesomeryView().getFirstStructureWithSelectedBloc();
        if (sv != null && StructureView.getSelectedBlocDelocalized() != null && (s = sv.getStructure()) != app.getCurrentMesomeryView().getCurrentStructure()) {
            Object[] args = new Object[]{"\u03c8" + s.getName()};
            String msgboxMess = MessageFormat.format(bundle.getString("kMessAnotherBloc"), args);
            JOptionPane.showMessageDialog(app, msgboxMess, msgboxTitle, 1);
            return false;
        }
        return true;
    }

    @Override
    public void execute() {
        SwingIO.log(this.getClass().getName(), "execute", "terminate bloc");
        String msgboxTitle = this.bundle.getString("kTitleMsgboxEndBloc");
        StructureView currentStructureView = this.app.getCurrentMesomeryView().getCurrentStructureView();
        StructureLocalized currentStructure = (StructureLocalized)currentStructureView.getStructure();
        BlocDelocalized currentSelectedBloc = StructureView.getSelectedBlocDelocalized();
        this.app.getStateManager().initNewState();
        if (currentSelectedBloc == null) {
            if (!ActionEndBloc.checkCurrentBlocInCurrentStructure(this.app)) {
                return;
            }
            String msgboxMess = this.bundle.getString("kMessNoModificationBloc");
            JOptionPane.showMessageDialog(this.parent, msgboxMess, msgboxTitle, 1);
        } else if (currentSelectedBloc.countHuckelObjects() == 0) {
            currentSelectedBloc.clear();
            currentStructure.removeBlocDelocalized(currentSelectedBloc);
            currentSelectedBloc = null;
            String msgboxMess = this.bundle.getString("kMessAutoDeleteBloc");
            JOptionPane.showMessageDialog(this.parent, msgboxMess, msgboxTitle, 1);
        } else {
            String sNbElec = null;
            int nbElec = 0;
            String msgboxMess = this.bundle.getString("kMessMsgboxEndBloc");
            while (sNbElec == null) {
                try {
                    sNbElec = (String)MyJOptionPane.showInputDialog(this.parent, msgboxMess, msgboxTitle, 3, null, null, currentSelectedBloc.getNbElectron());
                    nbElec = Integer.valueOf(sNbElec);
                }
                catch (NumberFormatException e) {
                    sNbElec = null;
                }
            }
            currentSelectedBloc.setNbElectron(nbElec);
        }
        this.unselectCurrentBloc();
        this.app.getStateManager().saveState();
    }

    public void unselectCurrentBloc() {
        StructureView.setSelectedBlocDelocalized(null);
        this.app.toolBarMesomery.btEndBloc.setVisible(false);
        this.app.toolBarMesomery.btBloc.setVisible(true);
        ActionCommandRegistry.getInstance().enableAll();
        String command = "";
        command = this.app.getCurrentMesomeryView().getCurrentStructure() instanceof StructureLocalized ? "7" : "2";
        this.app.clickButtonCommand(command);
        EnableActionManager.getInstance().updateActionsToEnable(this.app);
        this.app.statusBar.setTxtState(this.bundle.getString("kendbloc2"));
    }

    @Override
    public void updateLanguage() {
        MyResourceBundle rb2 = LanguageManager.getInstance().getResource("ToolBarMesomery");
        MyResourceBundle bundle = LanguageManager.getInstance().getResource("ActionsApp");
        this.setLang(rb2.getString("kendbloc"), bundle.getString("kendbloc1"), bundle.getString("kendbloc2"));
    }

    @Override
    public boolean isSucceed() {
        return true;
    }

    @Override
    public String getFailReason() {
        return "";
    }
}

