/*
 * Decompiled with CFR 0.152.
 */
package controller.globalCommands;

import controller.globalCommands.ActionCommand;
import controller.globalCommands.ActionStopConsumingProcess;
import controller.globalCommands.EnableActionManager;
import controller.globalCommands.ICommand;
import controller.globalCommands.IGlobalCommands;
import java.awt.event.ActionEvent;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.exception.CoupleException;
import org.ctom.hulis.huckel.exception.IMethodException;
import org.ctom.hulis.huckel.exception.MesomeryLocalizedStructureExistsException;
import org.ctom.hulis.huckel.exception.MesomeryNoStructureLocalizedException;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import util.MyResourceBundle;
import util.ThreadUtils;
import util.io.SwingIO;
import util.languages.LanguageManager;
import views.FrameApp;

public class ActionErase1
extends ActionCommand
implements ICommand,
IGlobalCommands {
    FrameApp app;

    public ActionErase1(FrameApp app) {
        super("16");
        this.app = app;
        this.updateLanguage();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.execute();
    }

    @Override
    public void updateLanguage() {
        MyResourceBundle rb2 = LanguageManager.getInstance().getResource("ToolBarMesomery");
        MyResourceBundle bundle = LanguageManager.getInstance().getResource("ActionsApp");
        this.setLang(rb2.getString("kerase1"), bundle.getString("kerase11"), bundle.getString("kerase12"));
    }

    @Override
    public void execute() {
        final Mesomery mesomery = this.app.getCurrentMesomeryView().getMesomery();
        this.setEnabled(false);
        Thread t = ActionStopConsumingProcess.stopAllConsumingProces(this.app);
        try {
            t.join();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        t = new Thread(new Runnable(){

            @Override
            public void run() {
                ActionErase1.this.app.statusBar.setTxtState(ActionErase1.this.bundle.getString("kerase12"));
                Structure currentStructure = ActionErase1.this.app.getCurrentMesomeryView().getCurrentStructure();
                if (currentStructure instanceof StructureLocalized) {
                    try {
                        ActionErase1.this.app.getStateManager().initNewState();
                        final String structureName = currentStructure.getName();
                        SwingIO.log(this.getClass().getName(), "execute", "Try to erase structure Psi" + structureName);
                        mesomery.deleteStructure(currentStructure);
                        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

                            @Override
                            public void run() {
                                SwingIO.log(this.getClass().getName(), "execute", "structure Psi" + structureName + " has been erased");
                                EnableActionManager.getInstance().updateActionsToEnable((this).ActionErase1.this.app);
                                if (mesomery.countSelectedLocalizedStructs() == 0) {
                                    (this).ActionErase1.this.app.clickButtonCommand("2");
                                }
                            }
                        });
                        ActionErase1.this.app.getStateManager().saveState();
                    }
                    catch (CoupleException e) {
                        final CoupleException ex = e;
                        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

                            @Override
                            public void run() {
                                SwingIO.error(this.getClass().getName(), "execute", ex.getMessage(), ex);
                                SwingIO.reportError((this).ActionErase1.this.app);
                            }
                        });
                    }
                    catch (IMethodException e) {
                        final IMethodException ex = e;
                        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

                            @Override
                            public void run() {
                                SwingIO.error(this.getClass().getName(), "execute", ex.getMessage(), ex);
                                SwingIO.reportError((this).ActionErase1.this.app);
                            }
                        });
                    }
                    catch (MesomeryNoStructureLocalizedException e) {
                        final MesomeryNoStructureLocalizedException ex = e;
                        ThreadUtils.invokeAsSoonAsPossible(new Runnable(){

                            @Override
                            public void run() {
                                SwingIO.error(this.getClass().getName(), "execute", ex.getMessage(), ex);
                                SwingIO.reportError((this).ActionErase1.this.app);
                            }
                        });
                    }
                    catch (MesomeryLocalizedStructureExistsException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isSucceed() {
        return true;
    }

    @Override
    public String getFailReason() {
        return "";
    }
}

