/*
 * Decompiled with CFR 0.152.
 */
package controller.globalCommands;

import controller.globalCommands.ActionCommand;
import controller.globalCommands.ICommand;
import controller.globalCommands.IGlobalCommands;
import java.awt.event.ActionEvent;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.structures.StructureDelocalized;
import util.MyResourceBundle;
import util.io.SwingIO;
import util.languages.LanguageManager;
import views.FrameApp;

public class ActionMoleculeAddElecCharge
extends ActionCommand
implements ICommand,
IGlobalCommands {
    FrameApp app;

    public ActionMoleculeAddElecCharge(FrameApp app) {
        super("19");
        this.updateLanguage();
        this.app = app;
    }

    @Override
    public void updateLanguage() {
        MyResourceBundle bundle = LanguageManager.getInstance().getResource("ActionsApp");
        this.setLang("-", bundle.getString("kaddcharge1"), bundle.getString("kaddcharge2"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.execute();
    }

    @Override
    public void execute() {
        SwingIO.log(this.getClass().getName(), "execute", "add an electron on the structure (charge -)");
        Mesomery mesomery = this.app.getCurrentMesomeryView().getMesomery();
        this.app.statusBar.setTxtState(this.bundle.getString("kaddcharge2"));
        StructureDelocalized structure = mesomery.getDelocalizedStructure();
        int nbMaxElecPossible = structure.countHuckelAtoms() * 2;
        if (structure.getSumOfPiElec() + 1 <= nbMaxElecPossible) {
            try {
                this.app.getStateManager().initNewState();
                structure.addNbElecCharge(1);
                this.app.getStateManager().saveState();
            }
            catch (Exception e1) {
                SwingIO.error(this.getClass().getName(), "actionPerformed", e1.getMessage(), e1);
                e1.printStackTrace();
                SwingIO.reportError(this.app);
            }
        }
    }

    @Override
    public boolean isSucceed() {
        return true;
    }

    @Override
    public String getFailReason() {
        return "";
    }
}

