/*
 * Decompiled with CFR 0.152.
 */
package controller.globalCommands;

import controller.globalCommands.ActionCommand;
import controller.globalCommands.ActionCommandRegistry;
import controller.globalCommands.ActionStopConsumingProcess;
import controller.globalCommands.ICommand;
import controller.globalCommands.IGlobalCommands;
import java.awt.event.ActionEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import util.MyResourceBundle;
import util.io.SwingIO;
import util.languages.LanguageManager;
import views.FrameApp;

public class ActionQuit
extends ActionCommand
implements ICommand,
IGlobalCommands {
    FrameApp app;
    int errcode;

    public ActionQuit(FrameApp app) {
        super("25");
        this.updateLanguage();
        this.app = app;
        this.errcode = 0;
    }

    public ActionQuit(FrameApp app, int errcode) {
        super("25");
        this.updateLanguage();
        this.app = app;
        this.errcode = errcode;
    }

    @Override
    public void updateLanguage() {
        MyResourceBundle rb3 = LanguageManager.getInstance().getResource("ToolBarHuckel");
        MyResourceBundle bundle = LanguageManager.getInstance().getResource("ActionsApp");
        this.setLang(rb3.getString("kquit"), bundle.getString("kquit1"), "");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.execute();
    }

    @Override
    public void execute() {
        try {
            try {
                SwingIO.log(this.getClass().getName(), "execute", "quit the software");
                this.setEnabled(false);
                Thread t = ActionStopConsumingProcess.stopAllConsumingProces(this.app);
                try {
                    t.join();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                this.app.getCurrentMesomery().deleteAllStructures();
                System.out.println("disableOptionsContext");
                ActionCommandRegistry.getInstance().disableAll();
                MenuElement[] menuElementArray = this.app.menuBar.getSubElements();
                int n = menuElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuElement menuElement = menuElementArray[n2];
                    if (menuElement instanceof JMenuItem) {
                        ((JMenuItem)menuElement).setEnabled(false);
                    } else if (menuElement instanceof JMenu) {
                        ((JMenu)menuElement).setEnabled(false);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.app.terminate(this.errcode);
            }
        }
        finally {
            this.app.terminate(this.errcode);
        }
    }

    @Override
    public boolean isSucceed() {
        return true;
    }

    @Override
    public String getFailReason() {
        return "";
    }
}

