/*
 * Decompiled with CFR 0.152.
 */
package controller.globalCommands;

import controller.globalCommands.ActionCommand;
import controller.globalCommands.ICommand;
import controller.globalCommands.IGlobalCommands;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.ImageIcon;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureDelocalized;
import util.MyResourceBundle;
import util.io.SwingIO;
import util.languages.LanguageManager;
import views.MesomeryView;
import views.StructureView;

public class Center
extends ActionCommand
implements ICommand,
IGlobalCommands {
    private MesomeryView mesomeryView;

    public Center(MesomeryView mesomeryView) {
        super("36");
        this.updateLanguage();
        this.mesomeryView = mesomeryView;
    }

    @Override
    public void execute() {
        SwingIO.log(this.getClass().getName(), "execute", "center the structures");
        final StructureDelocalized structure = this.mesomeryView.getMesomery().getDelocalizedStructure();
        final StructureView structureView = this.mesomeryView.getStructureView(structure);
        if (structure == null || structureView == null) {
            return;
        }
        this.center(structure, structureView);
        ComponentListener componentListener = new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Center.this.center(structure, structureView);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        };
        structureView.addComponentListener(componentListener);
    }

    public void center(Structure structure, StructureView structureView) {
        double moleculeWidth = structure.getWidth();
        double moleculeHeight = structure.getHeight();
        double zoom = this.mesomeryView.getZoom();
        double xMargin = (double)(structureView.getWidth() / 2) / zoom - moleculeWidth / 2.0 - structure.getXMin();
        double yMargin = (double)(structureView.getHeight() / 2) / zoom - moleculeHeight / 2.0 - structure.getYMin();
        this.mesomeryView.setXMargin(xMargin);
        this.mesomeryView.setYMargin(yMargin);
        this.mesomeryView.refresh();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.execute();
    }

    @Override
    public void updateLanguage() {
        MyResourceBundle rb3 = LanguageManager.getInstance().getResource("ToolBarHuckel");
        MyResourceBundle bundle = LanguageManager.getInstance().getResource("ActionsApp");
        this.setLang(new ImageIcon(new ImageIcon(this.getClass().getClassLoader().getResource(rb3.getString("kimgcenter"))).getImage().getScaledInstance(28, 15, 4)), bundle.getString("kcenter1"), bundle.getString("kcenter2"));
    }

    @Override
    public boolean isSucceed() {
        return true;
    }

    @Override
    public String getFailReason() {
        return "";
    }
}

