/*
 * Decompiled with CFR 0.152.
 */
package controller.globalCommands;

import controller.globalCommands.ActionCommandRegistry;
import controller.globalCommands.ICommand;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.UIManager;
import util.MyResourceBundle;
import util.io.SwingIO;
import util.languages.Language;
import util.languages.LanguageManager;
import views.FrameApp;
import views.FrameResult;
import views.prefs.PreferencesGUI;

public class ChangeLanguage
implements ActionListener,
ICommand {
    FrameApp app;
    Language language;

    public ChangeLanguage(FrameApp app, Language language) {
        this.app = app;
        this.language = language;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.execute();
    }

    @Override
    public void execute() {
        SwingIO.log(this.getClass().getName(), "execute", "change language");
        Locale locale = this.language.getLocale();
        LanguageManager.getInstance().setLanguage(this.language.getLocale());
        PreferencesGUI.getInstance().setLanguage(this.language.getLocale());
        MyResourceBundle rb2 = LanguageManager.getInstance().getResource("JOptionPane");
        UIManager.put("OptionPane.yesButtonText", rb2.getString("Yes"));
        UIManager.put("OptionPane.noButtonText", rb2.getString("No"));
        UIManager.put("OptionPane.cancelButtonText", rb2.getString("Cancel"));
        UIManager.getDefaults().setDefaultLocale(locale);
        JComponent.setDefaultLocale(locale);
        Window[] windowArray = JFrame.getWindows();
        int n = windowArray.length;
        int n2 = 0;
        while (n2 < n) {
            Window r = windowArray[n2];
            if (r instanceof FrameResult) {
                ((FrameResult)r).updateLanguage();
            }
            ++n2;
        }
        this.app.menuBar.languageMenu.setIcon(this.language.getFlag());
        this.app.menuBar.updateLanguage();
        this.app.toolBarHuckel.updateLanguage();
        this.app.toolBarMesomery.updateLanguage();
        this.app.getCurrentMesomeryView().updateLanguage();
        this.app.statusBar.updateLanguage();
        this.app.updateLanguage();
        MyResourceBundle bundle = LanguageManager.getInstance().getResource("FrameApp");
        this.app.statusBar.setTxtState(bundle.getString("kchangelang"));
        ActionCommandRegistry.getInstance().updateLanguage();
    }

    public String getActionCommand() {
        return "1";
    }

    @Override
    public boolean isSucceed() {
        return true;
    }

    @Override
    public String getFailReason() {
        return "";
    }
}

