/*
 * Decompiled with CFR 0.152.
 */
package controller.globalCommands;

import controller.globalCommands.ICommand;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import util.io.IOFichier;
import util.io.SwingIO;
import views.FrameApp;
import views.MesomeryView;
import views.prefs.PreferencesGUI;

public class PrintCurrentView
implements ICommand,
ActionListener {
    FrameApp app;
    String radical;

    public PrintCurrentView(FrameApp app) {
        this.app = app;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.execute();
    }

    @Override
    public void execute() {
        SwingIO.log(this.getClass().getName(), "execute", "print current view");
        SwingIO.PrintIfln("Print current view");
        MesomeryView view = this.app.getCurrentMesomeryView();
        BufferedImage img = new BufferedImage(view.getWidth(), view.getHeight(), 1);
        Graphics2D g = img.createGraphics();
        this.app.getCurrentMesomeryView().paint(g);
        g.dispose();
        if (!PreferencesGUI.isPrintingSet()) {
            new IOFichier(this.app);
        }
        try {
            boolean found = true;
            int ifile = 0;
            File file = null;
            while (found) {
                String strFile = PreferencesGUI.getDirPrint();
                int l = strFile.length();
                strFile = String.valueOf(strFile.substring(0, l - 4)) + ++ifile + "." + PreferencesGUI.getExtPrint();
                file = new File(strFile);
                found = file.exists();
            }
            String extPrint = PreferencesGUI.getExtPrint();
            ImageIO.write((RenderedImage)img, extPrint, file);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public boolean isSucceed() {
        return true;
    }

    @Override
    public String getFailReason() {
        return "";
    }
}

