/*
 * Decompiled with CFR 0.152.
 */
package controller.globalCommands;

import controller.globalCommands.Center;
import controller.globalCommands.EnableActionManager;
import controller.globalCommands.ICommand;
import controller.globalCommands.Undo;
import java.awt.Window;
import java.util.List;
import javax.swing.JFrame;
import org.ctom.hulis.files.gaussian.ReadGaussian;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.exception.CoupleException;
import org.ctom.hulis.huckel.exception.IMethodException;
import org.ctom.hulis.huckel.exception.MesomeryNoStructureLocalizedException;
import org.ctom.hulis.huckel.exception.SelectionException;
import org.ctom.hulis.huckel.methods.IMethod;
import util.io.SwingIO;
import views.FrameApp;
import views.IMesomeryReference;
import views.IStructureReference;

public class ReadGaussianCommand
implements ICommand {
    FrameApp app;
    ReadGaussian readGaussian;
    private boolean succeed;
    private String failReason;

    public ReadGaussianCommand(FrameApp app, ReadGaussian readGaussian) {
        this.app = app;
        this.readGaussian = readGaussian;
        this.succeed = false;
        this.failReason = "";
    }

    @Override
    public void execute() {
        try {
            SwingIO.log(this.getClass().getName(), "execute", "read gaussian");
            this.app.getStateManager().initNewState();
            Mesomery mesomery = new Mesomery(this.readGaussian);
            mesomery.setCloneResultsCacheWhenCloneMesomery(false);
            List<IMethod> lstCurrentSelectedMethods = this.app.getListSelectedMethods();
            this.app.deselectAllMethods();
            mesomery.setStructureSelector(this.app.getCurrentMesomery().getStructureSelector());
            this.app.getCurrentMesomeryView().setMesomery(mesomery);
            mesomery.addListener(this.app.getToolBarHuckel());
            mesomery.addListener(this.app.getStateManager());
            this.app.getToolBarMesomery().setMesomery(mesomery);
            Window[] windowArray = JFrame.getWindows();
            int n = windowArray.length;
            int n2 = 0;
            while (n2 < n) {
                Window r = windowArray[n2];
                if (r instanceof IMesomeryReference) {
                    IMesomeryReference mr = (IMesomeryReference)((Object)r);
                    mr.setMesomery(mesomery);
                } else if (r instanceof IStructureReference) {
                    r.dispose();
                }
                ++n2;
            }
            this.app.getCurrentMesomeryView().rebuild();
            EnableActionManager.getInstance().updateActionsToEnable(this.app);
            this.app.getToolBarHuckel().refresh();
            this.app.getToolBarMesomery().refresh();
            this.succeed = true;
            for (IMethod method : lstCurrentSelectedMethods) {
                this.app.selectMethod(method.getName(), true);
            }
            mesomery.setSelectionTreshold(mesomery.getStructureSelector().getMaximalValue());
            mesomery.setSelectionTreshold(mesomery.getStructureSelector().getMaximalValue());
            new Center(this.app.getCurrentMesomeryView()).execute();
            SwingIO.log(this.getClass().getName(), "execute", "reading gaussian was successful");
            this.app.getStateManager().saveState();
        }
        catch (CoupleException | IMethodException | MesomeryNoStructureLocalizedException | SelectionException e) {
            this.failReason = e.getMessage();
            e.printStackTrace();
        }
        catch (Exception e) {
            this.failReason = e.getMessage();
            e.printStackTrace();
            try {
                new Undo(this.app).execute();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public boolean isSucceed() {
        return this.succeed;
    }

    @Override
    public String getFailReason() {
        return this.failReason;
    }
}

