/*
 * Decompiled with CFR 0.152.
 */
package controller.globalCommands;

import controller.globalCommands.Center;
import controller.globalCommands.EnableActionManager;
import controller.globalCommands.ICommand;
import org.ctom.hulis.files.xyz.GeometryReader;
import org.ctom.hulis.huckel.exception.BondException;
import org.ctom.hulis.huckel.exception.CoupleException;
import org.ctom.hulis.huckel.exception.HuckelBondException;
import org.ctom.hulis.huckel.exception.IMethodException;
import org.ctom.hulis.huckel.exception.MesomeryDelocalizedStructureExistsException;
import org.ctom.hulis.huckel.exception.MesomeryNoStructureLocalizedException;
import org.ctom.hulis.huckel.exception.MoleculeBondExistsException;
import org.ctom.hulis.huckel.exception.MoleculeCoherenceException;
import org.ctom.hulis.huckel.exception.MoleculeTooManyNeighboursException;
import org.ctom.hulis.huckel.structures.StructureDelocalized;
import util.io.SwingIO;
import views.FrameApp;

public class ReadXMLCommand
implements ICommand {
    FrameApp app;
    GeometryReader xyz;

    public ReadXMLCommand(FrameApp app, GeometryReader xyz) {
        this.app = app;
        this.xyz = xyz;
    }

    @Override
    public void execute() {
        SwingIO.log(this.getClass().getName(), "execute", "read xml");
        try {
            this.app.getStateManager().initNewState();
            this.app.getCurrentMesomeryView().getMesomery().deleteAllStructures();
            this.app.getCurrentMesomeryView().getMesomery().addDelocalizedStruct(new StructureDelocalized(this.xyz));
            EnableActionManager.getInstance().updateActionsToEnable(this.app);
        }
        catch (CoupleException e) {
            SwingIO.error(this.getClass().getName(), "execute", e.getMessage(), e);
            SwingIO.reportError(this.app);
        }
        catch (IMethodException e) {
            SwingIO.error(this.getClass().getName(), "execute", e.getMessage(), e);
            SwingIO.reportError(this.app);
        }
        catch (MesomeryNoStructureLocalizedException e) {
            SwingIO.error(this.getClass().getName(), "execute", e.getMessage(), e);
            SwingIO.reportError(this.app);
        }
        catch (HuckelBondException e) {
            SwingIO.error(this.getClass().getName(), "execute", e.getMessage(), e);
            SwingIO.reportError(this.app);
        }
        catch (BondException e) {
            SwingIO.error(this.getClass().getName(), "execute", e.getMessage(), e);
            SwingIO.reportError(this.app);
        }
        catch (MesomeryDelocalizedStructureExistsException e) {
            SwingIO.error(this.getClass().getName(), "execute", e.getMessage(), e);
            SwingIO.reportError(this.app);
        }
        catch (MoleculeTooManyNeighboursException e) {
            SwingIO.error(this.getClass().getName(), "execute", e.getMessage(), e);
            SwingIO.reportError(this.app);
        }
        catch (MoleculeCoherenceException e) {
            SwingIO.error(this.getClass().getName(), "execute", e.getMessage(), e);
            SwingIO.reportError(this.app);
        }
        catch (MoleculeBondExistsException e) {
            SwingIO.error(this.getClass().getName(), "execute", e.getMessage(), e);
            SwingIO.reportError(this.app);
        }
        catch (Exception e) {
            SwingIO.error(this.getClass().getName(), "execute", "cannot create delocalized structure", e);
            SwingIO.reportError(this.app);
        }
        new Center(this.app.getCurrentMesomeryView()).execute();
        this.app.getStateManager().saveState();
    }

    @Override
    public boolean isSucceed() {
        return true;
    }

    @Override
    public String getFailReason() {
        return "";
    }
}

