/*
 * Decompiled with CFR 0.152.
 */
package controller.globalCommands;

import controller.globalCommands.Center;
import controller.globalCommands.EnableActionManager;
import controller.globalCommands.ICommand;
import controller.globalCommands.Undo;
import org.ctom.hulis.files.xyz.GeometryReader;
import org.ctom.hulis.files.xyz.ReadxyzException;
import org.ctom.hulis.huckel.exception.BondException;
import org.ctom.hulis.huckel.exception.CoupleException;
import org.ctom.hulis.huckel.exception.HuckelBondException;
import org.ctom.hulis.huckel.exception.IMethodException;
import org.ctom.hulis.huckel.exception.MesomeryDelocalizedStructureExistsException;
import org.ctom.hulis.huckel.exception.MesomeryNoStructureLocalizedException;
import org.ctom.hulis.huckel.exception.MoleculeBondExistsException;
import org.ctom.hulis.huckel.exception.MoleculeCoherenceException;
import org.ctom.hulis.huckel.exception.MoleculeTooManyNeighboursException;
import org.ctom.hulis.huckel.structures.StructureDelocalized;
import util.io.SwingIO;
import views.FrameApp;

public class ReadXYZCommand
implements ICommand {
    FrameApp app;
    GeometryReader xyz;
    boolean succeed;
    private String failReason;

    public ReadXYZCommand(FrameApp app, GeometryReader xyz) {
        this.app = app;
        this.xyz = xyz;
        this.succeed = false;
        this.failReason = "";
    }

    @Override
    public void execute() {
        SwingIO.log(this.getClass().getName(), "execute", "try to read xyz");
        try {
            this.app.getStateManager().initNewState();
            StructureDelocalized structureDelocalized = new StructureDelocalized(this.xyz);
            SwingIO.PrintIf("delete structures  in read XYZ Command");
            this.app.getCurrentMesomeryView().getMesomery().deleteAllStructures();
            this.app.getCurrentMesomeryView().getMesomery().addDelocalizedStruct(structureDelocalized);
            EnableActionManager.getInstance().updateActionsToEnable(this.app);
            this.app.getToolBarHuckel().refresh();
            new Center(this.app.getCurrentMesomeryView()).execute();
            this.app.getStateManager().saveState();
            this.succeed = true;
            SwingIO.log(this.getClass().getName(), "execute", "reading xyz was successful");
        }
        catch (CoupleException e) {
            SwingIO.error(this.getClass().getName(), "execute", e.getMessage(), e);
            this.failReason = e.getMessage();
        }
        catch (IMethodException e) {
            SwingIO.error(this.getClass().getName(), "execute", e.getMessage(), e);
            this.failReason = e.getMessage();
        }
        catch (MesomeryNoStructureLocalizedException e) {
            SwingIO.error(this.getClass().getName(), "execute", e.getMessage(), e);
            this.failReason = e.getMessage();
        }
        catch (HuckelBondException e) {
            SwingIO.error(this.getClass().getName(), "execute", e.getMessage(), e);
            this.failReason = e.getMessage();
        }
        catch (BondException e) {
            SwingIO.error(this.getClass().getName(), "execute", e.getMessage(), e);
            this.failReason = e.getMessage();
        }
        catch (MesomeryDelocalizedStructureExistsException e) {
            SwingIO.error(this.getClass().getName(), "execute", e.getMessage(), e);
            this.failReason = e.getMessage();
        }
        catch (MoleculeTooManyNeighboursException e) {
            SwingIO.error(this.getClass().getName(), "execute", e.getMessage(), e);
            this.failReason = e.getMessage();
        }
        catch (MoleculeCoherenceException e) {
            SwingIO.error(this.getClass().getName(), "execute", e.getMessage(), e);
            this.failReason = e.getMessage();
        }
        catch (MoleculeBondExistsException e) {
            SwingIO.error(this.getClass().getName(), "execute", e.getMessage(), e);
            this.failReason = e.getMessage();
        }
        catch (ReadxyzException e) {
            e.printStackTrace();
            this.failReason = e.getMessage();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.failReason = e.getMessage();
            try {
                new Undo(this.app).execute();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public String getFailReason() {
        return this.failReason;
    }

    @Override
    public boolean isSucceed() {
        return this.succeed;
    }
}

