/*
 * Decompiled with CFR 0.152.
 */
package controller.globalCommands;

import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.Bond;
import org.ctom.hulis.huckel.Molecule;
import org.ctom.hulis.huckel.exception.BondException;
import org.ctom.hulis.huckel.exception.HuckelBondException;
import org.ctom.hulis.huckel.exception.MoleculeAtomNullException;
import org.ctom.hulis.huckel.exception.MoleculeBondExistsException;
import org.ctom.hulis.huckel.exception.MoleculeCoherenceException;
import org.ctom.hulis.huckel.exception.MoleculeTooManyNeighboursException;
import org.ctom.hulis.util.geometry.CovalentRadii;
import org.ctom.util.maths.VecteurCTOM;

public class ReplaceAtom {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplaceAtom(Molecule m, Atom old, Atom newAtom) throws HuckelBondException, BondException, MoleculeAtomNullException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        ReplaceAtom replaceAtom = this;
        synchronized (replaceAtom) {
            if (old.countNeighboursExcludingH() <= 1) {
                Bond bondNonH = old.getBonds().get(0);
                Atom linkedAtom = bondNonH.getAtomLinkedWith(old);
                double covalentNew = 0.0;
                double covalentLinked = 0.0;
                covalentNew = newAtom.getElement() == null ? CovalentRadii.C.getCovRad() : newAtom.getCovalentRadius();
                covalentLinked = linkedAtom.getElement() == null ? CovalentRadii.C.getCovRad() : linkedAtom.getCovalentRadius();
                double distAB = (covalentNew + covalentLinked) * 50.0;
                VecteurCTOM v = new VecteurCTOM(linkedAtom.getLocation(), old.getLocation());
                old.translate(v.times(-1.0));
                v.renormEquals(distAB);
                old.translate(v);
            }
            m.replaceAtom(old, newAtom);
        }
    }
}

