/*
 * Decompiled with CFR 0.152.
 */
package controller.globalCommands;

import controller.globalCommands.ICommand;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.ctom.hulis.files.xml.XMLConstants;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.comparators.MethodNameComparator;
import org.ctom.hulis.huckel.methods.IMethod;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import org.ctom.util.maths.Maths;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import util.io.SwingIO;

public class SaveMesomeryToXML
implements XMLConstants,
ICommand {
    public static final int precision = 2;
    Mesomery mesomery;
    File out;

    public SaveMesomeryToXML(Mesomery mesomery, File out) throws FileNotFoundException, IOException {
        this.mesomery = mesomery;
        this.out = out;
    }

    @Override
    public void execute() throws IOException {
        SwingIO.log(this.getClass().getName(), "execute", "save mesomery to xml");
        Element racine = new Element("mesomery");
        for (Structure s : this.mesomery.getAllStructures()) {
            Element elemStruct = new Element("structure");
            Element elemType = new Element("type");
            elemType.setText(s.getClass().getName());
            elemStruct.addContent(elemType);
            Element elemEnergy = new Element("energy");
            Element elemAlpha = new Element("alpha");
            elemAlpha.setText(String.valueOf(Maths.round(s.getTotalEnergy().getAlpha(), 2)));
            Element elemBeta = new Element("beta");
            elemBeta.setText(String.valueOf(Maths.round(s.getTotalEnergy().getBeta(), 2)));
            elemEnergy.addContent(elemAlpha);
            elemEnergy.addContent(elemBeta);
            elemStruct.addContent(elemEnergy);
            if (s instanceof StructureLocalized) {
                IMethod[] mmethods = this.mesomery.getMethods();
                Arrays.sort(mmethods, new MethodNameComparator());
                IMethod[] iMethodArray = mmethods;
                int n = mmethods.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod method = iMethodArray[n2];
                    Element elemWeight = new Element("weight");
                    elemWeight.setText(String.valueOf(Maths.round(((StructureLocalized)s).getWeight(method.getName()), 2)));
                    Attribute classe = new Attribute("method", method.getName());
                    elemWeight.setAttribute(classe);
                    elemStruct.addContent(elemWeight);
                    ++n2;
                }
            }
            racine.addContent(elemStruct);
        }
        Document document = new Document(racine);
        XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat());
        try {
            sortie.output(document, (OutputStream)new FileOutputStream(this.out));
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    @Override
    public boolean isSucceed() {
        return true;
    }

    @Override
    public String getFailReason() {
        return "";
    }
}

