/*
 * Decompiled with CFR 0.152.
 */
package controller.globalCommands;

import controller.globalCommands.ActionStopConsumingProcess;
import java.util.Hashtable;
import javax.swing.undo.StateEdit;
import javax.swing.undo.StateEditable;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.events.BlocDelocalizedEvent;
import org.ctom.hulis.huckel.events.HuckelAtomEvent;
import org.ctom.hulis.huckel.events.HuckelBondEvent;
import org.ctom.hulis.huckel.events.MesomeryEvent;
import org.ctom.hulis.huckel.events.MoleculeEvent;
import org.ctom.hulis.huckel.events.MonoExcitationEvent;
import org.ctom.hulis.huckel.events.StructureDelocalizedEvent;
import org.ctom.hulis.huckel.events.StructureEvent;
import org.ctom.hulis.huckel.events.StructureLocalizedEvent;
import org.ctom.hulis.huckel.exception.CoupleException;
import org.ctom.hulis.huckel.exception.IMethodException;
import org.ctom.hulis.huckel.exception.IncorrectNumberPiElectronsException;
import org.ctom.hulis.huckel.exception.MesomeryNoStructureLocalizedException;
import org.ctom.hulis.huckel.listeners.IMesomeryListener;
import org.ctom.hulis.huckel.structures.Structure;
import util.MyJOptionPane;
import util.io.SwingIO;
import views.FrameApp;

public class StateManager
implements StateEditable,
IMesomeryListener {
    public static final int OBJECT_STRATEGY = 0;
    public static final int GAUSSIAN_STRATEGY = 1;
    public static final int SAVE_STRATEGY = 0;
    public static final boolean DISABLE_UNDO_REDO = false;
    public static final int OUT_OF_MEMORY_NB_STRUCTURES = 400;
    public static final int OUT_OF_MEMORY_MAX_STORE_STATE = 2;
    public static final int MAX_STORE_STATE = 40;
    UndoableEditSupport undoableEditSupport;
    UndoManager undoManager;
    FrameApp app;
    StateEdit stateEdit;

    public StateManager(FrameApp app) {
        this.app = app;
        this.undoableEditSupport = new UndoableEditSupport();
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(40);
        this.undoableEditSupport.addUndoableEditListener(this.undoManager);
    }

    public void initNewState() {
        this.stateEdit = new StateEdit(this);
    }

    public void saveState() {
        this.stateEdit.end();
        this.undoableEditSupport.postEdit(this.stateEdit);
    }

    public void undo() {
        this.undoManager.undo();
    }

    public void redo() {
        this.undoManager.redo();
    }

    @Override
    public void storeState(Hashtable<Object, Object> state) {
        Mesomery mesomeryClone = (Mesomery)this.app.getCurrentMesomery().clone();
        if (mesomeryClone != null) {
            state.put("mesomery", mesomeryClone);
        }
        if (this.app.getCurrentMesomeryView().getCurrentStructure() == null) {
            state.put("currentStructureName", "tot");
        } else {
            state.put("currentStructureName", this.app.getCurrentMesomeryView().getCurrentStructure().getName());
        }
        state.put("selectedCommand", this.app.getCurrentEnabledCommand());
    }

    @Override
    public void restoreState(Hashtable<?, ?> state) {
        try {
            String currentStructureName = "";
            currentStructureName = state.get("currentStructureName") != null ? (String)state.get("currentStructureName") : (this.app.getCurrentMesomeryView().getCurrentStructure() != null ? this.app.getCurrentMesomeryView().getCurrentStructure().getName() : "tot");
            String selectedCommand = "";
            selectedCommand = state.get("selectedCommand") != null ? (String)state.get("selectedCommand") : this.app.getCurrentEnabledCommand();
            final Mesomery m = state.get("mesomery") != null ? (Mesomery)((Mesomery)state.get("mesomery")).clone() : this.app.getCurrentMesomery();
            if (!m.isCloneResultsCacheWhenCloneMesomery() && m.isEnabledFlyCalculate()) {
                for (Structure s : m.getAllStructures()) {
                    if (s.isCloneResultsCacheWhenCloneStructure()) continue;
                    s.calculate();
                }
                Thread stop = ActionStopConsumingProcess.stopCalculateWeights(this.app);
                stop.join();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            m.calculate();
                        }
                        catch (IncorrectNumberPiElectronsException e) {
                            e.printStackTrace();
                        }
                        catch (IMethodException e) {
                            e.printStackTrace();
                        }
                        catch (MesomeryNoStructureLocalizedException e) {
                            e.printStackTrace();
                        }
                        catch (CoupleException e) {
                            e.printStackTrace();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            m.stopConsumingProcess();
                            m.forceAutoGenerating(false);
                            m.forceCalculatingWeights(false);
                            SwingIO.error(this.getClass().getName(), "restoreState", "mesomery compute error when restore state", e);
                            MyJOptionPane.showMessageDialog(StateManager.this.app, "Unexpected compute error during undo/redo operation", "Error", 0);
                        }
                    }
                }).start();
            }
            this.app.setMesomery(m, currentStructureName, selectedCommand);
        }
        catch (Exception e) {
            SwingIO.error(this.getClass().getName(), "restoreState", e.getMessage(), e);
        }
    }

    public void updateStorageLimit(Mesomery mesomery) {
        double coeffdirecteur = -0.095;
        double origine = 40.0;
        int limit = (int)((double)mesomery.countAllSructs() * coeffdirecteur + origine);
        this.undoManager.setLimit(limit);
    }

    @Override
    public void structureDelocalizedSpinChanged(StructureDelocalizedEvent event) {
    }

    @Override
    public void structureNameChanged(StructureEvent event) {
    }

    @Override
    public void moleculeDeleted(MoleculeEvent e) {
    }

    @Override
    public void moleculeAtomAdded(MoleculeEvent e) {
    }

    @Override
    public void moleculeAtomRemoved(MoleculeEvent e) {
    }

    @Override
    public void moleculeAtomReplaced(MoleculeEvent e) {
    }

    @Override
    public void moleculeBondAdded(MoleculeEvent e) {
    }

    @Override
    public void moleculeBondRemoved(MoleculeEvent e) {
    }

    @Override
    public void moleculeChargeChanged(MoleculeEvent event) {
    }

    @Override
    public void moleculeListHuckelAtomSeqNumAutoSetted(MoleculeEvent event) {
    }

    @Override
    public void moleculeListHuckelAtomSeqNumReset(MoleculeEvent event) {
    }

    @Override
    public void moleculeBlocDelocalizedAdded(MoleculeEvent event) {
    }

    @Override
    public void moleculeBlocDelocalizedRemoved(MoleculeEvent event) {
    }

    @Override
    public void huckelAtomHxChanged(HuckelAtomEvent e) {
    }

    @Override
    public void huckelAtomSeqNumChanged(HuckelAtomEvent e) {
    }

    @Override
    public void huckelAtomRadRChanged(HuckelAtomEvent e) {
    }

    @Override
    public void huckelBondHxyChanged(HuckelBondEvent e) {
    }

    @Override
    public void huckelBondBondTypeChanged(HuckelBondEvent e) {
    }

    @Override
    public void blocDelocalizedHuckelObjectAdded(BlocDelocalizedEvent e) {
    }

    @Override
    public void blocDelocalizedHuckelObjectRemoved(BlocDelocalizedEvent e) {
    }

    @Override
    public void blocDelocalizedNbElectronsChanged(BlocDelocalizedEvent e) {
    }

    @Override
    public void monoExcitationTriggered(MonoExcitationEvent e) {
    }

    @Override
    public void structureLocalizedWeightChanged(StructureLocalizedEvent event) {
    }

    @Override
    public void structureLocalizedCoupleChanged(StructureLocalizedEvent event) {
    }

    @Override
    public void structureLocalizedCoupleRemoved(StructureLocalizedEvent event) {
    }

    @Override
    public void mesomeryListWeightCalculated(MesomeryEvent e) {
    }

    @Override
    public void mesomeryStructuresSelectionTresholdChanged(MesomeryEvent e) {
    }

    @Override
    public void mesomeryStructureAdded(MesomeryEvent e) {
        this.updateStorageLimit(e.getSource());
    }

    @Override
    public void mesomeryStructureRemoved(MesomeryEvent e) {
        this.updateStorageLimit(e.getSource());
    }

    @Override
    public void mesomeryMethodAdded(MesomeryEvent e) {
    }

    @Override
    public void mesomeryMethodRemoved(MesomeryEvent e) {
    }

    @Override
    public void mesomeryExceptionOccured(MesomeryEvent e, Exception exception) {
    }

    @Override
    public void mesomeryStartComputeWeights(MesomeryEvent event) {
    }

    @Override
    public void mesomeryStructuresSelectorChanged(MesomeryEvent event) {
    }
}

