/*
 * Decompiled with CFR 0.152.
 */
package controller.graphOM;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.ctom.hulis.huckel.MonoExcitation;
import org.ctom.hulis.huckel.OrbitaleMoleculaire;
import org.ctom.hulis.huckel.SpinOrbitaleMoleculaire;
import org.ctom.hulis.prefs.Preferences;
import util.MyResourceBundle;
import util.io.SwingIO;
import util.languages.LanguageManager;
import views.GraphOM;
import views.OrbitalControl;

public class GraphOMController
implements MouseListener,
MouseMotionListener {
    public static final boolean ALLOW_EXCITATIONS = false;
    GraphOM graphOM;
    private MonoExcitation excitation = null;
    private SpinOrbitaleMoleculaire som_ex;

    public GraphOMController(GraphOM graphOM) {
        this.graphOM = graphOM;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        SwingIO.log(this.getClass().getName(), "mouseClicked", "graph MO click");
        Point p = e.getPoint();
        this.graphOM.setToolTipText(null);
        this.graphOM.setEOrbSelected(null);
        OrbitaleMoleculaire sav = this.graphOM.getStructureView().getShownOrbital();
        this.graphOM.getStructureView().setShownOrbital(null);
        for (OrbitalControl ec : this.graphOM.getOrbitalControls()) {
            if (!ec.contains(p)) continue;
            if (sav == ec.getOM()) {
                this.graphOM.setEOrbSelected(null);
                this.graphOM.getStructureView().setShownOrbital(null);
                break;
            }
            this.graphOM.setEOrbSelected(ec.getOM());
            this.graphOM.getStructureView().setShownOrbital(ec.getOM());
            break;
        }
        this.graphOM.repaint();
        this.graphOM.getStructureView().repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        this.graphOM.setToolTipText(null);
        for (OrbitalControl ec : this.graphOM.getOrbitalControls()) {
            if (!ec.contains(p)) continue;
            MyResourceBundle bundle = LanguageManager.getInstance().getResource("SkelMouseController");
            this.graphOM.setToolTipText("<html><p style=\"font-family: 'Arial';font-size: 10;\">" + ec.getOM().toHtml() + "</p></html>");
            break;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        SwingIO.log(this.getClass().getName(), "mousePressed", "graph MO press");
        if (Preferences.DISPLAY_ORBITAL == Preferences.DISPLAY_ORBITAL_TYPE.CANONICAL) {
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        SwingIO.log(this.getClass().getName(), "mouseReleased", "graph MO release");
        System.out.print("Excitation END\n");
    }
}

