/*
 * Decompiled with CFR 0.152.
 */
package controller.structureViewController;

import controller.globalCommands.EnableActionManager;
import controller.globalCommands.ReplaceAtom;
import controller.structureViewController.IStructureViewControllerState;
import controller.structureViewController.StructureViewController;
import java.awt.Toolkit;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.HuckelAtom;
import org.ctom.hulis.huckel.PeriodicTable;
import org.ctom.hulis.huckel.exception.BondException;
import org.ctom.hulis.huckel.exception.HuckelBondException;
import org.ctom.hulis.huckel.exception.MoleculeAtomNullException;
import org.ctom.hulis.huckel.exception.MoleculeBondExistsException;
import org.ctom.hulis.huckel.exception.MoleculeCoherenceException;
import org.ctom.hulis.huckel.exception.MoleculeTooManyNeighboursException;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import org.ctom.util.maths.Point3D;
import util.MyResourceBundle;
import util.io.SwingIO;
import util.languages.LanguageManager;
import views.BondDrawer;
import views.FrameApp;
import views.Selection;
import views.StructureView;

public class AddState
implements IStructureViewControllerState {
    private Atom atomToLink = null;

    @Override
    public void mouseClicked(StructureViewController structureViewController, Point2D p) {
        Structure structure = structureViewController.getStructure();
        StructureView structureView = structureViewController.getStructureView();
        FrameApp app = structureView.getMesomeryView().getFrameApp();
        Point3D p3d = structureView.getPoint3D(structureView.getAntecedentPoint(p));
        if (!(structure instanceof StructureLocalized)) {
            Atom a = structureView.getAtom(p);
            if (a != null) {
                if (a.getElement() == PeriodicTable.Element.H) {
                    try {
                        app.getStateManager().initNewState();
                        HuckelAtom carbon = (HuckelAtom)PeriodicTable.getNewAtom(PeriodicTable.Entry.C);
                        SwingIO.log(this.getClass().getName(), "mouseClicked", "replace " + a + " by " + carbon);
                        new ReplaceAtom(structure, a, carbon);
                        EnableActionManager.getInstance().updateActionsToEnable(app);
                        app.getStateManager().saveState();
                    }
                    catch (HuckelBondException e) {
                        SwingIO.error(this.getClass().getName(), "mouseClicked", e.getMessage(), e);
                        SwingIO.reportError(app);
                    }
                    catch (BondException e) {
                        SwingIO.error(this.getClass().getName(), "mouseClicked", e.getMessage(), e);
                        SwingIO.reportError(app);
                    }
                    catch (MoleculeAtomNullException e) {
                        SwingIO.error(this.getClass().getName(), "mouseClicked", e.getMessage(), e);
                        SwingIO.reportError(app);
                    }
                    catch (MoleculeTooManyNeighboursException e) {
                        SwingIO.error(this.getClass().getName(), "mouseClicked", e.getMessage(), e);
                        SwingIO.reportError(app);
                    }
                    catch (MoleculeCoherenceException e) {
                        SwingIO.error(this.getClass().getName(), "mouseClicked", e.getMessage(), e);
                        SwingIO.reportError(app);
                    }
                    catch (MoleculeBondExistsException e) {
                        SwingIO.error(this.getClass().getName(), "mouseClicked", e.getMessage(), e);
                        SwingIO.reportError(app);
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else {
                try {
                    app.getStateManager().initNewState();
                    Atom atom = structure.createNewAtom(PeriodicTable.Entry.C, p3d);
                    SwingIO.log(this.getClass().getName(), "mouseClicked", "create atom " + (HuckelAtom)atom);
                    EnableActionManager.getInstance().updateActionsToEnable(app);
                    app.getStateManager().saveState();
                }
                catch (HuckelBondException e) {
                    SwingIO.error(this.getClass().getName(), "mouseClicked", e.getMessage(), e);
                    SwingIO.reportError(app);
                }
                catch (BondException e) {
                    SwingIO.error(this.getClass().getName(), "mouseClicked", e.getMessage(), e);
                    SwingIO.reportError(app);
                }
                catch (MoleculeTooManyNeighboursException e) {
                    SwingIO.error(this.getClass().getName(), "mouseClicked", e.getMessage(), e);
                    SwingIO.reportError(app);
                }
                catch (MoleculeCoherenceException e) {
                    SwingIO.error(this.getClass().getName(), "mouseClicked", e.getMessage(), e);
                    SwingIO.reportError(app);
                }
                catch (MoleculeBondExistsException e) {
                    SwingIO.error(this.getClass().getName(), "mouseClicked", e.getMessage(), e);
                    SwingIO.reportError(app);
                }
            }
        }
    }

    @Override
    public void mouseDragged(StructureViewController structureViewController, Point2D p) {
        Structure structure = structureViewController.getStructure();
        StructureView structureView = structureViewController.getStructureView();
        FrameApp app = structureView.getMesomeryView().getFrameApp();
        Point3D p3d = structureView.getPoint3D(structureView.getAntecedentPoint(p));
        if (this.atomToLink == null && structureView.getAtom(p) == null) {
            try {
                app.getStateManager().initNewState();
                SwingIO.log(this.getClass().getName(), "mouseDragged", "create C in dragging");
                this.atomToLink = structure.createNewAtom(PeriodicTable.Entry.C, p3d);
                EnableActionManager.getInstance().updateActionsToEnable(app);
                app.getStateManager().saveState();
            }
            catch (HuckelBondException e) {
                SwingIO.error(this.getClass().getName(), "mouseClicked", e.getMessage(), e);
                SwingIO.reportError(app);
            }
            catch (BondException e) {
                SwingIO.error(this.getClass().getName(), "mouseClicked", e.getMessage(), e);
                SwingIO.reportError(app);
            }
            catch (MoleculeTooManyNeighboursException e) {
                SwingIO.error(this.getClass().getName(), "mouseClicked", e.getMessage(), e);
                SwingIO.reportError(app);
            }
            catch (MoleculeCoherenceException e) {
                SwingIO.error(this.getClass().getName(), "mouseClicked", e.getMessage(), e);
                SwingIO.reportError(app);
            }
            catch (MoleculeBondExistsException e) {
                SwingIO.error(this.getClass().getName(), "mouseClicked", e.getMessage(), e);
                SwingIO.reportError(app);
            }
        }
        Line2D.Double ligne = new Line2D.Double(structureView.getImagePoint(structureView.getPoint2D(this.atomToLink.getLocation())), p);
        structureView.setSelection(new Selection(ligne, BondDrawer.BOND_COLOR, 3.0f));
        structureView.repaint();
    }

    @Override
    public void mouseEntered(StructureViewController structureViewController, Point2D p) {
    }

    @Override
    public void mouseExited(StructureViewController structureViewController, Point2D p) {
    }

    @Override
    public void mouseMoved(StructureViewController structureViewController, Point2D p) {
    }

    @Override
    public void mousePressed(StructureViewController structureViewController, Point2D p) {
        StructureView structureView = structureViewController.getStructureView();
        if (structureViewController.getStructure() instanceof StructureLocalized) {
            return;
        }
        Atom a = structureView.getAtom(p);
        if (this.atomToLink == null && a != null) {
            this.atomToLink = a;
        }
    }

    @Override
    public void mouseReleased(StructureViewController structureViewController, Point2D p) {
        MyResourceBundle bundle = LanguageManager.getInstance().getResource("SkelMouseController");
        StructureView structureView = structureViewController.getStructureView();
        Structure structure = structureViewController.getStructure();
        FrameApp app = structureView.getMesomeryView().getFrameApp();
        Point3D p3d = structureView.getPoint3D(structureView.getAntecedentPoint(p));
        if (this.atomToLink != null) {
            Atom a = structureView.getAtom(p);
            if (a != null) {
                if (!structure.areLinked(this.atomToLink, a)) {
                    if (!structure.isNbNeighboursMaxReachedExcludingH(this.atomToLink) && !structure.isNbNeighboursMaxReachedExcludingH(a)) {
                        try {
                            app.getStateManager().initNewState();
                            SwingIO.log(this.getClass().getName(), "mouseReleased", "create bond between " + this.atomToLink + " and " + a);
                            structure.createNewBond(this.atomToLink, a);
                            app.getStateManager().saveState();
                        }
                        catch (BondException bondException) {
                        }
                        catch (MoleculeTooManyNeighboursException e) {
                            SwingIO.error(this.getClass().getName(), "mouseReleased", e.getMessage(), e);
                            SwingIO.reportError(app);
                        }
                        catch (MoleculeCoherenceException e) {
                            SwingIO.error(this.getClass().getName(), "mouseReleased", e.getMessage(), e);
                            SwingIO.reportError(app);
                        }
                        catch (MoleculeBondExistsException e) {
                            SwingIO.error(this.getClass().getName(), "mouseReleased", e.getMessage(), e);
                            SwingIO.reportError(app);
                        }
                    } else {
                        structureView.getMesomeryView().getFrameApp().getStatusBar().setTxtState(bundle.getString("ktoomanyneighbours2"));
                    }
                }
            } else if (!structure.isNbNeighboursMaxReachedExcludingH(this.atomToLink)) {
                try {
                    app.getStateManager().initNewState();
                    boolean savCalcFly = structure.isEnabledFlyCalculate();
                    structure.stopFlyCalculate();
                    structure.setEnabledNotify(false);
                    SwingIO.log(this.getClass().getName(), "mouseReleased", "create atom C");
                    Atom to = structure.createNewAtom(PeriodicTable.Entry.C, p3d);
                    structure.setEnabledFlyCalculate(savCalcFly);
                    structure.setEnabledNotify(true);
                    SwingIO.log(this.getClass().getName(), "mouseReleased", "create bond between" + this.atomToLink + " and new atom" + to);
                    structure.createNewBond(this.atomToLink, to);
                }
                catch (HuckelBondException e) {
                    SwingIO.error(this.getClass().getName(), "mouseReleased", e.getMessage(), e);
                    SwingIO.reportError(app);
                }
                catch (BondException e) {
                    SwingIO.error(this.getClass().getName(), "mouseReleased", e.getMessage(), e);
                    SwingIO.reportError(app);
                }
                catch (MoleculeTooManyNeighboursException e) {
                    SwingIO.error(this.getClass().getName(), "mouseReleased", e.getMessage(), e);
                    SwingIO.reportError(app);
                }
                catch (MoleculeCoherenceException e) {
                    SwingIO.error(this.getClass().getName(), "mouseReleased", e.getMessage(), e);
                    SwingIO.reportError(app);
                }
                catch (MoleculeBondExistsException e) {
                    SwingIO.error(this.getClass().getName(), "mouseReleased", e.getMessage(), e);
                    SwingIO.reportError(app);
                }
                app.getStateManager().saveState();
            } else {
                structureView.getMesomeryView().getFrameApp().getStatusBar().setTxtState(bundle.getString("ktoomanyneighbours2"));
            }
            this.atomToLink = null;
            structureView.setSelection(null);
            structureView.repaint();
        }
    }
}

