/*
 * Decompiled with CFR 0.152.
 */
package controller.structureViewController;

import controller.globalCommands.ActionEndBloc;
import controller.structureViewController.IStructureViewControllerState;
import controller.structureViewController.StructureViewController;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.ctom.hulis.huckel.BlocDelocalized;
import org.ctom.hulis.huckel.IHuckelObject;
import org.ctom.hulis.huckel.IMoleculeComponent;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.exception.BlocDelocalizedException;
import org.ctom.hulis.huckel.exception.CoupleException;
import org.ctom.hulis.huckel.exception.IMethodException;
import org.ctom.hulis.huckel.exception.IncorrectNumberPiElectronsException;
import org.ctom.hulis.huckel.exception.MesomeryNoStructureLocalizedException;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import org.ctom.util.maths.Point3D;
import util.io.SwingIO;
import views.DialogChangeBloc;
import views.Selection;
import views.StructureView;

public class BlocState
implements IStructureViewControllerState {
    Point2D pRectBegin = null;
    Point2D pRectEnd = null;
    BlocDelocalized currentBlocDelocalized = null;
    boolean savStructCalculateFly;
    boolean savMesomeryCalculateFly;
    private boolean startSelectRect = false;

    @Override
    public void mouseClicked(StructureViewController structureViewController, Point2D p) {
        IHuckelObject huckelObject;
        if (!ActionEndBloc.checkCurrentBlocInCurrentStructure(structureViewController.getStructureView().getMesomeryView().getFrameApp())) {
            return;
        }
        SwingIO.log(this.getClass().getName(), "mouseClicked", "create or modify bloc");
        StructureView structureView = structureViewController.getStructureView();
        StructureLocalized structure = (StructureLocalized)structureViewController.getStructure();
        System.out.println("debut clicked PSi" + structure.getName() + ", " + this.currentBlocDelocalized);
        Point3D p3d = structureView.getPoint3D(p);
        IMoleculeComponent component = structureView.getMoleculeComponent(p);
        this.currentBlocDelocalized = StructureView.getSelectedBlocDelocalized();
        if (this.currentBlocDelocalized == null) {
            BlocDelocalized blocSelect = structureView.getBlocDelocalized(p);
            if (blocSelect != null) {
                SwingIO.log(this.getClass().getName(), "mouseClicked", "open dialog change bloc");
                new DialogChangeBloc(structureView, structureView.getMousePointerLocationOrRelativeCoordinatesOnScreeen(p3d), blocSelect).setVisible(true);
                return;
            }
            if (!(component instanceof IHuckelObject)) {
                return;
            }
            this.currentBlocDelocalized = new BlocDelocalized();
            StructureView.setSelectedBlocDelocalized(this.currentBlocDelocalized);
            structure.addBlocDelocalized(this.currentBlocDelocalized);
        }
        if ((huckelObject = (IHuckelObject)component).getBlocDelocalizedParent() == null) {
            SwingIO.log(this.getClass().getName(), "mouseClicked", "add " + huckelObject + " in block");
            try {
                this.currentBlocDelocalized.addHuckelObject(huckelObject);
            }
            catch (BlocDelocalizedException e) {
                e.printStackTrace();
            }
        } else if (this.currentBlocDelocalized == huckelObject.getBlocDelocalizedParent()) {
            SwingIO.log(this.getClass().getName(), "mouseClicked", "remove " + huckelObject + " from block");
            this.currentBlocDelocalized.removeHuckelObject(huckelObject);
        }
        System.out.println("fin clicked PSi" + structure.getName() + ", " + this.currentBlocDelocalized);
    }

    @Override
    public void mouseDragged(StructureViewController structureViewController, Point2D p) {
        if (!ActionEndBloc.checkCurrentBlocInCurrentStructure(structureViewController.getStructureView().getMesomeryView().getFrameApp())) {
            return;
        }
        SwingIO.log(this.getClass().getName(), "mouseDragged", "drag to select multiple element to add in a block");
        StructureView structureView = structureViewController.getStructureView();
        StructureLocalized structure = (StructureLocalized)structureViewController.getStructure();
        this.pRectEnd = p;
        double zoom = structureView.getZoom();
        double x = this.pRectBegin.getX();
        double y = this.pRectBegin.getY();
        double width = this.pRectEnd.getX() - this.pRectBegin.getX();
        double height = this.pRectEnd.getY() - this.pRectBegin.getY();
        if (width < 0.0) {
            x += width;
        }
        if (height < 0.0) {
            y += height;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, Math.abs(width), Math.abs(height));
        Selection selection = new Selection(rect, StructureView.SELECTED_BLOC_DELOCALIZED_COLOR, 2.0f);
        structureView.setSelection(selection);
        this.currentBlocDelocalized = StructureView.getSelectedBlocDelocalized();
        if (this.currentBlocDelocalized != null && this.startSelectRect) {
            this.currentBlocDelocalized.empty();
        }
        for (IHuckelObject o : structure.getHuckelObjects()) {
            Point2D p2d = structureView.getImagePoint(structureView.getPoint2D(o.getLocation()));
            x = p2d.getX();
            y = p2d.getY();
            if (!((Rectangle2D)selection.getShape()).contains(x, y) || o.getBlocDelocalizedParent() != null) continue;
            this.startSelectRect = true;
            if (this.currentBlocDelocalized == null) {
                this.currentBlocDelocalized = new BlocDelocalized();
                StructureView.setSelectedBlocDelocalized(this.currentBlocDelocalized);
                structure.addBlocDelocalized(this.currentBlocDelocalized);
            }
            SwingIO.log(this.getClass().getName(), "mouseDragged", "add " + o + " in block");
            try {
                this.currentBlocDelocalized.addHuckelObject(o);
            }
            catch (BlocDelocalizedException e) {
                e.printStackTrace();
            }
        }
        this.currentBlocDelocalized.setNbElectron(this.currentBlocDelocalized.getSumAtomsNbElecPi());
        structureView.repaint();
    }

    @Override
    public void mouseEntered(StructureViewController structureViewController, Point2D p) {
    }

    @Override
    public void mouseExited(StructureViewController structureViewController, Point2D p) {
    }

    @Override
    public void mouseMoved(StructureViewController structureViewController, Point2D p) {
        StructureView structureView = structureViewController.getStructureView();
        structureView.setOverflightBlocDelocalized(null);
        structureView.repaint();
        BlocDelocalized bloc = structureView.getBlocDelocalized(p);
        if (bloc != null) {
            structureView.setOverflightBlocDelocalized(bloc);
            structureView.repaint();
        }
    }

    @Override
    public void mousePressed(StructureViewController structureViewController, Point2D p) {
        SwingIO.log(this.getClass().getName(), "mousePressed", "try to select multiple element to add in a block");
        Structure structure = structureViewController.getStructure();
        this.savStructCalculateFly = structure.isEnabledFlyCalculate();
        Mesomery mesomery = structure.getMesomeryParent();
        if (mesomery != null) {
            this.savMesomeryCalculateFly = mesomery.isEnabledFlyCalculate();
        }
        if (structure != null) {
            structure.stopFlyCalculate();
        }
        if (mesomery != null) {
            mesomery.stopFlyCalculate();
        }
        this.pRectBegin = p;
    }

    @Override
    public void mouseReleased(StructureViewController structureViewController, Point2D p) {
        Mesomery mesomery;
        SwingIO.log(this.getClass().getName(), "mouseReleased", "end multiple selection : recalculate weights, etc...");
        StructureView structureView = structureViewController.getStructureView();
        Structure structure = structureViewController.getStructure();
        if (structure != null && this.savStructCalculateFly) {
            structure.startFlyCalculate();
            if (this.currentBlocDelocalized != null) {
                structure.calculate();
            }
        }
        if ((mesomery = structure.getMesomeryParent()) != null && this.savMesomeryCalculateFly) {
            mesomery.startFlyCalculate();
            try {
                if (this.currentBlocDelocalized != null) {
                    mesomery.calculate();
                }
            }
            catch (IncorrectNumberPiElectronsException e) {
                e.printStackTrace();
            }
            catch (IMethodException e) {
                e.printStackTrace();
            }
            catch (MesomeryNoStructureLocalizedException e) {
                e.printStackTrace();
            }
            catch (CoupleException e) {
                e.printStackTrace();
            }
        }
        structureView.setSelection(null);
        this.pRectBegin = null;
        this.pRectEnd = null;
        this.startSelectRect = false;
        structureView.repaint();
    }
}

