/*
 * Decompiled with CFR 0.152.
 */
package controller.structureViewController;

import controller.structureViewController.IStructureViewControllerState;
import controller.structureViewController.StructureViewController;
import java.awt.Point;
import java.awt.geom.Point2D;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.Bond;
import org.ctom.hulis.huckel.HuckelBond;
import org.ctom.hulis.huckel.IMoleculeComponent;
import util.MyResourceBundle;
import util.ThreadUtils;
import util.io.SwingIO;
import util.languages.LanguageManager;
import views.DialogChangeAtom;
import views.DialogChangeHuckelBond;
import views.FrameApp;
import views.MyJDialog;
import views.StructureView;

public class ChangeState
implements IStructureViewControllerState {
    @Override
    public void mouseClicked(StructureViewController structureViewController, Point2D p) {
        StructureView structureView = structureViewController.getStructureView();
        MyResourceBundle bundle = LanguageManager.getInstance().getResource("SkelMouseController");
        IMoleculeComponent moleculeComponent = structureView.getMoleculeComponent(p);
        if (moleculeComponent == null) {
            return;
        }
        FrameApp app = structureView.getMesomeryView().getFrameApp();
        Point pos = structureView.getMousePointerLocationOrRelativeCoordinatesOnScreeen(moleculeComponent.getLocation());
        try {
            MyJDialog dialog;
            if (moleculeComponent instanceof Atom) {
                SwingIO.log(this.getClass().getName(), "mouseClicked", "open dialog box to change atom : " + (Atom)moleculeComponent);
                dialog = new DialogChangeAtom(app, pos, (Atom)moleculeComponent);
                ThreadUtils.invokeAsSoonAsPossible(new Runnable((DialogChangeAtom)dialog){
                    private final /* synthetic */ DialogChangeAtom val$dialog;
                    {
                        this.val$dialog = dialogChangeAtom;
                    }

                    @Override
                    public void run() {
                        this.val$dialog.requestFocusInWindow();
                    }
                });
                dialog.setModal();
                dialog.setVisible(true);
            }
            if (moleculeComponent instanceof HuckelBond) {
                SwingIO.log(this.getClass().getName(), "mouseClicked", "open dialog box to change bond " + (HuckelBond)moleculeComponent);
                dialog = new DialogChangeHuckelBond(app, pos, (HuckelBond)moleculeComponent);
                ThreadUtils.invokeAsSoonAsPossible(new Runnable((DialogChangeHuckelBond)dialog){
                    private final /* synthetic */ DialogChangeHuckelBond val$dialog;
                    {
                        this.val$dialog = dialogChangeHuckelBond;
                    }

                    @Override
                    public void run() {
                        this.val$dialog.requestFocusInWindow();
                    }
                });
                dialog.setModal();
                dialog.setVisible(true);
            }
            if (moleculeComponent instanceof Bond) {
                app.getStatusBar().setTxtState(bundle.getString("changeHBond"));
            }
        }
        catch (Exception e) {
            SwingIO.error(this.getClass().getName(), "changeMolecule", e.getMessage(), e);
            SwingIO.reportError(app);
        }
    }

    @Override
    public void mouseDragged(StructureViewController structureViewController, Point2D p) {
    }

    @Override
    public void mouseEntered(StructureViewController structureViewController, Point2D p) {
    }

    @Override
    public void mouseExited(StructureViewController structureViewController, Point2D p) {
    }

    @Override
    public void mouseMoved(StructureViewController structureViewController, Point2D p) {
    }

    @Override
    public void mousePressed(StructureViewController structureViewController, Point2D p) {
    }

    @Override
    public void mouseReleased(StructureViewController structureViewController, Point2D p) {
    }
}

