/*
 * Decompiled with CFR 0.152.
 */
package controller.structureViewController;

import controller.globalCommands.ActionStopConsumingProcess;
import controller.structureViewController.IStructureViewControllerState;
import controller.structureViewController.StructureViewController;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.CoupleLocal;
import org.ctom.hulis.huckel.HuckelAtom;
import org.ctom.hulis.huckel.exception.CoupleException;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import util.io.SwingIO;
import views.FrameApp;
import views.Selection;
import views.StructureView;

public class CoupleState
implements IStructureViewControllerState {
    private HuckelAtom atomToCouple = null;

    @Override
    public void mouseClicked(StructureViewController structureViewController, Point2D p) {
    }

    @Override
    public void mouseDragged(StructureViewController structureViewController, Point2D p) {
        StructureView structureView = structureViewController.getStructureView();
        if (this.atomToCouple == null) {
            return;
        }
        Line2D.Double ligne = new Line2D.Double(structureView.getImagePoint(structureView.getPoint2D(this.atomToCouple.getLocation())), p);
        structureView.setSelection(new Selection(ligne, StructureView.COUPLE_COLOR, 3.0f));
        structureView.repaint();
    }

    @Override
    public void mouseEntered(StructureViewController structureViewController, Point2D p) {
    }

    @Override
    public void mouseExited(StructureViewController structureViewController, Point2D p) {
    }

    @Override
    public void mouseMoved(StructureViewController structureViewController, Point2D p) {
    }

    @Override
    public void mousePressed(StructureViewController structureViewController, Point2D p) {
        StructureView structureView = structureViewController.getStructureView();
        FrameApp app = structureView.getMesomeryView().getFrameApp();
        Atom a = structureView.getAtom(p);
        if (!(a instanceof HuckelAtom)) {
            return;
        }
        final HuckelAtom huckelAtom = (HuckelAtom)a;
        final Structure structure = structureViewController.getStructure();
        if (structure instanceof StructureLocalized && this.atomToCouple == null && a != null && huckelAtom.getNbRadR() == 1) {
            SwingIO.log(this.getClass().getName(), "mousePressed", "remove current couple");
            if (structure.getMesomeryParent() != null && structure.getMesomeryParent().isCalculatingWeights()) {
                Thread stop = ActionStopConsumingProcess.stopCalculateWeights(app);
                try {
                    stop.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    StructureLocalized s = (StructureLocalized)structure;
                    s.removeCouple();
                    CoupleState.this.atomToCouple = huckelAtom;
                }
            }).start();
        }
    }

    @Override
    public void mouseReleased(StructureViewController structureViewController, Point2D p) {
        block5: {
            final StructureView structureView = structureViewController.getStructureView();
            final FrameApp app = structureView.getMesomeryView().getFrameApp();
            try {
                if (this.atomToCouple == null) break block5;
                Structure structure = structureViewController.getStructure();
                Atom a = structureView.getAtom(p);
                if (a != null) {
                    StructureLocalized s;
                    if (!(a instanceof HuckelAtom)) {
                        structureView.setSelection(null);
                        this.atomToCouple = null;
                        structureView.repaint();
                        return;
                    }
                    final HuckelAtom hAt = (HuckelAtom)a;
                    if (structure instanceof StructureLocalized && hAt.getNbRadR() == 1 && !(s = (StructureLocalized)structure).areCoupled(this.atomToCouple, hAt) && this.atomToCouple != hAt) {
                        SwingIO.log(this.getClass().getName(), "mouseReleased", "create couple between " + this.atomToCouple + " and " + hAt);
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    System.out.println("atomToCouple" + CoupleState.this.atomToCouple);
                                    System.out.println("autre " + hAt);
                                    structureView.setSelection(null);
                                    s.setCouple(new CoupleLocal(CoupleState.this.atomToCouple, hAt));
                                    CoupleState.this.atomToCouple = null;
                                }
                                catch (CoupleException e) {
                                    SwingIO.error(this.getClass().getName(), "mouseReleased", e.getMessage(), e);
                                    SwingIO.reportError(app);
                                }
                                catch (Exception e) {
                                    SwingIO.error(this.getClass().getName(), "mouseReleased", e.getMessage(), e);
                                    SwingIO.reportError(app);
                                }
                            }
                        }).start();
                    }
                    break block5;
                }
                structureView.setSelection(null);
                this.atomToCouple = null;
                structureView.repaint();
                return;
            }
            catch (Exception e) {
                SwingIO.error(this.getClass().getName(), "coupleTo", e.getMessage(), e);
                SwingIO.reportError(app);
            }
        }
    }
}

