/*
 * Decompiled with CFR 0.152.
 */
package controller.structureViewController;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.Bond;
import org.ctom.hulis.huckel.IHuckelObject;
import views.StructureView;

public class GhostMolecule {
    private ArrayList<Atom> lstAtoms;
    private ArrayList<Bond> lstBonds;
    private Point2D mousePosition;
    private Point2D offset;

    public GhostMolecule(StructureView structureView, Point2D mousePosition) {
        structureView.setGhost(this);
        this.mousePosition = mousePosition;
        this.lstAtoms = new ArrayList();
        this.lstBonds = new ArrayList();
    }

    public boolean add(IHuckelObject o) {
        if (o instanceof Bond) {
            return this.lstBonds.add((Bond)((Object)o));
        }
        if (o instanceof Atom) {
            return this.lstAtoms.add((Atom)((Object)o));
        }
        return false;
    }

    public ArrayList<Bond> getBonds() {
        return this.lstBonds;
    }

    public ArrayList<Atom> getAtoms() {
        return this.lstAtoms;
    }

    public Point2D getOffset() {
        this.setOffset();
        return this.offset;
    }

    private void setOffset() {
        this.offset = new Point2D.Double(this.mousePosition.getX() - this.lstAtoms.get(0).getX(), this.mousePosition.getY() - this.lstAtoms.get(0).getY());
    }
}

