/*
 * Decompiled with CFR 0.152.
 */
package controller.structureViewController;

import controller.structureViewController.IStructureViewControllerState;
import controller.structureViewController.StructureViewController;
import java.awt.geom.Point2D;
import org.ctom.hulis.huckel.Atom;
import org.ctom.util.maths.Point3D;
import util.io.SwingIO;
import views.FrameApp;
import views.MesomeryView;
import views.StructureView;

public class MoveState
implements IStructureViewControllerState {
    Atom atomToMove = null;
    Point2D moleculeMoveFrom = null;

    @Override
    public void mouseClicked(StructureViewController structureViewController, Point2D p) {
    }

    @Override
    public void mouseDragged(StructureViewController structureViewController, Point2D p) {
        StructureView structureView = structureViewController.getStructureView();
        Point3D p3d = structureView.getPoint3D(structureView.getAntecedentPoint(p));
        if (this.atomToMove != null) {
            SwingIO.log(this.getClass().getName(), "mouseDragged", "move atom " + this.atomToMove);
            this.atomToMove.setLocation(p3d);
            structureView.repaint();
        } else if (this.moleculeMoveFrom != null) {
            SwingIO.log(this.getClass().getName(), "mouseDragged", "move molecule");
            double dx = p.getX() - this.moleculeMoveFrom.getX();
            double dy = p.getY() - this.moleculeMoveFrom.getY();
            MesomeryView mesomeryView = structureView.getMesomeryView();
            structureView.getMesomeryView().setXMargin(structureView.getXMargin() + dx);
            structureView.getMesomeryView().setYMargin(structureView.getYMargin() + dy);
            this.moleculeMoveFrom = p;
            mesomeryView.refresh();
        }
    }

    @Override
    public void mouseEntered(StructureViewController structureViewController, Point2D p) {
    }

    @Override
    public void mouseExited(StructureViewController structureViewController, Point2D p) {
    }

    @Override
    public void mouseMoved(StructureViewController structureViewController, Point2D p) {
    }

    @Override
    public void mousePressed(StructureViewController structureViewController, Point2D p) {
        StructureView structureView = structureViewController.getStructureView();
        FrameApp app = structureView.getMesomeryView().getFrameApp();
        app.getStateManager().initNewState();
        Atom a = structureView.getAtom(p);
        if (a != null) {
            this.atomToMove = a;
        } else {
            this.moleculeMoveFrom = p;
        }
    }

    @Override
    public void mouseReleased(StructureViewController structureViewController, Point2D p) {
        StructureView structureView = structureViewController.getStructureView();
        FrameApp app = structureView.getMesomeryView().getFrameApp();
        this.atomToMove = null;
        this.moleculeMoveFrom = null;
        app.getStateManager().saveState();
    }
}

