/*
 * Decompiled with CFR 0.152.
 */
package controller.structureViewController;

import controller.structureViewController.IStructureViewControllerState;
import controller.structureViewController.StructureViewController;
import java.awt.geom.Point2D;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.util.maths.Point3D;
import org.ctom.util.maths.Rotation;
import org.ctom.util.maths.VecteurCTOM;
import util.io.SwingIO;
import views.FrameApp;
import views.StructureView;

public class RotateState
implements IStructureViewControllerState {
    Point2D rotateFrom = null;

    @Override
    public void mouseClicked(StructureViewController structureViewController, Point2D p) {
    }

    @Override
    public void mouseDragged(StructureViewController structureViewController, Point2D p) {
        SwingIO.log(this.getClass().getName(), "mouseDragged", "drag to rotate molecule");
        StructureView structureView = structureViewController.getStructureView();
        Point3D pOrigin = structureView.getPoint3D(this.rotateFrom);
        Point3D pDestination = structureView.getPoint3D(p);
        Structure structure = structureViewController.getStructure();
        Point3D imageCenter3D = structureView.getPoint3D(structureView.getImagePoint(structureView.getPoint2D(structure.getCenter())));
        VecteurCTOM CO = new VecteurCTOM(imageCenter3D, pOrigin);
        VecteurCTOM CD = new VecteurCTOM(imageCenter3D, pDestination);
        double sensAngle = Math.signum(CO.getCrossProduct(CD).getZ());
        double angle = CD.getAngle(CO);
        if (!Double.isNaN(angle) && !Double.isNaN(sensAngle) && angle != 0.0 && sensAngle != 0.0) {
            structure.rotate(Rotation.getRotationZ(angle * sensAngle));
            structureView.repaint();
        }
        this.rotateFrom = p;
    }

    @Override
    public void mouseEntered(StructureViewController structureViewController, Point2D p) {
    }

    @Override
    public void mouseExited(StructureViewController structureViewController, Point2D p) {
    }

    @Override
    public void mouseMoved(StructureViewController structureViewController, Point2D p) {
    }

    @Override
    public void mousePressed(StructureViewController structureViewController, Point2D p) {
        StructureView structureView = structureViewController.getStructureView();
        FrameApp app = structureView.getMesomeryView().getFrameApp();
        app.getStateManager().initNewState();
        this.rotateFrom = p;
    }

    @Override
    public void mouseReleased(StructureViewController structureViewController, Point2D p) {
        StructureView structureView = structureViewController.getStructureView();
        FrameApp app = structureView.getMesomeryView().getFrameApp();
        this.rotateFrom = p;
        app.getStateManager().saveState();
    }
}

