/*
 * Decompiled with CFR 0.152.
 */
package controller.structureViewController;

import controller.structureViewController.IStructureViewControllerState;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.ctom.hulis.huckel.HuckelAtom;
import org.ctom.hulis.huckel.IHuckelObject;
import org.ctom.hulis.huckel.IMoleculeComponent;
import org.ctom.hulis.huckel.OrbitaleAtomique;
import org.ctom.hulis.huckel.OrbitaleMoleculaire;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.symmetry.Symmetry;
import org.ctom.hulis.prefs.Preferences;
import views.FrameApp;
import views.OrbitalDrawer;
import views.StructureView;

public class StructureViewController
implements MouseListener,
MouseMotionListener {
    StructureView structureView;
    Structure structure;

    public StructureViewController(StructureView structureView, Structure structure) {
        this.structureView = structureView;
        this.structure = structure;
    }

    public StructureView getStructureView() {
        return this.structureView;
    }

    public Structure getStructure() {
        return this.structure;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        FrameApp app = this.structureView.getMesomeryView().getFrameApp();
        IStructureViewControllerState state = app.getCurrentStructureViewControllerState();
        if (state != null) {
            state.mouseClicked(this, e.getPoint());
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        FrameApp app = this.structureView.getMesomeryView().getFrameApp();
        IStructureViewControllerState state = app.getCurrentStructureViewControllerState();
        if (state != null) {
            state.mouseDragged(this, e.getPoint());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        FrameApp app = this.structureView.getMesomeryView().getFrameApp();
        IStructureViewControllerState state = app.getCurrentStructureViewControllerState();
        if (state != null) {
            state.mouseEntered(this, e.getPoint());
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        FrameApp app = this.structureView.getMesomeryView().getFrameApp();
        IStructureViewControllerState state = app.getCurrentStructureViewControllerState();
        if (state != null) {
            state.mouseExited(this, e.getPoint());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        this.setToolTipText(p);
        this.showSymmetryInfo(p);
        FrameApp app = this.structureView.getMesomeryView().getFrameApp();
        IStructureViewControllerState state = app.getCurrentStructureViewControllerState();
        if (state != null) {
            state.mouseMoved(this, p);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        FrameApp app = this.structureView.getMesomeryView().getFrameApp();
        IStructureViewControllerState state = app.getCurrentStructureViewControllerState();
        if (state != null) {
            state.mousePressed(this, e.getPoint());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        FrameApp app = this.structureView.getMesomeryView().getFrameApp();
        IStructureViewControllerState state = app.getCurrentStructureViewControllerState();
        if (state != null) {
            state.mouseReleased(this, e.getPoint());
        }
    }

    public void setToolTipText(Point2D p) {
        Structure structure = this.structureView.getStructure();
        String tooltipText = "";
        tooltipText = "<html><p style=\"font-family: 'Arial';font-size: 10;\">";
        if (this.structureView.getShownOrbital() != null) {
            OrbitaleAtomique[] orbs = structure.getOAs();
            OrbitaleMoleculaire spinOrb = this.structureView.getShownOrbital();
            int size = orbs.length;
            OrbitaleAtomique orb = null;
            double coeff = 0.0;
            boolean found = false;
            int i2 = 0;
            while (i2 < size) {
                orb = orbs[i2];
                coeff = spinOrb.getCoeff(i2);
                if (new OrbitalDrawer(this.structureView, orb, coeff).isContained(p)) {
                    found = true;
                    break;
                }
                ++i2;
            }
            if (orb != null && found) {
                HuckelAtom a = orb.getHuckelAtom();
                tooltipText = String.valueOf(tooltipText) + "C<sub>" + a.toString() + "</sub> = " + FrameApp.form2.format(coeff);
                if (Preferences.DISPLAY_ORBITAL == Preferences.DISPLAY_ORBITAL_TYPE.NATURAL) {
                    tooltipText = String.valueOf(tooltipText) + " c2: " + FrameApp.form2.format(coeff * coeff);
                }
                tooltipText = String.valueOf(tooltipText) + "<p></html>";
                this.structureView.setToolTipText(tooltipText);
            } else {
                this.structureView.setToolTipText(null);
            }
        } else {
            IMoleculeComponent component = this.structureView.getMoleculeComponent(p);
            if (component != null) {
                tooltipText = String.valueOf(tooltipText) + component.toString();
                if (component instanceof IHuckelObject) {
                    IHuckelObject huckelobj = (IHuckelObject)component;
                    tooltipText = String.valueOf(tooltipText) + "<br>" + huckelobj.getNameParamHuckelHTML() + " = " + huckelobj.getParamHuckel();
                }
                tooltipText = String.valueOf(tooltipText) + "<p></html>";
                this.structureView.setToolTipText(tooltipText);
            } else {
                this.structureView.setToolTipText(null);
            }
        }
    }

    public void showSymmetryInfo(Point2D p) {
        Structure structure = this.structureView.getStructure();
        Point2D pTransformed = this.structureView.getAntecedentPoint(p);
        IMoleculeComponent component = this.structureView.getMoleculeComponent(pTransformed);
        if (component != null && component instanceof HuckelAtom) {
            Symmetry sym = structure.getSymmetry();
            HuckelAtom atom = (HuckelAtom)component;
            ArrayList<Integer> list = sym.getGroupOfAtom(atom);
            this.structureView.setAtomsToHighlight(list);
        }
    }
}

