/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.Regression;
import flanagan.analysis.Stat;
import flanagan.math.ArrayMaths;
import flanagan.math.MaximizationFunction;

class BoxCoxFunction
implements MaximizationFunction {
    public double[] shiftedData = null;
    public int nData = 0;
    public double[] yTransform = null;
    public double[] gaussianOrderMedians = null;
    public Regression reg = null;
    public ArrayMaths am = null;
    public Stat st = null;

    BoxCoxFunction() {
    }

    @Override
    public double function(double[] dArray) {
        int n;
        if (dArray[0] == 0.0) {
            for (n = 0; n < this.nData; ++n) {
                this.yTransform[n] = Math.log(this.shiftedData[n]);
            }
        } else {
            for (n = 0; n < this.nData; ++n) {
                this.yTransform[n] = (Math.pow(this.shiftedData[n], dArray[0]) - 1.0) / dArray[0];
            }
        }
        this.am = new ArrayMaths(this.yTransform);
        this.am = this.am.sort();
        double[] dArray2 = this.am.array();
        this.st = new Stat(dArray2);
        this.yTransform = this.st.standardize();
        this.reg = new Regression(this.gaussianOrderMedians, this.yTransform);
        this.reg.linear();
        return this.reg.getSampleR();
    }
}

