/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.interpolation.CubicSpline;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Matrix;
import flanagan.plot.PlotGraph;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;

public class CurveSmooth {
    private double[] xData = null;
    private double[] yData = null;
    private BigDecimal[] xBDdata = null;
    private BigDecimal[] yBDdata = null;
    private int nPoints = 0;
    private boolean arbprec = false;
    private double[] yDataMovAv = null;
    private BigDecimal[] yDataMovAvBD = null;
    private double[] yDataSavGol = null;
    private double[] yDataSavGolFirst = null;
    private double[] yDataSavGolSecond = null;
    private double[] yDataSavGolNth = null;
    private int lastMethod = 0;
    private int nMethods = 2;
    private int lastPlotMethod = 0;
    private int maWindowWidth = 0;
    private int sgWindowWidth = 0;
    private int sgPolyDeg = 4;
    private double[] derivSavGol = null;
    private int sgDerivOrderUsed = 0;
    private boolean calcSavGol = false;
    private boolean calcMovAv = false;
    private boolean firstDeriv = false;
    private boolean secondDeriv = false;
    private boolean nthSet = false;
    private double[][] sgArrayC = null;
    private double[] sgCoeff = null;
    private double extentMovAv = -1.0;
    private double extentSavGol = -1.0;
    private ArrayList<Double> almin = new ArrayList();
    private ArrayList<Double> almax = new ArrayList();
    private ArrayList<BigDecimal> alminBD = new ArrayList();
    private ArrayList<BigDecimal> almaxBD = new ArrayList();
    private double[][][] minima = null;
    private double[][][] maxima = null;
    private BigDecimal[][][] minimaBD = null;
    private BigDecimal[][][] maximaBD = null;
    private int[] nMin = null;
    private int[] nMax = null;
    private boolean[] minimaCalc = null;
    private boolean[] maximaCalc = null;
    private CubicSpline csSavGol = null;
    private CubicSpline csMovAv = null;

    public CurveSmooth(double[] dArray, double[] dArray2) {
        this.xData = dArray;
        this.yData = dArray2;
        this.check();
        this.ascend();
    }

    public CurveSmooth(double[] dArray) {
        int n = dArray.length;
        this.yData = dArray;
        this.xData = new double[n];
        for (int j = 0; j < n; ++j) {
            this.xData[j] = j;
        }
        this.check();
    }

    public CurveSmooth(float[] fArray, float[] fArray2) {
        ArrayMaths arrayMaths = new ArrayMaths(fArray);
        this.xData = arrayMaths.array();
        arrayMaths = new ArrayMaths(fArray2);
        this.yData = arrayMaths.array();
        this.check();
        this.ascend();
    }

    public CurveSmooth(float[] fArray) {
        int n = fArray.length;
        this.yData = new double[n];
        this.xData = new double[n];
        for (int j = 0; j < n; ++j) {
            this.xData[j] = j;
            this.yData[j] = fArray[j];
        }
        this.check();
    }

    public CurveSmooth(long[] lArray, long[] lArray2) {
        ArrayMaths arrayMaths = new ArrayMaths(lArray);
        this.xData = arrayMaths.array();
        arrayMaths = new ArrayMaths(lArray2);
        this.yData = arrayMaths.array();
        this.check();
        this.ascend();
    }

    public CurveSmooth(long[] lArray) {
        int n = lArray.length;
        this.yData = new double[n];
        this.xData = new double[n];
        for (int j = 0; j < n; ++j) {
            this.xData[j] = j;
            this.yData[j] = lArray[j];
        }
        this.check();
    }

    public CurveSmooth(int[] nArray, int[] nArray2) {
        ArrayMaths arrayMaths = new ArrayMaths(nArray);
        this.xData = arrayMaths.array();
        arrayMaths = new ArrayMaths(nArray2);
        this.yData = arrayMaths.array();
        this.check();
        this.ascend();
    }

    public CurveSmooth(int[] nArray) {
        int n = nArray.length;
        this.yData = new double[n];
        this.xData = new double[n];
        for (int j = 0; j < n; ++j) {
            this.xData[j] = j;
            this.yData[j] = nArray[j];
        }
        this.check();
    }

    public CurveSmooth(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2) {
        this.arbprec = true;
        this.xBDdata = bigDecimalArray;
        this.yBDdata = bigDecimalArray2;
        ArrayMaths arrayMaths = new ArrayMaths(bigDecimalArray);
        this.xData = arrayMaths.array();
        arrayMaths = new ArrayMaths(bigDecimalArray2);
        this.yData = arrayMaths.array();
        this.check();
        this.ascend();
    }

    public CurveSmooth(BigDecimal[] bigDecimalArray) {
        this.arbprec = true;
        int n = bigDecimalArray.length;
        this.yData = new double[n];
        this.xData = new double[n];
        this.yBDdata = new BigDecimal[n];
        this.xBDdata = new BigDecimal[n];
        for (int j = 0; j < n; ++j) {
            this.xData[j] = j;
            this.yData[j] = bigDecimalArray[j].doubleValue();
            String string = new Integer(j).toString();
            this.xBDdata[j] = new BigDecimal(string);
            this.yBDdata[j] = bigDecimalArray[j];
        }
        this.check();
    }

    public CurveSmooth(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        this.arbprec = true;
        int n = bigIntegerArray.length;
        this.xBDdata = new BigDecimal[n];
        this.yBDdata = new BigDecimal[n];
        for (int j = 0; j < n; ++j) {
            this.xBDdata[j] = new BigDecimal(bigIntegerArray[j]);
            this.yBDdata[j] = new BigDecimal(bigIntegerArray2[j]);
        }
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        this.xData = arrayMaths.array();
        arrayMaths = new ArrayMaths(bigIntegerArray2);
        this.yData = arrayMaths.array();
        this.check();
        this.ascend();
    }

    public CurveSmooth(BigInteger[] bigIntegerArray) {
        this.arbprec = true;
        int n = bigIntegerArray.length;
        this.yData = new double[n];
        this.xData = new double[n];
        this.yBDdata = new BigDecimal[n];
        this.xBDdata = new BigDecimal[n];
        for (int j = 0; j < n; ++j) {
            this.xData[j] = j;
            this.yData[j] = bigIntegerArray[j].doubleValue();
            String string = new Double(j).toString();
            this.xBDdata[j] = new BigDecimal(string);
            this.yBDdata[j] = new BigDecimal(bigIntegerArray[j]);
        }
        this.check();
    }

    public CurveSmooth(ArrayMaths arrayMaths, ArrayMaths arrayMaths2) {
        this.xData = arrayMaths.array();
        this.yData = arrayMaths2.array();
        String[] stringArray = arrayMaths2.originalArrayTypes();
        int n = 0;
        int n2 = stringArray.length;
        for (int j = 0; j < stringArray.length; ++j) {
            if (!stringArray[j].equals("BigDecimal") && !stringArray[j].equals("BigInteger")) continue;
            ++n;
        }
        if (n == n2) {
            this.arbprec = true;
            this.yBDdata = arrayMaths2.array_as_BigDecimal();
        }
        this.xData = new double[n2];
        this.xBDdata = arrayMaths.array_as_BigDecimal();
        this.check();
        this.ascend();
    }

    public CurveSmooth(ArrayMaths arrayMaths) {
        int n;
        this.yData = arrayMaths.array();
        String[] stringArray = arrayMaths.originalArrayTypes();
        int n2 = 0;
        int n3 = stringArray.length;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals("BigDecimal") && !stringArray[n].equals("BigInteger")) continue;
            ++n2;
        }
        if (n2 == n3) {
            this.arbprec = true;
            this.yBDdata = arrayMaths.array_as_BigDecimal();
        }
        this.xData = new double[n3];
        if (this.arbprec) {
            this.xBDdata = new BigDecimal[n3];
        }
        for (n = 0; n < n3; ++n) {
            this.xData[n] = n;
            if (!this.arbprec) continue;
            this.xBDdata[n] = new BigDecimal(new Integer(n).toString());
        }
        this.check();
    }

    private CurveSmooth() {
    }

    private void check() {
        int n;
        this.nPoints = this.xData.length;
        int n2 = this.yData.length;
        if (n2 != this.nPoints) {
            throw new IllegalArgumentException("The length of the x data array, " + this.nPoints + ", must be the same as the length of the y data array, " + n2);
        }
        if (n2 < 5) {
            throw new IllegalArgumentException("There must be at least five data points");
        }
        this.minima = new double[this.nMethods + 1][2][];
        this.maxima = new double[this.nMethods + 1][2][];
        this.minimaBD = new BigDecimal[this.nMethods + 1][2][];
        this.maximaBD = new BigDecimal[this.nMethods + 1][2][];
        this.nMin = new int[this.nMethods + 1];
        this.nMax = new int[this.nMethods + 1];
        this.minimaCalc = new boolean[this.nMethods + 1];
        this.maximaCalc = new boolean[this.nMethods + 1];
        for (n = 0; n < this.nMethods; ++n) {
            this.minimaCalc[n] = false;
            this.maximaCalc[n] = false;
        }
        if (!this.arbprec) {
            this.xBDdata = new BigDecimal[this.nPoints];
            for (n = 0; n < this.nPoints; ++n) {
                this.xBDdata[n] = new BigDecimal(new Double(this.xData[n]).toString());
            }
        }
    }

    private void ascend() {
        boolean bl = true;
        boolean bl2 = true;
        int n = 1;
        while (bl) {
            if (this.xData[n] < this.xData[n - 1]) {
                bl = false;
                bl2 = false;
                continue;
            }
            if (++n < this.nPoints) continue;
            bl = false;
        }
        if (!bl2) {
            int n2;
            ArrayMaths arrayMaths = new ArrayMaths(this.xData);
            arrayMaths = arrayMaths.sort();
            int[] nArray = arrayMaths.originalIndices();
            double[] dArray = new double[this.nPoints];
            double[] dArray2 = new double[this.nPoints];
            BigDecimal[] bigDecimalArray = new BigDecimal[this.nPoints];
            BigDecimal[] bigDecimalArray2 = null;
            if (this.arbprec) {
                bigDecimalArray2 = new BigDecimal[this.nPoints];
            }
            for (n2 = 0; n2 < this.nPoints; ++n2) {
                dArray[n2] = this.xData[nArray[n2]];
                dArray2[n2] = this.yData[nArray[n2]];
                bigDecimalArray[n2] = this.xBDdata[nArray[n2]];
                if (!this.arbprec) continue;
                bigDecimalArray2[n2] = this.yBDdata[nArray[n2]];
            }
            for (n2 = 0; n2 < this.nPoints; ++n2) {
                this.xData[n2] = dArray[n2];
                this.yData[n2] = dArray2[n2];
                this.xBDdata[n2] = bigDecimalArray[n2];
                if (!this.arbprec) continue;
                this.yBDdata[n2] = bigDecimalArray2[n2];
            }
        }
    }

    public double[] movingAverage(int n) {
        this.lastMethod = 1;
        this.lastPlotMethod = 1;
        this.yDataMovAv = new double[this.nPoints];
        this.yDataMovAvBD = new BigDecimal[this.nPoints];
        int n2 = this.windowHalf(n);
        this.maWindowWidth = 2 * n2 + 1;
        int n3 = 0;
        int n4 = 0;
        for (int j = 0; j < this.nPoints; ++j) {
            n3 = j >= n2 ? j - n2 : 0;
            n4 = j <= this.nPoints - n2 - 1 ? j + n2 : this.nPoints - 1;
            int n5 = n4 - n3 + 1;
            if (this.arbprec) {
                BigDecimal bigDecimal = new BigDecimal("0.0");
                for (int k = n3; k <= n4; ++k) {
                    bigDecimal = bigDecimal.add(this.yBDdata[k]);
                }
                String string = new Integer(n5).toString();
                this.yDataMovAvBD[j] = bigDecimal.divide(new BigDecimal(string), 4);
                this.yDataMovAv[j] = this.yDataMovAvBD[j].doubleValue();
                continue;
            }
            double d = 0.0;
            for (int k = n3; k <= n4; ++k) {
                d += this.yData[k];
            }
            this.yDataMovAv[j] = d / (double)n5;
            String string = new Double(this.yDataMovAv[j]).toString();
            this.yDataMovAvBD[j] = new BigDecimal(string);
        }
        this.csMovAv = new CubicSpline(this.xData, this.yDataMovAv);
        this.calcMovAv = true;
        return Conv.copy(this.yDataMovAv);
    }

    public double[] movingAveragePlot(int n) {
        double[] dArray = this.movingAverage(n);
        this.plot();
        return dArray;
    }

    public BigDecimal[] movingAverageAsBigDecimal(int n) {
        this.movingAverage(n);
        return Conv.copy(this.yDataMovAvBD);
    }

    public BigDecimal[] movingAverageAsBigDecimalPlot(int n) {
        this.movingAverageAsBigDecimal(n);
        this.plot();
        return Conv.copy(this.yDataMovAvBD);
    }

    private int windowHalf(int n) {
        int n2 = 0;
        n2 = Fmath.isEven(n) ? n / 2 : (n - 1) / 2;
        return n2;
    }

    private int windowLength(int n) {
        int n2 = 0;
        n2 = Fmath.isEven(n) ? n + 1 : n;
        return n2;
    }

    public double[] savitzkyGolay(int n) {
        this.lastMethod = 2;
        this.lastPlotMethod = 2;
        this.yDataSavGol = new double[this.nPoints];
        this.sgWindowWidth = this.windowLength(n);
        this.savitzkyGolayCommon(this.sgWindowWidth);
        this.csSavGol = new CubicSpline(this.xData, Conv.copy(this.yDataSavGol));
        this.calcSavGol = true;
        return Conv.copy(this.yDataSavGol);
    }

    private double[] savitzkyGolayCommon(int n) {
        int n2 = (n - 1) / 2;
        double[] dArray = this.savitzkyGolayFilter(n2, n2)[0];
        double[] dArray2 = this.padData(this.yData, n2);
        for (int j = n2; j < this.nPoints + n2; ++j) {
            double d = 0.0;
            int n3 = 0;
            for (int k = j - n2; k <= j + n2; ++k) {
                d += dArray2[k] * dArray[n3++];
            }
            this.yDataSavGol[j - n2] = d;
        }
        return this.yDataSavGol;
    }

    private double[] padData(double[] dArray, int n) {
        int n2;
        int n3 = dArray.length;
        double[] dArray2 = new double[n3 + 2 * n];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[n2 + n] = dArray[n2];
        }
        for (n2 = 0; n2 < n; ++n2) {
            dArray2[n2] = dArray2[n];
        }
        for (n2 = n3 + n; n2 < n3 + 2 * n; ++n2) {
            dArray2[n2] = dArray2[n3 + n - 1];
        }
        return dArray2;
    }

    public double[][] savitzkyGolayFilter(int n, int n2) {
        int n3 = n + n2 + 1;
        double[] dArray = new double[n3];
        int[] nArray = new int[n3];
        for (int j = 0; j < n3; ++j) {
            nArray[j] = j - n;
        }
        double[][] dArray2 = new double[n3][this.sgPolyDeg + 1];
        for (int j = 0; j < n3; ++j) {
            for (int k = 0; k < this.sgPolyDeg + 1; ++k) {
                dArray2[j][k] = Math.pow(nArray[j], k);
            }
        }
        Matrix matrix = new Matrix(dArray2);
        Matrix matrix2 = matrix.transpose();
        Matrix matrix3 = matrix2.times(matrix);
        Matrix matrix4 = matrix3.inverse();
        Matrix matrix5 = matrix4.times(matrix2);
        this.sgArrayC = matrix5.getArrayCopy();
        this.sgCoeff = this.sgArrayC[0];
        return this.sgArrayC;
    }

    public double[] savitzkyGolayPlot(int n) {
        double[] dArray = this.savitzkyGolay(n);
        this.plot();
        return dArray;
    }

    public double[][] savitzkyGolayPlusFirstDeriv(int n) {
        if (1 > this.sgPolyDeg) {
            throw new IllegalArgumentException("The derivative order, 1, must be less than or equal to the polynomial degree, " + this.sgPolyDeg + ".");
        }
        this.lastMethod = 2;
        this.lastPlotMethod = 3;
        double[][] dArray = this.savitzkyGolay(n, 1);
        this.yDataSavGolFirst = dArray[1];
        if (!this.nthSet) {
            this.yDataSavGolNth = dArray[1];
        }
        this.nthSet = true;
        this.firstDeriv = true;
        return dArray;
    }

    public double[][] savitzkyGolayPlusFirstDerivPlot(int n) {
        double[][] dArray = this.savitzkyGolayPlusFirstDeriv(n);
        this.plot();
        this.firstDeriv = true;
        return dArray;
    }

    public double[][] savitzkyGolayPlusSecondDeriv(int n) {
        if (2 > this.sgPolyDeg) {
            throw new IllegalArgumentException("The derivative order, 2, must be less than or equal to the polynomial degree, " + this.sgPolyDeg + ".");
        }
        this.lastMethod = 2;
        this.lastPlotMethod = 4;
        double[][] dArray = this.savitzkyGolay(n, 2);
        this.yDataSavGolSecond = dArray[1];
        if (!this.nthSet) {
            this.yDataSavGolNth = dArray[1];
        }
        this.nthSet = true;
        this.secondDeriv = true;
        return dArray;
    }

    public double[][] savitzkyGolayPlusSecondDerivPlot(int n) {
        double[][] dArray = this.savitzkyGolayPlusSecondDeriv(n);
        this.plot();
        this.secondDeriv = true;
        return dArray;
    }

    public double[][] savitzkyGolay(int n, int n2) {
        if (n2 > this.sgPolyDeg) {
            throw new IllegalArgumentException("The  derivative order " + n2 + ", must be less than or equal to the polynomial degree, " + this.sgPolyDeg + ".");
        }
        this.sgDerivOrderUsed = n2;
        double[][] dArray = new double[2][this.nPoints];
        this.sgWindowWidth = this.windowLength(n);
        int n3 = (this.sgWindowWidth - 1) / 2;
        if (!this.calcSavGol) {
            this.savitzkyGolay(n);
        }
        dArray[0] = this.yDataSavGol;
        double[] dArray2 = this.sgArrayC[n2];
        double[] dArray3 = this.padData(this.yData, n3);
        for (int j = n3; j < this.nPoints + n3; ++j) {
            double d = 0.0;
            int n4 = 0;
            for (int k = j - n3; k <= j + n3; ++k) {
                d += dArray3[k] * dArray2[n4++];
            }
            dArray[1][j - n3] = d;
        }
        this.derivSavGol = dArray[1];
        if (n2 == 1) {
            this.yDataSavGolFirst = dArray[1];
            this.firstDeriv = true;
        }
        if (n2 == 2) {
            this.yDataSavGolSecond = dArray[1];
            this.secondDeriv = true;
        }
        this.nthSet = true;
        this.lastMethod = 2;
        this.lastPlotMethod = 5;
        if (n2 == 1) {
            this.lastPlotMethod = 3;
        }
        if (n2 == 2) {
            this.lastPlotMethod = 4;
        }
        return dArray;
    }

    public double[][] savitzkyGolayPlot(int n, int n2) {
        double[][] dArray = this.savitzkyGolay(n, n2);
        this.plot();
        return dArray;
    }

    public static double[][] savitzkyGolayFilter(int n, int n2, int n3) {
        CurveSmooth curveSmooth = new CurveSmooth();
        curveSmooth.setSGpolyDegree(n3);
        return curveSmooth.savitzkyGolayFilter(n, n2);
    }

    public static double[] savitzkyGolayFilter(int n, int n2, int n3, int n4) {
        CurveSmooth curveSmooth = new CurveSmooth();
        curveSmooth.setSGpolyDegree(n3);
        return curveSmooth.savitzkyGolayFilter(n, n2)[n4];
    }

    public double[] getSGcoefficientsUsed() {
        if (this.sgCoeff == null) {
            throw new IllegalArgumentException("No Savitzky-Golay coefficients have been calculated");
        }
        return this.sgCoeff;
    }

    public double[][] getSGcoefficients() {
        if (this.sgArrayC == null) {
            throw new IllegalArgumentException("No Savitzky-Golay coefficients have been calculated");
        }
        return this.sgArrayC;
    }

    public void setSGpolyDegree(int n) {
        this.sgPolyDeg = n;
    }

    public int getSGpolyDegree() {
        return this.sgPolyDeg;
    }

    private void plot() {
        Object object = null;
        String string = null;
        String[] stringArray = new String[]{"  ", "first", "second", "third", "fourth", "th"};
        System.out.println("lm " + this.lastPlotMethod);
        switch (this.lastPlotMethod) {
            case 1: {
                object = new double[8][];
                object[3] = this.yDataMovAv;
                string = "Moving average of " + this.maWindowWidth + " points";
                break;
            }
            case 2: {
                object = new double[8][];
                object[3] = this.yDataSavGol;
                string = "Savitzky-Golay filter with a window of " + this.sgWindowWidth + " points";
                break;
            }
            case 3: {
                object = new double[10][];
                object[3] = this.yDataSavGol;
                object[9] = this.yDataSavGolFirst;
                string = "Savitzky-Golay filter with a window of " + this.sgWindowWidth + " points  plus smoothed first derivative";
                break;
            }
            case 4: {
                object = new double[10][];
                object[3] = this.yDataSavGol;
                object[9] = this.yDataSavGolSecond;
                string = "Savitzky-Golay filter with a window of " + this.sgWindowWidth + " points  plus smoothed second derivative";
                break;
            }
            case 5: {
                object = new double[10][];
                object[3] = this.yDataSavGol;
                object[9] = this.yDataSavGolNth;
                string = this.sgDerivOrderUsed < 5 ? "Savitzky-Golay filter with a window of " + this.sgWindowWidth + " points  plus smoothed " + stringArray[this.sgDerivOrderUsed] + " derivative" : "Savitzky-Golay filter with a window of " + this.sgWindowWidth + " points  plus smoothed " + this.sgDerivOrderUsed + "th derivative";
            }
        }
        object[0] = this.xData;
        object[1] = this.yData;
        object[2] = this.xData;
        double[] dArray = new double[5];
        double[] dArray2 = new double[5];
        double[] dArray3 = new double[5];
        double[] dArray4 = new double[5];
        dArray[0] = this.xData[0];
        dArray[1] = this.xData[this.nPoints / 4];
        dArray[2] = this.xData[this.nPoints / 2];
        dArray[3] = this.xData[3 * this.nPoints / 4];
        dArray[4] = this.xData[this.nPoints - 1];
        dArray3[0] = this.yData[0];
        dArray3[1] = this.yData[this.nPoints / 4];
        dArray3[2] = this.yData[this.nPoints / 2];
        dArray3[3] = this.yData[3 * this.nPoints / 4];
        dArray3[4] = this.yData[this.nPoints - 1];
        dArray2[0] = this.xData[0];
        dArray2[1] = this.xData[this.nPoints / 4 - 1];
        dArray2[2] = this.xData[this.nPoints / 2 - 1];
        dArray2[3] = this.xData[3 * this.nPoints / 4 - 1];
        dArray2[4] = this.xData[this.nPoints - 1];
        dArray4[0] = object[3][0];
        dArray4[1] = object[3][this.nPoints / 4 - 1];
        dArray4[2] = object[3][this.nPoints / 2 - 1];
        dArray4[3] = object[3][3 * this.nPoints / 4 - 1];
        dArray4[4] = object[3][this.nPoints - 1];
        object[4] = dArray;
        object[5] = dArray3;
        object[6] = dArray2;
        object[7] = dArray4;
        int[] nArray = new int[]{0, 0, 1, 2};
        int[] nArray2 = new int[]{3, 3, 0, 0};
        int[] nArray3 = nArray;
        int[] nArray4 = nArray2;
        if (this.lastPlotMethod > 2) {
            object[8] = this.xData;
            nArray3 = new int[5];
            nArray4 = new int[5];
            nArray3[4] = 0;
            nArray4[4] = 3;
            for (int j = 0; j < 4; ++j) {
                nArray3[j] = nArray[j];
                nArray4[j] = nArray2[j];
            }
        }
        object[0] = this.xData;
        object[1] = this.yData;
        object[2] = this.xData;
        PlotGraph plotGraph = new PlotGraph((double[][])object);
        plotGraph.setPoint(nArray3);
        plotGraph.setLine(nArray4);
        plotGraph.setGraphTitle("Original (circles) and smoothed (squares) data");
        plotGraph.setGraphTitle2(string);
        plotGraph.setXaxisLegend("x values");
        plotGraph.setYaxisLegend("y values");
        plotGraph.plot();
    }

    public double[] getSmoothedValues() {
        double[] dArray = null;
        switch (this.lastMethod) {
            case 0: {
                throw new IllegalArgumentException("No smoothing method has been called");
            }
            case 1: {
                dArray = this.yDataMovAv;
                break;
            }
            case 2: {
                dArray = this.yDataSavGol;
            }
        }
        return Conv.copy(dArray);
    }

    public double[] getMovingAverageValues() {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        return Conv.copy(this.yDataMovAv);
    }

    public BigDecimal[] getMovingAverageValuesAsBigDecimal() {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        return Conv.copy(this.yDataMovAvBD);
    }

    public double[] getSavitzkyGolaySmoothedValues() {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        return Conv.copy(this.yDataSavGol);
    }

    public double[] getSavitzkyGolayFirstDerivatives() {
        return this.getSavitzkyGolaySmoothedFirstDerivValues();
    }

    public double[] getSavitzkyGolaySmoothedFirstDerivValues() {
        if (!this.firstDeriv) {
            throw new IllegalArgumentException("No Savitzky-Golay first derivative smoothing method has been called");
        }
        return Conv.copy(this.yDataSavGolFirst);
    }

    public double[] getSavitzkyGolaySecondDerivatives() {
        return this.getSavitzkyGolaySmoothedSecondDerivValues();
    }

    public double[] getSavitzkyGolaySmoothedSecondDerivValues() {
        if (!this.secondDeriv) {
            throw new IllegalArgumentException("No Savitzky-Golay second derivative smoothing method has been called");
        }
        return Conv.copy(this.yDataSavGolSecond);
    }

    public double[] getSavitzkyGolayNthDerivatives() {
        return this.getSavitzkyGolaySmoothedNthDerivValues();
    }

    public double[] getSavitzkyGolaySmoothedNthDerivValues() {
        if (!this.nthSet) {
            throw new IllegalArgumentException("No Savitzky-Golay derivative smoothing method has been called");
        }
        return Conv.copy(this.yDataSavGolNth);
    }

    public double[] getSavitzkyGolayDerivatives() {
        if (!this.nthSet) {
            throw new IllegalArgumentException("No Savitzky-Golay derivative smoothing method has been called");
        }
        return Conv.copy(this.yDataSavGolNth);
    }

    public double[] getSavitzkyGolayNthDerivatives(int n) {
        return this.getSavitzkyGolaySmoothedNthDerivValues(n);
    }

    public double[] getSavitzkyGolayDerivatives(int n) {
        return this.getSavitzkyGolaySmoothedNthDerivValues(n);
    }

    public double[] getSavitzkyGolaySmoothedNthDerivValues(int n) {
        if (!this.nthSet) {
            throw new IllegalArgumentException("No Savitzky-Golay derivative smoothing method has been called");
        }
        double[] dArray = null;
        switch (n) {
            case 0: {
                dArray = this.yDataSavGol;
                break;
            }
            case 1: {
                if (!this.firstDeriv) {
                    throw new IllegalArgumentException("No Savitzky-Golay first derivative smoothing method has been called");
                }
                dArray = this.yDataSavGolFirst;
                break;
            }
            case 2: {
                if (!this.secondDeriv) {
                    throw new IllegalArgumentException("No Savitzky-Golay second derivative smoothing method has been called");
                }
                dArray = this.yDataSavGolSecond;
                break;
            }
            default: {
                dArray = this.yDataSavGolNth;
            }
        }
        return Conv.copy(dArray);
    }

    public double extentMovingAverage() {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        this.extentMovAv = this.extent(this.yData, this.yDataMovAv);
        return this.extentMovAv;
    }

    public double extentSavitzkyGolay() {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        this.extentSavGol = this.extent(this.yData, this.yDataSavGol);
        return this.extentSavGol;
    }

    private double extent(double[] dArray, double[] dArray2) {
        double d = Fmath.maximum(dArray) - Fmath.minimum(dArray);
        double d2 = 0.0;
        for (int j = 0; j < this.nPoints; ++j) {
            d2 += Math.abs(dArray[j] - dArray2[j]) / d;
        }
        return d2 /= (double)this.nPoints;
    }

    public double extremaReductionMovingAverage() {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        int n = this.getNumberOfExtremaUnsmoothed();
        int n2 = this.getNumberOfExtremaMovingAverage();
        return (double)n2 / (double)n;
    }

    public double extremaReductionSavitzkyGolay() {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        int n = this.getNumberOfExtremaUnsmoothed();
        int n2 = this.getNumberOfExtremaSavitzkyGolay();
        return (double)n2 / (double)n;
    }

    public double interpolateSavitzkyGolay(double d) {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        return this.csSavGol.interpolate(d);
    }

    public double interpolateMovingAverage(double d) {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        return this.csMovAv.interpolate(d);
    }

    public double[][] getMinimaUnsmoothed() {
        if (!this.minimaCalc[0]) {
            if (this.arbprec) {
                this.findMinAndMaxBD(this.xBDdata, this.yBDdata, 0);
            } else {
                this.findMinAndMax(this.xData, this.yData, 0);
            }
        }
        double[][] dArray = new double[2][this.nMin[0]];
        dArray[0] = Conv.copy(this.minima[0][0]);
        dArray[1] = Conv.copy(this.minima[0][1]);
        return dArray;
    }

    public BigDecimal[][] getMinimaUnsmoothedAsBigDecimal() {
        if (!this.minimaCalc[0]) {
            if (this.arbprec) {
                this.findMinAndMaxBD(this.xBDdata, this.yBDdata, 0);
            } else {
                this.findMinAndMax(this.xData, this.yData, 0);
            }
        }
        BigDecimal[][] bigDecimalArray = new BigDecimal[2][this.nMin[0]];
        bigDecimalArray[0] = Conv.copy(this.minimaBD[0][0]);
        bigDecimalArray[1] = Conv.copy(this.minimaBD[0][1]);
        return bigDecimalArray;
    }

    public double[][] getMaximaUnsmoothed() {
        if (!this.maximaCalc[0]) {
            if (this.arbprec) {
                this.findMinAndMaxBD(this.xBDdata, this.yBDdata, 0);
            } else {
                this.findMinAndMax(this.xData, this.yData, 0);
            }
        }
        double[][] dArray = new double[2][this.nMax[0]];
        dArray[0] = Conv.copy(this.maxima[0][0]);
        dArray[1] = Conv.copy(this.maxima[0][1]);
        return dArray;
    }

    public BigDecimal[][] getMaximaUnsmoothedAsBigDecimal() {
        if (!this.maximaCalc[0]) {
            if (this.arbprec) {
                this.findMinAndMaxBD(this.xBDdata, this.yBDdata, 0);
            } else {
                this.findMinAndMax(this.xData, this.yData, 0);
            }
        }
        BigDecimal[][] bigDecimalArray = new BigDecimal[2][this.nMax[0]];
        bigDecimalArray[0] = Conv.copy(this.maximaBD[0][0]);
        bigDecimalArray[1] = Conv.copy(this.maximaBD[0][1]);
        return bigDecimalArray;
    }

    public int getNumberOfMinimaUnsmoothed() {
        if (!this.minimaCalc[0]) {
            if (this.arbprec) {
                this.findMinAndMaxBD(this.xBDdata, this.yBDdata, 0);
            } else {
                this.findMinAndMax(this.xData, this.yData, 0);
            }
        }
        return this.nMin[0];
    }

    public int getNumberOfMaximaUnsmoothed() {
        if (!this.maximaCalc[0]) {
            if (this.arbprec) {
                this.findMinAndMaxBD(this.xBDdata, this.yBDdata, 0);
            } else {
                this.findMinAndMax(this.xData, this.yData, 0);
            }
        }
        return this.nMax[0];
    }

    public int getNumberOfExtremaUnsmoothed() {
        if (!this.minimaCalc[0]) {
            if (this.arbprec) {
                this.findMinAndMaxBD(this.xBDdata, this.yBDdata, 0);
            } else {
                this.findMinAndMax(this.xData, this.yData, 0);
            }
        }
        return this.nMin[0] + this.nMax[0];
    }

    public double[][] getMinimaMovingAverage() {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        if (!this.minimaCalc[1]) {
            if (this.arbprec) {
                this.findMinAndMaxBD(this.xBDdata, this.yDataMovAvBD, 1);
            } else {
                this.findMinAndMax(this.xData, this.yDataMovAv, 1);
            }
        }
        double[][] dArray = new double[2][this.nMin[1]];
        dArray[0] = Conv.copy(this.minima[1][0]);
        dArray[1] = Conv.copy(this.minima[1][1]);
        return dArray;
    }

    public BigDecimal[][] getMinimaMovingAverageAsBigDecimal() {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        if (!this.minimaCalc[1]) {
            if (this.arbprec) {
                this.findMinAndMaxBD(this.xBDdata, this.yDataMovAvBD, 1);
            } else {
                this.findMinAndMax(this.xData, this.yDataMovAv, 1);
            }
        }
        BigDecimal[][] bigDecimalArray = new BigDecimal[2][this.nMin[1]];
        bigDecimalArray[0] = Conv.copy(this.minimaBD[1][0]);
        bigDecimalArray[1] = Conv.copy(this.minimaBD[1][1]);
        return bigDecimalArray;
    }

    public double[][] getMaximaMovingAverage() {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        if (!this.maximaCalc[1]) {
            this.findMinAndMax(this.xData, this.yDataMovAv, 1);
        }
        double[][] dArray = new double[2][this.nMax[1]];
        dArray[0] = Conv.copy(this.maxima[1][0]);
        dArray[1] = Conv.copy(this.maxima[1][1]);
        return dArray;
    }

    public BigDecimal[][] getMaximaMovingAverageAsBigDecimal() {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        if (!this.maximaCalc[1]) {
            if (this.arbprec) {
                this.findMinAndMaxBD(this.xBDdata, this.yDataMovAvBD, 1);
            } else {
                this.findMinAndMax(this.xData, this.yDataMovAv, 1);
            }
        }
        BigDecimal[][] bigDecimalArray = new BigDecimal[2][this.nMax[1]];
        bigDecimalArray[0] = Conv.copy(this.maximaBD[1][0]);
        bigDecimalArray[1] = Conv.copy(this.maximaBD[1][1]);
        return bigDecimalArray;
    }

    public int getNumberOfMinimaMovingAverage() {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        if (!this.minimaCalc[1]) {
            if (this.arbprec) {
                this.findMinAndMaxBD(this.xBDdata, this.yDataMovAvBD, 1);
            } else {
                this.findMinAndMax(this.xData, this.yDataMovAv, 1);
            }
        }
        return this.nMin[1];
    }

    public int getNumberOfMaximaMovingAverage() {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        if (!this.maximaCalc[1]) {
            if (this.arbprec) {
                this.findMinAndMaxBD(this.xBDdata, this.yDataMovAvBD, 1);
            } else {
                this.findMinAndMax(this.xData, this.yDataMovAv, 1);
            }
        }
        return this.nMax[1];
    }

    public int getNumberOfExtremaMovingAverage() {
        if (!this.calcMovAv) {
            throw new IllegalArgumentException("No moving average smoothing method has been called");
        }
        if (!this.minimaCalc[1]) {
            if (this.arbprec) {
                this.findMinAndMaxBD(this.xBDdata, this.yDataMovAvBD, 1);
            } else {
                this.findMinAndMax(this.xData, this.yDataMovAv, 1);
            }
        }
        return this.nMin[1] + this.nMax[1];
    }

    public double[][] getMinimaSavitzkyGolay() {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        if (!this.minimaCalc[1]) {
            this.findMinAndMax(this.xData, this.yDataSavGol, 2);
        }
        double[][] dArray = new double[2][this.nMin[2]];
        dArray[0] = Conv.copy(this.minima[2][0]);
        dArray[1] = Conv.copy(this.minima[2][1]);
        return dArray;
    }

    public double[][] getMaximaSavitzkyGolay() {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        if (!this.minimaCalc[1]) {
            this.findMinAndMax(this.xData, this.yDataSavGol, 2);
        }
        double[][] dArray = new double[2][this.nMax[2]];
        dArray[0] = Conv.copy(this.maxima[2][0]);
        dArray[1] = Conv.copy(this.maxima[2][1]);
        return dArray;
    }

    public int getNumberOfMinimaSavitzkyGolay() {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        if (!this.minimaCalc[2]) {
            this.findMinAndMax(this.xData, this.yDataSavGol, 2);
        }
        return this.nMin[2];
    }

    public int getNumberOfMaximaSavitzkyGolay() {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        if (!this.maximaCalc[2]) {
            this.findMinAndMax(this.xData, this.yDataSavGol, 2);
        }
        return this.nMax[2];
    }

    public int getNumberOfExtremaSavitzkyGolay() {
        if (!this.calcSavGol) {
            throw new IllegalArgumentException("No Savitzky-Golay smoothing method has been called");
        }
        if (!this.maximaCalc[2]) {
            this.findMinAndMax(this.xData, this.yDataSavGol, 2);
        }
        return this.nMin[2] + this.nMax[2];
    }

    private void findMinAndMax(double[] dArray, double[] dArray2, int n) {
        String string;
        int n2;
        boolean bl = false;
        int n3 = 0;
        this.almin.clear();
        this.almax.clear();
        int n4 = 0;
        int n5 = 0;
        for (int j = 2; j < this.nPoints - 1; ++j) {
            if (bl) {
                if (dArray2[j] < dArray2[j - 1]) {
                    bl = false;
                    if (dArray2[j] < dArray2[j + 1]) {
                        ++n4;
                        this.almin.add(dArray[j]);
                        this.almin.add(dArray2[j]);
                        continue;
                    }
                    if (dArray2[j] != dArray2[j + 1]) continue;
                    bl = true;
                    n3 = j;
                    continue;
                }
                if (dArray2[j] != dArray2[j - 1]) continue;
                if (dArray2[j] < dArray2[j + 1]) {
                    bl = false;
                    ++n4;
                    double d = (dArray[j] + dArray[n3]) / 2.0;
                    this.almin.add(d);
                    this.almin.add(dArray2[j]);
                    continue;
                }
                if (!(dArray2[j] > dArray2[j + 1])) continue;
                bl = false;
                continue;
            }
            if (dArray2[j] < dArray2[j - 1] && dArray2[j] < dArray2[j + 1]) {
                ++n4;
                this.almin.add(dArray[j]);
                this.almin.add(dArray2[j]);
                continue;
            }
            if (!(dArray2[j] < dArray2[j - 1]) || dArray2[j] != dArray2[j + 1]) continue;
            bl = true;
            n3 = j;
        }
        this.nMin[n] = n4;
        double[] dArray3 = new double[n4];
        double[] dArray4 = new double[n4];
        BigDecimal[] bigDecimalArray = new BigDecimal[n4];
        BigDecimal[] bigDecimalArray2 = new BigDecimal[n4];
        int n6 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            dArray3[n2] = this.almin.get(n6++);
            dArray4[n2] = this.almin.get(n6++);
            String string2 = new Double(dArray3[n2]).toString();
            bigDecimalArray[n2] = new BigDecimal(string2);
            string = new Double(dArray4[n2]).toString();
            bigDecimalArray2[n2] = new BigDecimal(string);
        }
        this.minima[n][0] = dArray3;
        this.minima[n][1] = dArray4;
        this.minimaBD[n][0] = bigDecimalArray;
        this.minimaBD[n][1] = bigDecimalArray2;
        this.minimaCalc[n] = true;
        bl = false;
        n3 = 0;
        for (n2 = 2; n2 < this.nPoints - 1; ++n2) {
            if (bl) {
                if (dArray2[n2] > dArray2[n2 - 1]) {
                    bl = false;
                    if (dArray2[n2] > dArray2[n2 + 1]) {
                        ++n5;
                        this.almax.add(dArray[n2]);
                        this.almax.add(dArray2[n2]);
                        continue;
                    }
                    if (dArray2[n2] != dArray2[n2 + 1]) continue;
                    bl = true;
                    n3 = n2;
                    continue;
                }
                if (dArray2[n2] != dArray2[n2 - 1]) continue;
                if (dArray2[n2] > dArray2[n2 + 1]) {
                    bl = false;
                    ++n5;
                    double d = (dArray[n2] + dArray[n3]) / 2.0;
                    this.almax.add(d);
                    this.almax.add(dArray2[n2]);
                    continue;
                }
                if (!(dArray2[n2] < dArray2[n2 + 1])) continue;
                bl = false;
                continue;
            }
            if (dArray2[n2] > dArray2[n2 - 1] && dArray2[n2] > dArray2[n2 + 1]) {
                ++n5;
                this.almax.add(dArray[n2]);
                this.almax.add(dArray2[n2]);
                continue;
            }
            if (!(dArray2[n2] > dArray2[n2 - 1]) || dArray2[n2] != dArray2[n2 + 1]) continue;
            bl = true;
            n3 = n2;
        }
        this.nMax[n] = n5;
        dArray3 = new double[n5];
        dArray4 = new double[n5];
        bigDecimalArray = new BigDecimal[n5];
        bigDecimalArray2 = new BigDecimal[n5];
        n6 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            dArray3[n2] = this.almax.get(n6++);
            dArray4[n2] = this.almax.get(n6++);
            String string3 = new Double(dArray3[n2]).toString();
            bigDecimalArray[n2] = new BigDecimal(string3);
            string = new Double(dArray4[n2]).toString();
            bigDecimalArray2[n2] = new BigDecimal(string);
        }
        this.maxima[n][0] = dArray3;
        this.maxima[n][1] = dArray4;
        this.maximaBD[n][0] = bigDecimalArray;
        this.maximaBD[n][1] = bigDecimalArray2;
        this.maximaCalc[n] = true;
    }

    private void findMinAndMaxBD(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2, int n) {
        int n2;
        Object object;
        boolean bl = false;
        int n3 = 0;
        this.almin.clear();
        this.almax.clear();
        int n4 = 0;
        int n5 = 0;
        for (int j = 2; j < this.nPoints - 1; ++j) {
            if (bl) {
                if (bigDecimalArray2[j].compareTo(bigDecimalArray2[j - 1]) == -1) {
                    bl = false;
                    if (bigDecimalArray2[j].compareTo(bigDecimalArray2[j + 1]) == -1) {
                        ++n4;
                        this.alminBD.add(bigDecimalArray[j]);
                        this.alminBD.add(bigDecimalArray2[j]);
                        continue;
                    }
                    if (bigDecimalArray2[j] != bigDecimalArray2[j + 1]) continue;
                    bl = true;
                    n3 = j;
                    continue;
                }
                if (bigDecimalArray2[j].compareTo(bigDecimalArray2[j - 1]) != 0) continue;
                if (bigDecimalArray2[j].compareTo(bigDecimalArray2[j + 1]) == -1) {
                    bl = false;
                    ++n4;
                    object = bigDecimalArray[j].add(bigDecimalArray[n3]).divide(new BigDecimal("2.0"), 4);
                    this.alminBD.add((BigDecimal)object);
                    this.alminBD.add(bigDecimalArray2[j]);
                    continue;
                }
                if (bigDecimalArray2[j].compareTo(bigDecimalArray2[j + 1]) != 1) continue;
                bl = false;
                continue;
            }
            if (bigDecimalArray2[j].compareTo(bigDecimalArray2[j - 1]) == -1 && bigDecimalArray2[j].compareTo(bigDecimalArray2[j + 1]) == -1) {
                ++n4;
                this.alminBD.add(bigDecimalArray[j]);
                this.alminBD.add(bigDecimalArray2[j]);
                continue;
            }
            if (bigDecimalArray2[j].compareTo(bigDecimalArray2[j - 1]) != -1 || bigDecimalArray2[j].compareTo(bigDecimalArray2[j + 1]) != 0) continue;
            bl = true;
            n3 = j;
        }
        this.nMin[n] = n4;
        double[] dArray = new double[n4];
        object = new double[n4];
        BigDecimal[] bigDecimalArray3 = new BigDecimal[n4];
        BigDecimal[] bigDecimalArray4 = new BigDecimal[n4];
        int n6 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            bigDecimalArray3[n2] = this.alminBD.get(n6++);
            bigDecimalArray4[n2] = this.alminBD.get(n6++);
            dArray[n2] = bigDecimalArray3[n2].doubleValue();
            object[n2] = bigDecimalArray4[n2].doubleValue();
        }
        this.minima[n][0] = dArray;
        this.minima[n][1] = object;
        this.minimaBD[n][0] = bigDecimalArray3;
        this.minimaBD[n][1] = bigDecimalArray4;
        this.minimaCalc[n] = true;
        bl = false;
        n3 = 0;
        for (n2 = 2; n2 < this.nPoints - 1; ++n2) {
            if (bl) {
                if (bigDecimalArray2[n2].compareTo(bigDecimalArray2[n2 - 1]) == 1) {
                    bl = false;
                    if (bigDecimalArray2[n2].compareTo(bigDecimalArray2[n2 + 1]) == 1) {
                        ++n5;
                        this.almaxBD.add(bigDecimalArray[n2]);
                        this.almaxBD.add(bigDecimalArray2[n2]);
                        continue;
                    }
                    if (bigDecimalArray2[n2].compareTo(bigDecimalArray2[n2 + 1]) != 0) continue;
                    bl = true;
                    n3 = n2;
                    continue;
                }
                if (bigDecimalArray2[n2] != bigDecimalArray2[n2 - 1]) continue;
                if (bigDecimalArray2[n2].compareTo(bigDecimalArray2[n2 + 1]) == 1) {
                    bl = false;
                    ++n5;
                    BigDecimal bigDecimal = bigDecimalArray[n2].add(bigDecimalArray[n3]).divide(new BigDecimal("2.0"), 4);
                    this.almaxBD.add(bigDecimal);
                    this.almaxBD.add(bigDecimalArray2[n2]);
                    continue;
                }
                if (bigDecimalArray2[n2].compareTo(bigDecimalArray2[n2 + 1]) != -1) continue;
                bl = false;
                continue;
            }
            if (bigDecimalArray2[n2].compareTo(bigDecimalArray2[n2 - 1]) == 1 && bigDecimalArray2[n2].compareTo(bigDecimalArray2[n2 + 1]) == 1) {
                ++n5;
                this.almaxBD.add(bigDecimalArray[n2]);
                this.almaxBD.add(bigDecimalArray2[n2]);
                continue;
            }
            if (bigDecimalArray2[n2].compareTo(bigDecimalArray2[n2 - 1]) != 1 || bigDecimalArray2[n2].compareTo(bigDecimalArray2[n2 + 1]) != 0) continue;
            bl = true;
            n3 = n2;
        }
        this.nMax[n] = n5;
        dArray = new double[n5];
        object = new double[n5];
        bigDecimalArray3 = new BigDecimal[n5];
        bigDecimalArray4 = new BigDecimal[n5];
        n6 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            bigDecimalArray3[n2] = this.alminBD.get(n6++);
            bigDecimalArray4[n2] = this.alminBD.get(n6++);
            dArray[n2] = bigDecimalArray3[n2].doubleValue();
            object[n2] = bigDecimalArray4[n2].doubleValue();
        }
        this.maxima[n][0] = dArray;
        this.maxima[n][1] = object;
        this.maximaBD[n][0] = bigDecimalArray3;
        this.maximaBD[n][1] = bigDecimalArray4;
        this.maximaCalc[n] = true;
    }
}

