/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.RegressionFunction;
import flanagan.math.Fmath;

class ErlangFunction
implements RegressionFunction {
    private boolean scaleOption = true;
    private double scaleFactor = 1.0;
    private double kay = 1.0;

    ErlangFunction() {
    }

    @Override
    public double function(double[] dArray, double[] dArray2) {
        boolean bl = false;
        double d = this.scaleFactor;
        if (this.scaleOption) {
            d = dArray[1];
        }
        double d2 = this.kay * Math.log(dArray[0]) + (this.kay - 1.0) * Math.log(dArray2[0]) - dArray2[0] * dArray[0] - Fmath.logFactorial(this.kay - 1.0);
        d2 = d * Math.exp(d2);
        return d2;
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
    }

    public void setScaleOption(boolean bl) {
        this.scaleOption = bl;
    }

    public void setKay(double d) {
        this.kay = d;
    }
}

