/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.math.Fmath;

public class ErrorProp {
    private double value = 0.0;
    private double error = 0.0;

    public ErrorProp() {
        this.value = 0.0;
        this.error = 0.0;
    }

    public ErrorProp(double d, double d2) {
        this.value = d;
        this.error = d2;
    }

    public ErrorProp(double d) {
        this.value = d;
        this.error = 0.0;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public void setError(double d) {
        this.error = d;
    }

    public void reset(double d, double d2) {
        this.value = d;
        this.error = d2;
    }

    public double getValue() {
        return this.value;
    }

    public double getError() {
        return this.error;
    }

    public void println(String string) {
        System.out.println(string + " " + this.toString());
    }

    public void println() {
        System.out.println(" " + this.toString());
    }

    public void print(String string) {
        System.out.print(string + " " + this.toString());
    }

    public void print() {
        System.out.print(" " + this.toString());
    }

    public static ErrorProp truncate(ErrorProp errorProp, int n) {
        if (n < 0) {
            return errorProp;
        }
        double d = errorProp.getValue();
        double d2 = errorProp.getError();
        ErrorProp errorProp2 = new ErrorProp();
        d = Fmath.truncate(d, n);
        d2 = Fmath.truncate(d2, n);
        errorProp2.reset(d, d2);
        return errorProp2;
    }

    public ErrorProp truncate(int n) {
        if (n < 0) {
            return this;
        }
        double d = this.getValue();
        double d2 = this.getError();
        ErrorProp errorProp = new ErrorProp();
        d = Fmath.truncate(d, n);
        d2 = Fmath.truncate(d2, n);
        errorProp.reset(d, d2);
        return errorProp;
    }

    public String toString() {
        return this.value + ", error = " + this.error;
    }

    public static String toString(ErrorProp errorProp) {
        return errorProp.value + ", error = " + errorProp.error;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        long l2 = Double.doubleToLongBits(this.error);
        int n = (int)(l ^ l >>> 32);
        int n2 = (int)(l2 ^ l2 >>> 32);
        return 7 * (n / 10) + 3 * (n2 / 10);
    }

    public static ErrorProp[] oneDarray(int n) {
        ErrorProp[] errorPropArray = new ErrorProp[n];
        for (int j = 0; j < n; ++j) {
            errorPropArray[j] = ErrorProp.zero();
        }
        return errorPropArray;
    }

    public static ErrorProp[] oneDarray(int n, double d, double d2) {
        ErrorProp[] errorPropArray = new ErrorProp[n];
        for (int j = 0; j < n; ++j) {
            errorPropArray[j] = ErrorProp.zero();
            errorPropArray[j].reset(d, d2);
        }
        return errorPropArray;
    }

    public static ErrorProp[] oneDarray(int n, ErrorProp errorProp) {
        ErrorProp[] errorPropArray = new ErrorProp[n];
        for (int j = 0; j < n; ++j) {
            errorPropArray[j] = ErrorProp.copy(errorProp);
        }
        return errorPropArray;
    }

    public static ErrorProp[][] twoDarray(int n, int n2) {
        ErrorProp[][] errorPropArray = new ErrorProp[n][n2];
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                errorPropArray[j][k] = ErrorProp.zero();
            }
        }
        return errorPropArray;
    }

    public static ErrorProp[][] twoDarray(int n, int n2, double d, double d2) {
        ErrorProp[][] errorPropArray = new ErrorProp[n][n2];
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                errorPropArray[j][k] = ErrorProp.zero();
                errorPropArray[j][k].reset(d, d2);
            }
        }
        return errorPropArray;
    }

    public static ErrorProp[][] twoDarray(int n, int n2, ErrorProp errorProp) {
        ErrorProp[][] errorPropArray = new ErrorProp[n][n2];
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                errorPropArray[j][k] = ErrorProp.copy(errorProp);
            }
        }
        return errorPropArray;
    }

    public static ErrorProp copy(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = errorProp.value;
        errorProp2.error = errorProp.error;
        return errorProp2;
    }

    public ErrorProp copy() {
        ErrorProp errorProp = new ErrorProp();
        errorProp.value = this.value;
        errorProp.error = this.error;
        return errorProp;
    }

    public Object clone() {
        ErrorProp errorProp = new ErrorProp();
        errorProp.value = this.value;
        errorProp.error = this.error;
        return errorProp;
    }

    public static ErrorProp[] copy(ErrorProp[] errorPropArray) {
        int n = errorPropArray.length;
        ErrorProp[] errorPropArray2 = ErrorProp.oneDarray(n);
        for (int j = 0; j < n; ++j) {
            errorPropArray2[j] = ErrorProp.copy(errorPropArray[j]);
        }
        return errorPropArray2;
    }

    public static ErrorProp[][] copy(ErrorProp[][] errorPropArray) {
        int n = errorPropArray.length;
        int n2 = errorPropArray[0].length;
        ErrorProp[][] errorPropArray2 = ErrorProp.twoDarray(n, n2);
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                errorPropArray2[j][k] = ErrorProp.copy(errorPropArray[j][k]);
            }
        }
        return errorPropArray2;
    }

    public ErrorProp plus(ErrorProp errorProp, double d) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = errorProp.value + this.value;
        errorProp2.error = ErrorProp.hypotWithCov(errorProp.error, this.error, d);
        return errorProp2;
    }

    public static ErrorProp plus(ErrorProp errorProp, ErrorProp errorProp2, double d) {
        ErrorProp errorProp3 = new ErrorProp();
        errorProp3.value = errorProp.value + errorProp2.value;
        errorProp3.error = ErrorProp.hypotWithCov(errorProp.error, errorProp2.error, d);
        return errorProp3;
    }

    public ErrorProp plus(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = this.value + errorProp.value;
        errorProp2.error = ErrorProp.hypotWithCov(errorProp.error, this.error, 0.0);
        return errorProp2;
    }

    public static ErrorProp plus(ErrorProp errorProp, ErrorProp errorProp2) {
        ErrorProp errorProp3 = new ErrorProp();
        errorProp3.value = errorProp.value + errorProp2.value;
        errorProp3.error = ErrorProp.hypotWithCov(errorProp.error, errorProp2.error, 0.0);
        return errorProp3;
    }

    public ErrorProp plus(double d) {
        ErrorProp errorProp = new ErrorProp();
        errorProp.value = this.value + d;
        errorProp.error = Math.abs(this.error);
        return errorProp;
    }

    public static ErrorProp plus(double d, ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = d + errorProp.value;
        errorProp2.error = Math.abs(errorProp.error);
        return errorProp2;
    }

    public static ErrorProp plus(double d, double d2) {
        ErrorProp errorProp = new ErrorProp();
        errorProp.value = d + d2;
        errorProp.error = 0.0;
        return errorProp;
    }

    public void plusEquals(ErrorProp errorProp, double d) {
        this.value += errorProp.value;
        this.error = ErrorProp.hypotWithCov(errorProp.error, this.error, d);
    }

    public void plusEquals(ErrorProp errorProp) {
        this.value += errorProp.value;
        this.error = Math.sqrt(errorProp.error * errorProp.error + this.error * this.error);
        this.error = ErrorProp.hypotWithCov(errorProp.error, this.error, 0.0);
    }

    public void plusEquals(double d) {
        this.value += d;
        this.error = Math.abs(this.error);
    }

    public ErrorProp minus(ErrorProp errorProp, double d) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = this.value - errorProp.value;
        errorProp2.error = ErrorProp.hypotWithCov(this.error, errorProp.error, -d);
        return errorProp2;
    }

    public static ErrorProp minus(ErrorProp errorProp, ErrorProp errorProp2, double d) {
        ErrorProp errorProp3 = new ErrorProp();
        errorProp3.value = errorProp.value - errorProp2.value;
        errorProp3.error = ErrorProp.hypotWithCov(errorProp.error, errorProp2.error, -d);
        return errorProp3;
    }

    public ErrorProp minus(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = this.value - errorProp.value;
        errorProp2.error = ErrorProp.hypotWithCov(errorProp.error, this.error, 0.0);
        return errorProp2;
    }

    public static ErrorProp minus(ErrorProp errorProp, ErrorProp errorProp2) {
        ErrorProp errorProp3 = new ErrorProp();
        errorProp3.value = errorProp.value - errorProp2.value;
        errorProp3.error = ErrorProp.hypotWithCov(errorProp.error, errorProp2.error, 0.0);
        return errorProp3;
    }

    public ErrorProp minus(double d) {
        ErrorProp errorProp = new ErrorProp();
        errorProp.value = this.value - d;
        errorProp.error = Math.abs(this.error);
        return errorProp;
    }

    public static ErrorProp minus(double d, ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = d - errorProp.value;
        errorProp2.error = Math.abs(errorProp.error);
        return errorProp2;
    }

    public static ErrorProp minus(double d, double d2) {
        ErrorProp errorProp = new ErrorProp();
        errorProp.value = d - d2;
        errorProp.error = 0.0;
        return errorProp;
    }

    public void minusEquals(ErrorProp errorProp, double d) {
        this.value -= errorProp.value;
        this.error = ErrorProp.hypotWithCov(errorProp.error, this.error, -d);
    }

    public void minusEquals(ErrorProp errorProp) {
        this.value -= errorProp.value;
        this.error = ErrorProp.hypotWithCov(errorProp.error, this.error, 0.0);
    }

    public void minusEquals(double d) {
        this.value -= d;
        this.error = Math.abs(this.error);
    }

    public ErrorProp times(ErrorProp errorProp, double d) {
        ErrorProp errorProp2 = new ErrorProp();
        double d2 = d * errorProp.error * this.error;
        errorProp2.value = errorProp.value * this.value;
        errorProp2.error = errorProp.value == 0.0 ? errorProp.error * this.value : (this.value == 0.0 ? this.error * errorProp.value : Math.abs(errorProp2.value) * ErrorProp.hypotWithCov(errorProp.error / errorProp.value, this.error / this.value, d));
        return errorProp2;
    }

    public ErrorProp times(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = this.value * errorProp.value;
        errorProp2.error = errorProp.value == 0.0 ? errorProp.error * this.value : (this.value == 0.0 ? this.error * errorProp.value : Math.abs(errorProp2.value) * ErrorProp.hypotWithCov(errorProp.error / errorProp.value, this.error / this.value, 0.0));
        return errorProp2;
    }

    public ErrorProp times(double d) {
        ErrorProp errorProp = new ErrorProp();
        errorProp.value = this.value * d;
        errorProp.error = Math.abs(this.error * d);
        return errorProp;
    }

    public static ErrorProp times(ErrorProp errorProp, ErrorProp errorProp2, double d) {
        ErrorProp errorProp3 = new ErrorProp();
        double d2 = d * errorProp.error * errorProp2.error;
        errorProp3.value = errorProp.value * errorProp2.value;
        errorProp3.error = errorProp.value == 0.0 ? errorProp.error * errorProp2.value : (errorProp2.value == 0.0 ? errorProp2.error * errorProp.value : Math.abs(errorProp3.value) * ErrorProp.hypotWithCov(errorProp.error / errorProp.value, errorProp2.error / errorProp2.value, d));
        return errorProp3;
    }

    public static ErrorProp times(ErrorProp errorProp, ErrorProp errorProp2) {
        ErrorProp errorProp3 = new ErrorProp();
        errorProp3.value = errorProp.value * errorProp2.value;
        errorProp3.error = errorProp.value == 0.0 ? errorProp.error * errorProp2.value : (errorProp2.value == 0.0 ? errorProp2.error * errorProp.value : Math.abs(errorProp3.value) * ErrorProp.hypotWithCov(errorProp.error / errorProp.value, errorProp2.error / errorProp2.value, 0.0));
        return errorProp3;
    }

    public static ErrorProp times(double d, ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = d * errorProp.value;
        errorProp2.error = Math.abs(d * errorProp.error);
        return errorProp2;
    }

    public static ErrorProp times(double d, double d2) {
        ErrorProp errorProp = new ErrorProp();
        errorProp.value = d * d2;
        errorProp.error = 0.0;
        return errorProp;
    }

    public void timesEquals(ErrorProp errorProp, double d) {
        ErrorProp errorProp2 = new ErrorProp();
        double d2 = d * this.error * errorProp.error;
        errorProp2.value = this.value * errorProp.value;
        errorProp2.error = errorProp.value == 0.0 ? errorProp.error * this.value : (this.value == 0.0 ? this.error * errorProp.value : Math.abs(errorProp2.value) * ErrorProp.hypotWithCov(errorProp.error / errorProp.value, this.error / this.value, d));
        this.value = errorProp2.value;
        this.error = errorProp2.error;
    }

    public void timesEquals(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = this.value * errorProp.value;
        errorProp2.error = errorProp.value == 0.0 ? errorProp.error * this.value : (this.value == 0.0 ? this.error * errorProp.value : Math.abs(errorProp2.value) * ErrorProp.hypotWithCov(errorProp.error / errorProp.value, this.error / this.value, 0.0));
        this.value = errorProp2.value;
        this.error = errorProp2.error;
    }

    public void timesEquals(double d) {
        this.value *= d;
        this.error = Math.abs(this.error * d);
    }

    public ErrorProp over(ErrorProp errorProp, double d) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = this.value / errorProp.value;
        errorProp2.error = this.value == 0.0 ? this.error * errorProp.value : Math.abs(errorProp2.value) * ErrorProp.hypotWithCov(this.error / this.value, errorProp.error / errorProp.value, -d);
        return errorProp2;
    }

    public static ErrorProp over(ErrorProp errorProp, ErrorProp errorProp2, double d) {
        ErrorProp errorProp3 = new ErrorProp();
        errorProp3.value = errorProp.value / errorProp2.value;
        errorProp3.error = errorProp.value == 0.0 ? errorProp.error * errorProp2.value : Math.abs(errorProp3.value) * ErrorProp.hypotWithCov(errorProp.error / errorProp.value, errorProp2.error / errorProp2.value, -d);
        return errorProp3;
    }

    public ErrorProp over(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = this.value / errorProp.value;
        errorProp2.error = Math.abs(errorProp2.value) * ErrorProp.hypotWithCov(errorProp.error / errorProp.value, this.error / this.value, 0.0);
        errorProp2.error = this.value == 0.0 ? this.error * errorProp2.value : Math.abs(errorProp2.value) * ErrorProp.hypotWithCov(errorProp.error / errorProp.value, this.error / this.value, 0.0);
        return errorProp2;
    }

    public static ErrorProp over(ErrorProp errorProp, ErrorProp errorProp2) {
        ErrorProp errorProp3 = new ErrorProp();
        errorProp3.value = errorProp.value / errorProp2.value;
        errorProp3.error = errorProp.value == 0.0 ? errorProp.error * errorProp2.value : Math.abs(errorProp3.value) * ErrorProp.hypotWithCov(errorProp.error / errorProp.value, errorProp2.error / errorProp2.value, 0.0);
        return errorProp3;
    }

    public ErrorProp over(double d) {
        ErrorProp errorProp = new ErrorProp();
        errorProp.value = this.value / d;
        errorProp.error = Math.abs(this.error / d);
        return errorProp;
    }

    public static ErrorProp over(double d, ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = d / errorProp.value;
        errorProp2.error = Math.abs(d * errorProp.error / (errorProp.value * errorProp.value));
        return errorProp2;
    }

    public static ErrorProp over(double d, double d2) {
        ErrorProp errorProp = new ErrorProp();
        errorProp.value = d / d2;
        errorProp.error = 0.0;
        return errorProp;
    }

    public void overEquals(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = this.value / errorProp.value;
        errorProp2.error = this.value == 0.0 ? this.error * errorProp.value : Math.abs(errorProp2.value) * ErrorProp.hypotWithCov(this.error / this.value, errorProp.error / errorProp.value, 0.0);
        this.value = errorProp2.value;
        this.error = errorProp2.error;
    }

    public void overEquals(ErrorProp errorProp, double d) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = this.value / errorProp.value;
        errorProp2.error = this.value == 0.0 ? this.error * errorProp.value : Math.abs(errorProp2.value) * ErrorProp.hypotWithCov(this.error / this.value, errorProp.error / errorProp.value, -d);
        this.value = errorProp2.value;
        this.error = errorProp2.error;
    }

    public void overEquals(double d) {
        this.value /= d;
        this.error = Math.abs(this.error / d);
    }

    public ErrorProp inverse() {
        ErrorProp errorProp = ErrorProp.over(1.0, this);
        return errorProp;
    }

    public static ErrorProp inverse(ErrorProp errorProp) {
        ErrorProp errorProp2 = ErrorProp.over(1.0, errorProp);
        return errorProp2;
    }

    public static ErrorProp hypot(ErrorProp errorProp, ErrorProp errorProp2, double d) {
        ErrorProp errorProp3 = new ErrorProp();
        errorProp3.value = Fmath.hypot(errorProp.value, errorProp2.value);
        errorProp3.error = Math.abs(ErrorProp.hypotWithCov(errorProp.error * errorProp.value, errorProp2.error * errorProp2.value, d) / errorProp3.value);
        return errorProp3;
    }

    public static ErrorProp hypot(ErrorProp errorProp, ErrorProp errorProp2) {
        ErrorProp errorProp3 = new ErrorProp();
        errorProp3.value = Fmath.hypot(errorProp.value, errorProp2.value);
        errorProp3.error = Math.abs(ErrorProp.hypotWithCov(errorProp.error * errorProp.value, errorProp2.error * errorProp2.value, 0.0) / errorProp3.value);
        return errorProp3;
    }

    public static ErrorProp abs(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = Math.abs(errorProp.value);
        errorProp2.error = Math.abs(errorProp.error);
        return errorProp2;
    }

    public ErrorProp abs() {
        ErrorProp errorProp = new ErrorProp();
        errorProp.value = Math.abs(this.value);
        errorProp.error = Math.abs(this.error);
        return errorProp;
    }

    public static ErrorProp exp(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = Math.exp(errorProp.value);
        errorProp2.error = Math.abs(errorProp2.value * errorProp.error);
        return errorProp2;
    }

    public static ErrorProp log(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = Math.log(errorProp.value);
        errorProp2.error = Math.abs(errorProp.error / errorProp.value);
        return errorProp2;
    }

    public static ErrorProp log10(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = Fmath.log10(errorProp.value);
        errorProp2.error = Math.abs(errorProp.error / (errorProp.value * Math.log(10.0)));
        return errorProp2;
    }

    public static ErrorProp sqrt(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = Math.sqrt(errorProp.value);
        errorProp2.error = Math.abs(errorProp.error / (2.0 * errorProp.value));
        return errorProp2;
    }

    public static ErrorProp nthRoot(ErrorProp errorProp, int n) {
        if (n == 0) {
            throw new ArithmeticException("Division by zero (n = 0 - infinite root) attempted in ErrorProp.nthRoot");
        }
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = Math.pow(errorProp.value, 1 / n);
        errorProp2.error = Math.abs(errorProp.error * Math.pow(errorProp.value, 1 / n - 1) / (double)n);
        return errorProp2;
    }

    public ErrorProp square() {
        ErrorProp errorProp = new ErrorProp(this.value, this.error);
        return errorProp.times(errorProp, 1.0);
    }

    public static ErrorProp square(ErrorProp errorProp) {
        return errorProp.times(errorProp, 1.0);
    }

    public static ErrorProp pow(ErrorProp errorProp, double d) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = Math.pow(errorProp.value, d);
        errorProp2.error = Math.abs(d * Math.pow(errorProp.value, d - 1.0));
        return errorProp2;
    }

    public static ErrorProp pow(double d, ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = Math.pow(d, errorProp.value);
        errorProp2.error = Math.abs(errorProp2.value * Math.log(d) * errorProp.error);
        return errorProp2;
    }

    public static ErrorProp pow(ErrorProp errorProp, ErrorProp errorProp2, double d) {
        ErrorProp errorProp3 = new ErrorProp();
        errorProp3.value = Math.pow(errorProp.value, errorProp2.value);
        errorProp3.error = ErrorProp.hypotWithCov(errorProp.error * errorProp2.value * Math.pow(errorProp.value, errorProp2.value - 1.0), errorProp2.error * Math.log(errorProp.value) * Math.pow(errorProp.value, errorProp2.value), d);
        return errorProp3;
    }

    public static ErrorProp pow(ErrorProp errorProp, ErrorProp errorProp2) {
        ErrorProp errorProp3 = new ErrorProp();
        errorProp3.value = Math.pow(errorProp.value, errorProp2.value);
        errorProp3.error = ErrorProp.hypotWithCov(errorProp.error * errorProp2.value * Math.pow(errorProp.value, errorProp2.value - 1.0), errorProp2.error * Math.log(errorProp.value) * Math.pow(errorProp.value, errorProp2.value), 0.0);
        return errorProp3;
    }

    public static ErrorProp sin(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = Math.sin(errorProp.value);
        errorProp2.error = Math.abs(errorProp.error * Math.cos(errorProp.value));
        return errorProp2;
    }

    public static ErrorProp cos(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = Math.cos(errorProp.value);
        errorProp2.error = Math.abs(errorProp.error * Math.sin(errorProp.value));
        return errorProp2;
    }

    public static ErrorProp tan(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = Math.tan(errorProp.value);
        errorProp2.error = Math.abs(errorProp.error * Fmath.square(Fmath.sec(errorProp.value)));
        return errorProp2;
    }

    public static ErrorProp sinh(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = Fmath.sinh(errorProp.value);
        errorProp2.error = Math.abs(errorProp.error * Fmath.cosh(errorProp.value));
        return errorProp2;
    }

    public static ErrorProp cosh(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = Fmath.cosh(errorProp.value);
        errorProp2.error = Math.abs(errorProp.error * Fmath.sinh(errorProp.value));
        return errorProp2;
    }

    public static ErrorProp tanh(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = Fmath.tanh(errorProp.value);
        errorProp2.error = Math.abs(errorProp.error * Fmath.square(Fmath.sech(errorProp.value)));
        return errorProp2;
    }

    public static ErrorProp asin(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = Math.asin(errorProp.value);
        errorProp2.error = Math.abs(errorProp.error / Math.sqrt(1.0 - errorProp.value * errorProp.value));
        return errorProp2;
    }

    public static ErrorProp acos(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = Math.acos(errorProp.value);
        errorProp2.error = Math.abs(errorProp.error / Math.sqrt(1.0 - errorProp.value * errorProp.value));
        return errorProp2;
    }

    public static ErrorProp atan(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = Math.atan(errorProp.value);
        errorProp2.error = Math.abs(errorProp.error / (1.0 + errorProp.value * errorProp.value));
        return errorProp2;
    }

    public static ErrorProp atan2(ErrorProp errorProp, ErrorProp errorProp2) {
        ErrorProp errorProp3 = new ErrorProp();
        ErrorProp errorProp4 = errorProp.over(errorProp2);
        errorProp3.value = Math.atan2(errorProp.value, errorProp2.value);
        errorProp3.error = Math.abs(errorProp4.error / (1.0 + errorProp4.value * errorProp4.value));
        return errorProp3;
    }

    public static ErrorProp atan2(ErrorProp errorProp, ErrorProp errorProp2, double d) {
        ErrorProp errorProp3 = new ErrorProp();
        ErrorProp errorProp4 = errorProp.over(errorProp2, d);
        errorProp3.value = Math.atan2(errorProp.value, errorProp2.value);
        errorProp3.error = Math.abs(errorProp4.error / (1.0 + errorProp4.value * errorProp4.value));
        return errorProp3;
    }

    public static ErrorProp asinh(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = Fmath.asinh(errorProp.value);
        errorProp2.error = Math.abs(errorProp.error / Math.sqrt(errorProp.value * errorProp.value + 1.0));
        return errorProp2;
    }

    public static ErrorProp acosh(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = Fmath.acosh(errorProp.value);
        errorProp2.error = Math.abs(errorProp.error / Math.sqrt(errorProp.value * errorProp.value - 1.0));
        return errorProp2;
    }

    public static ErrorProp atanh(ErrorProp errorProp) {
        ErrorProp errorProp2 = new ErrorProp();
        errorProp2.value = Fmath.atanh(errorProp.value);
        errorProp2.error = Math.abs(errorProp.error / (1.0 - errorProp.value * errorProp.value));
        return errorProp2;
    }

    public static ErrorProp zero() {
        ErrorProp errorProp = new ErrorProp();
        errorProp.value = 0.0;
        errorProp.error = 0.0;
        return errorProp;
    }

    public static ErrorProp plusOne() {
        ErrorProp errorProp = new ErrorProp();
        errorProp.value = 1.0;
        errorProp.error = 0.0;
        return errorProp;
    }

    public static ErrorProp minusOne() {
        ErrorProp errorProp = new ErrorProp();
        errorProp.value = -1.0;
        errorProp.error = 0.0;
        return errorProp;
    }

    private static double hypotWithCov(double d, double d2, double d3) {
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (d == 0.0 && d2 == 0.0) {
            return 0.0;
        }
        if (Math.abs(d) > Math.abs(d2)) {
            d4 = Math.abs(d);
            d5 = d2 / d;
            d6 = Fmath.sign(d);
        } else {
            d4 = Math.abs(d2);
            d5 = d / d2;
            d6 = Fmath.sign(d2);
        }
        return d4 * Math.sqrt(1.0 + d5 * (d5 + 2.0 * d3 * d6));
    }
}

