/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.RegressionFunction3;

class ExponentialSimpleFunctionDual
implements RegressionFunction3 {
    private boolean scaleOption = true;
    private double scaleFactor = 1.0;
    private double[][] xErrors = null;
    private double[] yErrors = null;

    ExponentialSimpleFunctionDual() {
    }

    @Override
    public double[] function(double[] dArray, double[] dArray2, int n) {
        double d = this.scaleFactor;
        if (this.scaleOption) {
            d = dArray[1];
        }
        double[] dArray3 = new double[2];
        dArray3[0] = d * Math.exp(dArray[0] * dArray2[0]);
        if (n >= 0) {
            dArray3[1] = d * dArray[0] * Math.exp(dArray[0] * dArray2[0]);
            dArray3[1] = this.yErrors[n] * this.yErrors[n] + this.xErrors[0][n] * this.xErrors[0][n] * dArray3[1] * dArray3[1];
        }
        return dArray3;
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
    }

    public void setScaleOption(boolean bl) {
        this.scaleOption = bl;
    }

    public void setXerrors(double[][] dArray) {
        this.xErrors = dArray;
    }

    public void setYerrors(double[] dArray) {
        this.yErrors = dArray;
    }
}

