/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.RegressionFunction;
import flanagan.analysis.Stat;

class GammaFunction
implements RegressionFunction {
    private boolean scaleOption = true;
    private double scaleFactor = 1.0;
    private int typeFlag = 0;

    GammaFunction() {
    }

    @Override
    public double function(double[] dArray, double[] dArray2) {
        double d = 0.0;
        boolean bl = false;
        double d2 = this.scaleFactor;
        switch (this.typeFlag) {
            case 0: {
                if (this.scaleOption) {
                    d2 = dArray[3];
                }
                double d3 = (dArray2[0] - dArray[0]) / dArray[1];
                d = d2 * Math.pow(d3, dArray[2] - 1.0) * Math.exp(-d3) / (dArray[1] * Stat.gammaFunction(dArray[2]));
                break;
            }
            case 1: {
                if (this.scaleOption) {
                    d2 = dArray[1];
                }
                d = d2 * Math.pow(dArray2[0], dArray[0] - 1.0) * Math.exp(-dArray2[0]) / Stat.gammaFunction(dArray[0]);
            }
        }
        return d;
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
    }

    public void setScaleOption(boolean bl) {
        this.scaleOption = bl;
    }

    public void setTypeFlag(int n) {
        this.typeFlag = n;
    }
}

