/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.Stat;
import flanagan.math.Fmath;
import flanagan.math.MinimizationFunction;

class GaussStandardProbPlotFunc
implements MinimizationFunction {
    private double[] dataArray = null;
    private double[] medians = null;
    private double[] weights = null;
    private boolean weighted = false;

    GaussStandardProbPlotFunc() {
    }

    @Override
    public double function(double[] dArray) {
        int n = this.dataArray.length;
        if (this.weighted) {
            for (int j = 0; j < n; ++j) {
                this.weights[j] = 1.0 / Math.sqrt(Stat.gaussianPDF(dArray[0], dArray[1], this.dataArray[j]));
            }
        }
        this.medians = Stat.gaussianOrderStatisticMedians(n);
        double d = 0.0;
        for (int j = 0; j < n; ++j) {
            d += Fmath.square((this.medians[j] - this.dataArray[j]) / this.weights[j]);
        }
        return d;
    }

    public void setDataArray(double[] dArray, double[] dArray2, boolean bl) {
        this.dataArray = dArray;
        this.weights = dArray2;
        this.weighted = bl;
    }
}

