/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.RegressionFunction;

class GumbelFunction
implements RegressionFunction {
    private boolean scaleOption = true;
    private double scaleFactor = 1.0;
    private int typeFlag = 0;

    GumbelFunction() {
    }

    @Override
    public double function(double[] dArray, double[] dArray2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.scaleFactor;
        switch (this.typeFlag) {
            case 0: {
                d2 = (dArray2[0] - dArray[0]) / dArray[1];
                if (this.scaleOption) {
                    d3 = dArray[2];
                }
                d = d3 / dArray[1] * Math.exp(d2) * Math.exp(-Math.exp(d2));
                break;
            }
            case 1: {
                d2 = (dArray[0] - dArray2[0]) / dArray[1];
                if (this.scaleOption) {
                    d3 = dArray[2];
                }
                d = d3 / dArray[1] * Math.exp(d2) * Math.exp(-Math.exp(d2));
                break;
            }
            case 2: {
                d2 = dArray2[0] / dArray[0];
                if (this.scaleOption) {
                    d3 = dArray[1];
                }
                d = d3 / dArray[0] * Math.exp(d2) * Math.exp(-Math.exp(d2));
                break;
            }
            case 3: {
                d2 = -dArray2[0] / dArray[0];
                if (this.scaleOption) {
                    d3 = dArray[1];
                }
                d = d3 / dArray[0] * Math.exp(d2) * Math.exp(-Math.exp(d2));
                break;
            }
            case 4: {
                if (this.scaleOption) {
                    d3 = dArray[0];
                }
                d = d3 * Math.exp(dArray2[0]) * Math.exp(-Math.exp(dArray2[0]));
                break;
            }
            case 5: {
                if (this.scaleOption) {
                    d3 = dArray[0];
                }
                d = d3 * Math.exp(-dArray2[0]) * Math.exp(-Math.exp(-dArray2[0]));
            }
        }
        return d;
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
    }

    public void setScaleOption(boolean bl) {
        this.scaleOption = bl;
    }

    public void setTypeFlag(int n) {
        this.typeFlag = n;
    }
}

