/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.RegressionFunction;
import flanagan.math.Fmath;

class LorentzianFunction
implements RegressionFunction {
    private boolean scaleOption = true;
    private double scaleFactor = 1.0;

    LorentzianFunction() {
    }

    @Override
    public double function(double[] dArray, double[] dArray2) {
        double d = this.scaleFactor;
        if (this.scaleOption) {
            d = dArray[2];
        }
        double d2 = d / Math.PI * (dArray[1] / 2.0) / (Fmath.square(dArray2[0] - dArray[0]) + Fmath.square(dArray[1] / 2.0));
        return d2;
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
    }

    public void setScaleOption(boolean bl) {
        this.scaleOption = bl;
    }
}

