/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.ProbabilityPlot;
import flanagan.analysis.Stat;
import flanagan.io.FileChooser;
import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Fmath;
import flanagan.math.TimeAndDate;
import flanagan.util.Strings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;

public class Normality {
    private double[] data = null;
    private double[] orderedData = null;
    private int[] originalindices = null;
    private double[] orderStatisticMedians = null;
    private int nPoints = 0;
    private double mean = Double.NaN;
    private double standardDeviation = Double.NaN;
    private double median = Double.NaN;
    private double momentSkewness = Double.NaN;
    private double medianSkewness = Double.NaN;
    private double quartileSkewness = Double.NaN;
    private double kurtosis = Double.NaN;
    private double curtosis = Double.NaN;
    private double excessKurtosis = Double.NaN;
    private double excessCurtosis = Double.NaN;
    private double maximum = Double.NaN;
    private double minimum = Double.NaN;
    private double range = Double.NaN;
    private double sumOfSquares = Double.NaN;
    private double[] shapiroWilkCoeff = null;
    private int nSWcoeff = 0;
    private boolean swCoeffDone = false;
    private double shapiroWilkWvalue = Double.NaN;
    private boolean swWvalueDone = false;
    private double shapiroWilkPvalue = Double.NaN;
    private boolean swPvalueDone = false;
    private double[] swWvalues = null;
    private double shapiroWilkCriticalWvalue = Double.NaN;
    private boolean swPCritDone = false;
    private double significance = 0.05;
    private int nSimulations = 10000;
    private ProbabilityPlot pp = null;
    private String filenameout = "NormalityAnalysis.txt";
    private String filenamein = null;
    private TimeAndDate tad = new TimeAndDate();
    private String time_date;
    private int trunc = 4;
    private int field0 = 35;
    private int field = 15;

    public Normality(double[] dArray) {
        this.data = dArray;
        this.initialise();
    }

    public Normality(float[] fArray) {
        ArrayMaths arrayMaths = new ArrayMaths(fArray);
        this.data = arrayMaths.array();
        this.initialise();
    }

    public Normality(long[] lArray) {
        ArrayMaths arrayMaths = new ArrayMaths(lArray);
        this.data = arrayMaths.array();
        this.initialise();
    }

    public Normality(int[] nArray) {
        ArrayMaths arrayMaths = new ArrayMaths(nArray);
        this.data = arrayMaths.array();
        this.initialise();
    }

    public Normality(BigDecimal[] bigDecimalArray) {
        ArrayMaths arrayMaths = new ArrayMaths(bigDecimalArray);
        this.data = arrayMaths.array_as_double();
        this.initialise();
    }

    public Normality(BigInteger[] bigIntegerArray) {
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray);
        this.data = arrayMaths.array_as_double();
        this.initialise();
    }

    public Normality() {
        this.data = null;
    }

    public void readDataFromTextFile() {
        int n;
        FileChooser fileChooser = new FileChooser();
        this.filenamein = fileChooser.selectFile();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n2 = fileChooser.numberOfLines();
        for (n = 0; n < n2; ++n) {
            String string = fileChooser.readLine();
            string = this.replacements(string);
            String[] stringArray = Strings.tokens(string);
            int n3 = stringArray.length;
            for (int j = 0; j < n3; ++j) {
                double d = Double.parseDouble(stringArray[j]);
                arrayList.add(d);
            }
        }
        fileChooser.close();
        this.nPoints = arrayList.size();
        this.data = new double[this.nPoints];
        for (n = 0; n < this.nPoints; ++n) {
            this.data[n] = (Double)arrayList.get(n);
        }
        this.initialise();
    }

    public String replacements(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        String string2 = "";
        for (int j = 0; j < n; ++j) {
            cArray[j] = string.charAt(j);
            if (cArray[j] == ',') {
                cArray[j] = 32;
            }
            if (cArray[j] == ';') {
                cArray[j] = 32;
            }
            if (cArray[j] == ':') {
                cArray[j] = 32;
            }
            if (cArray[j] == '\t') {
                cArray[j] = 32;
            }
            string2 = string2 + cArray[j];
        }
        return string2;
    }

    private void initialise() {
        this.nPoints = this.data.length;
        ArrayMaths arrayMaths = new ArrayMaths(this.data);
        arrayMaths = arrayMaths.sort();
        this.orderedData = arrayMaths.array();
        this.originalindices = arrayMaths.originalIndices();
        this.mean = Stat.mean(this.data);
        this.median = Stat.median(this.data);
        this.minimum = Fmath.minimum(this.data);
        this.maximum = Fmath.maximum(this.data);
        this.range = this.maximum - this.minimum;
        this.standardDeviation = Stat.standardDeviation(this.data);
        this.momentSkewness = Stat.momentSkewness(this.data);
        this.medianSkewness = Stat.medianSkewness(this.data);
        this.quartileSkewness = Stat.quartileSkewness(this.data);
        this.kurtosis = Stat.kurtosis(this.data);
        this.curtosis = Stat.kurtosis(this.data);
        this.excessKurtosis = Stat.excessKurtosis(this.data);
        this.excessCurtosis = Stat.excessKurtosis(this.data);
        this.sumOfSquares = 0.0;
        for (int j = 0; j < this.nPoints; ++j) {
            double d = this.data[j] - this.mean;
            this.sumOfSquares += d * d;
        }
        this.pp = new ProbabilityPlot(this.data);
        this.pp.suppressErrorMessages();
        this.pp.suppressFileOutput();
        this.time_date = this.tad.getShortTime24() + ", ";
        this.time_date = this.time_date + this.tad.getDate();
    }

    public void resetSignificanceLevel(double d) {
        this.significance = d;
    }

    public double getSignificanceLevel() {
        return this.significance;
    }

    public double mean() {
        return this.mean;
    }

    public double standardDeviation() {
        return this.standardDeviation;
    }

    public double momentSkewness() {
        return this.momentSkewness;
    }

    public double medianSkewness() {
        return this.medianSkewness;
    }

    public double quartileSkewness() {
        return this.quartileSkewness;
    }

    public double kurtosis() {
        return this.kurtosis;
    }

    public double curtosis() {
        return this.curtosis;
    }

    public double excessKurtosis() {
        return this.excessKurtosis;
    }

    public double excessCurtosis() {
        return this.excessCurtosis;
    }

    public double[] getData() {
        return this.data;
    }

    public double[] getOrderedOriginalData() {
        return this.orderedData;
    }

    public double[] getDataOrderStatisticMedians() {
        return this.orderStatisticMedians;
    }

    public double shapiroWilkWvalue() {
        if (!this.swCoeffDone) {
            this.shapiroWilkCoeff();
        }
        double d = 0.0;
        for (int j = 0; j < this.nSWcoeff; ++j) {
            int n = this.nPoints - j - 1;
            d += this.shapiroWilkCoeff[j] * (this.orderedData[n] - this.orderedData[j]);
        }
        d *= d;
        this.shapiroWilkWvalue = d / this.sumOfSquares;
        this.swWvalueDone = true;
        return this.shapiroWilkWvalue;
    }

    public double shapiroWilkPvalue() {
        if (!this.swCoeffDone) {
            this.shapiroWilkCoeff();
        }
        if (!this.swWvalueDone) {
            this.shapiroWilkWvalue();
        }
        this.swWvalues = new double[this.nSimulations];
        double[] dArray = new double[this.nPoints];
        int n = 0;
        for (int j = 0; j < this.nSimulations; ++j) {
            dArray = Stat.gaussianRand(this.mean, this.standardDeviation, this.nPoints);
            Normality normality = new Normality(dArray);
            this.swWvalues[j] = normality.shapiroWilkWvalue();
            if (!(this.shapiroWilkWvalue > this.swWvalues[j])) continue;
            ++n;
        }
        ArrayMaths arrayMaths = new ArrayMaths(this.swWvalues);
        this.swWvalues = arrayMaths.sort().array();
        this.shapiroWilkPvalue = (double)n / (double)this.nSimulations;
        this.swPvalueDone = true;
        return this.shapiroWilkPvalue;
    }

    public double shapiroWilkCriticalW() {
        if (!this.swCoeffDone) {
            this.shapiroWilkCoeff();
        }
        if (!this.swWvalueDone) {
            this.shapiroWilkWvalue();
        }
        if (!this.swPvalueDone) {
            this.shapiroWilkPvalue();
        }
        int n = (int)Math.round((double)this.nSimulations * this.significance);
        this.shapiroWilkCriticalWvalue = this.swWvalues[n];
        this.swPCritDone = true;
        return this.shapiroWilkCriticalWvalue;
    }

    public double shapiroWilkCriticalW(double d) {
        if (!this.swCoeffDone) {
            this.shapiroWilkCoeff();
        }
        if (!this.swWvalueDone) {
            this.shapiroWilkWvalue();
        }
        if (!this.swPvalueDone) {
            this.shapiroWilkPvalue();
        }
        int n = (int)Math.round((double)this.nSimulations * d);
        return this.swWvalues[n];
    }

    public double shapiroWilkCriticalW(double d, int n) {
        double d2 = Double.NaN;
        if (n == this.nPoints) {
            d2 = this.shapiroWilkCriticalW(d);
        } else {
            double[] dArray = new double[this.nSimulations];
            double[] dArray2 = new double[n];
            for (int j = 0; j < this.nSimulations; ++j) {
                dArray2 = Stat.gaussianRand(0.0, 1.0, n);
                Normality normality = new Normality(dArray2);
                dArray[j] = normality.shapiroWilkWvalue();
            }
            ArrayMaths arrayMaths = new ArrayMaths(dArray);
            dArray = arrayMaths.sort().array();
            int n2 = (int)Math.round((double)this.nSimulations * d);
            d2 = dArray[n2];
        }
        return d2;
    }

    public double[] shapiroWilkCoeff() {
        return this.shapiroWilkCoeff(this.nPoints);
    }

    public double[] shapiroWilkCoeff(int n) {
        int n2;
        int n3 = n;
        this.nSWcoeff = n2 = n / 2;
        if (n < 2) {
            n2 = 1;
        }
        double[] dArray = new double[n2 + 1];
        dArray[0] = Double.NaN;
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray2 = new double[]{Double.NaN, 0.0, 0.221157, -0.147981, -2.07119, 4.434685, -2.706056};
        double[] dArray3 = new double[]{Double.NaN, 0.0, 0.042981, -0.293762, -1.752461, 5.682633, -3.582633};
        double d3 = 0.0;
        double d4 = 1.0;
        double d5 = 2.0;
        double d6 = 0.70711;
        double d7 = 0.25;
        double d8 = 0.375;
        if (n < 2) {
            dArray[1] = 0.0;
        } else if (n == 2 || n == 3) {
            dArray[1] = d6;
        } else {
            double d9;
            int n4;
            int n5;
            double d10 = (double)n3 + d7;
            d = d3;
            for (n5 = 1; n5 <= n2; ++n5) {
                dArray[n5] = this.ppnd(((double)n5 - d8) / d10);
                d += Math.pow(dArray[n5], 2.0);
            }
            d2 = Math.sqrt(d *= d5);
            double d11 = d4 / Math.sqrt(n3);
            double d12 = this.poly(dArray2, 6, d11) - dArray[1] / d2;
            if (n > 5) {
                n4 = 3;
                double d13 = -dArray[2] / d2 + this.poly(dArray3, 6, d11);
                d9 = Math.sqrt((d - d5 * Math.pow(dArray[1], 2.0) - d5 * Math.pow(dArray[2], 2.0)) / (d4 - d5 * Math.pow(d12, 2.0) - d5 * Math.pow(d13, 2.0)));
                dArray[1] = d12;
                dArray[2] = d13;
            } else {
                n4 = 2;
                d9 = Math.sqrt((d - d5 * Math.pow(dArray[1], 2.0)) / (d4 - d5 * Math.pow(d12, 2.0)));
                dArray[1] = d12;
            }
            for (n5 = n4; n5 <= n2; ++n5) {
                dArray[n5] = -dArray[n5] / d9;
            }
        }
        this.shapiroWilkCoeff = this.shiftDown(dArray);
        this.swCoeffDone = true;
        return this.shapiroWilkCoeff;
    }

    public double ppnd(double d) {
        double d2 = 0.42;
        double d3 = 2.50662823884;
        double d4 = -18.61500062529;
        double d5 = 41.39119773534;
        double d6 = -25.44106049637;
        double d7 = -8.4735109309;
        double d8 = 23.08336743743;
        double d9 = -21.06224101826;
        double d10 = 3.13082909833;
        double d11 = -2.78718931138;
        double d12 = -2.29796479134;
        double d13 = 4.85014127135;
        double d14 = 2.32121276858;
        double d15 = 3.54388924762;
        double d16 = 1.63706781897;
        double d17 = 0.0;
        double d18 = 1.0;
        double d19 = 0.5;
        boolean bl = false;
        double d20 = d - d19;
        boolean bl2 = false;
        if (Math.abs(d20) > d2) {
            bl2 = true;
        }
        if (!bl2) {
            double d21 = d20 * d20;
            double d22 = d20 * (((d6 * d21 + d5) * d21 + d4) * d21 + d3) / ((((d10 * d21 + d9) * d21 + d8) * d21 + d7) * d21 + d18);
            return d22;
        }
        double d23 = d;
        if (d20 > d17) {
            d23 = d18 - d;
        }
        boolean bl3 = false;
        if (d23 <= d17) {
            bl3 = true;
        }
        if (!bl3) {
            d23 = Math.sqrt(-Math.log(d23));
            double d24 = (((d14 * d23 + d13) * d23 + d12) * d23 + d11) / ((d16 * d23 + d15) * d23 + d18);
            if (d20 < d17) {
                d24 = -d24;
            }
            return d24;
        }
        double d25 = d17;
        return d25;
    }

    public double poly(double[] dArray, int n, double d) {
        double d2 = dArray[1];
        if (n == 1) {
            return d2;
        }
        double d3 = d * dArray[n];
        boolean bl = false;
        if (n == 2) {
            bl = true;
        }
        if (!bl) {
            int n2 = n - 2;
            int n3 = n2 + 1;
            for (int j = 1; j <= n2; ++j) {
                d3 = (d3 + dArray[n3]) * d;
                --n3;
            }
        }
        return d2 += d3;
    }

    public double alnorm(double d, boolean bl) {
        double d2 = 0.0;
        double d3 = 1.0;
        double d4 = 0.5;
        double d5 = 7.0;
        double d6 = 18.66;
        double d7 = 1.28;
        double d8 = 0.398942280444;
        double d9 = 0.39990348504;
        double d10 = 0.398942280385;
        double d11 = 5.75885480458;
        double d12 = 2.62433121679;
        double d13 = 5.92885724438;
        double d14 = -29.8213557807;
        double d15 = 48.6959930692;
        double d16 = -3.8052E-8;
        double d17 = 3.98064794E-4;
        double d18 = -0.151679116635;
        double d19 = 4.8385912808;
        double d20 = 0.742380924027;
        double d21 = 3.99019417011;
        double d22 = 1.00000615302;
        double d23 = 1.98615381364;
        double d24 = 5.29330324926;
        double d25 = -15.1508972451;
        double d26 = 30.789933034;
        boolean bl2 = bl;
        double d27 = d;
        boolean bl3 = false;
        if (d27 >= d2) {
            bl3 = true;
        }
        if (!bl3) {
            bl2 = !bl2 ? true : true;
            d27 = -d27;
        }
        double d28 = 0.0;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (d27 <= d5 || bl2 && d27 <= d6) {
            bl6 = true;
        }
        if (!bl6) {
            d28 = d2;
            bl4 = true;
        }
        if (!bl4) {
            double d29 = d4 * d27 * d27;
            if (d27 > d7) {
                bl5 = true;
            }
            if (!bl5) {
                d28 = d4 - d27 * (d8 - d9 * d29 / (d29 + d11 + d14 / (d29 + d12 + d15 / (d29 + d13))));
                bl4 = true;
            }
            if (!bl4) {
                d28 = d10 * Math.exp(-d29) / (d27 + d16 + d22 / (d27 + d17 + d23 / (d27 + d18 + d24 / (d27 + d19 + d25 / (d27 + d20 + d26 / (d27 + d21))))));
            }
        }
        if (!bl2) {
            d28 = d3 - d28;
        }
        return d28;
    }

    public double swapSign(double d, double d2) {
        double d3 = Math.abs(d);
        if (d2 < 0.0) {
            d3 = -d3;
        }
        return d3;
    }

    public int swapSign(int n, int n2) {
        int n3 = Math.abs(n);
        if (n2 < 0) {
            n3 = -n3;
        }
        return n3;
    }

    public double[] shiftUp(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n + 1];
        dArray2[0] = Double.NaN;
        for (int j = 0; j < n; ++j) {
            dArray2[j + 1] = dArray[j];
        }
        return dArray2;
    }

    public double[] shiftDown(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n - 1];
        for (int j = 0; j < n - 1; ++j) {
            dArray2[j] = dArray[j + 1];
        }
        return dArray2;
    }

    public void resetNsimulation(int n) {
        this.nSimulations = n;
    }

    public int getNsimulation() {
        return this.nSimulations;
    }

    public void gaussianUserSuppliedInitialEstimates(double d, double d2) {
        this.pp.gaussianUserSuppliedInitialEstimates(d, d2);
    }

    public void normalUserSuppliedInitialEstimates(double d, double d2) {
        this.pp.normalUserSuppliedInitialEstimates(d, d2);
    }

    public void removeGaussianUserSuppliedInitialEstimates() {
        this.pp.removeGaussianUserSuppliedInitialEstimates();
    }

    public void removeNormalUserSuppliedInitialEstimates() {
        this.pp.removeNormalUserSuppliedInitialEstimates();
    }

    public void gaussianProbabilityPlot() {
        this.pp.gaussianProbabilityPlot();
    }

    public void normalProbabilityPlot() {
        this.pp.normalProbabilityPlot();
    }

    public double gaussianMu() {
        return this.pp.gaussianMu();
    }

    public double gaussianMuError() {
        return this.pp.gaussianMuError();
    }

    public double gaussianSigma() {
        return this.pp.gaussianSigma();
    }

    public double gaussianSigmaError() {
        return this.pp.gaussianSigmaError();
    }

    public double gaussianGradient() {
        return this.pp.gaussianGradient();
    }

    public double gaussianGradientError() {
        return this.pp.gaussianGradientError();
    }

    public double gaussianIntercept() {
        return this.pp.gaussianIntercept();
    }

    public double gaussianInterceptError() {
        return this.pp.gaussianInterceptError();
    }

    public double gaussianCorrelationCoefficient() {
        return this.pp.gaussianCorrelationCoefficient();
    }

    public double gaussianSumOfSquares() {
        return this.pp.gaussianSumOfSquares();
    }

    public double gaussianWeightedSumOfSquares() {
        return this.pp.gaussianWeightedSumOfSquares();
    }

    public double[] gaussianOrderStatisticMedians() {
        return this.pp.gaussianOrderStatisticMedians();
    }

    public double normalMu() {
        return this.pp.normalMu();
    }

    public double normalMuError() {
        return this.pp.normalMuError();
    }

    public double normalSigma() {
        return this.pp.normalSigma();
    }

    public double normalSigmaError() {
        return this.pp.normalSigmaError();
    }

    public double normalGradient() {
        return this.pp.normalGradient();
    }

    public double normalGradientError() {
        return this.pp.normalGradientError();
    }

    public double normalIntercept() {
        return this.pp.normalIntercept();
    }

    public double normalInterceptError() {
        return this.pp.normalInterceptError();
    }

    public double normalCorrelationCoefficient() {
        return this.pp.normalCorrelationCoefficient();
    }

    public double normalSumOfSquares() {
        return this.pp.normalSumOfSquares();
    }

    public double normalWeightedSumOfSquares() {
        return this.pp.normalWeightedSumOfSquares();
    }

    public double[] normalOrderStatisticMedians() {
        return this.pp.normalOrderStatisticMedians();
    }

    public void gaussianStandardProbabilityPlot() {
        this.pp.gaussianStandardProbabilityPlot();
    }

    public void normalStandardProbabilityPlot() {
        this.pp.normalStandardProbabilityPlot();
    }

    public double gaussianStandardGradient() {
        return this.pp.gaussianStandardGradient();
    }

    public double gaussianStandardGradientError() {
        return this.pp.gaussianStandardGradientError();
    }

    public double gaussianStandardIntercept() {
        return this.pp.gaussianStandardIntercept();
    }

    public double gaussianStandardInterceptError() {
        return this.pp.gaussianStandardInterceptError();
    }

    public double gaussianStandardCorrelationCoefficient() {
        return this.pp.gaussianStandardCorrelationCoefficient();
    }

    public double gaussianStandardSumOfSquares() {
        return this.pp.gaussianStandardSumOfSquares();
    }

    public double[] gaussianStandardOrderStatisticMedians() {
        return this.pp.gaussianStandardOrderStatisticMedians();
    }

    public double normalStandardGradient() {
        return this.pp.normalStandardGradient();
    }

    public double normalstandardGradientError() {
        return this.pp.normalstandardGradientError();
    }

    public double normalStandardInterceptError() {
        return this.pp.normalStandardInterceptError();
    }

    public double normalStandardCorrelationCoefficient() {
        return this.pp.normalStandardCorrelationCoefficient();
    }

    public double normalStandardSumOfSquares() {
        return this.pp.normalStandardSumOfSquares();
    }

    public double normalStandardWeightedSumOfSquares() {
        return this.pp.normalStandardWeightedSumOfSquares();
    }

    public double[] normalStandardOrderStatisticMedians() {
        return this.pp.normalStandardOrderStatisticMedians();
    }

    public void fullAnalysis() {
        this.fullAnalysis(this.filenameout);
    }

    public void fullAnalysis(String string) {
        int n = string.indexOf(".");
        if (n == -1) {
            string = string + ".txt";
        }
        this.filenameout = string;
        FileOutput fileOutput = new FileOutput(this.filenameout);
        fileOutput.println("Normality Analysis");
        if (this.filenamein != null) {
            fileOutput.println("Input file: " + this.filenamein);
        }
        fileOutput.println();
        fileOutput.println("File name: " + this.filenameout);
        fileOutput.println("Run date: " + this.time_date);
        fileOutput.println();
        fileOutput.print("Parameter / statistic", this.field0);
        fileOutput.print("Value", this.field);
        fileOutput.println("Error");
        fileOutput.print("Number of data points: ", this.field0);
        fileOutput.println(this.nPoints);
        fileOutput.print("Sample mean: ", this.field0);
        fileOutput.println(Fmath.truncate(this.mean, this.trunc));
        fileOutput.print("Sample median: ", this.field0);
        fileOutput.println(Fmath.truncate(this.median, this.trunc));
        fileOutput.print("Sample minimum: ", this.field0);
        fileOutput.println(Fmath.truncate(this.minimum, this.trunc));
        fileOutput.print("Sample maximum: ", this.field0);
        fileOutput.println(Fmath.truncate(this.maximum, this.trunc));
        fileOutput.print("Sample range: ", this.field0);
        fileOutput.println(Fmath.truncate(this.range, this.trunc));
        fileOutput.print("Sample standard deviation: ", this.field0);
        fileOutput.println(Fmath.truncate(this.standardDeviation, this.trunc));
        fileOutput.print("Sample moment skewnesss: ", this.field0);
        fileOutput.println(Fmath.truncate(this.momentSkewness, this.trunc));
        fileOutput.print("Sample median skewnesss: ", this.field0);
        fileOutput.println(Fmath.truncate(this.medianSkewness, this.trunc));
        fileOutput.print("Sample quartile skewnesss: ", this.field0);
        fileOutput.println(Fmath.truncate(this.quartileSkewness, this.trunc));
        fileOutput.print("Sample kurtosis: ", this.field0);
        fileOutput.println(Fmath.truncate(this.kurtosis, this.trunc));
        fileOutput.print("Sample excess kurtosis: ", this.field0);
        fileOutput.println(Fmath.truncate(this.excessKurtosis, this.trunc));
        fileOutput.println();
        fileOutput.println("Shapiro-Wilk W test");
        if (!this.swWvalueDone) {
            this.shapiroWilkWvalue = this.shapiroWilkWvalue();
        }
        fileOutput.print(" Shapiro-Wilk W value: ", this.field0);
        fileOutput.println(Fmath.truncate(this.shapiroWilkWvalue, this.trunc));
        if (!this.swPCritDone) {
            this.shapiroWilkCriticalWvalue = this.shapiroWilkCriticalW();
        }
        fileOutput.print(" Shapiro-Wilk W critical value: ", this.field0);
        fileOutput.println(Fmath.truncate(this.shapiroWilkCriticalWvalue, this.trunc));
        if (!this.swPvalueDone) {
            this.shapiroWilkPvalue = this.shapiroWilkPvalue();
        }
        fileOutput.print(" Shapiro-Wilk P value: ", this.field0);
        fileOutput.println(Fmath.truncate(this.shapiroWilkPvalue, this.trunc));
        String string2 = "Accepted";
        if (this.shapiroWilkWvalue < this.shapiroWilkCriticalWvalue) {
            string2 = "Rejected";
        }
        fileOutput.print(" Data possibly normal: ", this.field0);
        fileOutput.println(string2);
        fileOutput.println();
        fileOutput.println("Probability plot:");
        this.pp.gaussianProbabilityPlot();
        fileOutput.print(" Correlation coefficient, r: ", this.field0);
        double d = this.pp.gaussianCorrelationCoefficient();
        fileOutput.println(Fmath.truncate(d, this.trunc));
        fileOutput.println(" Critical value for r: ");
        double d2 = this.pp.correlationCoefficientCriticalValue();
        fileOutput.print("  (" + this.significance * 100.0 + "% Significance level)", this.field0);
        fileOutput.println(Fmath.truncate(d2, this.trunc));
        fileOutput.print(" Data possibly normal: ", this.field0);
        String string3 = "Rejected";
        if (d >= d2) {
            string3 = "Accepted";
        }
        fileOutput.println(string3);
        fileOutput.print(" Gradient: ", this.field0);
        fileOutput.print(Fmath.truncate(this.pp.gaussianGradient(), this.trunc), this.field);
        fileOutput.println(Fmath.truncate(this.pp.gaussianGradientError(), this.trunc));
        fileOutput.print(" Intercept: ", this.field0);
        fileOutput.print(Fmath.truncate(this.pp.gaussianIntercept(), this.trunc), this.field);
        fileOutput.println(Fmath.truncate(this.pp.gaussianInterceptError(), this.trunc));
        fileOutput.print(" Mean (best estimate): ", this.field0);
        fileOutput.print(Fmath.truncate(this.pp.gaussianMu(), this.trunc), this.field);
        fileOutput.println(Fmath.truncate(this.pp.gaussianMuError(), this.trunc));
        fileOutput.print(" Stand. devn. (best estimate): ", this.field0);
        fileOutput.print(Fmath.truncate(this.pp.gaussianSigma(), this.trunc), this.field);
        fileOutput.println(Fmath.truncate(this.pp.gaussianSigmaError(), this.trunc));
        fileOutput.println();
        fileOutput.println("Input data: ");
        int n2 = 0;
        for (int j = 0; j < this.nPoints; ++j) {
            fileOutput.print(this.data[j] + "  ");
            if (++n2 != 10) continue;
            fileOutput.println();
            n2 = 0;
        }
        fileOutput.close();
    }
}

