/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.Scores;
import flanagan.analysis.Stat;
import flanagan.io.Db;
import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Matrix;
import flanagan.math.PsRandom;
import flanagan.plot.PlotGraph;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.text.DateFormat;
import java.util.Date;

public class PCA
extends Scores {
    private Matrix data = null;
    private Matrix dataMinusMeans = null;
    private Matrix dataMinusMeansTranspose = null;
    private Matrix covarianceMatrix = null;
    private Matrix correlationMatrix = null;
    private Matrix partialCorrelationMatrix = null;
    private double kmo = 0.0;
    private double[] itemKMOs = null;
    private double chiSquareBartlett = 0.0;
    private int dfBartlett = 0;
    private double probBartlett = 0.0;
    private double sign10Bartlett = 0.0;
    private double sign05Bartlett = 0.0;
    private boolean bartlettDone = false;
    private double[] eigenValues = null;
    private double[] orderedEigenValues = null;
    private int[] eigenValueIndices = null;
    private double eigenValueTotal = 0.0;
    private int[] rotatedIndices = null;
    private double[] rotatedEigenValues = null;
    private double[] usRotatedEigenValues = null;
    private int nMonteCarlo = 200;
    private double[][] randomEigenValues = null;
    private double[] randomEigenValuesMeans = null;
    private double[] randomEigenValuesSDs = null;
    private double[] randomEigenValuesPercentiles = null;
    private double percentile = 95.0;
    private boolean gaussianDeviates = false;
    private double[] proportionPercentage = null;
    private double[] cumulativePercentage = null;
    private double[] rotatedProportionPercentage = null;
    private double[] rotatedCumulativePercentage = null;
    private double[][] eigenVectorsAsColumns = null;
    private double[][] eigenVectorsAsRows = null;
    private double[][] orderedEigenVectorsAsColumns = null;
    private double[][] orderedEigenVectorsAsRows = null;
    private double[][] loadingFactorsAsColumns = null;
    private double[][] loadingFactorsAsRows = null;
    private double[][] rotatedLoadingFactorsAsColumns = null;
    private double[][] rotatedLoadingFactorsAsRows = null;
    private double[][] usRotatedLoadingFactorsAsColumns = null;
    private double[][] usRotatedLoadingFactorsAsRows = null;
    private double[] communalities = null;
    private double[] communalityWeights = null;
    private boolean covRhoOption = false;
    private int greaterThanOneLimit = 0;
    private int percentileCrossover = 0;
    private int meanCrossover = 0;
    private int nVarimaxMax = 1000;
    private int nVarimax = 0;
    private double varimaxTolerance = 1.0E-8;
    private boolean varimaxOption = true;
    private boolean pcaDone = false;
    private boolean monteCarloDone = false;
    private boolean rotationDone = false;

    public PCA() {
        this.trunc = 4;
    }

    public void useCovarianceMatrix() {
        this.covRhoOption = true;
    }

    public void useCorrelationMatrix() {
        this.covRhoOption = false;
    }

    public void useNormalVarimax() {
        this.varimaxOption = true;
    }

    public void useRawVarimax() {
        this.varimaxOption = false;
    }

    public String getVarimaxOption() {
        if (this.varimaxOption) {
            return "normal varimax option";
        }
        return "raw varimax option";
    }

    public void setNumberOfSimulations(int n) {
        this.nMonteCarlo = n;
    }

    public int getNumberOfSimulations() {
        return this.nMonteCarlo;
    }

    public void useGaussianDeviates() {
        this.gaussianDeviates = true;
    }

    public void useUniformDeviates() {
        this.gaussianDeviates = false;
    }

    public void setParallelAnalysisPercentileValue(double d) {
        this.percentile = d;
    }

    public double getParallelAnalysisPercentileValue() {
        return this.percentile;
    }

    public void pca() {
        if (!this.pcaDone) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            if (this.nItems == 1) {
                throw new IllegalArgumentException("You have entered only one item - PCA is not meaningful");
            }
            if (this.nPersons == 1) {
                throw new IllegalArgumentException("You have entered only one score or measurement source - PCA is not meaningful");
            }
            if (!this.dataPreprocessed) {
                this.preprocessData();
            }
            this.data = new Matrix(this.scores0);
            this.dataMinusMeans = this.data.subtractRowMeans();
            this.dataMinusMeansTranspose = this.dataMinusMeans.transpose();
            this.covarianceMatrix = this.dataMinusMeans.times(this.dataMinusMeansTranspose);
            double d = this.nPersons;
            if (!this.nFactorOption) {
                d -= 1.0;
            }
            this.covarianceMatrix = this.covarianceMatrix.times(1.0 / d);
            boolean bl = false;
            double[][] dArray = this.covarianceMatrix.getArrayCopy();
            double[][] dArray2 = new double[this.nItems][this.nItems];
            for (int j = 0; j < this.nItems; ++j) {
                for (int k = 0; k < this.nItems; ++k) {
                    if (j == k) {
                        dArray2[j][k] = 1.0;
                        continue;
                    }
                    dArray2[j][k] = dArray[j][k] / Math.sqrt(dArray[j][j] * dArray[k][k]);
                    if (!Fmath.isNaN(dArray2[j][k])) continue;
                    dArray2[j][k] = 0.0;
                }
            }
            this.correlationMatrix = new Matrix(dArray2);
            double[][] dArray3 = new double[this.nItems][this.nItems];
            double[][] dArray4 = new double[this.nItems][this.nItems];
            for (n6 = 0; n6 < this.nItems; ++n6) {
                for (n5 = 0; n5 < this.nItems; ++n5) {
                    dArray3[n6][n5] = this.correlationMatrix.cofactor(n6, n5);
                }
            }
            for (n6 = 0; n6 < this.nItems; ++n6) {
                for (n5 = 0; n5 < this.nItems; ++n5) {
                    dArray4[n6][n5] = dArray3[n6][n5] == 0.0 && dArray3[n6][n6] == 0.0 && dArray3[n5][n5] == 0.0 ? 1.0 : (n6 == n5 ? 1.0 : -dArray3[n6][n5] / Math.sqrt(dArray3[n6][n6] * dArray3[n5][n5]));
                }
            }
            this.partialCorrelationMatrix = new Matrix(dArray4);
            double d2 = 0.0;
            double d3 = 0.0;
            for (n4 = 0; n4 < this.nItems; ++n4) {
                for (n3 = 0; n3 < this.nItems; ++n3) {
                    if (n4 == n3) continue;
                    d2 += dArray2[n4][n3] * dArray2[n4][n3];
                    d3 += dArray4[n4][n3] * dArray4[n4][n3];
                }
            }
            this.kmo = d2 == 0.0 && d3 == 0.0 ? 0.5 : d2 / (d2 + d3);
            this.itemKMOs = new double[this.nItems];
            for (n4 = 0; n4 < this.nItems; ++n4) {
                d2 = 0.0;
                d3 = 0.0;
                for (n3 = 0; n3 < this.nItems; ++n3) {
                    if (n4 == n3) continue;
                    d2 += dArray2[n4][n3] * dArray2[n4][n3];
                    d3 += dArray4[n4][n3] * dArray4[n4][n3];
                }
                this.itemKMOs[n4] = d2 == 0.0 && d3 == 0.0 ? 0.5 : d2 / (d2 + d3);
            }
            double d4 = this.correlationMatrix.determinant();
            this.chiSquareBartlett = -((double)(this.nPersons - 1) - (double)(2 * this.nItems + 5) / 6.0) * Math.log(Math.abs(d4));
            if (this.chiSquareBartlett >= 0.0) {
                this.dfBartlett = this.nItems * (this.nItems - 1) / 2;
                this.probBartlett = 1.0 - Stat.chiSquareCDF(this.chiSquareBartlett, this.dfBartlett);
                this.sign10Bartlett = Stat.chiSquareInverseCDF(this.dfBartlett, 0.9);
                this.sign05Bartlett = Stat.chiSquareInverseCDF(this.dfBartlett, 0.95);
                this.bartlettDone = true;
            }
            Matrix matrix = null;
            matrix = this.covRhoOption ? this.covarianceMatrix : this.correlationMatrix;
            this.eigenValues = matrix.getEigenValues();
            this.orderedEigenValues = matrix.getSortedEigenValues();
            this.eigenValueIndices = matrix.eigenValueIndices();
            this.eigenVectorsAsColumns = matrix.getEigenVectorsAsColumns();
            this.eigenVectorsAsRows = matrix.getEigenVectorsAsRows();
            this.orderedEigenVectorsAsColumns = matrix.getSortedEigenVectorsAsColumns();
            this.orderedEigenVectorsAsRows = matrix.getSortedEigenVectorsAsRows();
            ArrayMaths arrayMaths = new ArrayMaths(this.orderedEigenValues);
            double d5 = arrayMaths.sum();
            arrayMaths = arrayMaths.times(100.0 / d5);
            this.proportionPercentage = arrayMaths.array();
            this.cumulativePercentage = new double[this.nItems];
            this.cumulativePercentage[0] = this.proportionPercentage[0];
            this.eigenValueTotal = 0.0;
            for (n2 = 1; n2 < this.nItems; ++n2) {
                this.cumulativePercentage[n2] = this.cumulativePercentage[n2 - 1] + this.proportionPercentage[n2];
                this.eigenValueTotal += this.eigenValues[n2];
            }
            n2 = 1;
            int n7 = 0;
            while (n2 != 0) {
                if (this.orderedEigenValues[n7] < 1.0) {
                    this.greaterThanOneLimit = n7;
                    n2 = 0;
                    continue;
                }
                if (++n7 != this.nItems) continue;
                this.greaterThanOneLimit = n7;
                n2 = 0;
            }
            this.loadingFactorsAsColumns = new double[this.nItems][this.nItems];
            this.loadingFactorsAsRows = new double[this.nItems][this.nItems];
            for (n = 0; n < this.nItems; ++n) {
                for (int j = 0; j < this.nItems; ++j) {
                    this.loadingFactorsAsColumns[n][j] = this.orderedEigenVectorsAsColumns[n][j] * Math.sqrt(Math.abs(this.orderedEigenValues[j]));
                    this.loadingFactorsAsRows[n][j] = this.orderedEigenVectorsAsRows[n][j] * Math.sqrt(Math.abs(this.orderedEigenValues[n]));
                }
            }
            this.communalities = new double[this.nItems];
            this.communalityWeights = new double[this.nItems];
            for (n = 0; n < this.nItems; ++n) {
                double d6 = 0.0;
                for (int j = 0; j < this.nItems; ++j) {
                    d6 += this.loadingFactorsAsRows[j][n] * this.loadingFactorsAsRows[j][n];
                }
                this.communalities[n] = d6;
                this.communalityWeights[n] = Math.sqrt(this.communalities[n]);
            }
        }
        this.pcaDone = true;
    }

    public void monteCarlo() {
        int n;
        if (!this.pcaDone) {
            this.pca();
        }
        double[] dArray = super.rawItemMeans();
        double[] dArray2 = super.rawItemStandardDeviations();
        double[][] dArray3 = new double[this.nItems][this.nPersons];
        this.randomEigenValues = new double[this.nMonteCarlo][this.nItems];
        PsRandom psRandom = new PsRandom();
        for (int j = 0; j < this.nMonteCarlo; ++j) {
            for (int k = 0; k < this.nItems; ++k) {
                if (this.gaussianDeviates) {
                    dArray3[k] = psRandom.gaussianArray(dArray[k], dArray2[k], this.nPersons);
                    continue;
                }
                dArray3[k] = psRandom.doubleArray(this.nPersons);
                dArray3[k] = Stat.scale(dArray3[k], dArray[k], dArray2[k]);
            }
            PCA pCA = new PCA();
            if (this.covRhoOption) {
                pCA.useCovarianceMatrix();
            } else {
                pCA.useCorrelationMatrix();
            }
            pCA.enterScoresAsRowPerItem(dArray3);
            this.randomEigenValues[j] = pCA.orderedEigenValues();
        }
        Matrix matrix = new Matrix(this.randomEigenValues);
        this.randomEigenValuesMeans = matrix.columnMeans();
        this.randomEigenValuesSDs = matrix.columnStandardDeviations();
        this.randomEigenValuesPercentiles = new double[this.nItems];
        int n2 = (int)Math.ceil((double)this.nMonteCarlo * this.percentile / 100.0);
        int n3 = n2 - 1;
        double d = this.percentile * (double)this.nMonteCarlo / 100.0 - (double)n3;
        --n2;
        --n3;
        for (n = 0; n < this.nItems; ++n) {
            double[] dArray4 = new double[this.nMonteCarlo];
            for (int j = 0; j < this.nMonteCarlo; ++j) {
                dArray4[j] = this.randomEigenValues[j][n];
            }
            ArrayMaths arrayMaths = new ArrayMaths(dArray4);
            arrayMaths = arrayMaths.sort();
            dArray4 = arrayMaths.array();
            this.randomEigenValuesPercentiles[n] = dArray4[n3] + d * (dArray4[n2] - dArray4[n3]);
        }
        n = 1;
        int n4 = 0;
        while (n != 0) {
            if (this.orderedEigenValues[n4] <= this.randomEigenValuesPercentiles[n4]) {
                this.percentileCrossover = n4;
                n = 0;
                continue;
            }
            if (++n4 != this.nItems) continue;
            this.percentileCrossover = n4;
            n = 0;
        }
        n = 1;
        n4 = 0;
        while (n != 0) {
            if (this.orderedEigenValues[n4] <= this.randomEigenValuesMeans[n4]) {
                this.meanCrossover = n4;
                n = 0;
                continue;
            }
            if (++n4 != this.nItems) continue;
            this.meanCrossover = n4;
            n = 0;
        }
        this.monteCarloDone = true;
    }

    public void screePlotDataAlone() {
        if (!this.pcaDone) {
            this.pca();
        }
        double[] dArray = new double[this.nItems];
        for (int j = 0; j < this.nItems; ++j) {
            dArray[j] = j + 1;
        }
        PlotGraph plotGraph = new PlotGraph(dArray, this.orderedEigenValues);
        plotGraph.setGraphTitle("Principal Component Analysis Scree Plot");
        plotGraph.setXaxisLegend("Component");
        plotGraph.setYaxisLegend("Eigenvalues");
        plotGraph.setLine(3);
        plotGraph.setPoint(1);
        plotGraph.plot();
    }

    public void screePlot() {
        if (!this.pcaDone) {
            this.pca();
        }
        if (!this.monteCarloDone) {
            this.monteCarlo();
        }
        double[][] dArray = new double[6][this.nItems];
        double[] dArray2 = new double[this.nItems];
        for (int j = 0; j < this.nItems; ++j) {
            dArray2[j] = j + 1;
        }
        dArray[0] = dArray2;
        dArray[1] = this.orderedEigenValues;
        dArray[2] = dArray2;
        dArray[3] = this.randomEigenValuesPercentiles;
        dArray[4] = dArray2;
        dArray[5] = this.randomEigenValuesMeans;
        PlotGraph plotGraph = new PlotGraph(dArray);
        plotGraph.setErrorBars(2, this.randomEigenValuesSDs);
        if (this.gaussianDeviates) {
            plotGraph.setGraphTitle("Principal Component Analysis Scree Plot with Parallel Analysis using Gaussian deviates (" + this.nMonteCarlo + " simulations)");
        } else {
            plotGraph.setGraphTitle("Principal Component Analysis Scree Plot with Parallel Analysis using uniform deviates (" + this.nMonteCarlo + " simulations)");
        }
        plotGraph.setGraphTitle2("Closed squares - data eigenvalues; open circles = Monte Carlo eigenvalue " + this.percentile + "% percentiles; error bars = standard deviations about the Monte carlo means (crosses)");
        plotGraph.setXaxisLegend("Component");
        plotGraph.setYaxisLegend("Eigenvalue");
        int[] nArray = new int[]{3, 0, 3};
        plotGraph.setLine(nArray);
        int[] nArray2 = new int[]{5, 1, 7};
        plotGraph.setPoint(nArray2);
        plotGraph.plot();
    }

    public void setVarimaxTolerance(double d) {
        this.varimaxTolerance = d;
    }

    public void setVarimaxMaximumIterations(int n) {
        this.nVarimaxMax = n;
    }

    public int getVarimaxIterations() {
        return this.nVarimax;
    }

    public void varimaxRotation(int n) {
        if (!this.pcaDone) {
            this.pca();
        }
        if (this.varimaxOption) {
            this.normalVarimaxRotation(n);
        } else {
            this.rawVarimaxRotation(n);
        }
    }

    public void varimaxRotation(double[][] dArray) {
        if (this.varimaxOption) {
            System.out.println("Method varimaxRotation: communality weights not supplied - raw varimax option used");
        }
        this.rawVarimaxRotationInHouse(dArray);
    }

    public void varimaxRotation(double[][] dArray, double[] dArray2) {
        if (this.varimaxOption) {
            this.normalVarimaxRotationInHouse(dArray, dArray2);
        } else {
            System.out.println("Method varimaxRotation: raw varimax option chosen, supplied communality weights ignored");
            this.rawVarimaxRotationInHouse(dArray);
        }
    }

    public void rawVarimaxRotation(int n) {
        if (!this.pcaDone) {
            this.pca();
        }
        double[][] dArray = new double[n][this.nItems];
        for (int j = 0; j < n; ++j) {
            dArray[j] = this.loadingFactorsAsRows[j];
        }
        double[] dArray2 = new double[this.nItems];
        for (int j = 0; j < this.nItems; ++j) {
            dArray2[j] = 1.0;
        }
        this.normalVarimaxRotationInHouse(dArray, dArray2);
    }

    private void rawVarimaxRotationInHouse(double[][] dArray) {
        double[] dArray2 = new double[this.nItems];
        for (int j = 0; j < this.nItems; ++j) {
            dArray2[j] = 1.0;
        }
        this.normalVarimaxRotationInHouse(dArray, dArray2);
    }

    public void normalVarimaxRotation(int n) {
        if (!this.pcaDone) {
            this.pca();
        }
        double[][] dArray = new double[n][this.nItems];
        for (int j = 0; j < n; ++j) {
            dArray[j] = this.loadingFactorsAsRows[j];
        }
        double[] dArray2 = new double[this.nItems];
        for (int j = 0; j < this.nItems; ++j) {
            dArray2[j] = 0.0;
            for (int k = 0; k < n; ++k) {
                int n2 = j;
                dArray2[n2] = dArray2[n2] + dArray[k][j] * dArray[k][j];
            }
        }
        this.normalVarimaxRotationInHouse(dArray, dArray2);
    }

    private void normalVarimaxRotationInHouse(double[][] dArray, double[] dArray2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (!this.pcaDone) {
            this.pca();
        }
        int n7 = dArray.length;
        int n8 = dArray[0].length;
        this.usRotatedLoadingFactorsAsRows = new double[n7][n8];
        this.rotatedLoadingFactorsAsRows = new double[n7][n8];
        this.usRotatedEigenValues = new double[n7];
        this.rotatedEigenValues = new double[n7];
        this.rotatedProportionPercentage = new double[n7];
        this.rotatedCumulativePercentage = new double[n7];
        for (n6 = 0; n6 < n8; ++n6) {
            dArray2[n6] = Math.sqrt(dArray2[n6]);
        }
        for (n6 = 0; n6 < n7; ++n6) {
            for (int j = 0; j < n8; ++j) {
                if (dArray[n6][j] == 0.0 && dArray2[j] == 0.0) {
                    dArray[n6][j] = 1.0;
                } else {
                    double[] dArray3 = dArray[n6];
                    int n9 = j;
                    dArray3[n9] = dArray3[n9] / dArray2[j];
                }
                this.usRotatedLoadingFactorsAsRows[n6][j] = dArray[n6][j];
            }
        }
        double d = PCA.varimaxCriterion(this.usRotatedLoadingFactorsAsRows);
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl = true;
        this.nVarimax = 0;
        while (bl) {
            for (n5 = 0; n5 < n7 - 1; ++n5) {
                for (n4 = n5 + 1; n4 < n7; ++n4) {
                    d3 = PCA.varimaxAngle(this.usRotatedLoadingFactorsAsRows, n5, n4);
                    this.usRotatedLoadingFactorsAsRows = PCA.singleRotation(this.usRotatedLoadingFactorsAsRows, n5, n4, d3);
                    d = PCA.varimaxCriterion(this.usRotatedLoadingFactorsAsRows);
                }
            }
            if (Math.abs(d - d2) < this.varimaxTolerance) {
                bl = false;
                continue;
            }
            d2 = d;
            ++this.nVarimax;
            if (this.nVarimax <= this.nVarimaxMax) continue;
            bl = false;
            System.out.println("Method varimaxRotation: maximum iterations " + this.nVarimaxMax + " exceeded");
            System.out.println("Tolerance = " + this.varimaxTolerance + ",     Comparison value = " + Math.abs(d - d2));
            System.out.println("Current values returned");
            if (this.sameCheck <= 0) continue;
            System.out.println("Presence of identical element row/s and/or column/s in the data probably impeding convergence");
            System.out.println("Returned values are likely to be correct");
        }
        this.usRotatedLoadingFactorsAsColumns = new double[n8][n7];
        for (n5 = 0; n5 < n7; ++n5) {
            for (n4 = 0; n4 < n8; ++n4) {
                double[] dArray4 = this.usRotatedLoadingFactorsAsRows[n5];
                int n10 = n4;
                dArray4[n10] = dArray4[n10] * dArray2[n4];
                this.usRotatedLoadingFactorsAsColumns[n4][n5] = this.usRotatedLoadingFactorsAsRows[n5][n4];
                double[] dArray5 = dArray[n5];
                int n11 = n4;
                dArray5[n11] = dArray5[n11] * dArray2[n4];
            }
        }
        double d4 = 0.0;
        double d5 = 0.0;
        for (int j = 0; j < n7; ++j) {
            this.usRotatedEigenValues[j] = 0.0;
            for (int k = 0; k < n8; ++k) {
                int n12 = j;
                this.usRotatedEigenValues[n12] = this.usRotatedEigenValues[n12] + this.usRotatedLoadingFactorsAsRows[j][k] * this.usRotatedLoadingFactorsAsRows[j][k];
            }
            d4 += this.usRotatedEigenValues[j];
            d5 += this.orderedEigenValues[j];
        }
        ArrayMaths arrayMaths = new ArrayMaths(this.usRotatedEigenValues);
        arrayMaths = arrayMaths.sort();
        this.usRotatedEigenValues = arrayMaths.array();
        int[] nArray = arrayMaths.originalIndices();
        int n13 = n7 / 2;
        double d6 = 0.0;
        int n14 = 0;
        for (n3 = 0; n3 < n13; ++n3) {
            d6 = this.usRotatedEigenValues[n3];
            this.usRotatedEigenValues[n3] = this.usRotatedEigenValues[n7 - 1 - n3];
            this.usRotatedEigenValues[n7 - 1 - n3] = d6;
            n14 = nArray[n3];
            nArray[n3] = nArray[n7 - 1 - n3];
            nArray[n7 - 1 - n3] = n14;
        }
        n3 = this.usRotatedLoadingFactorsAsRows.length;
        int n15 = this.usRotatedLoadingFactorsAsRows[0].length;
        double[][] dArray6 = new double[n3][n15];
        for (int j = 0; j < n3; ++j) {
            for (n2 = 0; n2 < n15; ++n2) {
                dArray6[j][n2] = this.usRotatedLoadingFactorsAsRows[nArray[j]][n2];
            }
        }
        this.usRotatedLoadingFactorsAsRows = Conv.copy(dArray6);
        n3 = nArray.length;
        this.rotatedIndices = new int[n3];
        int[] nArray2 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray2[n2] = this.eigenValueIndices[nArray[n2]];
        }
        this.rotatedIndices = Conv.copy(this.eigenValueIndices);
        for (n2 = 0; n2 < n3; ++n2) {
            this.rotatedIndices[n2] = nArray2[n2];
        }
        double d7 = Math.abs(d5 / d4);
        double d8 = Math.sqrt(d7);
        for (n = 0; n < n7; ++n) {
            this.rotatedEigenValues[n] = d7 * this.usRotatedEigenValues[n];
            this.rotatedProportionPercentage[n] = this.rotatedEigenValues[n] * 100.0 / this.eigenValueTotal;
            for (int j = 0; j < n8; ++j) {
                this.rotatedLoadingFactorsAsRows[n][j] = d8 * this.usRotatedLoadingFactorsAsRows[n][j];
            }
        }
        this.rotatedCumulativePercentage[0] = this.rotatedProportionPercentage[0];
        for (n = 1; n < n7; ++n) {
            this.rotatedCumulativePercentage[n] = this.rotatedCumulativePercentage[n - 1] + this.rotatedProportionPercentage[n];
        }
        this.rotationDone = true;
    }

    public static double[][] rawVarimaxRotation(double[][] dArray) {
        double d = 1.0E-4;
        int n = 1000;
        return PCA.rawVarimaxRotation(dArray, d, n);
    }

    public static double[][] rawVarimaxRotation(double[][] dArray, double d, int n) {
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        double[] dArray2 = new double[n3];
        for (int j = 0; j < n3; ++j) {
            dArray2[j] = 1.0;
        }
        return PCA.normalVarimaxRotation(dArray, dArray2, d, n);
    }

    public static double[][] normalVarimaxRotation(double[][] dArray, double[] dArray2) {
        double d = 1.0E-4;
        int n = 1000;
        return PCA.normalVarimaxRotation(dArray, dArray2, d, n);
    }

    public static double[][] normalVarimaxRotation(double[][] dArray, double[] dArray2, double d, int n) {
        int n2;
        int n3;
        int n4 = dArray.length;
        int n5 = dArray[0].length;
        for (int j = 1; j < n4; ++j) {
            if (dArray[j].length == n5) continue;
            throw new IllegalArgumentException("All rows must be the same length");
        }
        double[][] dArray3 = new double[n4][n5];
        for (int j = 0; j < n4; ++j) {
            for (int k = 0; k < n5; ++k) {
                double[] dArray4 = dArray[j];
                int n6 = k;
                dArray4[n6] = dArray4[n6] / dArray2[k];
                dArray3[j][k] = dArray[j][k];
            }
        }
        double d2 = PCA.varimaxCriterion(dArray3);
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = true;
        int n7 = 0;
        while (bl) {
            for (n3 = 0; n3 < n4 - 1; ++n3) {
                for (n2 = n3 + 1; n2 < n4; ++n2) {
                    d4 = PCA.varimaxAngle(dArray3, n3, n2);
                    dArray3 = PCA.singleRotation(dArray3, n3, n2, d4);
                    d2 = PCA.varimaxCriterion(dArray3);
                }
            }
            if (Math.abs(d2 - d3) < d) {
                bl = false;
                continue;
            }
            d3 = d2;
            if (++n7 <= n) continue;
            bl = false;
            System.out.println("Method varimaxRotation: maximum iterations " + n + " exceeded");
            System.out.println("Current values returned");
        }
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                double[] dArray5 = dArray3[n3];
                int n8 = n2;
                dArray5[n8] = dArray5[n8] * dArray2[n2];
                double[] dArray6 = dArray[n3];
                int n9 = n2;
                dArray6[n9] = dArray6[n9] * dArray2[n2];
            }
        }
        return dArray3;
    }

    public static double[][] transposeMatrix(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int j = 1; j < n; ++j) {
            if (dArray[j].length == n2) continue;
            throw new IllegalArgumentException("All rows must be the same length");
        }
        double[][] dArray2 = new double[n2][n];
        for (int j = 0; j < n; ++j) {
            for (int k = 0; k < n2; ++k) {
                dArray2[k][j] = dArray[j][k];
            }
        }
        return dArray2;
    }

    public static double varimaxCriterion(double[][] dArray) {
        int n;
        double d;
        int n2;
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            d = 0.0;
            for (n = 0; n < n4; ++n) {
                d += Math.pow(dArray[n2][n], 4.0);
            }
            d2 += d;
        }
        d2 *= (double)n4;
        for (n2 = 0; n2 < n3; ++n2) {
            d = 0.0;
            for (n = 0; n < n4; ++n) {
                d += Math.pow(dArray[n2][n], 2.0);
            }
            d3 += d * d;
        }
        d4 = d2 - d3;
        return d4;
    }

    public static double varimaxAngle(double[][] dArray, int n, int n2) {
        int n3 = dArray[0].length;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int j = 0; j < n3; ++j) {
            double d7 = dArray[n][j];
            double d8 = dArray[n2][j];
            d = d7 * d7 - d8 * d8;
            d2 = 2.0 * d7 * d8;
            d3 += d;
            d4 += d2;
            d5 += d * d - d2 * d2;
            d6 += 2.0 * d * d2;
        }
        double d9 = d6 - 2.0 * d3 * d4 / (double)n3;
        double d10 = d5 - (d3 * d3 - d4 * d4) / (double)n3;
        double d11 = 0.25 * Math.atan2(d9, d10);
        return d11;
    }

    public static double[][] singleRotation(double[][] dArray, int n, int n2, double d) {
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        double[][] dArray2 = new double[n3][n4];
        for (int j = 0; j < n3; ++j) {
            for (int k = 0; k < n4; ++k) {
                dArray2[j][k] = dArray[j][k];
            }
        }
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        for (int j = 0; j < n4; ++j) {
            dArray2[n][j] = dArray[n][j] * d3 + dArray[n2][j] * d2;
            dArray2[n2][j] = -dArray[n][j] * d2 + dArray[n2][j] * d3;
        }
        return dArray2;
    }

    public double[] eigenValues() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.eigenValues;
    }

    public double[] orderedEigenValues() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.orderedEigenValues;
    }

    public int[] eigenValueIndices() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.eigenValueIndices;
    }

    public double eigenValueTotal() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.eigenValueTotal;
    }

    public double[] proportionPercentage() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.proportionPercentage;
    }

    public double[] cumulativePercentage() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.cumulativePercentage;
    }

    public double[] rotatedEigenValues() {
        if (!this.rotationDone) {
            throw new IllegalArgumentException("No rotation has been performed");
        }
        return this.rotatedEigenValues;
    }

    public double[] rotatedProportionPercentage() {
        if (!this.rotationDone) {
            throw new IllegalArgumentException("No rotation has been performed");
        }
        return this.rotatedProportionPercentage;
    }

    public double[] rotatedCumulativePercentage() {
        if (!this.rotationDone) {
            throw new IllegalArgumentException("No rotation has been performed");
        }
        return this.rotatedCumulativePercentage;
    }

    public double[][] eigenVectors() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.eigenVectorsAsColumns;
    }

    public double[][] eigenVectorsAsRows() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.eigenVectorsAsRows;
    }

    public double[][] orderedEigenVectorsAsColumns() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.orderedEigenVectorsAsColumns;
    }

    public double[][] orderedEigenVectors() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.orderedEigenVectorsAsColumns;
    }

    public double[][] orderedEigenVectorsAsRows() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.orderedEigenVectorsAsRows;
    }

    public double[][] loadingFactorsAsColumns() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.loadingFactorsAsColumns;
    }

    public double[][] loadingFactorsAsRows() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.loadingFactorsAsRows;
    }

    public double[][] rotatedLoadingFactorsAsColumns() {
        if (!this.rotationDone) {
            throw new IllegalArgumentException("No rotation has been performed");
        }
        return this.rotatedLoadingFactorsAsColumns;
    }

    public double[][] rotatedLoadingFactorsAsRows() {
        if (!this.rotationDone) {
            throw new IllegalArgumentException("No rotation has been performed");
        }
        return this.rotatedLoadingFactorsAsRows;
    }

    public double[] communalities() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.communalities;
    }

    public double[] communalityWeights() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.communalityWeights;
    }

    public Matrix covarianceMatrix() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.covarianceMatrix;
    }

    public Matrix correlationMatrix() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.correlationMatrix;
    }

    public Matrix partialCorrelationMatrix() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.partialCorrelationMatrix;
    }

    public double[] monteCarloMeans() {
        if (!this.monteCarloDone) {
            this.monteCarlo();
        }
        return this.randomEigenValuesMeans;
    }

    public double[] monteCarloStandardDeviations() {
        if (!this.monteCarloDone) {
            this.monteCarlo();
        }
        return this.randomEigenValuesSDs;
    }

    public double[] monteCarloPercentiles() {
        if (!this.monteCarloDone) {
            this.monteCarlo();
        }
        return this.randomEigenValuesPercentiles;
    }

    public double[][] monteCarloEigenValues() {
        if (!this.monteCarloDone) {
            this.monteCarlo();
        }
        return this.randomEigenValues;
    }

    public Matrix originalData() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.data;
    }

    public Matrix xMatrix() {
        if (!this.pcaDone) {
            this.pca();
        }
        double d = this.nItems;
        if (!this.nFactorOption) {
            d -= 1.0;
        }
        Matrix matrix = this.dataMinusMeans.times(1.0 / Math.sqrt(d));
        return matrix;
    }

    public Matrix xMatrixTranspose() {
        if (!this.pcaDone) {
            this.pca();
        }
        double d = this.nItems;
        if (!this.nFactorOption) {
            d -= 1.0;
        }
        Matrix matrix = this.dataMinusMeansTranspose.times(1.0 / Math.sqrt(d));
        return matrix;
    }

    public int nEigenOneOrGreater() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.greaterThanOneLimit;
    }

    public int nMeanCrossover() {
        if (!this.monteCarloDone) {
            this.monteCarlo();
        }
        return this.meanCrossover;
    }

    public int nPercentileCrossover() {
        if (!this.monteCarloDone) {
            this.monteCarlo();
        }
        return this.percentileCrossover;
    }

    public double overallKMO() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.kmo;
    }

    public double kmo() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.kmo;
    }

    public double[] itemKMOs() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.itemKMOs;
    }

    public double chiSquareBartlett() {
        if (!this.pcaDone) {
            this.pca();
        }
        if (this.bartlettDone) {
            return this.chiSquareBartlett;
        }
        System.out.println("Method chiSquareBartlett(): Bartlett Sphericity Test nor performed, NaN returned");
        return Double.NaN;
    }

    public int dofBartlett() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.dfBartlett;
    }

    public double probabilityBartlett() {
        if (!this.pcaDone) {
            this.pca();
        }
        if (this.bartlettDone) {
            return this.probBartlett;
        }
        System.out.println("Method probabilityBartlett(): Bartlett Sphericity Test nor performed, NaN returned");
        return Double.NaN;
    }

    public void analysis() {
        this.outputFilename = "PCAOutput";
        this.outputFilename = this.fileOption == 1 ? this.outputFilename + ".txt" : this.outputFilename + ".xls";
        String string = "Output file name for the analysis details:";
        String string2 = "\nEnter the required name (as a single word) and click OK ";
        String string3 = "\nor simply click OK for default value";
        String string4 = string + string2 + string3;
        String string5 = this.outputFilename;
        this.outputFilename = Db.readLine(string4, string5);
        this.analysis(this.outputFilename);
    }

    public void analysis(String string) {
        this.screePlot();
        this.outputFilename = string;
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(46);
        if (n == -1) {
            string2 = string;
            this.outputFilename = this.fileOption == 1 ? this.outputFilename + ".txt" : this.outputFilename + ".xls";
        } else {
            int n2;
            int n3;
            String[] stringArray;
            String[] stringArray2;
            String string4;
            String string5;
            String string6;
            String string7;
            string3 = string.substring(n).trim();
            string2 = string.substring(0, n).trim();
            if (string3.equalsIgnoreCase(".xls") && this.fileOption == 1) {
                if (this.fileOptionSet) {
                    string7 = "Your entered output file type is .xls";
                    string6 = "\nbut you have chosen a .txt output";
                    string5 = "Your output file name extension";
                    string4 = string7 + string6;
                    stringArray2 = new String[]{string4, "replace it with .txt [text file]"};
                    n2 = Db.optionBox(string5, stringArray2, stringArray = new String[]{"Retain", ".txt"}, n3 = 1);
                    if (n2 == 2) {
                        this.outputFilename = string2 + ".txt";
                    }
                } else {
                    this.fileOption = 2;
                }
            }
            if (string3.equalsIgnoreCase(".txt") && this.fileOption == 2) {
                if (this.fileOptionSet) {
                    string7 = "Your entered output file type is .txt";
                    string6 = "\nbut you have chosen a .xls output";
                    string5 = "Your output file name extension";
                    string4 = string7 + string6;
                    stringArray2 = new String[]{string4, "replace it with .xls [Excel file]"};
                    n2 = Db.optionBox(string5, stringArray2, stringArray = new String[]{"Retain", ".xls"}, n3 = 1);
                    if (n2 == 2) {
                        this.outputFilename = string2 + ".xls";
                    }
                } else {
                    this.fileOption = 1;
                }
            }
            if (!string3.equalsIgnoreCase(".txt") && !string3.equalsIgnoreCase(".xls")) {
                string7 = "Your extension is " + string3;
                string6 = "\n    Do you wish to retain it:";
                string4 = string7 + string6;
                string5 = "Your output file name extension";
                stringArray2 = new String[]{string4, "replace it with .txt [text file]", "replace it with .xls [MS Excel file]"};
                stringArray = new String[]{"Retain", ".txt", ".xls"};
                n3 = 1;
                n2 = Db.optionBox(string5, stringArray2, stringArray, n3);
                switch (n2) {
                    case 1: {
                        this.fileOption = 1;
                        break;
                    }
                    case 2: {
                        this.outputFilename = string2 + ".txt";
                        this.fileOption = 1;
                        break;
                    }
                    case 3: {
                        this.outputFilename = string2 + ".xls";
                        this.fileOption = 2;
                    }
                }
            }
        }
        if (this.fileOption == 1) {
            this.analysisText();
        } else {
            this.analysisExcel();
        }
        System.out.println("The analysis has been written to the file " + this.outputFilename);
    }

    private void analysisText() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        FileOutput fileOutput = null;
        fileOutput = this.fileNumberingSet ? new FileOutput(this.outputFilename, 'n') : new FileOutput(this.outputFilename);
        if (!this.pcaDone) {
            this.pca();
        }
        if (!this.monteCarloDone) {
            this.monteCarlo();
        }
        fileOutput.println("PRINCIPAL COMPONENT ANALYSIS");
        fileOutput.println("Program: PCA - Analysis Output");
        for (int j = 0; j < this.titleLines; ++j) {
            fileOutput.println(this.title[j]);
        }
        Date date = new Date();
        String string = DateFormat.getDateInstance().format(date);
        String string2 = DateFormat.getTimeInstance().format(date);
        fileOutput.println("Program executed at " + string2 + " on " + string);
        fileOutput.println();
        if (this.covRhoOption) {
            fileOutput.println("Covariance matrix used");
        } else {
            fileOutput.println("Correlation matrix used");
        }
        fileOutput.println();
        int n7 = 10;
        int n8 = 12;
        int n9 = 2;
        fileOutput.println("ALL EIGENVALUES");
        fileOutput.print("Component ", n7);
        fileOutput.print("Unordered ", n7);
        fileOutput.print("Eigenvalue ", n8);
        fileOutput.print("Proportion ", n8);
        fileOutput.print("Cumulative ", n8);
        fileOutput.println("Difference ");
        fileOutput.print(" ", n7);
        fileOutput.print("index", n7);
        fileOutput.print(" ", n8);
        fileOutput.print("as % ", n8);
        fileOutput.print("percentage ", n8);
        fileOutput.println(" ");
        for (n6 = 0; n6 < this.nItems; ++n6) {
            fileOutput.print(n6 + 1, n7);
            fileOutput.print(this.eigenValueIndices[n6] + 1, n7);
            fileOutput.print(Fmath.truncate(this.orderedEigenValues[n6], this.trunc), n8);
            fileOutput.print(Fmath.truncate(this.proportionPercentage[n6], this.trunc), n8);
            fileOutput.print(Fmath.truncate(this.cumulativePercentage[n6], this.trunc), n8);
            if (n6 < this.nItems - 1) {
                fileOutput.print(Fmath.truncate(this.orderedEigenValues[n6] - this.orderedEigenValues[n6 + 1], this.trunc), n8);
            } else {
                fileOutput.print(" ", n8);
            }
            fileOutput.print(" ", n9);
            fileOutput.println();
        }
        fileOutput.println();
        n6 = this.greaterThanOneLimit;
        if (n6 < this.meanCrossover) {
            n6 = this.meanCrossover;
        }
        if (n6 < this.percentileCrossover) {
            n6 = this.percentileCrossover;
        }
        fileOutput.println("EXTRACTED EIGENVALUES");
        fileOutput.print(" ", n7);
        fileOutput.print("Greater than unity", 3 * n8 + n9);
        fileOutput.print("Greater than Monte Carlo Mean ", 3 * n8 + n9);
        fileOutput.println("Greater than Monte Carlo Percentile");
        fileOutput.print("Component ", n7);
        fileOutput.print("Eigenvalue ", n8);
        fileOutput.print("Proportion ", n8);
        fileOutput.print("Cumulative ", n8);
        fileOutput.print(" ", n9);
        fileOutput.print("Eigenvalue ", n8);
        fileOutput.print("Proportion ", n8);
        fileOutput.print("Cumulative ", n8);
        fileOutput.print(" ", n9);
        fileOutput.print("Eigenvalue ", n8);
        fileOutput.print("Proportion ", n8);
        fileOutput.print("Cumulative ", n8);
        fileOutput.println(" ");
        fileOutput.print(" ", n7);
        fileOutput.print(" ", n8);
        fileOutput.print("as % ", n8);
        fileOutput.print("percentage ", n8);
        fileOutput.print(" ", n9);
        fileOutput.print(" ", n8);
        fileOutput.print("as % ", n8);
        fileOutput.print("percentage ", n8);
        fileOutput.print(" ", n9);
        fileOutput.print(" ", n8);
        fileOutput.print("as % ", n8);
        fileOutput.print("percentage ", n8);
        fileOutput.println(" ");
        for (int j = 0; j < n6; ++j) {
            fileOutput.print(j + 1, n7);
            if (j < this.greaterThanOneLimit) {
                fileOutput.print(Fmath.truncate(this.orderedEigenValues[j], this.trunc), n8);
                fileOutput.print(Fmath.truncate(this.proportionPercentage[j], this.trunc), n8);
                fileOutput.print(Fmath.truncate(this.cumulativePercentage[j], this.trunc), n8 + n9);
            }
            if (j < this.meanCrossover) {
                fileOutput.print(Fmath.truncate(this.orderedEigenValues[j], this.trunc), n8);
                fileOutput.print(Fmath.truncate(this.proportionPercentage[j], this.trunc), n8);
                fileOutput.print(Fmath.truncate(this.cumulativePercentage[j], this.trunc), n8 + n9);
            }
            if (j < this.percentileCrossover) {
                fileOutput.print(Fmath.truncate(this.orderedEigenValues[j], this.trunc), n8);
                fileOutput.print(Fmath.truncate(this.proportionPercentage[j], this.trunc), n8);
                fileOutput.print(Fmath.truncate(this.cumulativePercentage[j], this.trunc));
            }
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.println("PARALLEL ANALYSIS");
        fileOutput.println("Number of simulations = " + this.nMonteCarlo);
        if (this.gaussianDeviates) {
            fileOutput.println("Gaussian random deviates used");
        } else {
            fileOutput.println("Uniform random deviates used");
        }
        fileOutput.println("Percentile value used = " + this.percentile + " %");
        fileOutput.println();
        fileOutput.print("Component ", n7);
        fileOutput.print("Data ", n8);
        fileOutput.print("Proportion ", n8);
        fileOutput.print("Cumulative ", n8);
        fileOutput.print(" ", n9);
        fileOutput.print("Data ", n8);
        fileOutput.print("Monte Carlo ", n8);
        fileOutput.print("Monte Carlo ", n8);
        fileOutput.println("Monte Carlo ");
        fileOutput.print(" ", n7);
        fileOutput.print("Eigenvalue ", n8);
        fileOutput.print("as % ", n8);
        fileOutput.print("percentage ", n8);
        fileOutput.print(" ", n9);
        fileOutput.print("Eigenvalue ", n8);
        fileOutput.print("Eigenvalue ", n8);
        fileOutput.print("Eigenvalue ", n8);
        fileOutput.println("Eigenvalue ");
        fileOutput.print(" ", n7);
        fileOutput.print(" ", n8);
        fileOutput.print(" ", n8);
        fileOutput.print(" ", n8);
        fileOutput.print(" ", n9);
        fileOutput.print(" ", n8);
        fileOutput.print("Percentile ", n8);
        fileOutput.print("Mean ", n8);
        fileOutput.println("Standard Deviation ");
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.print(n5 + 1, n7);
            fileOutput.print(Fmath.truncate(this.orderedEigenValues[n5], this.trunc), n8);
            fileOutput.print(Fmath.truncate(this.proportionPercentage[n5], this.trunc), n8);
            fileOutput.print(Fmath.truncate(this.cumulativePercentage[n5], this.trunc), n8);
            fileOutput.print(" ", n9);
            fileOutput.print(Fmath.truncate(this.orderedEigenValues[n5], this.trunc), n8);
            fileOutput.print(Fmath.truncate(this.randomEigenValuesPercentiles[n5], this.trunc), n8);
            fileOutput.print(Fmath.truncate(this.randomEigenValuesMeans[n5], this.trunc), n8);
            fileOutput.println(Fmath.truncate(this.randomEigenValuesSDs[n5], this.trunc));
        }
        fileOutput.println();
        fileOutput.println("CORRELATION MATRIX");
        fileOutput.println("Original item indices in parenthesis");
        fileOutput.println();
        fileOutput.print(" ", n7);
        fileOutput.print("item", n7);
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.print(this.eigenValueIndices[n5] + 1 + " (" + (n5 + 1) + ")", n8);
        }
        fileOutput.println();
        fileOutput.println("item");
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.print(this.eigenValueIndices[n5] + 1 + " (" + (n5 + 1) + ")", 2 * n7);
            for (n4 = 0; n4 < this.nItems; ++n4) {
                fileOutput.print(Fmath.truncate(this.correlationMatrix.getElement(n4, n5), this.trunc), n8);
            }
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.println("PARTIAL CORRELATION MATRIX");
        fileOutput.println("Original item indices in parenthesis");
        fileOutput.println();
        fileOutput.print(" ", n7);
        fileOutput.print("item", n7);
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.print(this.eigenValueIndices[n5] + 1 + " (" + (n5 + 1) + ")", n8);
        }
        fileOutput.println();
        fileOutput.println("item");
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.print(this.eigenValueIndices[n5] + 1 + " (" + (n5 + 1) + ")", 2 * n7);
            for (n4 = 0; n4 < this.nItems; ++n4) {
                fileOutput.print(Fmath.truncate(this.partialCorrelationMatrix.getElement(n4, n5), this.trunc), n8);
            }
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.println("COVARIANCE MATRIX");
        fileOutput.println("Original item indices in parenthesis");
        fileOutput.println();
        fileOutput.print(" ", n7);
        fileOutput.print("item", n7);
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.print(this.eigenValueIndices[n5] + 1 + " (" + (n5 + 1) + ")", n8);
        }
        fileOutput.println();
        fileOutput.println("item");
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.print(this.eigenValueIndices[n5] + 1 + " (" + (n5 + 1) + ")", 2 * n7);
            for (n4 = 0; n4 < this.nItems; ++n4) {
                fileOutput.print(Fmath.truncate(this.covarianceMatrix.getElement(n4, n5), this.trunc), n8);
            }
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.println("EIGENVECTORS");
        fileOutput.println("Original component indices in parenthesis");
        fileOutput.println("Vector corresponding to an ordered eigenvalues in each row");
        fileOutput.println();
        fileOutput.print(" ", n7);
        fileOutput.print("component", n7);
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.print(this.eigenValueIndices[n5] + 1 + " (" + (n5 + 1) + ")", n8);
        }
        fileOutput.println();
        fileOutput.println("component");
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.print(n5 + 1 + " (" + (this.eigenValueIndices[n5] + 1) + ")", 2 * n7);
            for (n4 = 0; n4 < this.nItems; ++n4) {
                fileOutput.print(Fmath.truncate(this.orderedEigenVectorsAsRows[n5][n4], this.trunc), n8);
            }
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.println("LOADING FACTORS");
        fileOutput.println("Original  indices in parenthesis");
        fileOutput.println("Loading factors corresponding to an ordered eigenvalues in each row");
        fileOutput.println();
        fileOutput.print(" ", n7);
        fileOutput.print("component", n7);
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.print(this.eigenValueIndices[n5] + 1 + " (" + (n5 + 1) + ")", n8);
        }
        fileOutput.print(" ", n7);
        fileOutput.print("Eigenvalue", n8);
        fileOutput.print("Proportion", n8);
        fileOutput.println("Cumulative %");
        fileOutput.println("factor");
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.print(n5 + 1 + " (" + (this.eigenValueIndices[n5] + 1) + ")", 2 * n7);
            for (n4 = 0; n4 < this.nItems; ++n4) {
                fileOutput.print(Fmath.truncate(this.loadingFactorsAsRows[n5][n4], this.trunc), n8);
            }
            fileOutput.print(" ", n7);
            fileOutput.print(Fmath.truncate(this.orderedEigenValues[n5], this.trunc), n8);
            fileOutput.print(Fmath.truncate(this.proportionPercentage[n5], this.trunc), n8);
            fileOutput.println(Fmath.truncate(this.cumulativePercentage[n5], this.trunc));
        }
        fileOutput.println();
        fileOutput.println("ROTATED LOADING FACTORS");
        if (this.varimaxOption) {
            fileOutput.println("NORMAL VARIMAX");
        } else {
            fileOutput.println("RAW VARIMAX");
        }
        String string3 = "The ordered eigenvalues with Monte Carlo means and percentiles in parenthesis";
        string3 = string3 + "\n (Total number of eigenvalues = " + this.nItems + ")";
        n4 = this.nItems;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n10 = dimension.height;
        int n11 = 20 * n10 / 800;
        if (n4 > n4) {
            n4 = n11;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            string3 = string3 + "\n " + Fmath.truncate(this.orderedEigenValues[n3], 4) + " (" + Fmath.truncate(this.randomEigenValuesMeans[n3], 4) + "  " + Fmath.truncate(this.randomEigenValuesPercentiles[n3], 4) + ")";
        }
        if (n4 < this.nItems) {
            string3 = string3 + "\n . . . ";
        }
        string3 = string3 + "\nEnter number of eigenvalues to be extracted";
        n3 = this.greaterThanOneLimit;
        n3 = Db.readInt(string3, n3);
        this.varimaxRotation(n3);
        fileOutput.println("Varimax rotation for " + n3 + " extracted factors");
        fileOutput.println("Rotated loading factors and eigenvalues scaled to ensure total 'rotated variance' matches unrotated variance for the extracted factors");
        fileOutput.println("Original  indices in parenthesis");
        fileOutput.println();
        fileOutput.print(" ", n7);
        fileOutput.print("component", n7);
        for (n2 = 0; n2 < this.nItems; ++n2) {
            fileOutput.print(this.rotatedIndices[n2] + 1 + " (" + (n2 + 1) + ")", n8);
        }
        fileOutput.print(" ", n7);
        fileOutput.print("Eigenvalue", n8);
        fileOutput.print("Proportion", n8);
        fileOutput.println("Cumulative %");
        fileOutput.println("factor");
        for (n2 = 0; n2 < n3; ++n2) {
            fileOutput.print(n2 + 1 + " (" + (this.rotatedIndices[n2] + 1) + ")", 2 * n7);
            for (n = 0; n < this.nItems; ++n) {
                fileOutput.print(Fmath.truncate(this.rotatedLoadingFactorsAsRows[n2][n], this.trunc), n8);
            }
            fileOutput.print(" ", n7);
            fileOutput.print(Fmath.truncate(this.rotatedEigenValues[n2], this.trunc), n8);
            fileOutput.print(Fmath.truncate(this.rotatedProportionPercentage[n2], this.trunc), n8);
            fileOutput.println(Fmath.truncate(this.rotatedCumulativePercentage[n2], this.trunc));
        }
        fileOutput.println();
        fileOutput.println("Kaiser-Meyer-Olkin (KMO) statistic");
        fileOutput.println("   Overall KMO statistic =   " + Fmath.truncate(this.kmo, this.trunc));
        fileOutput.println("   KMO values for each item");
        fileOutput.print("   ");
        for (n2 = 0; n2 < this.nItems; ++n2) {
            fileOutput.print(n2 + 1, n8);
        }
        fileOutput.println();
        fileOutput.print("   ");
        for (n2 = 0; n2 < this.nItems; ++n2) {
            fileOutput.print(Fmath.truncate(this.itemKMOs[n2], this.trunc), n8);
        }
        fileOutput.println();
        fileOutput.println();
        if (this.bartlettDone) {
            fileOutput.println();
            fileOutput.println("Bartlett Sphericity Test");
            fileOutput.println("   Chi-Square =         " + Fmath.truncate(this.chiSquareBartlett, this.trunc));
            fileOutput.println("   Probability value =  " + Fmath.truncate(this.probBartlett, this.trunc));
            fileOutput.println("   Degrees of freedom = " + this.dfBartlett);
            fileOutput.println("   Chi-Square value at the 5% significance level  (p = 0.05) = " + Fmath.truncate(this.sign05Bartlett, this.trunc));
            fileOutput.println("   Chi-Square value at the 10% significance level (p = 0.10) = " + Fmath.truncate(this.sign10Bartlett, this.trunc));
            fileOutput.println();
        }
        fileOutput.println("DATA USED");
        fileOutput.println("Number of items = " + this.nItems);
        fileOutput.println("Number of persons = " + this.nPersons);
        if (this.originalDataType == 0) {
            fileOutput.printtab("Item");
            for (n2 = 0; n2 < this.nPersons; ++n2) {
                fileOutput.printtab(n2 + 1);
            }
            fileOutput.println();
            for (n2 = 0; n2 < this.nItems; ++n2) {
                fileOutput.printtab(this.itemNames[n2]);
                for (n = 0; n < this.nPersons; ++n) {
                    fileOutput.printtab(Fmath.truncate(this.scores0[n2][n], this.trunc));
                }
                fileOutput.println();
            }
        } else {
            fileOutput.printtab("Person");
            for (n2 = 0; n2 < this.nItems; ++n2) {
                fileOutput.printtab(this.itemNames[n2]);
            }
            fileOutput.println();
            for (n2 = 0; n2 < this.nPersons; ++n2) {
                fileOutput.printtab(n2 + 1);
                for (n = 0; n < this.nItems; ++n) {
                    fileOutput.printtab(Fmath.truncate(this.scores1[n2][n], this.trunc));
                }
                fileOutput.println();
            }
        }
        fileOutput.close();
    }

    private void analysisExcel() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        FileOutput fileOutput = null;
        fileOutput = this.fileNumberingSet ? new FileOutput(this.outputFilename, 'n') : new FileOutput(this.outputFilename);
        if (!this.pcaDone) {
            this.pca();
        }
        if (!this.monteCarloDone) {
            this.monteCarlo();
        }
        fileOutput.println("PRINCIPAL COMPONENT ANALYSIS");
        fileOutput.println("Program: PCA - Analysis Output");
        for (int j = 0; j < this.titleLines; ++j) {
            fileOutput.println(this.title[j]);
        }
        Date date = new Date();
        String string = DateFormat.getDateInstance().format(date);
        String string2 = DateFormat.getTimeInstance().format(date);
        fileOutput.println("Program executed at " + string2 + " on " + string);
        fileOutput.println();
        if (this.covRhoOption) {
            fileOutput.println("Covariance matrix used");
        } else {
            fileOutput.println("Correlation matrix used");
        }
        fileOutput.println();
        fileOutput.println("ALL EIGENVALUES");
        fileOutput.printtab("Component ");
        fileOutput.printtab("Unordered ");
        fileOutput.printtab("Eigenvalue ");
        fileOutput.printtab("Proportion ");
        fileOutput.printtab("Cumulative ");
        fileOutput.println("Difference ");
        fileOutput.printtab(" ");
        fileOutput.printtab("index");
        fileOutput.printtab(" ");
        fileOutput.printtab("as % ");
        fileOutput.printtab("percentage ");
        fileOutput.println(" ");
        for (n6 = 0; n6 < this.nItems; ++n6) {
            fileOutput.printtab(n6 + 1);
            fileOutput.printtab(this.eigenValueIndices[n6] + 1);
            fileOutput.printtab(Fmath.truncate(this.orderedEigenValues[n6], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.proportionPercentage[n6], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.cumulativePercentage[n6], this.trunc));
            if (n6 < this.nItems - 1) {
                fileOutput.printtab(Fmath.truncate(this.orderedEigenValues[n6] - this.orderedEigenValues[n6 + 1], this.trunc));
            } else {
                fileOutput.printtab(" ");
            }
            fileOutput.printtab(" ");
            fileOutput.println();
        }
        fileOutput.println();
        n6 = this.greaterThanOneLimit;
        if (n6 < this.meanCrossover) {
            n6 = this.meanCrossover;
        }
        if (n6 < this.percentileCrossover) {
            n6 = this.percentileCrossover;
        }
        fileOutput.println("EXTRACTED EIGENVALUES");
        fileOutput.printtab(" ");
        fileOutput.printtab("Greater than unity");
        fileOutput.printtab(" ");
        fileOutput.printtab(" ");
        fileOutput.printtab(" ");
        fileOutput.printtab("Greater than Monte Carlo Mean ");
        fileOutput.printtab(" ");
        fileOutput.printtab(" ");
        fileOutput.printtab(" ");
        fileOutput.println("Greater than Monte Carlo Percentile");
        fileOutput.printtab("Component ");
        fileOutput.printtab("Eigenvalue ");
        fileOutput.printtab("Proportion ");
        fileOutput.printtab("Cumulative ");
        fileOutput.printtab(" ");
        fileOutput.printtab("Eigenvalue ");
        fileOutput.printtab("Proportion ");
        fileOutput.printtab("Cumulative ");
        fileOutput.printtab(" ");
        fileOutput.printtab("Eigenvalue ");
        fileOutput.printtab("Proportion ");
        fileOutput.printtab("Cumulative ");
        fileOutput.println(" ");
        fileOutput.printtab(" ");
        fileOutput.printtab(" ");
        fileOutput.printtab("as % ");
        fileOutput.printtab("percentage ");
        fileOutput.printtab(" ");
        fileOutput.printtab(" ");
        fileOutput.printtab("as % ");
        fileOutput.printtab("percentage ");
        fileOutput.printtab(" ");
        fileOutput.printtab(" ");
        fileOutput.printtab("as % ");
        fileOutput.printtab("percentage ");
        fileOutput.println(" ");
        for (int j = 0; j < n6; ++j) {
            fileOutput.printtab(j + 1);
            if (j < this.greaterThanOneLimit) {
                fileOutput.printtab(Fmath.truncate(this.orderedEigenValues[j], this.trunc));
                fileOutput.printtab(Fmath.truncate(this.proportionPercentage[j], this.trunc));
                fileOutput.printtab(Fmath.truncate(this.cumulativePercentage[j], this.trunc));
                fileOutput.printtab(" ");
            }
            if (j < this.meanCrossover) {
                fileOutput.printtab(Fmath.truncate(this.orderedEigenValues[j], this.trunc));
                fileOutput.printtab(Fmath.truncate(this.proportionPercentage[j], this.trunc));
                fileOutput.printtab(Fmath.truncate(this.cumulativePercentage[j], this.trunc));
                fileOutput.printtab(" ");
            }
            if (j < this.percentileCrossover) {
                fileOutput.printtab(Fmath.truncate(this.orderedEigenValues[j], this.trunc));
                fileOutput.printtab(Fmath.truncate(this.proportionPercentage[j], this.trunc));
                fileOutput.printtab(Fmath.truncate(this.cumulativePercentage[j], this.trunc));
            }
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.println("PARALLEL ANALYSIS");
        fileOutput.println("Number of simulations = " + this.nMonteCarlo);
        if (this.gaussianDeviates) {
            fileOutput.println("Gaussian random deviates used");
        } else {
            fileOutput.println("Uniform random deviates used");
        }
        fileOutput.println("Percentile value used = " + this.percentile + " %");
        fileOutput.println();
        fileOutput.printtab("Component ");
        fileOutput.printtab("Data ");
        fileOutput.printtab("Proportion ");
        fileOutput.printtab("Cumulative ");
        fileOutput.printtab(" ");
        fileOutput.printtab("Data ");
        fileOutput.printtab("Monte Carlo ");
        fileOutput.printtab("Monte Carlo ");
        fileOutput.println("Monte Carlo ");
        fileOutput.printtab(" ");
        fileOutput.printtab("Eigenvalue ");
        fileOutput.printtab("as % ");
        fileOutput.printtab("percentage ");
        fileOutput.printtab(" ");
        fileOutput.printtab("Eigenvalue ");
        fileOutput.printtab("Eigenvalue ");
        fileOutput.printtab("Eigenvalue ");
        fileOutput.println("Eigenvalue ");
        fileOutput.printtab(" ");
        fileOutput.printtab(" ");
        fileOutput.printtab(" ");
        fileOutput.printtab(" ");
        fileOutput.printtab(" ");
        fileOutput.printtab(" ");
        fileOutput.printtab("Percentile ");
        fileOutput.printtab("Mean ");
        fileOutput.println("Standard Deviation ");
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.printtab(n5 + 1);
            fileOutput.printtab(Fmath.truncate(this.orderedEigenValues[n5], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.proportionPercentage[n5], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.cumulativePercentage[n5], this.trunc));
            fileOutput.printtab(" ");
            fileOutput.printtab(Fmath.truncate(this.orderedEigenValues[n5], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.randomEigenValuesPercentiles[n5], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.randomEigenValuesMeans[n5], this.trunc));
            fileOutput.println(Fmath.truncate(this.randomEigenValuesSDs[n5], this.trunc));
        }
        fileOutput.println();
        fileOutput.println("CORRELATION MATRIX");
        fileOutput.println("Original item indices in parenthesis");
        fileOutput.println();
        fileOutput.printtab(" ");
        fileOutput.printtab("item");
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.printtab(this.eigenValueIndices[n5] + 1 + " (" + (n5 + 1) + ")");
        }
        fileOutput.println();
        fileOutput.println("item");
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.printtab(this.eigenValueIndices[n5] + 1 + " (" + (n5 + 1) + ")");
            fileOutput.printtab(" ");
            for (n4 = 0; n4 < this.nItems; ++n4) {
                fileOutput.printtab(Fmath.truncate(this.correlationMatrix.getElement(n4, n5), this.trunc));
            }
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.println("PARTIAL CORRELATION MATRIX");
        fileOutput.println("Original item indices in parenthesis");
        fileOutput.println();
        fileOutput.printtab(" ");
        fileOutput.printtab("item");
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.printtab(this.eigenValueIndices[n5] + 1 + " (" + (n5 + 1) + ")");
        }
        fileOutput.println();
        fileOutput.println("item");
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.printtab(this.eigenValueIndices[n5] + 1 + " (" + (n5 + 1) + ")");
            fileOutput.printtab(" ");
            for (n4 = 0; n4 < this.nItems; ++n4) {
                fileOutput.printtab(Fmath.truncate(this.partialCorrelationMatrix.getElement(n4, n5), this.trunc));
            }
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.println("COVARIANCE MATRIX");
        fileOutput.println("Original item indices in parenthesis");
        fileOutput.println();
        fileOutput.printtab(" ");
        fileOutput.printtab("item");
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.printtab(this.eigenValueIndices[n5] + 1 + " (" + (n5 + 1) + ")");
        }
        fileOutput.println();
        fileOutput.println("item");
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.printtab(this.eigenValueIndices[n5] + 1 + " (" + (n5 + 1) + ")");
            fileOutput.printtab(" ");
            for (n4 = 0; n4 < this.nItems; ++n4) {
                fileOutput.printtab(Fmath.truncate(this.covarianceMatrix.getElement(n4, n5), this.trunc));
            }
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.println("EIGENVECTORS");
        fileOutput.println("Original component indices in parenthesis");
        fileOutput.println("Vector corresponding to an ordered eigenvalues in each row");
        fileOutput.println();
        fileOutput.printtab(" ");
        fileOutput.printtab("component");
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.printtab(this.eigenValueIndices[n5] + 1 + " (" + (n5 + 1) + ")");
        }
        fileOutput.println();
        fileOutput.println("component");
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.printtab(n5 + 1 + " (" + (this.eigenValueIndices[n5] + 1) + ")");
            fileOutput.printtab(" ");
            for (n4 = 0; n4 < this.nItems; ++n4) {
                fileOutput.printtab(Fmath.truncate(this.orderedEigenVectorsAsRows[n5][n4], this.trunc));
            }
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.println("LOADING FACTORS");
        fileOutput.println("Original  indices in parenthesis");
        fileOutput.println("Loading factors corresponding to an ordered eigenvalues in each row");
        fileOutput.println();
        fileOutput.printtab(" ");
        fileOutput.printtab("component");
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.printtab(this.eigenValueIndices[n5] + 1 + " (" + (n5 + 1) + ")");
        }
        fileOutput.printtab(" ");
        fileOutput.printtab("Eigenvalue");
        fileOutput.printtab("% Proportion");
        fileOutput.println("Cumulative %");
        fileOutput.println("factor");
        for (n5 = 0; n5 < this.nItems; ++n5) {
            fileOutput.printtab(n5 + 1 + " (" + (this.eigenValueIndices[n5] + 1) + ")");
            fileOutput.printtab(" ");
            for (n4 = 0; n4 < this.nItems; ++n4) {
                fileOutput.printtab(Fmath.truncate(this.loadingFactorsAsRows[n5][n4], this.trunc));
            }
            fileOutput.printtab(" ");
            fileOutput.printtab(Fmath.truncate(this.orderedEigenValues[n5], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.proportionPercentage[n5], this.trunc));
            fileOutput.println(Fmath.truncate(this.cumulativePercentage[n5], this.trunc));
        }
        fileOutput.println();
        fileOutput.println("ROTATED LOADING FACTORS");
        if (this.varimaxOption) {
            fileOutput.println("NORMAL VARIMAX");
        } else {
            fileOutput.println("RAW VARIMAX");
        }
        String string3 = "The ordered eigenvalues with Monte Carlo means and percentiles in parenthesis";
        string3 = string3 + "\n (Total number of eigenvalues = " + this.nItems + ")";
        n4 = this.nItems;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n7 = dimension.height;
        int n8 = 20 * n7 / 800;
        if (n4 > n4) {
            n4 = n8;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            string3 = string3 + "\n " + Fmath.truncate(this.orderedEigenValues[n3], 4) + " (" + Fmath.truncate(this.randomEigenValuesMeans[n3], 4) + "  " + Fmath.truncate(this.randomEigenValuesPercentiles[n3], 4) + ")";
        }
        if (n4 < this.nItems) {
            string3 = string3 + "\n . . . ";
        }
        string3 = string3 + "\nEnter number of eigenvalues to be extracted";
        n3 = this.greaterThanOneLimit;
        n3 = Db.readInt(string3, n3);
        this.varimaxRotation(n3);
        fileOutput.println("Varimax rotation for " + n3 + " extracted factors");
        fileOutput.println("Rotated loading factors and eigenvalues scaled to ensure total 'rotated variance' matches unrotated variance for the extracted factors");
        fileOutput.println("Original  indices in parenthesis");
        fileOutput.println();
        fileOutput.printtab(" ");
        fileOutput.printtab("component");
        for (n2 = 0; n2 < this.nItems; ++n2) {
            fileOutput.printtab(this.rotatedIndices[n2] + 1 + " (" + (n2 + 1) + ")");
        }
        fileOutput.printtab(" ");
        fileOutput.printtab("Eigenvalue");
        fileOutput.printtab("% Proportion");
        fileOutput.println("Cumulative %");
        fileOutput.println("factor");
        for (n2 = 0; n2 < n3; ++n2) {
            fileOutput.printtab(n2 + 1 + " (" + (this.rotatedIndices[n2] + 1) + ")");
            fileOutput.printtab(" ");
            for (n = 0; n < this.nItems; ++n) {
                fileOutput.printtab(Fmath.truncate(this.rotatedLoadingFactorsAsRows[n2][n], this.trunc));
            }
            fileOutput.printtab(" ");
            fileOutput.printtab(Fmath.truncate(this.rotatedEigenValues[n2], this.trunc));
            fileOutput.printtab(Fmath.truncate(this.rotatedProportionPercentage[n2], this.trunc));
            fileOutput.println(Fmath.truncate(this.rotatedCumulativePercentage[n2], this.trunc));
        }
        fileOutput.println();
        fileOutput.println("Kaiser-Meyer-Olkin (KMO) statistic");
        fileOutput.println("   Overall KMO statistic =   " + Fmath.truncate(this.kmo, this.trunc));
        fileOutput.println("   KMO values for each item");
        fileOutput.printtab("   ");
        for (n2 = 0; n2 < this.nItems; ++n2) {
            fileOutput.printtab(n2 + 1);
        }
        fileOutput.println();
        fileOutput.printtab("   ");
        for (n2 = 0; n2 < this.nItems; ++n2) {
            fileOutput.printtab(Fmath.truncate(this.itemKMOs[n2], this.trunc));
        }
        fileOutput.println();
        fileOutput.println();
        fileOutput.println("Bartlett Sphericity Test");
        fileOutput.println("   Chi-Square =         " + Fmath.truncate(this.chiSquareBartlett, this.trunc));
        fileOutput.println("   Probability value =  " + Fmath.truncate(this.probBartlett, this.trunc));
        fileOutput.println("   Degrees of freedom = " + this.dfBartlett);
        fileOutput.println("   Chi-Square value at the 5% significance level  (p = 0.05) = " + Fmath.truncate(this.sign05Bartlett, this.trunc));
        fileOutput.println("   Chi-Square value at the 10% significance level (p = 0.10) = " + Fmath.truncate(this.sign10Bartlett, this.trunc));
        fileOutput.println();
        fileOutput.println("DATA USED");
        fileOutput.println("Number of items = " + this.nItems);
        fileOutput.println("Number of persons = " + this.nPersons);
        if (this.originalDataType == 0) {
            fileOutput.printtab("Item");
            for (n2 = 0; n2 < this.nPersons; ++n2) {
                fileOutput.printtab(n2 + 1);
            }
            fileOutput.println();
            for (n2 = 0; n2 < this.nItems; ++n2) {
                fileOutput.printtab(this.itemNames[n2]);
                for (n = 0; n < this.nPersons; ++n) {
                    fileOutput.printtab(Fmath.truncate(this.scores0[n2][n], this.trunc));
                }
                fileOutput.println();
            }
        } else {
            fileOutput.printtab("Person");
            for (n2 = 0; n2 < this.nItems; ++n2) {
                fileOutput.printtab(this.itemNames[n2]);
            }
            fileOutput.println();
            for (n2 = 0; n2 < this.nPersons; ++n2) {
                fileOutput.printtab(n2 + 1);
                for (n = 0; n < this.nItems; ++n) {
                    fileOutput.printtab(Fmath.truncate(this.scores1[n2][n], this.trunc));
                }
                fileOutput.println();
            }
        }
        fileOutput.close();
    }
}

