/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.ExponentialProbPlotFunc;
import flanagan.analysis.FrechetProbPlotFunc;
import flanagan.analysis.FrechetStandardProbPlotFunc;
import flanagan.analysis.FrechetTwoParProbPlotFunc;
import flanagan.analysis.GaussProbPlotFunc;
import flanagan.analysis.GumbelMaxProbPlotFunc;
import flanagan.analysis.GumbelMinProbPlotFunc;
import flanagan.analysis.LogisticProbPlotFunc;
import flanagan.analysis.ParetoProbPlotFunc;
import flanagan.analysis.RayleighProbPlotFunc;
import flanagan.analysis.Regression;
import flanagan.analysis.RegressionFunction;
import flanagan.analysis.Stat;
import flanagan.analysis.WeibullProbPlotFunc;
import flanagan.analysis.WeibullStandardProbPlotFunc;
import flanagan.analysis.WeibullTwoParProbPlotFunc;
import flanagan.interpolation.CubicSpline;
import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.DeepCopy;
import flanagan.math.Fmath;
import flanagan.math.TimeAndDate;
import flanagan.plot.PlotGraph;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Vector;

public class ProbabilityPlot {
    private double[] array = null;
    private Stat arrayAsStat = null;
    private double[] sortedData = null;
    private int[] indices = null;
    private double[] weights = null;
    private Stat weightsAsStat = null;
    private double[] sortedWeights = null;
    private boolean weighted = false;
    private int weightingOption = 0;
    private double mean = Double.NaN;
    private double standardDeviation = Double.NaN;
    private double minimum = Double.NaN;
    private double maximum = Double.NaN;
    private double range = Double.NaN;
    private double halfWidth = Double.NaN;
    private double peakPoint = Double.NaN;
    private int numberOfDataPoints = 0;
    private double dataOffset = 0.0;
    private boolean dataShifted = false;
    private double[] initialEstimates = null;
    private int lastMethod = -1;
    private int nMethods = 16;
    private String[] methodNames = new String[]{"Gaussian", "Three Parameter Weibull", "Exponential", "Rayleigh", "Pareto", "Gumbel (minimum order statistic)", "Gumbel (maximum order statistic)", "Three Parameter Frechet", "Logistic", "Lorentzian", "Three Parameter Log-Normal", "Two Parameter Log-Normal", "Two Parameter Weibull", "One Parameter (Standard) Weibull", "Standard Gaussian", "F-distribution", "Two Parameter Frechet", "One Parameter (Standard) Frechet"};
    private String[][] methodParameters = new String[][]{{"mu", "sigma"}, {"mu", "sigma", "gamma"}, {"mu", "sigma"}, {"beta"}, {"alpha", "beta"}, {"mu", "sigma"}, {"mu", "sigma"}, {"mu", "sigma", "gamma"}, {"mu", "beta"}, {"mu", "gamma"}, {"alpha", "beta", "gamma"}, {"mu", "sigma"}, {"sigma", "gamma"}, {"gamma"}, {" "}, {" "}, {"sigma", "gamma"}, {"gamma"}};
    private int fDistributionNu1 = 0;
    private int fDistributionNu2 = 0;
    private boolean suppressPlot = false;
    private boolean suppressFile = false;
    private boolean suppressErrorMessages = false;
    private double significance = 0.05;
    private int gaussianNumberOfParameters = 2;
    private double[] gaussianOrderMedians = null;
    private double[] gaussianParam = null;
    private double[] gaussianParamErrors = null;
    private double gaussianSumOfSquares = Double.NaN;
    private double gaussianWeightedSumOfSquares = Double.NaN;
    private double[] gaussianLine = null;
    private double[] gaussianLineErrors = null;
    private double gaussianCorrCoeff = Double.NaN;
    private boolean gaussianDone = false;
    private int gaussianStandardNumberOfParameters = 0;
    private double[] gaussianStandardOrderMedians = null;
    private double gaussianStandardSumOfSquares = Double.NaN;
    private double gaussianStandardWeightedSumOfSquares = Double.NaN;
    private double[] gaussianStandardLine = null;
    private double[] gaussianStandardLineErrors = null;
    private double gaussianStandardCorrCoeff = Double.NaN;
    private boolean gaussianStandardDone = false;
    private int exponentialNumberOfParameters = 2;
    private double[] exponentialOrderMedians = null;
    private double[] exponentialParam = null;
    private double[] exponentialParamErrors = null;
    private double exponentialSumOfSquares = Double.NaN;
    private double exponentialWeightedSumOfSquares = Double.NaN;
    private double[] exponentialLine = null;
    private double[] exponentialLineErrors = null;
    private double exponentialCorrCoeff = Double.NaN;
    private boolean exponentialDone = false;
    private int fDistributionNumberOfParameters = 0;
    private double[] fDistributionOrderMedians = null;
    private double fDistributionSumOfSquares = Double.NaN;
    private double fDistributionWeightedSumOfSquares = Double.NaN;
    private double[] fDistributionLine = null;
    private double[] fDistributionLineErrors = null;
    private double fDistributionCorrCoeff = Double.NaN;
    private boolean fDistributionDone = false;
    private int frechetNumberOfParameters = 3;
    private double[] frechetOrderMedians = null;
    private double[] frechetParam = null;
    private double[] frechetParamErrors = null;
    private double frechetSumOfSquares = Double.NaN;
    private double frechetWeightedSumOfSquares = Double.NaN;
    private double[] frechetLine = null;
    private double[] frechetLineErrors = null;
    private double frechetCorrCoeff = Double.NaN;
    private boolean frechetDone = false;
    private int frechetTwoParNumberOfParameters = 2;
    private double[] frechetTwoParOrderMedians = null;
    private double[] frechetTwoParParam = null;
    private double[] frechetTwoParParamErrors = null;
    private double frechetTwoParSumOfSquares = Double.NaN;
    private double frechetTwoParWeightedSumOfSquares = Double.NaN;
    private double[] frechetTwoParLine = null;
    private double[] frechetTwoParLineErrors = null;
    private double frechetTwoParCorrCoeff = Double.NaN;
    private boolean frechetTwoParDone = false;
    private int frechetStandardNumberOfParameters = 1;
    private double[] frechetStandardOrderMedians = null;
    private double[] frechetStandardParam = null;
    private double[] frechetStandardParamErrors = null;
    private double frechetStandardSumOfSquares = Double.NaN;
    private double frechetStandardWeightedSumOfSquares = Double.NaN;
    private double[] frechetStandardLine = null;
    private double[] frechetStandardLineErrors = null;
    private double frechetStandardCorrCoeff = Double.NaN;
    private boolean frechetStandardDone = false;
    private int gumbelMinNumberOfParameters = 3;
    private double[] gumbelMinOrderMedians = null;
    private double[] gumbelMinParam = null;
    private double[] gumbelMinParamErrors = null;
    private double gumbelMinSumOfSquares = Double.NaN;
    private double gumbelMinWeightedSumOfSquares = Double.NaN;
    private double[] gumbelMinLine = null;
    private double[] gumbelMinLineErrors = null;
    private double gumbelMinCorrCoeff = Double.NaN;
    private boolean gumbelMinDone = false;
    private int gumbelMaxNumberOfParameters = 3;
    private double[] gumbelMaxOrderMedians = null;
    private double[] gumbelMaxParam = null;
    private double[] gumbelMaxParamErrors = null;
    private double gumbelMaxSumOfSquares = Double.NaN;
    private double gumbelMaxWeightedSumOfSquares = Double.NaN;
    private double[] gumbelMaxLine = null;
    private double[] gumbelMaxLineErrors = null;
    private double gumbelMaxCorrCoeff = Double.NaN;
    private boolean gumbelMaxDone = false;
    private int logisticNumberOfParameters = 3;
    private double[] logisticOrderMedians = null;
    private double[] logisticParam = null;
    private double[] logisticParamErrors = null;
    private double logisticSumOfSquares = Double.NaN;
    private double logisticWeightedSumOfSquares = Double.NaN;
    private double[] logisticLine = null;
    private double[] logisticLineErrors = null;
    private double logisticCorrCoeff = Double.NaN;
    private boolean logisticDone = false;
    private int paretoNumberOfParameters = 2;
    private double[] paretoOrderMedians = null;
    private double[] paretoParam = null;
    private double[] paretoParamErrors = null;
    private double paretoSumOfSquares = Double.NaN;
    private double paretoWeightedSumOfSquares = Double.NaN;
    private double[] paretoLine = null;
    private double[] paretoLineErrors = null;
    private double paretoCorrCoeff = Double.NaN;
    private boolean paretoDone = false;
    private int rayleighNumberOfParameters = 2;
    private double[] rayleighOrderMedians = null;
    private double[] rayleighParam = null;
    private double[] rayleighParamErrors = null;
    private double rayleighSumOfSquares = Double.NaN;
    private double rayleighWeightedSumOfSquares = Double.NaN;
    private double[] rayleighLine = null;
    private double[] rayleighLineErrors = null;
    private double rayleighCorrCoeff = Double.NaN;
    private boolean rayleighDone = false;
    private int weibullNumberOfParameters = 3;
    private double[] weibullOrderMedians = null;
    private double[] weibullParam = null;
    private double[] weibullParamErrors = null;
    private double weibullSumOfSquares = Double.NaN;
    private double weibullWeightedSumOfSquares = Double.NaN;
    private double[] weibullLine = null;
    private double[] weibullLineErrors = null;
    private double weibullCorrCoeff = Double.NaN;
    private boolean weibullDone = false;
    private int weibullTwoParNumberOfParameters = 2;
    private double[] weibullTwoParOrderMedians = null;
    private double[] weibullTwoParParam = null;
    private double[] weibullTwoParParamErrors = null;
    private double weibullTwoParSumOfSquares = Double.NaN;
    private double weibullTwoParWeightedSumOfSquares = Double.NaN;
    private double[] weibullTwoParLine = null;
    private double[] weibullTwoParLineErrors = null;
    private double weibullTwoParCorrCoeff = Double.NaN;
    private boolean weibullTwoParDone = false;
    private int weibullStandardNumberOfParameters = 1;
    private double[] weibullStandardOrderMedians = null;
    private double[] weibullStandardParam = null;
    private double[] weibullStandardParamErrors = null;
    private double weibullStandardSumOfSquares = Double.NaN;
    private double weibullStandardWeightedSumOfSquares = Double.NaN;
    private double[] weibullStandardLine = null;
    private double[] weibullStandardLineErrors = null;
    private double weibullStandardCorrCoeff = Double.NaN;
    private boolean weibullStandardDone = false;
    private boolean probPlotDone = false;
    private double delta = 0.01;
    private double stepFactor = 0.2;
    private double tolerance = 1.0E-15;
    private boolean nFactorOptionI = false;
    private boolean nFactorReset = false;
    private boolean[] userSuppliedEstimates = null;
    private double[][] userInitialEstimates = null;
    private TimeAndDate tad = new TimeAndDate();
    private int trunc = 4;
    private String titleStart = "";

    public ProbabilityPlot(double[] dArray) {
        this.arrayAsStat = new Stat(dArray);
        this.array = this.arrayAsStat.array();
        this.weighted = false;
        this.weightingOption = 0;
        this.initialise();
    }

    public ProbabilityPlot(double[] dArray, double[] dArray2) {
        this.arrayAsStat = new Stat(dArray);
        this.array = this.arrayAsStat.array();
        this.weightsAsStat = new Stat(dArray2);
        this.weights = this.weightsAsStat.array();
        this.weighted = true;
        this.weightingOption = 1;
        this.initialise();
    }

    public ProbabilityPlot(Double[] doubleArray) {
        this.arrayAsStat = new Stat(doubleArray);
        this.array = this.arrayAsStat.array();
        this.weighted = false;
        this.weightingOption = 0;
        this.initialise();
    }

    public ProbabilityPlot(Double[] doubleArray, Double[] doubleArray2) {
        this.arrayAsStat = new Stat(doubleArray);
        this.array = this.arrayAsStat.array();
        this.weightsAsStat = new Stat(doubleArray2);
        this.weights = this.weightsAsStat.array();
        this.weighted = true;
        this.weightingOption = 1;
        this.initialise();
    }

    public ProbabilityPlot(float[] fArray) {
        this.arrayAsStat = new Stat(fArray);
        this.array = this.arrayAsStat.array();
        this.weighted = false;
        this.weightingOption = 0;
        this.initialise();
    }

    public ProbabilityPlot(float[] fArray, float[] fArray2) {
        this.arrayAsStat = new Stat(fArray);
        this.array = this.arrayAsStat.array();
        this.weightsAsStat = new Stat(fArray2);
        this.weights = this.weightsAsStat.array();
        this.weighted = true;
        this.weightingOption = 1;
        this.initialise();
    }

    public ProbabilityPlot(Float[] floatArray) {
        this.arrayAsStat = new Stat(floatArray);
        this.array = this.arrayAsStat.array();
        this.weighted = false;
        this.weightingOption = 0;
        this.initialise();
    }

    public ProbabilityPlot(Float[] floatArray, Float[] floatArray2) {
        this.arrayAsStat = new Stat(floatArray);
        this.array = this.arrayAsStat.array();
        this.weightsAsStat = new Stat(floatArray2);
        this.weights = this.weightsAsStat.array();
        this.weighted = true;
        this.weightingOption = 1;
        this.initialise();
    }

    public ProbabilityPlot(long[] lArray) {
        this.arrayAsStat = new Stat(lArray);
        this.array = this.arrayAsStat.array();
        this.weighted = false;
        this.weightingOption = 0;
        this.initialise();
    }

    public ProbabilityPlot(long[] lArray, long[] lArray2) {
        this.arrayAsStat = new Stat(lArray);
        this.array = this.arrayAsStat.array();
        this.weightsAsStat = new Stat(lArray2);
        this.weights = this.weightsAsStat.array();
        this.weighted = true;
        this.weightingOption = 1;
        this.initialise();
    }

    public ProbabilityPlot(Long[] longArray) {
        this.arrayAsStat = new Stat(longArray);
        this.array = this.arrayAsStat.array();
        this.weighted = false;
        this.weightingOption = 0;
        this.initialise();
    }

    public ProbabilityPlot(Long[] longArray, Long[] longArray2) {
        this.arrayAsStat = new Stat(longArray);
        this.array = this.arrayAsStat.array();
        this.weightsAsStat = new Stat(longArray2);
        this.weights = this.weightsAsStat.array();
        this.weighted = true;
        this.weightingOption = 1;
        this.initialise();
    }

    public ProbabilityPlot(int[] nArray) {
        this.arrayAsStat = new Stat(nArray);
        this.array = this.arrayAsStat.array();
        this.weighted = false;
        this.weightingOption = 0;
        this.initialise();
    }

    public ProbabilityPlot(int[] nArray, int[] nArray2) {
        this.arrayAsStat = new Stat(nArray);
        this.array = this.arrayAsStat.array();
        this.weightsAsStat = new Stat(nArray2);
        this.weights = this.weightsAsStat.array();
        this.weighted = true;
        this.weightingOption = 1;
        this.initialise();
    }

    public ProbabilityPlot(Integer[] integerArray) {
        this.arrayAsStat = new Stat(integerArray);
        this.array = this.arrayAsStat.array();
        this.weighted = false;
        this.weightingOption = 0;
        this.initialise();
    }

    public ProbabilityPlot(Integer[] integerArray, Integer[] integerArray2) {
        this.arrayAsStat = new Stat(integerArray);
        this.array = this.arrayAsStat.array();
        this.weightsAsStat = new Stat(integerArray2);
        this.weights = this.weightsAsStat.array();
        this.weighted = true;
        this.weightingOption = 1;
        this.initialise();
    }

    public ProbabilityPlot(short[] sArray) {
        this.arrayAsStat = new Stat(sArray);
        this.array = this.arrayAsStat.array();
        this.weighted = false;
        this.weightingOption = 0;
        this.initialise();
    }

    public ProbabilityPlot(short[] sArray, short[] sArray2) {
        this.arrayAsStat = new Stat(sArray);
        this.array = this.arrayAsStat.array();
        this.weightsAsStat = new Stat(sArray2);
        this.weights = this.weightsAsStat.array();
        this.weighted = true;
        this.weightingOption = 1;
        this.initialise();
    }

    public ProbabilityPlot(Short[] shortArray) {
        this.arrayAsStat = new Stat(shortArray);
        this.array = this.arrayAsStat.array();
        this.weightingOption = 0;
        this.initialise();
    }

    public ProbabilityPlot(Short[] shortArray, Short[] shortArray2) {
        this.arrayAsStat = new Stat(shortArray);
        this.array = this.arrayAsStat.array();
        this.weightsAsStat = new Stat(shortArray2);
        this.weights = this.weightsAsStat.array();
        this.weighted = true;
        this.weightingOption = 1;
        this.initialise();
    }

    public ProbabilityPlot(byte[] byArray) {
        this.arrayAsStat = new Stat(byArray);
        this.array = this.arrayAsStat.array();
        this.weightingOption = 0;
        this.weighted = false;
        this.initialise();
    }

    public ProbabilityPlot(byte[] byArray, byte[] byArray2) {
        this.arrayAsStat = new Stat(byArray);
        this.array = this.arrayAsStat.array();
        this.weightsAsStat = new Stat(byArray2);
        this.weights = this.weightsAsStat.array();
        this.weighted = true;
        this.weightingOption = 1;
        this.initialise();
    }

    public ProbabilityPlot(Byte[] byteArray) {
        this.arrayAsStat = new Stat(byteArray);
        this.array = this.arrayAsStat.array();
        this.weighted = false;
        this.weightingOption = 0;
        this.initialise();
    }

    public ProbabilityPlot(Byte[] byteArray, Byte[] byteArray2) {
        this.arrayAsStat = new Stat(byteArray);
        this.array = this.arrayAsStat.array();
        this.weightsAsStat = new Stat(byteArray2);
        this.weights = this.weightsAsStat.array();
        this.weighted = true;
        this.weightingOption = 1;
        this.initialise();
    }

    public ProbabilityPlot(BigDecimal[] bigDecimalArray) {
        this.arrayAsStat = new Stat(bigDecimalArray);
        this.weighted = false;
        this.weightingOption = 0;
        this.initialise();
    }

    public ProbabilityPlot(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2) {
        this.arrayAsStat = new Stat(bigDecimalArray);
        this.array = this.arrayAsStat.array();
        this.weightsAsStat = new Stat(bigDecimalArray2);
        this.weights = this.weightsAsStat.array();
        this.weighted = true;
        this.weightingOption = 1;
        this.initialise();
    }

    public ProbabilityPlot(BigInteger[] bigIntegerArray) {
        this.arrayAsStat = new Stat(bigIntegerArray);
        this.array = this.arrayAsStat.array();
        this.weighted = false;
        this.weightingOption = 0;
        this.initialise();
    }

    public ProbabilityPlot(BigInteger[] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        this.arrayAsStat = new Stat(bigIntegerArray);
        this.array = this.arrayAsStat.array();
        this.weightsAsStat = new Stat(bigIntegerArray2);
        this.weights = this.weightsAsStat.array();
        this.weighted = true;
        this.weightingOption = 1;
        this.initialise();
    }

    public ProbabilityPlot(Object[] objectArray) {
        this.arrayAsStat = new Stat(objectArray);
        this.array = this.arrayAsStat.array();
        this.weighted = false;
        this.weightingOption = 0;
        this.initialise();
    }

    public ProbabilityPlot(Object[] objectArray, Object[] objectArray2) {
        this.arrayAsStat = new Stat(objectArray);
        this.array = this.arrayAsStat.array();
        this.weightsAsStat = new Stat(objectArray2);
        this.weights = this.weightsAsStat.array();
        this.weighted = true;
        this.weightingOption = 1;
        this.initialise();
    }

    public ProbabilityPlot(Vector<Object> vector) {
        this.arrayAsStat = new Stat(vector);
        this.array = this.arrayAsStat.array();
        this.weighted = false;
        this.weightingOption = 0;
        this.initialise();
    }

    public ProbabilityPlot(Vector<Object> vector, Vector<Object> vector2) {
        this.arrayAsStat = new Stat(vector);
        this.array = this.arrayAsStat.array();
        this.weightsAsStat = new Stat(vector2);
        this.weights = this.weightsAsStat.array();
        this.weighted = true;
        this.weightingOption = 1;
        this.initialise();
    }

    public ProbabilityPlot(ArrayList<Object> arrayList) {
        this.arrayAsStat = new Stat(arrayList);
        this.array = this.arrayAsStat.array();
        this.weighted = false;
        this.weightingOption = 0;
        this.initialise();
    }

    public ProbabilityPlot(ArrayList<Object> arrayList, ArrayList<Object> arrayList2) {
        this.arrayAsStat = new Stat(arrayList);
        this.array = this.arrayAsStat.array();
        this.weightsAsStat = new Stat(arrayList2);
        this.weights = this.weightsAsStat.array();
        this.weighted = true;
        this.weightingOption = 1;
        this.initialise();
    }

    public ProbabilityPlot(ArrayMaths arrayMaths) {
        double[] dArray = arrayMaths.array();
        this.arrayAsStat = new Stat(dArray);
        this.array = this.arrayAsStat.array();
        this.weighted = false;
        this.weightingOption = 0;
        this.initialise();
    }

    public ProbabilityPlot(ArrayMaths arrayMaths, ArrayMaths arrayMaths2) {
        double[] dArray = arrayMaths.array();
        this.arrayAsStat = new Stat(dArray);
        this.array = this.arrayAsStat.array();
        double[] dArray2 = arrayMaths2.array();
        this.weightsAsStat = new Stat(dArray2);
        this.weights = this.weightsAsStat.array();
        this.weighted = true;
        this.weightingOption = 1;
        this.initialise();
    }

    public ProbabilityPlot(Stat stat) {
        this.arrayAsStat = stat;
        this.array = this.arrayAsStat.array();
        this.weighted = false;
        this.weightingOption = 0;
        this.initialise();
    }

    public ProbabilityPlot(Stat stat, Stat stat2) {
        this.arrayAsStat = stat;
        this.array = this.arrayAsStat.array();
        this.weightsAsStat = stat2;
        this.weights = this.weightsAsStat.array();
        this.weighted = true;
        this.weightingOption = 1;
        this.initialise();
    }

    private void initialise() {
        int n;
        this.numberOfDataPoints = this.array.length;
        ArrayMaths arrayMaths = this.arrayAsStat.sort();
        this.indices = arrayMaths.originalIndices();
        this.sortedData = arrayMaths.array();
        this.mean = this.arrayAsStat.mean();
        this.standardDeviation = this.arrayAsStat.standardDeviation();
        this.minimum = this.arrayAsStat.minimum();
        this.maximum = this.arrayAsStat.maximum();
        this.range = this.maximum - this.minimum;
        this.sortedWeights = new double[this.numberOfDataPoints];
        if (this.weighted) {
            for (n = 0; n < this.numberOfDataPoints; ++n) {
                this.sortedWeights[n] = this.weights[this.indices[n]];
            }
        } else {
            this.weights = new double[this.numberOfDataPoints];
            for (n = 0; n < this.numberOfDataPoints; ++n) {
                this.weights[n] = 1.0;
                this.sortedWeights[n] = 1.0;
            }
        }
        this.userSuppliedEstimates = new boolean[this.nMethods];
        for (n = 0; n < this.nMethods; ++n) {
            this.userSuppliedEstimates[n] = false;
        }
        this.userSuppliedEstimates = new boolean[this.nMethods];
        this.userInitialEstimates = new double[this.nMethods][];
    }

    public void resetSignificance(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("The argument signif, " + d + ", must lie between 0 and 1 inclusive");
        }
        this.significance = d;
    }

    public double getSignificance() {
        return this.significance;
    }

    public void suppressDisplay() {
        this.suppressPlot = true;
    }

    public void restoreDisplay() {
        this.suppressPlot = false;
    }

    public void suppressFileOutput() {
        this.suppressFile = true;
    }

    public void restoreFileOutput() {
        this.suppressFile = false;
    }

    public void suppressErrorMessages() {
        this.suppressErrorMessages = true;
    }

    public void restoreErrorMessages() {
        this.suppressErrorMessages = false;
    }

    public void setWeightingOption(int n) {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("The option argument, " + n + ", should be 1, 2, 3 or 4");
        }
        if (this.weighted && this.weightingOption == 1) {
            throw new IllegalArgumentException("Weights already entered via a constructor");
        }
        switch (n) {
            case 1: {
                for (int j = 0; j < this.numberOfDataPoints; ++j) {
                    this.sortedWeights[j] = Math.abs(this.sortedData[j]);
                }
                break;
            }
            case 2: {
                for (int j = 0; j < this.numberOfDataPoints; ++j) {
                    this.sortedWeights[j] = Math.sqrt(Math.abs(this.sortedData[j]));
                }
                break;
            }
            case 3: {
                for (int j = 0; j < this.numberOfDataPoints; ++j) {
                    this.sortedWeights[j] = 1.0 / Math.abs(this.sortedData[j]);
                }
                break;
            }
            case 4: {
                for (int j = 0; j < this.numberOfDataPoints; ++j) {
                    this.sortedWeights[j] = 1.0 / Math.sqrt(Math.abs(this.sortedData[j]));
                }
                break;
            }
        }
        this.weightingOption = n + 1;
    }

    public String getWeightingOption() {
        String string = null;
        switch (this.weightingOption) {
            case 0: {
                string = "Unweighted regression";
                break;
            }
            case 1: {
                string = "Weighted regression: user supplied weights";
                break;
            }
            case 2: {
                string = "Weighted regression: weight = response value";
                break;
            }
            case 3: {
                string = "Weighted regression: weight = square root of the response value";
                break;
            }
            case 4: {
                string = "Weighted regression: weight = reciprocal of the response value";
                break;
            }
            case 5: {
                string = "Weighted regression: weight = reciprocal of the square root of the response value";
            }
        }
        return string;
    }

    public void removeWeights() {
        this.weighted = false;
        for (int j = 0; j < this.numberOfDataPoints; ++j) {
            this.sortedWeights[j] = 1.0;
        }
    }

    public void restoreWeights() {
        this.weighted = true;
        for (int j = 0; j < this.numberOfDataPoints; ++j) {
            this.sortedWeights[j] = this.weights[this.indices[j]];
        }
    }

    private void negativeAndNonZeroDataShift() {
        this.dataShifted = false;
        if (this.minimum <= 0.0) {
            this.dataOffset = this.range * 0.01 - this.minimum;
            this.dataShift();
        }
    }

    private void negativeDataShift() {
        this.dataShifted = false;
        if (this.minimum < 0.0) {
            this.dataOffset = -this.minimum;
            this.dataShift();
        }
    }

    private void dataShift() {
        int n = 0;
        while (n < this.numberOfDataPoints) {
            int n2 = n++;
            this.sortedData[n2] = this.sortedData[n2] + this.dataOffset;
        }
        this.minimum += this.dataOffset;
        this.maximum += this.dataOffset;
        this.mean += this.dataOffset;
        this.dataShifted = true;
    }

    public double getdataOffset() {
        return this.dataOffset;
    }

    private double peakWidth() {
        double[] dArray;
        Object object;
        this.halfWidth = 0.0;
        double[] dArray2 = null;
        int n = 10000;
        if (this.numberOfDataPoints >= 1000) {
            dArray2 = this.sortedData;
            n = this.numberOfDataPoints;
        } else {
            double[] dArray3 = new double[this.numberOfDataPoints];
            for (int j = 0; j < this.numberOfDataPoints; ++j) {
                dArray3[j] = j;
            }
            double d = (double)(this.numberOfDataPoints - 1) / (double)(n - 1);
            dArray2 = new double[n];
            CubicSpline cubicSpline = new CubicSpline(dArray3, this.sortedData);
            double d2 = 0.0;
            for (int j = 0; j < n - 1; ++j) {
                dArray2[j] = cubicSpline.interpolate(d2);
                d2 += d;
            }
            dArray2[n - 1] = this.numberOfDataPoints - 1;
        }
        int n2 = 100;
        double[] dArray4 = new double[n2];
        double[] dArray5 = new double[n2];
        double d = this.range / (double)n2;
        double d3 = this.minimum;
        double d4 = d3 + d;
        int n3 = 0;
        for (int j = 0; j < n2; ++j) {
            dArray5[j] = (d4 + d3) / 2.0;
            dArray4[j] = 0.0;
            boolean bl = true;
            if (n3 >= n) {
                bl = false;
            }
            while (bl) {
                if (dArray2[n3] < d4) {
                    int n4 = j;
                    dArray4[n4] = dArray4[n4] + 1.0;
                } else {
                    bl = false;
                }
                if (++n3 < n) continue;
                bl = false;
            }
            d3 = d4;
            d4 = d3 + d;
        }
        if (n3 < n) {
            int n5 = n2 - 1;
            dArray4[n5] = dArray4[n5] + (double)(n - n3);
        }
        ArrayMaths arrayMaths = new ArrayMaths(dArray4);
        double d5 = arrayMaths.maximum();
        int n6 = arrayMaths.maximumIndex();
        this.peakPoint = dArray5[n6];
        double d6 = d5 / 2.0;
        double d7 = 0.0;
        boolean bl = false;
        double d8 = 0.0;
        boolean bl2 = false;
        if (dArray4[0] == d6) {
            d7 = dArray5[0];
            bl = true;
        } else if (dArray4[0] < d6) {
            if (n6 >= 2) {
                int n7;
                double[] dArray6 = new double[n6 + 1];
                double[] dArray7 = new double[n6 + 1];
                for (int j = 0; j <= n6; ++j) {
                    dArray6[j] = dArray4[j];
                    dArray7[j] = dArray5[j];
                }
                object = new CubicSpline(dArray7, dArray6);
                dArray = new double[100];
                double[] dArray8 = new double[100];
                double d9 = (dArray7[n6] - dArray7[0]) / 99.0;
                double d10 = dArray7[0];
                for (n7 = 0; n7 < 99; ++n7) {
                    dArray[n7] = d10;
                    dArray8[n7] = ((CubicSpline)object).interpolate(d10);
                    d10 += d9;
                }
                dArray8[99] = dArray6[n6];
                dArray[99] = dArray7[n6];
                n7 = 1;
                int n8 = 0;
                while (n7 != 0) {
                    if (d6 <= dArray8[n8]) {
                        if (n8 == 0) {
                            d7 = dArray[0];
                            n7 = 0;
                            bl = true;
                        } else if (n8 == 99) {
                            d7 = dArray[99];
                            n7 = 0;
                            bl = true;
                        } else {
                            d7 = (dArray[n8] + dArray[n8 - 1]) / 2.0;
                            n7 = 0;
                            bl = true;
                        }
                    }
                    if (++n8 < 100) continue;
                    n7 = 0;
                }
            } else if (n6 == 2) {
                if (dArray4[1] >= d6) {
                    d7 = dArray5[0] + (dArray5[1] - dArray5[0]) * (d6 - dArray4[0]) / (dArray4[1] - dArray4[0]);
                    bl = true;
                } else {
                    d7 = dArray5[1] + (dArray5[2] - dArray5[1]) * (d6 - dArray4[1]) / (dArray4[2] - dArray4[1]);
                    bl = true;
                }
            } else {
                d7 = dArray5[0] + (dArray5[1] - dArray5[0]) * (d6 - dArray4[0]) / (dArray4[1] - dArray4[0]);
                bl = true;
            }
        } else if (n6 > 2 && dArray4[n6] - dArray4[0] > d6 * 0.5) {
            d7 = dArray5[0] + (dArray5[1] - dArray5[0]) * (d6 - dArray4[0]) / (dArray4[1] - dArray4[0]);
            bl = true;
        }
        int n9 = n2 - 1;
        int n10 = n2 - n6;
        if (dArray4[n9] == d6) {
            d8 = dArray5[n9];
            bl2 = true;
        } else if (dArray4[n9] < d6) {
            if (n10 >= 3) {
                int n11;
                object = new double[n10];
                dArray = new double[n10];
                int n12 = 0;
                for (int j = n6; j < n2; ++j) {
                    object[n12] = dArray4[j];
                    dArray[n12] = dArray5[j];
                    ++n12;
                }
                CubicSpline cubicSpline = new CubicSpline(dArray, (double[])object);
                double[] dArray9 = new double[100];
                double[] dArray10 = new double[100];
                double d11 = (dArray[n10 - 1] - dArray[0]) / 99.0;
                double d12 = dArray[0];
                for (n11 = 0; n11 < 99; ++n11) {
                    dArray9[n11] = d12;
                    dArray10[n11] = cubicSpline.interpolate(d12);
                    d12 += d11;
                }
                dArray10[99] = (double)object[n10 - 1];
                dArray9[99] = dArray[n10 - 1];
                n11 = 1;
                n12 = 0;
                while (n11 != 0) {
                    if (d6 <= dArray10[n12]) {
                        if (n12 == 0) {
                            d8 = dArray9[0];
                            n11 = 0;
                            bl2 = true;
                        } else if (n12 == 99) {
                            d8 = dArray9[99];
                            n11 = 0;
                            bl2 = true;
                        } else {
                            d8 = (dArray9[n12] + dArray9[n12 - 1]) / 2.0;
                            n11 = 0;
                            bl2 = true;
                        }
                    }
                    if (++n12 < 100) continue;
                    n11 = 0;
                }
            } else if (n10 == 2) {
                if (dArray4[n9 - 1] >= d6) {
                    d8 = dArray5[n9 - 1] + (dArray5[n9] - dArray5[n9 - 1]) * (d6 - dArray4[n9 - 1]) / (dArray4[n9] - dArray4[n9 - 1]);
                    bl2 = true;
                } else {
                    d8 = dArray5[n9 - 2] + (dArray5[n9 - 1] - dArray5[n9 - 2]) * (d6 - dArray4[n9 - 2]) / (dArray4[n9 - 1] - dArray4[n9 - 2]);
                    bl2 = true;
                }
            } else {
                d8 = dArray5[n9 - 1] + (dArray5[n9] - dArray5[n9 - 1]) * (d6 - dArray4[n9 - 1]) / (dArray4[n9] - dArray4[n9 - 1]);
                bl2 = true;
            }
        } else if (n10 > 2 && dArray4[n6] - dArray4[n9] > d6 * 0.5) {
            d8 = dArray5[n9 - 1] + (dArray5[n9] - dArray5[n9 - 1]) * (d6 - dArray4[n9 - 1]) / (dArray4[n9] - dArray4[n9 - 1]);
            bl2 = true;
        }
        if (bl) {
            this.halfWidth = bl2 ? d8 - d7 : (this.peakPoint - d7) * 1.3;
        } else if (bl2) {
            this.halfWidth = (d8 - this.peakPoint) * 1.3;
        } else {
            System.out.println("Half height width could not be calculated - half range returned");
            this.halfWidth = this.range / 2.0;
        }
        return this.halfWidth;
    }

    public double correlationCoefficientCriticalValue() {
        return this.correlationCoefficientCriticalValue(this.significance);
    }

    public double correlationCoefficientCriticalValue(double d) {
        double d2 = Double.NaN;
        d2 = Stat.corrCoeffInverseCDFoneTailed(d, this.numberOfDataPoints - 2);
        return d2;
    }

    public void gaussianUserSuppliedInitialEstimates(double d, double d2) {
        this.userSuppliedEstimates[0] = true;
        this.userInitialEstimates[0] = new double[2];
        this.userInitialEstimates[0][0] = d;
        this.userInitialEstimates[0][1] = d2;
    }

    public void normalUserSuppliedInitialEstimates(double d, double d2) {
        this.userSuppliedEstimates[0] = true;
        this.userInitialEstimates[0] = new double[2];
        this.userInitialEstimates[0][0] = d;
        this.userInitialEstimates[0][1] = d2;
    }

    public void removeGaussianUserSuppliedInitialEstimates() {
        this.userSuppliedEstimates[0] = false;
    }

    public void removeNormalUserSuppliedInitialEstimates() {
        this.userSuppliedEstimates[0] = false;
    }

    public void gaussianProbabilityPlot() {
        double d;
        this.lastMethod = 0;
        this.gaussianNumberOfParameters = 2;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        Regression regression = new Regression(this.sortedData, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression.suppressErrorMessages();
        }
        double[] dArray = new double[2];
        if (this.userSuppliedEstimates[0]) {
            dArray[0] = this.userInitialEstimates[0][0];
            dArray[1] = this.userInitialEstimates[0][1];
            if (dArray[1] <= 0.0) {
                dArray[1] = this.range * 0.01;
            }
        } else {
            dArray[0] = this.mean;
            dArray[1] = this.standardDeviation;
        }
        this.initialEstimates = dArray;
        double[] dArray2 = new double[]{this.stepFactor * Math.abs(dArray[0]), this.stepFactor * Math.abs(dArray[1])};
        if (dArray2[0] == 0.0) {
            dArray2[0] = this.stepFactor * this.standardDeviation;
        }
        if (dArray2[1] == 0.0) {
            dArray2[1] = this.stepFactor * this.standardDeviation;
        }
        regression.addConstraint(1, -1, 0.0);
        GaussProbPlotFunc gaussProbPlotFunc = new GaussProbPlotFunc();
        gaussProbPlotFunc.setDataArray(this.numberOfDataPoints);
        regression.simplex((RegressionFunction)gaussProbPlotFunc, DeepCopy.copy(dArray), dArray2, this.tolerance);
        double[] dArray3 = regression.getBestEstimates();
        double[] dArray4 = regression.getBestEstimatesErrors();
        double d2 = d = regression.getSumOfSquares();
        double d3 = d;
        if (this.weighted) {
            d3 = d2 = regression.getSumOfWeightedResidualSquares();
        }
        double[] dArray5 = new double[this.gaussianNumberOfParameters];
        dArray5[0] = 2.0 * dArray3[0] - dArray[0];
        dArray2[0] = Math.abs(dArray5[0] * this.stepFactor);
        if (dArray2[0] == 0.0) {
            dArray2[0] = this.range * 0.01;
        }
        dArray5[1] = 2.0 * dArray3[1] - dArray[1];
        if (dArray5[1] <= 0.0) {
            dArray5[1] = this.range * 0.01;
        }
        dArray2[1] = Math.abs(dArray5[1] * this.stepFactor);
        regression.simplex((RegressionFunction)gaussProbPlotFunc, DeepCopy.copy(dArray5), dArray2, this.tolerance);
        this.gaussianParam = regression.getBestEstimates();
        this.gaussianParamErrors = regression.getBestEstimatesErrors();
        this.gaussianWeightedSumOfSquares = this.gaussianSumOfSquares = regression.getSumOfSquares();
        double d4 = this.gaussianSumOfSquares;
        if (this.weighted) {
            d4 = this.gaussianWeightedSumOfSquares = regression.getChiSquare();
        }
        if (d3 < d4) {
            this.gaussianParam = dArray3;
            this.gaussianParamErrors = dArray4;
            this.gaussianSumOfSquares = d;
            if (this.weighted) {
                this.gaussianWeightedSumOfSquares = d2;
            }
        }
        this.gaussianOrderMedians = Stat.gaussianOrderStatisticMedians(this.gaussianParam[0], this.gaussianParam[1], this.numberOfDataPoints);
        Regression regression2 = new Regression(this.gaussianOrderMedians, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression2.suppressErrorMessages();
        }
        regression2.linear();
        this.gaussianLine = regression2.getBestEstimates();
        this.gaussianLineErrors = regression2.getBestEstimatesErrors();
        this.gaussianCorrCoeff = regression2.getSampleR();
        this.gaussianSumOfSquares = regression.getSumOfSquares();
        if (!this.suppressFile) {
            this.outputFile(this.lastMethod, regression, regression2, this.gaussianNumberOfParameters);
        }
        if (!this.suppressPlot) {
            double[][] dArray6 = PlotGraph.data(2, this.numberOfDataPoints);
            dArray6[0] = this.gaussianOrderMedians;
            dArray6[1] = this.sortedData;
            dArray6[2] = this.gaussianOrderMedians;
            for (int j = 0; j < this.numberOfDataPoints; ++j) {
                dArray6[3][j] = this.gaussianLine[0] + this.gaussianLine[1] * this.gaussianOrderMedians[j];
            }
            PlotGraph plotGraph = new PlotGraph(dArray6);
            int[] nArray = new int[]{4, 0};
            plotGraph.setPoint(nArray);
            int[] nArray2 = new int[]{0, 3};
            plotGraph.setLine(nArray2);
            plotGraph.setXaxisLegend("Gaussian Order Statistic Medians");
            plotGraph.setYaxisLegend("Ordered Data Values");
            plotGraph.setGraphTitle(this.titleStart + "Gaussian probability plot:   gradient = " + Fmath.truncate(this.gaussianLine[1], 4) + ", intercept = " + Fmath.truncate(this.gaussianLine[0], 4) + ",  R = " + Fmath.truncate(this.gaussianCorrCoeff, 4));
            plotGraph.setGraphTitle2("  mu = " + Fmath.truncate(this.gaussianParam[0], 4) + ", sigma = " + Fmath.truncate(this.gaussianParam[1], 4));
            plotGraph.plot();
            this.probPlotDone = true;
        }
        this.gaussianDone = true;
    }

    public void normalProbabilityPlot() {
        this.gaussianProbabilityPlot();
    }

    public double gaussianMu() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianParam[0];
    }

    public double gaussianMuError() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianParamErrors[0];
    }

    public double gaussianSigma() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianParam[1];
    }

    public double gaussianSigmaError() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianParamErrors[1];
    }

    public double gaussianGradient() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianLine[1];
    }

    public double gaussianGradientError() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianLineErrors[1];
    }

    public double gaussianIntercept() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianLine[0];
    }

    public double gaussianInterceptError() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianLineErrors[0];
    }

    public double gaussianCorrelationCoefficient() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianCorrCoeff;
    }

    public double gaussianSumOfSquares() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianSumOfSquares;
    }

    public double gaussianWeightedSumOfSquares() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianWeightedSumOfSquares;
    }

    public double[] gaussianOrderStatisticMedians() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianOrderMedians;
    }

    public double normalMu() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianParam[0];
    }

    public double normalMuError() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianParamErrors[0];
    }

    public double normalSigma() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianParam[1];
    }

    public double normalSigmaError() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianParamErrors[1];
    }

    public double normalGradient() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianLine[1];
    }

    public double normalGradientError() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianLineErrors[1];
    }

    public double normalIntercept() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianLine[0];
    }

    public double normalInterceptError() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianLineErrors[0];
    }

    public double normalCorrelationCoefficient() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianCorrCoeff;
    }

    public double normalSumOfSquares() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianSumOfSquares;
    }

    public double normalWeightedSumOfSquares() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianWeightedSumOfSquares;
    }

    public double[] normalOrderStatisticMedians() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianOrderMedians;
    }

    public void gaussianStandardProbabilityPlot() {
        this.lastMethod = 14;
        this.gaussianStandardNumberOfParameters = 2;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        this.gaussianStandardOrderMedians = Stat.gaussianOrderStatisticMedians(this.numberOfDataPoints);
        Regression regression = new Regression(this.gaussianStandardOrderMedians, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression.suppressErrorMessages();
        }
        regression.linear();
        this.gaussianStandardLine = regression.getBestEstimates();
        this.gaussianStandardLineErrors = regression.getBestEstimatesErrors();
        this.gaussianStandardCorrCoeff = regression.getSampleR();
        this.gaussianStandardSumOfSquares = regression.getSumOfSquares();
        this.gaussianStandardWeightedSumOfSquares = regression.getSumOfSquares();
        if (this.weighted) {
            this.gaussianStandardWeightedSumOfSquares = regression.getChiSquare();
        }
        if (!this.suppressFile) {
            this.outputFile(this.lastMethod, null, regression, 0);
        }
        if (!this.suppressPlot) {
            double[][] dArray = PlotGraph.data(2, this.numberOfDataPoints);
            dArray[0] = this.gaussianStandardOrderMedians;
            dArray[1] = this.sortedData;
            dArray[2] = this.gaussianStandardOrderMedians;
            for (int j = 0; j < this.numberOfDataPoints; ++j) {
                dArray[3][j] = this.gaussianStandardLine[0] + this.gaussianStandardLine[1] * this.gaussianStandardOrderMedians[j];
            }
            PlotGraph plotGraph = new PlotGraph(dArray);
            int[] nArray = new int[]{4, 0};
            plotGraph.setPoint(nArray);
            int[] nArray2 = new int[]{0, 3};
            plotGraph.setLine(nArray2);
            plotGraph.setXaxisLegend("Standard Gaussian Order Statistic Medians");
            plotGraph.setYaxisLegend("Ordered Data Values");
            plotGraph.setGraphTitle("Standard Gaussian probability plot:   gradient = " + Fmath.truncate(this.gaussianStandardLine[1], 4) + ", intercept = " + Fmath.truncate(this.gaussianStandardLine[0], 4) + ",  R = " + Fmath.truncate(this.gaussianStandardCorrCoeff, 4));
            plotGraph.plot();
            this.probPlotDone = true;
        }
        this.gaussianStandardDone = true;
    }

    public void normalStandardProbabilityPlot() {
        this.gaussianStandardProbabilityPlot();
    }

    public double gaussianStandardGradient() {
        if (!this.gaussianStandardDone) {
            this.gaussianStandardProbabilityPlot();
        }
        return this.gaussianStandardLine[1];
    }

    public double gaussianStandardGradientError() {
        if (!this.gaussianStandardDone) {
            this.gaussianStandardProbabilityPlot();
        }
        return this.gaussianStandardLineErrors[1];
    }

    public double gaussianStandardIntercept() {
        if (!this.gaussianStandardDone) {
            this.gaussianStandardProbabilityPlot();
        }
        return this.gaussianStandardLine[0];
    }

    public double gaussianStandardInterceptError() {
        if (!this.gaussianStandardDone) {
            this.gaussianStandardProbabilityPlot();
        }
        return this.gaussianStandardLineErrors[0];
    }

    public double gaussianStandardCorrelationCoefficient() {
        if (!this.gaussianStandardDone) {
            this.gaussianStandardProbabilityPlot();
        }
        return this.gaussianStandardCorrCoeff;
    }

    public double gaussianStandardSumOfSquares() {
        if (!this.gaussianStandardDone) {
            this.gaussianStandardProbabilityPlot();
        }
        return this.gaussianStandardSumOfSquares;
    }

    public double[] gaussianStandardOrderStatisticMedians() {
        if (!this.gaussianStandardDone) {
            this.gaussianStandardProbabilityPlot();
        }
        return this.gaussianStandardOrderMedians;
    }

    public double normalStandardGradient() {
        if (!this.gaussianStandardDone) {
            this.gaussianStandardProbabilityPlot();
        }
        return this.gaussianStandardLine[1];
    }

    public double normalstandardGradientError() {
        if (!this.gaussianStandardDone) {
            this.gaussianStandardProbabilityPlot();
        }
        return this.gaussianStandardLineErrors[1];
    }

    public double normalStandardInterceptError() {
        if (!this.gaussianStandardDone) {
            this.gaussianStandardProbabilityPlot();
        }
        return this.gaussianStandardLineErrors[0];
    }

    public double normalStandardCorrelationCoefficient() {
        if (!this.gaussianStandardDone) {
            this.gaussianStandardProbabilityPlot();
        }
        return this.gaussianStandardCorrCoeff;
    }

    public double normalStandardSumOfSquares() {
        if (!this.gaussianStandardDone) {
            this.gaussianStandardProbabilityPlot();
        }
        return this.gaussianStandardSumOfSquares;
    }

    public double normalStandardWeightedSumOfSquares() {
        if (!this.gaussianDone) {
            this.gaussianProbabilityPlot();
        }
        return this.gaussianStandardWeightedSumOfSquares;
    }

    public double[] normalStandardOrderStatisticMedians() {
        if (!this.gaussianDone) {
            this.gaussianStandardProbabilityPlot();
        }
        return this.gaussianStandardOrderMedians;
    }

    public void logisticUserSuppliedInitialEstimates(double d, double d2) {
        this.userSuppliedEstimates[8] = true;
        this.userInitialEstimates[8] = new double[2];
        this.userInitialEstimates[8][0] = d;
        this.userInitialEstimates[8][1] = d2;
    }

    public void removeLogisticUserSuppliedInitialEstimates() {
        this.userSuppliedEstimates[8] = false;
    }

    public void logisticProbabilityPlot() {
        this.lastMethod = 8;
        this.logisticNumberOfParameters = 2;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        Regression regression = new Regression(this.sortedData, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression.suppressErrorMessages();
        }
        double[] dArray = new double[2];
        if (this.userSuppliedEstimates[8]) {
            dArray[0] = this.userInitialEstimates[8][0];
            dArray[1] = this.userInitialEstimates[8][1];
            if (dArray[1] <= 0.0) {
                dArray[0] = this.standardDeviation / 3.0;
            }
        } else {
            dArray[0] = this.mean;
            dArray[1] = this.standardDeviation;
        }
        this.initialEstimates = dArray;
        double[] dArray2 = new double[]{this.stepFactor * Math.abs(dArray[0]), this.stepFactor * Math.abs(dArray[1])};
        double[] dArray3 = dArray2;
        if (dArray3[0] <= 0.0) {
            dArray3[0] = this.standardDeviation / 10.0;
        }
        if (dArray3[1] <= 0.0) {
            dArray3[1] = this.standardDeviation / 10.0;
        }
        regression.addConstraint(1, -1, 0.0);
        LogisticProbPlotFunc logisticProbPlotFunc = new LogisticProbPlotFunc();
        logisticProbPlotFunc.setDataArray(this.numberOfDataPoints);
        regression.simplex((RegressionFunction)logisticProbPlotFunc, dArray, dArray3, this.tolerance);
        this.logisticParam = regression.getBestEstimates();
        this.logisticParamErrors = regression.getBestEstimatesErrors();
        this.logisticWeightedSumOfSquares = this.logisticSumOfSquares = regression.getSumOfSquares();
        if (this.weighted) {
            this.logisticWeightedSumOfSquares = regression.getChiSquare();
        }
        this.logisticOrderMedians = Stat.logisticOrderStatisticMedians(this.logisticParam[0], this.logisticParam[1], this.numberOfDataPoints);
        Regression regression2 = new Regression(this.logisticOrderMedians, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression2.suppressErrorMessages();
        }
        regression2.linear();
        this.logisticLine = regression2.getBestEstimates();
        this.logisticLineErrors = regression2.getBestEstimatesErrors();
        this.logisticCorrCoeff = regression2.getSampleR();
        this.logisticSumOfSquares = regression.getSumOfSquares();
        if (!this.suppressFile) {
            this.outputFile(this.lastMethod, regression, regression2, this.logisticNumberOfParameters);
        }
        if (!this.suppressPlot) {
            double[][] dArray4 = PlotGraph.data(2, this.numberOfDataPoints);
            dArray4[0] = this.logisticOrderMedians;
            dArray4[1] = this.sortedData;
            dArray4[2] = this.logisticOrderMedians;
            for (int j = 0; j < this.numberOfDataPoints; ++j) {
                dArray4[3][j] = this.logisticLine[0] + this.logisticLine[1] * this.logisticOrderMedians[j];
            }
            PlotGraph plotGraph = new PlotGraph(dArray4);
            int[] nArray = new int[]{4, 0};
            plotGraph.setPoint(nArray);
            int[] nArray2 = new int[]{0, 3};
            plotGraph.setLine(nArray2);
            plotGraph.setXaxisLegend("Logistic Order Statistic Medians");
            plotGraph.setYaxisLegend("Ordered Data Values");
            plotGraph.setGraphTitle("Logistic probability plot:   gradient = " + Fmath.truncate(this.logisticLine[1], 4) + ", intercept = " + Fmath.truncate(this.logisticLine[0], 4) + ",  R = " + Fmath.truncate(this.logisticCorrCoeff, 4));
            plotGraph.setGraphTitle2("  mu = " + Fmath.truncate(this.logisticParam[0], 4) + ", beta = " + Fmath.truncate(this.logisticParam[1], 4));
            plotGraph.plot();
            this.probPlotDone = true;
        }
        this.logisticDone = true;
    }

    public double logisticMu() {
        if (!this.logisticDone) {
            this.logisticProbabilityPlot();
        }
        return this.logisticParam[0];
    }

    public double logisticMuError() {
        if (!this.logisticDone) {
            this.logisticProbabilityPlot();
        }
        return this.logisticParamErrors[0];
    }

    public double logisticBeta() {
        if (!this.logisticDone) {
            this.logisticProbabilityPlot();
        }
        return this.logisticParam[1];
    }

    public double logisticBetaError() {
        if (!this.logisticDone) {
            this.logisticProbabilityPlot();
        }
        return this.logisticParamErrors[1];
    }

    public double[] logisticOrderStatisticMedians() {
        if (!this.logisticDone) {
            this.logisticProbabilityPlot();
        }
        return this.logisticOrderMedians;
    }

    public double logisticGradient() {
        if (!this.logisticDone) {
            this.logisticProbabilityPlot();
        }
        return this.logisticLine[1];
    }

    public double logisticGradientError() {
        if (!this.logisticDone) {
            this.logisticProbabilityPlot();
        }
        return this.logisticLineErrors[1];
    }

    public double logisticIntercept() {
        if (!this.logisticDone) {
            this.logisticProbabilityPlot();
        }
        return this.logisticLine[0];
    }

    public double logisticInterceptError() {
        if (!this.logisticDone) {
            this.logisticProbabilityPlot();
        }
        return this.logisticLineErrors[0];
    }

    public double logisticCorrelationCoefficient() {
        if (!this.logisticDone) {
            this.logisticProbabilityPlot();
        }
        return this.logisticCorrCoeff;
    }

    public double logisticSumOfSquares() {
        if (!this.logisticDone) {
            this.logisticProbabilityPlot();
        }
        return this.logisticSumOfSquares;
    }

    public double logisticWeightedSumOfSquares() {
        if (!this.logisticDone) {
            this.logisticProbabilityPlot();
        }
        return this.logisticWeightedSumOfSquares;
    }

    public void weibullUserSuppliedInitialEstimates(double d, double d2, double d3) {
        this.userSuppliedEstimates[1] = true;
        this.userInitialEstimates[1] = new double[3];
        this.userInitialEstimates[1][0] = d;
        this.userInitialEstimates[1][1] = d2;
        this.userInitialEstimates[1][2] = d3;
    }

    public void removeWeibullUserSuppliedInitialEstimates() {
        this.userSuppliedEstimates[1] = false;
    }

    public void weibullProbabilityPlot() {
        double d;
        this.lastMethod = 1;
        this.weibullNumberOfParameters = 3;
        if (this.numberOfDataPoints < 4) {
            throw new IllegalArgumentException("There must be at least four data points - preferably considerably more");
        }
        Regression regression = new Regression(this.sortedData, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression.suppressErrorMessages();
        }
        double[] dArray = new double[3];
        if (this.userSuppliedEstimates[1]) {
            dArray[0] = this.userInitialEstimates[1][0];
            if (dArray[0] > this.minimum) {
                dArray[0] = this.minimum - 0.1 * Math.abs(this.minimum);
            }
            dArray[1] = this.userInitialEstimates[1][1];
            if (dArray[1] <= 0.0) {
                dArray[1] = this.range * 0.1;
            }
            dArray[2] = this.userInitialEstimates[1][2];
            if (dArray[2] <= 0.0) {
                dArray[2] = 0.1;
            }
        } else {
            dArray[0] = this.minimum - 0.1 * Math.abs(this.minimum);
            dArray[1] = this.peakWidth();
            if (dArray[1] <= 0.0) {
                dArray[1] = this.range * 0.1;
            }
            dArray[2] = 4.0;
        }
        this.initialEstimates = dArray;
        double[] dArray2 = new double[]{Math.abs(this.stepFactor * dArray[0]), Math.abs(this.stepFactor * dArray[1]), Math.abs(this.stepFactor * dArray[2])};
        double[] dArray3 = dArray2;
        if (dArray3[0] <= 0.0) {
            dArray3[0] = this.range * 0.01;
        }
        if (dArray3[1] <= 0.0) {
            dArray3[1] = this.range * 0.01;
        }
        if (dArray3[2] <= 0.0) {
            dArray3[2] = 0.01;
        }
        regression.addConstraint(0, 1, this.minimum);
        regression.addConstraint(1, -1, 0.0);
        regression.addConstraint(2, -1, 0.0);
        WeibullProbPlotFunc weibullProbPlotFunc = new WeibullProbPlotFunc();
        weibullProbPlotFunc.setDataArray(this.numberOfDataPoints);
        regression.simplex((RegressionFunction)weibullProbPlotFunc, Conv.copy(dArray), dArray3, this.tolerance);
        double[] dArray4 = regression.getBestEstimates();
        double[] dArray5 = regression.getBestEstimatesErrors();
        double d2 = d = regression.getSumOfSquares();
        double d3 = d;
        if (this.weighted) {
            d3 = d2 = regression.getSumOfWeightedResidualSquares();
        }
        double[] dArray6 = new double[this.weibullNumberOfParameters];
        dArray6[0] = 2.0 * dArray4[0] - dArray[0];
        if (dArray6[0] > this.minimum) {
            dArray6[0] = this.minimum * (1.0 - Math.abs(this.minimum) * 0.05);
        }
        dArray3[0] = Math.abs(dArray6[0] * 0.1);
        if (dArray3[0] == 0.0) {
            dArray3[0] = this.range * 0.01;
        }
        dArray6[1] = 2.0 * dArray4[1] - dArray[1];
        if (dArray6[1] <= 0.0) {
            dArray6[1] = Math.abs(2.0 * dArray4[1] - 0.98 * dArray[1]);
        }
        dArray3[1] = Math.abs(dArray6[1] * 0.1);
        dArray6[2] = 2.0 * dArray4[2] - dArray[2];
        if (dArray6[1] <= 0.0) {
            dArray6[2] = Math.abs(2.0 * dArray4[2] - 0.98 * dArray[2]);
        }
        dArray3[2] = Math.abs(dArray6[2] * 0.1);
        regression.simplex((RegressionFunction)weibullProbPlotFunc, Conv.copy(dArray6), dArray3, this.tolerance);
        this.weibullParam = regression.getBestEstimates();
        this.weibullParamErrors = regression.getBestEstimatesErrors();
        this.weibullWeightedSumOfSquares = this.weibullSumOfSquares = regression.getSumOfSquares();
        double d4 = this.weibullSumOfSquares;
        if (this.weighted) {
            d4 = this.weibullWeightedSumOfSquares = regression.getChiSquare();
        }
        if (d3 < d4) {
            this.weibullParam = dArray4;
            this.weibullParamErrors = dArray5;
            this.weibullSumOfSquares = d;
            if (this.weighted) {
                this.weibullWeightedSumOfSquares = d2;
            }
        }
        this.weibullOrderMedians = Stat.weibullOrderStatisticMedians(this.weibullParam[0], this.weibullParam[1], this.weibullParam[2], this.numberOfDataPoints);
        Regression regression2 = new Regression(this.weibullOrderMedians, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression2.suppressErrorMessages();
        }
        regression2.linear();
        this.weibullLine = regression2.getBestEstimates();
        this.weibullLineErrors = regression2.getBestEstimatesErrors();
        this.weibullCorrCoeff = regression2.getSampleR();
        if (!this.suppressFile) {
            this.outputFile(this.lastMethod, regression, regression2, this.weibullNumberOfParameters);
        }
        if (!this.suppressPlot) {
            double[][] dArray7 = PlotGraph.data(2, this.numberOfDataPoints);
            dArray7[0] = this.weibullOrderMedians;
            dArray7[1] = this.sortedData;
            dArray7[2] = this.weibullOrderMedians;
            for (int j = 0; j < this.numberOfDataPoints; ++j) {
                dArray7[3][j] = this.weibullLine[0] + this.weibullLine[1] * this.weibullOrderMedians[j];
            }
            PlotGraph plotGraph = new PlotGraph(dArray7);
            int[] nArray = new int[]{4, 0};
            plotGraph.setPoint(nArray);
            int[] nArray2 = new int[]{0, 3};
            plotGraph.setLine(nArray2);
            plotGraph.setXaxisLegend("Weibull Order Statistic Medians");
            plotGraph.setYaxisLegend("Ordered Data Values");
            plotGraph.setGraphTitle("Weibull probability plot:   gradient = " + Fmath.truncate(this.weibullLine[1], 4) + ", intercept = " + Fmath.truncate(this.weibullLine[0], 4) + ",  R = " + Fmath.truncate(this.weibullCorrCoeff, 4));
            plotGraph.setGraphTitle2("  mu = " + Fmath.truncate(this.weibullParam[0], 4) + ", sigma = " + Fmath.truncate(this.weibullParam[1], 4) + ", gamma = " + Fmath.truncate(this.weibullParam[2], 4));
            plotGraph.plot();
            this.probPlotDone = true;
        }
        this.weibullDone = true;
    }

    public void weibullThreeParProbabilityPlot() {
        this.weibullProbabilityPlot();
    }

    public double weibullMu() {
        if (!this.weibullDone) {
            this.weibullProbabilityPlot();
        }
        return this.weibullParam[0];
    }

    public double weibullMuError() {
        if (!this.weibullDone) {
            this.weibullProbabilityPlot();
        }
        return this.weibullParamErrors[0];
    }

    public double weibullSigma() {
        if (!this.weibullDone) {
            this.weibullProbabilityPlot();
        }
        return this.weibullParam[1];
    }

    public double weibullSigmaError() {
        if (!this.weibullDone) {
            this.weibullProbabilityPlot();
        }
        return this.weibullParamErrors[1];
    }

    public double weibullGamma() {
        if (!this.weibullDone) {
            this.weibullProbabilityPlot();
        }
        return this.weibullParam[2];
    }

    public double weibullGammaError() {
        if (!this.weibullDone) {
            this.weibullProbabilityPlot();
        }
        return this.weibullParamErrors[2];
    }

    public double[] weibullOrderStatisticMedians() {
        if (!this.weibullDone) {
            this.weibullProbabilityPlot();
        }
        return this.weibullOrderMedians;
    }

    public double weibullGradient() {
        if (!this.weibullDone) {
            this.weibullProbabilityPlot();
        }
        return this.weibullLine[1];
    }

    public double weibullGradientError() {
        if (!this.weibullDone) {
            this.weibullProbabilityPlot();
        }
        return this.weibullLineErrors[1];
    }

    public double weibullIntercept() {
        if (!this.weibullDone) {
            this.weibullProbabilityPlot();
        }
        return this.weibullLine[0];
    }

    public double weibullInterceptError() {
        if (!this.weibullDone) {
            this.weibullProbabilityPlot();
        }
        return this.weibullLineErrors[0];
    }

    public double weibullCorrelationCoefficient() {
        if (!this.weibullDone) {
            this.weibullProbabilityPlot();
        }
        return this.weibullCorrCoeff;
    }

    public double weibullSumOfSquares() {
        if (!this.weibullDone) {
            this.weibullProbabilityPlot();
        }
        return this.weibullSumOfSquares;
    }

    public double weibullWeightedSumOfSquares() {
        if (!this.weibullDone) {
            this.weibullProbabilityPlot();
        }
        return this.weibullWeightedSumOfSquares;
    }

    public void weibullTwoParUserSuppliedInitialEstimates(double d, double d2) {
        this.userSuppliedEstimates[12] = true;
        this.userInitialEstimates[12] = new double[2];
        this.userInitialEstimates[12][0] = d;
        this.userInitialEstimates[1][1] = d2;
    }

    public void removeWeibullTwoParUserSuppliedInitialEstimates() {
        this.userSuppliedEstimates[12] = false;
    }

    public void weibullTwoParProbabilityPlot() {
        double d;
        this.lastMethod = 12;
        if (this.sortedData[0] < 0.0) {
            System.out.println("Method weibullTwoParProbabilityPlot: negative x value found - weibullThreeParProbabilityPlot called");
            this.weibullThreeParProbabilityPlot();
        }
        this.weibullTwoParNumberOfParameters = 2;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        Regression regression = new Regression(this.sortedData, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression.suppressErrorMessages();
        }
        double[] dArray = new double[2];
        if (this.userSuppliedEstimates[12]) {
            dArray[0] = this.userInitialEstimates[12][0];
            if (dArray[0] <= 0.0) {
                dArray[0] = this.range * 0.01;
            }
            dArray[1] = this.userInitialEstimates[12][1];
            if (dArray[1] <= 0.0) {
                dArray[1] = 1.0;
            }
        } else {
            dArray[0] = this.peakWidth();
            dArray[1] = 4.0;
        }
        this.initialEstimates = dArray;
        double[] dArray2 = new double[]{Math.abs(this.stepFactor * dArray[0]), Math.abs(this.stepFactor * dArray[1])};
        double[] dArray3 = dArray2;
        if (dArray3[0] <= 0.0) {
            dArray3[0] = this.range * 0.01;
        }
        regression.addConstraint(0, -1, 0.0);
        regression.addConstraint(1, -1, 0.0);
        WeibullTwoParProbPlotFunc weibullTwoParProbPlotFunc = new WeibullTwoParProbPlotFunc();
        weibullTwoParProbPlotFunc.setDataArray(this.numberOfDataPoints);
        regression.simplex((RegressionFunction)weibullTwoParProbPlotFunc, Conv.copy(dArray), dArray3, this.tolerance);
        double[] dArray4 = regression.getBestEstimates();
        double[] dArray5 = regression.getBestEstimatesErrors();
        double d2 = d = regression.getSumOfSquares();
        double d3 = d;
        if (this.weighted) {
            d3 = d2 = regression.getSumOfWeightedResidualSquares();
        }
        double[] dArray6 = new double[this.weibullTwoParNumberOfParameters];
        dArray6[0] = 2.0 * dArray4[0] - dArray[0];
        if (dArray6[0] <= 0.0) {
            dArray6[0] = Math.abs(2.0 * dArray4[0] - 0.98 * dArray[0]);
        }
        dArray3[0] = Math.abs(dArray6[0] * 0.1);
        if (dArray3[0] <= 0.0) {
            dArray3[0] = this.range * 0.01;
        }
        dArray6[1] = 2.0 * dArray4[1] - dArray[1];
        if (dArray6[1] <= 0.0) {
            dArray6[1] = Math.abs(2.0 * dArray4[1] - 0.98 * dArray[1]);
        }
        dArray3[1] = Math.abs(dArray6[1] * 0.1);
        regression.simplex((RegressionFunction)weibullTwoParProbPlotFunc, Conv.copy(dArray6), dArray3, this.tolerance);
        this.weibullTwoParParam = regression.getBestEstimates();
        this.weibullTwoParParamErrors = regression.getBestEstimatesErrors();
        this.weibullTwoParWeightedSumOfSquares = this.weibullTwoParSumOfSquares = regression.getSumOfSquares();
        double d4 = this.weibullTwoParSumOfSquares;
        if (this.weighted) {
            this.weibullTwoParWeightedSumOfSquares = regression.getChiSquare();
            d4 = this.weibullWeightedSumOfSquares;
        }
        if (d3 < d4) {
            this.weibullTwoParParam = dArray4;
            this.weibullTwoParParamErrors = dArray5;
            this.weibullTwoParSumOfSquares = d;
            if (this.weighted) {
                this.weibullTwoParWeightedSumOfSquares = d2;
            }
        }
        this.weibullTwoParOrderMedians = Stat.weibullOrderStatisticMedians(this.weibullTwoParParam[0], this.weibullTwoParParam[1], this.numberOfDataPoints);
        Regression regression2 = new Regression(this.weibullTwoParOrderMedians, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression2.suppressErrorMessages();
        }
        regression2.linear();
        this.weibullTwoParLine = regression2.getBestEstimates();
        this.weibullTwoParLineErrors = regression2.getBestEstimatesErrors();
        this.weibullTwoParCorrCoeff = regression2.getSampleR();
        if (!this.suppressFile) {
            this.outputFile(this.lastMethod, regression, regression2, this.weibullTwoParNumberOfParameters);
        }
        if (!this.suppressPlot) {
            double[][] dArray7 = PlotGraph.data(2, this.numberOfDataPoints);
            dArray7[0] = this.weibullTwoParOrderMedians;
            dArray7[1] = this.sortedData;
            dArray7[2] = this.weibullTwoParOrderMedians;
            for (int j = 0; j < this.numberOfDataPoints; ++j) {
                dArray7[3][j] = this.weibullTwoParLine[0] + this.weibullTwoParLine[1] * this.weibullTwoParOrderMedians[j];
            }
            PlotGraph plotGraph = new PlotGraph(dArray7);
            int[] nArray = new int[]{4, 0};
            plotGraph.setPoint(nArray);
            int[] nArray2 = new int[]{0, 3};
            plotGraph.setLine(nArray2);
            plotGraph.setXaxisLegend("Weibull Order Statistic Medians");
            plotGraph.setYaxisLegend("Ordered Data Values");
            plotGraph.setGraphTitle("Two Parameter Weibull probability plot:   gradient = " + Fmath.truncate(this.weibullTwoParLine[1], 4) + ", intercept = " + Fmath.truncate(this.weibullTwoParLine[0], 4) + ",  R = " + Fmath.truncate(this.weibullTwoParCorrCoeff, 4));
            plotGraph.setGraphTitle2("  mu = 0, sigma = " + Fmath.truncate(this.weibullTwoParParam[0], 4) + ", gamma = " + Fmath.truncate(this.weibullTwoParParam[1], 4));
            plotGraph.plot();
            this.probPlotDone = true;
        }
        this.weibullTwoParDone = true;
    }

    public double weibullTwoParSigma() {
        if (!this.weibullTwoParDone) {
            this.weibullTwoParProbabilityPlot();
        }
        return this.weibullTwoParParam[0];
    }

    public double weibullTwoParSigmaError() {
        if (!this.weibullTwoParDone) {
            this.weibullTwoParProbabilityPlot();
        }
        return this.weibullTwoParParamErrors[0];
    }

    public double weibullTwoParGamma() {
        if (!this.weibullTwoParDone) {
            this.weibullTwoParProbabilityPlot();
        }
        return this.weibullTwoParParam[1];
    }

    public double weibullTwoParGammaError() {
        if (!this.weibullTwoParDone) {
            this.weibullTwoParProbabilityPlot();
        }
        return this.weibullTwoParParamErrors[1];
    }

    public double[] weibullTwoParOrderStatisticMedians() {
        if (!this.weibullTwoParDone) {
            this.weibullTwoParProbabilityPlot();
        }
        return this.weibullTwoParOrderMedians;
    }

    public double weibullTwoParGradient() {
        if (!this.weibullTwoParDone) {
            this.weibullTwoParProbabilityPlot();
        }
        return this.weibullTwoParLine[1];
    }

    public double weibullTwoParGradientError() {
        if (!this.weibullTwoParDone) {
            this.weibullTwoParProbabilityPlot();
        }
        return this.weibullTwoParLineErrors[1];
    }

    public double weibullTwoParIntercept() {
        if (!this.weibullTwoParDone) {
            this.weibullTwoParProbabilityPlot();
        }
        return this.weibullTwoParLine[0];
    }

    public double weibullTwoParInterceptError() {
        if (!this.weibullTwoParDone) {
            this.weibullTwoParProbabilityPlot();
        }
        return this.weibullTwoParLineErrors[0];
    }

    public double weibullTwoParCorrelationCoefficient() {
        if (!this.weibullTwoParDone) {
            this.weibullTwoParProbabilityPlot();
        }
        return this.weibullTwoParCorrCoeff;
    }

    public double weibullTwoParSumOfSquares() {
        if (!this.weibullTwoParDone) {
            this.weibullTwoParProbabilityPlot();
        }
        return this.weibullTwoParSumOfSquares;
    }

    public double weibullTwoParWeightedSumOfSquares() {
        if (!this.weibullTwoParDone) {
            this.weibullTwoParProbabilityPlot();
        }
        return this.weibullTwoParWeightedSumOfSquares;
    }

    public void weibullStandardUserSuppliedInitialEstimates(double d) {
        this.userSuppliedEstimates[13] = true;
        this.userInitialEstimates[13] = new double[1];
        this.userInitialEstimates[13][0] = d;
    }

    public void removeWeibullStandardUserSuppliedInitialEstimates() {
        this.userSuppliedEstimates[13] = false;
    }

    public void weibullStandardProbabilityPlot() {
        double d;
        this.lastMethod = 13;
        if (this.sortedData[0] < 0.0) {
            System.out.println("Method weibullStandardProbabilityPlot: negative x value found - weibullThreeParProbabilityPlot called");
            this.weibullThreeParProbabilityPlot();
        }
        this.weibullStandardNumberOfParameters = 1;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        Regression regression = new Regression(this.sortedData, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression.suppressErrorMessages();
        }
        double[] dArray = new double[1];
        if (this.userSuppliedEstimates[13]) {
            dArray[0] = this.userInitialEstimates[13][0];
            if (dArray[0] <= 0.0) {
                dArray[0] = 1.0;
            }
        } else {
            dArray[0] = 4.0;
        }
        double[] dArray2 = new double[]{Math.abs(this.stepFactor * dArray[0])};
        this.initialEstimates = dArray;
        regression.addConstraint(0, -1, 0.0);
        WeibullStandardProbPlotFunc weibullStandardProbPlotFunc = new WeibullStandardProbPlotFunc();
        weibullStandardProbPlotFunc.setDataArray(this.numberOfDataPoints);
        regression.simplex((RegressionFunction)weibullStandardProbPlotFunc, Conv.copy(dArray), dArray2, this.tolerance);
        double[] dArray3 = regression.getBestEstimates();
        double[] dArray4 = regression.getBestEstimatesErrors();
        double d2 = d = regression.getSumOfSquares();
        double d3 = d;
        if (this.weighted) {
            d3 = d2 = regression.getSumOfWeightedResidualSquares();
        }
        double[] dArray5 = new double[this.weibullStandardNumberOfParameters];
        dArray5[0] = 2.0 * dArray3[0] - dArray[0];
        if (dArray5[0] <= 0.0) {
            dArray5[0] = Math.abs(2.0 * dArray3[0] - 0.98 * dArray[0]);
        }
        dArray2[0] = Math.abs(dArray5[0] * 0.1);
        if (dArray2[0] == 0.0) {
            dArray2[0] = this.range * 0.01;
        }
        regression.simplex((RegressionFunction)weibullStandardProbPlotFunc, Conv.copy(dArray5), dArray2, this.tolerance);
        this.weibullStandardParam = regression.getBestEstimates();
        this.weibullStandardParamErrors = regression.getBestEstimatesErrors();
        this.weibullStandardWeightedSumOfSquares = this.weibullStandardSumOfSquares = regression.getSumOfSquares();
        double d4 = this.weibullStandardSumOfSquares;
        if (this.weighted) {
            d4 = this.weibullStandardWeightedSumOfSquares = regression.getChiSquare();
        }
        if (d3 < d4) {
            this.weibullStandardParam = dArray3;
            this.weibullStandardParamErrors = dArray4;
            this.weibullStandardSumOfSquares = d;
            if (this.weighted) {
                this.weibullStandardWeightedSumOfSquares = d2;
            }
        }
        this.weibullStandardOrderMedians = Stat.weibullOrderStatisticMedians(this.weibullStandardParam[0], this.numberOfDataPoints);
        Regression regression2 = new Regression(this.weibullStandardOrderMedians, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression2.suppressErrorMessages();
        }
        regression2.linear();
        this.weibullStandardLine = regression2.getBestEstimates();
        this.weibullStandardLineErrors = regression2.getBestEstimatesErrors();
        this.weibullStandardCorrCoeff = regression2.getSampleR();
        if (!this.suppressFile) {
            this.outputFile(this.lastMethod, regression, regression2, this.weibullStandardNumberOfParameters);
        }
        if (!this.suppressPlot) {
            double[][] dArray6 = PlotGraph.data(2, this.numberOfDataPoints);
            dArray6[0] = this.weibullStandardOrderMedians;
            dArray6[1] = this.sortedData;
            dArray6[2] = this.weibullStandardOrderMedians;
            for (int j = 0; j < this.numberOfDataPoints; ++j) {
                dArray6[3][j] = this.weibullStandardLine[0] + this.weibullStandardLine[1] * this.weibullStandardOrderMedians[j];
            }
            PlotGraph plotGraph = new PlotGraph(dArray6);
            int[] nArray = new int[]{4, 0};
            plotGraph.setPoint(nArray);
            int[] nArray2 = new int[]{0, 3};
            plotGraph.setLine(nArray2);
            plotGraph.setXaxisLegend("Weibull Order Statistic Medians");
            plotGraph.setYaxisLegend("Ordered Data Values");
            plotGraph.setGraphTitle("Standard Weibull probability plot:   gradient = " + Fmath.truncate(this.weibullStandardLine[1], 4) + ", intercept = " + Fmath.truncate(this.weibullStandardLine[0], 4) + ",  R = " + Fmath.truncate(this.weibullStandardCorrCoeff, 4));
            plotGraph.setGraphTitle2("  mu = 0, sigma = 1, gamma = " + Fmath.truncate(this.weibullStandardParam[0], 4));
            plotGraph.plot();
            this.probPlotDone = true;
        }
        this.weibullStandardDone = true;
    }

    public void weibullOneParProbabilityPlot() {
        this.weibullStandardProbabilityPlot();
    }

    public double weibullStandardGamma() {
        if (!this.weibullStandardDone) {
            this.weibullStandardProbabilityPlot();
        }
        return this.weibullStandardParam[0];
    }

    public double weibullStandardGammaError() {
        if (!this.weibullStandardDone) {
            this.weibullStandardProbabilityPlot();
        }
        return this.weibullStandardParamErrors[0];
    }

    public double[] weibullStandardOrderStatisticMedians() {
        if (!this.weibullStandardDone) {
            this.weibullStandardProbabilityPlot();
        }
        return this.weibullStandardOrderMedians;
    }

    public double weibullStandardGradient() {
        if (!this.weibullStandardDone) {
            this.weibullStandardProbabilityPlot();
        }
        return this.weibullStandardLine[1];
    }

    public double weibullStandardGradientError() {
        if (!this.weibullStandardDone) {
            this.weibullStandardProbabilityPlot();
        }
        return this.weibullStandardLineErrors[1];
    }

    public double weibullStandardIntercept() {
        if (!this.weibullStandardDone) {
            this.weibullStandardProbabilityPlot();
        }
        return this.weibullStandardLine[0];
    }

    public double weibullStandardInterceptError() {
        if (!this.weibullStandardDone) {
            this.weibullStandardProbabilityPlot();
        }
        return this.weibullStandardLineErrors[0];
    }

    public double weibullStandardCorrelationCoefficient() {
        if (!this.weibullStandardDone) {
            this.weibullStandardProbabilityPlot();
        }
        return this.weibullStandardCorrCoeff;
    }

    public double weibullStandardSumOfSquares() {
        if (!this.weibullStandardDone) {
            this.weibullStandardProbabilityPlot();
        }
        return this.weibullStandardSumOfSquares;
    }

    public double weibullStandardWeightedSumOfSquares() {
        if (!this.weibullStandardDone) {
            this.weibullStandardProbabilityPlot();
        }
        return this.weibullStandardWeightedSumOfSquares;
    }

    public void exponentialUserSuppliedInitialEstimates(double d, double d2) {
        this.userSuppliedEstimates[2] = true;
        this.userInitialEstimates[2] = new double[2];
        this.userInitialEstimates[2][0] = d;
        this.userInitialEstimates[2][1] = d2;
    }

    public void exponentialUserSuppliedInitialEstimates() {
        this.userSuppliedEstimates[2] = false;
    }

    public void exponentialProbabilityPlot() {
        this.lastMethod = 2;
        this.exponentialNumberOfParameters = 2;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        Regression regression = new Regression(this.sortedData, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression.suppressErrorMessages();
        }
        double[] dArray = new double[2];
        if (this.userSuppliedEstimates[2]) {
            dArray[0] = this.userInitialEstimates[2][0];
            dArray[1] = this.userInitialEstimates[2][1];
        } else {
            dArray[0] = this.minimum;
            if (dArray[0] == 0.0) {
                dArray[0] = this.standardDeviation / 3.0;
            }
            dArray[1] = this.standardDeviation;
        }
        this.initialEstimates = dArray;
        double[] dArray2 = new double[]{this.stepFactor * dArray[0], this.stepFactor * dArray[1]};
        if (dArray2[0] <= 0.0) {
            dArray2[0] = this.standardDeviation / 30.0;
        }
        regression.addConstraint(1, -1, 0.0);
        ExponentialProbPlotFunc exponentialProbPlotFunc = new ExponentialProbPlotFunc();
        exponentialProbPlotFunc.setDataArray(this.numberOfDataPoints);
        regression.simplex((RegressionFunction)exponentialProbPlotFunc, dArray, dArray2, this.tolerance);
        this.exponentialParam = regression.getBestEstimates();
        this.exponentialParamErrors = regression.getBestEstimatesErrors();
        this.exponentialWeightedSumOfSquares = this.exponentialSumOfSquares = regression.getSumOfSquares();
        if (this.weighted) {
            this.exponentialWeightedSumOfSquares = regression.getChiSquare();
        }
        this.exponentialOrderMedians = Stat.weibullOrderStatisticMedians(this.exponentialParam[0], this.exponentialParam[1], 1.0, this.numberOfDataPoints);
        Regression regression2 = new Regression(this.exponentialOrderMedians, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression2.suppressErrorMessages();
        }
        regression2.linear();
        this.exponentialLine = regression2.getBestEstimates();
        this.exponentialLineErrors = regression2.getBestEstimatesErrors();
        this.exponentialCorrCoeff = regression2.getSampleR();
        if (!this.suppressFile) {
            this.outputFile(this.lastMethod, regression, regression2, this.exponentialNumberOfParameters);
        }
        if (!this.suppressPlot) {
            double[][] dArray3 = PlotGraph.data(2, this.numberOfDataPoints);
            dArray3[0] = this.exponentialOrderMedians;
            dArray3[1] = this.sortedData;
            dArray3[2] = this.exponentialOrderMedians;
            for (int j = 0; j < this.numberOfDataPoints; ++j) {
                dArray3[3][j] = this.exponentialLine[0] + this.exponentialLine[1] * this.exponentialOrderMedians[j];
            }
            PlotGraph plotGraph = new PlotGraph(dArray3);
            int[] nArray = new int[]{4, 0};
            plotGraph.setPoint(nArray);
            int[] nArray2 = new int[]{0, 3};
            plotGraph.setLine(nArray2);
            plotGraph.setXaxisLegend("Exponential Order Statistic Medians");
            plotGraph.setYaxisLegend("Ordered Data Values");
            plotGraph.setGraphTitle("Exponential probability plot:   gradient = " + Fmath.truncate(this.exponentialLine[1], 4) + ", intercept = " + Fmath.truncate(this.exponentialLine[0], 4) + ",  R = " + Fmath.truncate(this.exponentialCorrCoeff, 4));
            plotGraph.setGraphTitle2("  mu = " + Fmath.truncate(this.exponentialParam[0], 4) + ", sigma = " + Fmath.truncate(this.exponentialParam[1], 4));
            plotGraph.plot();
            this.probPlotDone = true;
        }
        this.exponentialDone = true;
    }

    public double exponentialMu() {
        if (!this.exponentialDone) {
            this.exponentialProbabilityPlot();
        }
        return this.exponentialParam[0];
    }

    public double exponentialMuError() {
        if (!this.exponentialDone) {
            this.exponentialProbabilityPlot();
        }
        return this.exponentialParamErrors[0];
    }

    public double exponentialSigma() {
        if (!this.exponentialDone) {
            this.exponentialProbabilityPlot();
        }
        return this.exponentialParam[1];
    }

    public double exponentialSigmaError() {
        if (!this.exponentialDone) {
            this.exponentialProbabilityPlot();
        }
        return this.exponentialParamErrors[1];
    }

    public double[] exponentialOrderStatisticMedians() {
        if (!this.exponentialDone) {
            this.exponentialProbabilityPlot();
        }
        return this.exponentialOrderMedians;
    }

    public double exponentialGradient() {
        if (!this.exponentialDone) {
            this.exponentialProbabilityPlot();
        }
        return this.exponentialLine[1];
    }

    public double exponentialGradientError() {
        if (!this.exponentialDone) {
            this.exponentialProbabilityPlot();
        }
        return this.exponentialLineErrors[1];
    }

    public double exponentialIntercept() {
        if (!this.exponentialDone) {
            this.exponentialProbabilityPlot();
        }
        return this.exponentialLine[0];
    }

    public double exponentialInterceptError() {
        if (!this.exponentialDone) {
            this.exponentialProbabilityPlot();
        }
        return this.exponentialLineErrors[0];
    }

    public double exponentialCorrelationCoefficient() {
        if (!this.exponentialDone) {
            this.exponentialProbabilityPlot();
        }
        return this.exponentialCorrCoeff;
    }

    public double exponentialSumOfSquaresExponential() {
        if (!this.exponentialDone) {
            this.exponentialProbabilityPlot();
        }
        return this.exponentialSumOfSquares;
    }

    public double exponentialWeightedSumOfSquares() {
        if (!this.exponentialDone) {
            this.exponentialProbabilityPlot();
        }
        return this.exponentialWeightedSumOfSquares;
    }

    public void frechetUserSuppliedInitialEstimates(double d, double d2, double d3) {
        this.userSuppliedEstimates[7] = true;
        this.userInitialEstimates[7] = new double[3];
        this.userInitialEstimates[7][0] = d;
        this.userInitialEstimates[7][1] = d2;
        this.userInitialEstimates[7][2] = d3;
    }

    public void removeFrechetUserSuppliedInitialEstimates() {
        this.userSuppliedEstimates[7] = false;
    }

    public void frechetProbabilityPlot() {
        double d;
        this.lastMethod = 7;
        this.frechetNumberOfParameters = 3;
        if (this.numberOfDataPoints < 4) {
            throw new IllegalArgumentException("There must be at least four data points - preferably considerably more");
        }
        Regression regression = new Regression(this.sortedData, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression.suppressErrorMessages();
        }
        double[] dArray = new double[3];
        if (this.userSuppliedEstimates[7]) {
            dArray[0] = this.userInitialEstimates[7][0];
            if (dArray[0] > this.minimum) {
                dArray[0] = this.minimum - 0.1 * Math.abs(this.minimum);
            }
            dArray[1] = this.userInitialEstimates[7][1];
            if (dArray[1] <= 0.0) {
                dArray[1] = 0.001 * this.range;
            }
            dArray[2] = this.userInitialEstimates[7][2];
            if (dArray[2] < 0.0) {
                dArray[2] = 1.0E-4;
            }
        } else {
            dArray[0] = this.minimum - 0.1 * Math.abs(this.minimum);
            dArray[1] = this.peakWidth();
            if (dArray[1] <= 0.0) {
                dArray[1] = 0.001 * this.range;
            }
            dArray[2] = 4.0;
        }
        this.initialEstimates = dArray;
        double[] dArray2 = new double[]{Math.abs(this.stepFactor * dArray[0]), Math.abs(this.stepFactor * dArray[1]), Math.abs(this.stepFactor * dArray[2])};
        if (dArray2[0] == 0.0) {
            dArray2[0] = this.range * 0.01;
        }
        regression.addConstraint(0, 1, this.minimum);
        regression.addConstraint(1, -1, 0.0);
        regression.addConstraint(2, -1, 0.0);
        FrechetProbPlotFunc frechetProbPlotFunc = new FrechetProbPlotFunc();
        frechetProbPlotFunc.setDataArray(this.numberOfDataPoints);
        regression.simplex((RegressionFunction)frechetProbPlotFunc, Conv.copy(dArray), dArray2, this.tolerance);
        double[] dArray3 = regression.getBestEstimates();
        double[] dArray4 = regression.getBestEstimatesErrors();
        double d2 = d = regression.getSumOfSquares();
        double d3 = d;
        if (this.weighted) {
            d3 = d2 = regression.getSumOfWeightedResidualSquares();
        }
        double[] dArray5 = new double[this.frechetNumberOfParameters];
        dArray5[0] = 2.0 * dArray3[0] - dArray[0];
        if (dArray5[0] > this.minimum) {
            dArray5[0] = this.minimum * (1.0 - Math.abs(this.minimum) * 0.05);
        }
        dArray2[0] = Math.abs(dArray5[0] * 0.1);
        if (dArray2[0] == 0.0) {
            dArray2[0] = this.range * 0.01;
        }
        dArray5[1] = 2.0 * dArray3[1] - dArray[1];
        if (dArray5[1] <= 0.0) {
            dArray5[1] = Math.abs(2.0 * dArray3[1] - 0.98 * dArray[1]);
        }
        dArray2[1] = Math.abs(dArray5[1] * 0.1);
        dArray5[2] = 2.0 * dArray3[2] - dArray[2];
        if (dArray5[2] <= 0.0) {
            dArray5[2] = Math.abs(2.0 * dArray3[2] - 0.98 * dArray[2]);
        }
        dArray2[2] = Math.abs(dArray5[2] * 0.1);
        regression.simplex((RegressionFunction)frechetProbPlotFunc, Conv.copy(dArray5), dArray2, this.tolerance);
        this.frechetParam = regression.getBestEstimates();
        this.frechetParamErrors = regression.getBestEstimatesErrors();
        this.frechetWeightedSumOfSquares = this.frechetSumOfSquares = regression.getSumOfSquares();
        double d4 = this.frechetSumOfSquares;
        if (this.weighted) {
            d4 = this.frechetWeightedSumOfSquares = regression.getChiSquare();
        }
        if (d3 < d4) {
            this.frechetParam = dArray3;
            this.frechetParamErrors = dArray4;
            this.frechetSumOfSquares = d;
            if (this.weighted) {
                this.frechetWeightedSumOfSquares = d2;
            }
        }
        this.frechetOrderMedians = Stat.frechetOrderStatisticMedians(this.frechetParam[0], this.frechetParam[1], this.frechetParam[2], this.numberOfDataPoints);
        Regression regression2 = new Regression(this.frechetOrderMedians, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression2.suppressErrorMessages();
        }
        regression2.linear();
        this.frechetLine = regression2.getBestEstimates();
        this.frechetLineErrors = regression2.getBestEstimatesErrors();
        this.frechetCorrCoeff = regression2.getSampleR();
        this.gaussianSumOfSquares = regression.getSumOfSquares();
        if (!this.suppressFile) {
            this.outputFile(this.lastMethod, regression, regression2, this.frechetNumberOfParameters);
        }
        if (!this.suppressPlot) {
            double[][] dArray6 = PlotGraph.data(2, this.numberOfDataPoints);
            dArray6[0] = this.frechetOrderMedians;
            dArray6[1] = this.sortedData;
            dArray6[2] = this.frechetOrderMedians;
            for (int j = 0; j < this.numberOfDataPoints; ++j) {
                dArray6[3][j] = this.frechetLine[0] + this.frechetLine[1] * this.frechetOrderMedians[j];
            }
            PlotGraph plotGraph = new PlotGraph(dArray6);
            int[] nArray = new int[]{4, 0};
            plotGraph.setPoint(nArray);
            int[] nArray2 = new int[]{0, 3};
            plotGraph.setLine(nArray2);
            plotGraph.setXaxisLegend("Frechet Order Statistic Medians");
            plotGraph.setYaxisLegend("Ordered Data Values");
            plotGraph.setGraphTitle("Frechet probability plot:   gradient = " + Fmath.truncate(this.frechetLine[1], 4) + ", intercept = " + Fmath.truncate(this.frechetLine[0], 4) + ",  R = " + Fmath.truncate(this.frechetCorrCoeff, 4));
            plotGraph.setGraphTitle2("  mu = " + Fmath.truncate(this.frechetParam[0], 4) + ", sigma = " + Fmath.truncate(this.frechetParam[1], 4) + ", gamma = " + Fmath.truncate(this.frechetParam[2], 4));
            plotGraph.plot();
            this.probPlotDone = true;
        }
        this.frechetDone = true;
    }

    public double frechetMu() {
        if (!this.frechetDone) {
            this.frechetProbabilityPlot();
        }
        return this.frechetParam[0];
    }

    public double frechetMuError() {
        if (!this.frechetDone) {
            this.frechetProbabilityPlot();
        }
        return this.frechetParamErrors[0];
    }

    public double frechetSigma() {
        if (!this.frechetDone) {
            this.frechetProbabilityPlot();
        }
        return this.frechetParam[1];
    }

    public double frechetSigmaError() {
        if (!this.frechetDone) {
            this.frechetProbabilityPlot();
        }
        return this.frechetParamErrors[1];
    }

    public double frechetGamma() {
        if (!this.frechetDone) {
            this.frechetProbabilityPlot();
        }
        return this.frechetParam[2];
    }

    public double frechetGammaError() {
        if (!this.frechetDone) {
            this.frechetProbabilityPlot();
        }
        return this.frechetParamErrors[2];
    }

    public double[] frechetOrderStatisticMedians() {
        if (!this.frechetDone) {
            this.frechetProbabilityPlot();
        }
        return this.frechetOrderMedians;
    }

    public double frechetGradient() {
        if (!this.frechetDone) {
            this.frechetProbabilityPlot();
        }
        return this.frechetLine[1];
    }

    public double frechetGradientError() {
        if (!this.frechetDone) {
            this.frechetProbabilityPlot();
        }
        return this.frechetLineErrors[1];
    }

    public double frechetIntercept() {
        if (!this.frechetDone) {
            this.frechetProbabilityPlot();
        }
        return this.frechetLine[0];
    }

    public double frechetInterceptError() {
        if (!this.frechetDone) {
            this.frechetProbabilityPlot();
        }
        return this.frechetLineErrors[0];
    }

    public double frechetCorrelationCoefficient() {
        if (!this.frechetDone) {
            this.frechetProbabilityPlot();
        }
        return this.frechetCorrCoeff;
    }

    public double frechetSumOfSquares() {
        if (!this.frechetDone) {
            this.frechetProbabilityPlot();
        }
        return this.frechetSumOfSquares;
    }

    public double frechetWeightedSumOfSquares() {
        if (!this.frechetDone) {
            this.frechetProbabilityPlot();
        }
        return this.frechetWeightedSumOfSquares;
    }

    public void frechetThreeParProbabilityPlot() {
        this.frechetProbabilityPlot();
    }

    public void frechetTwoParUserSuppliedInitialEstimates(double d, double d2) {
        this.userSuppliedEstimates[16] = true;
        this.userInitialEstimates[16] = new double[2];
        this.userInitialEstimates[16][0] = d;
        this.userInitialEstimates[16][1] = d2;
    }

    public void removeFrechetTwoParUserSuppliedInitialEstimates() {
        this.userSuppliedEstimates[16] = false;
    }

    public void frechetTwoParProbabilityPlot() {
        double d;
        this.lastMethod = 16;
        this.frechetTwoParNumberOfParameters = 2;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        Regression regression = new Regression(this.sortedData, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression.suppressErrorMessages();
        }
        double[] dArray = new double[2];
        if (this.userSuppliedEstimates[16]) {
            dArray[0] = this.userInitialEstimates[16][0];
            dArray[1] = this.userInitialEstimates[16][1];
        } else {
            dArray[0] = this.peakWidth();
            dArray[1] = 4.0;
        }
        if (dArray[0] <= 0.0) {
            dArray[0] = this.range / 100.0;
        }
        if (dArray[1] <= 0.0) {
            dArray[1] = 1.0;
        }
        this.initialEstimates = dArray;
        double[] dArray2 = new double[]{Math.abs(this.stepFactor * dArray[0]), Math.abs(this.stepFactor * dArray[1])};
        regression.addConstraint(0, -1, 0.0);
        regression.addConstraint(1, -1, 0.0);
        FrechetTwoParProbPlotFunc frechetTwoParProbPlotFunc = new FrechetTwoParProbPlotFunc();
        frechetTwoParProbPlotFunc.setDataArray(this.numberOfDataPoints);
        regression.simplex((RegressionFunction)frechetTwoParProbPlotFunc, Conv.copy(dArray), dArray2, this.tolerance);
        double[] dArray3 = regression.getBestEstimates();
        double[] dArray4 = regression.getBestEstimatesErrors();
        double d2 = d = regression.getSumOfSquares();
        double d3 = d;
        if (this.weighted) {
            d3 = d2 = regression.getSumOfWeightedResidualSquares();
        }
        double[] dArray5 = new double[this.frechetTwoParNumberOfParameters];
        dArray5[0] = 2.0 * dArray3[0] - dArray[0];
        if (dArray5[0] <= 0.0) {
            dArray5[0] = Math.abs(2.0 * dArray3[0] - 0.98 * dArray[0]);
        }
        dArray2[0] = Math.abs(dArray5[0] * 0.1);
        dArray5[1] = 2.0 * dArray3[1] - dArray[1];
        if (dArray5[1] <= 0.0) {
            dArray5[1] = Math.abs(2.0 * dArray3[1] - 0.98 * dArray[1]);
        }
        dArray2[1] = Math.abs(dArray5[1] * 0.1);
        regression.simplex((RegressionFunction)frechetTwoParProbPlotFunc, Conv.copy(dArray5), dArray2, this.tolerance);
        this.frechetTwoParParam = regression.getBestEstimates();
        this.frechetTwoParParamErrors = regression.getBestEstimatesErrors();
        this.frechetTwoParWeightedSumOfSquares = this.frechetTwoParSumOfSquares = regression.getSumOfSquares();
        double d4 = this.frechetTwoParSumOfSquares;
        if (this.weighted) {
            d4 = this.frechetTwoParWeightedSumOfSquares = regression.getChiSquare();
        }
        if (d3 < d4) {
            this.frechetTwoParParam = dArray3;
            this.frechetTwoParParamErrors = dArray4;
            this.frechetTwoParSumOfSquares = d;
            if (this.weighted) {
                this.frechetTwoParWeightedSumOfSquares = d2;
            }
        }
        this.frechetTwoParOrderMedians = Stat.frechetOrderStatisticMedians(this.frechetTwoParParam[0], this.frechetTwoParParam[1], this.numberOfDataPoints);
        Regression regression2 = new Regression(this.frechetTwoParOrderMedians, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression2.suppressErrorMessages();
        }
        regression2.linear();
        this.frechetTwoParLine = regression2.getBestEstimates();
        this.frechetTwoParLineErrors = regression2.getBestEstimatesErrors();
        this.frechetTwoParCorrCoeff = regression2.getSampleR();
        if (!this.suppressFile) {
            this.outputFile(this.lastMethod, regression, regression2, this.frechetTwoParNumberOfParameters);
        }
        if (!this.suppressPlot) {
            double[][] dArray6 = PlotGraph.data(2, this.numberOfDataPoints);
            dArray6[0] = this.frechetTwoParOrderMedians;
            dArray6[1] = this.sortedData;
            dArray6[2] = this.frechetTwoParOrderMedians;
            for (int j = 0; j < this.numberOfDataPoints; ++j) {
                dArray6[3][j] = this.frechetTwoParLine[0] + this.frechetTwoParLine[1] * this.frechetTwoParOrderMedians[j];
            }
            PlotGraph plotGraph = new PlotGraph(dArray6);
            int[] nArray = new int[]{4, 0};
            plotGraph.setPoint(nArray);
            int[] nArray2 = new int[]{0, 3};
            plotGraph.setLine(nArray2);
            plotGraph.setXaxisLegend("Two Parameter Frechet Order Statistic Medians");
            plotGraph.setYaxisLegend("Ordered Data Values");
            plotGraph.setGraphTitle("Two parameter Frechet probability plot:   gradient = " + Fmath.truncate(this.frechetTwoParLine[1], 4) + ", intercept = " + Fmath.truncate(this.frechetTwoParLine[0], 4) + ",  R = " + Fmath.truncate(this.frechetTwoParCorrCoeff, 4));
            plotGraph.setGraphTitle2("  sigma = " + Fmath.truncate(this.frechetTwoParParam[1], 4) + ", gamma = " + Fmath.truncate(this.frechetTwoParParam[2], 4));
            plotGraph.plot();
            this.probPlotDone = true;
        }
        this.frechetTwoParDone = true;
    }

    public double frechetTwoParMu() {
        if (!this.frechetTwoParDone) {
            this.frechetTwoParProbabilityPlot();
        }
        return this.frechetTwoParParam[0];
    }

    public double frechetTwoParMuError() {
        if (!this.frechetTwoParDone) {
            this.frechetTwoParProbabilityPlot();
        }
        return this.frechetTwoParParamErrors[0];
    }

    public double frechetTwoParSigma() {
        if (!this.frechetTwoParDone) {
            this.frechetTwoParProbabilityPlot();
        }
        return this.frechetTwoParParam[1];
    }

    public double frechetTwoParSigmaError() {
        if (!this.frechetTwoParDone) {
            this.frechetTwoParProbabilityPlot();
        }
        return this.frechetTwoParParamErrors[1];
    }

    public double frechetTwoParGamma() {
        if (!this.frechetTwoParDone) {
            this.frechetTwoParProbabilityPlot();
        }
        return this.frechetTwoParParam[2];
    }

    public double frechetTwoParGammaError() {
        if (!this.frechetTwoParDone) {
            this.frechetTwoParProbabilityPlot();
        }
        return this.frechetTwoParParamErrors[2];
    }

    public double[] frechetTwoParOrderStatisticMedians() {
        if (!this.frechetTwoParDone) {
            this.frechetTwoParProbabilityPlot();
        }
        return this.frechetTwoParOrderMedians;
    }

    public double frechetTwoParGradient() {
        if (!this.frechetTwoParDone) {
            this.frechetTwoParProbabilityPlot();
        }
        return this.frechetTwoParLine[1];
    }

    public double frechetTwoParGradientError() {
        if (!this.frechetTwoParDone) {
            this.frechetTwoParProbabilityPlot();
        }
        return this.frechetTwoParLineErrors[1];
    }

    public double frechetTwoParIntercept() {
        if (!this.frechetTwoParDone) {
            this.frechetTwoParProbabilityPlot();
        }
        return this.frechetTwoParLine[0];
    }

    public double frechetTwoParInterceptError() {
        if (!this.frechetTwoParDone) {
            this.frechetTwoParProbabilityPlot();
        }
        return this.frechetTwoParLineErrors[0];
    }

    public double frechetTwoParCorrelationCoefficient() {
        if (!this.frechetTwoParDone) {
            this.frechetTwoParProbabilityPlot();
        }
        return this.frechetTwoParCorrCoeff;
    }

    public double frechetTwoParSumOfSquares() {
        if (!this.frechetTwoParDone) {
            this.frechetTwoParProbabilityPlot();
        }
        return this.frechetTwoParSumOfSquares;
    }

    public double frechetTwoParWeightedSumOfSquares() {
        if (!this.frechetTwoParDone) {
            this.frechetTwoParProbabilityPlot();
        }
        return this.frechetTwoParWeightedSumOfSquares;
    }

    public void frechetStandardUserSuppliedInitialEstimates(double d) {
        this.userSuppliedEstimates[17] = true;
        this.userInitialEstimates[17] = new double[1];
        this.userInitialEstimates[17][0] = d;
    }

    public void removeFrechetStandardUserSuppliedInitialEstimates() {
        this.userSuppliedEstimates[17] = false;
    }

    public void frechetStandardProbabilityPlot() {
        double d;
        this.lastMethod = 17;
        this.frechetStandardNumberOfParameters = 1;
        if (this.numberOfDataPoints < 2) {
            throw new IllegalArgumentException("There must be at least two data points - preferably considerably more");
        }
        Regression regression = new Regression(this.sortedData, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression.suppressErrorMessages();
        }
        double[] dArray = new double[1];
        if (this.userSuppliedEstimates[17]) {
            dArray[0] = this.userInitialEstimates[17][0];
            if (dArray[0] <= 0.0) {
                dArray[0] = 0.1;
            }
        } else {
            dArray[0] = 4.0;
        }
        this.initialEstimates = dArray;
        double[] dArray2 = new double[]{Math.abs(this.stepFactor * dArray[0])};
        regression.addConstraint(0, -1, 0.0);
        FrechetStandardProbPlotFunc frechetStandardProbPlotFunc = new FrechetStandardProbPlotFunc();
        frechetStandardProbPlotFunc.setDataArray(this.numberOfDataPoints);
        regression.simplex((RegressionFunction)frechetStandardProbPlotFunc, Conv.copy(dArray), dArray2, this.tolerance);
        double[] dArray3 = regression.getBestEstimates();
        double[] dArray4 = regression.getBestEstimatesErrors();
        double d2 = d = regression.getSumOfSquares();
        double d3 = d;
        if (this.weighted) {
            d3 = d2 = regression.getSumOfWeightedResidualSquares();
        }
        double[] dArray5 = new double[this.frechetStandardNumberOfParameters];
        dArray5[0] = 2.0 * dArray3[0] - dArray[0];
        if (dArray5[0] <= 0.0) {
            dArray5[0] = 2.0 * dArray3[0] - 0.98 * dArray[0];
        }
        regression.simplex((RegressionFunction)frechetStandardProbPlotFunc, Conv.copy(dArray5), dArray2, this.tolerance);
        this.frechetStandardParam = regression.getBestEstimates();
        this.frechetStandardParamErrors = regression.getBestEstimatesErrors();
        this.frechetStandardWeightedSumOfSquares = this.frechetStandardSumOfSquares = regression.getSumOfSquares();
        double d4 = this.frechetStandardSumOfSquares;
        if (this.weighted) {
            d4 = this.frechetStandardWeightedSumOfSquares = regression.getChiSquare();
        }
        if (d3 < d4) {
            this.frechetStandardParam = dArray3;
            this.frechetStandardParamErrors = dArray4;
            this.frechetStandardSumOfSquares = d;
            if (this.weighted) {
                this.frechetStandardWeightedSumOfSquares = d2;
            }
        }
        this.frechetStandardOrderMedians = Stat.frechetOrderStatisticMedians(this.frechetStandardParam[0], this.numberOfDataPoints);
        Regression regression2 = new Regression(this.frechetStandardOrderMedians, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression2.suppressErrorMessages();
        }
        regression2.linear();
        this.frechetStandardLine = regression2.getBestEstimates();
        this.frechetStandardLineErrors = regression2.getBestEstimatesErrors();
        this.frechetStandardCorrCoeff = regression2.getSampleR();
        if (!this.suppressFile) {
            this.outputFile(this.lastMethod, regression, regression2, this.frechetStandardNumberOfParameters);
        }
        if (!this.suppressPlot) {
            double[][] dArray6 = PlotGraph.data(2, this.numberOfDataPoints);
            dArray6[0] = this.frechetStandardOrderMedians;
            dArray6[1] = this.sortedData;
            dArray6[2] = this.frechetStandardOrderMedians;
            for (int j = 0; j < this.numberOfDataPoints; ++j) {
                dArray6[3][j] = this.frechetStandardLine[0] + this.frechetStandardLine[1] * this.frechetStandardOrderMedians[j];
            }
            PlotGraph plotGraph = new PlotGraph(dArray6);
            int[] nArray = new int[]{4, 0};
            plotGraph.setPoint(nArray);
            int[] nArray2 = new int[]{0, 3};
            plotGraph.setLine(nArray2);
            plotGraph.setXaxisLegend("Frechet StandardOrder Statistic Medians");
            plotGraph.setYaxisLegend("Ordered Data Values");
            plotGraph.setGraphTitle("Standard Frechet probability plot:   gradient = " + Fmath.truncate(this.frechetStandardLine[1], 4) + ", intercept = " + Fmath.truncate(this.frechetStandardLine[0], 4) + ",  R = " + Fmath.truncate(this.frechetStandardCorrCoeff, 4));
            plotGraph.setGraphTitle2("  gamma = " + Fmath.truncate(this.frechetStandardParam[0], 4));
            plotGraph.plot();
            this.probPlotDone = true;
        }
        this.frechetStandardDone = true;
    }

    public double frechetStandardMu() {
        if (!this.frechetStandardDone) {
            this.frechetStandardProbabilityPlot();
        }
        return this.frechetStandardParam[0];
    }

    public double frechetStandardMuError() {
        if (!this.frechetStandardDone) {
            this.frechetStandardProbabilityPlot();
        }
        return this.frechetStandardParamErrors[0];
    }

    public double frechetStandardSigma() {
        if (!this.frechetStandardDone) {
            this.frechetStandardProbabilityPlot();
        }
        return this.frechetStandardParam[1];
    }

    public double frechetStandardSigmaError() {
        if (!this.frechetStandardDone) {
            this.frechetStandardProbabilityPlot();
        }
        return this.frechetStandardParamErrors[1];
    }

    public double frechetStandardGamma() {
        if (!this.frechetStandardDone) {
            this.frechetStandardProbabilityPlot();
        }
        return this.frechetStandardParam[2];
    }

    public double frechetStandardGammaError() {
        if (!this.frechetStandardDone) {
            this.frechetStandardProbabilityPlot();
        }
        return this.frechetStandardParamErrors[2];
    }

    public double[] frechetStandardOrderStatisticMedians() {
        if (!this.frechetStandardDone) {
            this.frechetStandardProbabilityPlot();
        }
        return this.frechetStandardOrderMedians;
    }

    public double frechetStandardGradient() {
        if (!this.frechetStandardDone) {
            this.frechetStandardProbabilityPlot();
        }
        return this.frechetStandardLine[1];
    }

    public double frechetStandardGradientError() {
        if (!this.frechetStandardDone) {
            this.frechetStandardProbabilityPlot();
        }
        return this.frechetStandardLineErrors[1];
    }

    public double frechetStandardIntercept() {
        if (!this.frechetStandardDone) {
            this.frechetStandardProbabilityPlot();
        }
        return this.frechetStandardLine[0];
    }

    public double frechetStandardInterceptError() {
        if (!this.frechetStandardDone) {
            this.frechetStandardProbabilityPlot();
        }
        return this.frechetStandardLineErrors[0];
    }

    public double frechetStandardCorrelationCoefficient() {
        if (!this.frechetStandardDone) {
            this.frechetStandardProbabilityPlot();
        }
        return this.frechetStandardCorrCoeff;
    }

    public double frechetStandardSumOfSquares() {
        if (!this.frechetStandardDone) {
            this.frechetStandardProbabilityPlot();
        }
        return this.frechetStandardSumOfSquares;
    }

    public double frechetStandardWeightedSumOfSquares() {
        if (!this.frechetStandardDone) {
            this.frechetStandardProbabilityPlot();
        }
        return this.frechetStandardWeightedSumOfSquares;
    }

    public void gumbelMinUserSuppliedInitialEstimates(double d, double d2) {
        this.userSuppliedEstimates[5] = true;
        this.userInitialEstimates[5] = new double[2];
        this.userInitialEstimates[5][0] = d;
        this.userInitialEstimates[5][1] = d2;
    }

    public void removeGumbelMinUserSuppliedInitialEstimates() {
        this.userSuppliedEstimates[5] = false;
    }

    public void gumbelMinProbabilityPlot() {
        double[] dArray;
        this.lastMethod = 5;
        this.gumbelMinNumberOfParameters = 2;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        Regression regression = new Regression(this.sortedData, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression.suppressErrorMessages();
        }
        double[] dArray2 = new double[2];
        if (this.userSuppliedEstimates[5]) {
            dArray2[0] = this.userInitialEstimates[5][0];
            dArray2[1] = this.userInitialEstimates[5][1];
            if (dArray2[1] < 0.0) {
                dArray2[1] = this.standardDeviation / 3.0;
            }
        } else {
            dArray2[0] = this.mean;
            dArray2[1] = this.standardDeviation;
        }
        if ((dArray = new double[]{this.stepFactor * dArray2[0], this.stepFactor * dArray2[1]})[0] == 0.0) {
            dArray[0] = this.standardDeviation / 30.0;
        }
        this.initialEstimates = dArray2;
        regression.addConstraint(1, -1, 0.0);
        GumbelMinProbPlotFunc gumbelMinProbPlotFunc = new GumbelMinProbPlotFunc();
        gumbelMinProbPlotFunc.setDataArray(this.numberOfDataPoints);
        regression.simplex((RegressionFunction)gumbelMinProbPlotFunc, dArray2, dArray, this.tolerance);
        this.gumbelMinParam = regression.getBestEstimates();
        this.gumbelMinParamErrors = regression.getBestEstimatesErrors();
        this.gumbelMinWeightedSumOfSquares = this.gumbelMinSumOfSquares = regression.getSumOfSquares();
        if (this.weighted) {
            this.gumbelMinWeightedSumOfSquares = regression.getChiSquare();
        }
        this.gumbelMinOrderMedians = Stat.gumbelMinOrderStatisticMedians(this.gumbelMinParam[0], this.gumbelMinParam[1], this.numberOfDataPoints);
        Regression regression2 = new Regression(this.gumbelMinOrderMedians, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression2.suppressErrorMessages();
        }
        regression2.linear();
        this.gumbelMinLine = regression2.getBestEstimates();
        this.gumbelMinLineErrors = regression2.getBestEstimatesErrors();
        this.gumbelMinCorrCoeff = regression2.getSampleR();
        if (!this.suppressFile) {
            this.outputFile(this.lastMethod, regression, regression2, this.gumbelMinNumberOfParameters);
        }
        if (!this.suppressPlot) {
            double[][] dArray3 = PlotGraph.data(2, this.numberOfDataPoints);
            dArray3[0] = this.gumbelMinOrderMedians;
            dArray3[1] = this.sortedData;
            dArray3[2] = this.gumbelMinOrderMedians;
            for (int j = 0; j < this.numberOfDataPoints; ++j) {
                dArray3[3][j] = this.gumbelMinLine[0] + this.gumbelMinLine[1] * this.gumbelMinOrderMedians[j];
            }
            PlotGraph plotGraph = new PlotGraph(dArray3);
            int[] nArray = new int[]{4, 0};
            plotGraph.setPoint(nArray);
            int[] nArray2 = new int[]{0, 3};
            plotGraph.setLine(nArray2);
            plotGraph.setXaxisLegend("Gumbel (minimum order statistic) Order Statistic Medians");
            plotGraph.setYaxisLegend("Ordered Data Values");
            plotGraph.setGraphTitle("Gumbel (minimum order statistic) probability plot:   gradient = " + Fmath.truncate(this.gumbelMinLine[1], 4) + ", intercept = " + Fmath.truncate(this.gumbelMinLine[0], 4) + ",  R = " + Fmath.truncate(this.gumbelMinCorrCoeff, 4));
            plotGraph.setGraphTitle2("  mu = " + Fmath.truncate(this.gumbelMinParam[0], 4) + ", sigma = " + Fmath.truncate(this.gumbelMinParam[1], 4));
            plotGraph.plot();
            this.probPlotDone = true;
        }
        this.gumbelMinDone = true;
    }

    public double gumbelMinMu() {
        if (!this.gumbelMinDone) {
            this.gumbelMinProbabilityPlot();
        }
        return this.gumbelMinParam[0];
    }

    public double gumbelMinMuError() {
        if (!this.gumbelMinDone) {
            this.gumbelMinProbabilityPlot();
        }
        return this.gumbelMinParamErrors[0];
    }

    public double gumbelMinSigma() {
        if (!this.gumbelMinDone) {
            this.gumbelMinProbabilityPlot();
        }
        return this.gumbelMinParam[1];
    }

    public double gumbelMinSigmaError() {
        if (!this.gumbelMinDone) {
            this.gumbelMinProbabilityPlot();
        }
        return this.gumbelMinParamErrors[1];
    }

    public double[] gumbelMinOrderStatisticMedians() {
        if (!this.gumbelMinDone) {
            this.gumbelMinProbabilityPlot();
        }
        return this.gumbelMinOrderMedians;
    }

    public double gumbelMinGradient() {
        if (!this.gumbelMinDone) {
            this.gumbelMinProbabilityPlot();
        }
        return this.gumbelMinLine[1];
    }

    public double gumbelMinGradientError() {
        if (!this.gumbelMinDone) {
            this.gumbelMinProbabilityPlot();
        }
        return this.gumbelMinLineErrors[1];
    }

    public double gumbelMinIntercept() {
        if (!this.gumbelMinDone) {
            this.gumbelMinProbabilityPlot();
        }
        return this.gumbelMinLine[0];
    }

    public double gumbelMinInterceptError() {
        if (!this.gumbelMinDone) {
            this.gumbelMinProbabilityPlot();
        }
        return this.gumbelMinLineErrors[0];
    }

    public double gumbelMinCorrelationCoefficient() {
        if (!this.gumbelMinDone) {
            this.gumbelMinProbabilityPlot();
        }
        return this.gumbelMinCorrCoeff;
    }

    public double gumbelMinSumOfSquares() {
        if (!this.gumbelMinDone) {
            this.gumbelMinProbabilityPlot();
        }
        return this.gumbelMinSumOfSquares;
    }

    public double gumbelMinWeightedSumOfSquares() {
        if (!this.gumbelMinDone) {
            this.gumbelMinProbabilityPlot();
        }
        return this.gumbelMinWeightedSumOfSquares;
    }

    public void gumbelMaxUserSuppliedInitialEstimates(double d, double d2) {
        this.userSuppliedEstimates[6] = true;
        this.userInitialEstimates[6] = new double[2];
        this.userInitialEstimates[6][0] = d;
        this.userInitialEstimates[6][1] = d2;
    }

    public void removeGumbelMaxUserSuppliedInitialEstimates() {
        this.userSuppliedEstimates[6] = false;
    }

    public void gumbelMaxProbabilityPlot() {
        double[] dArray;
        this.lastMethod = 6;
        this.gumbelMaxNumberOfParameters = 2;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        Regression regression = new Regression(this.sortedData, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression.suppressErrorMessages();
        }
        double[] dArray2 = new double[2];
        if (this.userSuppliedEstimates[6]) {
            dArray2[0] = this.userInitialEstimates[6][0];
            dArray2[1] = this.userInitialEstimates[6][1];
            if (dArray2[1] < 0.0) {
                dArray2[1] = this.standardDeviation / 3.0;
            }
        } else {
            dArray2[0] = this.mean;
            dArray2[1] = this.standardDeviation;
        }
        if ((dArray = new double[]{this.stepFactor * dArray2[0], this.stepFactor * dArray2[1]})[0] == 0.0) {
            dArray[0] = this.standardDeviation / 30.0;
        }
        this.initialEstimates = dArray2;
        regression.addConstraint(1, -1, 0.0);
        GumbelMaxProbPlotFunc gumbelMaxProbPlotFunc = new GumbelMaxProbPlotFunc();
        gumbelMaxProbPlotFunc.setDataArray(this.numberOfDataPoints);
        regression.simplex((RegressionFunction)gumbelMaxProbPlotFunc, dArray2, dArray, this.tolerance);
        this.gumbelMaxParam = regression.getBestEstimates();
        this.gumbelMaxParamErrors = regression.getBestEstimatesErrors();
        this.gumbelMaxWeightedSumOfSquares = this.gumbelMaxSumOfSquares = regression.getSumOfSquares();
        if (this.weighted) {
            this.gumbelMaxWeightedSumOfSquares = regression.getChiSquare();
        }
        this.gumbelMaxOrderMedians = Stat.gumbelMaxOrderStatisticMedians(this.gumbelMaxParam[0], this.gumbelMaxParam[1], this.numberOfDataPoints);
        Regression regression2 = new Regression(this.gumbelMaxOrderMedians, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression2.suppressErrorMessages();
        }
        regression2.linear();
        this.gumbelMaxLine = regression2.getBestEstimates();
        this.gumbelMaxCorrCoeff = regression2.getSampleR();
        if (!this.suppressFile) {
            this.outputFile(this.lastMethod, regression, regression2, this.gumbelMaxNumberOfParameters);
        }
        if (!this.suppressPlot) {
            double[][] dArray3 = PlotGraph.data(2, this.numberOfDataPoints);
            dArray3[0] = this.gumbelMaxOrderMedians;
            dArray3[1] = this.sortedData;
            dArray3[2] = this.gumbelMaxOrderMedians;
            for (int j = 0; j < this.numberOfDataPoints; ++j) {
                dArray3[3][j] = this.gumbelMaxLine[0] + this.gumbelMaxLine[1] * this.gumbelMaxOrderMedians[j];
            }
            PlotGraph plotGraph = new PlotGraph(dArray3);
            int[] nArray = new int[]{4, 0};
            plotGraph.setPoint(nArray);
            int[] nArray2 = new int[]{0, 3};
            plotGraph.setLine(nArray2);
            plotGraph.setXaxisLegend("Gumbel (maximum order statistic) Order Statistic Medians");
            plotGraph.setYaxisLegend("Ordered Data Values");
            plotGraph.setGraphTitle("Gumbel (maximum order statistic) probability plot:   gradient = " + Fmath.truncate(this.gumbelMaxLine[1], 4) + ", intercept = " + Fmath.truncate(this.gumbelMaxLine[0], 4) + ",  R = " + Fmath.truncate(this.gumbelMaxCorrCoeff, 4));
            plotGraph.setGraphTitle2("  mu = " + Fmath.truncate(this.gumbelMaxParam[0], 4) + ", sigma = " + Fmath.truncate(this.gumbelMaxParam[1], 4));
            plotGraph.plot();
            this.probPlotDone = true;
        }
        this.gumbelMaxDone = true;
    }

    public double gumbelMaxMu() {
        if (!this.gumbelMaxDone) {
            this.gumbelMaxProbabilityPlot();
        }
        return this.gumbelMaxParam[0];
    }

    public double gumbelMaxMuError() {
        if (!this.gumbelMaxDone) {
            this.gumbelMaxProbabilityPlot();
        }
        return this.gumbelMaxParamErrors[0];
    }

    public double gumbelMaxSigma() {
        if (!this.gumbelMaxDone) {
            this.gumbelMaxProbabilityPlot();
        }
        return this.gumbelMaxParam[1];
    }

    public double gumbelMaxSigmaError() {
        if (!this.gumbelMaxDone) {
            this.gumbelMaxProbabilityPlot();
        }
        return this.gumbelMaxParamErrors[1];
    }

    public double[] gumbelMaxOrderStatisticMedians() {
        if (!this.gumbelMaxDone) {
            this.gumbelMaxProbabilityPlot();
        }
        return this.gumbelMaxOrderMedians;
    }

    public double gumbelMaxGradient() {
        if (!this.gumbelMaxDone) {
            this.gumbelMaxProbabilityPlot();
        }
        return this.gumbelMaxLine[1];
    }

    public double gumbelMaxGradientError() {
        if (!this.gumbelMaxDone) {
            this.gumbelMaxProbabilityPlot();
        }
        return this.gumbelMaxLineErrors[1];
    }

    public double gumbelMaxIntercept() {
        if (!this.gumbelMaxDone) {
            this.gumbelMaxProbabilityPlot();
        }
        return this.gumbelMaxLine[0];
    }

    public double gumbelMaxInterceptError() {
        if (!this.gumbelMaxDone) {
            this.gumbelMaxProbabilityPlot();
        }
        return this.gumbelMaxLineErrors[0];
    }

    public double gumbelMaxCorrelationCoefficient() {
        if (!this.gumbelMaxDone) {
            this.gumbelMaxProbabilityPlot();
        }
        return this.gumbelMaxCorrCoeff;
    }

    public double gumbelMaxSumOfSquares() {
        if (!this.gumbelMaxDone) {
            this.gumbelMaxProbabilityPlot();
        }
        return this.gumbelMaxSumOfSquares;
    }

    public double gumbelMaxWeightedSumOfSquares() {
        if (!this.gumbelMaxDone) {
            this.gumbelMaxProbabilityPlot();
        }
        return this.gumbelMaxWeightedSumOfSquares;
    }

    public void rayleighUserSuppliedInitialEstimates(double d) {
        this.userSuppliedEstimates[3] = true;
        this.userInitialEstimates[3] = new double[1];
        this.userInitialEstimates[3][0] = d;
    }

    public void removeRayleighUserSuppliedInitialEstimates() {
        this.userSuppliedEstimates[3] = false;
    }

    public void rayleighProbabilityPlot() {
        double[] dArray;
        this.lastMethod = 3;
        this.rayleighNumberOfParameters = 1;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        Regression regression = new Regression(this.sortedData, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression.suppressErrorMessages();
        }
        double[] dArray2 = new double[1];
        if (this.userSuppliedEstimates[3]) {
            dArray2[0] = this.userInitialEstimates[3][0];
            if (dArray2[0] < 0.0) {
                dArray2[0] = this.standardDeviation;
            }
        } else {
            dArray2[0] = this.standardDeviation;
        }
        if ((dArray = new double[]{this.stepFactor * dArray2[0]})[0] == 0.0) {
            dArray[0] = this.standardDeviation / 30.0;
        }
        this.initialEstimates = dArray2;
        regression.addConstraint(0, -1, 0.0);
        RayleighProbPlotFunc rayleighProbPlotFunc = new RayleighProbPlotFunc();
        rayleighProbPlotFunc.setDataArray(this.numberOfDataPoints);
        regression.simplex((RegressionFunction)rayleighProbPlotFunc, dArray2, dArray, this.tolerance);
        this.rayleighParam = regression.getBestEstimates();
        this.rayleighParamErrors = regression.getBestEstimatesErrors();
        this.rayleighWeightedSumOfSquares = this.rayleighSumOfSquares = regression.getSumOfSquares();
        if (this.weighted) {
            this.rayleighWeightedSumOfSquares = regression.getChiSquare();
        }
        this.rayleighOrderMedians = Stat.weibullOrderStatisticMedians(0.0, this.rayleighParam[0] * Math.sqrt(2.0), 2.0, this.numberOfDataPoints);
        Regression regression2 = new Regression(this.rayleighOrderMedians, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression2.suppressErrorMessages();
        }
        regression2.linear();
        this.rayleighLine = regression2.getBestEstimates();
        this.rayleighLineErrors = regression2.getBestEstimatesErrors();
        this.rayleighCorrCoeff = regression2.getSampleR();
        if (!this.suppressFile) {
            this.outputFile(this.lastMethod, regression, regression2, this.rayleighNumberOfParameters);
        }
        if (!this.suppressPlot) {
            double[][] dArray3 = PlotGraph.data(2, this.numberOfDataPoints);
            dArray3[0] = this.rayleighOrderMedians;
            dArray3[1] = this.sortedData;
            dArray3[2] = this.rayleighOrderMedians;
            for (int j = 0; j < this.numberOfDataPoints; ++j) {
                dArray3[3][j] = this.rayleighLine[0] + this.rayleighLine[1] * this.rayleighOrderMedians[j];
            }
            PlotGraph plotGraph = new PlotGraph(dArray3);
            int[] nArray = new int[]{4, 0};
            plotGraph.setPoint(nArray);
            int[] nArray2 = new int[]{0, 3};
            plotGraph.setLine(nArray2);
            plotGraph.setXaxisLegend("Rayleigh Order Statistic Medians");
            plotGraph.setYaxisLegend("Ordered Data Values");
            plotGraph.setGraphTitle("Rayleigh probability plot:   gradient = " + Fmath.truncate(this.rayleighLine[1], 4) + ", intercept = " + Fmath.truncate(this.rayleighLine[0], 4) + ",  R = " + Fmath.truncate(this.rayleighCorrCoeff, 4));
            plotGraph.setGraphTitle2("  beta = " + Fmath.truncate(this.rayleighParam[0], 4));
            plotGraph.plot();
            this.probPlotDone = true;
        }
        this.rayleighDone = true;
    }

    public double rayleighBeta() {
        if (!this.rayleighDone) {
            this.rayleighProbabilityPlot();
        }
        return this.rayleighParam[0];
    }

    public double rayleighBetaError() {
        if (!this.rayleighDone) {
            this.rayleighProbabilityPlot();
        }
        return this.rayleighParamErrors[0];
    }

    public double[] rayleighOrderStatisticMedians() {
        if (!this.rayleighDone) {
            this.rayleighProbabilityPlot();
        }
        return this.rayleighOrderMedians;
    }

    public double rayleighGradient() {
        if (!this.rayleighDone) {
            this.rayleighProbabilityPlot();
        }
        return this.rayleighLine[1];
    }

    public double rayleighGradientError() {
        if (!this.rayleighDone) {
            this.rayleighProbabilityPlot();
        }
        return this.rayleighLineErrors[1];
    }

    public double rayleighIntercept() {
        if (!this.rayleighDone) {
            this.rayleighProbabilityPlot();
        }
        return this.rayleighLine[0];
    }

    public double rayleighInterceptError() {
        if (!this.rayleighDone) {
            this.rayleighProbabilityPlot();
        }
        return this.rayleighLineErrors[0];
    }

    public double rayleighCorrelationCoefficient() {
        if (!this.rayleighDone) {
            this.rayleighProbabilityPlot();
        }
        return this.rayleighCorrCoeff;
    }

    public double rayleighSumOfSquares() {
        if (!this.rayleighDone) {
            this.rayleighProbabilityPlot();
        }
        return this.rayleighSumOfSquares;
    }

    public double rayleighMinWeightedSumOfSquares() {
        if (!this.rayleighDone) {
            this.rayleighProbabilityPlot();
        }
        return this.rayleighWeightedSumOfSquares;
    }

    public void paretoUserSuppliedInitialEstimates(double d, double d2) {
        this.userSuppliedEstimates[4] = true;
        this.userInitialEstimates[4] = new double[2];
        this.userInitialEstimates[4][0] = d;
        this.userInitialEstimates[4][1] = d2;
    }

    public void removeParetoUserSuppliedInitialEstimates() {
        this.userSuppliedEstimates[4] = false;
    }

    public void paretoProbabilityPlot() {
        double[] dArray;
        this.lastMethod = 4;
        this.paretoNumberOfParameters = 2;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        Regression regression = new Regression(this.sortedData, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression.suppressErrorMessages();
        }
        double[] dArray2 = new double[2];
        if (this.userSuppliedEstimates[4]) {
            dArray2[0] = this.userInitialEstimates[4][0];
            dArray2[1] = this.userInitialEstimates[4][1];
            if (dArray2[1] < this.minimum) {
                dArray2[1] = this.minimum + this.standardDeviation / 30.0;
            }
        } else {
            dArray2[0] = this.mean / (this.mean - this.minimum);
            dArray2[1] = this.minimum + this.standardDeviation / 30.0;
        }
        if ((dArray = new double[]{Math.abs(this.stepFactor * dArray2[0]), Math.abs(this.stepFactor * dArray2[1])})[0] == 0.0) {
            dArray[0] = this.standardDeviation / 30.0;
        }
        if (dArray[1] == 0.0) {
            dArray[1] = this.standardDeviation / 30.0;
        }
        this.initialEstimates = dArray2;
        ParetoProbPlotFunc paretoProbPlotFunc = new ParetoProbPlotFunc();
        paretoProbPlotFunc.setDataArray(this.numberOfDataPoints);
        regression.simplex((RegressionFunction)paretoProbPlotFunc, dArray2, dArray, this.tolerance);
        this.paretoParam = regression.getBestEstimates();
        this.paretoParamErrors = regression.getBestEstimatesErrors();
        this.paretoWeightedSumOfSquares = this.paretoSumOfSquares = regression.getSumOfSquares();
        if (this.weighted) {
            this.paretoWeightedSumOfSquares = regression.getChiSquare();
        }
        this.paretoOrderMedians = Stat.paretoOrderStatisticMedians(this.paretoParam[0], this.paretoParam[1], this.numberOfDataPoints);
        Regression regression2 = new Regression(this.paretoOrderMedians, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression2.suppressErrorMessages();
        }
        regression2.linear();
        this.paretoLine = regression2.getBestEstimates();
        this.paretoLineErrors = regression2.getBestEstimatesErrors();
        this.paretoCorrCoeff = regression2.getSampleR();
        if (!this.suppressFile) {
            this.outputFile(this.lastMethod, regression, regression2, this.paretoNumberOfParameters);
        }
        if (!this.suppressPlot) {
            double[][] dArray3 = PlotGraph.data(2, this.numberOfDataPoints);
            dArray3[0] = this.paretoOrderMedians;
            dArray3[1] = this.sortedData;
            dArray3[2] = this.paretoOrderMedians;
            for (int j = 0; j < this.numberOfDataPoints; ++j) {
                dArray3[3][j] = this.paretoLine[0] + this.paretoLine[1] * this.paretoOrderMedians[j];
            }
            PlotGraph plotGraph = new PlotGraph(dArray3);
            int[] nArray = new int[]{4, 0};
            plotGraph.setPoint(nArray);
            int[] nArray2 = new int[]{0, 3};
            plotGraph.setLine(nArray2);
            plotGraph.setXaxisLegend("Pareto Order Statistic Medians");
            plotGraph.setYaxisLegend("Ordered Data Values");
            plotGraph.setGraphTitle("Pareto probability plot:   gradient = " + Fmath.truncate(this.paretoLine[1], 4) + ", intercept = " + Fmath.truncate(this.paretoLine[0], 4) + ",  R = " + Fmath.truncate(this.paretoCorrCoeff, 4));
            plotGraph.setGraphTitle2("  alpha = " + Fmath.truncate(this.paretoParam[0], 4) + ", beta = " + Fmath.truncate(this.paretoParam[1], 4));
            plotGraph.plot();
            this.probPlotDone = true;
        }
        this.paretoDone = true;
    }

    public double paretoAlpha() {
        if (!this.paretoDone) {
            this.paretoProbabilityPlot();
        }
        return this.paretoParam[0];
    }

    public double paretoAlphaError() {
        if (!this.paretoDone) {
            this.paretoProbabilityPlot();
        }
        return this.paretoParamErrors[0];
    }

    public double paretoBeta() {
        if (!this.paretoDone) {
            this.paretoProbabilityPlot();
        }
        return this.paretoParam[1];
    }

    public double paretoBetaError() {
        if (!this.paretoDone) {
            this.paretoProbabilityPlot();
        }
        return this.paretoParamErrors[1];
    }

    public double[] paretoOrderStatisticMedians() {
        if (!this.paretoDone) {
            this.paretoProbabilityPlot();
        }
        return this.paretoOrderMedians;
    }

    public double paretoGradient() {
        if (!this.paretoDone) {
            this.paretoProbabilityPlot();
        }
        return this.paretoLine[1];
    }

    public double paretoGradientError() {
        if (!this.paretoDone) {
            this.paretoProbabilityPlot();
        }
        return this.paretoLineErrors[1];
    }

    public double paretoIntercept() {
        if (!this.paretoDone) {
            this.paretoProbabilityPlot();
        }
        return this.paretoLine[0];
    }

    public double paretoInterceptError() {
        if (!this.paretoDone) {
            this.paretoProbabilityPlot();
        }
        return this.paretoLineErrors[0];
    }

    public double paretoCorrelationCoefficient() {
        if (!this.paretoDone) {
            this.paretoProbabilityPlot();
        }
        return this.paretoCorrCoeff;
    }

    public double paretoSumOfSquares() {
        if (!this.paretoDone) {
            this.paretoProbabilityPlot();
        }
        return this.paretoSumOfSquares;
    }

    public double paretoWeightedSumOfSquares() {
        if (!this.paretoDone) {
            this.paretoProbabilityPlot();
        }
        return this.paretoWeightedSumOfSquares;
    }

    public void fDistributionProbabilityPlot(int n, int n2) {
        this.lastMethod = 15;
        this.fDistributionNu1 = n;
        this.fDistributionNu2 = n2;
        this.fDistributionNumberOfParameters = 0;
        if (this.numberOfDataPoints < 3) {
            throw new IllegalArgumentException("There must be at least three data points - preferably considerably more");
        }
        this.fDistributionOrderMedians = Stat.fDistributionOrderStatisticMedians(n, n2, this.numberOfDataPoints);
        Regression regression = new Regression(this.fDistributionOrderMedians, this.sortedData, this.sortedWeights);
        if (this.suppressErrorMessages) {
            regression.suppressErrorMessages();
        }
        regression.linear();
        this.fDistributionLine = regression.getBestEstimates();
        this.fDistributionLineErrors = regression.getBestEstimatesErrors();
        this.fDistributionCorrCoeff = regression.getSampleR();
        this.fDistributionSumOfSquares = regression.getSumOfSquares();
        this.fDistributionSumOfSquares = regression.getSumOfSquares();
        this.fDistributionWeightedSumOfSquares = this.paretoSumOfSquares;
        if (this.weighted) {
            this.fDistributionWeightedSumOfSquares = regression.getChiSquare();
        }
        if (!this.suppressFile) {
            this.outputFile(this.lastMethod, null, regression, 0);
        }
        if (!this.suppressPlot) {
            double[][] dArray = PlotGraph.data(2, this.numberOfDataPoints);
            dArray[0] = this.fDistributionOrderMedians;
            dArray[1] = this.sortedData;
            dArray[2] = this.fDistributionOrderMedians;
            for (int j = 0; j < this.numberOfDataPoints; ++j) {
                dArray[3][j] = this.fDistributionLine[0] + this.fDistributionLine[1] * this.fDistributionOrderMedians[j];
            }
            PlotGraph plotGraph = new PlotGraph(dArray);
            int[] nArray = new int[]{4, 0};
            plotGraph.setPoint(nArray);
            int[] nArray2 = new int[]{0, 3};
            plotGraph.setLine(nArray2);
            plotGraph.setXaxisLegend("F-distribution Order Statistic Medians");
            plotGraph.setYaxisLegend("Ordered Data Values");
            plotGraph.setGraphTitle("F-distribution probability plot:   gradient = " + Fmath.truncate(this.fDistributionLine[1], 4) + ", intercept = " + Fmath.truncate(this.fDistributionLine[0], 4) + ",  R = " + Fmath.truncate(this.fDistributionCorrCoeff, 4));
            plotGraph.setGraphTitle2("  nu1 = " + n + ", nu2 = " + n2);
            plotGraph.plot();
            this.probPlotDone = true;
        }
        this.fDistributionDone = true;
    }

    public double[] fDistributionOrderStatisticMedians() {
        if (!this.fDistributionDone) {
            throw new IllegalArgumentException("F-distribution Probability Plot method has not been called");
        }
        return this.fDistributionOrderMedians;
    }

    public double fDistributionGradient() {
        if (!this.fDistributionDone) {
            throw new IllegalArgumentException("F-distribution Probability Plot method has not been called");
        }
        return this.fDistributionLine[1];
    }

    public double fDistributionGradientError() {
        if (!this.fDistributionDone) {
            throw new IllegalArgumentException("F-distribution Probability Plot method has not been called");
        }
        return this.fDistributionLineErrors[1];
    }

    public double fDistributionIntercept() {
        if (!this.fDistributionDone) {
            throw new IllegalArgumentException("F-distribution Probability Plot method has not been called");
        }
        return this.fDistributionLine[0];
    }

    public double fDistributionInterceptError() {
        if (!this.fDistributionDone) {
            throw new IllegalArgumentException("F-distribution Probability Plot method has not been called");
        }
        return this.fDistributionLineErrors[0];
    }

    public double fDistributionCorrelationCoefficient() {
        if (!this.fDistributionDone) {
            throw new IllegalArgumentException("F-distribution Probability Plot method has not been called");
        }
        return this.fDistributionCorrCoeff;
    }

    public double fDistributionSumOfSquares() {
        if (!this.fDistributionDone) {
            throw new IllegalArgumentException("F-distribution Probability Plot method has not been called");
        }
        return this.fDistributionSumOfSquares;
    }

    public double fDistributionWeightedSumOfSquares() {
        if (!this.fDistributionDone) {
            throw new IllegalArgumentException("F-distribution Probability Plot method has not been called");
        }
        return this.fDistributionWeightedSumOfSquares;
    }

    public double[] orderedData() {
        return this.sortedData;
    }

    public int numberOfDataPoints() {
        return this.numberOfDataPoints;
    }

    public double mean() {
        return this.mean;
    }

    public double standardDeviation() {
        if (!this.probPlotDone) {
            throw new IllegalArgumentException("no probability plot method has been called");
        }
        return this.standardDeviation;
    }

    public double minimum() {
        return this.minimum;
    }

    public double maximum() {
        return this.maximum;
    }

    public double delta() {
        return this.delta;
    }

    public void resetDelta(double d) {
        this.delta = d;
    }

    public double stepFactor() {
        return this.stepFactor;
    }

    public void resetStepFactor(double d) {
        this.stepFactor = d;
    }

    public void setDenominatorToN() {
        this.nFactorOptionI = true;
        this.arrayAsStat.setDenominatorToN();
        this.standardDeviation = this.arrayAsStat.standardDeviation();
        this.nFactorReset = true;
    }

    public void setDenominatorToNminusOne() {
        this.nFactorOptionI = false;
        this.arrayAsStat.setDenominatorToNminusOne();
        this.standardDeviation = this.arrayAsStat.standardDeviation();
        this.nFactorReset = true;
    }

    public double[] getInitialEstimates() {
        if (this.lastMethod == -1) {
            throw new IllegalArgumentException("No probability plot method has been called");
        }
        return this.initialEstimates;
    }

    public void outputFile(int n, Regression regression, Regression regression2, int n2) {
        String string = this.methodNames[this.lastMethod];
        String string2 = string + "ProbabilityPlotOutput.txt";
        string2 = this.removeSpacesEtc(string2);
        double[] dArray = regression2.getBestEstimates();
        double[] dArray2 = regression2.getBestEstimatesErrors();
        double[] dArray3 = null;
        double[] dArray4 = null;
        double[][] dArray5 = null;
        if (n2 > 0) {
            dArray3 = regression.getBestEstimates();
            dArray4 = regression.getBestEstimatesErrors();
            dArray5 = regression.getCorrCoeffMatrix();
        }
        FileOutput fileOutput = new FileOutput(string2);
        fileOutput.println(string + " Probability Plot");
        fileOutput.println();
        fileOutput.println(this.tad.getFullDate() + ", " + this.tad.getShortTime24());
        fileOutput.println();
        switch (this.weightingOption) {
            case 0: {
                fileOutput.println("Unweighted constrained simplex regression");
                break;
            }
            case 1: {
                fileOutput.println("Weighted constrained simplex regression - user supplied weights");
                break;
            }
            case 2: {
                fileOutput.println("Weighted constrained simplex regression - weights = responses");
                break;
            }
            case 3: {
                fileOutput.println("Weighted constrained simplex regression - weights = square root of the responses");
            }
        }
        fileOutput.println();
        fileOutput.print("Gradient:  " + Fmath.truncate(dArray[1], this.trunc), 25);
        fileOutput.println("s.e. " + Fmath.truncate(dArray2[1], this.trunc));
        fileOutput.print("Intercept: " + Fmath.truncate(dArray[0], this.trunc), 25);
        fileOutput.println("s.e. " + Fmath.truncate(dArray2[0], this.trunc));
        fileOutput.println();
        fileOutput.println("Correlation Coefficient, r: " + Fmath.truncate(regression2.getSampleR(), this.trunc));
        fileOutput.println("Critical Value for r:       " + Fmath.truncate(this.correlationCoefficientCriticalValue(), this.trunc));
        fileOutput.println("Significance level used:    " + this.significance * 100.0 + "%");
        fileOutput.println("Sum of squares:             " + Fmath.truncate(regression2.getSumOfSquares(), this.trunc));
        fileOutput.println();
        if (n2 > 0) {
            int n3;
            fileOutput.println("Best Estimates of the Parameters");
            for (n3 = 0; n3 < n2; ++n3) {
                fileOutput.print(this.methodParameters[n][n3] + ": ", 8);
                fileOutput.print(Fmath.truncate(dArray3[n3], this.trunc), 12);
                fileOutput.println("'pseudo-linear' s.e. " + Fmath.truncate(dArray4[n3], this.trunc));
            }
            fileOutput.println();
            fileOutput.println("The 'pseudo-linear' s.e.s are a lower limit to the s.e. and may significantly underestimate the s.e.");
            fileOutput.println("See documentation, http://www.ee.ucl.ac.uk/~mflanaga/java/ProbabilityPlot.html, for details");
            fileOutput.println();
            fileOutput.println("'Pseudo-linear' Parameter-Parameter Correlation Coefficients");
            fileOutput.print(" ", 8);
            for (n3 = 0; n3 < n2; ++n3) {
                fileOutput.print(this.methodParameters[n][n3], 12);
            }
            fileOutput.println();
            for (n3 = 0; n3 < n2; ++n3) {
                fileOutput.print(this.methodParameters[n][n3], 8);
                for (int j = 0; j < n2; ++j) {
                    fileOutput.print(Fmath.truncate(dArray5[n3][j], this.trunc), 12);
                }
                fileOutput.println();
            }
        } else if (n == 15) {
            fileOutput.println("Degrees of freedom, nu1: " + this.fDistributionNu1);
            fileOutput.println("Degrees of freedom, nu2: " + this.fDistributionNu2);
        }
        fileOutput.close();
    }

    public String removeSpacesEtc(String string) {
        int n = string.length();
        String string2 = "";
        for (int j = 0; j < n; ++j) {
            char c = string.charAt(j);
            if (c == ' ' || c == '(' || c == ')' || c == '-') continue;
            string2 = string2 + c;
        }
        return string2;
    }

    public void setStartOfGraphTitle(String string) {
        this.titleStart = string;
    }
}

