/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.Cronbach;
import flanagan.analysis.PCA;
import flanagan.analysis.Scores;
import flanagan.analysis.Stat;
import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Matrix;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class RankAnalysis {
    private double[][] values = null;
    private double[][] errors = null;
    private double[] valuesDiagonal = null;
    private double[] errorsDiagonal = null;
    private double[][] reducedValues = null;
    private double[][] reducedErrors = null;
    private double[] reducedValuesDiagonal = null;
    private double[] reducedErrorsDiagonal = null;
    private double[] reducedValueOverError = null;
    private double[] probabilityValues = null;
    private double[] mcMullen = null;
    private int numberOfRows = 0;
    private int numberOfColumns = 0;
    private int diagonalLength = 0;
    private int errorType = 3;
    private double[] errorRowMeans = null;
    private double[] errorColumnMeans = null;
    private int numberOfMissingErrors = 0;
    private boolean rowOption = true;
    private boolean rankAnalysisDone = false;

    public RankAnalysis(double[][] dArray, double[][] dArray2) {
        this.values = Conv.copy(dArray);
        this.errors = Conv.copy(dArray2);
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(float[][] fArray, float[][] fArray2) {
        Matrix matrix = new Matrix(fArray);
        this.values = matrix.getArrayCopy();
        Matrix matrix2 = new Matrix(fArray2);
        this.errors = matrix2.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(long[][] lArray, long[][] lArray2) {
        Matrix matrix = new Matrix(lArray);
        this.values = matrix.getArrayCopy();
        Matrix matrix2 = new Matrix(lArray2);
        this.errors = matrix2.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(int[][] nArray, int[][] nArray2) {
        Matrix matrix = new Matrix(nArray);
        this.values = matrix.getArrayCopy();
        Matrix matrix2 = new Matrix(nArray2);
        this.errors = matrix2.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(BigDecimal[][] bigDecimalArray, BigDecimal[][] bigDecimalArray2) {
        Matrix matrix = new Matrix(bigDecimalArray);
        this.values = matrix.getArrayCopy();
        Matrix matrix2 = new Matrix(bigDecimalArray2);
        this.errors = matrix2.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(BigInteger[][] bigIntegerArray, BigInteger[][] bigIntegerArray2) {
        Matrix matrix = new Matrix(bigIntegerArray);
        this.values = matrix.getArrayCopy();
        Matrix matrix2 = new Matrix(bigIntegerArray2);
        this.errors = matrix2.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(ArrayMaths[] arrayMathsArray, ArrayMaths[] arrayMathsArray2) {
        Matrix matrix = new Matrix(arrayMathsArray);
        this.values = matrix.getArrayCopy();
        Matrix matrix2 = new Matrix(arrayMathsArray2);
        this.errors = matrix2.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(ArrayList<Object>[] arrayListArray, ArrayList<Object>[] arrayListArray2) {
        Matrix matrix = new Matrix(arrayListArray);
        this.values = matrix.getArrayCopy();
        Matrix matrix2 = new Matrix(arrayListArray2);
        this.errors = matrix2.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(Vector<Object>[] vectorArray, Vector<Object>[] vectorArray2) {
        Matrix matrix = new Matrix(vectorArray);
        this.values = matrix.getArrayCopy();
        Matrix matrix2 = new Matrix(vectorArray2);
        this.errors = matrix2.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(Matrix matrix, Matrix matrix2) {
        this.values = matrix.getArrayCopy();
        this.errors = matrix2.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(double[][] dArray, double[] dArray2) {
        this.values = Conv.copy(dArray);
        this.errors = this.oneToTwo(Conv.copy(dArray2), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(float[][] fArray, float[] fArray2) {
        Matrix matrix = new Matrix(fArray);
        this.values = matrix.getArrayCopy();
        ArrayMaths arrayMaths = new ArrayMaths(fArray2);
        this.errors = this.oneToTwo(arrayMaths.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(long[][] lArray, long[] lArray2) {
        Matrix matrix = new Matrix(lArray);
        this.values = matrix.getArrayCopy();
        ArrayMaths arrayMaths = new ArrayMaths(lArray2);
        this.errors = this.oneToTwo(arrayMaths.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(int[][] nArray, int[] nArray2) {
        Matrix matrix = new Matrix(nArray);
        this.values = matrix.getArrayCopy();
        ArrayMaths arrayMaths = new ArrayMaths(nArray2);
        this.errors = this.oneToTwo(arrayMaths.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(BigDecimal[][] bigDecimalArray, BigDecimal[] bigDecimalArray2) {
        Matrix matrix = new Matrix(bigDecimalArray);
        this.values = matrix.getArrayCopy();
        ArrayMaths arrayMaths = new ArrayMaths(bigDecimalArray2);
        this.errors = this.oneToTwo(arrayMaths.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(BigInteger[][] bigIntegerArray, BigInteger[] bigIntegerArray2) {
        Matrix matrix = new Matrix(bigIntegerArray);
        this.values = matrix.getArrayCopy();
        ArrayMaths arrayMaths = new ArrayMaths(bigIntegerArray2);
        this.errors = this.oneToTwo(arrayMaths.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(ArrayMaths[] arrayMathsArray, ArrayMaths arrayMaths) {
        Matrix matrix = new Matrix(arrayMathsArray);
        this.values = matrix.getArrayCopy();
        this.errors = this.oneToTwo(arrayMaths.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(ArrayList<Object>[] arrayListArray, ArrayList<Object> arrayList) {
        Matrix matrix = new Matrix(arrayListArray);
        this.values = matrix.getArrayCopy();
        ArrayMaths arrayMaths = new ArrayMaths(arrayList);
        this.errors = this.oneToTwo(arrayMaths.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(Vector<Object>[] vectorArray, Vector<Object> vector) {
        Matrix matrix = new Matrix(vectorArray);
        this.values = matrix.getArrayCopy();
        ArrayMaths arrayMaths = new ArrayMaths(vector);
        this.errors = this.oneToTwo(arrayMaths.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(Scores scores) {
        this.values = scores.usedScoresAsRowPerItem();
        Matrix matrix = new Matrix(this.values);
        double[] dArray = matrix.rowStandardDeviations();
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        this.errors = this.oneToTwo(arrayMaths.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(Cronbach cronbach) {
        this.values = cronbach.usedScoresAsRowPerItem();
        Matrix matrix = new Matrix(this.values);
        double[] dArray = matrix.rowStandardDeviations();
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        this.errors = this.oneToTwo(arrayMaths.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(PCA pCA) {
        this.values = pCA.usedScoresAsRowPerItem();
        Matrix matrix = new Matrix(this.values);
        double[] dArray = matrix.rowStandardDeviations();
        ArrayMaths arrayMaths = new ArrayMaths(dArray);
        this.errors = this.oneToTwo(arrayMaths.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(double[][] dArray, double d) {
        this.values = Conv.copy(dArray);
        this.errorType = 2;
        this.preprocessDataTwo(d);
    }

    public RankAnalysis(float[][] fArray, float f) {
        Matrix matrix = new Matrix(fArray);
        this.values = matrix.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(f);
    }

    public RankAnalysis(long[][] lArray, long l) {
        Matrix matrix = new Matrix(lArray);
        this.values = matrix.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(l);
    }

    public RankAnalysis(int[][] nArray, int n) {
        Matrix matrix = new Matrix(nArray);
        this.values = matrix.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(n);
    }

    public RankAnalysis(BigDecimal[][] bigDecimalArray, BigDecimal bigDecimal) {
        Matrix matrix = new Matrix(bigDecimalArray);
        this.values = matrix.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(bigDecimal.doubleValue());
    }

    public RankAnalysis(BigInteger[][] bigIntegerArray, BigInteger bigInteger) {
        Matrix matrix = new Matrix(bigIntegerArray);
        this.values = matrix.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(bigInteger.doubleValue());
    }

    public RankAnalysis(ArrayMaths[] arrayMathsArray, double d) {
        Matrix matrix = new Matrix(arrayMathsArray);
        this.values = matrix.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(d);
    }

    public RankAnalysis(ArrayList<Object>[] arrayListArray, double d) {
        Matrix matrix = new Matrix(arrayListArray);
        this.values = matrix.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(d);
    }

    public RankAnalysis(Vector<Object>[] vectorArray, double d) {
        Matrix matrix = new Matrix(vectorArray);
        this.values = matrix.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(d);
    }

    public RankAnalysis(Matrix matrix, double d) {
        this.values = matrix.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(d);
    }

    public RankAnalysis(double[][] dArray) {
        this.values = Conv.copy(dArray);
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(float[][] fArray) {
        Matrix matrix = new Matrix(fArray);
        this.values = matrix.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(long[][] lArray) {
        Matrix matrix = new Matrix(lArray);
        this.values = matrix.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(int[][] nArray) {
        Matrix matrix = new Matrix(nArray);
        this.values = matrix.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(BigDecimal[][] bigDecimalArray) {
        Matrix matrix = new Matrix(bigDecimalArray);
        this.values = matrix.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(BigInteger[][] bigIntegerArray) {
        Matrix matrix = new Matrix(bigIntegerArray);
        this.values = matrix.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(ArrayMaths[] arrayMathsArray) {
        Matrix matrix = new Matrix(arrayMathsArray);
        this.values = matrix.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(ArrayList<Object>[] arrayListArray) {
        Matrix matrix = new Matrix(arrayListArray);
        this.values = matrix.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(Vector<Object>[] vectorArray) {
        Matrix matrix = new Matrix(vectorArray);
        this.values = matrix.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(Matrix matrix) {
        this.values = matrix.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    private double[][] oneToTwo(double[] dArray, int n) {
        int n2 = dArray.length;
        double[][] dArray2 = new double[n2][n];
        for (int j = 0; j < n2; ++j) {
            for (int k = 0; k < n; ++k) {
                dArray2[j][k] = dArray[j];
            }
        }
        return dArray2;
    }

    private void preprocessDataOne() {
        int n;
        this.numberOfRows = this.values.length;
        this.numberOfColumns = this.values[0].length;
        for (n = 1; n < this.numberOfRows; ++n) {
            if (this.values[n].length == this.numberOfColumns) continue;
            throw new IllegalArgumentException("All rows of the value matrix must be of the same length");
        }
        for (n = 0; n < this.numberOfRows; ++n) {
            if (this.errors[n].length == this.numberOfColumns) continue;
            throw new IllegalArgumentException("All rows of the error matrix must be of the same length as those of the value matrix");
        }
        this.diagonalLength = this.numberOfRows;
        if (this.numberOfRows > this.numberOfColumns) {
            this.diagonalLength = this.numberOfColumns;
        }
        for (n = 0; n < this.numberOfRows; ++n) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                double[] dArray = this.errors[n];
                int n2 = j;
                dArray[n2] = dArray[n2] * this.errors[n][j];
            }
        }
    }

    private void preprocessDataTwo(double d) {
        int n;
        this.numberOfRows = this.values.length;
        this.numberOfColumns = this.values[0].length;
        for (n = 1; n < this.numberOfRows; ++n) {
            if (this.values[n].length == this.numberOfColumns) continue;
            throw new IllegalArgumentException("All rows of the value matrix must be of the same length");
        }
        this.diagonalLength = this.numberOfRows;
        if (this.numberOfRows > this.numberOfColumns) {
            this.diagonalLength = this.numberOfColumns;
        }
        this.errors = new double[this.numberOfRows][this.numberOfColumns];
        for (n = 0; n < this.numberOfRows; ++n) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.errors[n][j] = d * d;
            }
        }
    }

    private void preprocessDataThree() {
        this.numberOfRows = this.values.length;
        this.numberOfColumns = this.values[0].length;
        for (int j = 1; j < this.numberOfRows; ++j) {
            if (this.values[j].length == this.numberOfColumns) continue;
            throw new IllegalArgumentException("All rows of the value matrix must be of the same length");
        }
        this.diagonalLength = this.numberOfRows;
        if (this.numberOfRows > this.numberOfColumns) {
            this.diagonalLength = this.numberOfColumns;
        }
        this.errors = new double[this.numberOfRows][this.numberOfColumns];
        double d = 0.0;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int k = 0; k < this.numberOfColumns; ++k) {
                d = Math.pow(10.0, Math.floor(Math.log10(Math.abs(this.values[j][k])))) * 5.0E-16;
                this.errors[j][k] = d * d;
            }
        }
    }

    public void useErrorRowMean() {
        this.rowOption = true;
    }

    public void useErrorColumnMean() {
        this.rowOption = false;
    }

    public int nMissingErrors() {
        return this.numberOfMissingErrors;
    }

    private void rankAnalysis() {
        int n;
        int n2;
        int n3;
        int n4;
        this.errorRowMeans = new double[this.numberOfRows];
        this.errorColumnMeans = new double[this.numberOfColumns];
        this.numberOfMissingErrors = 0;
        int n5 = 0;
        while (n5 < this.numberOfRows) {
            n4 = 0;
            for (n3 = 0; n3 < this.numberOfColumns; ++n3) {
                if (!Double.isNaN(this.errors[n5][n3])) {
                    if (this.errors[n5][n3] < 0.0) {
                        double[] dArray = this.errors[n5];
                        int n6 = n3;
                        dArray[n6] = dArray[n6] * -1.0;
                    }
                    int n7 = n5;
                    this.errorRowMeans[n7] = this.errorRowMeans[n7] + this.errors[n5][n3];
                    ++n4;
                    continue;
                }
                ++this.numberOfMissingErrors;
            }
            int n8 = n5++;
            this.errorRowMeans[n8] = this.errorRowMeans[n8] / (double)n4;
        }
        n5 = 0;
        while (n5 < this.numberOfColumns) {
            n4 = 0;
            for (n3 = 0; n3 < this.numberOfRows; ++n3) {
                if (Double.isNaN(this.errors[n3][n5])) continue;
                int n9 = n5;
                this.errorColumnMeans[n9] = this.errorColumnMeans[n9] + this.errors[n3][n5];
                ++n4;
            }
            int n10 = n5++;
            this.errorColumnMeans[n10] = this.errorColumnMeans[n10] / (double)n4;
        }
        if (this.numberOfMissingErrors > 0) {
            for (n5 = 0; n5 < this.numberOfRows; ++n5) {
                for (n4 = 0; n4 < this.numberOfColumns; ++n4) {
                    if (!Double.isNaN(this.errors[n5][n4])) continue;
                    this.errors[n5][n4] = this.rowOption ? this.errorRowMeans[n5] : this.errorColumnMeans[n5];
                }
            }
        }
        this.reducedValues = this.values;
        this.reducedErrors = this.errors;
        Matrix matrix = new Matrix(this.reducedValues);
        Matrix matrix2 = new Matrix(this.reducedErrors);
        n3 = this.diagonalLength - 1;
        for (n2 = 0; n2 < n3; ++n2) {
            matrix = new Matrix(this.reducedValues);
            n = this.numberOfRows - n2;
            int n11 = this.numberOfColumns - n2;
            Matrix matrix3 = matrix.getSubMatrix(n2, n2, this.numberOfRows - 1, this.numberOfColumns - 1);
            double[][] dArray = matrix3.getArrayCopy();
            int[] nArray = matrix3.pivot();
            int n12 = nArray[0] + n2;
            int n13 = nArray[1] + n2;
            double[] dArray2 = this.reducedValues[n2];
            double[] dArray3 = this.reducedErrors[n2];
            this.reducedValues[n2] = this.reducedValues[n12];
            this.reducedErrors[n2] = this.reducedErrors[n12];
            this.reducedValues[n12] = dArray2;
            this.reducedErrors[n12] = dArray3;
            double d = 0.0;
            double d2 = 0.0;
            for (int j = 0; j < this.numberOfRows; ++j) {
                d = this.reducedValues[j][n2];
                d2 = this.reducedErrors[j][n2];
                this.reducedValues[j][n2] = this.reducedValues[j][n13];
                this.reducedErrors[j][n2] = this.reducedErrors[j][n13];
                this.reducedValues[j][n13] = d;
                this.reducedErrors[j][n13] = d2;
            }
            Matrix matrix4 = new Matrix(this.reducedValues);
            Matrix matrix5 = new Matrix(this.reducedErrors);
            double[][] dArray4 = matrix4.getArrayCopy();
            double[][] dArray5 = matrix5.getArrayCopy();
            for (int j = n2 + 1; j < this.numberOfRows; ++j) {
                for (int k = n2; k < this.numberOfColumns; ++k) {
                    double d3 = 1.0;
                    if (this.reducedValues[j][n2] != this.reducedValues[n2][n2]) {
                        d3 = this.reducedValues[j][n2] / this.reducedValues[n2][n2];
                    }
                    dArray4[j][k] = this.reducedValues[j][k] - d3 * this.reducedValues[n2][k];
                    double d4 = this.reducedErrors[j][k] + this.reducedErrors[n2][k] * d3 * d3;
                    double d5 = 1.0;
                    if (this.reducedValues[n2][k] != this.reducedValues[n2][n2]) {
                        d5 = this.reducedValues[n2][k] / this.reducedValues[n2][n2];
                    }
                    dArray5[j][k] = (d4 += this.reducedErrors[j][n2] * d5 * d5) + this.reducedErrors[n2][n2] * d3 * d3 * d5 * d5;
                }
            }
            matrix4 = new Matrix(dArray4);
            matrix5 = new Matrix(dArray5);
            this.reducedValues = matrix4.getArrayCopy();
            this.reducedErrors = matrix5.getArrayCopy();
        }
        for (n2 = 0; n2 < this.numberOfRows; ++n2) {
            for (n = 0; n < this.numberOfColumns; ++n) {
                this.reducedErrors[n2][n] = Math.sqrt(this.reducedErrors[n2][n]);
            }
        }
        for (n2 = 1; n2 < this.diagonalLength; ++n2) {
            for (n = 0; n < n2; ++n) {
                this.reducedValues[n2][n] = 0.0;
                this.reducedErrors[n2][n] = 0.0;
            }
        }
        if (this.diagonalLength < this.numberOfRows) {
            for (n2 = this.diagonalLength; n2 < this.numberOfRows; ++n2) {
                for (n = 0; n < this.numberOfColumns; ++n) {
                    this.reducedValues[n2][n] = 0.0;
                    this.reducedErrors[n2][n] = 0.0;
                }
            }
        }
        this.reducedValuesDiagonal = new double[this.diagonalLength];
        this.reducedErrorsDiagonal = new double[this.diagonalLength];
        this.reducedValueOverError = new double[this.diagonalLength];
        this.probabilityValues = new double[this.diagonalLength];
        this.mcMullen = new double[this.numberOfRows];
        for (n2 = 0; n2 < this.diagonalLength; ++n2) {
            this.reducedValuesDiagonal[n2] = this.reducedValues[n2][n2];
            this.reducedErrorsDiagonal[n2] = this.reducedErrors[n2][n2];
            this.reducedValueOverError[n2] = Math.abs(this.reducedValuesDiagonal[n2] / this.reducedErrorsDiagonal[n2]);
            this.probabilityValues[n2] = 1.0 - Stat.gaussianCDF(0.0, 1.0, -this.reducedValueOverError[n2], this.reducedValueOverError[n2]);
        }
        for (n2 = 0; n2 < this.numberOfRows; ++n2) {
            double d = 0.0;
            for (int j = n2; j < this.numberOfColumns; ++j) {
                d += this.reducedValues[n2][j] * this.reducedValues[n2][j];
            }
            this.mcMullen[n2] = Math.sqrt(d) / (double)(this.numberOfColumns - n2);
        }
        this.rankAnalysisDone = true;
    }

    public void analysis() {
        this.analysis("RankAnalysisOutput.txt");
    }

    public void analysis(String string) {
        int n;
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        if ((n = string.indexOf(".")) == -1) {
            string = string + ".txt";
        }
        FileOutput fileOutput = new FileOutput(string);
        fileOutput.println("Rank Analysis");
        fileOutput.println("File name:   " + string);
        Date date = new Date();
        String string2 = DateFormat.getDateInstance().format(date);
        String string3 = DateFormat.getTimeInstance().format(date);
        fileOutput.println("Program executed at " + string3 + " on " + string2);
        fileOutput.println();
        fileOutput.println("Number of rows    " + this.numberOfRows);
        fileOutput.println("Number of columns " + this.numberOfColumns);
        if (this.numberOfMissingErrors > 0) {
            fileOutput.println("Number of substituted missing errors" + this.numberOfMissingErrors);
            if (this.rowOption) {
                fileOutput.println("Row means used as the substituted value/s");
            } else {
                fileOutput.println("Column means used as the substituted value/s");
            }
        }
        fileOutput.println();
        switch (this.errorType) {
            case 0: {
                fileOutput.println("Matrix of individual errors supplied");
                break;
            }
            case 1: {
                fileOutput.println("Common error for all elements in each each row supplied");
                break;
            }
            case 2: {
                fileOutput.println("Single common error for all elements in the matrix supplied");
                break;
            }
            case 3: {
                fileOutput.println("No errors supplied - estimate of the rounding errors used");
            }
        }
        fileOutput.println();
        int n2 = 30;
        int n3 = 15;
        int n4 = 4;
        if (this.errorType != 3) {
            fileOutput.print("Reduced", n3);
            fileOutput.print("Reduced", n3);
            fileOutput.print("V/E Ratio", n3);
            fileOutput.print("P-value", n3);
            fileOutput.println("McMullen");
            fileOutput.print("Value", n3);
            fileOutput.print("Error", n3);
            fileOutput.print("    ", n3);
            fileOutput.print("    ", n3);
            fileOutput.println("rms");
            fileOutput.print("Diagonal (V)", n3);
            fileOutput.print("Diagonal (E)", n3);
            fileOutput.print("   ", n3);
            fileOutput.print("   ", n3);
            fileOutput.println("   ");
        } else {
            fileOutput.print("Reduced", n3);
            fileOutput.print("Reduced", n3);
            fileOutput.print("V/E Ratio", n3);
            fileOutput.print("P-value", n3);
            fileOutput.println("McMullen");
            fileOutput.print("Value", n3);
            fileOutput.print("Estimated", n3);
            fileOutput.print("    ", n3);
            fileOutput.print("    ", n3);
            fileOutput.println("rms");
            fileOutput.print("Diagonal (V)", n3);
            fileOutput.print("Rounding", n3);
            fileOutput.print("   ", n3);
            fileOutput.print("   ", n3);
            fileOutput.println("   ");
            fileOutput.print("   ", n3);
            fileOutput.print("Error (E)", n3);
            fileOutput.print("   ", n3);
            fileOutput.print("   ", n3);
            fileOutput.println("   ");
        }
        for (int j = 0; j < this.diagonalLength; ++j) {
            fileOutput.print(Fmath.truncate(this.reducedValuesDiagonal[j], n4), n3);
            fileOutput.print(Fmath.truncate(this.reducedErrorsDiagonal[j], n4), n3);
            fileOutput.print(Fmath.truncate(this.reducedValueOverError[j], n4), n3);
            fileOutput.print(Fmath.truncate(this.probabilityValues[j], n4), n3);
            fileOutput.println(Fmath.truncate(this.mcMullen[j], n4));
        }
        System.out.println("Analysis written to text file " + string);
        fileOutput.close();
    }

    public double[][] originalValues() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.values;
    }

    public double[][] originalErrors() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.errors;
    }

    public double[][] reducedValues() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.reducedValues;
    }

    public double[][] reducedErrors() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.reducedErrors;
    }

    public double[] reducedValuesDiagonal() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.reducedValuesDiagonal;
    }

    public double[] reducedErrorsDiagonal() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.reducedErrorsDiagonal;
    }

    public double[] reducedRatiosDiagonal() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.reducedValueOverError;
    }

    public double[] probabilityValues() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.probabilityValues;
    }

    public double[] mcMullenValues() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.mcMullen;
    }

    public int nRows() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.numberOfRows;
    }

    public int nColumns() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.numberOfColumns;
    }

    public int nDiagonalElements() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.diagonalLength;
    }
}

