/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.BetaFunction;
import flanagan.analysis.EC50FixedFunction;
import flanagan.analysis.EC50FixedFunctionDual;
import flanagan.analysis.EC50Function;
import flanagan.analysis.EC50FunctionDual;
import flanagan.analysis.ErlangFunction;
import flanagan.analysis.ErrorProp;
import flanagan.analysis.ExponentialFunction;
import flanagan.analysis.ExponentialMultipleFunction;
import flanagan.analysis.ExponentialSimpleFunction;
import flanagan.analysis.FrechetFunctionOne;
import flanagan.analysis.FrechetFunctionTwo;
import flanagan.analysis.GammaFunction;
import flanagan.analysis.GaussianFunction;
import flanagan.analysis.GaussianFunctionFixed;
import flanagan.analysis.GumbelFunction;
import flanagan.analysis.LinearGXYDEfunction;
import flanagan.analysis.LinearIXYDEfunction;
import flanagan.analysis.LinearXYDEfunction;
import flanagan.analysis.LogNormalThreeParFunction;
import flanagan.analysis.LogNormalTwoParFunction;
import flanagan.analysis.Logistic5FixedFunction;
import flanagan.analysis.Logistic5FixedFunctionDual;
import flanagan.analysis.Logistic5Function;
import flanagan.analysis.Logistic5FunctionDual;
import flanagan.analysis.LogisticFunction;
import flanagan.analysis.LorentzianFunction;
import flanagan.analysis.MultipleGaussianFunction;
import flanagan.analysis.NonIntegerPolyFunction;
import flanagan.analysis.NonIntegerPolyFunctionDual;
import flanagan.analysis.Normality;
import flanagan.analysis.OneMinusExponentialFunction;
import flanagan.analysis.ParetoFunctionOne;
import flanagan.analysis.ParetoFunctionTwo;
import flanagan.analysis.PoissonFunction;
import flanagan.analysis.PolyIXYDEfunction;
import flanagan.analysis.PolyXYDEfunction;
import flanagan.analysis.RayleighFunctionOne;
import flanagan.analysis.RayleighFunctionTwo;
import flanagan.analysis.RectangularHyperbolaFunction;
import flanagan.analysis.RectangularHyperbolaFunctionDual;
import flanagan.analysis.RegressionDerivativeFunction;
import flanagan.analysis.RegressionDerivativeFunction2;
import flanagan.analysis.RegressionFunction;
import flanagan.analysis.RegressionFunction2;
import flanagan.analysis.RegressionFunction3;
import flanagan.analysis.ShiftedRectangularHyperbolaFunction;
import flanagan.analysis.ShiftedRectangularHyperbolaFunctionDual;
import flanagan.analysis.SigmoidHillSipsFunction;
import flanagan.analysis.SigmoidHillSipsFunctionDual;
import flanagan.analysis.SigmoidThresholdFunction;
import flanagan.analysis.SigmoidThresholdFunctionDual;
import flanagan.analysis.Stat;
import flanagan.analysis.StepFunctionFunction;
import flanagan.analysis.WeibullFunctionOne;
import flanagan.analysis.WeibullFunctionTwo;
import flanagan.interpolation.CubicSpline;
import flanagan.io.Db;
import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Matrix;
import flanagan.plot.PlotGraph;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class Regression {
    protected int nData0 = 0;
    protected int nData = 0;
    protected double nEffective = 0.0;
    protected int nXarrays = 1;
    protected int nYarrays = 1;
    protected int nParam = 0;
    protected int degreesOfFreedom = 0;
    protected double[][] xData = null;
    protected double[][] xErrors = null;
    protected boolean xErrorsEntered = false;
    protected double[] yData = null;
    protected double[] yErrors = null;
    protected boolean yErrorsEntered = false;
    protected boolean dualErrorsRequired = false;
    protected boolean trueErrors = true;
    protected double[] weight = null;
    protected double[] yCalc = null;
    protected double[] residual = null;
    protected double[] residualW = null;
    protected boolean weightOpt = false;
    protected int weightFlag = 0;
    protected String[] weightWord = new String[]{"", "Weighted "};
    protected double[] best = null;
    protected double[] bestSd = null;
    protected double[] pseudoSd = null;
    protected double[] tValues = null;
    protected double[] pValues = null;
    protected double fixedInterceptL = 0.0;
    protected double fixedInterceptP = 0.0;
    protected double yMean = Double.NaN;
    protected double yWeightedMean = Double.NaN;
    protected double chiSquare = Double.NaN;
    protected double reducedChiSquare = Double.NaN;
    protected double sumOfSquaresError = Double.NaN;
    protected double sumOfSquaresTotal = Double.NaN;
    protected double sumOfSquaresRegrn = Double.NaN;
    protected double lastSSnoConstraint = 0.0;
    protected double[][] covar = null;
    protected double[][] corrCoeff = null;
    protected double xyR = Double.NaN;
    protected double yyR = Double.NaN;
    protected double multR = Double.NaN;
    protected double adjustedR = Double.NaN;
    protected double multipleF = Double.NaN;
    protected double multipleFprob = Double.NaN;
    protected String[] paraName = null;
    protected int prec = 4;
    protected int field = 13;
    protected int simplexFlag = 1;
    protected int derivFlag = 1;
    protected boolean nonLinStatsNeeded = true;
    protected int lastMethod = -1;
    protected int[] dualMethods = new int[]{19, 20, 21, 25, 26, 28, 39, 40, 41, 42, 43, 44, 45, 50, 51, 52};
    protected int nSpecDual = this.dualMethods.length;
    protected boolean bestPolyFlag = false;
    protected int bestPolynomialDegree = 0;
    protected double fProbSignificance = 0.05;
    protected ArrayList<Object> bestPolyArray = new ArrayList();
    protected boolean userSupplied = true;
    protected double kayValue = 0.0;
    protected boolean frechetWeibull = true;
    protected boolean linNonLin = true;
    protected boolean trueFreq = false;
    protected String xLegend = "x axis values";
    protected String yLegend = "y axis values";
    protected String graphTitle = " ";
    protected String graphTitle2 = " ";
    protected boolean legendCheck = false;
    protected boolean suppressPrint = false;
    protected boolean suppressYYplot = false;
    protected boolean suppressErrorMessages = false;
    protected boolean nlrStatus = true;
    protected int scaleOpt = 0;
    protected double[] scale = null;
    protected boolean zeroCheck = false;
    protected boolean penalty = false;
    protected boolean sumPenalty = false;
    protected int nConstraints = 0;
    protected int nSumConstraints = 0;
    protected int maxConstraintIndex = -1;
    protected double constraintTolerance = 1.0E-4;
    protected ArrayList<Object> penalties = new ArrayList();
    protected ArrayList<Object> sumPenalties = new ArrayList();
    protected int[] penaltyCheck = null;
    protected int[] sumPenaltyCheck = null;
    protected double penaltyWeight = 1.0E30;
    protected int[] penaltyParam = null;
    protected int[][] sumPenaltyParam = null;
    protected double[][] sumPlusOrMinus = null;
    protected int[] sumPenaltyNumber = null;
    protected double[] constraints = null;
    protected double[] sumConstraints = null;
    protected int constraintMethod = 0;
    protected ArrayList<Object> constrainedSingle = new ArrayList();
    protected ArrayList<Object> constrainedMultiple = new ArrayList();
    String[] constraintString = null;
    protected boolean scaleFlag = true;
    protected double yScaleFactor = 1.0;
    protected int nMax = 3000;
    protected int minIter = 300;
    protected int nIter = 0;
    protected int konvge = 3;
    protected int kRestart = 0;
    protected double fMin = -1.0;
    protected double fTol = 1.0E-9;
    protected double rCoeff = 1.0;
    protected double eCoeff = 2.0;
    protected double cCoeff = 0.5;
    protected double[] startH = null;
    protected double[] stepH = null;
    protected double[] startSH = null;
    protected double[] stepSH = null;
    protected double dStep = 0.1;
    protected double[][] grad = null;
    protected double delta = 1.0E-4;
    protected boolean invertFlag = true;
    protected boolean posVarFlag = true;
    protected int minTest = 0;
    protected double simplexSd = 0.0;
    protected boolean statFlag = true;
    protected boolean plotOpt = true;
    protected boolean multipleY = false;
    protected boolean ignoreDofFcheck = false;
    protected double[] values = null;
    protected boolean[] fixed = null;
    protected int nGaussians = 0;
    protected double[] multGaussFract = null;
    protected double[] multGaussFractErrors = null;
    protected double[] multGaussCoeffVar = null;
    protected double[] multGaussTvalue = null;
    protected double[] multGaussPvalue = null;
    protected double multGaussScale = 1.0;
    protected double multGaussScaleError = 0.0;
    protected double multGaussScaleCoeffVar = 0.0;
    protected double multGaussScaleTvalue = 0.0;
    protected double multGaussScalePvalue = 0.0;
    protected boolean plotWindowCloseChoice = false;
    protected double minimumY = 0.0;
    protected double minimumYindex = 0.0;
    protected double maximumY = 0.0;
    protected double maximumYindex = 0.0;
    protected double bottom = 0.0;
    protected double top = 0.0;
    protected double bottomS = 0.0;
    protected double bottomSindex = 0.0;
    protected double topS = 0.0;
    protected double topSindex = 0.0;
    protected int midPointLowerIndex = 0;
    protected int midPointUpperIndex = 0;
    protected double midPointXvalue = 0.0;
    protected double midPointYvalue = 0.0;
    protected int directionFlag = 0;
    protected double dDurbinWatson = Double.NaN;
    protected boolean dDurbinWatsonDone = false;
    protected double[][] firstDerivs = null;
    protected boolean analyticalDerivative = false;
    protected double obsnVariance = 0.0;
    protected static double histTol = 1.0001;

    public Regression() {
    }

    public Regression(double[][] dArray, double[] dArray2, double[] dArray3) {
        this.simplexFlag = 1;
        this.nData0 = dArray2.length;
        dArray3 = this.checkForZeroWeights(dArray3);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(Conv.copy(dArray), Conv.copy(dArray2), Conv.copy(dArray3));
    }

    public Regression(double[][] dArray, double[] dArray2, double[][] dArray3, double[] dArray4) {
        this.simplexFlag = 3;
        this.nData0 = dArray2.length;
        this.jointZeroCheck(dArray3, dArray4);
        this.yErrorsEntered = true;
        this.xErrorsEntered = true;
        this.weightOpt = true;
        this.weightFlag = 1;
        this.setDefaultValues(Conv.copy(dArray), Conv.copy(dArray2), Conv.copy(dArray3), Conv.copy(dArray4));
    }

    public Regression(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        int n;
        int n2;
        this.simplexFlag = 2;
        this.multipleY = true;
        this.nYarrays = n2 = dArray2.length;
        this.nData0 = n = dArray2[0].length;
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        double[] dArray4 = new double[n2 * n];
        double[] dArray5 = new double[n2 * n];
        double[][] dArray6 = new double[n2 * n][n3];
        int n5 = 0;
        for (int j = 0; j < n2; ++j) {
            int n6 = dArray2[j].length;
            if (n6 != n) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            int n7 = dArray[j].length;
            if (n6 != n7) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length as the x array length");
            }
            for (int k = 0; k < n; ++k) {
                dArray4[n5] = dArray2[j][k];
                dArray6[n5][j] = dArray[j][k];
                dArray5[n5] = dArray3[j][k];
                ++n5;
            }
        }
        dArray5 = this.checkForZeroWeights(dArray5);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(dArray6, dArray4, dArray5);
    }

    public Regression(double[][] dArray, double[][] dArray2, double[][] dArray3, double[][] dArray4) {
        int n;
        int n2;
        this.simplexFlag = 4;
        this.multipleY = true;
        this.nYarrays = n2 = dArray2.length;
        this.nData0 = n = dArray2[0].length;
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        double[] dArray5 = new double[n2 * n];
        double[] dArray6 = new double[n2 * n];
        double[][] dArray7 = new double[n2 * n][n3];
        double[][] dArray8 = new double[n2 * n][n3];
        int n5 = 0;
        for (int j = 0; j < n2; ++j) {
            int n6 = dArray2[j].length;
            if (n6 != n) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            int n7 = dArray[j].length;
            if (n6 != n7) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length as the x array length");
            }
            for (int k = 0; k < n; ++k) {
                dArray5[n5] = dArray2[j][k];
                dArray7[n5][j] = dArray[j][k];
                dArray6[n5] = dArray4[j][k];
                dArray8[n5][j] = dArray3[j][k];
                ++n5;
            }
        }
        this.jointZeroCheck(dArray8, dArray6);
        this.yErrorsEntered = true;
        this.xErrorsEntered = true;
        this.weightOpt = true;
        this.weightFlag = 1;
        this.setDefaultValues(Conv.copy(dArray7), Conv.copy(dArray5), Conv.copy(dArray8), Conv.copy(dArray6));
        this.setDefaultValues(dArray7, dArray5, dArray6);
    }

    public Regression(double[] dArray, double[] dArray2, double[] dArray3) {
        this.simplexFlag = 1;
        this.nData0 = dArray2.length;
        int n = dArray.length;
        int n2 = dArray3.length;
        double[][] dArray4 = new double[1][n];
        for (int j = 0; j < n; ++j) {
            dArray4[0][j] = dArray[j];
        }
        dArray3 = this.checkForZeroWeights(dArray3);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(Conv.copy(dArray4), Conv.copy(dArray2), Conv.copy(dArray3));
    }

    public Regression(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        this.simplexFlag = 3;
        this.nData0 = dArray2.length;
        int n = dArray.length;
        int n2 = dArray4.length;
        double[][] dArray5 = new double[1][n];
        double[][] dArray6 = new double[1][n];
        for (int j = 0; j < n; ++j) {
            dArray5[0][j] = dArray[j];
            dArray6[0][j] = dArray3[j];
        }
        this.jointZeroCheck(dArray6, dArray4);
        this.xErrorsEntered = true;
        this.yErrorsEntered = true;
        this.weightOpt = true;
        this.weightFlag = 1;
        this.setDefaultValues(Conv.copy(dArray5), Conv.copy(dArray2), Conv.copy(dArray6), Conv.copy(dArray4));
    }

    public Regression(double[] dArray, double[][] dArray2, double[][] dArray3) {
        int n;
        int n2;
        int n3;
        int n4;
        this.simplexFlag = 1;
        this.multipleY = true;
        this.nYarrays = n4 = dArray2.length;
        this.nData0 = n3 = dArray2[0].length;
        double[] dArray4 = new double[n4 * n3];
        double[] dArray5 = new double[n4 * n3];
        int n5 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            int n6 = dArray2[n2].length;
            if (n6 != n3) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            for (n = 0; n < n3; ++n) {
                dArray4[n5] = dArray2[n2][n];
                dArray5[n5] = dArray3[n2][n];
                ++n5;
            }
        }
        n2 = dArray.length;
        if (n2 != n3) {
            throw new IllegalArgumentException("x and y data lengths must be the same");
        }
        double[][] dArray6 = new double[1][n4 * n2];
        n5 = 0;
        for (n = 0; n < n4; ++n) {
            for (int j = 0; j < n2; ++j) {
                dArray6[0][n5] = dArray[j];
                ++n5;
            }
        }
        dArray5 = this.checkForZeroWeights(dArray5);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(dArray6, dArray4, dArray5);
    }

    public Regression(double[] dArray, double[][] dArray2, double[] dArray3, double[][] dArray4) {
        int n;
        int n2;
        int n3;
        this.simplexFlag = 4;
        this.multipleY = true;
        this.nYarrays = n3 = dArray2.length;
        this.nData0 = n2 = dArray2[0].length;
        double[] dArray5 = new double[n3 * n2];
        double[] dArray6 = new double[n3 * n2];
        int n4 = 0;
        for (n = 0; n < n3; ++n) {
            int n5 = dArray2[n].length;
            if (n5 != n2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            for (int j = 0; j < n2; ++j) {
                dArray5[n4] = dArray2[n][j];
                dArray6[n4] = dArray4[n][j];
                ++n4;
            }
        }
        n = dArray.length;
        if (n != n2) {
            throw new IllegalArgumentException("x and y data lengths must be the same");
        }
        double[][] dArray7 = new double[1][n3 * n];
        double[][] dArray8 = new double[1][n3 * n];
        n4 = 0;
        for (int j = 0; j < n3; ++j) {
            for (int k = 0; k < n; ++k) {
                dArray7[0][n4] = dArray[k];
                dArray8[0][n4] = dArray3[k];
                ++n4;
            }
        }
        this.jointZeroCheck(dArray8, dArray6);
        this.xErrorsEntered = true;
        this.yErrorsEntered = true;
        this.weightOpt = true;
        this.weightFlag = 1;
        this.setDefaultValues(Conv.copy(dArray7), Conv.copy(dArray5), Conv.copy(dArray8), Conv.copy(dArray6));
    }

    public Regression(double[][] dArray, double[] dArray2) {
        this.nData0 = dArray2.length;
        int n = dArray2.length;
        double[] dArray3 = new double[n];
        this.weightOpt = false;
        this.weightFlag = 0;
        for (int j = 0; j < n; ++j) {
            dArray3[j] = 1.0;
        }
        this.setDefaultValues(Conv.copy(dArray), Conv.copy(dArray2), dArray3);
    }

    public Regression(double[][] dArray, double[][] dArray2) {
        int n;
        int n2;
        int n3;
        int n4;
        this.multipleY = true;
        this.simplexFlag = 2;
        this.nYarrays = n4 = dArray2.length;
        this.nData0 = n3 = dArray2[0].length;
        int n5 = dArray.length;
        double[] dArray3 = new double[n4 * n3];
        if (n4 != n5) {
            throw new IllegalArgumentException("Multiple xData and yData arrays of different overall dimensions not supported");
        }
        double[][] dArray4 = new double[1][n4 * n3];
        int n6 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            int n7 = dArray2[n2].length;
            if (n7 != n3) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            n = dArray[n2].length;
            if (n7 != n) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length as the x array length");
            }
            for (int j = 0; j < n3; ++j) {
                dArray3[n6] = dArray2[n2][j];
                dArray4[0][n6] = dArray[n2][j];
                ++n6;
            }
        }
        n2 = dArray3.length;
        double[] dArray5 = new double[n2];
        this.weightOpt = false;
        for (n = 0; n < n2; ++n) {
            dArray5[n] = 1.0;
        }
        this.weightFlag = 0;
        this.setDefaultValues(dArray4, dArray3, dArray5);
    }

    public Regression(double[] dArray, double[] dArray2) {
        int n;
        this.simplexFlag = 1;
        this.nData0 = dArray2.length;
        int n2 = dArray.length;
        double[][] dArray3 = new double[1][n2];
        double[] dArray4 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray3[0][n] = dArray[n];
        }
        this.weightOpt = false;
        this.weightFlag = 0;
        for (n = 0; n < n2; ++n) {
            dArray4[n] = 1.0;
        }
        this.setDefaultValues(dArray3, Conv.copy(dArray2), dArray4);
    }

    public Regression(double[] dArray, double[][] dArray2) {
        int n;
        int n2;
        int n3;
        this.multipleY = true;
        this.simplexFlag = 2;
        this.nYarrays = n3 = dArray2.length;
        this.nData0 = n2 = dArray2[0].length;
        double[] dArray3 = new double[n3 * n2];
        int n4 = 0;
        for (int j = 0; j < n3; ++j) {
            int n5 = dArray2[j].length;
            if (n5 != n2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            for (n = 0; n < n2; ++n) {
                dArray3[n4] = dArray2[j][n];
                ++n4;
            }
        }
        double[][] dArray4 = new double[1][n3 * n2];
        double[] dArray5 = new double[n3 * n2];
        n4 = 0;
        n = dArray.length;
        for (int j = 0; j < n3; ++j) {
            for (int k = 0; k < n; ++k) {
                dArray4[0][n4] = dArray[k];
                dArray5[n4] = 1.0;
                ++n4;
            }
        }
        this.weightOpt = false;
        this.weightFlag = 0;
        this.setDefaultValues(dArray4, dArray3, dArray5);
    }

    public Regression(double[] dArray, double d, double d2) {
        int n;
        int n2;
        this.simplexFlag = 1;
        double[][] dArray2 = Regression.histogramBins(Conv.copy(dArray), d, d2);
        this.nData0 = n2 = dArray2[0].length;
        double[][] dArray3 = new double[1][n2];
        double[] dArray4 = new double[n2];
        double[] dArray5 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray3[0][n] = dArray2[0][n];
            dArray4[n] = dArray2[1][n];
        }
        n = Regression.setTrueFreqWeights(dArray4, dArray5) ? 1 : 0;
        if (n != 0) {
            this.trueFreq = true;
            this.weightOpt = true;
            this.weightFlag = 1;
        } else {
            this.trueFreq = false;
            this.weightOpt = false;
            this.weightFlag = 0;
        }
        this.setDefaultValues(dArray3, dArray4, dArray5);
    }

    public Regression(double[] dArray, double d) {
        int n;
        int n2;
        this.simplexFlag = 1;
        double[][] dArray2 = Regression.histogramBins(Conv.copy(dArray), d);
        this.nData0 = n2 = dArray2[0].length;
        double[][] dArray3 = new double[1][n2];
        double[] dArray4 = new double[n2];
        double[] dArray5 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray3[0][n] = dArray2[0][n];
            dArray4[n] = dArray2[1][n];
        }
        n = Regression.setTrueFreqWeights(dArray4, dArray5) ? 1 : 0;
        if (n != 0) {
            this.trueFreq = true;
            this.weightOpt = true;
            this.weightFlag = 1;
        } else {
            this.trueFreq = false;
            this.weightOpt = false;
            this.weightFlag = 0;
        }
        this.setDefaultValues(dArray3, dArray4, dArray5);
    }

    public void enterData(double[][] dArray, double[] dArray2, double[] dArray3) {
        this.simplexFlag = 1;
        this.nData0 = dArray2.length;
        dArray3 = this.checkForZeroWeights(dArray3);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(Conv.copy(dArray), Conv.copy(dArray2), Conv.copy(dArray3));
    }

    public void enterData(double[][] dArray, double[] dArray2, double[][] dArray3, double[] dArray4) {
        this.simplexFlag = 3;
        this.nData0 = dArray2.length;
        this.jointZeroCheck(dArray3, dArray4);
        this.yErrorsEntered = true;
        this.xErrorsEntered = true;
        this.weightOpt = true;
        this.weightFlag = 1;
        this.setDefaultValues(Conv.copy(dArray), Conv.copy(dArray2), Conv.copy(dArray3), Conv.copy(dArray4));
    }

    public void enterData(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        int n;
        int n2;
        this.simplexFlag = 2;
        this.multipleY = true;
        this.nYarrays = n2 = dArray2.length;
        this.nData0 = n = dArray2[0].length;
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        double[] dArray4 = new double[n2 * n];
        double[] dArray5 = new double[n2 * n];
        double[][] dArray6 = new double[n2 * n][n3];
        int n5 = 0;
        for (int j = 0; j < n2; ++j) {
            int n6 = dArray2[j].length;
            if (n6 != n) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            int n7 = dArray[j].length;
            if (n6 != n7) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length as the x array length");
            }
            for (int k = 0; k < n; ++k) {
                dArray4[n5] = dArray2[j][k];
                dArray6[n5][j] = dArray[j][k];
                dArray5[n5] = dArray3[j][k];
                ++n5;
            }
        }
        dArray5 = this.checkForZeroWeights(dArray5);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(dArray6, dArray4, dArray5);
    }

    public void enterData(double[][] dArray, double[][] dArray2, double[][] dArray3, double[][] dArray4) {
        int n;
        int n2;
        this.simplexFlag = 4;
        this.multipleY = true;
        this.nYarrays = n2 = dArray2.length;
        this.nData0 = n = dArray2[0].length;
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        double[] dArray5 = new double[n2 * n];
        double[] dArray6 = new double[n2 * n];
        double[][] dArray7 = new double[n2 * n][n3];
        double[][] dArray8 = new double[n2 * n][n3];
        int n5 = 0;
        for (int j = 0; j < n2; ++j) {
            int n6 = dArray2[j].length;
            if (n6 != n) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            int n7 = dArray[j].length;
            if (n6 != n7) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length as the x array length");
            }
            for (int k = 0; k < n; ++k) {
                dArray5[n5] = dArray2[j][k];
                dArray7[n5][j] = dArray[j][k];
                dArray6[n5] = dArray4[j][k];
                dArray8[n5][j] = dArray3[j][k];
                ++n5;
            }
        }
        this.jointZeroCheck(dArray8, dArray6);
        this.yErrorsEntered = true;
        this.xErrorsEntered = true;
        this.weightOpt = true;
        this.weightFlag = 1;
        this.setDefaultValues(Conv.copy(dArray7), Conv.copy(dArray5), Conv.copy(dArray8), Conv.copy(dArray6));
        this.setDefaultValues(dArray7, dArray5, dArray6);
    }

    public void enterData(double[] dArray, double[] dArray2, double[] dArray3) {
        this.simplexFlag = 1;
        this.nData0 = dArray2.length;
        int n = dArray.length;
        int n2 = dArray3.length;
        double[][] dArray4 = new double[1][n];
        for (int j = 0; j < n; ++j) {
            dArray4[0][j] = dArray[j];
        }
        dArray3 = this.checkForZeroWeights(dArray3);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(Conv.copy(dArray4), Conv.copy(dArray2), Conv.copy(dArray3));
    }

    public void enterData(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        this.simplexFlag = 3;
        this.nData0 = dArray2.length;
        int n = dArray.length;
        int n2 = dArray4.length;
        double[][] dArray5 = new double[1][n];
        double[][] dArray6 = new double[1][n];
        for (int j = 0; j < n; ++j) {
            dArray5[0][j] = dArray[j];
            dArray6[0][j] = dArray3[j];
        }
        this.jointZeroCheck(dArray6, dArray4);
        this.xErrorsEntered = true;
        this.yErrorsEntered = true;
        this.weightOpt = true;
        this.weightFlag = 1;
        this.setDefaultValues(Conv.copy(dArray5), Conv.copy(dArray2), Conv.copy(dArray6), Conv.copy(dArray4));
    }

    public void enterData(double[] dArray, double[][] dArray2, double[][] dArray3) {
        int n;
        int n2;
        int n3;
        int n4;
        this.simplexFlag = 1;
        this.multipleY = true;
        this.nYarrays = n4 = dArray2.length;
        this.nData0 = n3 = dArray2[0].length;
        double[] dArray4 = new double[n4 * n3];
        double[] dArray5 = new double[n4 * n3];
        int n5 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            int n6 = dArray2[n2].length;
            if (n6 != n3) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            for (n = 0; n < n3; ++n) {
                dArray4[n5] = dArray2[n2][n];
                dArray5[n5] = dArray3[n2][n];
                ++n5;
            }
        }
        n2 = dArray.length;
        if (n2 != n3) {
            throw new IllegalArgumentException("x and y data lengths must be the same");
        }
        double[][] dArray6 = new double[1][n4 * n2];
        n5 = 0;
        for (n = 0; n < n4; ++n) {
            for (int j = 0; j < n2; ++j) {
                dArray6[0][n5] = dArray[j];
                ++n5;
            }
        }
        dArray5 = this.checkForZeroWeights(dArray5);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(dArray6, dArray4, dArray5);
    }

    public void enterData(double[] dArray, double[][] dArray2, double[] dArray3, double[][] dArray4) {
        int n;
        int n2;
        int n3;
        this.simplexFlag = 4;
        this.multipleY = true;
        this.nYarrays = n3 = dArray2.length;
        this.nData0 = n2 = dArray2[0].length;
        double[] dArray5 = new double[n3 * n2];
        double[] dArray6 = new double[n3 * n2];
        int n4 = 0;
        for (n = 0; n < n3; ++n) {
            int n5 = dArray2[n].length;
            if (n5 != n2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            for (int j = 0; j < n2; ++j) {
                dArray5[n4] = dArray2[n][j];
                dArray6[n4] = dArray4[n][j];
                ++n4;
            }
        }
        n = dArray.length;
        if (n != n2) {
            throw new IllegalArgumentException("x and y data lengths must be the same");
        }
        double[][] dArray7 = new double[1][n3 * n];
        double[][] dArray8 = new double[1][n3 * n];
        n4 = 0;
        for (int j = 0; j < n3; ++j) {
            for (int k = 0; k < n; ++k) {
                dArray7[0][n4] = dArray[k];
                dArray8[0][n4] = dArray3[k];
                ++n4;
            }
        }
        this.jointZeroCheck(dArray8, dArray6);
        this.xErrorsEntered = true;
        this.yErrorsEntered = true;
        this.weightOpt = true;
        this.weightFlag = 1;
        this.setDefaultValues(Conv.copy(dArray7), Conv.copy(dArray5), Conv.copy(dArray8), Conv.copy(dArray6));
    }

    public void enterData(double[][] dArray, double[] dArray2) {
        this.nData0 = dArray2.length;
        int n = dArray2.length;
        double[] dArray3 = new double[n];
        this.weightOpt = false;
        this.weightFlag = 0;
        for (int j = 0; j < n; ++j) {
            dArray3[j] = 1.0;
        }
        this.setDefaultValues(Conv.copy(dArray), Conv.copy(dArray2), dArray3);
    }

    public void enterData(double[][] dArray, double[][] dArray2) {
        int n;
        int n2;
        int n3;
        int n4;
        this.multipleY = true;
        this.simplexFlag = 2;
        this.nYarrays = n4 = dArray2.length;
        this.nData0 = n3 = dArray2[0].length;
        int n5 = dArray.length;
        double[] dArray3 = new double[n4 * n3];
        if (n4 != n5) {
            throw new IllegalArgumentException("Multiple xData and yData arrays of different overall dimensions not supported");
        }
        double[][] dArray4 = new double[1][n4 * n3];
        int n6 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            int n7 = dArray2[n2].length;
            if (n7 != n3) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            n = dArray[n2].length;
            if (n7 != n) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length as the x array length");
            }
            for (int j = 0; j < n3; ++j) {
                dArray3[n6] = dArray2[n2][j];
                dArray4[0][n6] = dArray[n2][j];
                ++n6;
            }
        }
        n2 = dArray3.length;
        double[] dArray5 = new double[n2];
        this.weightOpt = false;
        for (n = 0; n < n2; ++n) {
            dArray5[n] = 1.0;
        }
        this.weightFlag = 0;
        this.setDefaultValues(dArray4, dArray3, dArray5);
    }

    public void enterData(double[] dArray, double[] dArray2) {
        int n;
        this.simplexFlag = 1;
        this.nData0 = dArray2.length;
        int n2 = dArray.length;
        double[][] dArray3 = new double[1][n2];
        double[] dArray4 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray3[0][n] = dArray[n];
        }
        this.weightOpt = false;
        this.weightFlag = 0;
        for (n = 0; n < n2; ++n) {
            dArray4[n] = 1.0;
        }
        this.setDefaultValues(dArray3, Conv.copy(dArray2), dArray4);
    }

    public void enterData(double[] dArray, double[][] dArray2) {
        int n;
        int n2;
        int n3;
        this.multipleY = true;
        this.simplexFlag = 2;
        this.nYarrays = n3 = dArray2.length;
        this.nData0 = n2 = dArray2[0].length;
        double[] dArray3 = new double[n3 * n2];
        int n4 = 0;
        for (int j = 0; j < n3; ++j) {
            int n5 = dArray2[j].length;
            if (n5 != n2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            for (n = 0; n < n2; ++n) {
                dArray3[n4] = dArray2[j][n];
                ++n4;
            }
        }
        double[][] dArray4 = new double[1][n3 * n2];
        double[] dArray5 = new double[n3 * n2];
        n4 = 0;
        n = dArray.length;
        for (int j = 0; j < n3; ++j) {
            for (int k = 0; k < n; ++k) {
                dArray4[0][n4] = dArray[k];
                dArray5[n4] = 1.0;
                ++n4;
            }
        }
        this.weightOpt = false;
        this.weightFlag = 0;
        this.setDefaultValues(dArray4, dArray3, dArray5);
    }

    public void enterData(double[] dArray, double d, double d2) {
        int n;
        int n2;
        this.simplexFlag = 1;
        double[][] dArray2 = Regression.histogramBins(Conv.copy(dArray), d, d2);
        this.nData0 = n2 = dArray2[0].length;
        double[][] dArray3 = new double[1][n2];
        double[] dArray4 = new double[n2];
        double[] dArray5 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray3[0][n] = dArray2[0][n];
            dArray4[n] = dArray2[1][n];
        }
        n = Regression.setTrueFreqWeights(dArray4, dArray5) ? 1 : 0;
        if (n != 0) {
            this.trueFreq = true;
            this.weightOpt = true;
            this.weightFlag = 1;
        } else {
            this.trueFreq = false;
            this.weightOpt = false;
            this.weightFlag = 0;
        }
        this.setDefaultValues(dArray3, dArray4, dArray5);
    }

    public void enterData(double[] dArray, double d) {
        int n;
        int n2;
        this.simplexFlag = 1;
        double[][] dArray2 = Regression.histogramBins(Conv.copy(dArray), d);
        this.nData0 = n2 = dArray2[0].length;
        double[][] dArray3 = new double[1][n2];
        double[] dArray4 = new double[n2];
        double[] dArray5 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray3[0][n] = dArray2[0][n];
            dArray4[n] = dArray2[1][n];
        }
        n = Regression.setTrueFreqWeights(dArray4, dArray5) ? 1 : 0;
        if (n != 0) {
            this.trueFreq = true;
            this.weightOpt = true;
            this.weightFlag = 1;
        } else {
            this.trueFreq = false;
            this.weightOpt = false;
            this.weightFlag = 0;
        }
        this.setDefaultValues(dArray3, dArray4, dArray5);
    }

    protected double[] checkForZeroWeights(double[] dArray) {
        int n = 1;
        boolean bl = this.weightOpt;
        this.weightOpt = false;
        dArray = this.checkForZeroWeightsCommon(dArray, dArray.length, 0, n);
        if (this.weightOpt) {
            this.yErrorsEntered = true;
        }
        if (bl) {
            this.weightOpt = true;
        }
        return dArray;
    }

    protected double[] checkForZeroWeightsCommon(double[] dArray, int n, int n2, int n3) {
        this.weightOpt = true;
        int n4 = 0;
        int n5 = dArray.length;
        for (int j = 0; j < n5; ++j) {
            if (!(dArray[j] <= 0.0)) continue;
            ++n4;
        }
        double d = 100.0 * (double)n4 / (double)n5;
        if (d > 40.0) {
            System.out.println(d + "% of the weighting errors are zero or less; all weighting errors set to 1.0");
            for (int j = 0; j < n5; ++j) {
                dArray[j] = 1.0;
            }
            this.weightOpt = false;
        } else if (d > 0.0) {
            for (int j = 0; j < n5; ++j) {
                double d2;
                boolean bl;
                int n6;
                if (!(dArray[j] <= 0.0)) continue;
                if (j == 0) {
                    n6 = 1;
                    bl = true;
                    while (bl) {
                        if (dArray[n6] > 0.0) {
                            d2 = dArray[0];
                            dArray[0] = dArray[n6];
                            if (n3 == 1) {
                                System.out.println("y error at point " + j + ", " + d2 + ", replaced by " + dArray[j]);
                            } else {
                                System.out.println("x error at point " + j / n2 + "," + j % n2 + " " + d2 + " replaced by " + dArray[j]);
                            }
                            bl = false;
                            continue;
                        }
                        ++n6;
                    }
                }
                if (j == n5 - 1) {
                    n6 = n5 - 2;
                    bl = true;
                    while (bl) {
                        if (dArray[n6] > 0.0) {
                            d2 = dArray[j];
                            dArray[j] = dArray[n6];
                            if (n3 == 1) {
                                System.out.println("y error at point " + j + ", " + d2 + ", replaced by " + dArray[j]);
                            } else {
                                System.out.println("x error at point " + j / n2 + "," + j % n2 + " " + d2 + " replaced by " + dArray[j]);
                            }
                            bl = false;
                            continue;
                        }
                        --n6;
                    }
                }
                if (j <= 0 || j >= n5 - 2) continue;
                double d3 = 0.0;
                d2 = 0.0;
                int n7 = j - 1;
                boolean bl2 = true;
                while (bl2) {
                    if (dArray[n7] > 0.0) {
                        d3 = dArray[n7];
                        bl2 = false;
                        continue;
                    }
                    if (--n7 != 0) continue;
                    bl2 = false;
                }
                n7 = j + 1;
                bl2 = true;
                while (bl2) {
                    if (dArray[n7] > 0.0) {
                        d2 = dArray[n7];
                        bl2 = false;
                        continue;
                    }
                    if (++n7 != n5 - 1) continue;
                    bl2 = false;
                }
                double d4 = dArray[j];
                dArray[j] = d3 == 0.0 ? d2 : (d2 == 0.0 ? d3 : (d3 + d2) / 2.0);
                if (n3 == 1) {
                    System.out.println("y error at point " + j + ", " + d4 + ", replaced by " + dArray[j]);
                    continue;
                }
                System.out.println("x error at point " + j / n2 + "," + j % n2 + " " + d4 + " replaced by " + dArray[j]);
            }
        }
        return dArray;
    }

    protected void jointZeroCheck(double[][] dArray, double[] dArray2) {
        int n = dArray[0].length;
        int n2 = dArray2.length;
        int n3 = dArray.length;
        int n4 = 0;
        if (n2 != n) {
            throw new IllegalArgumentException("The number of x weightimg errors, " + n + ", does not match the number of y weighting errors. " + n2);
        }
        for (int j = 0; j < n; ++j) {
            n4 = 0;
            if (dArray2[j] == 0.0) {
                ++n4;
            }
            for (int k = 0; k < n3; ++k) {
                if (dArray[k][j] != 0.0) continue;
                ++n4;
            }
            if (n4 != n3 + 1) continue;
            throw new IllegalArgumentException("Data point, index, " + j + ", has zero x and zero y weighting error values");
        }
    }

    protected static boolean setTrueFreqWeights(double[] dArray, double[] dArray2) {
        int n;
        int n2 = dArray.length;
        boolean bl = true;
        boolean bl2 = false;
        for (n = 0; n < n2; ++n) {
            dArray2[n] = Math.sqrt(Math.abs(dArray[n]));
        }
        for (n = 0; n < n2; ++n) {
            double d = 0.0;
            double d2 = 0.0;
            if (dArray2[n] != 0.0) continue;
            boolean bl3 = true;
            int n3 = n - 1;
            while (bl3) {
                if (n3 < 0) {
                    bl3 = false;
                    continue;
                }
                if (dArray2[n3] == 0.0) {
                    --n3;
                    continue;
                }
                d = dArray2[n3];
                bl3 = false;
            }
            boolean bl4 = true;
            int n4 = n + 1;
            while (bl4) {
                if (n4 >= n2) {
                    bl4 = false;
                    continue;
                }
                if (dArray2[n4] == 0.0) {
                    ++n4;
                    continue;
                }
                d2 = dArray2[n4];
                bl4 = false;
            }
            dArray2[n] = (d + d2) / 2.0;
        }
        return bl;
    }

    protected void setDefaultValues(double[][] dArray, double[] dArray2, double[] dArray3) {
        this.setDefaultValues(dArray, dArray2, null, dArray3);
    }

    protected void setDefaultValues(double[][] dArray, double[] dArray2, double[][] dArray3, double[] dArray4) {
        int n;
        int n2;
        boolean bl = true;
        if (dArray3 == null) {
            bl = false;
        }
        this.nData = dArray2.length;
        this.nParam = this.nXarrays = dArray.length;
        this.yData = new double[this.nData];
        this.yCalc = new double[this.nData];
        this.yErrors = new double[this.nData];
        this.weight = new double[this.nData];
        this.residual = new double[this.nData];
        this.residualW = new double[this.nData];
        this.xData = new double[this.nXarrays][this.nData];
        if (bl) {
            this.xErrors = new double[this.nXarrays][this.nData];
        }
        if ((n2 = dArray4.length) != this.nData) {
            throw new IllegalArgumentException("The y error and the y data lengths do not agree");
        }
        for (n = 0; n < this.nData; ++n) {
            this.yData[n] = dArray2[n];
            this.yErrors[n] = dArray4[n];
            this.weight[n] = this.yErrors[n];
        }
        for (n = 0; n < this.nXarrays; ++n) {
            int n3;
            n2 = dArray[n].length;
            if (n2 != this.nData) {
                throw new IllegalArgumentException("An x [" + n + "] length " + n2 + " and the y data length, " + this.nData + ", do not agree");
            }
            if (bl && (n3 = dArray3[n].length) != this.nData) {
                throw new IllegalArgumentException("An x error [" + n + "] length " + n2 + " and the y data length, " + this.nData + ", do not agree");
            }
            for (n3 = 0; n3 < this.nData; ++n3) {
                this.xData[n][n3] = dArray[n][n3];
            }
            if (!bl) continue;
            for (n3 = 0; n3 < this.nData; ++n3) {
                this.xErrors[n][n3] = dArray3[n][n3];
            }
        }
        this.minimumY = this.yData[0];
        this.minimumYindex = 0.0;
        this.maximumY = this.yData[0];
        this.maximumYindex = 0.0;
        for (n = 0; n < this.nData; ++n) {
            if (this.yData[n] < this.minimumY) {
                this.minimumY = this.yData[n];
                this.minimumYindex = n;
            }
            if (!(this.yData[n] > this.maximumY)) continue;
            this.maximumY = this.yData[n];
            this.maximumYindex = n;
        }
        this.effectiveNumber();
    }

    public void setErrorsAsSD() {
        this.trueErrors = true;
    }

    public void setErrorsAsScaled() {
        this.trueErrors = false;
    }

    protected void effectiveNumber() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int j = 0; j < this.nData; ++j) {
            d3 = 1.0 / (this.weight[j] * this.weight[j]);
            d += d3;
            d2 += d3 * d3;
        }
        this.nEffective = d * d / d2;
    }

    private void reassessFtol() {
        double d = Math.pow(10.0, Math.floor(Math.log10((this.minimumY + this.maximumY) / 2.0)));
        double d2 = d * this.fTol;
        if (d2 < this.fTol) {
            this.fTol = d2;
        }
    }

    public static void setDenominatorToN() {
        Stat.setStaticDenominatorToN();
    }

    public static void setDenominatorToNminusOne() {
        Stat.setStaticDenominatorToNminusOne();
    }

    public static void resetCFmaxIter(int n) {
        Stat.resetCFmaxIter(n);
    }

    public static int getCFmaxIter() {
        return Stat.getCFmaxIter();
    }

    public static void resetCFtolerance(double d) {
        Stat.resetCFtolerance(d);
    }

    public static double getCFtolerance() {
        return Stat.getCFtolerance();
    }

    public void suppressPrint() {
        this.suppressPrint = true;
    }

    public void supressPrint() {
        this.suppressPrint = true;
    }

    public void suppressYYplot() {
        this.suppressYYplot = true;
    }

    public void supressYYplot() {
        this.suppressYYplot = true;
    }

    public void suppressErrorMessages() {
        this.suppressErrorMessages = true;
    }

    public void supressErrorMessages() {
        this.suppressErrorMessages = true;
    }

    public void ignoreDofFcheck() {
        this.ignoreDofFcheck = true;
    }

    public void suppressStats() {
        this.statFlag = false;
    }

    public void supressStats() {
        this.statFlag = false;
    }

    public void reinstateStats() {
        this.statFlag = true;
    }

    public void setCloseChoice(int n) {
        switch (n) {
            case 1: {
                this.plotWindowCloseChoice = false;
                break;
            }
            case 2: {
                this.plotWindowCloseChoice = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Option " + n + " not recognised");
            }
        }
    }

    public void setYscaleOption(boolean bl) {
        this.scaleFlag = bl;
        if (!bl) {
            this.yScaleFactor = 1.0;
        }
    }

    public void setYscale(boolean bl) {
        this.scaleFlag = bl;
        if (!bl) {
            this.yScaleFactor = 1.0;
        }
    }

    public void setYscaleFactor(double d) {
        this.scaleFlag = false;
        this.yScaleFactor = d;
    }

    public boolean getYscaleOption() {
        return this.scaleFlag;
    }

    public boolean getYscale() {
        return this.scaleFlag;
    }

    public void setTrueFreq(boolean bl) {
        boolean bl2 = this.trueFreq;
        this.trueFreq = bl;
        if (bl) {
            boolean bl3 = Regression.setTrueFreqWeights(this.yData, this.weight);
            if (bl3) {
                this.trueFreq = true;
                this.weightOpt = true;
            } else {
                this.trueFreq = false;
                this.weightOpt = false;
            }
        } else if (bl2) {
            for (int j = 0; j < this.weight.length; ++j) {
                this.weight[j] = 1.0;
            }
            this.weightOpt = false;
        }
    }

    public boolean getTrueFreq() {
        return this.trueFreq;
    }

    public void setXlegend(String string) {
        this.xLegend = string;
        this.legendCheck = true;
    }

    public void setYlegend(String string) {
        this.yLegend = string;
        this.legendCheck = true;
    }

    public void setTitle(String string) {
        this.graphTitle = string;
    }

    public void constant() {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 46;
        this.linNonLin = true;
        this.nParam = 1;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        this.best = new double[this.nParam];
        this.bestSd = new double[this.nParam];
        this.tValues = new double[this.nParam];
        this.pValues = new double[this.nParam];
        this.best[0] = Stat.mean(this.yData, this.weight);
        this.bestSd[0] = Stat.standardDeviation(this.yData, this.weight);
        this.tValues[0] = this.best[0] / this.bestSd[0];
        double d = Math.abs(this.tValues[0]);
        this.pValues[0] = d != d ? Double.NaN : 1.0 - Stat.studentTcdf(-d, d, this.degreesOfFreedom);
        this.sumOfSquaresError = 0.0;
        this.chiSquare = 0.0;
        for (int j = 0; j < this.nData; ++j) {
            this.yCalc[j] = this.best[0];
            this.residual[j] = this.yCalc[j] - this.yData[j];
            this.residualW[j] = this.residual[j] / this.weight[j];
            this.sumOfSquaresError += this.residual[j] * this.residual[j];
            this.chiSquare += this.residualW[j] * this.residualW[j];
        }
        this.reducedChiSquare = this.chiSquare / (double)this.degreesOfFreedom;
        this.calcDurbinWatson();
    }

    public void constantPlot(String string, String string2) {
        this.xLegend = string;
        this.yLegend = string2;
        this.legendCheck = true;
        this.constant();
        if (!this.suppressPrint) {
            this.print();
        }
        int n = 0;
        if (this.xData.length < 2) {
            n = this.plotXY();
        }
        if (n != -2 && !this.suppressYYplot) {
            this.plotYY();
        }
    }

    public void constantPlot() {
        this.constant();
        if (!this.suppressPrint) {
            this.print();
        }
        int n = 0;
        if (this.xData.length < 2) {
            n = this.plotXY();
        }
    }

    public void linear() {
        if (this.xErrorsEntered) {
            this.linearDual();
        } else {
            this.linearMono();
        }
    }

    public void linearMono() {
        int n;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 0;
        this.linNonLin = true;
        this.dualErrorsRequired = false;
        this.nParam = this.nXarrays + 1;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        double[][] dArray = new double[this.nParam][this.nData];
        for (n = 0; n < this.nData; ++n) {
            dArray[0][n] = 1.0;
        }
        for (n = 1; n < this.nParam; ++n) {
            for (int j = 0; j < this.nData; ++j) {
                dArray[n][j] = this.xData[n - 1][j];
            }
        }
        this.best = new double[this.nParam];
        this.bestSd = new double[this.nParam];
        this.tValues = new double[this.nParam];
        this.pValues = new double[this.nParam];
        this.generalLinear(dArray);
        if (!this.ignoreDofFcheck) {
            this.generalLinearStats(dArray);
        }
    }

    protected void linearDual() {
        int n;
        this.simplexFlag = 3;
        this.lastMethod = 0;
        this.userSupplied = false;
        this.zeroCheck = false;
        this.nParam = this.nXarrays + 1;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        this.dualErrorsRequired = true;
        this.nonLinStatsNeeded = false;
        Regression regression = new Regression(this.xData, this.yData);
        regression.linear();
        double[] dArray = regression.getBestEstimates();
        LinearXYDEfunction linearXYDEfunction = new LinearXYDEfunction();
        linearXYDEfunction.setNterms(this.nParam);
        linearXYDEfunction.setYerrors(this.yErrors);
        linearXYDEfunction.setXerrors(this.xErrors);
        this.linNonLin = false;
        double[] dArray2 = new double[this.nParam];
        for (int j = 0; j < this.nParam; ++j) {
            dArray2[j] = dArray[j] * 0.1;
            if (dArray2[j] != 0.0) continue;
            dArray2[j] = Stat.mean(dArray) * 0.1;
        }
        this.nelderMead(linearXYDEfunction, null, dArray, dArray2, this.fTol, this.nMax);
        double[][] dArray3 = new double[this.nParam][this.nData];
        this.linNonLin = true;
        for (n = 0; n < this.nData; ++n) {
            dArray3[0][n] = 1.0;
        }
        for (n = 1; n < this.nParam; ++n) {
            for (int j = 0; j < this.nData; ++j) {
                dArray3[n][j] = this.xData[n - 1][j];
            }
        }
        this.tValues = new double[this.nParam];
        this.pValues = new double[this.nParam];
        if (!this.ignoreDofFcheck) {
            this.generalLinearStats(dArray3);
        }
        this.dualErrorsRequired = false;
        this.nonLinStatsNeeded = true;
    }

    public void linearPlot(String string, String string2) {
        if (this.xErrorsEntered) {
            this.linearPlotDual(string, string2);
        } else {
            this.linearPlotMono(string, string2);
        }
    }

    public void linearPlotMono(String string, String string2) {
        this.xLegend = string;
        this.yLegend = string2;
        this.legendCheck = true;
        this.dualErrorsRequired = false;
        this.nonLinStatsNeeded = false;
        this.linearMono();
        if (!this.suppressPrint) {
            this.print();
        }
        int n = 0;
        if (this.xData.length < 2) {
            n = this.plotXY();
        }
        if (n != -2 && !this.suppressYYplot) {
            this.plotYY();
        }
    }

    public void linearPlotDual(String string, String string2) {
        this.xLegend = string;
        this.yLegend = string2;
        this.legendCheck = true;
        this.linearDual();
        if (!this.suppressPrint) {
            this.print();
        }
        int n = 0;
        if (this.xData.length < 2) {
            n = this.plotXY();
        }
        if (n != -2 && !this.suppressYYplot) {
            this.plotYY();
        }
    }

    public void linearPlot() {
        if (this.xErrorsEntered) {
            this.linearPlotDual();
        } else {
            this.linearPlotMono();
        }
    }

    public void linearPlotMono() {
        this.linearMono();
        if (!this.suppressPrint) {
            this.print();
        }
        int n = 0;
        if (this.xData.length < 2) {
            n = this.plotXY();
        }
        if (n != -2 && !this.suppressYYplot) {
            this.plotYY();
        }
    }

    public void linearPlotDual() {
        this.linearDual();
        if (!this.suppressPrint) {
            this.print();
        }
        int n = 0;
        this.xErrorsEntered = false;
        this.simplexFlag = 1;
        if (this.xData.length < 2) {
            n = this.plotXY();
        }
        if (n != -2 && !this.suppressYYplot) {
            this.plotYY();
        }
        this.xErrorsEntered = true;
    }

    public void linear(double d) {
        if (this.xErrorsEntered) {
            this.linearDual(d);
        } else {
            this.linearMono(d);
        }
    }

    public void linearMono(double d) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 47;
        this.fixedInterceptL = d;
        this.linNonLin = true;
        this.dualErrorsRequired = false;
        this.nParam = this.nXarrays;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        double[][] dArray = new double[this.nParam][this.nData];
        int n = 0;
        while (n < this.nData) {
            int n2 = n++;
            this.yData[n2] = this.yData[n2] - d;
        }
        for (n = 0; n < this.nParam; ++n) {
            for (int j = 0; j < this.nData; ++j) {
                dArray[n][j] = this.xData[n][j];
            }
        }
        this.best = new double[this.nParam];
        this.bestSd = new double[this.nParam];
        this.tValues = new double[this.nParam];
        this.pValues = new double[this.nParam];
        this.generalLinear(dArray);
        if (!this.ignoreDofFcheck) {
            this.generalLinearStats(dArray);
        }
        n = 0;
        while (n < this.nData) {
            int n3 = n;
            this.yData[n3] = this.yData[n3] + d;
            int n4 = n++;
            this.yCalc[n4] = this.yCalc[n4] + d;
        }
    }

    public void linearDual(double d) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 47;
        this.simplexFlag = 3;
        this.fixedInterceptL = d;
        this.dualErrorsRequired = true;
        this.nonLinStatsNeeded = false;
        this.nParam = this.nXarrays;
        this.userSupplied = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression regression = new Regression(this.xData, this.yData);
        regression.linear(d);
        double[] dArray = regression.getBestEstimates();
        LinearIXYDEfunction linearIXYDEfunction = new LinearIXYDEfunction();
        linearIXYDEfunction.setNparam(this.nParam);
        linearIXYDEfunction.setYerrors(this.yErrors);
        linearIXYDEfunction.setXerrors(this.xErrors);
        linearIXYDEfunction.setIntercept(d);
        this.linNonLin = false;
        double[] dArray2 = new double[this.nParam];
        for (int j = 0; j < this.nParam; ++j) {
            dArray2[j] = dArray[j] * 0.1;
            if (dArray2[j] != 0.0) continue;
            dArray2[j] = Stat.mean(dArray) * 0.1;
        }
        this.nelderMead(linearIXYDEfunction, null, dArray, dArray2, this.fTol, this.nMax);
        this.linNonLin = true;
        double[][] dArray3 = new double[this.nParam][this.nData];
        int n = 0;
        while (n < this.nData) {
            int n2 = n++;
            this.yData[n2] = this.yData[n2] - d;
        }
        for (n = 0; n < this.nParam; ++n) {
            for (int j = 0; j < this.nData; ++j) {
                dArray3[n][j] = this.xData[n][j];
            }
        }
        this.bestSd = new double[this.nParam];
        this.tValues = new double[this.nParam];
        this.pValues = new double[this.nParam];
        if (!this.ignoreDofFcheck) {
            this.generalLinearStats(dArray3);
        }
        n = 0;
        while (n < this.nData) {
            int n3 = n;
            this.yData[n3] = this.yData[n3] + d;
            int n4 = n++;
            this.yCalc[n4] = this.yCalc[n4] + d;
        }
        this.dualErrorsRequired = false;
        this.nonLinStatsNeeded = true;
    }

    public void linearPlot(double d, String string, String string2) {
        if (this.xErrorsEntered) {
            this.linearPlotDual(d, string, string2);
        } else {
            this.linearPlotMono(d, string, string2);
        }
    }

    public void linearPlotMono(double d, String string, String string2) {
        this.xLegend = string;
        this.yLegend = string2;
        this.legendCheck = true;
        this.linearMono(d);
        if (!this.suppressPrint) {
            this.print();
        }
        int n = 0;
        if (this.xData.length < 2) {
            n = this.plotXY();
        }
        if (n != -2 && !this.suppressYYplot) {
            this.plotYY();
        }
    }

    public void linearPlotDual(double d, String string, String string2) {
        this.xLegend = string;
        this.yLegend = string2;
        this.legendCheck = true;
        this.linearDual(d);
        this.xErrorsEntered = false;
        if (!this.suppressPrint) {
            this.print();
        }
        int n = 0;
        if (this.xData.length < 2) {
            n = this.plotXY();
        }
        if (n != -2 && !this.suppressYYplot) {
            this.plotYY();
        }
        this.xErrorsEntered = true;
    }

    public void linearPlot(double d) {
        if (this.xErrorsEntered) {
            this.linearPlotDual(d);
        } else {
            this.linearPlotMono(d);
        }
    }

    public void linearPlotMono(double d) {
        this.linearMono(d);
        if (!this.suppressPrint) {
            this.print();
        }
        int n = 0;
        if (this.xData.length < 2) {
            n = this.plotXY();
        }
        if (n != -2 && !this.suppressYYplot) {
            this.plotYY();
        }
    }

    public void linearPlotDual(double d) {
        this.xErrorsEntered = true;
        this.linearDual(d);
        this.linNonLin = true;
        if (!this.suppressPrint) {
            this.print();
        }
        int n = 0;
        this.xErrorsEntered = false;
        if (this.xData.length < 2) {
            n = this.plotXY();
        }
        if (n != -2 && !this.suppressYYplot) {
            this.plotYY();
        }
        this.xErrorsEntered = true;
    }

    public void polynomial(int n) {
        if (this.xErrorsEntered) {
            this.polynomialDual(n);
        } else {
            this.polynomialMono(n);
        }
    }

    protected void polynomialMono(int n) {
        int n2;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        if (this.nXarrays > 1) {
            throw new IllegalArgumentException("This class will only perform a polynomial regression on a single x array");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Polynomial degree must be greater than zero");
        }
        this.lastMethod = 1;
        this.linNonLin = true;
        this.dualErrorsRequired = false;
        this.nParam = n + 1;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        double[][] dArray = new double[this.nParam][this.nData];
        for (n2 = 0; n2 < this.nData; ++n2) {
            dArray[0][n2] = 1.0;
        }
        for (n2 = 0; n2 < this.nData; ++n2) {
            dArray[1][n2] = this.xData[0][n2];
        }
        for (n2 = 2; n2 < this.nParam; ++n2) {
            for (int j = 0; j < this.nData; ++j) {
                dArray[n2][j] = Math.pow(this.xData[0][j], n2);
            }
        }
        this.best = new double[this.nParam];
        this.bestSd = new double[this.nParam];
        this.tValues = new double[this.nParam];
        this.pValues = new double[this.nParam];
        this.generalLinear(dArray);
        if (!this.ignoreDofFcheck) {
            this.generalLinearStats(dArray);
        }
    }

    protected void polynomialDual(int n) {
        int n2;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        if (this.nXarrays > 1) {
            throw new IllegalArgumentException("This class will only perform a polynomial regression on a single x array");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Polynomial degree must be greater than zero");
        }
        this.lastMethod = 1;
        this.linNonLin = true;
        this.dualErrorsRequired = true;
        this.nonLinStatsNeeded = false;
        this.nParam = n + 1;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression regression = new Regression(this.xData, this.yData);
        regression.polynomial(n);
        double[] dArray = regression.getBestEstimates();
        PolyXYDEfunction polyXYDEfunction = new PolyXYDEfunction();
        polyXYDEfunction.setDeg(n);
        polyXYDEfunction.setYerrors(this.yErrors);
        polyXYDEfunction.setXerrors(this.xErrors);
        this.linNonLin = false;
        double[] dArray2 = new double[this.nParam];
        for (int j = 0; j < this.nParam; ++j) {
            dArray2[j] = dArray[j] * 0.1;
            if (dArray2[j] != 0.0) continue;
            dArray2[j] = Stat.mean(dArray) * 0.1;
        }
        this.nelderMead(polyXYDEfunction, null, dArray, dArray2, this.fTol, this.nMax);
        this.linNonLin = true;
        double[][] dArray3 = new double[this.nParam][this.nData];
        for (n2 = 0; n2 < this.nData; ++n2) {
            dArray3[0][n2] = 1.0;
        }
        for (n2 = 0; n2 < this.nData; ++n2) {
            dArray3[1][n2] = this.xData[0][n2];
        }
        for (n2 = 2; n2 < this.nParam; ++n2) {
            for (int j = 0; j < this.nData; ++j) {
                dArray3[n2][j] = Math.pow(this.xData[0][j], n2);
            }
        }
        this.bestSd = new double[this.nParam];
        this.tValues = new double[this.nParam];
        this.pValues = new double[this.nParam];
        if (!this.ignoreDofFcheck) {
            this.generalLinearStats(dArray3);
        }
        this.dualErrorsRequired = false;
        this.nonLinStatsNeeded = true;
    }

    public void polynomialPlot(int n, String string, String string2) {
        int n2;
        this.xLegend = string;
        this.yLegend = string2;
        this.legendCheck = true;
        this.polynomial(n);
        if (!this.suppressPrint) {
            this.print();
        }
        if ((n2 = this.plotXY()) != -2 && !this.suppressYYplot) {
            this.plotYY();
        }
    }

    public void polynomialPlot(int n) {
        int n2;
        this.polynomial(n);
        if (!this.suppressPrint) {
            this.print();
        }
        if ((n2 = this.plotXY()) != -2 && !this.suppressYYplot) {
            this.plotYY();
        }
    }

    public void polynomial(int n, double d) {
        if (this.xErrorsEntered) {
            this.polynomialDual(n, d);
        } else {
            this.polynomialMono(n, d);
        }
    }

    protected void polynomialMono(int n, double d) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        if (this.nXarrays > 1) {
            throw new IllegalArgumentException("This class will only perform a polynomial regression on a single x array");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Polynomial degree must be greater than zero");
        }
        this.lastMethod = 48;
        this.fixedInterceptP = d;
        this.linNonLin = true;
        this.dualErrorsRequired = false;
        this.nParam = n;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        double[][] dArray = new double[this.nParam][this.nData];
        int n2 = 0;
        while (n2 < this.nData) {
            int n3 = n2++;
            this.yData[n3] = this.yData[n3] - d;
        }
        for (n2 = 0; n2 < this.nData; ++n2) {
            dArray[0][n2] = this.xData[0][n2];
        }
        for (n2 = 1; n2 < this.nParam; ++n2) {
            for (int j = 0; j < this.nData; ++j) {
                dArray[n2][j] = Math.pow(this.xData[0][j], n2 + 1);
            }
        }
        this.best = new double[this.nParam];
        this.bestSd = new double[this.nParam];
        this.tValues = new double[this.nParam];
        this.pValues = new double[this.nParam];
        this.generalLinear(dArray);
        if (!this.ignoreDofFcheck) {
            this.generalLinearStats(dArray);
        }
        n2 = 0;
        while (n2 < this.nData) {
            int n4 = n2;
            this.yData[n4] = this.yData[n4] + d;
            int n5 = n2++;
            this.yCalc[n5] = this.yCalc[n5] + d;
        }
    }

    protected void polynomialDual(int n, double d) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        if (this.nXarrays > 1) {
            throw new IllegalArgumentException("This class will only perform a polynomial regression on a single x array");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Polynomial degree must be greater than zero");
        }
        this.lastMethod = 48;
        this.fixedInterceptP = d;
        this.linNonLin = true;
        this.dualErrorsRequired = true;
        this.nonLinStatsNeeded = false;
        this.nParam = n;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression regression = new Regression(this.xData, this.yData);
        regression.polynomial(n, d);
        double[] dArray = regression.getBestEstimates();
        PolyIXYDEfunction polyIXYDEfunction = new PolyIXYDEfunction();
        polyIXYDEfunction.setDeg(n);
        polyIXYDEfunction.setIntercept(d);
        polyIXYDEfunction.setYerrors(this.yErrors);
        polyIXYDEfunction.setXerrors(this.xErrors);
        this.linNonLin = false;
        double[] dArray2 = new double[this.nParam];
        for (int j = 0; j < this.nParam; ++j) {
            dArray2[j] = dArray[j] * 0.1;
            if (dArray2[j] != 0.0) continue;
            dArray2[j] = Stat.mean(dArray) * 0.1;
        }
        this.nelderMead(polyIXYDEfunction, null, dArray, dArray2, this.fTol, this.nMax);
        this.linNonLin = true;
        double[][] dArray3 = new double[this.nParam][this.nData];
        int n2 = 0;
        while (n2 < this.nData) {
            int n3 = n2++;
            this.yData[n3] = this.yData[n3] - d;
        }
        for (n2 = 0; n2 < this.nData; ++n2) {
            dArray3[0][n2] = this.xData[0][n2];
        }
        for (n2 = 1; n2 < this.nParam; ++n2) {
            for (int j = 0; j < this.nData; ++j) {
                dArray3[n2][j] = Math.pow(this.xData[0][j], n2 + 1);
            }
        }
        this.bestSd = new double[this.nParam];
        this.tValues = new double[this.nParam];
        this.pValues = new double[this.nParam];
        if (!this.ignoreDofFcheck) {
            this.generalLinearStats(dArray3);
        }
        n2 = 0;
        while (n2 < this.nData) {
            int n4 = n2;
            this.yData[n4] = this.yData[n4] + d;
            int n5 = n2++;
            this.yCalc[n5] = this.yCalc[n5] + d;
        }
        this.dualErrorsRequired = false;
        this.nonLinStatsNeeded = true;
    }

    public void polynomialPlot(int n, double d, String string, String string2) {
        int n2;
        this.xLegend = string;
        this.yLegend = string2;
        this.legendCheck = true;
        this.polynomial(n, d);
        if (!this.suppressPrint) {
            this.print();
        }
        if ((n2 = this.plotXY()) != -2 && !this.suppressYYplot) {
            this.plotYY();
        }
    }

    public void polynomialPlot(int n, double d) {
        int n2;
        this.polynomial(n, d);
        if (!this.suppressPrint) {
            this.print();
        }
        if ((n2 = this.plotXY()) != -2 && !this.suppressYYplot) {
            this.plotYY();
        }
    }

    public ArrayList<Object> bestPolynomial() {
        return this.polynomialBest(0);
    }

    public ArrayList<Object> polynomialBest(int n) {
        int n2;
        double d;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        if (this.nXarrays > 1) {
            throw new IllegalArgumentException("This class will only perform a polynomial regression on a single x array");
        }
        this.bestPolyFlag = true;
        this.linNonLin = true;
        ArrayList<Object> arrayList = null;
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        int n3 = 0;
        int n4 = 0;
        int n5 = this.nData - 2;
        int n6 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = true;
        Regression regression = new Regression(this.xData[0], this.yData);
        regression.constant();
        double d5 = d = regression.getChiSquare();
        if (++n3 > n5) {
            bl = false;
            System.out.println("Method bestPolynomial requires at least three data points: null  returned");
            return null;
        }
        regression.linear();
        d = regression.getChiSquare();
        arrayList = Regression.testOfAdditionalTerms_ArrayList(d5, 0, d, 1, this.nData, this.fProbSignificance);
        ++n6;
        d2 = (Double)arrayList.get(0);
        d3 = (Double)arrayList.get(1);
        d4 = (Double)arrayList.get(8);
        arrayList2.add(new Double(d5));
        arrayList2.add(new Double(d));
        arrayList2.add(new Double(d2));
        arrayList2.add(new Double(d3));
        arrayList2.add(new Double(d4));
        if (d2 < d4) {
            bl = false;
            n4 = 0;
        }
        if (++n3 > n5) {
            bl = false;
        }
        while (bl) {
            d5 = d;
            regression.polynomial(n3);
            d = regression.getChiSquare();
            arrayList = Regression.testOfAdditionalTerms_ArrayList(d5, n3 - 1, d, n3, this.nData, this.fProbSignificance);
            ++n6;
            d2 = (Double)arrayList.get(0);
            d3 = (Double)arrayList.get(1);
            d4 = (Double)arrayList.get(8);
            arrayList2.add(new Double(d5));
            arrayList2.add(new Double(d));
            arrayList2.add(new Double(d2));
            arrayList2.add(new Double(d3));
            arrayList2.add(new Double(d4));
            if (d2 < d4) {
                bl = false;
                n4 = n3 - 1;
            }
            if (++n3 <= n5) continue;
            bl = false;
        }
        this.bestPolynomialDegree = n4;
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n6];
        double[] dArray = new double[n6];
        double[] dArray2 = new double[n6];
        double[] dArray3 = new double[n6];
        double[] dArray4 = new double[n6];
        double[] dArray5 = new double[n6];
        for (n2 = 0; n2 < n6; ++n2) {
            nArray[n2] = n2;
            nArray2[n2] = n2 + 1;
            dArray[n2] = (Double)arrayList2.get(5 * n2);
            dArray2[n2] = (Double)arrayList2.get(5 * n2 + 1);
            dArray3[n2] = (Double)arrayList2.get(5 * n2 + 2);
            dArray4[n2] = (Double)arrayList2.get(5 * n2 + 3);
            dArray5[n2] = (Double)arrayList2.get(5 * n2 + 4);
        }
        this.bestPolyArray.clear();
        this.bestPolyArray.add(new Integer(this.bestPolynomialDegree));
        this.bestPolyArray.add(new Integer(n6));
        this.bestPolyArray.add(nArray);
        this.bestPolyArray.add(nArray2);
        this.bestPolyArray.add(dArray);
        this.bestPolyArray.add(dArray2);
        this.bestPolyArray.add(dArray3);
        this.bestPolyArray.add(dArray4);
        this.bestPolyArray.add(dArray5);
        this.bestPolyArray.add(this.fProbSignificance);
        n2 = 1;
        int n7 = 0;
        while (n2 != 0) {
            if (dArray[n7] == 0.0) {
                this.bestPolynomialDegree = n7;
                n2 = 0;
                continue;
            }
            if (++n7 < n6) continue;
            n2 = 0;
        }
        block0 : switch (n) {
            case 0: {
                switch (this.bestPolynomialDegree) {
                    case 0: {
                        this.constant();
                        break block0;
                    }
                    case 1: {
                        this.linear();
                        break block0;
                    }
                }
                this.polynomial(this.bestPolynomialDegree);
                break;
            }
            case 1: {
                switch (this.bestPolynomialDegree) {
                    case 0: {
                        this.constantPlot();
                        break block0;
                    }
                    case 1: {
                        this.linearPlot();
                        break block0;
                    }
                }
                this.polynomialPlot(this.bestPolynomialDegree);
            }
        }
        return this.bestPolyArray;
    }

    public ArrayList<Object> bestPolynomialPlot(String string, String string2) {
        this.xLegend = string;
        this.yLegend = string2;
        this.legendCheck = true;
        return this.polynomialBest(1);
    }

    public ArrayList<Object> bestPolynomialPlot() {
        return this.polynomialBest(1);
    }

    public ArrayList<Object> bestPolynomial(double d) {
        this.fixedInterceptP = d;
        return this.polynomialBest(d, 0);
    }

    public ArrayList<Object> polynomialBest(double d, int n) {
        int n2;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        if (this.nXarrays > 1) {
            throw new IllegalArgumentException("This class will only perform a polynomial regression on a single x array");
        }
        this.bestPolyFlag = true;
        this.linNonLin = true;
        this.dualErrorsRequired = false;
        ArrayList<Object> arrayList = null;
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        int n3 = 1;
        int n4 = 1;
        int n5 = this.nData - 2;
        int n6 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = true;
        Regression regression = null;
        regression = this.xErrorsEntered ? new Regression(this.xData, this.yData, this.xErrors, this.yErrors) : (this.weightOpt ? new Regression(this.xData[0], this.yData, this.yErrors) : new Regression(this.xData[0], this.yData));
        double d5 = 0.0;
        double d6 = 0.0;
        if (n3 > n5) {
            bl = false;
            System.out.println("Method bestPolynomial requires at least three data points: null  returned");
            return null;
        }
        regression.linear(d);
        d5 = regression.getChiSquare();
        if (++n3 > n5) {
            bl = false;
        }
        if (!bl && n4 == 0) {
            n4 = 1;
        }
        while (bl) {
            d6 = d5;
            regression.polynomial(n3, d);
            d5 = regression.getChiSquare();
            arrayList = Regression.testOfAdditionalTerms_ArrayList(d6, n3 - 1, d5, n3, this.nData, this.fProbSignificance);
            ++n6;
            d2 = (Double)arrayList.get(0);
            d3 = (Double)arrayList.get(1);
            d4 = (Double)arrayList.get(8);
            arrayList2.add(new Double(d6));
            arrayList2.add(new Double(d5));
            arrayList2.add(new Double(d2));
            arrayList2.add(new Double(d3));
            arrayList2.add(new Double(d4));
            if (d2 < d4) {
                bl = false;
                n4 = n3 - 1;
            }
            if (++n3 <= n5) continue;
            bl = false;
        }
        this.bestPolynomialDegree = n4;
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n6];
        double[] dArray = new double[n6];
        double[] dArray2 = new double[n6];
        double[] dArray3 = new double[n6];
        double[] dArray4 = new double[n6];
        double[] dArray5 = new double[n6];
        for (n2 = 0; n2 < n6; ++n2) {
            nArray[n2] = n2 + 1;
            nArray2[n2] = n2 + 2;
            dArray[n2] = (Double)arrayList2.get(5 * n2);
            dArray2[n2] = (Double)arrayList2.get(5 * n2 + 1);
            dArray3[n2] = (Double)arrayList2.get(5 * n2 + 2);
            dArray4[n2] = (Double)arrayList2.get(5 * n2 + 3);
            dArray5[n2] = (Double)arrayList2.get(5 * n2 + 4);
        }
        this.bestPolyArray.clear();
        this.bestPolyArray.add(new Integer(this.bestPolynomialDegree));
        this.bestPolyArray.add(new Integer(n6));
        this.bestPolyArray.add(nArray);
        this.bestPolyArray.add(nArray2);
        this.bestPolyArray.add(dArray);
        this.bestPolyArray.add(dArray2);
        this.bestPolyArray.add(dArray3);
        this.bestPolyArray.add(dArray4);
        this.bestPolyArray.add(dArray5);
        this.bestPolyArray.add(this.fProbSignificance);
        n2 = 1;
        int n7 = 0;
        while (n2 != 0) {
            if (dArray[n7] == 0.0) {
                this.bestPolynomialDegree = n7 + 1;
                n2 = 0;
                continue;
            }
            if (++n7 < n6) continue;
            n2 = 0;
        }
        block0 : switch (n) {
            case 0: {
                switch (this.bestPolynomialDegree) {
                    case 1: {
                        this.linear(d);
                        break block0;
                    }
                }
                this.polynomial(this.bestPolynomialDegree, d);
                break;
            }
            case 1: {
                switch (this.bestPolynomialDegree) {
                    case 1: {
                        this.linearPlot(d);
                        break block0;
                    }
                }
                this.polynomialPlot(this.bestPolynomialDegree, d);
            }
        }
        return this.bestPolyArray;
    }

    public ArrayList<Object> bestPolynomialPlot(double d, String string, String string2) {
        this.xLegend = string;
        this.yLegend = string2;
        this.legendCheck = true;
        return this.polynomialBest(d, 1);
    }

    public ArrayList<Object> bestPolynomialPlot(double d) {
        return this.polynomialBest(d, 1);
    }

    public void setFtestSignificance(double d) {
        this.fProbSignificance = d;
    }

    public double getFtestSignificance(double d) {
        return this.fProbSignificance;
    }

    public void nonIntegerPolynomial(int n) {
        this.fitNonIntegerPolynomial(n, 0);
    }

    public void nonIntegerPolynomial() {
        this.fitNonIntegerPolynomial(3, 0);
    }

    public void nonIntegerPolynomialPlot(int n) {
        this.fitNonIntegerPolynomial(n, 1);
    }

    public void nonIntegerPolynomialPlot() {
        this.fitNonIntegerPolynomial(3, 1);
    }

    public void nonIntegerPolynomialPlot(int n, String string, String string2) {
        this.xLegend = string;
        this.yLegend = string2;
        this.legendCheck = true;
        this.fitNonIntegerPolynomial(n, 1);
    }

    public void nonIntegerPolynomialPlot(String string, String string2) {
        this.xLegend = string;
        this.xLegend = string;
        this.yLegend = string2;
        this.legendCheck = true;
        this.fitNonIntegerPolynomial(3, 1);
    }

    protected void fitNonIntegerPolynomial(int n, int n2) {
        if (this.xErrorsEntered) {
            this.fitNonIntegerPolynomialDual(n, n2);
        } else {
            this.fitNonIntegerPolynomialMono(n, n2);
        }
    }

    protected void fitNonIntegerPolynomialMono(int n, int n2) {
        int n3;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 50;
        this.userSupplied = false;
        this.linNonLin = false;
        this.dualErrorsRequired = false;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.zeroCheck = false;
        int n4 = n - 1;
        this.nParam = 2 * n - 1;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Regression regression = new Regression(this.xData[0], this.yData, this.weight);
        regression.polynomial(n4);
        double[] dArray = new double[this.nParam];
        double[] dArray2 = new double[this.nParam];
        double[] dArray3 = regression.getBestEstimates();
        double d = 0.0;
        for (n3 = 0; n3 < n; ++n3) {
            dArray[n3] = dArray3[n3];
            d += dArray[n3];
        }
        d /= (double)n;
        for (n3 = 0; n3 < n; ++n3) {
            dArray2[n3] = dArray[n3] * 0.1;
            if (dArray2[n3] != 0.0) continue;
            dArray2[n3] = 0.1 * d;
        }
        double d2 = 1.0;
        for (int j = n; j < this.nParam; ++j) {
            dArray[j] = d2;
            dArray2[j] = dArray[j] * 0.1;
            d2 += 1.0;
        }
        NonIntegerPolyFunction nonIntegerPolyFunction = new NonIntegerPolyFunction();
        nonIntegerPolyFunction.setNterms(n);
        NonIntegerPolyFunction nonIntegerPolyFunction2 = nonIntegerPolyFunction;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.nelderMead(nonIntegerPolyFunction2, null, dArray, dArray2, this.fTol, this.nMax);
        if (n2 == 1) {
            int n5;
            if (!this.suppressPrint) {
                this.print();
            }
            if ((n5 = this.plotXY(nonIntegerPolyFunction)) != -2 && !this.suppressYYplot) {
                this.plotYY();
            }
        }
    }

    protected void fitNonIntegerPolynomialDual(int n, int n2) {
        int n3;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 50;
        this.userSupplied = false;
        this.simplexFlag = 3;
        this.linNonLin = false;
        this.dualErrorsRequired = true;
        this.nonLinStatsNeeded = true;
        this.zeroCheck = false;
        int n4 = n - 1;
        this.nParam = 2 * n - 1;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Regression regression = new Regression(this.xData[0], this.yData, this.weight);
        regression.polynomial(n4);
        double[] dArray = new double[this.nParam];
        double[] dArray2 = new double[this.nParam];
        double[] dArray3 = regression.getBestEstimates();
        double d = 0.0;
        for (n3 = 0; n3 < n; ++n3) {
            dArray[n3] = dArray3[n3];
            d += dArray[n3];
        }
        d /= (double)n;
        for (n3 = 0; n3 < n; ++n3) {
            dArray2[n3] = dArray[n3] * 0.1;
            if (dArray2[n3] != 0.0) continue;
            dArray2[n3] = 0.1 * d;
        }
        double d2 = 1.0;
        for (int j = n; j < this.nParam; ++j) {
            dArray[j] = d2;
            dArray2[j] = dArray[j] * 0.1;
            d2 += 1.0;
        }
        NonIntegerPolyFunctionDual nonIntegerPolyFunctionDual = new NonIntegerPolyFunctionDual();
        nonIntegerPolyFunctionDual.setNterms(n);
        nonIntegerPolyFunctionDual.setYerrors(this.yErrors);
        nonIntegerPolyFunctionDual.setXerrors(this.xErrors);
        NonIntegerPolyFunctionDual nonIntegerPolyFunctionDual2 = nonIntegerPolyFunctionDual;
        this.nelderMead(nonIntegerPolyFunctionDual2, null, dArray, dArray2, this.fTol, this.nMax);
        if (n2 == 1) {
            int n5;
            if (!this.suppressPrint) {
                this.print();
            }
            if ((n5 = this.plotXY(nonIntegerPolyFunctionDual)) != -2 && !this.suppressYYplot) {
                this.plotYY();
            }
        }
        this.dualErrorsRequired = false;
    }

    public void linearGeneral() {
        if (this.xErrorsEntered) {
            this.linearGeneralDual();
        } else {
            this.linearGeneralMono();
        }
    }

    public void linearGeneralMono() {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 2;
        this.linNonLin = true;
        this.nParam = this.nXarrays;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        this.best = new double[this.nParam];
        this.bestSd = new double[this.nParam];
        this.tValues = new double[this.nParam];
        this.pValues = new double[this.nParam];
        this.generalLinear(this.xData);
        if (!this.ignoreDofFcheck) {
            this.generalLinearStats(this.xData);
        }
    }

    public void linearGeneralDual() {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 2;
        this.simplexFlag = 3;
        this.linNonLin = true;
        this.userSupplied = false;
        this.zeroCheck = false;
        this.nParam = this.nXarrays;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        this.best = new double[this.nParam];
        this.dualErrorsRequired = true;
        this.nonLinStatsNeeded = false;
        Regression regression = new Regression(this.xData, this.yData);
        regression.linearGeneral();
        double[] dArray = regression.getBestEstimates();
        LinearGXYDEfunction linearGXYDEfunction = new LinearGXYDEfunction();
        linearGXYDEfunction.setNterms(this.nParam);
        linearGXYDEfunction.setYerrors(this.yErrors);
        linearGXYDEfunction.setXerrors(this.xErrors);
        this.linNonLin = false;
        double[] dArray2 = new double[this.nParam];
        for (int j = 0; j < this.nParam; ++j) {
            dArray2[j] = dArray[j] * 0.1;
            if (dArray2[j] != 0.0) continue;
            dArray2[j] = Stat.mean(dArray) * 0.1;
        }
        this.nelderMead(linearGXYDEfunction, null, dArray, dArray2, this.fTol, this.nMax);
        this.linNonLin = true;
        this.bestSd = new double[this.nParam];
        this.tValues = new double[this.nParam];
        this.pValues = new double[this.nParam];
        if (!this.ignoreDofFcheck) {
            this.generalLinearStats(this.xData);
        }
        this.dualErrorsRequired = false;
        this.nonLinStatsNeeded = true;
    }

    public void linearGeneralPlot(String string, String string2) {
        if (this.xErrorsEntered) {
            this.linearGeneralPlotDual(string, string2);
        } else {
            this.linearGeneralPlotMono(string, string2);
        }
    }

    public void linearGeneralPlotMono(String string, String string2) {
        this.xLegend = string;
        this.yLegend = string2;
        this.legendCheck = true;
        this.linearGeneral();
        if (!this.suppressPrint) {
            this.print();
        }
        if (!this.suppressYYplot) {
            this.plotYY();
        }
    }

    public void linearGeneralPlotDual(String string, String string2) {
        this.xLegend = string;
        this.yLegend = string2;
        this.legendCheck = true;
        this.linearGeneralDual();
        this.linNonLin = true;
        if (!this.suppressPrint) {
            this.print();
        }
        this.xErrorsEntered = false;
        if (!this.suppressYYplot) {
            this.plotYY();
        }
        this.xErrorsEntered = true;
    }

    public void linearGeneralPlot() {
        if (this.xErrorsEntered) {
            this.linearGeneralPlotDual();
        } else {
            this.linearGeneralPlotMono();
        }
    }

    public void linearGeneralPlotMono() {
        this.linearGeneral();
        if (!this.suppressPrint) {
            this.print();
        }
        if (!this.suppressYYplot) {
            this.plotYY();
        }
    }

    public void linearGeneralPlotDual() {
        this.linearGeneralDual();
        this.linNonLin = true;
        if (!this.suppressPrint) {
            this.print();
        }
        this.xErrorsEntered = false;
        if (!this.suppressYYplot) {
            this.plotYY();
        }
        this.xErrorsEntered = true;
    }

    protected void generalLinear(double[][] dArray) {
        int n;
        int n2;
        if (this.nData <= this.nParam && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Number of unknown parameters is greater than or equal to the number of data points");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double[][] dArray2 = new double[this.nParam][this.nParam];
        double[][] dArray3 = new double[this.nParam][this.nParam];
        double[] dArray4 = new double[this.nParam];
        double[] dArray5 = new double[this.nParam];
        if (this.ignoreDofFcheck) {
            this.bestSd = new double[this.nParam];
            this.pseudoSd = new double[this.nParam];
            this.tValues = new double[this.nParam];
            this.pValues = new double[this.nParam];
            this.covar = new double[this.nParam][this.nParam];
            this.corrCoeff = new double[this.nParam][this.nParam];
            for (n2 = 0; n2 < this.nParam; ++n2) {
                this.bestSd[n2] = Double.NaN;
                this.pseudoSd[n2] = Double.NaN;
                for (n = 0; n < this.nParam; ++n) {
                    this.covar[n2][n] = Double.NaN;
                    this.corrCoeff[n2][n] = Double.NaN;
                }
            }
        }
        for (n2 = 0; n2 < this.nParam; ++n2) {
            d2 = 0.0;
            for (n = 0; n < this.nData; ++n) {
                d2 += this.yData[n] * dArray[n2][n] / Fmath.square(this.weight[n]);
            }
            dArray4[n2] = d2;
        }
        for (n2 = 0; n2 < this.nParam; ++n2) {
            for (n = 0; n < this.nParam; ++n) {
                d2 = 0.0;
                for (int j = 0; j < this.nData; ++j) {
                    d2 += dArray[n2][j] * dArray[n][j] / Fmath.square(this.weight[j]);
                }
                dArray2[n][n2] = d2;
            }
        }
        Matrix matrix = new Matrix(dArray2);
        if (this.suppressErrorMessages) {
            matrix.suppressErrorMessage();
        }
        dArray5 = matrix.solveLinearSet(dArray4);
        for (n = 0; n < this.nParam; ++n) {
            this.best[n] = dArray5[n];
        }
    }

    protected void nelderMead(Object object, Object object2, double[] dArray, double[] dArray2, double d, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        Object object3;
        int n6;
        int n7;
        if (this.xErrorsEntered && !this.dualErrorsRequired) {
            throw new IllegalArgumentException("The data fitting method called does not support independent variable errors - use a constructor that does not include x errors in its argument list");
        }
        int n8 = dArray.length;
        if (this.maxConstraintIndex >= n8) {
            throw new IllegalArgumentException("You have entered more constrained parameters (" + this.maxConstraintIndex + ") than minimisation parameters (" + n8 + ")");
        }
        this.nlrStatus = true;
        this.nParam = n8;
        int n9 = n8 + 1;
        this.lastSSnoConstraint = 0.0;
        if (this.scaleOpt < 2) {
            this.scale = new double[n8];
        }
        if (this.scaleOpt == 2 && this.scale.length != dArray.length) {
            throw new IllegalArgumentException("scale array and initial estimate array are of different lengths");
        }
        if (dArray2.length != dArray.length) {
            throw new IllegalArgumentException("step array length " + dArray2.length + " and initial estimate array length " + dArray.length + " are of different");
        }
        for (n7 = 0; n7 < n8; ++n7) {
            if (dArray2[n7] != 0.0) continue;
            throw new IllegalArgumentException("step " + n7 + " size is zero");
        }
        if (this.minIter > this.nMax) {
            this.nMax = this.minIter;
        }
        if (this.ignoreDofFcheck) {
            this.bestSd = new double[this.nParam];
            this.pseudoSd = new double[this.nParam];
            this.tValues = new double[this.nParam];
            this.pValues = new double[this.nParam];
            this.covar = new double[this.nParam][this.nParam];
            this.corrCoeff = new double[this.nParam][this.nParam];
            for (n7 = 0; n7 < this.nParam; ++n7) {
                this.bestSd[n7] = Double.NaN;
                this.pseudoSd[n7] = Double.NaN;
                for (int j = 0; j < this.nParam; ++j) {
                    this.covar[n7][j] = Double.NaN;
                    this.corrCoeff[n7][j] = Double.NaN;
                }
            }
        }
        this.startH = new double[n8];
        this.stepH = new double[n8];
        this.startSH = new double[n8];
        this.stepSH = new double[n8];
        double[] dArray3 = new double[n8];
        this.best = new double[n8];
        this.bestSd = new double[n8];
        this.tValues = new double[n8];
        this.pValues = new double[n8];
        double[][] dArray4 = new double[n9][n9];
        double[] dArray5 = new double[n9];
        double[] dArray6 = new double[n9];
        double[] dArray7 = new double[n9];
        double[] dArray8 = new double[n9];
        double d2 = 0.0;
        for (n6 = 0; n6 < this.nData; ++n6) {
            d2 += Math.abs(this.yData[n6]);
        }
        d2 /= (double)this.nData;
        if (this.penalty) {
            Integer n10 = (Integer)this.penalties.get(1);
            this.nConstraints = n10;
            this.penaltyParam = new int[this.nConstraints];
            this.penaltyCheck = new int[this.nConstraints];
            this.constraints = new double[this.nConstraints];
            object3 = null;
            n5 = 2;
            for (n4 = 0; n4 < this.nConstraints; ++n4) {
                n10 = (Integer)this.penalties.get(n5);
                this.penaltyParam[n4] = n10;
                n10 = (Integer)this.penalties.get(++n5);
                this.penaltyCheck[n4] = n10;
                object3 = (Double)this.penalties.get(++n5);
                this.constraints[n4] = (Double)object3;
                ++n5;
            }
        }
        if (this.sumPenalty) {
            Integer n11 = (Integer)this.sumPenalties.get(1);
            this.nSumConstraints = n11;
            this.sumPenaltyParam = new int[this.nSumConstraints][];
            this.sumPlusOrMinus = new double[this.nSumConstraints][];
            this.sumPenaltyCheck = new int[this.nSumConstraints];
            this.sumPenaltyNumber = new int[this.nSumConstraints];
            this.sumConstraints = new double[this.nSumConstraints];
            object3 = null;
            double[] dArray9 = null;
            Double d3 = null;
            n3 = 2;
            for (int j = 0; j < this.nSumConstraints; ++j) {
                n11 = (Integer)this.sumPenalties.get(n3);
                this.sumPenaltyNumber[j] = n11;
                object3 = (int[])this.sumPenalties.get(++n3);
                this.sumPenaltyParam[j] = (int[])object3;
                dArray9 = (double[])this.sumPenalties.get(++n3);
                this.sumPlusOrMinus[j] = dArray9;
                n11 = (Integer)this.sumPenalties.get(++n3);
                this.sumPenaltyCheck[j] = n11;
                d3 = (Double)this.sumPenalties.get(++n3);
                this.sumConstraints[j] = d3;
                ++n3;
            }
        }
        for (n6 = 0; n6 < n8; ++n6) {
            dArray2[n6] = Math.abs(dArray2[n6]);
            this.startH[n6] = dArray[n6];
            this.stepH[n6] = dArray2[n6];
        }
        if (this.scaleOpt > 0) {
            n6 = 0;
            for (int j = 0; j < n8; ++j) {
                if (dArray[j] != 0.0) continue;
                n6 = 1;
            }
            if (n6 != 0) {
                System.out.println("Neler and Mead Simplex: a start value of zero precludes scaling");
                System.out.println("Regression performed without scaling");
                this.scaleOpt = 0;
            }
        }
        switch (this.scaleOpt) {
            case 0: {
                for (n6 = 0; n6 < n8; ++n6) {
                    this.scale[n6] = 1.0;
                }
                break;
            }
            case 1: {
                for (n6 = 0; n6 < n8; ++n6) {
                    this.scale[n6] = 1.0 / dArray[n6];
                    dArray2[n6] = dArray2[n6] / dArray[n6];
                    dArray[n6] = 1.0;
                }
                break;
            }
            case 2: {
                for (n6 = 0; n6 < n8; ++n6) {
                    int n12 = n6;
                    dArray2[n12] = dArray2[n12] * this.scale[n6];
                    int n13 = n6;
                    dArray[n13] = dArray[n13] * this.scale[n6];
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Scaling factor option " + this.scaleOpt + " not recognised");
            }
        }
        this.fTol = d;
        this.nMax = n;
        this.nIter = 0;
        for (n6 = 0; n6 < n8; ++n6) {
            this.startSH[n6] = dArray[n6];
            this.stepSH[n6] = dArray2[n6];
            this.scale[n6] = this.scale[n6];
        }
        double d4 = 0.0;
        for (n5 = 0; n5 < n8; ++n5) {
            dArray7[n5] = d4 = dArray[n5];
            dArray8[n5] = d4;
            dArray3[n5] = d4;
        }
        n5 = this.konvge;
        for (n4 = 0; n4 < n8; ++n4) {
            dArray4[n4][n9 - 1] = dArray[n4];
        }
        dArray5[n9 - 1] = this.sumSquares(object, dArray);
        for (n4 = 0; n4 < n8; ++n4) {
            dArray[n4] = dArray[n4] + dArray2[n4];
            for (n3 = 0; n3 < n8; ++n3) {
                dArray4[n3][n4] = dArray[n3];
            }
            dArray5[n4] = this.sumSquares(object, dArray);
            dArray[n4] = dArray[n4] - dArray2[n4];
        }
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        boolean bl = true;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        while (bl) {
            int n17;
            d5 = d8 = dArray5[0];
            n14 = 0;
            n15 = 0;
            for (n2 = 1; n2 < n9; ++n2) {
                if (dArray5[n2] < d8) {
                    d8 = dArray5[n2];
                    n14 = n2;
                }
                if (!(dArray5[n2] > d5)) continue;
                d5 = dArray5[n2];
                n15 = n2;
            }
            for (n2 = 0; n2 < n8; ++n2) {
                d11 = 0.0;
                for (n17 = 0; n17 < n9; ++n17) {
                    d11 += dArray4[n2][n17];
                }
                dArray6[n2] = (d11 -= dArray4[n2][n15]) / (double)n8;
            }
            for (n2 = 0; n2 < n8; ++n2) {
                dArray7[n2] = (1.0 + this.rCoeff) * dArray6[n2] - this.rCoeff * dArray4[n2][n15];
            }
            d6 = this.sumSquares(object, dArray7);
            ++this.nIter;
            if (d6 < d8) {
                for (n2 = 0; n2 < n8; ++n2) {
                    dArray8[n2] = dArray7[n2] * (1.0 + this.eCoeff) - this.eCoeff * dArray6[n2];
                }
                d7 = this.sumSquares(object, dArray8);
                ++this.nIter;
                if (d7 < d8) {
                    for (n2 = 0; n2 < n8; ++n2) {
                        dArray4[n2][n15] = dArray8[n2];
                    }
                    dArray5[n15] = d7;
                } else {
                    for (n2 = 0; n2 < n8; ++n2) {
                        dArray4[n2][n15] = dArray7[n2];
                    }
                    dArray5[n15] = d6;
                }
            } else {
                n16 = 0;
                for (n2 = 0; n2 < n9; ++n2) {
                    if (n2 == n15 || !(d6 > dArray5[n2])) continue;
                    ++n16;
                }
                if (n16 == n8) {
                    if (d6 <= dArray5[n15]) {
                        for (n2 = 0; n2 < n8; ++n2) {
                            dArray4[n2][n15] = dArray7[n2];
                        }
                        dArray5[n15] = d6;
                    }
                    for (n2 = 0; n2 < n8; ++n2) {
                        dArray8[n2] = this.cCoeff * dArray4[n2][n15] + (1.0 - this.cCoeff) * dArray6[n2];
                    }
                    d7 = this.sumSquares(object, dArray8);
                    ++this.nIter;
                    if (d7 > dArray5[n15]) {
                        for (n2 = 0; n2 < n9; ++n2) {
                            for (n17 = 0; n17 < n8; ++n17) {
                                dArray4[n17][n2] = 0.5 * (dArray4[n17][n2] + dArray4[n17][n14]);
                                dArray3[n17] = dArray4[n17][n2];
                            }
                            dArray5[n2] = this.sumSquares(object, dArray3);
                        }
                        this.nIter += n9;
                    } else {
                        for (n2 = 0; n2 < n8; ++n2) {
                            dArray4[n2][n15] = dArray8[n2];
                        }
                        dArray5[n15] = d7;
                    }
                } else {
                    for (n2 = 0; n2 < n8; ++n2) {
                        dArray4[n2][n15] = dArray7[n2];
                    }
                    dArray5[n15] = d6;
                }
            }
            d10 = 0.0;
            d5 = dArray5[0];
            n14 = 0;
            for (n2 = 0; n2 < n9; ++n2) {
                d10 += dArray5[n2];
                if (!(d5 > dArray5[n2])) continue;
                d5 = dArray5[n2];
                n14 = n2;
            }
            d10 /= (double)n9;
            d12 = 0.0;
            for (n2 = 0; n2 < n9; ++n2) {
                d11 = dArray5[n2] - d10;
                d12 += d11 * d11;
            }
            d9 = Math.sqrt(d12 / (double)n8);
            switch (this.minTest) {
                case 0: {
                    if (!(d9 < d) || this.nIter <= this.minIter) break;
                    bl = false;
                    break;
                }
                case 1: {
                    if (!(Math.sqrt(d5 / (double)this.degreesOfFreedom) < d2 * d) || this.nIter <= this.minIter) break;
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Simplex standard deviation test option " + this.minTest + " not recognised");
                }
            }
            this.sumOfSquaresError = d5;
            if (!bl) {
                for (n2 = 0; n2 < n8; ++n2) {
                    dArray3[n2] = dArray4[n2][n14];
                }
                dArray5[n9 - 1] = d5;
                this.simplexSd = d9;
                if (--n5 > 0) {
                    bl = true;
                    for (n2 = 0; n2 < n8; ++n2) {
                        dArray3[n2] = dArray3[n2] + dArray2[n2];
                        for (n17 = 0; n17 < n8; ++n17) {
                            dArray4[n17][n2] = dArray3[n17];
                        }
                        dArray5[n2] = this.sumSquares(object, dArray3);
                        dArray3[n2] = dArray3[n2] - dArray2[n2];
                    }
                }
            }
            if (!bl || this.nIter <= this.nMax) continue;
            if (!this.suppressErrorMessages) {
                System.out.println("Maximum iteration number reached, in Regression.simplex(...)");
                System.out.println("without the convergence criterion being satisfied");
                System.out.println("Current parameter estimates and sum of squares values returned");
            }
            this.nlrStatus = false;
            for (n2 = 0; n2 < n8; ++n2) {
                dArray3[n2] = dArray4[n2][n14];
            }
            dArray5[n9 - 1] = d5;
            bl = false;
        }
        for (n2 = 0; n2 < n8; ++n2) {
            dArray3[n2] = dArray4[n2][n14];
            this.best[n2] = dArray3[n2] / this.scale[n2];
            this.scale[n2] = 1.0;
        }
        this.fMin = d5;
        this.kRestart = this.konvge - n5;
        if (this.xErrorsEntered) {
            double[] dArray10 = new double[this.nXarrays];
            double[] dArray11 = new double[2];
            for (int j = 0; j < this.nData; ++j) {
                for (int k = 0; k < this.nXarrays; ++k) {
                    dArray10[k] = this.xData[k][j];
                }
                dArray11 = ((RegressionFunction3)object).function(this.best, dArray10, j);
                this.yCalc[j] = dArray11[0];
                this.weight[j] = Math.sqrt(dArray11[1]);
            }
            this.effectiveNumber();
        }
        if (this.nonLinStatsNeeded) {
            if (this.statFlag) {
                if (!this.ignoreDofFcheck) {
                    if (this.analyticalDerivative) {
                        this.pseudoLinearStats(object, object2);
                    } else {
                        this.pseudoLinearStats(object);
                    }
                }
            } else {
                for (int j = 0; j < n8; ++j) {
                    this.bestSd[j] = Double.NaN;
                }
            }
        }
    }

    protected double sumSquares(Object object, double[] dArray) {
        int n;
        int n2;
        RegressionFunction regressionFunction = null;
        RegressionFunction2 regressionFunction2 = null;
        RegressionFunction3 regressionFunction3 = null;
        switch (this.simplexFlag) {
            case 1: {
                regressionFunction = (RegressionFunction)object;
                break;
            }
            case 2: {
                regressionFunction2 = (RegressionFunction2)object;
                break;
            }
            case 3: 
            case 4: {
                regressionFunction3 = (RegressionFunction3)object;
            }
        }
        double d = -3.0;
        double[] dArray2 = new double[this.nParam];
        double[] dArray3 = new double[this.nXarrays];
        for (int j = 0; j < this.nParam; ++j) {
            dArray2[j] = dArray[j] / this.scale[j];
        }
        double d2 = this.lastSSnoConstraint;
        boolean bl = true;
        if (this.penalty) {
            n2 = 0;
            block21: for (int j = 0; j < this.nConstraints; ++j) {
                n2 = this.penaltyParam[j];
                switch (this.penaltyCheck[j]) {
                    case -1: {
                        if (!(dArray2[n2] < this.constraints[j])) continue block21;
                        d = d2 + this.penaltyWeight * Fmath.square(this.constraints[j] - dArray2[n2]);
                        bl = false;
                        continue block21;
                    }
                    case 0: {
                        if (dArray2[n2] < this.constraints[j] * (1.0 - this.constraintTolerance)) {
                            d = d2 + this.penaltyWeight * Fmath.square(this.constraints[j] * (1.0 - this.constraintTolerance) - dArray2[n2]);
                            bl = false;
                        }
                        if (!(dArray2[n2] > this.constraints[j] * (1.0 + this.constraintTolerance))) continue block21;
                        d = d2 + this.penaltyWeight * Fmath.square(dArray2[n2] - this.constraints[j] * (1.0 + this.constraintTolerance));
                        bl = false;
                        continue block21;
                    }
                    case 1: {
                        if (!(dArray2[n2] > this.constraints[j])) continue block21;
                        d = d2 + this.penaltyWeight * Fmath.square(dArray2[n2] - this.constraints[j]);
                        bl = false;
                        continue block21;
                    }
                    default: {
                        throw new IllegalArgumentException("The " + j + "th penalty check " + this.penaltyCheck[j] + " not recognised");
                    }
                }
            }
        }
        if (this.sumPenalty) {
            n2 = 0;
            double d3 = 0.0;
            block22: for (n = 0; n < this.nSumConstraints; ++n) {
                double d4 = 0.0;
                for (int j = 0; j < this.sumPenaltyNumber[n]; ++j) {
                    n2 = this.sumPenaltyParam[n][j];
                    d3 = this.sumPlusOrMinus[n][j];
                    d4 += dArray2[n2] * d3;
                }
                switch (this.sumPenaltyCheck[n]) {
                    case -1: {
                        if (!(d4 < this.sumConstraints[n])) continue block22;
                        d = d2 + this.penaltyWeight * Fmath.square(this.sumConstraints[n] - d4);
                        bl = false;
                        continue block22;
                    }
                    case 0: {
                        if (d4 < this.sumConstraints[n] * (1.0 - this.constraintTolerance)) {
                            d = d2 + this.penaltyWeight * Fmath.square(this.sumConstraints[n] * (1.0 - this.constraintTolerance) - d4);
                            bl = false;
                        }
                        if (!(d4 > this.sumConstraints[n] * (1.0 + this.constraintTolerance))) continue block22;
                        d = d2 + this.penaltyWeight * Fmath.square(d4 - this.sumConstraints[n] * (1.0 + this.constraintTolerance));
                        bl = false;
                        continue block22;
                    }
                    case 1: {
                        if (!(d4 > this.sumConstraints[n])) continue block22;
                        d = d2 + this.penaltyWeight * Fmath.square(d4 - this.sumConstraints[n]);
                        bl = false;
                        continue block22;
                    }
                    default: {
                        throw new IllegalArgumentException("The " + n + "th summation penalty check " + this.sumPenaltyCheck[n] + " not recognised");
                    }
                }
            }
        }
        if (bl) {
            d = 0.0;
            double d5 = 0.0;
            double[] dArray4 = null;
            block24: for (n = 0; n < this.nData; ++n) {
                for (int j = 0; j < this.nXarrays; ++j) {
                    dArray3[j] = this.xData[j][n];
                }
                switch (this.simplexFlag) {
                    case 1: {
                        d += Fmath.square((this.yData[n] - regressionFunction.function(dArray2, dArray3)) / this.weight[n]);
                        continue block24;
                    }
                    case 2: {
                        d += Fmath.square((this.yData[n] - regressionFunction2.function(dArray2, dArray3, n)) / this.weight[n]);
                        continue block24;
                    }
                    case 3: 
                    case 4: {
                        dArray4 = regressionFunction3.function(dArray2, dArray3, n);
                        d5 = Fmath.square(this.yData[n] - dArray4[0]);
                        this.weight[n] = Math.sqrt(dArray4[1]);
                        d += d5 / dArray4[1];
                    }
                }
            }
            this.lastSSnoConstraint = d;
        }
        return d;
    }

    public void addConstraint(int n, int n2, double d) {
        this.penalty = true;
        if (this.penalties.isEmpty()) {
            this.penalties.add(new Integer(this.constraintMethod));
        }
        if (this.penalties.size() == 1) {
            this.penalties.add(new Integer(1));
        } else {
            int n3 = (Integer)this.penalties.get(1);
            this.penalties.set(1, new Integer(++n3));
        }
        this.penalties.add(new Integer(n));
        this.constrainedSingle.add(new Integer(n));
        this.penalties.add(new Integer(n2));
        String string = "";
        switch (n2) {
            case -1: {
                string = "must be >= " + d;
                break;
            }
            case 0: {
                string = "must = " + d;
                break;
            }
            case 1: {
                string = "must be <= " + d;
                break;
            }
            default: {
                throw new IllegalArgumentException("Constraint direction " + n2 + " not recognised");
            }
        }
        this.constrainedSingle.add(string);
        this.penalties.add(new Double(d));
        if (n > this.maxConstraintIndex) {
            this.maxConstraintIndex = n;
        }
    }

    public void addConstraint(int[] nArray, int[] nArray2, int n, double d) {
        ArrayMaths arrayMaths = new ArrayMaths(nArray2);
        double[] dArray = arrayMaths.getArray_as_double();
        this.addConstraint(nArray, dArray, n, d);
    }

    public void addConstraint(int[] nArray, double[] dArray, int n, double d) {
        int n2;
        int n3 = nArray.length;
        int n4 = dArray.length;
        if (n3 != n4) {
            throw new IllegalArgumentException("num of parameters, " + n3 + ", does not equal number of parameter signs, " + n4);
        }
        this.sumPenalty = true;
        if (this.sumPenalties.isEmpty()) {
            this.sumPenalties.add(new Integer(this.constraintMethod));
        }
        if (this.sumPenalties.size() == 1) {
            this.sumPenalties.add(new Integer(1));
        } else {
            int n5 = (Integer)this.sumPenalties.get(1);
            this.sumPenalties.set(1, new Integer(++n5));
        }
        this.sumPenalties.add(new Integer(n3));
        this.sumPenalties.add(nArray);
        this.sumPenalties.add(dArray);
        this.sumPenalties.add(new Integer(n));
        this.sumPenalties.add(new Double(d));
        ArrayMaths arrayMaths = new ArrayMaths(nArray);
        int n6 = arrayMaths.getMaximum_as_int();
        if (n6 > this.maxConstraintIndex) {
            this.maxConstraintIndex = n6;
        }
        String string = "";
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n7 = nArray[n2];
            if (dArray[n2] >= 0.0) {
                if (n2 > 0) {
                    string = string + " + ";
                }
            } else {
                string = n2 > 0 ? string + " - " : string + "-";
            }
            string = string + "p[" + n7 + "]." + Math.abs(dArray[n2]);
        }
        switch (n) {
            case -1: {
                string = string + " >= " + d;
                break;
            }
            case 0: {
                string = string + " = " + d;
                break;
            }
            case 1: {
                string = string + " <= " + d;
                break;
            }
            default: {
                throw new IllegalArgumentException("Constraint direction " + n + " not recognised");
            }
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.constrainedMultiple.add(new Integer(nArray[n2]));
            this.constrainedMultiple.add(string);
        }
    }

    public void removeConstraints() {
        int n;
        int n2;
        if (!this.penalties.isEmpty()) {
            n2 = this.penalties.size();
            for (n = n2 - 1; n >= 0; --n) {
                this.penalties.remove(n);
            }
        }
        this.penalty = false;
        this.nConstraints = 0;
        this.constrainedSingle.clear();
        if (!this.sumPenalties.isEmpty()) {
            n2 = this.sumPenalties.size();
            for (n = n2 - 1; n >= 0; --n) {
                this.sumPenalties.remove(n);
            }
        }
        this.sumPenalty = false;
        this.nSumConstraints = 0;
        this.maxConstraintIndex = -1;
        this.constrainedMultiple.clear();
    }

    public void setConstraintTolerance(double d) {
        this.constraintTolerance = d;
    }

    protected void generalLinearStats(double[][] dArray) {
        int n;
        int n2;
        int n3;
        int n4;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double[][] dArray2 = new double[this.nParam][this.nParam];
        double[][] dArray3 = new double[this.nParam][this.nParam];
        double[][] dArray4 = new double[this.nParam][this.nParam];
        double[][] dArray5 = new double[this.nParam][this.nParam];
        this.covar = new double[this.nParam][this.nParam];
        this.corrCoeff = new double[this.nParam][this.nParam];
        double[] dArray6 = new double[this.nParam];
        double[] dArray7 = new double[this.nParam];
        for (n4 = 0; n4 < this.nParam; ++n4) {
            dArray7[n4] = this.best[n4];
        }
        this.chiSquare = 0.0;
        this.sumOfSquaresError = 0.0;
        for (n4 = 0; n4 < this.nData; ++n4) {
            d3 = 0.0;
            for (int j = 0; j < this.nParam; ++j) {
                d3 += dArray7[j] * dArray[j][n4];
            }
            this.yCalc[n4] = d3;
            this.residual[n4] = d3 -= this.yData[n4];
            this.sumOfSquaresError += Fmath.square(d3);
        }
        double d4 = this.sumOfSquaresError / (double)this.degreesOfFreedom;
        double d5 = Math.sqrt(d4);
        if (this.weightOpt && !this.trueErrors) {
            double d6 = 0.0;
            for (int j = 0; j < this.nData; ++j) {
                d6 = this.weight[j] * this.weight[j];
            }
            double d7 = Math.sqrt(d4 / (d6 /= (double)this.degreesOfFreedom));
            for (int j = 0; j < this.nData; ++j) {
                this.weight[j] = this.weight[j] * d7;
            }
        }
        for (n3 = 0; n3 < this.nData; ++n3) {
            this.residualW[n3] = this.residual[n3] / this.weight[n3];
            this.chiSquare += Fmath.square(this.residual[n3] / this.weight[n3]);
        }
        this.reducedChiSquare = this.chiSquare / (double)this.degreesOfFreedom;
        if (this.sumOfSquaresError == 0.0) {
            for (n3 = 0; n3 < this.nParam; ++n3) {
                dArray6[n3] = 0.0;
                for (n2 = 0; n2 < this.nParam; ++n2) {
                    this.covar[n3][n2] = 0.0;
                    this.corrCoeff[n3][n2] = n3 == n2 ? 1.0 : 0.0;
                }
            }
        } else {
            for (n3 = 0; n3 < this.nParam; ++n3) {
                for (n2 = 0; n2 < this.nParam; ++n2) {
                    d2 = 0.0;
                    for (int j = 0; j < this.nData; ++j) {
                        d = this.weightOpt ? this.weight[j] : d5;
                        d2 += dArray[n3][j] * dArray[n2][j] / Fmath.square(d);
                    }
                    dArray3[n2][n3] = d2;
                }
            }
            Matrix matrix = new Matrix(dArray3);
            if (this.suppressErrorMessages) {
                matrix.suppressErrorMessage();
            }
            matrix = matrix.inverse();
            dArray4 = matrix.getArrayCopy();
            for (n2 = 0; n2 < this.nParam; ++n2) {
                dArray6[n2] = Math.sqrt(dArray4[n2][n2]);
            }
            for (n2 = 0; n2 < this.nParam; ++n2) {
                for (int j = 0; j < this.nParam; ++j) {
                    this.covar[n2][j] = dArray4[n2][j];
                }
            }
            for (n2 = 0; n2 < this.nParam; ++n2) {
                for (int j = 0; j < this.nParam; ++j) {
                    this.corrCoeff[n2][j] = n2 == j ? 1.0 : this.covar[n2][j] / (dArray6[n2] * dArray6[j]);
                }
            }
        }
        for (n = 0; n < this.nParam; ++n) {
            this.bestSd[n] = dArray6[n];
            this.tValues[n] = this.best[n] / this.bestSd[n];
            double d8 = Math.abs(this.tValues[n]);
            this.pValues[n] = d8 != d8 ? Double.NaN : 1.0 - Stat.studentTcdf(-d8, d8, this.degreesOfFreedom);
        }
        if (this.nXarrays == 1 && this.nYarrays == 1) {
            this.xyR = Stat.corrCoeff(this.xData[0], this.yData, this.weight);
        }
        this.yyR = Stat.corrCoeff(this.yCalc, this.yData, this.weight);
        this.yMean = Stat.mean(this.yData);
        this.yWeightedMean = Stat.mean(this.yData, this.weight);
        this.sumOfSquaresTotal = 0.0;
        for (n = 0; n < this.nData; ++n) {
            this.sumOfSquaresTotal += Fmath.square((this.yData[n] - this.yWeightedMean) / this.weight[n]);
        }
        this.sumOfSquaresRegrn = this.sumOfSquaresTotal - this.chiSquare;
        if (this.sumOfSquaresRegrn < 0.0) {
            this.sumOfSquaresRegrn = 0.0;
        }
        this.multR = this.sumOfSquaresRegrn / this.sumOfSquaresTotal;
        this.adjustedR = Double.NaN;
        this.multipleF = Double.NaN;
        if (this.nData - this.nParam - 1 > 0) {
            this.adjustedR = 1.0 - (1.0 - this.multR) * (double)(this.nData - 1) / (double)(this.nData - this.nParam - 1);
        }
        this.multipleF = this.multR * ((double)(this.nData - this.nParam) - 1.0) / ((1.0 - this.multR) * (double)this.nParam);
        n = this.nData - this.nParam - 1;
        if (this.multipleF >= 0.0 && n > 0) {
            this.multipleFprob = Stat.fTestProb(this.multipleF, this.nXarrays, n);
        }
        this.calcDurbinWatson();
        this.varianceOfObservations();
    }

    protected int pseudoLinearStats(Object object, Object object2) {
        int n;
        int n2;
        int n3;
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        int n4 = 0;
        int n5 = this.nParam;
        double[] dArray = new double[n5];
        double[] dArray2 = new double[n5];
        double[] dArray3 = new double[n5];
        double[] dArray4 = new double[this.nXarrays];
        double[][] dArray5 = new double[n5][n5];
        this.pseudoSd = new double[n5];
        Object var14_12 = null;
        this.grad = new double[n5][2];
        this.covar = new double[n5][n5];
        this.corrCoeff = new double[n5][n5];
        dArray2 = Conv.copy(this.best);
        double d4 = 0.0;
        for (int j = 0; j < this.nData; ++j) {
            for (int k = 0; k < this.nXarrays; ++k) {
                dArray4[k] = this.xData[k][j];
            }
            switch (this.simplexFlag) {
                case 1: {
                    this.yCalc[j] = ((RegressionFunction)object).function(this.best, dArray4);
                    break;
                }
                case 2: {
                    this.yCalc[j] = ((RegressionFunction2)object).function(this.best, dArray4, j);
                    break;
                }
                case 3: 
                case 4: {
                    double[] dArray6 = ((RegressionFunction3)object).function(this.best, dArray4, j);
                    this.yCalc[j] = dArray6[0];
                    this.weight[j] = Math.sqrt(dArray6[1]);
                }
            }
            this.residual[j] = this.yCalc[j] - this.yData[j];
            d4 += Fmath.square(this.residual[j]);
        }
        this.sumOfSquaresError = d4;
        double d5 = d4 / (double)(this.nData - n5);
        double d6 = Math.sqrt(d5);
        if (this.weightOpt && !this.trueErrors) {
            d = 0.0;
            for (int j = 0; j < this.nData; ++j) {
                d = this.weight[j] * this.weight[j];
            }
            double d7 = Math.sqrt(d5 / (d /= (double)this.degreesOfFreedom));
            for (int j = 0; j < this.nData; ++j) {
                this.weight[j] = this.weight[j] * d7;
            }
        }
        d = 0.0;
        for (int j = 0; j < this.nData; ++j) {
            this.residualW[j] = this.residual[j] / this.weight[j];
            d += Fmath.square(this.residualW[j]);
        }
        this.chiSquare = d;
        this.reducedChiSquare = d / (double)(this.nData - n5);
        double d8 = 1.0;
        if (!this.weightOpt && !this.trueFreq) {
            d8 = this.sumOfSquaresError / (double)(this.nData - n5);
        }
        double d9 = 1.0;
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                dArray[n2] = dArray2[n2];
            }
            d9 = dArray2[n3];
            if (d9 == 0.0) {
                d9 = this.stepH[n3];
                this.zeroCheck = true;
            }
            dArray[n3] = d9 * (1.0 - this.delta);
            this.lastSSnoConstraint = this.sumOfSquaresError;
            d2 = this.sumSquares(object, dArray);
            dArray[n3] = d9 * (1.0 + this.delta);
            this.lastSSnoConstraint = this.sumOfSquaresError;
            d3 = this.sumSquares(object, dArray);
            this.grad[n3][0] = (this.fMin - d2) / Math.abs(this.delta * d9);
            this.grad[n3][1] = (d3 - this.fMin) / Math.abs(this.delta * d9);
        }
        this.lastSSnoConstraint = this.sumOfSquaresError;
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                dArray5[n3][n2] = this.secondDerivative(object, object2, dArray2, n3, n2);
            }
        }
        for (n3 = 0; n3 < n5; ++n3) {
            this.pseudoSd[n3] = 2.0 * this.delta * d8 * Math.abs(dArray2[n3]) / (this.grad[n3][1] - this.grad[n3][0]);
            this.pseudoSd[n3] = this.pseudoSd[n3] >= 0.0 ? Math.sqrt(this.pseudoSd[n3]) : Double.NaN;
        }
        if (n5 == 1) {
            dArray5[0][0] = 1.0 / dArray5[0][0];
            this.covar[0][0] = dArray5[0][0] * d8;
            if (this.covar[0][0] >= 0.0) {
                dArray3[0] = Math.sqrt(this.covar[0][0]);
                this.corrCoeff[0][0] = 1.0;
            } else {
                dArray3[0] = Double.NaN;
                this.corrCoeff[0][0] = Double.NaN;
                this.posVarFlag = false;
            }
        } else {
            int n6;
            int n7;
            double d10;
            Matrix matrix = new Matrix(dArray5);
            if (this.suppressErrorMessages) {
                matrix.suppressErrorMessage();
            }
            if ((d10 = matrix.determinant()) == 0.0) {
                this.invertFlag = false;
            } else {
                matrix = matrix.inverse();
                this.invertFlag = matrix.getMatrixCheck();
            }
            if (!this.invertFlag) {
                --n4;
            }
            dArray5 = matrix.getArrayCopy();
            this.posVarFlag = true;
            if (this.invertFlag) {
                for (n7 = 0; n7 < n5; ++n7) {
                    for (n6 = n7; n6 < n5; ++n6) {
                        this.covar[n7][n6] = 2.0 * dArray5[n7][n6] * d8;
                        this.covar[n6][n7] = this.covar[n7][n6];
                    }
                    if (this.covar[n7][n7] >= 0.0) {
                        dArray3[n7] = Math.sqrt(this.covar[n7][n7]);
                        continue;
                    }
                    dArray3[n7] = Double.NaN;
                    this.posVarFlag = false;
                }
                for (n7 = 0; n7 < n5; ++n7) {
                    for (n6 = 0; n6 < n5; ++n6) {
                        this.corrCoeff[n7][n6] = dArray3[n7] != Double.NaN && dArray3[n6] != Double.NaN ? this.covar[n7][n6] / (dArray3[n7] * dArray3[n6]) : Double.NaN;
                    }
                }
            } else {
                for (n7 = 0; n7 < n5; ++n7) {
                    for (n6 = 0; n6 < n5; ++n6) {
                        this.covar[n7][n6] = Double.NaN;
                        this.corrCoeff[n7][n6] = Double.NaN;
                    }
                    dArray3[n7] = Double.NaN;
                }
            }
        }
        if (!this.posVarFlag) {
            --n4;
        }
        for (n = 0; n < this.nParam; ++n) {
            this.bestSd[n] = dArray3[n];
            this.tValues[n] = this.best[n] / this.bestSd[n];
            double d11 = Math.abs(this.tValues[n]);
            this.pValues[n] = d11 != d11 ? Double.NaN : 1.0 - Stat.studentTcdf(-d11, d11, this.degreesOfFreedom);
        }
        if (this.nXarrays == 1 && this.nYarrays == 1) {
            this.xyR = Stat.corrCoeff(this.xData[0], this.yData, this.weight);
        }
        this.yyR = Stat.corrCoeff(this.yCalc, this.yData, this.weight);
        this.yMean = Stat.mean(this.yData);
        this.yWeightedMean = Stat.mean(this.yData, this.weight);
        this.sumOfSquaresTotal = 0.0;
        for (n = 0; n < this.nData; ++n) {
            this.sumOfSquaresTotal += Fmath.square((this.yData[n] - this.yWeightedMean) / this.weight[n]);
        }
        this.sumOfSquaresRegrn = this.sumOfSquaresTotal - this.chiSquare;
        if (this.sumOfSquaresRegrn < 0.0) {
            this.sumOfSquaresRegrn = 0.0;
        }
        this.multR = this.sumOfSquaresRegrn / this.sumOfSquaresTotal;
        this.adjustedR = Double.NaN;
        this.multipleF = Double.NaN;
        if (this.nData - this.nXarrays - 1 > 0) {
            this.adjustedR = 1.0 - (1.0 - this.multR) * (double)(this.nData - 1) / (double)(this.nData - this.nXarrays - 1);
        }
        this.multipleF = this.multR * ((double)(this.nData - this.nXarrays) - 1.0) / ((1.0 - this.multR) * (double)this.nXarrays);
        n = this.nData - this.nXarrays - 1;
        if (this.multipleF >= 0.0 && n > 0) {
            this.multipleFprob = Stat.fTestProb(this.multipleF, this.nXarrays, n);
        }
        this.calcDurbinWatson();
        this.varianceOfObservations();
        return n4;
    }

    protected int pseudoLinearStats(Object object) {
        double d;
        int n;
        int n2;
        int n3;
        int n4;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n5 = 0;
        int n6 = this.nParam;
        double[] dArray = new double[n6];
        double[] dArray2 = new double[n6];
        double[] dArray3 = new double[n6];
        double[] dArray4 = new double[this.nXarrays];
        double[][] dArray5 = new double[n6][n6];
        this.pseudoSd = new double[n6];
        Object var17_13 = null;
        this.grad = new double[n6][2];
        this.covar = new double[n6][n6];
        this.corrCoeff = new double[n6][n6];
        dArray2 = Conv.copy(this.best);
        double d6 = 1.0;
        double d7 = 1.0;
        this.firstDerivs = new double[this.nParam][this.nData];
        for (n4 = 0; n4 < n6; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                dArray[n3] = dArray2[n3];
            }
            d6 = dArray2[n4];
            if (d6 == 0.0) {
                d6 = this.stepH[n4];
                this.zeroCheck = true;
            }
            dArray[n4] = d6 * (1.0 - this.delta);
            this.lastSSnoConstraint = this.sumOfSquaresError;
            d2 = this.sumSquares(object, dArray);
            block17: for (n3 = 0; n3 < this.nData; ++n3) {
                for (n2 = 0; n2 < this.nXarrays; ++n2) {
                    dArray4[n2] = this.xData[n2][n3];
                }
                switch (this.simplexFlag) {
                    case 1: {
                        this.firstDerivs[n4][n3] = -((RegressionFunction)object).function(dArray, dArray4) / Math.abs(this.delta * 2.0 * d6);
                        continue block17;
                    }
                    case 2: {
                        this.firstDerivs[n4][n3] = -((RegressionFunction2)object).function(dArray, dArray4, n3) / Math.abs(this.delta * 2.0 * d6);
                        continue block17;
                    }
                    case 3: 
                    case 4: {
                        this.firstDerivs[n4][n3] = -((RegressionFunction3)object).function(dArray, dArray4, n3)[0] / Math.abs(this.delta * 2.0 * d6);
                    }
                }
            }
            dArray[n4] = d6 * (1.0 + this.delta);
            this.lastSSnoConstraint = this.sumOfSquaresError;
            d3 = this.sumSquares(object, dArray);
            block19: for (n3 = 0; n3 < this.nData; ++n3) {
                for (n2 = 0; n2 < this.nXarrays; ++n2) {
                    dArray4[n2] = this.xData[n2][n3];
                }
                switch (this.simplexFlag) {
                    case 1: {
                        this.firstDerivs[n4][n3] = -((RegressionFunction)object).function(dArray, dArray4) / Math.abs(this.delta * 2.0 * d6);
                        continue block19;
                    }
                    case 2: {
                        this.firstDerivs[n4][n3] = -((RegressionFunction2)object).function(dArray, dArray4, n3) / Math.abs(this.delta * 2.0 * d6);
                        continue block19;
                    }
                    case 3: 
                    case 4: {
                        this.firstDerivs[n4][n3] = -((RegressionFunction3)object).function(dArray, dArray4, n3)[0] / Math.abs(this.delta * 2.0 * d6);
                    }
                }
            }
            this.grad[n4][0] = (this.fMin - d2) / Math.abs(this.delta * d6);
            this.grad[n4][1] = (d3 - this.fMin) / Math.abs(this.delta * d6);
        }
        this.lastSSnoConstraint = this.sumOfSquaresError;
        for (n4 = 0; n4 < n6; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                for (n2 = 0; n2 < n6; ++n2) {
                    dArray[n2] = dArray2[n2];
                }
                d6 = dArray[n4];
                if (d6 == 0.0) {
                    d6 = this.stepH[n4];
                    this.zeroCheck = true;
                }
                dArray[n4] = d6 * (1.0 + this.delta / 2.0);
                d6 = dArray[n3];
                if (d6 == 0.0) {
                    d6 = this.stepH[n3];
                    this.zeroCheck = true;
                }
                dArray[n3] = d6 * (1.0 + this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquaresError;
                d2 = this.sumSquares(object, dArray);
                dArray[n4] = dArray2[n4];
                dArray[n3] = dArray2[n3];
                d6 = dArray[n4];
                if (d6 == 0.0) {
                    d6 = this.stepH[n4];
                    this.zeroCheck = true;
                }
                dArray[n4] = d6 * (1.0 - this.delta / 2.0);
                d6 = dArray[n3];
                if (d6 == 0.0) {
                    d6 = this.stepH[n3];
                    this.zeroCheck = true;
                }
                dArray[n3] = d6 * (1.0 + this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquaresError;
                d3 = this.sumSquares(object, dArray);
                dArray[n4] = dArray2[n4];
                dArray[n3] = dArray2[n3];
                d6 = dArray[n4];
                if (d6 == 0.0) {
                    d6 = this.stepH[n4];
                    this.zeroCheck = true;
                }
                dArray[n4] = d6 * (1.0 + this.delta / 2.0);
                d6 = dArray[n3];
                if (d6 == 0.0) {
                    d6 = this.stepH[n3];
                    this.zeroCheck = true;
                }
                dArray[n3] = d6 * (1.0 - this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquaresError;
                d4 = this.sumSquares(object, dArray);
                dArray[n4] = dArray2[n4];
                dArray[n3] = dArray2[n3];
                d6 = dArray[n4];
                if (d6 == 0.0) {
                    d6 = this.stepH[n4];
                    this.zeroCheck = true;
                }
                dArray[n4] = d6 * (1.0 - this.delta / 2.0);
                d6 = dArray[n3];
                if (d6 == 0.0) {
                    d6 = this.stepH[n3];
                    this.zeroCheck = true;
                }
                dArray[n3] = d6 * (1.0 - this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquaresError;
                d5 = this.sumSquares(object, dArray);
                dArray5[n4][n3] = (d2 - d3 - d4 + d5) / (this.delta * this.delta);
            }
        }
        double d8 = 0.0;
        double d9 = 0.0;
        for (int j = 0; j < this.nData; ++j) {
            for (int k = 0; k < this.nXarrays; ++k) {
                dArray4[k] = this.xData[k][j];
            }
            switch (this.simplexFlag) {
                case 1: {
                    this.yCalc[j] = ((RegressionFunction)object).function(dArray2, dArray4);
                    break;
                }
                case 2: {
                    this.yCalc[j] = ((RegressionFunction2)object).function(dArray2, dArray4, j);
                    break;
                }
                case 3: 
                case 4: {
                    double[] dArray6 = ((RegressionFunction3)object).function(dArray2, dArray4, j);
                    this.yCalc[j] = dArray6[0];
                    this.weight[j] = Math.sqrt(dArray6[1]);
                }
            }
            this.residual[j] = this.yCalc[j] - this.yData[j];
            d8 += Fmath.square(this.residual[j]);
            this.residualW[j] = this.residual[j] / this.weight[j];
            d9 += Fmath.square(this.residualW[j]);
        }
        this.sumOfSquaresError = d8;
        double d10 = d8 / (double)(this.nData - n6);
        double d11 = Math.sqrt(d10);
        this.chiSquare = d9;
        this.reducedChiSquare = d9 / (double)(this.nData - n6);
        double d12 = 1.0;
        if (!this.weightOpt && !this.trueFreq) {
            d12 = this.sumOfSquaresError / (double)(this.nData - n6);
        }
        for (n = 0; n < n6; ++n) {
            this.pseudoSd[n] = 2.0 * this.delta * d12 * Math.abs(dArray2[n]) / (this.grad[n][1] - this.grad[n][0]);
            this.pseudoSd[n] = this.pseudoSd[n] >= 0.0 ? Math.sqrt(this.pseudoSd[n]) : Double.NaN;
        }
        if (n6 == 1) {
            d6 = dArray2[0];
            if (d6 == 0.0) {
                d6 = this.stepH[0];
            }
            dArray5[0][0] = 1.0 / dArray5[0][0];
            this.covar[0][0] = dArray5[0][0] * d12 * d6 * d6;
            if (this.covar[0][0] >= 0.0) {
                dArray3[0] = Math.sqrt(this.covar[0][0]);
                this.corrCoeff[0][0] = 1.0;
            } else {
                dArray3[0] = Double.NaN;
                this.corrCoeff[0][0] = Double.NaN;
                this.posVarFlag = false;
            }
        } else {
            int n7;
            int n8;
            Matrix matrix = new Matrix(dArray5);
            if (this.suppressErrorMessages) {
                matrix.suppressErrorMessage();
            }
            if ((d = matrix.determinant()) == 0.0) {
                this.invertFlag = false;
            } else {
                matrix = matrix.inverse();
                this.invertFlag = matrix.getMatrixCheck();
            }
            if (!this.invertFlag) {
                --n5;
            }
            dArray5 = matrix.getArrayCopy();
            this.posVarFlag = true;
            if (this.invertFlag) {
                for (n8 = 0; n8 < n6; ++n8) {
                    d6 = dArray2[n8];
                    if (d6 == 0.0) {
                        d6 = this.stepH[n8];
                    }
                    for (n7 = n8; n7 < n6; ++n7) {
                        d7 = dArray2[n7];
                        if (d7 == 0.0) {
                            d7 = this.stepH[n7];
                        }
                        this.covar[n8][n7] = 2.0 * dArray5[n8][n7] * d12 * d6 * d7;
                        this.covar[n7][n8] = this.covar[n8][n7];
                    }
                    if (this.covar[n8][n8] >= 0.0) {
                        dArray3[n8] = Math.sqrt(this.covar[n8][n8]);
                        continue;
                    }
                    dArray3[n8] = Double.NaN;
                    this.posVarFlag = false;
                }
                for (n8 = 0; n8 < n6; ++n8) {
                    for (n7 = 0; n7 < n6; ++n7) {
                        this.corrCoeff[n8][n7] = dArray3[n8] != Double.NaN && dArray3[n7] != Double.NaN ? this.covar[n8][n7] / (dArray3[n8] * dArray3[n7]) : Double.NaN;
                    }
                }
            } else {
                for (n8 = 0; n8 < n6; ++n8) {
                    for (n7 = 0; n7 < n6; ++n7) {
                        this.covar[n8][n7] = Double.NaN;
                        this.corrCoeff[n8][n7] = Double.NaN;
                    }
                    dArray3[n8] = Double.NaN;
                }
            }
        }
        if (!this.posVarFlag) {
            --n5;
        }
        for (n = 0; n < this.nParam; ++n) {
            this.bestSd[n] = dArray3[n];
            this.tValues[n] = this.best[n] / this.bestSd[n];
            d = Math.abs(this.tValues[n]);
            this.pValues[n] = d != d ? Double.NaN : 1.0 - Stat.studentTcdf(-d, d, this.degreesOfFreedom);
        }
        if (this.nXarrays == 1 && this.nYarrays == 1) {
            this.xyR = Stat.corrCoeff(this.xData[0], this.yData, this.weight);
        }
        this.yyR = Stat.corrCoeff(this.yCalc, this.yData, this.weight);
        this.yMean = Stat.mean(this.yData);
        this.yWeightedMean = Stat.mean(this.yData, this.weight);
        this.sumOfSquaresTotal = 0.0;
        for (n = 0; n < this.nData; ++n) {
            this.sumOfSquaresTotal += Fmath.square((this.yData[n] - this.yWeightedMean) / this.weight[n]);
        }
        this.sumOfSquaresRegrn = this.sumOfSquaresTotal - this.chiSquare;
        if (this.sumOfSquaresRegrn < 0.0) {
            this.sumOfSquaresRegrn = 0.0;
        }
        this.multR = this.sumOfSquaresRegrn / this.sumOfSquaresTotal;
        this.adjustedR = Double.NaN;
        this.multipleF = Double.NaN;
        if (this.nData - this.nXarrays - 1 > 0) {
            this.adjustedR = 1.0 - (1.0 - this.multR) * (double)(this.nData - 1) / (double)(this.nData - this.nXarrays - 1);
        }
        this.multipleF = this.multR * ((double)(this.nData - this.nXarrays) - 1.0) / ((1.0 - this.multR) * (double)this.nXarrays);
        n = this.nData - this.nXarrays - 1;
        if (this.multipleF >= 0.0 && n > 0) {
            this.multipleFprob = Stat.fTestProb(this.multipleF, this.nXarrays, n);
        }
        this.calcDurbinWatson();
        this.varianceOfObservations();
        return n5;
    }

    private double secondDerivative(Object object, Object object2, double[] dArray, int n, int n2) {
        if (n == 0 && n2 == 0) {
            this.firstDerivs = new double[this.nParam][this.nData];
        }
        double[] dArray2 = null;
        double[] dArray3 = new double[this.nXarrays];
        double d = 0.0;
        switch (this.simplexFlag) {
            case 1: {
                RegressionDerivativeFunction regressionDerivativeFunction = (RegressionDerivativeFunction)object2;
                RegressionFunction regressionFunction = (RegressionFunction)object;
                for (int j = 0; j < this.nData; ++j) {
                    for (int k = 0; k < this.nXarrays; ++k) {
                        dArray3[k] = this.xData[k][j];
                    }
                    dArray2 = regressionDerivativeFunction.function(dArray, dArray3, n, n2);
                    d += (2.0 * dArray2[0] * dArray2[1] + 2.0 * dArray2[2] * (regressionFunction.function(dArray, dArray3) - this.yData[j])) / (this.weight[j] * this.weight[j]);
                    if (n != 0) continue;
                    this.firstDerivs[n2][j] = dArray2[1];
                }
                break;
            }
            case 2: {
                RegressionDerivativeFunction2 regressionDerivativeFunction2 = (RegressionDerivativeFunction2)object2;
                RegressionFunction2 regressionFunction2 = (RegressionFunction2)object;
                for (int j = 0; j < this.nData; ++j) {
                    for (int k = 0; k < this.nXarrays; ++k) {
                        dArray3[k] = this.xData[k][j];
                    }
                    dArray2 = regressionDerivativeFunction2.function(dArray, dArray3, n, n2, j);
                    d += (2.0 * dArray2[0] * dArray2[1] + 2.0 * dArray2[2] * (regressionFunction2.function(dArray, dArray3, j) - this.yData[j])) / (this.weight[j] * this.weight[j]);
                    if (n != 0) continue;
                    this.firstDerivs[n2][j] = dArray2[1];
                }
                break;
            }
            case 3: 
            case 4: {
                if (this.derivFlag == 1) {
                    RegressionDerivativeFunction regressionDerivativeFunction = (RegressionDerivativeFunction)object2;
                    RegressionFunction3 regressionFunction3 = (RegressionFunction3)object;
                    for (int j = 0; j < this.nData; ++j) {
                        for (int k = 0; k < this.nXarrays; ++k) {
                            dArray3[k] = this.xData[k][j];
                        }
                        dArray2 = regressionDerivativeFunction.function(dArray, dArray3, n, n2);
                        d += (2.0 * dArray2[0] * dArray2[1] + 2.0 * dArray2[2] * (regressionFunction3.function(dArray, dArray3, j)[0] - this.yData[j])) / (this.weight[j] * this.weight[j]);
                        if (n != 0) continue;
                        this.firstDerivs[n2][j] = dArray2[1];
                    }
                } else {
                    RegressionDerivativeFunction2 regressionDerivativeFunction2 = (RegressionDerivativeFunction2)object2;
                    RegressionFunction3 regressionFunction3 = (RegressionFunction3)object;
                    for (int j = 0; j < this.nData; ++j) {
                        for (int k = 0; k < this.nXarrays; ++k) {
                            dArray3[k] = this.xData[k][j];
                        }
                        dArray2 = regressionDerivativeFunction2.function(dArray, dArray3, n, n2, j);
                        d += (2.0 * dArray2[0] * dArray2[1] + 2.0 * dArray2[2] * (regressionFunction3.function(dArray, dArray3, j)[0] - this.yData[j])) / (this.weight[j] * this.weight[j]);
                        if (n != 0) continue;
                        this.firstDerivs[n2][j] = dArray2[1];
                    }
                }
                break;
            }
        }
        return d;
    }

    protected void calcDurbinWatson() {
        double d = 0.0;
        double d2 = 0.0;
        for (int j = 1; j < this.nData; ++j) {
            d2 = this.residual[j] - this.residual[j - 1];
            d += d2 * d2;
        }
        double d3 = 0.0;
        for (int j = 0; j < this.nData; ++j) {
            d3 += this.residual[j] * this.residual[j];
        }
        this.dDurbinWatson = d / d3;
        this.dDurbinWatsonDone = true;
    }

    protected double getDurbinWatsonD() {
        if (!this.dDurbinWatsonDone) {
            this.calcDurbinWatson();
        }
        return this.dDurbinWatson;
    }

    protected void checkResidualNormality() {
        this.checkResidualNormality(this.residual);
    }

    protected void checkResidualNormality(double[] dArray) {
        Normality normality = new Normality(dArray);
        normality.fullAnalysis();
    }

    protected void checkWeightedResidualNormality() {
        this.checkResidualNormality(this.residualW);
    }

    protected void varianceOfObservations() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int j = 0; j < this.nData; ++j) {
            d = 1.0 / this.weight[j];
            d *= d;
            d2 += this.residual[j] * this.residual[j] * d;
            d3 += d;
            d4 += d * d;
        }
        this.obsnVariance = d2 * d3 / (d3 * d3 - (double)this.nParam * d4);
    }

    public void simplex(RegressionFunction regressionFunction, double[] dArray, double[] dArray2, double d, int n) {
        this.simplexFlag = 1;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction, dArray, dArray2, d, n);
    }

    public void simplex(RegressionFunction2 regressionFunction2, double[] dArray, double[] dArray2, double d, int n) {
        this.simplexFlag = 2;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction2, dArray, dArray2, d, n);
    }

    public void simplex(RegressionFunction3 regressionFunction3, double[] dArray, double[] dArray2, double d, int n) {
        this.simplexFlag = 3;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplex((Object)regressionFunction3, dArray, dArray2, d, n);
    }

    public void simplex(Object object, double[] dArray, double[] dArray2, double d, int n) {
        this.analyticalDerivative = false;
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(object, null, dArray, dArray2, d, n);
    }

    public void simplex(RegressionFunction regressionFunction, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double[] dArray2, double d, int n) {
        this.simplexFlag = 1;
        this.dualErrorsRequired = false;
        this.derivFlag = 1;
        this.simplex((Object)regressionFunction, (Object)regressionDerivativeFunction, dArray, dArray2, d, n);
    }

    public void simplex(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2, double d, int n) {
        this.simplexFlag = 2;
        this.dualErrorsRequired = false;
        this.derivFlag = 2;
        this.simplex((Object)regressionFunction2, (Object)regressionDerivativeFunction2, dArray, dArray2, d, n);
    }

    public void simplex(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double[] dArray2, double d, int n) {
        this.simplexFlag = 3;
        this.dualErrorsRequired = false;
        this.derivFlag = 1;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.simplex((Object)regressionFunction3, (Object)regressionDerivativeFunction, dArray, dArray2, d, n);
    }

    public void simplex(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2, double d, int n) {
        this.simplexFlag = 3;
        this.derivFlag = 2;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplex((Object)regressionFunction3, (Object)regressionDerivativeFunction2, dArray, dArray2, d, n);
    }

    public void simplex(Object object, Object object2, double[] dArray, double[] dArray2, double d, int n) {
        this.analyticalDerivative = true;
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(object, object2, dArray, dArray2, d, n);
    }

    public void simplexPlot(RegressionFunction regressionFunction, double[] dArray, double[] dArray2, double d, int n) {
        this.simplexFlag = 1;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction, dArray, dArray2, d, n);
    }

    public void simplexPlot(RegressionFunction2 regressionFunction2, double[] dArray, double[] dArray2, double d, int n) {
        this.simplexFlag = 2;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction2, dArray, dArray2, d, n);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, double[] dArray, double[] dArray2, double d, int n) {
        this.simplexFlag = 3;
        this.dualErrorsRequired = true;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.simplexPlot((Object)regressionFunction3, dArray, dArray2, d, n);
    }

    public void simplexPlot(Object object, double[] dArray, double[] dArray2, double d, int n) {
        this.analyticalDerivative = false;
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.dualErrorsRequired = true;
        this.nelderMead(object, null, dArray, dArray2, d, n);
        if (!this.suppressPrint) {
            this.print();
        }
        int n2 = 0;
        if (this.xData.length < 2 && !this.multipleY) {
            n2 = this.plotXY(object);
        }
        if (n2 != -2 && !this.suppressYYplot) {
            this.plotYY();
        }
    }

    public void simplexPlot(RegressionFunction regressionFunction, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double[] dArray2, double d, int n) {
        this.simplexFlag = 1;
        this.dualErrorsRequired = false;
        this.derivFlag = 1;
        this.simplexPlot((Object)regressionFunction, (Object)regressionDerivativeFunction, dArray, dArray2, d, n);
    }

    public void simplexPlot(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2, double d, int n) {
        this.simplexFlag = 2;
        this.derivFlag = 2;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction2, (Object)regressionDerivativeFunction2, dArray, dArray2, d, n);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double[] dArray2, double d, int n) {
        this.simplexFlag = 3;
        this.derivFlag = 1;
        this.dualErrorsRequired = true;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.simplexPlot((Object)regressionFunction3, (Object)regressionDerivativeFunction, dArray, dArray2, d, n);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2, double d, int n) {
        this.simplexFlag = 3;
        this.derivFlag = 2;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplexPlot((Object)regressionFunction3, (Object)regressionDerivativeFunction2, dArray, dArray2, d, n);
    }

    public void simplexPlot(Object object, Object object2, double[] dArray, double[] dArray2, double d, int n) {
        this.analyticalDerivative = true;
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(object, object2, dArray, dArray2, d, n);
        if (!this.suppressPrint) {
            this.print();
        }
        int n2 = 0;
        if (this.xData.length < 2 && !this.multipleY) {
            n2 = this.plotXY(object);
        }
        if (n2 != -2 && !this.suppressYYplot) {
            this.plotYY();
        }
    }

    public void simplex(RegressionFunction regressionFunction, double[] dArray, double[] dArray2, double d) {
        this.simplexFlag = 1;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction, dArray, dArray2, d);
    }

    public void simplex(RegressionFunction2 regressionFunction2, double[] dArray, double[] dArray2, double d) {
        this.simplexFlag = 2;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction2, dArray, dArray2, d);
    }

    public void simplex(RegressionFunction3 regressionFunction3, double[] dArray, double[] dArray2, double d) {
        this.simplexFlag = 3;
        this.dualErrorsRequired = true;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.simplex((Object)regressionFunction3, dArray, dArray2, d);
    }

    public void simplex(Object object, double[] dArray, double[] dArray2, double d) {
        this.simplex(object, dArray, dArray2, d, this.nMax);
    }

    public void simplex(RegressionFunction regressionFunction, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double[] dArray2, double d) {
        this.simplexFlag = 1;
        this.derivFlag = 1;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction, (Object)regressionDerivativeFunction, dArray, dArray2, d);
    }

    public void simplex(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2, double d) {
        this.simplexFlag = 2;
        this.derivFlag = 2;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction2, (Object)regressionDerivativeFunction2, dArray, dArray2, d);
    }

    public void simplex(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double[] dArray2, double d) {
        this.simplexFlag = 3;
        this.derivFlag = 1;
        this.dualErrorsRequired = true;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.simplex((Object)regressionFunction3, (Object)regressionDerivativeFunction, dArray, dArray2, d);
    }

    public void simplex(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2, double d) {
        this.simplexFlag = 3;
        this.derivFlag = 2;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplex((Object)regressionFunction3, (Object)regressionDerivativeFunction2, dArray, dArray2, d);
    }

    public void simplex(Object object, Object object2, double[] dArray, double[] dArray2, double d) {
        this.simplex(object, object2, dArray, dArray2, d, this.nMax);
    }

    public void simplexPlot(RegressionFunction regressionFunction, double[] dArray, double[] dArray2, double d) {
        this.simplexFlag = 1;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction, dArray, dArray2, d);
    }

    public void simplexPlot(RegressionFunction2 regressionFunction2, double[] dArray, double[] dArray2, double d) {
        this.simplexFlag = 2;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction2, dArray, dArray2, d);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, double[] dArray, double[] dArray2, double d) {
        this.simplexFlag = 3;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplexPlot((Object)regressionFunction3, dArray, dArray2, d);
    }

    public void simplexPlot(Object object, double[] dArray, double[] dArray2, double d) {
        this.simplexPlot(object, dArray, dArray2, d, this.nMax);
    }

    public void simplexPlot(RegressionFunction regressionFunction, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double[] dArray2, double d) {
        this.simplexFlag = 1;
        this.derivFlag = 1;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction, (Object)regressionDerivativeFunction, dArray, dArray2, d);
    }

    public void simplexPlot(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2, double d) {
        this.simplexFlag = 2;
        this.derivFlag = 2;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction2, (Object)regressionDerivativeFunction2, dArray, dArray2, d);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double[] dArray2, double d) {
        this.simplexFlag = 3;
        this.derivFlag = 1;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplexPlot((Object)regressionFunction3, (Object)regressionDerivativeFunction, dArray, dArray2, d);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2, double d) {
        this.simplexFlag = 3;
        this.derivFlag = 2;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplexPlot((Object)regressionFunction3, (Object)regressionDerivativeFunction2, dArray, dArray2, d);
    }

    public void simplexPlot(Object object, Object object2, double[] dArray, double[] dArray2, double d) {
        this.simplexPlot(object, object2, dArray, dArray2, d, this.nMax);
    }

    public void simplex(RegressionFunction regressionFunction, double[] dArray, double[] dArray2, int n) {
        this.simplexFlag = 1;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction, dArray, dArray2, n);
    }

    public void simplex(RegressionFunction2 regressionFunction2, double[] dArray, double[] dArray2, int n) {
        this.simplexFlag = 2;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction2, dArray, dArray2, n);
    }

    public void simplex(RegressionFunction3 regressionFunction3, double[] dArray, double[] dArray2, int n) {
        this.simplexFlag = 3;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplex((Object)regressionFunction3, dArray, dArray2, n);
    }

    public void simplex(Object object, double[] dArray, double[] dArray2, int n) {
        this.simplex(object, dArray, dArray2, this.fTol, n);
    }

    public void simplex(RegressionFunction regressionFunction, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double[] dArray2, int n) {
        this.simplexFlag = 1;
        this.derivFlag = 1;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction, (Object)regressionDerivativeFunction, dArray, dArray2, n);
    }

    public void simplex(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2, int n) {
        this.simplexFlag = 2;
        this.derivFlag = 2;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction2, (Object)regressionDerivativeFunction2, dArray, dArray2, n);
    }

    public void simplex(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double[] dArray2, int n) {
        this.simplexFlag = 3;
        this.derivFlag = 1;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplex((Object)regressionFunction3, (Object)regressionDerivativeFunction, dArray, dArray2, n);
    }

    public void simplex(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2, int n) {
        this.simplexFlag = 3;
        this.derivFlag = 2;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplex((Object)regressionFunction3, (Object)regressionDerivativeFunction2, dArray, dArray2, n);
    }

    public void simplex(Object object, Object object2, double[] dArray, double[] dArray2, int n) {
        this.simplex(object, object2, dArray, dArray2, this.fTol, n);
    }

    public void simplexPlot(RegressionFunction regressionFunction, double[] dArray, double[] dArray2, int n) {
        this.simplexFlag = 1;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction, dArray, dArray2, n);
    }

    public void simplexPlot(RegressionFunction2 regressionFunction2, double[] dArray, double[] dArray2, int n) {
        this.simplexFlag = 2;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction2, dArray, dArray2, n);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, double[] dArray, double[] dArray2, int n) {
        this.simplexFlag = 3;
        this.dualErrorsRequired = true;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.simplexPlot((Object)regressionFunction3, dArray, dArray2, n);
    }

    public void simplexPlot(Object object, double[] dArray, double[] dArray2, int n) {
        this.simplexPlot(object, dArray, dArray2, this.fTol, n);
    }

    public void simplexPlot(RegressionFunction regressionFunction, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double[] dArray2, int n) {
        this.simplexFlag = 1;
        this.derivFlag = 1;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction, (Object)regressionDerivativeFunction, dArray, dArray2, n);
    }

    public void simplexPlot(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2, int n) {
        this.simplexFlag = 2;
        this.derivFlag = 2;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction2, (Object)regressionDerivativeFunction2, dArray, dArray2, n);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double[] dArray2, int n) {
        this.simplexFlag = 3;
        this.derivFlag = 1;
        this.dualErrorsRequired = true;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.simplexPlot((Object)regressionFunction3, (Object)regressionDerivativeFunction, dArray, dArray2, n);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2, int n) {
        this.simplexFlag = 3;
        this.derivFlag = 2;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplexPlot((Object)regressionFunction3, (Object)regressionDerivativeFunction2, dArray, dArray2, n);
    }

    public void simplexPlot(Object object, Object object2, double[] dArray, double[] dArray2, int n) {
        this.simplexPlot(object, object2, dArray, dArray2, this.fTol, n);
    }

    public void simplex(RegressionFunction regressionFunction, double[] dArray, double[] dArray2) {
        this.simplexFlag = 1;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction, dArray, dArray2);
    }

    public void simplex(RegressionFunction2 regressionFunction2, double[] dArray, double[] dArray2) {
        this.simplexFlag = 2;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction2, dArray, dArray2);
    }

    public void simplex(RegressionFunction3 regressionFunction3, double[] dArray, double[] dArray2) {
        this.simplexFlag = 3;
        this.dualErrorsRequired = true;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.simplex((Object)regressionFunction3, dArray, dArray2);
    }

    public void simplex(Object object, double[] dArray, double[] dArray2) {
        this.simplex(object, dArray, dArray2, this.fTol, this.nMax);
    }

    public void simplex(RegressionFunction regressionFunction, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double[] dArray2) {
        this.simplexFlag = 1;
        this.derivFlag = 1;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction, (Object)regressionDerivativeFunction, dArray, dArray2);
    }

    public void simplex(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2) {
        this.simplexFlag = 2;
        this.derivFlag = 2;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction2, (Object)regressionDerivativeFunction2, dArray, dArray2);
    }

    public void simplex(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double[] dArray2) {
        this.simplexFlag = 3;
        this.derivFlag = 1;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplex((Object)regressionFunction3, (Object)regressionDerivativeFunction, dArray, dArray2);
    }

    public void simplex(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2) {
        this.simplexFlag = 3;
        this.derivFlag = 2;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplex((Object)regressionFunction3, (Object)regressionDerivativeFunction2, dArray, dArray2);
    }

    public void simplex(Object object, Object object2, double[] dArray, double[] dArray2) {
        this.simplex(object, object2, dArray, dArray2, this.fTol, this.nMax);
    }

    public void simplexPlot(RegressionFunction regressionFunction, double[] dArray, double[] dArray2) {
        this.simplexFlag = 1;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction, dArray, dArray2);
    }

    public void simplexPlot(RegressionFunction2 regressionFunction2, double[] dArray, double[] dArray2) {
        this.simplexFlag = 2;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction2, dArray, dArray2);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, double[] dArray, double[] dArray2) {
        this.simplexFlag = 3;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplexPlot((Object)regressionFunction3, dArray, dArray2);
    }

    public void simplexPlot(Object object, double[] dArray, double[] dArray2) {
        this.simplexPlot(object, dArray, dArray2, this.fTol, this.nMax);
    }

    public void simplexPlot(RegressionFunction regressionFunction, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double[] dArray2) {
        this.simplexFlag = 1;
        this.derivFlag = 1;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction, (Object)regressionDerivativeFunction, dArray, dArray2);
    }

    public void simplexPlot(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2) {
        this.simplexFlag = 2;
        this.derivFlag = 2;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction2, (Object)regressionDerivativeFunction2, dArray, dArray2);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double[] dArray2) {
        this.simplexFlag = 3;
        this.derivFlag = 1;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplexPlot((Object)regressionFunction3, (Object)regressionDerivativeFunction, dArray, dArray2);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2) {
        this.simplexFlag = 3;
        this.derivFlag = 2;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplexPlot((Object)regressionFunction3, (Object)regressionDerivativeFunction2, dArray, dArray2);
    }

    public void simplexPlot(Object object, Object object2, double[] dArray, double[] dArray2) {
        this.simplexPlot(object, object2, dArray, dArray2, this.fTol, this.nMax);
    }

    public void simplex(RegressionFunction regressionFunction, double[] dArray, double d, int n) {
        this.simplexFlag = 1;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction, dArray, d, n);
    }

    public void simplex(RegressionFunction2 regressionFunction2, double[] dArray, double d, int n) {
        this.simplexFlag = 2;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction2, dArray, d, n);
    }

    public void simplex(RegressionFunction3 regressionFunction3, double[] dArray, double d, int n) {
        this.simplexFlag = 3;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplex((Object)regressionFunction3, dArray, d, n);
    }

    public void simplex(Object object, double[] dArray, double d, int n) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        for (int j = 0; j < n2; ++j) {
            dArray2[j] = this.dStep * dArray[j];
        }
        this.simplex(object, dArray, dArray2, d, n);
    }

    public void simplex(RegressionFunction regressionFunction, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double d, int n) {
        this.simplexFlag = 1;
        this.derivFlag = 1;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction, (Object)regressionDerivativeFunction, dArray, d, n);
    }

    public void simplex(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double d, int n) {
        this.simplexFlag = 2;
        this.derivFlag = 2;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction2, (Object)regressionDerivativeFunction2, dArray, d, n);
    }

    public void simplex(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double d, int n) {
        this.simplexFlag = 3;
        this.derivFlag = 1;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplex((Object)regressionFunction3, (Object)regressionDerivativeFunction, dArray, d, n);
    }

    public void simplex(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double d, int n) {
        this.simplexFlag = 3;
        this.derivFlag = 2;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplex((Object)regressionFunction3, (Object)regressionDerivativeFunction2, dArray, d, n);
    }

    public void simplex(Object object, Object object2, double[] dArray, double d, int n) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        for (int j = 0; j < n2; ++j) {
            dArray2[j] = this.dStep * dArray[j];
        }
        this.simplex(object, object2, dArray, dArray2, d, n);
    }

    public void simplexPlot(RegressionFunction regressionFunction, double[] dArray, double d, int n) {
        this.simplexFlag = 1;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction, dArray, d, n);
    }

    public void simplexPlot(RegressionFunction2 regressionFunction2, double[] dArray, double d, int n) {
        this.simplexFlag = 2;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction2, dArray, d, n);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, double[] dArray, double d, int n) {
        this.simplexFlag = 3;
        this.dualErrorsRequired = true;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.simplexPlot((Object)regressionFunction3, dArray, d, n);
    }

    public void simplexPlot(Object object, double[] dArray, double d, int n) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        for (int j = 0; j < n2; ++j) {
            dArray2[j] = this.dStep * dArray[j];
        }
        this.simplexPlot(object, dArray, dArray2, d, n);
    }

    public void simplexPlot(RegressionFunction regressionFunction, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double d, int n) {
        this.simplexFlag = 1;
        this.derivFlag = 1;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction, (Object)regressionDerivativeFunction, dArray, d, n);
    }

    public void simplexPlot(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double d, int n) {
        this.simplexFlag = 2;
        this.derivFlag = 2;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction2, (Object)regressionDerivativeFunction2, dArray, d, n);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double d, int n) {
        this.simplexFlag = 3;
        this.derivFlag = 1;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplexPlot((Object)regressionFunction3, (Object)regressionDerivativeFunction, dArray, d, n);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double d, int n) {
        this.simplexFlag = 3;
        this.derivFlag = 2;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplexPlot((Object)regressionFunction3, (Object)regressionDerivativeFunction2, dArray, d, n);
    }

    public void simplexPlot(Object object, Object object2, double[] dArray, double d, int n) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        for (int j = 0; j < n2; ++j) {
            dArray2[j] = this.dStep * dArray[j];
        }
        this.simplexPlot(object, object2, dArray, dArray2, d, n);
    }

    public void simplex(RegressionFunction regressionFunction, double[] dArray, double d) {
        this.simplexFlag = 1;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction, dArray, d);
    }

    public void simplex(RegressionFunction2 regressionFunction2, double[] dArray, double d) {
        this.simplexFlag = 2;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction2, dArray, d);
    }

    public void simplex(RegressionFunction3 regressionFunction3, double[] dArray, double d) {
        this.simplexFlag = 3;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplex((Object)regressionFunction3, dArray, d);
    }

    public void simplex(Object object, double[] dArray, double d) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = this.dStep * dArray[j];
        }
        this.simplex(object, dArray, dArray2, d, this.nMax);
    }

    public void simplex(RegressionFunction regressionFunction, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double d) {
        this.simplexFlag = 1;
        this.derivFlag = 1;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction, (Object)regressionDerivativeFunction, dArray, d);
    }

    public void simplex(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double d) {
        this.simplexFlag = 2;
        this.derivFlag = 2;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction2, (Object)regressionDerivativeFunction2, dArray, d);
    }

    public void simplex(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double d) {
        this.simplexFlag = 3;
        this.derivFlag = 1;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplex((Object)regressionFunction3, (Object)regressionDerivativeFunction, dArray, d);
    }

    public void simplex(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double d) {
        this.simplexFlag = 3;
        this.derivFlag = 2;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplex((Object)regressionFunction3, (Object)regressionDerivativeFunction2, dArray, d);
    }

    public void simplex(Object object, Object object2, double[] dArray, double d) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = this.dStep * dArray[j];
        }
        this.simplex(object, object2, dArray, dArray2, d, this.nMax);
    }

    public void simplexPlot(RegressionFunction regressionFunction, double[] dArray, double d) {
        this.simplexFlag = 1;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction, dArray, d);
    }

    public void simplexPlot(RegressionFunction2 regressionFunction2, double[] dArray, double d) {
        this.simplexFlag = 2;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction2, dArray, d);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, double[] dArray, double d) {
        this.simplexFlag = 3;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplexPlot((Object)regressionFunction3, dArray, d);
    }

    public void simplexPlot(Object object, double[] dArray, double d) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = this.dStep * dArray[j];
        }
        this.simplexPlot(object, dArray, dArray2, d, this.nMax);
    }

    public void simplexPlot(RegressionFunction regressionFunction, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double d) {
        this.simplexFlag = 1;
        this.derivFlag = 1;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction, (Object)regressionDerivativeFunction, dArray, d);
    }

    public void simplexPlot(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double d) {
        this.simplexFlag = 2;
        this.derivFlag = 2;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction2, (Object)regressionDerivativeFunction2, dArray, d);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, double d) {
        this.simplexFlag = 3;
        this.derivFlag = 1;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplexPlot((Object)regressionFunction3, (Object)regressionDerivativeFunction, dArray, d);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double d) {
        this.simplexFlag = 3;
        this.derivFlag = 2;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplexPlot((Object)regressionFunction3, (Object)regressionDerivativeFunction2, dArray, d);
    }

    public void simplexPlot(Object object, Object object2, double[] dArray, double d) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = this.dStep * dArray[j];
        }
        this.simplexPlot(object, object2, dArray, dArray2, d, this.nMax);
    }

    public void simplex(RegressionFunction regressionFunction, double[] dArray, int n) {
        this.simplexFlag = 1;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction, dArray, n);
    }

    public void simplex(RegressionFunction2 regressionFunction2, double[] dArray, int n) {
        this.simplexFlag = 2;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction2, dArray, n);
    }

    public void simplex(RegressionFunction3 regressionFunction3, double[] dArray, int n) {
        this.simplexFlag = 3;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplex((Object)regressionFunction3, dArray, n);
    }

    public void simplex(Object object, double[] dArray, int n) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        for (int j = 0; j < n2; ++j) {
            dArray2[j] = this.dStep * dArray[j];
        }
        this.simplex(object, dArray, dArray2, this.fTol, n);
    }

    public void simplex(RegressionFunction regressionFunction, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, int n) {
        this.simplexFlag = 1;
        this.derivFlag = 1;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction, (Object)regressionDerivativeFunction, dArray, n);
    }

    public void simplex(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, int n) {
        this.simplexFlag = 2;
        this.derivFlag = 2;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction2, (Object)regressionDerivativeFunction2, dArray, n);
    }

    public void simplex(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, int n) {
        this.simplexFlag = 3;
        this.derivFlag = 1;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplex((Object)regressionFunction3, (Object)regressionDerivativeFunction, dArray, n);
    }

    public void simplex(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, int n) {
        this.simplexFlag = 3;
        this.derivFlag = 2;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplex((Object)regressionFunction3, (Object)regressionDerivativeFunction2, dArray, n);
    }

    public void simplex(Object object, Object object2, double[] dArray, int n) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        for (int j = 0; j < n2; ++j) {
            dArray2[j] = this.dStep * dArray[j];
        }
        this.simplex(object, object2, dArray, dArray2, this.fTol, n);
    }

    public void simplexPlot(RegressionFunction regressionFunction, double[] dArray, int n) {
        this.simplexFlag = 1;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction, dArray, n);
    }

    public void simplexPlot(RegressionFunction2 regressionFunction2, double[] dArray, int n) {
        this.simplexFlag = 2;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction2, dArray, n);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, double[] dArray, int n) {
        this.simplexFlag = 3;
        this.dualErrorsRequired = true;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.simplexPlot((Object)regressionFunction3, dArray, n);
    }

    public void simplexPlot(Object object, double[] dArray, int n) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        for (int j = 0; j < n2; ++j) {
            dArray2[j] = this.dStep * dArray[j];
        }
        this.simplexPlot(object, dArray, dArray2, this.fTol, n);
    }

    public void simplexPlot(RegressionFunction regressionFunction, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, int n) {
        this.simplexFlag = 1;
        this.derivFlag = 1;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction, (Object)regressionDerivativeFunction, dArray, n);
    }

    public void simplexPlot(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, int n) {
        this.simplexFlag = 2;
        this.derivFlag = 2;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction2, (Object)regressionDerivativeFunction2, dArray, n);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray, int n) {
        this.simplexFlag = 3;
        this.derivFlag = 1;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplexPlot((Object)regressionFunction3, (Object)regressionDerivativeFunction, dArray, n);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, int n) {
        this.simplexFlag = 3;
        this.derivFlag = 2;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplexPlot((Object)regressionFunction3, (Object)regressionDerivativeFunction2, dArray, n);
    }

    public void simplexPlot(Object object, Object object2, double[] dArray, int n) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        for (int j = 0; j < n2; ++j) {
            dArray2[j] = this.dStep * dArray[j];
        }
        this.simplexPlot(object, object2, dArray, dArray2, this.fTol, n);
    }

    public void simplex(RegressionFunction regressionFunction, double[] dArray) {
        this.simplexFlag = 1;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction, dArray);
    }

    public void simplex(RegressionFunction2 regressionFunction2, double[] dArray) {
        this.simplexFlag = 2;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction2, dArray);
    }

    public void simplex(RegressionFunction3 regressionFunction3, double[] dArray) {
        this.simplexFlag = 3;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplex((Object)regressionFunction3, dArray);
    }

    public void simplex(Object object, double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = this.dStep * dArray[j];
        }
        this.simplex(object, dArray, dArray2, this.fTol, this.nMax);
    }

    public void simplex(RegressionFunction regressionFunction, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray) {
        this.simplexFlag = 1;
        this.derivFlag = 1;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction, (Object)regressionDerivativeFunction, dArray);
    }

    public void simplex(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray) {
        this.simplexFlag = 2;
        this.derivFlag = 2;
        this.dualErrorsRequired = false;
        this.simplex((Object)regressionFunction2, (Object)regressionDerivativeFunction2, dArray);
    }

    public void simplex(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray) {
        this.simplexFlag = 3;
        this.derivFlag = 1;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplex((Object)regressionFunction3, (Object)regressionDerivativeFunction, dArray);
    }

    public void simplex(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray) {
        this.simplexFlag = 3;
        this.derivFlag = 2;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplex((Object)regressionFunction3, (Object)regressionDerivativeFunction2, dArray);
    }

    public void simplex(Object object, Object object2, double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = this.dStep * dArray[j];
        }
        this.simplex(object, object2, dArray, dArray2, this.fTol, this.nMax);
    }

    public void simplexPlot(RegressionFunction regressionFunction, double[] dArray) {
        this.simplexFlag = 1;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction, dArray);
    }

    public void simplexPlot(RegressionFunction2 regressionFunction2, double[] dArray) {
        this.simplexFlag = 2;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction2, dArray);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, double[] dArray) {
        this.simplexFlag = 3;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplexPlot((Object)regressionFunction3, dArray);
    }

    public void simplexPlot(Object object, double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = this.dStep * dArray[j];
        }
        this.simplexPlot(object, dArray, dArray2, this.fTol, this.nMax);
    }

    public void simplexPlot(RegressionFunction regressionFunction, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray) {
        this.simplexFlag = 1;
        this.derivFlag = 1;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction, (Object)regressionDerivativeFunction, dArray);
    }

    public void simplexPlot(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray) {
        this.simplexFlag = 2;
        this.derivFlag = 2;
        this.dualErrorsRequired = false;
        this.simplexPlot((Object)regressionFunction2, (Object)regressionDerivativeFunction2, dArray);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction regressionDerivativeFunction, double[] dArray) {
        this.simplexFlag = 3;
        this.derivFlag = 1;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplexPlot((Object)regressionFunction3, (Object)regressionDerivativeFunction, dArray);
    }

    public void simplexPlot(RegressionFunction3 regressionFunction3, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray) {
        this.simplexFlag = 3;
        this.derivFlag = 2;
        if (this.multipleY) {
            this.simplexFlag = 4;
        }
        this.dualErrorsRequired = true;
        this.simplexPlot((Object)regressionFunction3, (Object)regressionDerivativeFunction2, dArray);
    }

    public void simplexPlot(Object object, Object object2, double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int j = 0; j < n; ++j) {
            dArray2[j] = this.dStep * dArray[j];
        }
        this.simplexPlot(object, object2, dArray, dArray2, this.fTol, this.nMax);
    }

    public void print(String string, int n) {
        this.prec = n;
        this.print(string);
    }

    public void print(int n) {
        this.prec = n;
        String string = "RegressionOutput.txt";
        this.print(string);
    }

    public void print(String string) {
        int n;
        int n2;
        int n3;
        if (string.indexOf(46) == -1) {
            string = string + ".txt";
        }
        FileOutput fileOutput = new FileOutput(string, 'n');
        fileOutput.dateAndTimeln(string);
        fileOutput.println(this.graphTitle);
        this.paraName = new String[this.nParam];
        this.constraintString = new String[this.nParam];
        for (n3 = 0; n3 < this.nParam; ++n3) {
            this.constraintString[n3] = "none";
        }
        n3 = this.constrainedSingle.size() / 2;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n = (Integer)this.constrainedSingle.get(n4++);
            this.constraintString[n] = (String)this.constrainedSingle.get(n4++);
        }
        n3 = this.constrainedMultiple.size() / 2;
        n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.constraintString[n = ((Integer)this.constrainedMultiple.get(n4++)).intValue()].equals("none")) {
                this.constraintString[n] = (String)this.constrainedMultiple.get(n4++);
                continue;
            }
            int n5 = n;
            this.constraintString[n5] = this.constraintString[n5] + "; " + (String)this.constrainedMultiple.get(n4++);
        }
        if (this.lastMethod == 38) {
            this.paraName = new String[3];
        }
        if (this.bestPolyFlag) {
            fileOutput.println("This is the best fit found by the method bestPolynomial");
        }
        if (this.weightOpt) {
            fileOutput.println("Weighted Least Squares Minimisation");
        } else {
            fileOutput.println("Unweighted Least Squares Minimisation");
        }
        switch (this.lastMethod) {
            case 0: {
                fileOutput.println("Linear Regression with intercept");
                fileOutput.println("y = c[0] + c[1]*x1 + c[2]*x2 +c[3]*x3 + . . .");
                for (n2 = 0; n2 < this.nParam; ++n2) {
                    this.paraName[n2] = "c[" + n2 + "]";
                }
                this.linearPrint(fileOutput);
                break;
            }
            case 1: {
                fileOutput.println("Polynomial (with degree = " + (this.nParam - 1) + "), Fitting: Linear Regression");
                fileOutput.println("y = c[0] + c[1]*x + c[2]*x^2 +c[3]*x^3 + . . .");
                for (n2 = 0; n2 < this.nParam; ++n2) {
                    this.paraName[n2] = "c[" + n2 + "]";
                }
                this.linearPrint(fileOutput);
                break;
            }
            case 2: {
                fileOutput.println("Generalised linear regression");
                fileOutput.println("y = c[0]*f1(x) + c[1]*f2(x) + c[2]*f3(x) + . . .");
                for (n2 = 0; n2 < this.nParam; ++n2) {
                    this.paraName[n2] = "c[" + n2 + "]";
                }
                this.linearPrint(fileOutput);
                break;
            }
            case 3: {
                fileOutput.println("Nelder and Mead Simplex Non-linear Regression");
                fileOutput.println("y = f(x1, x2, x3 . . ., c[0], c[1], c[2] . . .");
                fileOutput.println("y is non-linear with respect to the c[i]");
                for (n2 = 0; n2 < this.nParam; ++n2) {
                    this.paraName[n2] = "c[" + n2 + "]";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 4: {
                fileOutput.println("Fitting to a Normal (Gaussian) distribution");
                fileOutput.println("y = (yscale/(sd.sqrt(2.pi)).exp(0.5.square((x-mean)/sd))");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mean";
                this.paraName[1] = "sd";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 5: {
                fileOutput.println("Fitting to a Lorentzian distribution");
                fileOutput.println("y = (yscale/pi).(gamma/2)/((x-mean)^2+(gamma/2)^2)");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mean";
                this.paraName[1] = "gamma";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 6: {
                fileOutput.println("Fitting to a Poisson distribution");
                fileOutput.println("y = yscale.mu^k.exp(-mu)/mu!");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mean";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 7: {
                fileOutput.println("Fitting to a Two Parameter Minimum Order Statistic Gumbel [Type 1 Extreme Value] Distribution");
                fileOutput.println("y = (yscale/sigma)*exp((x - mu)/sigma))*exp(-exp((x-mu)/sigma))");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mu";
                this.paraName[1] = "sigma";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 8: {
                fileOutput.println("Fitting to a Two Parameter Maximum Order Statistic Gumbel [Type 1 Extreme Value] Distribution");
                fileOutput.println("y = (yscale/sigma)*exp(-(x - mu)/sigma))*exp(-exp(-(x-mu)/sigma))");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mu";
                this.paraName[1] = "sigma";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 9: {
                fileOutput.println("Fitting to a One Parameter Minimum Order Statistic Gumbel [Type 1 Extreme Value] Distribution");
                fileOutput.println("y = (yscale)*exp(x/sigma))*exp(-exp(x/sigma))");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "sigma";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 10: {
                fileOutput.println("Fitting to a One Parameter Maximum Order Statistic Gumbel [Type 1 Extreme Value] Distribution");
                fileOutput.println("y = (yscale)*exp(-x/sigma))*exp(-exp(-x/sigma))");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "sigma";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 11: {
                fileOutput.println("Fitting to a Standard Minimum Order Statistic Gumbel [Type 1 Extreme Value] Distribution");
                fileOutput.println("y = (yscale)*exp(x))*exp(-exp(x))");
                fileOutput.println("Linear regression used to fit y = yscale*z where z = exp(x))*exp(-exp(x)))");
                if (this.scaleFlag) {
                    this.paraName[0] = "y scale";
                }
                this.linearPrint(fileOutput);
                break;
            }
            case 12: {
                fileOutput.println("Fitting to a Standard Maximum Order Statistic Gumbel [Type 1 Extreme Value] Distribution");
                fileOutput.println("y = (yscale)*exp(-x))*exp(-exp(-x))");
                fileOutput.println("Linear regression used to fit y = yscale*z where z = exp(-x))*exp(-exp(-x)))");
                if (this.scaleFlag) {
                    this.paraName[0] = "y scale";
                }
                this.linearPrint(fileOutput);
                break;
            }
            case 13: {
                fileOutput.println("Fitting to a Three Parameter Frechet [Type 2 Extreme Value] Distribution");
                fileOutput.println("y = yscale.(gamma/sigma)*((x - mu)/sigma)^(-gamma-1)*exp(-((x-mu)/sigma)^-gamma");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mu";
                this.paraName[1] = "sigma";
                this.paraName[2] = "gamma";
                if (this.scaleFlag) {
                    this.paraName[3] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 14: {
                fileOutput.println("Fitting to a Two parameter Frechet [Type2  Extreme Value] Distribution");
                fileOutput.println("y = yscale.(gamma/sigma)*(x/sigma)^(-gamma-1)*exp(-(x/sigma)^-gamma");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "sigma";
                this.paraName[1] = "gamma";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 15: {
                fileOutput.println("Fitting to a Standard Frechet [Type 2 Extreme Value] Distribution");
                fileOutput.println("y = yscale.gamma*(x)^(-gamma-1)*exp(-(x)^-gamma");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "gamma";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 16: {
                fileOutput.println("Fitting to a Three parameter Weibull [Type 3 Extreme Value] Distribution");
                fileOutput.println("y = yscale.(gamma/sigma)*((x - mu)/sigma)^(gamma-1)*exp(-((x-mu)/sigma)^gamma");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mu";
                this.paraName[1] = "sigma";
                this.paraName[2] = "gamma";
                if (this.scaleFlag) {
                    this.paraName[3] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 17: {
                fileOutput.println("Fitting to a Two parameter Weibull [Type 3 Extreme Value] Distribution");
                fileOutput.println("y = yscale.(gamma/sigma)*(x/sigma)^(gamma-1)*exp(-(x/sigma)^gamma");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "sigma";
                this.paraName[1] = "gamma";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 18: {
                fileOutput.println("Fitting to a Standard Weibull [Type 3 Extreme Value] Distribution");
                fileOutput.println("y = yscale.gamma*(x)^(gamma-1)*exp(-(x)^gamma");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "gamma";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 19: {
                fileOutput.println("Fitting to a Two parameter Exponential Distribution");
                fileOutput.println("y = (yscale/sigma)*exp(-(x-mu)/sigma)");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mu";
                this.paraName[1] = "sigma";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 20: {
                fileOutput.println("Fitting to a One parameter Exponential Distribution");
                fileOutput.println("y = (yscale/sigma)*exp(-x/sigma)");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "sigma";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 21: {
                fileOutput.println("Fitting to a Standard Exponential Distribution");
                fileOutput.println("y = yscale*exp(-x)");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                if (this.scaleFlag) {
                    this.paraName[0] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 22: {
                fileOutput.println("Fitting to a Rayleigh Distribution");
                fileOutput.println("y = (yscale/sigma)*(x/sigma)*exp(-0.5*(x/sigma)^2)");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "sigma";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 23: {
                fileOutput.println("Fitting to a Two Parameter Pareto Distribution");
                fileOutput.println("y = yscale*(alpha*beta^alpha)/(x^(alpha+1))");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "alpha";
                this.paraName[1] = "beta";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 24: {
                fileOutput.println("Fitting to a One Parameter Pareto Distribution");
                fileOutput.println("y = yscale*(alpha)/(x^(alpha+1))");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "alpha";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 25: {
                fileOutput.println("Fitting to a Sigmoidal Threshold Function");
                fileOutput.println("y = yscale/(1 + exp(-slopeTerm(x - theta)))");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "slope term";
                this.paraName[1] = "theta";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 26: {
                fileOutput.println("Fitting to a Rectangular Hyperbola");
                fileOutput.println("y = yscale.x/(theta + x)");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "theta";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 27: {
                fileOutput.println("Fitting to a Scaled Heaviside Step Function");
                fileOutput.println("y = yscale.H(x - theta)");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "theta";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 28: {
                fileOutput.println("Fitting to a Hill/Sips Sigmoid");
                fileOutput.println("y = yscale.x^n/(theta^n + x^n)");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "theta";
                this.paraName[1] = "n";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 29: {
                fileOutput.println("Fitting to a Shifted Pareto Distribution");
                fileOutput.println("y = yscale*(alpha*beta^alpha)/((x-theta)^(alpha+1))");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "alpha";
                this.paraName[1] = "beta";
                this.paraName[2] = "theta";
                if (this.scaleFlag) {
                    this.paraName[3] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 30: {
                fileOutput.println("Fitting to a Logistic distribution");
                fileOutput.println("y = yscale*exp(-(x-mu)/beta)/(beta*(1 + exp(-(x-mu)/beta))^2");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mu";
                this.paraName[1] = "beta";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 31: {
                fileOutput.println("Fitting to a Beta distribution - [0, 1] interval");
                fileOutput.println("y = yscale*x^(alpha-1)*(1-x)^(beta-1)/B(alpha, beta)");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "alpha";
                this.paraName[1] = "beta";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 32: {
                fileOutput.println("Fitting to a Beta distribution - [min, max] interval");
                fileOutput.println("y = yscale*(x-min)^(alpha-1)*(max-x)^(beta-1)/(B(alpha, beta)*(max-min)^(alpha+beta-1)");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "alpha";
                this.paraName[1] = "beta";
                this.paraName[2] = "min";
                this.paraName[3] = "max";
                if (this.scaleFlag) {
                    this.paraName[4] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 33: {
                fileOutput.println("Fitting to a Three Parameter Gamma distribution");
                fileOutput.println("y = yscale*((x-mu)/beta)^(gamma-1)*exp(-(x-mu)/beta)/(beta*Gamma(gamma))");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mu";
                this.paraName[1] = "beta";
                this.paraName[2] = "gamma";
                if (this.scaleFlag) {
                    this.paraName[3] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 34: {
                fileOutput.println("Fitting to a Standard Gamma distribution");
                fileOutput.println("y = yscale*x^(gamma-1)*exp(-x)/Gamma(gamma)");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "gamma";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 35: {
                fileOutput.println("Fitting to an Erang distribution");
                fileOutput.println("y = yscale*lambda^k*x^(k-1)*exp(-x*lambda)/(k-1)!");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "lambda";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 36: {
                fileOutput.println("Fitting to a two parameter log-normal distribution");
                fileOutput.println("y = (yscale/(x.sigma.sqrt(2.pi)).exp(0.5.square((log(x)-muu)/sigma))");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mu";
                this.paraName[1] = "sigma";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 37: {
                fileOutput.println("Fitting to a three parameter log-normal distribution");
                fileOutput.println("y = (yscale/((x-alpha).beta.sqrt(2.pi)).exp(0.5.square((log(x-alpha)/gamma)/beta))");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "alpha";
                this.paraName[1] = "beta";
                this.paraName[2] = "gamma";
                if (this.scaleFlag) {
                    this.paraName[3] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 38: {
                fileOutput.println("Fitting to a Normal (Gaussian) distribution with fixed parameters");
                fileOutput.println("y = (yscale/(sd.sqrt(2.pi)).exp(0.5.square((x-mean)/sd))");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mean";
                this.paraName[1] = "sd";
                this.paraName[2] = "y scale";
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 39: {
                fileOutput.println("Fitting to a EC50 dose response curve (four parameter logistic)");
                fileOutput.println("y = top + (bottom - top)/(1 + (x/EC50)^HillSlope)");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "top";
                this.paraName[1] = "bottom";
                this.paraName[2] = "EC50";
                this.paraName[3] = "Hill Slope";
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 40: {
                fileOutput.println("Fitting to a EC50 dose response curve (four parameter logistic)");
                fileOutput.println("y = top + (bottom - top)/(1 + (x/EC50)^HillSlope) [top and bottom fixed]");
                fileOutput.println("bottom = " + this.bottom);
                fileOutput.println("top =    " + this.top);
                fileOutput.println();
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "EC50";
                this.paraName[1] = "Hill Slope";
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 41: {
                fileOutput.println("Fitting to a EC50 dose response curve - bottom constrained to be zero or positive");
                fileOutput.println("y = top + (bottom - top)/(1 + (x/EC50)^HillSlope)");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "top";
                this.paraName[1] = "bottom";
                this.paraName[2] = "EC50";
                this.paraName[3] = "Hill Slope";
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 42: {
                fileOutput.println("Fitting to a five parameter logistic");
                fileOutput.println("y = top + (bottom - top)/(1 + (x/C50)^HillSlope)^asymm [top and bottom fixed]");
                fileOutput.println("bottom = " + this.bottom);
                fileOutput.println("top =    " + this.top);
                fileOutput.println();
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "C50";
                this.paraName[1] = "HillSlope";
                this.paraName[2] = "asymm";
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 43: {
                fileOutput.println("Fitting to an exponential");
                fileOutput.println("y = yscale.exp(A.x)");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "A";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 44: {
                fileOutput.println("Fitting to multiple exponentials");
                fileOutput.println("y = Sum[Ai.exp(Bi.x)], i=1 to n");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                n2 = 1;
                for (n = 0; n < this.nParam; n += 2) {
                    this.paraName[n] = "A[" + n2 + "]";
                    this.paraName[n + 1] = "B[" + n2++ + "]";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 45: {
                fileOutput.println("Fitting to one minus an exponential");
                fileOutput.println("y = A(1 - exp(B.x)");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "A";
                this.paraName[1] = "B";
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 46: {
                fileOutput.println("Fitting to a constant");
                fileOutput.println("y = a");
                fileOutput.println("Stat weighted mean used to fit the data");
                this.paraName[0] = "a";
                this.linearPrint(fileOutput);
                break;
            }
            case 47: {
                fileOutput.println("Linear Regression with fixed intercept");
                fileOutput.println("y = fixed intercept + c[0]*x1 + c[1]*x2 +c[2]*x3 + . . .     ");
                for (n = 0; n < this.nParam; ++n) {
                    this.paraName[n] = "c[" + n + "]";
                }
                this.linearPrint(fileOutput);
                break;
            }
            case 48: {
                fileOutput.println("Polynomial (with degree = " + this.nParam + ") and fixed intercept, Fitting: Linear Regression");
                fileOutput.println("y = fixed intercept + c[0]*x + c[1]*x^2 +c[2]*x^3 + . . .");
                for (n = 0; n < this.nParam; ++n) {
                    this.paraName[n] = "c[" + n + "]";
                }
                this.linearPrint(fileOutput);
                break;
            }
            case 49: {
                fileOutput.println("Fitting multiple Gaussian distributions");
                fileOutput.println("y = Sum(A[i]/(sd[i].sqrt(2.pi)).exp(0.5.square((x-mean[i])/sd[i])) = yscale.Sum(f[i]/(sd[i].sqrt(2.pi)).exp(0.5.square((x-mean[i])/sd[i]))");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                for (n = 0; n < this.nGaussians; ++n) {
                    this.paraName[3 * n] = "mean[" + n + "]";
                    this.paraName[3 * n + 1] = "sd[" + n + "]";
                    this.paraName[3 * n + 2] = "A[" + n + "]";
                }
                if (this.scaleFlag) {
                    this.paraName[3 * this.nGaussians] = "y scale";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 50: {
                fileOutput.println("Fitting to a non-integer polynomial");
                fileOutput.println("y = c[0] + c[1]*x + c[2]*x^c[3]");
                for (n = 0; n < this.nParam; ++n) {
                    this.paraName[n] = "c[" + n + "]";
                }
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 51: {
                fileOutput.println("Five parameter logistic function");
                fileOutput.println("y = top + (bottom - top)/((1 + (x/y50)^HillSlope)^asymm");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "top";
                this.paraName[1] = "bottom";
                this.paraName[2] = "y50";
                this.paraName[3] = "HillSlope";
                this.paraName[4] = "asymm";
                this.nonLinearPrint(fileOutput);
                break;
            }
            case 52: {
                fileOutput.println("Fitting to a Shifted Rectangular Hyperbola");
                fileOutput.println("y = A.x/(theta + x) + alpha");
                fileOutput.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "theta";
                this.paraName[1] = "alpha";
                this.paraName[2] = "A";
                this.nonLinearPrint(fileOutput);
                break;
            }
            default: {
                throw new IllegalArgumentException("Method number (this.lastMethod) not found");
            }
        }
        fileOutput.close();
    }

    public void print() {
        String string = "RegressOutput.txt";
        this.print(string);
    }

    protected void linearPrint(FileOutput fileOutput) {
        int n;
        int n2;
        int n3;
        if (this.legendCheck) {
            fileOutput.println();
            fileOutput.println("x1 = " + this.xLegend);
            fileOutput.println("y  = " + this.yLegend);
        }
        fileOutput.println();
        if (this.lastMethod == 47) {
            fileOutput.println("Fixed Intercept = " + this.fixedInterceptL);
        }
        if (this.lastMethod == 48) {
            fileOutput.println("Fixed Intercept = " + this.fixedInterceptP);
        }
        fileOutput.printtab(" ", this.field);
        fileOutput.printtab("Best", this.field);
        fileOutput.printtab("Error", this.field);
        fileOutput.printtab("Coefficient of", this.field);
        fileOutput.printtab("t-value  ", this.field);
        fileOutput.println("p-value");
        fileOutput.printtab(" ", this.field);
        fileOutput.printtab("Estimate", this.field);
        fileOutput.printtab("        ", this.field);
        fileOutput.printtab("variation (%)", this.field);
        fileOutput.printtab("t ", this.field);
        fileOutput.println("P > |t|");
        for (n3 = 0; n3 < this.nParam; ++n3) {
            fileOutput.printtab(this.paraName[n3], this.field);
            fileOutput.printtab(Fmath.truncate(this.best[n3], this.prec), this.field);
            fileOutput.printtab(Fmath.truncate(this.bestSd[n3], this.prec), this.field);
            fileOutput.printtab(Fmath.truncate(Math.abs(this.bestSd[n3] * 100.0 / this.best[n3]), this.prec), this.field);
            fileOutput.printtab(Fmath.truncate(this.tValues[n3], this.prec), this.field);
            fileOutput.println(Fmath.truncate(this.pValues[n3], this.prec));
        }
        fileOutput.println();
        n3 = 0;
        if (this.lastMethod < 2) {
            n3 = 1;
        }
        for (n2 = 0; n2 < this.nXarrays; ++n2) {
            fileOutput.printtab("x" + String.valueOf(n2 + n3), this.field);
        }
        fileOutput.printtab("y(expl)", this.field);
        fileOutput.printtab("y(calc)", this.field);
        if (this.xErrorsEntered) {
            for (n2 = 0; n2 < this.nXarrays; ++n2) {
                fileOutput.printtab("x error", this.field);
            }
            fileOutput.printtab("y error", this.field);
        }
        fileOutput.printtab("weight", this.field);
        fileOutput.printtab("residual", this.field);
        fileOutput.println("residual");
        for (n2 = 0; n2 < this.nXarrays; ++n2) {
            fileOutput.printtab(" ", this.field);
        }
        fileOutput.printtab(" ", this.field);
        fileOutput.printtab(" ", this.field);
        if (this.xErrorsEntered) {
            for (n2 = 0; n2 < this.nXarrays; ++n2) {
                fileOutput.printtab("x" + String.valueOf(n2 + n3), this.field);
            }
            fileOutput.printtab(" ", this.field);
        }
        fileOutput.printtab(" ", this.field);
        fileOutput.printtab("(unweighted)", this.field);
        fileOutput.println("(weighted)");
        for (n2 = 0; n2 < this.nData; ++n2) {
            for (n = 0; n < this.nXarrays; ++n) {
                fileOutput.printtab(Fmath.truncate(this.xData[n][n2], this.prec), this.field);
            }
            fileOutput.printtab(Fmath.truncate(this.yData[n2], this.prec), this.field);
            fileOutput.printtab(Fmath.truncate(this.yCalc[n2], this.prec), this.field);
            if (this.xErrorsEntered) {
                for (n = 0; n < this.nXarrays; ++n) {
                    fileOutput.printtab(Fmath.truncate(this.xErrors[n][n2], this.prec), this.field);
                }
                fileOutput.printtab(Fmath.truncate(this.yErrors[n2], this.prec), this.field);
            }
            fileOutput.printtab(Fmath.truncate(this.weight[n2], this.prec), this.field);
            fileOutput.printtab(Fmath.truncate(this.residual[n2], this.prec), this.field);
            fileOutput.println(Fmath.truncate(this.residualW[n2], this.prec));
        }
        fileOutput.println();
        fileOutput.println("Sum of squares " + Fmath.truncate(this.sumOfSquaresError, this.prec));
        if (this.trueFreq) {
            fileOutput.printtab("Chi Square (Poissonian bins)");
            fileOutput.println(Fmath.truncate(this.chiSquare, this.prec));
            fileOutput.printtab("Reduced Chi Square (Poissonian bins)");
            fileOutput.println(Fmath.truncate(this.reducedChiSquare, this.prec));
            fileOutput.printtab("Chi Square (Poissonian bins) Probability");
            fileOutput.println(Fmath.truncate(1.0 - Stat.chiSquareProb(this.chiSquare, this.nData - this.nXarrays), this.prec));
        } else if (this.weightOpt) {
            fileOutput.printtab("Chi Square");
            fileOutput.println(Fmath.truncate(this.chiSquare, this.prec));
            fileOutput.printtab("Reduced Chi Square");
            fileOutput.println(Fmath.truncate(this.reducedChiSquare, this.prec));
        }
        fileOutput.println(" ");
        if (this.lastMethod != 46) {
            if (this.nXarrays == 1 && this.nYarrays == 1 && this.lastMethod != 47 && this.lastMethod != 48) {
                fileOutput.println("Correlation: x - y data");
                fileOutput.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient (R)");
                fileOutput.println(Fmath.truncate(this.xyR, this.prec));
                if (Math.abs(this.xyR) <= 1.0) {
                    fileOutput.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient Probability");
                    fileOutput.println(Fmath.truncate(Stat.linearCorrCoeffProb(this.xyR, this.nData - 2), this.prec));
                }
            }
            fileOutput.println(" ");
            fileOutput.println("Correlation: y(experimental) - y(calculated)");
            fileOutput.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient");
            fileOutput.println(Fmath.truncate(this.yyR, this.prec));
            if (Math.abs(this.yyR) <= 1.0) {
                fileOutput.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient Probability");
                fileOutput.println(Fmath.truncate(Stat.linearCorrCoeffProb(this.yyR, this.nData - 2), this.prec));
            }
            fileOutput.println();
            if (this.chiSquare != 0.0) {
                fileOutput.println("Correlation coefficients");
                fileOutput.printtab(" ", this.field);
                for (n2 = 0; n2 < this.nParam; ++n2) {
                    fileOutput.printtab(this.paraName[n2], this.field);
                }
                fileOutput.println();
                for (n2 = 0; n2 < this.nParam; ++n2) {
                    fileOutput.printtab(this.paraName[n2], this.field);
                    for (n = 0; n < this.nParam; ++n) {
                        fileOutput.printtab(Fmath.truncate(this.corrCoeff[n][n2], this.prec), this.field);
                    }
                    fileOutput.println();
                }
            }
        }
        fileOutput.println(" ");
        fileOutput.printtab("Degrees of freedom");
        fileOutput.println(this.nData - this.nParam);
        fileOutput.printtab("Number of data points");
        fileOutput.println(this.nData);
        fileOutput.printtab("Number of estimated paramaters");
        fileOutput.println(this.nParam);
        fileOutput.println();
        fileOutput.printtab("Durbin-Watson d statistic");
        fileOutput.println(Fmath.truncate(this.getDurbinWatsonD(), this.prec));
        fileOutput.println();
        if (this.bestPolyFlag) {
            fileOutput.println("Method bestPolynomial search history");
            fileOutput.println("F-probability significance level: " + this.fProbSignificance + " (" + this.fProbSignificance * 100.0 + " %)");
            fileOutput.println("Degree of best fit polynomial " + this.bestPolynomialDegree);
            fileOutput.println(" ");
            fileOutput.print("Polynomial degree", 2 * this.field);
            fileOutput.print("chi square", 2 * this.field);
            fileOutput.print("F-ratio", this.field);
            fileOutput.print("F-probability", this.field + 2);
            fileOutput.println("F-value at the");
            fileOutput.print("comparison", 2 * this.field);
            fileOutput.print("comparison", 2 * this.field);
            fileOutput.print("   ", this.field);
            fileOutput.print("   ", this.field + 2);
            fileOutput.println("significance level");
            n2 = (Integer)this.bestPolyArray.get(1);
            int[] nArray = (int[])this.bestPolyArray.get(2);
            int[] nArray2 = (int[])this.bestPolyArray.get(3);
            double[] dArray = (double[])this.bestPolyArray.get(4);
            double[] dArray2 = (double[])this.bestPolyArray.get(5);
            double[] dArray3 = (double[])this.bestPolyArray.get(6);
            double[] dArray4 = (double[])this.bestPolyArray.get(7);
            double[] dArray5 = (double[])this.bestPolyArray.get(8);
            for (int j = 0; j < n2; ++j) {
                fileOutput.print(nArray[j], this.field);
                fileOutput.print(nArray2[j], this.field);
                fileOutput.print(Fmath.truncate(dArray[j], this.prec), this.field);
                fileOutput.print(Fmath.truncate(dArray2[j], this.prec), this.field);
                fileOutput.print(Fmath.truncate(dArray3[j], this.prec), this.field);
                fileOutput.print(Fmath.truncate(dArray4[j], this.prec), this.field + 2);
                fileOutput.println(Fmath.truncate(dArray5[j], this.prec));
            }
        }
        fileOutput.println();
        fileOutput.println("Coefficient of determination,   =                   " + Fmath.truncate(this.multR, this.prec));
        fileOutput.println("Adjusted Coefficient of determination,    =         " + Fmath.truncate(this.adjustedR, this.prec));
        fileOutput.println("Coefficient of determination, F-ratio =             " + Fmath.truncate(this.multipleF, this.prec));
        fileOutput.println("Coefficient of determination, F-ratio probability = " + Fmath.truncate(this.multipleFprob, this.prec));
        fileOutput.println("Total (weighted) sum of squares  =                  " + Fmath.truncate(this.sumOfSquaresTotal, this.prec));
        fileOutput.println("Regression (weighted) sum of squares  =             " + Fmath.truncate(this.sumOfSquaresRegrn, this.prec));
        fileOutput.println("Error (weighted) sum of squares  =                  " + Fmath.truncate(this.chiSquare, this.prec));
        fileOutput.println();
        fileOutput.println("End of file");
        fileOutput.close();
    }

    protected void nonLinearPrint(FileOutput fileOutput) {
        int n;
        int n2;
        int n3;
        Object object;
        int n4;
        int n5;
        for (n5 = 0; n5 < this.nParam; ++n5) {
            if (this.constraintString[n5].equals("none")) continue;
            n4 = 1;
            String string = this.constraintString[n5];
            object = "";
            while (n4 != 0) {
                n3 = string.indexOf("p[");
                if (n3 == -1) {
                    object = (String)object + string;
                    n4 = 0;
                    continue;
                }
                n2 = string.indexOf("]");
                int n6 = Integer.parseInt(string.substring(n3 + 2, n2));
                object = (String)object + string.substring(0, n3) + this.paraName[n6];
                string = string.substring(n2 + 1);
            }
            this.constraintString[n5] = object;
        }
        if (this.userSupplied) {
            fileOutput.println();
            fileOutput.println("Initial estimates were supplied by the user");
        } else {
            fileOutput.println("Initial estimates were calculated internally");
        }
        switch (this.scaleOpt) {
            case 1: {
                fileOutput.println();
                fileOutput.println("Initial estimates were scaled to unity within the regression");
                break;
            }
            case 2: {
                fileOutput.println();
                fileOutput.println("Initial estimates were scaled with user supplied scaling factors within the regression");
            }
        }
        if (this.legendCheck) {
            fileOutput.println();
            fileOutput.println("x1 = " + this.xLegend);
            fileOutput.println("y  = " + this.yLegend);
        }
        fileOutput.println();
        if (!this.nlrStatus) {
            fileOutput.println("Convergence criterion was not satisfied");
            fileOutput.println("The following results are, or are derived from, the current estimates on exiting the regression method");
            fileOutput.println();
        }
        fileOutput.println("Estimated parameters");
        fileOutput.println("The statistics are obtained assuming that the model behaves as a linear model about the minimum.");
        if (!this.analyticalDerivative) {
            fileOutput.println("The Hessian matrix is calculated as the numerically derived second derivatives of chi square with respect to all pairs of parameters.");
        }
        if (this.zeroCheck) {
            fileOutput.println("The best estimate/s equal to zero were replaced by the step size in the numerical differentiation!!!");
        }
        fileOutput.println("Consequentlty treat the statistics with great caution");
        if (!this.posVarFlag) {
            fileOutput.println("Covariance matrix contains at least one negative diagonal element");
            fileOutput.println(" - all variances are dubious");
            fileOutput.println(" - may not be at a minimum or the model may be so non-linear that the linear approximation in calculating the statisics is invalid");
        }
        if (!this.invertFlag) {
            fileOutput.println("Hessian matrix is singular");
            fileOutput.println(" - variances cannot be calculated");
            fileOutput.println(" - may not be at a minimum  or the model may be so non-linear that the linear approximation in calculating the statisics is invalid");
        }
        fileOutput.println(" ");
        if (!this.scaleFlag) {
            fileOutput.println("The ordinate scaling factor [yscale, Ao] has been set equal to " + this.yScaleFactor);
            fileOutput.println(" ");
        }
        if (this.lastMethod == 35) {
            fileOutput.println("The integer rate parameter, k, was varied in unit steps to obtain a minimum sum of squares");
            fileOutput.println("This value of k was " + this.kayValue);
            fileOutput.println(" ");
        }
        fileOutput.printtab(" ", this.field);
        if (this.invertFlag) {
            fileOutput.printtab("Best", this.field);
            fileOutput.printtab("Estimate of", this.field);
            fileOutput.printtab("Coefficient", this.field);
            fileOutput.printtab("t-value", this.field);
            fileOutput.println("p-value");
        } else {
            fileOutput.println("Best");
        }
        if (this.invertFlag) {
            fileOutput.printtab(" ", this.field);
            fileOutput.printtab("estimate", this.field);
            fileOutput.printtab("the error", this.field);
            fileOutput.printtab("of", this.field);
            fileOutput.printtab("t", this.field);
            fileOutput.println("P > |t|");
        } else {
            fileOutput.printtab(" ", this.field);
            fileOutput.println("estimate");
        }
        if (this.invertFlag) {
            fileOutput.printtab(" ", this.field);
            fileOutput.printtab(" ", this.field);
            fileOutput.printtab(" ", this.field);
            fileOutput.println("variation (%)");
        } else {
            fileOutput.println("   ");
        }
        if (this.lastMethod == 38) {
            n5 = 3;
            n4 = 0;
            for (int j = 0; j < n5; ++j) {
                fileOutput.printtab(this.paraName[j], this.field);
                if (this.fixed[j]) {
                    fileOutput.printtab(this.values[j]);
                    fileOutput.println(" fixed parameter");
                    continue;
                }
                if (this.invertFlag) {
                    fileOutput.printtab(Fmath.truncate(this.best[n4], this.prec), this.field);
                    fileOutput.printtab(Fmath.truncate(this.bestSd[n4], this.prec), this.field);
                    fileOutput.printtab(Fmath.truncate(Math.abs(this.bestSd[n4] * 100.0 / this.best[n4]), this.prec), this.field);
                    fileOutput.printtab(Fmath.truncate(this.tValues[n4], this.prec), this.field);
                    fileOutput.println(Fmath.truncate(this.pValues[n4], this.prec));
                } else {
                    fileOutput.println(Fmath.truncate(this.best[n4], this.prec));
                }
                ++n4;
            }
        } else {
            for (n5 = 0; n5 < this.nParam; ++n5) {
                if (this.invertFlag) {
                    fileOutput.printtab(this.paraName[n5], this.field);
                    fileOutput.printtab(Fmath.truncate(this.best[n5], this.prec), this.field);
                    fileOutput.printtab(Fmath.truncate(this.bestSd[n5], this.prec), this.field);
                    fileOutput.printtab(Fmath.truncate(Math.abs(this.bestSd[n5] * 100.0 / this.best[n5]), this.prec), this.field);
                    fileOutput.printtab(Fmath.truncate(this.tValues[n5], this.prec), this.field);
                    fileOutput.println(Fmath.truncate(this.pValues[n5], this.prec));
                    continue;
                }
                fileOutput.printtab(this.paraName[n5], this.field);
                fileOutput.println(Fmath.truncate(this.best[n5], this.prec));
            }
        }
        fileOutput.println();
        fileOutput.printtab(" ", this.field);
        fileOutput.printtab("Best", this.field);
        fileOutput.printtab("Pre-min", this.field);
        fileOutput.printtab("Post-min", this.field);
        fileOutput.printtab("Initial", this.field);
        fileOutput.printtab("Fractional", this.field);
        fileOutput.printtab("Scaling", this.field);
        fileOutput.println("Constraint");
        fileOutput.printtab(" ", this.field);
        fileOutput.printtab("estimate", this.field);
        fileOutput.printtab("gradient", this.field);
        fileOutput.printtab("gradient", this.field);
        fileOutput.printtab("estimate", this.field);
        fileOutput.printtab("step", this.field);
        fileOutput.println("factor");
        if (this.lastMethod == 38) {
            n5 = 3;
            n4 = 0;
            for (int j = 0; j < n5; ++j) {
                fileOutput.printtab(this.paraName[j], this.field);
                if (this.fixed[j]) {
                    fileOutput.printtab(this.values[j]);
                    fileOutput.println(" fixed parameter");
                    continue;
                }
                fileOutput.printtab(Fmath.truncate(this.best[n4], this.prec), this.field);
                fileOutput.printtab(Fmath.truncate(this.grad[n4][0], this.prec), this.field);
                fileOutput.printtab(Fmath.truncate(this.grad[n4][1], this.prec), this.field);
                fileOutput.printtab(Fmath.truncate(this.startH[n4], this.prec), this.field);
                fileOutput.printtab(Fmath.truncate(this.stepH[n4], this.prec), this.field);
                fileOutput.printtab(Fmath.truncate(this.scale[n4], this.prec), this.field);
                fileOutput.println(this.constraintString[n4]);
                ++n4;
            }
        } else {
            for (n5 = 0; n5 < this.nParam; ++n5) {
                fileOutput.printtab(this.paraName[n5], this.field);
                fileOutput.printtab(Fmath.truncate(this.best[n5], this.prec), this.field);
                fileOutput.printtab(Fmath.truncate(this.grad[n5][0], this.prec), this.field);
                fileOutput.printtab(Fmath.truncate(this.grad[n5][1], this.prec), this.field);
                fileOutput.printtab(Fmath.truncate(this.startH[n5], this.prec), this.field);
                fileOutput.printtab(Fmath.truncate(this.stepH[n5], this.prec), this.field);
                fileOutput.printtab(Fmath.truncate(this.scale[n5], this.prec), this.field);
                fileOutput.println(this.constraintString[n5]);
            }
        }
        fileOutput.println();
        ErrorProp errorProp = null;
        ErrorProp errorProp2 = null;
        if (this.scaleFlag) {
            switch (this.lastMethod) {
                case 4: {
                    ErrorProp errorProp3 = new ErrorProp(this.best[1], this.bestSd[1]);
                    errorProp2 = new ErrorProp(this.best[2] / Math.sqrt(Math.PI * 2), this.bestSd[2] / Math.sqrt(Math.PI * 2));
                    errorProp = errorProp2.over(errorProp3);
                    fileOutput.printsp("Calculated estimate of the peak value = ");
                    fileOutput.println(ErrorProp.truncate(errorProp, this.prec));
                    break;
                }
                case 5: {
                    object = new ErrorProp(this.best[1], this.bestSd[1]);
                    errorProp2 = new ErrorProp(2.0 * this.best[2] / Math.PI, 2.0 * this.bestSd[2] / Math.PI);
                    errorProp = errorProp2.over((ErrorProp)object);
                    fileOutput.printsp("Calculated estimate of the peak value = ");
                    fileOutput.println(ErrorProp.truncate(errorProp, this.prec));
                }
            }
        }
        if (this.lastMethod == 25) {
            fileOutput.printsp("Calculated estimate of the maximum gradient = ");
            if (this.scaleFlag) {
                fileOutput.println(Fmath.truncate(this.best[0] * this.best[2] / 4.0, this.prec));
            } else {
                fileOutput.println(Fmath.truncate(this.best[0] * this.yScaleFactor / 4.0, this.prec));
            }
        }
        if (this.lastMethod == 28) {
            fileOutput.printsp("Calculated estimate of the maximum gradient = ");
            if (this.scaleFlag) {
                fileOutput.println(Fmath.truncate(this.best[1] * this.best[2] / (4.0 * this.best[0]), this.prec));
            } else {
                fileOutput.println(Fmath.truncate(this.best[1] * this.yScaleFactor / (4.0 * this.best[0]), this.prec));
            }
            fileOutput.printsp("Calculated estimate of the Ka, i.e. theta raised to the power n = ");
            fileOutput.println(Fmath.truncate(Math.pow(this.best[0], this.best[1]), this.prec));
        }
        fileOutput.println();
        if (this.lastMethod == 49) {
            fileOutput.println("A[i] values converted to fractional contributions, f[i], and a scaling factor, yscale");
            fileOutput.printtab(" ", this.field);
            if (this.invertFlag) {
                fileOutput.printtab("Best", this.field);
                fileOutput.printtab("Estimate of", this.field);
                fileOutput.printtab("Coefficient", this.field);
                fileOutput.printtab("t-value", this.field);
                fileOutput.println("p-value");
            } else {
                fileOutput.println("Best");
            }
            if (this.invertFlag) {
                fileOutput.printtab(" ", this.field);
                fileOutput.printtab("estimate", this.field);
                fileOutput.printtab("the error", this.field);
                fileOutput.printtab("of", this.field);
                fileOutput.printtab("t", this.field);
                fileOutput.println("P > |t|");
            } else {
                fileOutput.printtab(" ", this.field);
                fileOutput.println("estimate");
            }
            if (this.invertFlag) {
                fileOutput.printtab(" ", this.field);
                fileOutput.printtab(" ", this.field);
                fileOutput.printtab(" ", this.field);
                fileOutput.println("variation (%)");
            } else {
                fileOutput.println("   ");
            }
            for (int j = 0; j < this.nGaussians; ++j) {
                if (this.invertFlag) {
                    fileOutput.printtab("f[" + j + "]", this.field);
                    fileOutput.printtab(Fmath.truncate(this.multGaussFract[j], this.prec), this.field);
                    fileOutput.printtab(Fmath.truncate(this.multGaussFractErrors[j], this.prec), this.field);
                    fileOutput.printtab(Fmath.truncate(this.multGaussCoeffVar[j], this.prec), this.field);
                    fileOutput.printtab(Fmath.truncate(this.multGaussTvalue[j], this.prec), this.field);
                    fileOutput.println(Fmath.truncate(this.multGaussPvalue[j], this.prec));
                    continue;
                }
                fileOutput.printtab("f[" + j + "]", this.field);
                fileOutput.println(Fmath.truncate(this.multGaussFract[j], this.prec));
            }
            if (this.invertFlag) {
                fileOutput.printtab("yscale", this.field);
                fileOutput.printtab(Fmath.truncate(this.multGaussScale, this.prec), this.field);
                fileOutput.printtab(Fmath.truncate(this.multGaussScaleError, this.prec), this.field);
                fileOutput.printtab(Fmath.truncate(this.multGaussScaleCoeffVar, this.prec), this.field);
                fileOutput.printtab(Fmath.truncate(this.multGaussScaleTvalue, this.prec), this.field);
                fileOutput.println(Fmath.truncate(this.multGaussScalePvalue, this.prec));
            } else {
                fileOutput.printtab("yscale", this.field);
                fileOutput.println(Fmath.truncate(this.multGaussScale, this.prec));
            }
        }
        fileOutput.println();
        int n7 = 0;
        for (n = 0; n < this.nYarrays; ++n) {
            if (this.multipleY) {
                fileOutput.println("Y array " + n);
            }
            for (n3 = 0; n3 < this.nXarrays; ++n3) {
                fileOutput.printtab("x" + String.valueOf(n3), this.field);
            }
            fileOutput.printtab("y(expl)", this.field);
            fileOutput.printtab("y(calc)", this.field);
            if (this.xErrorsEntered) {
                for (n3 = 0; n3 < this.nXarrays; ++n3) {
                    fileOutput.printtab("x errors", this.field);
                }
                fileOutput.printtab("y errors", this.field);
            }
            fileOutput.printtab("weight", this.field);
            fileOutput.printtab("residual", this.field);
            fileOutput.println("residual");
            for (n3 = 0; n3 < this.nXarrays; ++n3) {
                fileOutput.printtab(" ", this.field);
            }
            fileOutput.printtab(" ", this.field);
            fileOutput.printtab(" ", this.field);
            if (this.xErrorsEntered) {
                for (n3 = 0; n3 < this.nXarrays; ++n3) {
                    fileOutput.printtab("x" + String.valueOf(n3), this.field);
                }
                fileOutput.printtab("  ", this.field);
            }
            fileOutput.printtab(" ", this.field);
            fileOutput.printtab("(unweighted)", this.field);
            fileOutput.println("(weighted)");
            for (n3 = 0; n3 < this.nData0; ++n3) {
                for (n2 = 0; n2 < this.nXarrays; ++n2) {
                    fileOutput.printtab(Fmath.truncate(this.xData[n2][n7], this.prec), this.field);
                }
                fileOutput.printtab(Fmath.truncate(this.yData[n7], this.prec), this.field);
                fileOutput.printtab(Fmath.truncate(this.yCalc[n7], this.prec), this.field);
                if (this.xErrorsEntered) {
                    for (n2 = 0; n2 < this.nXarrays; ++n2) {
                        fileOutput.printtab(Fmath.truncate(this.xErrors[n2][n7], this.prec), this.field);
                    }
                    fileOutput.printtab(Fmath.truncate(this.yErrors[n7], this.prec), this.field);
                }
                fileOutput.printtab(Fmath.truncate(this.weight[n7], this.prec), this.field);
                fileOutput.printtab(Fmath.truncate(this.residual[n7], this.prec), this.field);
                fileOutput.println(Fmath.truncate(this.residualW[n7], this.prec));
                ++n7;
            }
            fileOutput.println();
        }
        fileOutput.printtab("Sum of squares of the unweighted residuals");
        fileOutput.println(Fmath.truncate(this.sumOfSquaresError, this.prec));
        if (this.trueFreq) {
            fileOutput.printtab("Chi Square (Poissonian bins)");
            fileOutput.println(Fmath.truncate(this.chiSquare, this.prec));
            fileOutput.printtab("Reduced Chi Square (Poissonian bins)");
            fileOutput.println(Fmath.truncate(this.reducedChiSquare, this.prec));
            fileOutput.printtab("Chi Square (Poissonian bins) Probability");
            fileOutput.println(Fmath.truncate(1.0 - Stat.chiSquareProb(this.reducedChiSquare, this.degreesOfFreedom), this.prec));
        } else if (this.weightOpt) {
            fileOutput.printtab("Chi Square");
            fileOutput.println(Fmath.truncate(this.chiSquare, this.prec));
            fileOutput.printtab("Reduced Chi Square");
            fileOutput.println(Fmath.truncate(this.reducedChiSquare, this.prec));
        }
        fileOutput.println(" ");
        if (this.nXarrays == 1 && this.nYarrays == 1) {
            fileOutput.println("Correlation: x - y data");
            fileOutput.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient (R)");
            fileOutput.println(Fmath.truncate(this.xyR, this.prec));
            if (Math.abs(this.xyR) <= 1.0) {
                fileOutput.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient Probability");
                fileOutput.println(Fmath.truncate(Stat.linearCorrCoeffProb(this.xyR, this.nData - 2), this.prec));
            }
        }
        fileOutput.println(" ");
        fileOutput.println("Correlation: y(experimental) - y(calculated)");
        fileOutput.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient");
        fileOutput.println(Fmath.truncate(this.yyR, this.prec));
        if (Math.abs(this.yyR) <= 1.0) {
            fileOutput.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient Probability");
            fileOutput.println(Fmath.truncate(Stat.linearCorrCoeffProb(this.yyR, this.nData - 2), this.prec));
        }
        fileOutput.println(" ");
        fileOutput.printtab("Degrees of freedom");
        fileOutput.println(this.degreesOfFreedom);
        fileOutput.printtab("Number of data points");
        fileOutput.println(this.nData);
        fileOutput.printtab("Number of estimated paramaters");
        fileOutput.println(this.nParam);
        fileOutput.println();
        if (this.posVarFlag && this.invertFlag && this.chiSquare != 0.0) {
            fileOutput.println("Parameter - parameter correlation coefficients");
            fileOutput.printtab(" ", this.field);
            for (n = 0; n < this.nParam; ++n) {
                fileOutput.printtab(this.paraName[n], this.field);
            }
            fileOutput.println();
            for (n = 0; n < this.nParam; ++n) {
                fileOutput.printtab(this.paraName[n], this.field);
                for (n3 = 0; n3 < this.nParam; ++n3) {
                    fileOutput.printtab(Fmath.truncate(this.corrCoeff[n3][n], this.prec), this.field);
                }
                fileOutput.println();
            }
            fileOutput.println();
        }
        fileOutput.println();
        fileOutput.println("Coefficient of determination, R =                   " + Fmath.truncate(this.multR, this.prec));
        fileOutput.println("Adjusted Coefficient of determination, R' =         " + Fmath.truncate(this.adjustedR, this.prec));
        fileOutput.println("Coefficient of determination, F-ratio =             " + Fmath.truncate(this.multipleF, this.prec));
        fileOutput.println("Coefficient of determination, F-ratio probability = " + Fmath.truncate(this.multipleFprob, this.prec));
        fileOutput.println("Total (weighted) sum of squares  =                  " + Fmath.truncate(this.sumOfSquaresTotal, this.prec));
        fileOutput.println("Regression (weighted) sum of squares  =             " + Fmath.truncate(this.sumOfSquaresRegrn, this.prec));
        fileOutput.println("Error (weighted) sum of squares  =                  " + Fmath.truncate(this.chiSquare, this.prec));
        fileOutput.println();
        fileOutput.println();
        fileOutput.printtab("Durbin-Watson d statistic");
        fileOutput.println(Fmath.truncate(this.getDurbinWatsonD(), this.prec));
        fileOutput.println();
        fileOutput.printtab("Number of iterations taken");
        fileOutput.println(this.nIter);
        fileOutput.printtab("Maximum number of iterations allowed");
        fileOutput.println(this.nMax);
        fileOutput.printtab("Number of restarts taken");
        fileOutput.println(this.kRestart);
        fileOutput.printtab("Maximum number of restarts allowed");
        fileOutput.println(this.konvge);
        fileOutput.printtab("Standard deviation of the simplex at the minimum");
        fileOutput.println(Fmath.truncate(this.simplexSd, this.prec));
        fileOutput.printtab("Convergence tolerance");
        fileOutput.println(this.fTol);
        switch (this.minTest) {
            case 0: {
                fileOutput.println("simplex sd < the tolerance times the mean of the absolute values of the y values");
                break;
            }
            case 1: {
                fileOutput.println("simplex sd < the tolerance");
                break;
            }
            case 2: {
                fileOutput.println("simplex sd < the tolerance times the square root(sum of squares/degrees of freedom");
            }
        }
        if (!this.analyticalDerivative) {
            fileOutput.println("Step used in numerical differentiation to obtain Hessian matrix");
            fileOutput.println("d(parameter) = parameter*" + this.delta);
        }
        fileOutput.println();
        fileOutput.println("End of file");
        fileOutput.close();
    }

    public void plotYY(String string) {
        this.graphTitle = string;
        int n = 2;
        int n2 = this.nData0;
        double[][] dArray = PlotGraph.data(n, n2);
        int n3 = 0;
        for (int j = 0; j < this.nYarrays; ++j) {
            for (int k = 0; k < this.nData0; ++k) {
                dArray[0][k] = this.yData[n3];
                dArray[1][k] = this.yCalc[n3];
                ++n3;
            }
            String string2 = this.setGandPtitle(this.graphTitle);
            if (this.multipleY) {
                string2 = string2 + "y array " + j;
            }
            String string3 = "Calculated versus experimental y values";
            Regression regression = new Regression(this.yData, this.yCalc, this.weight);
            regression.linear();
            double[] dArray2 = regression.getCoeff();
            dArray[2][0] = Fmath.minimum(this.yData);
            dArray[3][0] = dArray2[0] + dArray2[1] * dArray[2][0];
            dArray[2][1] = Fmath.maximum(this.yData);
            dArray[3][1] = dArray2[0] + dArray2[1] * dArray[2][1];
            PlotGraph plotGraph = new PlotGraph(dArray);
            if (this.plotWindowCloseChoice) {
                plotGraph.setCloseChoice(2);
            } else {
                plotGraph.setCloseChoice(1);
            }
            plotGraph.setGraphTitle(string2);
            plotGraph.setGraphTitle2(string3);
            plotGraph.setXaxisLegend("Experimental y value");
            plotGraph.setYaxisLegend("Calculated y value");
            int[] nArray = new int[]{1, 0};
            plotGraph.setPoint(nArray);
            int[] nArray2 = new int[]{0, 3};
            plotGraph.setLine(nArray2);
            plotGraph.plot();
        }
    }

    protected String setGandPtitle(String string) {
        String string2 = "";
        switch (this.lastMethod) {
            case 0: {
                string2 = "Linear regression (with intercept): " + string;
                break;
            }
            case 1: {
                string2 = "Linear(polynomial with degree = " + (this.nParam - 1) + ") regression: " + string;
                break;
            }
            case 2: {
                string2 = "General linear regression: " + string;
                break;
            }
            case 3: {
                string2 = "Non-linear (simplex) regression: " + string;
                break;
            }
            case 4: {
                string2 = "Fit to a Gaussian distribution: " + string;
                break;
            }
            case 5: {
                string2 = "Fit to a Lorentzian distribution: " + string;
                break;
            }
            case 6: {
                string2 = "Fit to a Poisson distribution: " + string;
                break;
            }
            case 7: {
                string2 = "Fit to a Two Parameter Minimum Order Statistic Gumbel distribution: " + string;
                break;
            }
            case 8: {
                string2 = "Fit to a two Parameter Maximum Order Statistic Gumbel distribution: " + string;
                break;
            }
            case 9: {
                string2 = "Fit to a One Parameter Minimum Order Statistic Gumbel distribution: " + string;
                break;
            }
            case 10: {
                string2 = "Fit to a One Parameter Maximum Order Statistic Gumbel distribution: " + string;
                break;
            }
            case 11: {
                string2 = "Fit to a Standard Minimum Order Statistic Gumbel distribution: " + string;
                break;
            }
            case 12: {
                string2 = "Fit to a Standard Maximum Order Statistic Gumbel distribution: " + string;
                break;
            }
            case 13: {
                string2 = "Fit to a Three Parameter Frechet distribution: " + string;
                break;
            }
            case 14: {
                string2 = "Fit to a Two Parameter Frechet distribution: " + string;
                break;
            }
            case 15: {
                string2 = "Fit to a Standard Frechet distribution: " + string;
                break;
            }
            case 16: {
                string2 = "Fit to a Three Parameter Weibull distribution: " + string;
                break;
            }
            case 17: {
                string2 = "Fit to a Two Parameter Weibull distribution: " + string;
                break;
            }
            case 18: {
                string2 = "Fit to a Standard Weibull distribution: " + string;
                break;
            }
            case 19: {
                string2 = "Fit to a Two Parameter Exponential distribution: " + string;
                break;
            }
            case 20: {
                string2 = "Fit to a One Parameter Exponential distribution: " + string;
                break;
            }
            case 21: {
                string2 = "Fit to a Standard exponential distribution: " + string;
                break;
            }
            case 22: {
                string2 = "Fit to a Rayleigh distribution: " + string;
                break;
            }
            case 23: {
                string2 = "Fit to a Two Parameter Pareto distribution: " + string;
                break;
            }
            case 24: {
                string2 = "Fit to a One Parameter Pareto distribution: " + string;
                break;
            }
            case 25: {
                string2 = "Fit to a Sigmoid Threshold Function: " + string;
                break;
            }
            case 26: {
                string2 = "Fit to a Rectangular Hyperbola: " + string;
                break;
            }
            case 27: {
                string2 = "Fit to a Scaled Heaviside Step Function: " + string;
                break;
            }
            case 28: {
                string2 = "Fit to a Hill/Sips Sigmoid: " + string;
                break;
            }
            case 29: {
                string2 = "Fit to a Shifted Pareto distribution: " + string;
                break;
            }
            case 30: {
                string2 = "Fit to a Logistic distribution: " + string;
                break;
            }
            case 31: {
                string2 = "Fit to a Beta distribution - interval [0, 1]: " + string;
                break;
            }
            case 32: {
                string2 = "Fit to a Beta distribution - interval [min, max]: " + string;
                break;
            }
            case 33: {
                string2 = "Fit to a Three Parameter Gamma distribution]: " + string;
                break;
            }
            case 34: {
                string2 = "Fit to a Standard Gamma distribution]: " + string;
                break;
            }
            case 35: {
                string2 = "Fit to an Erlang distribution]: " + string;
                break;
            }
            case 36: {
                string2 = "Fit to an two parameter log-normal distribution]: " + string;
                break;
            }
            case 37: {
                string2 = "Fit to an three parameter log-normal distribution]: " + string;
                break;
            }
            case 38: {
                string2 = "Fit to a Gaussian distribution with fixed parameters: " + string;
                break;
            }
            case 39: {
                string2 = "Fit to a EC50 dose response curve (four parameter logistic): " + string;
                break;
            }
            case 40: {
                string2 = "Fit to a EC50 dose response curve (top and bottom fixed): " + string;
                break;
            }
            case 41: {
                string2 = "Fit to a EC50 dose response curve - bottom constrained [>= 0]: " + string;
                break;
            }
            case 42: {
                string2 = "Fitting to a five parameter logistic function (top and bottom fixed)";
                break;
            }
            case 43: {
                string2 = "Fit to an exponential yscale.exp(A.x): " + string;
                break;
            }
            case 44: {
                string2 = "Fit to multiple exponentials sum[Ai.exp(Bi.x)]: " + string;
                break;
            }
            case 45: {
                string2 = "Fit to an exponential A.(1 - exp(B.x): " + string;
                break;
            }
            case 46: {
                string2 = "Fit to a constant a: " + string;
                break;
            }
            case 47: {
                string2 = "Linear regression (with fixed intercept): " + string;
                break;
            }
            case 48: {
                string2 = "Linear(polynomial with degree = " + (this.nParam - 1) + " and fixed intercept) regression: " + string;
                break;
            }
            case 49: {
                string2 = "Fitting multiple Gaussian distributions";
                break;
            }
            case 50: {
                string2 = "Fitting to a non-integer polynomial";
                break;
            }
            case 51: {
                string2 = "Fitting to a five parameter logistic function";
                break;
            }
            case 52: {
                string2 = "Fit to a shifted Rectangular Hyperbola: " + string;
                break;
            }
            default: {
                string2 = " " + string;
            }
        }
        return string2;
    }

    public void plotYY() {
        this.plotYY(this.graphTitle);
    }

    protected int plotXY(String string) {
        this.graphTitle = string;
        int n = 0;
        if (!this.linNonLin && this.nParam > 0) {
            System.out.println("You attempted to use Regression.plotXY() for a non-linear regression without providing the function reference in the plotXY argument list");
            System.out.println("No plot attempted");
            n = -1;
            return n;
        }
        n = this.plotXYlinear(string);
        return n;
    }

    public int plotXY() {
        int n = -2;
        if (this.multipleY) {
            System.out.println("You attempted to use Regression.plotXY() for a multiply dimensioned y array");
            System.out.println("No plot attempted");
        } else {
            n = this.plotXY(this.graphTitle);
        }
        return n;
    }

    protected int plotXY(Object object, String string) {
        int n = -2;
        if (this.multipleY) {
            System.out.println("You attempted to use Regression.plotXY() for a multiply dimensioned y array");
            System.out.println("No plot attempted");
        } else {
            n = this.plotXYnonlinear(object, string);
        }
        return n;
    }

    protected int plotXY(RegressionFunction regressionFunction, String string) {
        return this.plotXY((Object)regressionFunction, string);
    }

    protected int plotXY(RegressionFunction2 regressionFunction2, String string) {
        return this.plotXY((Object)regressionFunction2, string);
    }

    protected int plotXY(RegressionFunction3 regressionFunction3, String string) {
        return this.plotXY((Object)regressionFunction3, string);
    }

    protected int plotXY(Object object) {
        int n = -2;
        if (this.multipleY) {
            System.out.println("You attempted to use Regression.plotXY() for a multiply dimensioned y array");
            System.out.println("No plot attempted");
        } else {
            n = this.plotXYnonlinear(object, this.graphTitle);
        }
        return n;
    }

    protected int plotXY(RegressionFunction regressionFunction) {
        return this.plotXY((Object)regressionFunction);
    }

    protected int plotXY(RegressionFunction2 regressionFunction2) {
        return this.plotXY((Object)regressionFunction2);
    }

    protected int plotXY(RegressionFunction3 regressionFunction3) {
        return this.plotXY((Object)regressionFunction3);
    }

    public void addLegends() {
        int n = JOptionPane.showConfirmDialog(null, "Do you wish to add your own legends to the x and y axes", "Axis Legends", 0, 3);
        if (n == 0) {
            this.xLegend = JOptionPane.showInputDialog("Type the legend for the abscissae (x-axis) [first data set]");
            this.yLegend = JOptionPane.showInputDialog("Type the legend for the ordinates (y-axis) [second data set]");
            this.legendCheck = true;
        }
    }

    protected int plotXYlinear(String string) {
        String string2;
        String string3;
        double[][] dArray;
        int n;
        block49: {
            int n2;
            int n3;
            block48: {
                this.graphTitle = string;
                n = 0;
                if (this.nXarrays > 1) {
                    System.out.println("You attempted to use Regression.plotXY() for a multiple regression");
                    System.out.println("No plot attempted");
                    n = -2;
                    return n;
                }
                int n4 = 2;
                n3 = 200;
                if (n3 < this.nData0) {
                    n3 = this.nData0;
                }
                if (this.lastMethod == 11 || this.lastMethod == 12 || this.lastMethod == 21) {
                    n3 = this.nData0;
                }
                dArray = PlotGraph.data(n4, n3);
                double d = Fmath.minimum(this.xData[0]);
                double d2 = Fmath.maximum(this.xData[0]);
                double d3 = (d2 - d) / (double)(n3 - 1);
                string3 = " ";
                string2 = " ";
                for (n2 = 0; n2 < this.nData0; ++n2) {
                    dArray[0][n2] = this.xData[0][n2];
                    dArray[1][n2] = this.yData[n2];
                }
                dArray[2][0] = d;
                for (n2 = 1; n2 < n3; ++n2) {
                    dArray[2][n2] = dArray[2][n2 - 1] + d3;
                }
                if (this.nParam != 0) break block48;
                switch (this.lastMethod) {
                    case 11: {
                        string3 = "No regression: Minimum Order Statistic Standard Gumbel (y = exp(x)exp(-exp(x))): " + this.graphTitle;
                        string2 = " points - experimental values;   line - theoretical curve;   no parameters to be estimated";
                        if (this.weightOpt) {
                            string2 = string2 + ";   error bars - weighting factors";
                        }
                        for (n2 = 0; n2 < n3; ++n2) {
                            dArray[3][n2] = this.yCalc[n2];
                        }
                        break block49;
                    }
                    case 12: {
                        string3 = "No regression:  Maximum Order Statistic Standard Gumbel (y = exp(-x)exp(-exp(-x))): " + this.graphTitle;
                        string2 = " points - experimental values;   line - theoretical curve;   no parameters to be estimated";
                        if (this.weightOpt) {
                            string2 = string2 + ";   error bars - weighting factors";
                        }
                        for (n2 = 0; n2 < n3; ++n2) {
                            dArray[3][n2] = this.yCalc[n2];
                        }
                        break block49;
                    }
                    case 21: {
                        string3 = "No regression:  Standard Exponential (y = exp(-x)): " + this.graphTitle;
                        string2 = " points - experimental values;   line - theoretical curve;   no parameters to be estimated";
                        if (this.weightOpt) {
                            string2 = string2 + ";   error bars - weighting factors";
                        }
                        for (n2 = 0; n2 < n3; ++n2) {
                            dArray[3][n2] = this.yCalc[n2];
                        }
                        break;
                    }
                }
                break block49;
            }
            switch (this.lastMethod) {
                case 0: {
                    string3 = "Linear regression  (y = a + b.x): " + this.graphTitle;
                    string2 = " points - experimental values;   line - best fit curve";
                    if (this.weightOpt) {
                        string2 = string2 + ";   error bars - weighting factors";
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        dArray[3][n2] = this.best[0] + this.best[1] * dArray[2][n2];
                    }
                    break;
                }
                case 1: {
                    double d;
                    string3 = "Linear (polynomial with degree = " + (this.nParam - 1) + ") regression: " + this.graphTitle;
                    string2 = " points - experimental values;   line - best fit curve";
                    if (this.weightOpt) {
                        string2 = string2 + ";   error bars - weighting factors";
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        d = this.best[0];
                        for (int j = 1; j < this.nParam; ++j) {
                            d += this.best[j] * Math.pow(dArray[2][n2], j);
                        }
                        dArray[3][n2] = d;
                    }
                    break;
                }
                case 2: {
                    string3 = "Linear regression  (y = a.x): " + this.graphTitle;
                    string2 = " points - experimental values;   line - best fit curve";
                    if (this.nXarrays == 1) {
                        if (this.weightOpt) {
                            string2 = string2 + ";   error bars - weighting factors";
                        }
                        for (n2 = 0; n2 < n3; ++n2) {
                            dArray[3][n2] = this.best[0] * dArray[2][n2];
                        }
                        break;
                    }
                    System.out.println("Regression.plotXY(linear): lastMethod, " + this.lastMethod + ",cannot be plotted in two dimensions");
                    System.out.println("No plot attempted");
                    n = -1;
                    break;
                }
                case 11: {
                    string3 = "Linear regression: Minimum Order Statistic Standard Gumbel (y = a.z where z = exp(x)exp(-exp(x))): " + this.graphTitle;
                    string2 = " points - experimental values;   line - best fit curve";
                    if (this.weightOpt) {
                        string2 = string2 + ";   error bars - weighting factors";
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        dArray[3][n2] = this.best[0] * Math.exp(dArray[2][n2]) * Math.exp(-Math.exp(dArray[2][n2]));
                    }
                    break;
                }
                case 12: {
                    string3 = "Linear regression:  Maximum Order Statistic Standard Gumbel (y = a.z where z=exp(-x)exp(-exp(-x))): " + this.graphTitle;
                    string2 = " points - experimental values;   line - best fit curve";
                    if (this.weightOpt) {
                        string2 = string2 + ";   error bars - weighting factors";
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        dArray[3][n2] = this.best[0] * Math.exp(-dArray[2][n2]) * Math.exp(-Math.exp(-dArray[2][n2]));
                    }
                    break;
                }
                case 46: {
                    string3 = "Linear regression:  Fit to a constant (y = a): " + this.graphTitle;
                    string2 = " points - experimental values;   line - best fit curve";
                    if (this.weightOpt) {
                        string2 = string2 + ";   error bars - weighting factors";
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        dArray[3][n2] = this.best[0];
                    }
                    break;
                }
                case 47: {
                    string3 = "Linear regression  (y = fixed intercept + b.x): " + this.graphTitle;
                    string2 = " points - experimental values;   line - best fit curve";
                    if (this.weightOpt) {
                        string2 = string2 + ";   error bars - weighting factors";
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        dArray[3][n2] = this.fixedInterceptL + this.best[0] * dArray[2][n2];
                    }
                    break;
                }
                case 48: {
                    double d;
                    string3 = "Linear (polynomial with degree = " + this.nParam + ") regression: " + this.graphTitle;
                    string2 = "Fixed intercept;   points - experimental values;   line - best fit curve";
                    if (this.weightOpt) {
                        string2 = string2 + ";   error bars - weighting factors";
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        d = this.fixedInterceptP;
                        for (int j = 0; j < this.nParam; ++j) {
                            d += this.best[j] * Math.pow(dArray[2][n2], j + 1);
                        }
                        dArray[3][n2] = d;
                    }
                    break;
                }
                default: {
                    System.out.println("Regression.plotXY(linear): lastMethod, " + this.lastMethod + ", either not recognised or cannot be plotted in two dimensions");
                    System.out.println("No plot attempted");
                    n = -1;
                    return n;
                }
            }
        }
        PlotGraph plotGraph = new PlotGraph(dArray);
        if (this.plotWindowCloseChoice) {
            plotGraph.setCloseChoice(2);
        } else {
            plotGraph.setCloseChoice(1);
        }
        plotGraph.setGraphTitle(string3);
        plotGraph.setGraphTitle2(string2);
        plotGraph.setXaxisLegend(this.xLegend);
        plotGraph.setYaxisLegend(this.yLegend);
        int[] nArray = new int[]{1, 0};
        plotGraph.setPoint(nArray);
        int[] nArray2 = new int[]{0, 3};
        plotGraph.setLine(nArray2);
        if (this.weightOpt) {
            plotGraph.setErrorBars(0, this.weight);
        }
        plotGraph.plot();
        return n;
    }

    public int plotXYnonlinear(Object object, String string) {
        this.graphTitle = string;
        RegressionFunction regressionFunction = null;
        RegressionFunction2 regressionFunction2 = null;
        RegressionFunction3 regressionFunction3 = null;
        switch (this.simplexFlag) {
            case 1: {
                regressionFunction = (RegressionFunction)object;
                break;
            }
            case 2: {
                regressionFunction2 = (RegressionFunction2)object;
                break;
            }
            case 3: 
            case 4: {
                regressionFunction3 = (RegressionFunction3)object;
            }
        }
        int n = 0;
        if (this.lastMethod < 3) {
            System.out.println("Regression.plotXY(non-linear): lastMethod, " + this.lastMethod + ", either not recognised or cannot be plotted in two dimensions");
            System.out.println("No plot attempted");
            n = -1;
            return n;
        }
        if (this.nXarrays > 1) {
            System.out.println("Multiple Linear Regression with more than one independent variable cannot be plotted in two dimensions");
            System.out.println("plotYY() called instead of plotXY()");
            this.plotYY(string);
            n = -2;
        } else {
            int n2 = 2;
            int n3 = 200;
            if (n3 < this.nData0) {
                n3 = this.nData0;
            }
            if (this.lastMethod == 6) {
                n3 = this.nData0;
            }
            double[][] dArray = PlotGraph.data(n2, n3);
            for (int j = 0; j < this.nData0; ++j) {
                dArray[0][j] = this.xData[0][j];
                dArray[1][j] = this.yData[j];
            }
            if (this.lastMethod == 6) {
                double[] dArray2 = new double[this.nXarrays];
                for (int j = 0; j < n3; ++j) {
                    dArray[2][j] = dArray[0][j];
                    dArray2[0] = dArray[2][j];
                    dArray[3][j] = regressionFunction.function(this.best, dArray2);
                }
            } else {
                double d = Fmath.minimum(this.xData[0]);
                double d2 = Fmath.maximum(this.xData[0]);
                double d3 = (d2 - d) / (double)(n3 - 1);
                dArray[2][0] = d;
                for (int j = 1; j < n3; ++j) {
                    dArray[2][j] = dArray[2][j - 1] + d3;
                }
                dArray[2][n3 - 1] = d2;
                double[] dArray3 = new double[this.nXarrays];
                switch (this.simplexFlag) {
                    case 1: {
                        for (int j = 0; j < n3; ++j) {
                            dArray3[0] = dArray[2][j];
                            dArray[3][j] = regressionFunction.function(this.best, dArray3);
                        }
                        break;
                    }
                    case 2: {
                        CubicSpline cubicSpline = new CubicSpline(this.xData[0], this.yCalc);
                        for (int j = 0; j < n3; ++j) {
                            dArray[3][j] = cubicSpline.interpolate(dArray[2][j]);
                        }
                        break;
                    }
                    case 3: 
                    case 4: {
                        int n4;
                        boolean bl = false;
                        for (n4 = 0; n4 < this.nSpecDual; ++n4) {
                            if (this.lastMethod != this.dualMethods[n4]) continue;
                            bl = true;
                        }
                        if (bl) {
                            for (n4 = 0; n4 < n3; ++n4) {
                                dArray3[0] = dArray[2][n4];
                                dArray[3][n4] = regressionFunction3.function(this.best, dArray3, -1)[0];
                            }
                        } else {
                            CubicSpline cubicSpline = new CubicSpline(this.xData[0], this.yCalc);
                            for (int j = 0; j < n3; ++j) {
                                dArray[3][j] = cubicSpline.interpolate(dArray[2][j]);
                            }
                        }
                        break;
                    }
                }
            }
            String string2 = this.setGandPtitle(string);
            String string3 = " points - experimental values;   line - best fit curve";
            if (this.weightOpt) {
                string3 = string3 + ";   error bars - weighting factors";
            }
            PlotGraph plotGraph = new PlotGraph(dArray);
            if (this.plotWindowCloseChoice) {
                plotGraph.setCloseChoice(2);
            } else {
                plotGraph.setCloseChoice(1);
            }
            plotGraph.setGraphTitle(string2);
            plotGraph.setGraphTitle2(string3);
            plotGraph.setXaxisLegend(this.xLegend);
            plotGraph.setYaxisLegend(this.yLegend);
            int[] nArray = new int[]{1, 0};
            plotGraph.setPoint(nArray);
            int[] nArray2 = new int[]{0, 3};
            plotGraph.setLine(nArray2);
            if (this.weightOpt) {
                plotGraph.setErrorBars(0, this.weight);
            }
            plotGraph.plot();
        }
        return n;
    }

    public int plotXYfixed(Object object, String string) {
        int n = 0;
        if (this.multipleY) {
            System.out.println("You attempted to use Regression.plotXY() for a multiply dimensioned y array");
            System.out.println("No plot attempted");
            n = -1;
        } else {
            RegressionFunction regressionFunction = null;
            RegressionFunction2 regressionFunction2 = null;
            RegressionFunction3 regressionFunction3 = null;
            switch (this.simplexFlag) {
                case 1: {
                    regressionFunction = (RegressionFunction)object;
                    break;
                }
                case 2: {
                    regressionFunction2 = (RegressionFunction2)object;
                    break;
                }
                case 3: 
                case 4: {
                    regressionFunction3 = (RegressionFunction3)object;
                }
            }
            if (this.lastMethod < 3) {
                System.out.println("Regression.plotXY(non-linear): lastMethod, " + this.lastMethod + ", either not recognised or cannot be plotted in two dimensions");
                System.out.println("No plot attempted");
                n = -1;
                return n;
            }
            if (this.nXarrays > 1) {
                System.out.println("Multiple Linear Regression with more than one independent variable cannot be plotted in two dimensions");
                System.out.println("plotYY() called instead of plotXY()");
                this.plotYY(string);
                n = -2;
            } else {
                int n2 = 2;
                int n3 = 200;
                if (n3 < this.nData0) {
                    n3 = this.nData0;
                }
                if (this.lastMethod == 6) {
                    n3 = this.nData0;
                }
                double[][] dArray = PlotGraph.data(n2, n3);
                for (int j = 0; j < this.nData0; ++j) {
                    dArray[0][j] = this.xData[0][j];
                    dArray[1][j] = this.yData[j];
                }
                if (this.lastMethod == 6) {
                    double[] dArray2 = new double[this.nXarrays];
                    for (int j = 0; j < n3; ++j) {
                        dArray[2][j] = dArray[0][j];
                        dArray2[0] = dArray[2][j];
                        dArray[3][j] = regressionFunction.function(this.values, dArray2);
                    }
                } else {
                    double d = Fmath.minimum(this.xData[0]);
                    double d2 = Fmath.maximum(this.xData[0]);
                    double d3 = (d2 - d) / (double)(n3 - 1);
                    dArray[2][0] = d;
                    for (int j = 1; j < n3; ++j) {
                        dArray[2][j] = dArray[2][j - 1] + d3;
                    }
                    double[] dArray3 = new double[this.nXarrays];
                    switch (this.simplexFlag) {
                        case 1: {
                            for (int j = 0; j < n3; ++j) {
                                dArray3[0] = dArray[2][j];
                                dArray[3][j] = regressionFunction.function(this.best, dArray3);
                            }
                            break;
                        }
                        case 2: {
                            CubicSpline cubicSpline = new CubicSpline(this.xData[0], this.yCalc);
                            for (int j = 0; j < n3; ++j) {
                                dArray[3][j] = cubicSpline.interpolate(dArray[2][j]);
                            }
                            break;
                        }
                        case 3: 
                        case 4: {
                            int n4;
                            boolean bl = false;
                            for (n4 = 0; n4 < this.nSpecDual; ++n4) {
                                if (this.lastMethod != this.dualMethods[n4]) continue;
                                bl = true;
                            }
                            if (bl) {
                                for (n4 = 0; n4 < n3; ++n4) {
                                    dArray3[0] = dArray[2][n4];
                                    dArray[3][n4] = regressionFunction3.function(this.best, dArray3, -1)[0];
                                }
                            } else {
                                CubicSpline cubicSpline = new CubicSpline(this.xData[0], this.yCalc);
                                for (int j = 0; j < n3; ++j) {
                                    dArray[3][j] = cubicSpline.interpolate(dArray[2][j]);
                                }
                            }
                            break;
                        }
                    }
                }
                String string2 = this.setGandPtitle(string);
                String string3 = " points - experimental values;   line - best fit curve";
                if (this.weightOpt) {
                    string3 = string3 + ";   error bars - weighting factors";
                }
                PlotGraph plotGraph = new PlotGraph(dArray);
                if (this.plotWindowCloseChoice) {
                    plotGraph.setCloseChoice(2);
                } else {
                    plotGraph.setCloseChoice(1);
                }
                plotGraph.setGraphTitle(string2);
                plotGraph.setGraphTitle2(string3);
                plotGraph.setXaxisLegend(this.xLegend);
                plotGraph.setYaxisLegend(this.yLegend);
                int[] nArray = new int[]{1, 0};
                plotGraph.setPoint(nArray);
                int[] nArray2 = new int[]{0, 3};
                plotGraph.setLine(nArray2);
                if (this.weightOpt) {
                    plotGraph.setErrorBars(0, this.weight);
                }
                plotGraph.plot();
            }
        }
        return n;
    }

    public double[] getWeights() {
        return this.weight;
    }

    public int getNparameters() {
        return this.nParam;
    }

    public int getNdata() {
        return this.nData;
    }

    public boolean getNlrStatus() {
        return this.nlrStatus;
    }

    public void setScale(int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("The argument must be 0 (no scaling) 1(initial estimates all scaled to unity) or the array of scaling factors");
        }
        this.scaleOpt = n;
    }

    public void setScale(double[] dArray) {
        this.scale = dArray;
        this.scaleOpt = 2;
    }

    public double[] getScale() {
        return Conv.copy(this.scale);
    }

    public void setMinTest(int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("minTest must be 0 or 1");
        }
        this.minTest = n;
    }

    public int getMinTest() {
        return this.minTest;
    }

    public double getSimplexSd() {
        return this.simplexSd;
    }

    public double getVarianceOfObserations() {
        return this.obsnVariance;
    }

    public double[] getBestEstimates() {
        return Conv.copy(this.best);
    }

    public double[] getCoeff() {
        return Conv.copy(this.best);
    }

    public double[] getbestestimatesStandardDeviations() {
        return Conv.copy(this.bestSd);
    }

    public double[] getBestEstimatesStandardDeviations() {
        return Conv.copy(this.bestSd);
    }

    public double[] getCoeffSd() {
        return Conv.copy(this.bestSd);
    }

    public double[] getBestEstimatesErrors() {
        return Conv.copy(this.bestSd);
    }

    public double[] getInitialEstimates() {
        return Conv.copy(this.startH);
    }

    public double[] getScaledInitialEstimates() {
        return Conv.copy(this.startSH);
    }

    public double[] getInitialSteps() {
        return Conv.copy(this.stepH);
    }

    public double[] getScaledInitialSteps() {
        return Conv.copy(this.stepSH);
    }

    public double[] getCoeffVar() {
        double[] dArray = new double[this.nParam];
        for (int j = 0; j < this.nParam; ++j) {
            dArray[j] = this.bestSd[j] * 100.0 / this.best[j];
        }
        return dArray;
    }

    public double[] getPseudoSd() {
        return Conv.copy(this.pseudoSd);
    }

    public double[] getPseudoErrors() {
        return Conv.copy(this.pseudoSd);
    }

    public double[] getTvalues() {
        return Conv.copy(this.tValues);
    }

    public double[] getPvalues() {
        return Conv.copy(this.pValues);
    }

    public double[][] getXdata() {
        return Conv.copy(this.xData);
    }

    public double[] getYdata() {
        return Conv.copy(this.yData);
    }

    public double[] getYcalc() {
        double[] dArray = new double[this.nData];
        for (int j = 0; j < this.nData; ++j) {
            dArray[j] = this.yCalc[j];
        }
        return dArray;
    }

    public double[] getResiduals() {
        double[] dArray = new double[this.nData];
        for (int j = 0; j < this.nData; ++j) {
            dArray[j] = this.yData[j] - this.yCalc[j];
        }
        return dArray;
    }

    public double[] getWeightedResiduals() {
        double[] dArray = new double[this.nData];
        for (int j = 0; j < this.nData; ++j) {
            dArray[j] = (this.yData[j] - this.yCalc[j]) / this.weight[j];
        }
        return dArray;
    }

    public double getSumOfSquares() {
        return this.sumOfSquaresError;
    }

    public double getSumOfUnweightedResidualSquares() {
        return this.sumOfSquaresError;
    }

    public double getSumOfWeightedResidualSquares() {
        return this.chiSquare;
    }

    public double getChiSquare() {
        return this.chiSquare;
    }

    public double getReducedChiSquare() {
        return this.reducedChiSquare;
    }

    public double getTotalSumOfWeightedSquares() {
        return this.sumOfSquaresTotal;
    }

    public double getRegressionSumOfWeightedSquares() {
        return this.sumOfSquaresRegrn;
    }

    public double getCoefficientOfDetermination() {
        return this.multR;
    }

    public double getSampleR() {
        return this.multR;
    }

    public double getAdjustedCoefficientOfDetermination() {
        return this.adjustedR;
    }

    public double getCoeffDeterminationFratio() {
        return this.multipleF;
    }

    public double getCoeffDeterminationFratioProb() {
        return this.multipleFprob;
    }

    public double[][] getCovMatrix() {
        return Conv.copy(this.covar);
    }

    public double[][] getCorrCoeffMatrix() {
        return Conv.copy(this.corrCoeff);
    }

    public double[][] getFirstDerivatives() {
        return Conv.copy(this.firstDerivs);
    }

    public int getNiter() {
        return this.nIter;
    }

    public void setNmax(int n) {
        this.nMax = n;
    }

    public int getNmax() {
        return this.nMax;
    }

    public void setNmin(int n) {
        this.minIter = n;
    }

    public int getNmin() {
        return this.minIter;
    }

    public int getNrestarts() {
        return this.kRestart;
    }

    public void setNrestartsMax(int n) {
        this.konvge = n;
    }

    public int getNrestartsMax() {
        return this.konvge;
    }

    public double getDegFree() {
        return this.degreesOfFreedom;
    }

    public void setNMreflect(double d) {
        this.rCoeff = d;
    }

    public double getNMreflect() {
        return this.rCoeff;
    }

    public void setNMextend(double d) {
        this.eCoeff = d;
    }

    public double getNMextend() {
        return this.eCoeff;
    }

    public void setNMcontract(double d) {
        this.cCoeff = d;
    }

    public double getNMcontract() {
        return this.cCoeff;
    }

    public void setTolerance(double d) {
        this.fTol = d;
    }

    public double getTolerance() {
        return this.fTol;
    }

    public double[][] getGrad() {
        return this.grad;
    }

    public void setDelta(double d) {
        this.delta = d;
    }

    public double getDelta() {
        return this.delta;
    }

    public boolean getInversionCheck() {
        return this.invertFlag;
    }

    public boolean getPosVarCheck() {
        return this.posVarFlag;
    }

    public static ArrayList<Object> testOfAdditionalTerms(double d, int n, double d2, int n2, int n3) {
        return Regression.testOfAdditionalTerms(d, n, d2, n2, n3, 0.05);
    }

    public static ArrayList<Object> testOfAdditionalTerms(double d, int n, double d2, int n2, int n3, double d3) {
        ArrayList<Object> arrayList = Regression.testOfAdditionalTerms_ArrayList(d, n, d2, n2, n3);
        ArrayList<Object> arrayList2 = null;
        if (arrayList != null) {
            int n4 = arrayList2.size();
            arrayList2 = new ArrayList<Object>(n4);
            for (int j = 0; j < n4; ++j) {
                arrayList2.add(arrayList.get(j));
            }
        }
        return arrayList2;
    }

    public static ArrayList<Object> testOfAdditionalTerms_ArrayList(double d, int n, double d2, int n2, int n3) {
        return Regression.testOfAdditionalTerms(d, n, d2, n2, n3, 0.05);
    }

    public static ArrayList<Object> testOfAdditionalTerms_ArrayList(double d, int n, double d2, int n2, int n3, double d3) {
        return Regression.testOfAdditionalTerms(d, n, d2, n2, n3, d3);
    }

    public static double testOfAdditionalTermsFratio(double d, int n, double d2, int n2, int n3) {
        return Regression.testOfAdditionalTermsFratio(d, n, d2, n2, n3, 0.05);
    }

    public static double testOfAdditionalTermsFratio(double d, int n, double d2, int n2, int n3, double d3) {
        int n4 = n3 - n;
        int n5 = n3 - n2;
        boolean bl = false;
        if (n4 < n5) {
            bl = true;
            double d4 = d;
            d = d2;
            d2 = d4;
            int n6 = n;
            n = n2;
            n2 = n6;
            n4 = n3 - n;
            n5 = n3 - n2;
            System.out.println("package flanagan.analysis; class Regression; method testAdditionalTermsFratio");
            System.out.println("the order of the chi-squares has been reversed to give a second chi- square with the lowest degrees of freedom");
        }
        int n7 = n4 - n5;
        double d5 = (d - d2) / (double)n7;
        double d6 = d2 / (double)n5;
        double d7 = d5 / d6;
        return d7;
    }

    public static double testOfAdditionalTermsFprobability(double d, int n, double d2, int n2, int n3) {
        return Regression.testOfAdditionalTermsFprobability(d, n, d2, n2, n3, 0.05);
    }

    public static double testOfAdditionalTermsFprobability(double d, int n, double d2, int n2, int n3, double d3) {
        int n4 = n3 - n;
        int n5 = n3 - n2;
        boolean bl = false;
        if (n4 < n5) {
            bl = true;
            double d4 = d;
            d = d2;
            d2 = d4;
            int n6 = n;
            n = n2;
            n2 = n6;
            n4 = n3 - n;
            n5 = n3 - n2;
            System.out.println("package flanagan.analysis; class Regression; method testAdditionalTermsFprobability");
            System.out.println("the order of the chi-squares has been reversed to give a second chi- square with the lowest degrees of freedom");
        }
        int n7 = n4 - n5;
        double d5 = (d - d2) / (double)n7;
        double d6 = d2 / (double)n5;
        double d7 = d5 / d6;
        double d8 = 1.0;
        if (d > d2) {
            d8 = Stat.fTestProb(d7, n7, n5);
        }
        return d8;
    }

    public static double testOfAdditionalTermsFprobabilty(double d, int n, double d2, int n2, int n3) {
        return Regression.testOfAdditionalTermsFprobability(d, n, d2, n2, n3, 0.05);
    }

    public void poisson() {
        this.userSupplied = false;
        this.fitPoisson(0);
    }

    public void poissonPlot() {
        this.userSupplied = false;
        this.fitPoisson(1);
    }

    protected void fitPoisson(int n) {
        Object object;
        Object object2;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 6;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 2;
        if (!this.scaleFlag) {
            this.nParam = 2;
        }
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        for (int j = 0; j < this.nData; ++j) {
            if (this.xData[0][j] - Math.floor(this.xData[0][j]) == 0.0) continue;
            throw new IllegalArgumentException("all abscissae must be, mathematically, integer values");
        }
        ArrayList<Object> arrayList = Regression.dataSign(this.yData);
        Double d = null;
        Integer n2 = null;
        n2 = (Integer)arrayList.get(5);
        int n3 = n2;
        double d2 = this.xData[0][n3];
        d = (Double)arrayList.get(4);
        double d3 = d;
        double[] dArray = new double[this.nParam];
        double[] dArray2 = new double[this.nParam];
        dArray[0] = d2;
        if (this.scaleFlag) {
            dArray[1] = d3 / (Math.exp(d2 * Math.log(d2) - Stat.logFactorial(d2)) * Math.exp(-d2));
        }
        dArray2[0] = 0.1 * dArray[0];
        if (dArray2[0] == 0.0) {
            object2 = Regression.dataSign(this.xData[0]);
            object = null;
            object = (Double)((ArrayList)object2).get(2);
            double d4 = (Double)object;
            if (d4 == 0.0) {
                object = (Double)((ArrayList)object2).get(0);
                d4 = (Double)object;
            }
            dArray2[0] = d4 * 0.1;
        }
        if (this.scaleFlag) {
            dArray2[1] = 0.1 * dArray[1];
        }
        object2 = new PoissonFunction();
        this.addConstraint(1, -1, 0.0);
        ((PoissonFunction)object2).setScaleOption(this.scaleFlag);
        ((PoissonFunction)object2).setScaleFactor(this.yScaleFactor);
        object = object2;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.nelderMead(object, null, dArray, dArray2, this.fTol, this.nMax);
        if (n == 1) {
            if (!this.suppressPrint) {
                this.print();
            }
            this.plotOpt = false;
            int n4 = this.plotXY((RegressionFunction)object2);
            if (n4 != -2 && !this.suppressYYplot) {
                this.plotYY();
            }
        }
    }

    public void gaussian() {
        this.userSupplied = false;
        this.fitGaussian(0);
    }

    public void normal() {
        this.userSupplied = false;
        this.fitGaussian(0);
    }

    public void gaussianPlot() {
        this.userSupplied = false;
        this.fitGaussian(1);
    }

    public void normalPlot() {
        this.userSupplied = false;
        this.fitGaussian(1);
    }

    protected void fitGaussian(int n) {
        Object object;
        Object object2;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 4;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 3;
        if (!this.scaleFlag) {
            this.nParam = 2;
        }
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double d = null;
        ArrayList<Object> arrayList = Regression.dataSign(this.yData);
        d = (Double)arrayList.get(4);
        double d2 = d;
        boolean bl = false;
        if (d2 < 0.0) {
            System.out.println("Regression.fitGaussian(): This implementation of the Gaussian distribution takes only positive y values\n(noise taking low values below zero are allowed)");
            System.out.println("All y values have been multiplied by -1 before fitting");
            for (int j = 0; j < this.nData; ++j) {
                this.yData[j] = -this.yData[j];
            }
            arrayList = Regression.dataSign(this.yData);
            bl = true;
        }
        ArrayList<Object> arrayList2 = Regression.dataSign(this.yData);
        Integer n2 = null;
        n2 = (Integer)arrayList2.get(5);
        int n3 = n2;
        double d3 = this.xData[0][n3];
        double d4 = Math.sqrt(2.0) * Regression.halfWidth(this.xData[0], this.yData);
        d = (Double)arrayList2.get(4);
        double d5 = d;
        d5 = d5 * d4 * Math.sqrt(Math.PI * 2);
        double[] dArray = new double[this.nParam];
        double[] dArray2 = new double[this.nParam];
        dArray[0] = d3;
        dArray[1] = d4;
        if (this.scaleFlag) {
            dArray[2] = d5;
        }
        dArray2[0] = 0.1 * d4;
        dArray2[1] = 0.1 * dArray[1];
        if (dArray2[1] == 0.0) {
            object2 = Regression.dataSign(this.xData[0]);
            object = null;
            object = (Double)((ArrayList)object2).get(2);
            double d6 = (Double)object;
            if (d6 == 0.0) {
                object = (Double)((ArrayList)object2).get(0);
                d6 = (Double)object;
            }
            dArray2[1] = d6 * 0.1;
        }
        if (this.scaleFlag) {
            dArray2[2] = 0.1 * dArray[2];
        }
        object2 = new GaussianFunction();
        this.addConstraint(1, -1, 0.0);
        ((GaussianFunction)object2).setScaleOption(this.scaleFlag);
        ((GaussianFunction)object2).setScaleFactor(this.yScaleFactor);
        object = object2;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.nelderMead(object, null, dArray, dArray2, this.fTol, this.nMax);
        if (n == 1) {
            int n4;
            if (!this.suppressPrint) {
                this.print();
            }
            if ((n4 = this.plotXY((RegressionFunction)object2)) != -2 && !this.suppressYYplot) {
                this.plotYY();
            }
        }
        if (bl) {
            for (int j = 0; j < this.nData - 1; ++j) {
                this.yData[j] = -this.yData[j];
            }
        }
    }

    public void gaussian(double[] dArray, boolean[] blArray) {
        this.userSupplied = true;
        this.fitGaussianFixed(dArray, blArray, 0);
    }

    public void normal(double[] dArray, boolean[] blArray) {
        this.userSupplied = true;
        this.fitGaussianFixed(dArray, blArray, 0);
    }

    public void gaussianPlot(double[] dArray, boolean[] blArray) {
        this.userSupplied = true;
        this.fitGaussianFixed(dArray, blArray, 1);
    }

    public void normalPlot(double[] dArray, boolean[] blArray) {
        this.userSupplied = true;
        this.fitGaussianFixed(dArray, blArray, 1);
    }

    protected void fitGaussianFixed(double[] dArray, boolean[] blArray, int n) {
        int n2;
        int n3;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 38;
        this.values = dArray;
        this.fixed = blArray;
        this.scaleFlag = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 3;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double d = null;
        ArrayList<Object> arrayList = Regression.dataSign(this.yData);
        d = (Double)arrayList.get(4);
        double d2 = d;
        boolean bl = false;
        if (d2 < 0.0) {
            System.out.println("Regression.fitGaussian(): This implementation of the Gaussian distribution takes only positive y values\n(noise taking low values below zero are allowed)");
            System.out.println("All y values have been multiplied by -1 before fitting");
            for (int j = 0; j < this.nData; ++j) {
                this.yData[j] = -this.yData[j];
            }
            arrayList = Regression.dataSign(this.yData);
            bl = true;
        }
        GaussianFunctionFixed gaussianFunctionFixed = new GaussianFunctionFixed();
        gaussianFunctionFixed.setFixed(blArray);
        gaussianFunctionFixed.setParam(dArray);
        int n4 = this.nParam;
        for (int j = 0; j < this.nParam; ++j) {
            if (!blArray[j]) continue;
            --n4;
        }
        if (n4 == 0) {
            if (n == 0) {
                throw new IllegalArgumentException("At least one parameter must be available for variation by the Regression procedure or GauasianPlot should have been called and not Gaussian");
            }
            n = 3;
        }
        double[] dArray2 = new double[n4];
        double[] dArray3 = new double[n4];
        boolean[] blArray2 = new boolean[n4];
        double d3 = Fmath.minimum(this.xData[0]);
        double d4 = Fmath.maximum(this.xData[0]);
        double d5 = Fmath.maximum(this.yData);
        if (dArray[2] == 0.0) {
            if (blArray[2]) {
                throw new IllegalArgumentException("Scale factor has been fixed at zero");
            }
            dArray[2] = d5;
        }
        int n5 = 0;
        for (n3 = 0; n3 < this.nParam; ++n3) {
            if (blArray[n3]) continue;
            dArray2[n5] = dArray[n3];
            dArray3[n5] = dArray2[n5] * 0.1;
            if (dArray3[n5] == 0.0) {
                dArray3[n5] = (d4 - d3) * 0.1;
            }
            blArray2[n5] = false;
            if (n3 == 1) {
                blArray2[n5] = true;
            }
            ++n5;
        }
        this.nParam = n4;
        for (n3 = 0; n3 < this.nParam; ++n3) {
            if (!blArray2[n3]) continue;
            this.addConstraint(n3, -1, 0.0);
        }
        GaussianFunctionFixed gaussianFunctionFixed2 = gaussianFunctionFixed;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        if (n != 3) {
            this.nelderMead(gaussianFunctionFixed2, null, dArray2, dArray3, this.fTol, this.nMax);
        }
        if (n == 1) {
            if (!this.suppressPrint) {
                this.print();
            }
            if ((n2 = this.plotXY(gaussianFunctionFixed)) != -2 && !this.suppressYYplot) {
                this.plotYY();
            }
        }
        if (n == 3) {
            n2 = this.plotXYfixed(gaussianFunctionFixed2, "Gaussian distribution - all parameters fixed");
        }
        if (bl) {
            for (n2 = 0; n2 < this.nData - 1; ++n2) {
                this.yData[n2] = -this.yData[n2];
            }
        }
    }

    public void multipleGaussiansPlot(int n, double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray.length != n) {
            throw new IllegalArgumentException("length of initial means array, " + dArray.length + ", does not equal the number of Gaussians, " + n);
        }
        if (dArray2.length != n) {
            throw new IllegalArgumentException("length of initial standard deviations array, " + dArray2.length + ", does not equal the number of Gaussians, " + n);
        }
        if (dArray3.length != n) {
            throw new IllegalArgumentException("length of initial fractional weight array, " + dArray3.length + ", does not equal the number of Gaussians, " + n);
        }
        double d = 0.0;
        for (int j = 0; j < n; ++j) {
            d += dArray3[j];
        }
        if (d != 1.0) {
            System.out.println("Regression method multipleGaussiansPlot: the sum of the initial estimates of the fractional weight, " + d + ", does not equal 1.0");
            System.out.println("Program continued using the supplied fractional weight");
        }
        this.fitMultipleGaussians(n, dArray, dArray2, dArray3, 1);
    }

    protected void fitMultipleGaussians(int n, double[] dArray, double[] dArray2, double[] dArray3, int n2) {
        this.nGaussians = n;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 49;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 3 * this.nGaussians;
        boolean bl = this.scaleFlag;
        this.scaleFlag = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        int n3 = this.nMax;
        if (this.nMax < 10000) {
            this.nMax = 10000;
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double d = null;
        ArrayList<Object> arrayList = Regression.dataSign(this.yData);
        d = (Double)arrayList.get(4);
        double d2 = d;
        boolean bl2 = false;
        if (d2 < 0.0) {
            System.out.println("Regression.fitGaussian(): This implementation of the Gaussian distribution takes only positive y values\n(noise taking low values below zero are allowed)");
            System.out.println("All y values have been multiplied by -1 before fitting");
            for (int j = 0; j < this.nData; ++j) {
                this.yData[j] = -this.yData[j];
            }
            arrayList = Regression.dataSign(this.yData);
            bl2 = true;
        }
        ArrayList<Object> arrayList2 = Regression.dataSign(this.yData);
        Integer n4 = null;
        n4 = (Integer)arrayList2.get(5);
        int n5 = n4;
        double d3 = this.xData[0][n5];
        double d4 = Math.sqrt(2.0) * Regression.halfWidth(this.xData[0], this.yData);
        d = (Double)arrayList2.get(4);
        double d5 = d;
        double[] dArray4 = new double[this.nParam];
        double[] dArray5 = new double[this.nParam];
        int n6 = 0;
        for (int j = 0; j < n; ++j) {
            dArray4[n6] = dArray[j];
            dArray5[n6] = Math.abs(0.1 * dArray4[n6]);
            dArray4[n6 + 1] = dArray2[j];
            dArray5[n6 + 1] = Math.abs(0.1 * dArray4[n6 + 1]);
            if (dArray5[n6 + 1] == 0.0) {
                ArrayList<Object> arrayList3 = Regression.dataSign(this.xData[0]);
                Double d6 = null;
                d6 = (Double)arrayList3.get(2);
                double d7 = d6;
                if (d7 == 0.0) {
                    d6 = (Double)arrayList3.get(0);
                    d7 = d6;
                }
                dArray5[n6 + 1] = Math.abs(d7 * 0.1);
            }
            dArray4[n6 + 2] = dArray3[j] * Math.sqrt(Math.PI * 2) * dArray4[n6 + 1] * d5;
            dArray5[n6 + 2] = Math.abs(0.1 * dArray4[n6 + 2]);
            n6 += 3;
        }
        MultipleGaussianFunction multipleGaussianFunction = new MultipleGaussianFunction();
        multipleGaussianFunction.setScaleOption(this.scaleFlag);
        double d8 = this.yScaleFactor;
        if (!this.scaleFlag) {
            d8 = 1.0;
        }
        multipleGaussianFunction.setScaleFactor(d8);
        multipleGaussianFunction.setNgaussians(this.nGaussians);
        for (int j = 0; j < this.nGaussians; ++j) {
            this.addConstraint(3 * j + 1, -1, 0.0);
            this.addConstraint(3 * j + 2, -1, 0.0);
        }
        MultipleGaussianFunction multipleGaussianFunction2 = multipleGaussianFunction;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.nelderMead(multipleGaussianFunction2, null, dArray4, dArray5, this.fTol, this.nMax);
        this.multGaussFract = new double[this.nGaussians];
        this.multGaussFractErrors = new double[this.nGaussians];
        this.multGaussCoeffVar = new double[this.nGaussians];
        this.multGaussTvalue = new double[this.nGaussians];
        this.multGaussPvalue = new double[this.nGaussians];
        for (int j = 0; j < n; ++j) {
            this.multGaussFractErrors[j] = Double.NaN;
            this.multGaussCoeffVar[j] = Double.NaN;
            this.multGaussTvalue[j] = Double.NaN;
            this.multGaussPvalue[j] = Double.NaN;
        }
        this.multGaussScaleError = Double.NaN;
        this.multGaussScaleCoeffVar = Double.NaN;
        this.multGaussScaleTvalue = Double.NaN;
        this.multGaussScalePvalue = Double.NaN;
        this.multGaussScaleTvalue = Double.NaN;
        this.multGaussScalePvalue = Double.NaN;
        if (this.invertFlag) {
            ErrorProp[] errorPropArray = new ErrorProp[this.nGaussians];
            ErrorProp errorProp = new ErrorProp(0.0, 0.0);
            for (int j = 0; j < n; ++j) {
                errorPropArray[j] = new ErrorProp(this.best[3 * j + 2], this.bestSd[3 * j + 2]);
                errorProp = errorProp.plus(errorPropArray[j]);
            }
            ErrorProp errorProp2 = new ErrorProp(0.0, 0.0);
            for (int j = 0; j < n; ++j) {
                ErrorProp errorProp3 = errorPropArray[j].over(errorProp);
                this.multGaussFract[j] = errorProp3.getValue();
                this.multGaussFractErrors[j] = errorProp3.getError();
                errorProp2 = errorProp2.plus(errorPropArray[j].over(errorProp3));
                this.multGaussCoeffVar[j] = 100.0 * this.multGaussFractErrors[j] / this.multGaussFract[j];
                this.multGaussTvalue[j] = this.multGaussFract[j] / this.multGaussFractErrors[j];
                double d9 = Math.abs(this.multGaussTvalue[j]);
                this.multGaussPvalue[j] = d9 != d9 ? Double.NaN : 1.0 - Stat.studentTcdf(-d9, d9, this.degreesOfFreedom);
            }
            errorProp2 = errorProp2.over(this.nGaussians);
            this.multGaussScale = errorProp2.getValue();
            this.multGaussScaleError = errorProp2.getError();
            this.multGaussScaleCoeffVar = 100.0 * this.multGaussScaleError / this.multGaussScale;
            this.multGaussScaleTvalue = this.multGaussScale / this.multGaussScaleError;
            double d10 = Math.abs(this.multGaussScaleTvalue);
            this.multGaussScalePvalue = d10 != d10 ? Double.NaN : 1.0 - Stat.studentTcdf(-d10, d10, this.degreesOfFreedom);
        } else {
            int n7;
            double d11 = 0.0;
            for (n7 = 0; n7 < n; ++n7) {
                d11 += this.best[3 * n7 + 2];
            }
            this.multGaussScale = 0.0;
            for (n7 = 0; n7 < n; ++n7) {
                this.multGaussFract[n7] = this.best[3 * n7 + 2] / d11;
                this.multGaussScale += this.multGaussFract[n7];
            }
            this.multGaussScale /= (double)this.nGaussians;
        }
        if (n2 == 1) {
            int n8;
            if (!this.suppressPrint) {
                this.print();
            }
            if ((n8 = this.plotXY(multipleGaussianFunction)) != -2 && !this.suppressYYplot) {
                this.plotYY();
            }
        }
        if (bl2) {
            for (int j = 0; j < this.nData - 1; ++j) {
                this.yData[j] = -this.yData[j];
            }
        }
        this.nMax = n3;
        this.scaleFlag = bl;
    }

    public void logNormal() {
        this.fitLogNormalTwoPar(0);
    }

    public void logNormalTwoPar() {
        this.fitLogNormalTwoPar(0);
    }

    public void logNormalPlot() {
        this.fitLogNormalTwoPar(1);
    }

    public void logNormalTwoParPlot() {
        this.fitLogNormalTwoPar(1);
    }

    protected void fitLogNormalTwoPar(int n) {
        double d;
        Object object;
        Object object2;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 36;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 3;
        if (!this.scaleFlag) {
            this.nParam = 2;
        }
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double d2 = null;
        ArrayList<Object> arrayList = Regression.dataSign(this.yData);
        d2 = (Double)arrayList.get(4);
        double d3 = d2;
        boolean bl = false;
        if (d3 < 0.0) {
            System.out.println("Regression.fitLogNormalTwoPar(): This implementation of the two parameter log-nprmal distribution takes only positive y values\n(noise taking low values below zero are allowed)");
            System.out.println("All y values have been multiplied by -1 before fitting");
            for (int j = 0; j < this.nData; ++j) {
                this.yData[j] = -this.yData[j];
            }
            arrayList = Regression.dataSign(this.yData);
            bl = true;
        }
        ArrayList<Object> arrayList2 = Regression.dataSign(this.yData);
        Integer n2 = null;
        n2 = (Integer)arrayList2.get(5);
        int n3 = n2;
        double d4 = this.xData[0][n3];
        double d5 = 0.0;
        for (int j = 0; j < this.nData; ++j) {
            d5 += Math.log(this.xData[0][j]);
        }
        d5 /= (double)this.nData;
        double d6 = 0.0;
        for (int j = 0; j < this.nData; ++j) {
            d6 += Fmath.square(Math.log(this.xData[0][j]) - d5);
        }
        d6 = Math.sqrt(d6 / (double)this.nData);
        d2 = (Double)arrayList2.get(4);
        double d7 = d2;
        d7 *= Math.exp(d5 - d6 * d6 / 2.0);
        double[] dArray = new double[this.nParam];
        double[] dArray2 = new double[this.nParam];
        dArray[0] = d5;
        dArray[1] = d6;
        if (this.scaleFlag) {
            dArray[2] = d7;
        }
        dArray2[0] = 0.1 * dArray[0];
        dArray2[1] = 0.1 * dArray[1];
        if (dArray2[0] == 0.0) {
            object2 = Regression.dataSign(this.xData[0]);
            object = null;
            object = (Double)((ArrayList)object2).get(2);
            d = (Double)object;
            if (d == 0.0) {
                object = (Double)((ArrayList)object2).get(0);
                d = (Double)object;
            }
            dArray2[0] = d * 0.1;
        }
        if (dArray2[0] == 0.0) {
            object2 = Regression.dataSign(this.xData[0]);
            object = null;
            object = (Double)((ArrayList)object2).get(2);
            d = (Double)object;
            if (d == 0.0) {
                object = (Double)((ArrayList)object2).get(0);
                d = (Double)object;
            }
            dArray2[1] = d * 0.1;
        }
        if (this.scaleFlag) {
            dArray2[2] = 0.1 * dArray[2];
        }
        object2 = new LogNormalTwoParFunction();
        this.addConstraint(1, -1, 0.0);
        ((LogNormalTwoParFunction)object2).setScaleOption(this.scaleFlag);
        ((LogNormalTwoParFunction)object2).setScaleFactor(this.yScaleFactor);
        object = object2;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.nelderMead(object, null, dArray, dArray2, this.fTol, this.nMax);
        if (n == 1) {
            int n4;
            if (!this.suppressPrint) {
                this.print();
            }
            if ((n4 = this.plotXY((RegressionFunction)object2)) != -2 && !this.suppressYYplot) {
                this.plotYY();
            }
        }
        if (bl) {
            for (int j = 0; j < this.nData - 1; ++j) {
                this.yData[j] = -this.yData[j];
            }
        }
    }

    public void logNormalThreePar() {
        this.fitLogNormalThreePar(0);
    }

    public void logNormalThreeParPlot() {
        this.fitLogNormalThreePar(1);
    }

    protected void fitLogNormalThreePar(int n) {
        int n2;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 37;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 4;
        if (!this.scaleFlag) {
            this.nParam = 3;
        }
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double d = null;
        ArrayList<Object> arrayList = Regression.dataSign(this.yData);
        d = (Double)arrayList.get(4);
        double d2 = d;
        boolean bl = false;
        if (d2 < 0.0) {
            System.out.println("Regression.fitLogNormalThreePar(): This implementation of the three parameter log-normal distribution takes only positive y values\n(noise taking low values below zero are allowed)");
            System.out.println("All y values have been multiplied by -1 before fitting");
            for (int j = 0; j < this.nData; ++j) {
                this.yData[j] = -this.yData[j];
            }
            arrayList = Regression.dataSign(this.yData);
            bl = true;
        }
        ArrayList<Object> arrayList2 = Regression.dataSign(this.yData);
        Integer n3 = null;
        n3 = (Integer)arrayList2.get(5);
        int n4 = n3;
        double d3 = this.xData[0][n4];
        double d4 = 0.0;
        for (int j = 0; j < this.nData; ++j) {
            d4 += this.xData[0][j];
        }
        d4 /= (double)this.nData;
        double d5 = 0.0;
        for (int j = 0; j < this.nData; ++j) {
            d5 += Fmath.square(Math.log(this.xData[0][j]) - Math.log(d4));
        }
        d5 = Math.sqrt(d5 / (double)this.nData);
        ArrayList<Object> arrayList3 = Regression.dataSign(this.xData[0]);
        Double d6 = null;
        d6 = (Double)arrayList3.get(0);
        double d7 = d6;
        d6 = (Double)arrayList3.get(2);
        double d8 = d6;
        double d9 = d7 - (d8 - d7) / 100.0;
        if (d7 == 0.0) {
            d9 -= (d8 - d7) / 100.0;
        }
        d = (Double)arrayList2.get(4);
        double d10 = d;
        d10 = d10 * (d4 + d9) * Math.exp(-d5 * d5 / 2.0);
        double[] dArray = new double[this.nParam];
        double[] dArray2 = new double[this.nParam];
        dArray[0] = d9;
        dArray[1] = d5;
        dArray[2] = d4;
        if (this.scaleFlag) {
            dArray[3] = d10;
        }
        dArray2[0] = 0.1 * dArray[0];
        dArray2[1] = 0.1 * dArray[1];
        dArray2[2] = 0.1 * dArray[2];
        for (int j = 0; j < 3; ++j) {
            if (dArray2[j] != 0.0) continue;
            dArray2[j] = d8 * 0.1;
        }
        if (this.scaleFlag) {
            dArray2[3] = 0.1 * dArray[3];
        }
        LogNormalThreeParFunction logNormalThreeParFunction = new LogNormalThreeParFunction();
        this.addConstraint(0, 1, d7);
        this.addConstraint(1, -1, 0.0);
        this.addConstraint(2, -1, 0.0);
        logNormalThreeParFunction.setScaleOption(this.scaleFlag);
        logNormalThreeParFunction.setScaleFactor(this.yScaleFactor);
        LogNormalThreeParFunction logNormalThreeParFunction2 = logNormalThreeParFunction;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.nelderMead(logNormalThreeParFunction2, null, dArray, dArray2, this.fTol, this.nMax);
        if (n == 1) {
            if (!this.suppressPrint) {
                this.print();
            }
            if ((n2 = this.plotXY(logNormalThreeParFunction)) != -2 && !this.suppressYYplot) {
                this.plotYY();
            }
        }
        if (bl) {
            for (n2 = 0; n2 < this.nData - 1; ++n2) {
                this.yData[n2] = -this.yData[n2];
            }
        }
    }

    public void lorentzian() {
        this.fitLorentzian(0);
    }

    public void lorentzianPlot() {
        this.fitLorentzian(1);
    }

    protected void fitLorentzian(int n) {
        Object object;
        Object object2;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 5;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 3;
        if (!this.scaleFlag) {
            this.nParam = 2;
        }
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double d = null;
        ArrayList<Object> arrayList = Regression.dataSign(this.yData);
        d = (Double)arrayList.get(4);
        double d2 = d;
        boolean bl = false;
        if (d2 < 0.0) {
            System.out.println("Regression.fitLorentzian(): This implementation of the Lorentzian distribution takes only positive y values\n(noise taking low values below zero are allowed)");
            System.out.println("All y values have been multiplied by -1 before fitting");
            for (int j = 0; j < this.nData; ++j) {
                this.yData[j] = -this.yData[j];
            }
            arrayList = Regression.dataSign(this.yData);
            bl = true;
        }
        ArrayList<Object> arrayList2 = Regression.dataSign(this.yData);
        Integer n2 = null;
        n2 = (Integer)arrayList2.get(5);
        int n3 = n2;
        double d3 = this.xData[0][n3];
        double d4 = Regression.halfWidth(this.xData[0], this.yData);
        d = (Double)arrayList2.get(4);
        double d5 = d;
        d5 = d5 * d4 * Math.PI / 2.0;
        double[] dArray = new double[this.nParam];
        double[] dArray2 = new double[this.nParam];
        dArray[0] = d3;
        dArray[1] = d4 * 0.9;
        if (this.scaleFlag) {
            dArray[2] = d5;
        }
        dArray2[0] = 0.2 * d4;
        if (dArray2[0] == 0.0) {
            object2 = Regression.dataSign(this.xData[0]);
            object = null;
            object = (Double)((ArrayList)object2).get(2);
            double d6 = (Double)object;
            if (d6 == 0.0) {
                object = (Double)((ArrayList)object2).get(0);
                d6 = (Double)object;
            }
            dArray2[0] = d6 * 0.1;
        }
        dArray2[1] = 0.2 * dArray[1];
        if (this.scaleFlag) {
            dArray2[2] = 0.2 * dArray[2];
        }
        object2 = new LorentzianFunction();
        this.addConstraint(1, -1, 0.0);
        ((LorentzianFunction)object2).setScaleOption(this.scaleFlag);
        ((LorentzianFunction)object2).setScaleFactor(this.yScaleFactor);
        object = object2;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.nelderMead(object, null, dArray, dArray2, this.fTol, this.nMax);
        if (n == 1) {
            int n4;
            if (!this.suppressPrint) {
                this.print();
            }
            if ((n4 = this.plotXY((RegressionFunction)object2)) != -2 && !this.suppressYYplot) {
                this.plotYY();
            }
        }
        if (bl) {
            for (int j = 0; j < this.nData - 1; ++j) {
                this.yData[j] = -this.yData[j];
            }
        }
    }

    public static void fitOneOrSeveralDistributions(double[] dArray) {
        int n = dArray.length;
        double d = Fmath.maximum(dArray);
        double d2 = Fmath.minimum(dArray);
        double d3 = d - d2;
        int n2 = (int)Math.ceil(Math.sqrt(n));
        double d4 = d3 / (double)n2;
        double d5 = (double)n / (double)n2;
        String string = "Maximum value:  " + d + "\n";
        string = string + "Minimum value:  " + d2 + "\n";
        string = string + "Suggested bin width:  " + d4 + "\n";
        string = string + "Giving an average points per bin:  " + d5 + "\n";
        string = string + "If you wish to change the bin width enter the new value below \n";
        string = string + "and click on OK\n";
        string = string + "If you do NOT wish to change the bin width simply click on OK";
        d4 = Db.readDouble(string, d4);
        string = "Input the name of the output text file\n";
        string = string + "[Do not forget the extension, e.g.   .txt]";
        String string2 = Db.readLine(string, "fitOneOrSeveralDistributionsOutput.txt");
        FileOutput fileOutput = new FileOutput(string2, 'n');
        fileOutput.println("Fitting a set of data to one or more distributions");
        fileOutput.println("Class Regression/Stat: method fitAllDistributions");
        fileOutput.dateAndTimeln();
        fileOutput.println();
        fileOutput.printtab("Number of points: ");
        fileOutput.println(n);
        fileOutput.printtab("Minimum value: ");
        fileOutput.println(d2);
        fileOutput.printtab("Maximum value: ");
        fileOutput.println(d);
        fileOutput.printtab("Number of bins: ");
        fileOutput.println(n2);
        fileOutput.printtab("Bin width: ");
        fileOutput.println(d4);
        fileOutput.printtab("Average number of points per bin: ");
        fileOutput.println(d5);
        fileOutput.println();
        String[] stringArray = new String[]{"Gaussian Distribution", "Two parameter Log-normal Distribution", "Three parameter Log-normal Distribution", "Logistic Distribution", "Lorentzian Distribution", "Type 1 Extreme Distribution - Gumbel minimum order statistic", "Type 1 Extreme Distribution - Gumbel maximum order statistic", "Type 2 Extreme Distribution - Frechet", "Type 3 Extreme Distribution - Weibull", "Type 3 Extreme Distribution - Exponential Distribution", "Type 3 Extreme Distribution - Rayleigh Distribution", "Pareto Distribution", "Beta Distribution", "Gamma Distribution", "Erlang Distribution", "exit"};
        String[] stringArray2 = new String[]{" ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", "exit"};
        String string3 = "Choose next distribution to be fitted by clicking on box number";
        int n3 = 1;
        boolean bl = true;
        Regression regression = null;
        double[] dArray2 = null;
        block17: while (bl) {
            int n4 = Db.optionBox(string3, stringArray, stringArray2, n3);
            switch (n4) {
                case 1: {
                    regression = new Regression(dArray, d4);
                    regression.suppressPrint();
                    regression.gaussianPlot();
                    dArray2 = regression.getCoeff();
                    fileOutput.println("NORMAL (GAUSSIAN) DISTRIBUTION");
                    fileOutput.println("Best Estimates:");
                    fileOutput.printtab("Mean [mu] ");
                    fileOutput.println(dArray2[0]);
                    fileOutput.printtab("Standard deviation [sigma] ");
                    fileOutput.println(dArray2[1]);
                    fileOutput.printtab("Scaling factor [Ao] ");
                    fileOutput.println(dArray2[2]);
                    Regression.regressionDetails(fileOutput, regression);
                    continue block17;
                }
                case 2: {
                    regression = new Regression(dArray, d4);
                    regression.suppressPrint();
                    regression.logNormalTwoParPlot();
                    dArray2 = regression.getCoeff();
                    fileOutput.println("LOG-NORMAL DISTRIBUTION (two parameter statistic)");
                    fileOutput.println("Best Estimates:");
                    fileOutput.printtab("Location parameter [mu] ");
                    fileOutput.println(dArray2[0]);
                    fileOutput.printtab("Shape parameter [sigma] ");
                    fileOutput.println(dArray2[1]);
                    fileOutput.printtab("Scaling factor [Ao] ");
                    fileOutput.println(dArray2[2]);
                    Regression.regressionDetails(fileOutput, regression);
                    continue block17;
                }
                case 3: {
                    regression = new Regression(dArray, d4);
                    regression.suppressPrint();
                    regression.logNormalThreeParPlot();
                    dArray2 = regression.getCoeff();
                    fileOutput.println("LOG-NORMAL DISTRIBUTION (three parameter statistic)");
                    fileOutput.println("Best Estimates:");
                    fileOutput.printtab("Location parameter [alpha] ");
                    fileOutput.println(dArray2[0]);
                    fileOutput.printtab("Shape parameter [beta] ");
                    fileOutput.println(dArray2[1]);
                    fileOutput.printtab("Scale parameter [gamma] ");
                    fileOutput.println(dArray2[2]);
                    fileOutput.printtab("Scaling factor [Ao] ");
                    fileOutput.println(dArray2[3]);
                    Regression.regressionDetails(fileOutput, regression);
                    continue block17;
                }
                case 4: {
                    regression = new Regression(dArray, d4);
                    regression.suppressPrint();
                    regression.logisticPlot();
                    dArray2 = regression.getCoeff();
                    fileOutput.println("LOGISTIC DISTRIBUTION");
                    fileOutput.println("Best Estimates:");
                    fileOutput.printtab("Location parameter [mu] ");
                    fileOutput.println(dArray2[0]);
                    fileOutput.printtab("Scale parameter [beta] ");
                    fileOutput.println(dArray2[1]);
                    fileOutput.printtab("Scaling factor [Ao] ");
                    fileOutput.println(dArray2[2]);
                    Regression.regressionDetails(fileOutput, regression);
                    continue block17;
                }
                case 5: {
                    regression = new Regression(dArray, d4);
                    regression.suppressPrint();
                    regression.lorentzianPlot();
                    dArray2 = regression.getCoeff();
                    fileOutput.println("LORENTZIAN DISTRIBUTION");
                    fileOutput.println("Best Estimates:");
                    fileOutput.printtab("Mean [mu] ");
                    fileOutput.println(dArray2[0]);
                    fileOutput.printtab("Half-height parameter [Gamma] ");
                    fileOutput.println(dArray2[1]);
                    fileOutput.printtab("Scaling factor [Ao] ");
                    fileOutput.println(dArray2[2]);
                    Regression.regressionDetails(fileOutput, regression);
                    continue block17;
                }
                case 6: {
                    regression = new Regression(dArray, d4);
                    regression.suppressPrint();
                    regression.gumbelMinPlot();
                    dArray2 = regression.getCoeff();
                    fileOutput.println("TYPE 1 (GUMBEL) EXTREME DISTRIBUTION [MINIMUM ORDER STATISTIC]");
                    fileOutput.println("Best Estimates:");
                    fileOutput.printtab("Location parameter [mu] ");
                    fileOutput.println(dArray2[0]);
                    fileOutput.printtab("Scale parameter [sigma] ");
                    fileOutput.println(dArray2[1]);
                    fileOutput.printtab("Scaling factor [Ao] ");
                    fileOutput.println(dArray2[2]);
                    Regression.regressionDetails(fileOutput, regression);
                    continue block17;
                }
                case 7: {
                    regression = new Regression(dArray, d4);
                    regression.suppressPrint();
                    regression.gumbelMaxPlot();
                    dArray2 = regression.getCoeff();
                    fileOutput.println("TYPE 1 (GUMBEL) EXTREME DISTRIBUTION [MAXIMUM ORDER STATISTIC]");
                    fileOutput.println("Best Estimates:");
                    fileOutput.printtab("Location parameter [mu] ");
                    fileOutput.println(dArray2[0]);
                    fileOutput.printtab("Scale parameter [sigma] ");
                    fileOutput.println(dArray2[1]);
                    fileOutput.printtab("Scaling factor [Ao] ");
                    fileOutput.println(dArray2[2]);
                    Regression.regressionDetails(fileOutput, regression);
                    continue block17;
                }
                case 8: {
                    regression = new Regression(dArray, d4);
                    regression.suppressPrint();
                    regression.frechetPlot();
                    dArray2 = regression.getCoeff();
                    fileOutput.println("TYPE 2 (FRECHET) EXTREME DISTRIBUTION");
                    fileOutput.println("Best Estimates:");
                    fileOutput.printtab("Location parameter [mu] ");
                    fileOutput.println(dArray2[0]);
                    fileOutput.printtab("Scale parameter [sigma] ");
                    fileOutput.println(dArray2[1]);
                    fileOutput.printtab("Shape parameter [gamma] ");
                    fileOutput.println(dArray2[2]);
                    fileOutput.printtab("Scaling factor [Ao] ");
                    fileOutput.println(dArray2[3]);
                    Regression.regressionDetails(fileOutput, regression);
                    continue block17;
                }
                case 9: {
                    regression = new Regression(dArray, d4);
                    regression.suppressPrint();
                    regression.weibullPlot();
                    dArray2 = regression.getCoeff();
                    fileOutput.println("TYPE 3 (WEIBULL) EXTREME DISTRIBUTION");
                    fileOutput.println("Best Estimates:");
                    fileOutput.printtab("Location parameter [mu] ");
                    fileOutput.println(dArray2[0]);
                    fileOutput.printtab("Scale parameter [sigma] ");
                    fileOutput.println(dArray2[1]);
                    fileOutput.printtab("Shape parameter [gamma] ");
                    fileOutput.println(dArray2[2]);
                    fileOutput.printtab("Scaling factor [Ao] ");
                    fileOutput.println(dArray2[3]);
                    Regression.regressionDetails(fileOutput, regression);
                    continue block17;
                }
                case 10: {
                    regression = new Regression(dArray, d4);
                    regression.suppressPrint();
                    regression.exponentialPlot();
                    dArray2 = regression.getCoeff();
                    fileOutput.println("EXPONENTIAL DISTRIBUTION");
                    fileOutput.println("Best Estimates:");
                    fileOutput.printtab("Location parameter [mu] ");
                    fileOutput.println(dArray2[0]);
                    fileOutput.printtab("Scale parameter [sigma] ");
                    fileOutput.println(dArray2[1]);
                    fileOutput.printtab("Scaling factor [Ao] ");
                    fileOutput.println(dArray2[2]);
                    Regression.regressionDetails(fileOutput, regression);
                    continue block17;
                }
                case 11: {
                    regression = new Regression(dArray, d4);
                    regression.suppressPrint();
                    regression.rayleighPlot();
                    dArray2 = regression.getCoeff();
                    fileOutput.println("RAYLEIGH DISTRIBUTION");
                    fileOutput.println("Best Estimates:");
                    fileOutput.printtab("Scale parameter [beta] ");
                    fileOutput.println(dArray2[0]);
                    fileOutput.printtab("Scaling factor [Ao] ");
                    fileOutput.println(dArray2[1]);
                    Regression.regressionDetails(fileOutput, regression);
                    continue block17;
                }
                case 12: {
                    regression = new Regression(dArray, d4);
                    regression.suppressPrint();
                    regression.paretoThreeParPlot();
                    dArray2 = regression.getCoeff();
                    fileOutput.println("PARETO DISTRIBUTION");
                    fileOutput.println("Best Estimates:");
                    fileOutput.printtab("Shape parameter [alpha] ");
                    fileOutput.println(dArray2[0]);
                    fileOutput.printtab("Scale parameter [beta] ");
                    fileOutput.println(dArray2[1]);
                    fileOutput.printtab("Threshold parameter [theta] ");
                    fileOutput.println(dArray2[2]);
                    fileOutput.printtab("Scaling factor [Ao] ");
                    fileOutput.println(dArray2[3]);
                    Regression.regressionDetails(fileOutput, regression);
                    continue block17;
                }
                case 13: {
                    regression = new Regression(dArray, d4);
                    regression.suppressPrint();
                    regression.betaMinMaxPlot();
                    dArray2 = regression.getCoeff();
                    fileOutput.println("BETA DISTRIBUTION");
                    fileOutput.println("Best Estimates:");
                    fileOutput.printtab("Shape parameter [alpha] ");
                    fileOutput.println(dArray2[0]);
                    fileOutput.printtab("Shape parameter [beta] ");
                    fileOutput.println(dArray2[1]);
                    fileOutput.printtab("minimum limit [min] ");
                    fileOutput.println(dArray2[2]);
                    fileOutput.printtab("maximum limit [max] ");
                    fileOutput.println(dArray2[3]);
                    fileOutput.printtab("Scaling factor [Ao] ");
                    fileOutput.println(dArray2[4]);
                    Regression.regressionDetails(fileOutput, regression);
                    continue block17;
                }
                case 14: {
                    regression = new Regression(dArray, d4);
                    regression.suppressPrint();
                    regression.gammaPlot();
                    dArray2 = regression.getCoeff();
                    fileOutput.println("GAMMA DISTRIBUTION");
                    fileOutput.println("Best Estimates:");
                    fileOutput.printtab("Location parameter [mu] ");
                    fileOutput.println(dArray2[0]);
                    fileOutput.printtab("Scale parameter [beta] ");
                    fileOutput.println(dArray2[1]);
                    fileOutput.printtab("Shape parameter [gamma] ");
                    fileOutput.println(dArray2[2]);
                    fileOutput.printtab("Scaling factor [Ao] ");
                    fileOutput.println(dArray2[3]);
                    Regression.regressionDetails(fileOutput, regression);
                    continue block17;
                }
                case 15: {
                    regression = new Regression(dArray, d4);
                    regression.suppressPrint();
                    regression.erlangPlot();
                    dArray2 = regression.getCoeff();
                    fileOutput.println("ERLANG DISTRIBUTION");
                    fileOutput.println("Best Estimates:");
                    fileOutput.printtab("Shape parameter [lambda] ");
                    fileOutput.println(dArray2[0]);
                    fileOutput.printtab("Rate parameter [k] ");
                    fileOutput.println(regression.getKayValue());
                    fileOutput.printtab("Scaling factor [Ao] ");
                    fileOutput.println(dArray2[1]);
                    Regression.regressionDetails(fileOutput, regression);
                    continue block17;
                }
            }
            fileOutput.close();
            bl = false;
        }
    }

    protected static void regressionDetails(FileOutput fileOutput, Regression regression) {
        fileOutput.println();
        fileOutput.println("Regression details:");
        fileOutput.printtab("Chi squared: ");
        fileOutput.println(regression.getChiSquare());
        fileOutput.printtab("Reduced chi squared: ");
        fileOutput.println(regression.getReducedChiSquare());
        fileOutput.printtab("Sum of squares: ");
        fileOutput.println(regression.getSumOfSquares());
        fileOutput.printtab("Degrees of freedom: ");
        fileOutput.println(regression.getDegFree());
        fileOutput.printtab("Number of iterations: ");
        fileOutput.println(regression.getNiter());
        fileOutput.printtab("maximum number of iterations allowed: ");
        fileOutput.println(regression.getNmax());
        fileOutput.println();
        fileOutput.println();
    }

    public double getXYcorrCoeff() {
        return this.xyR;
    }

    public double getYYcorrCoeff() {
        return this.yyR;
    }

    protected static ArrayList<Object> dataSign(double[] dArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = dArray.length;
        double d = dArray[0];
        int n2 = 0;
        double d2 = dArray[0];
        int n3 = 0;
        double d3 = 0.0;
        int n4 = -1;
        int n5 = -1;
        double d4 = 0.0;
        double d5 = 0.0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (int j = 0; j < n; ++j) {
            d5 = dArray[j];
            if (dArray[j] > d) {
                d = dArray[j];
                n2 = j;
            }
            if (dArray[j] < d2) {
                d2 = dArray[j];
                n3 = j;
            }
            if (dArray[j] == 0.0) {
                ++n6;
            }
            if (dArray[j] > 0.0) {
                ++n8;
            }
            if (!(dArray[j] < 0.0)) continue;
            ++n7;
        }
        d5 /= (double)n;
        if (n6 + n8 == n) {
            d3 = d;
            n4 = n2;
            n5 = 0;
        } else if (n6 + n7 == n) {
            d3 = d2;
            n4 = n3;
            n5 = 1;
        } else {
            d3 = d;
            n4 = n2;
            if (-d2 > d) {
                d3 = d2;
                d3 = n3;
            }
            n5 = 2;
            d4 = -d2;
        }
        arrayList.add(new Double(d2));
        arrayList.add(new Integer(n3));
        arrayList.add(new Double(d));
        arrayList.add(new Integer(n2));
        arrayList.add(new Double(d3));
        arrayList.add(new Integer(n4));
        arrayList.add(new Integer(n5));
        arrayList.add(new Double(d4));
        arrayList.add(new Double(d5));
        arrayList.add(new Integer(n6));
        arrayList.add(new Integer(n8));
        arrayList.add(new Integer(n7));
        return arrayList;
    }

    public void frechet() {
        this.fitFrechet(0, 0);
    }

    public void frechetPlot() {
        this.fitFrechet(1, 0);
    }

    public void frechetTwoPar() {
        this.fitFrechet(0, 1);
    }

    public void frechetTwoParPlot() {
        this.fitFrechet(1, 1);
    }

    public void frechetStandard() {
        this.fitFrechet(0, 2);
    }

    public void frechetStandardPlot() {
        this.fitFrechet(1, 2);
    }

    protected void fitFrechet(int n, int n2) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.userSupplied = false;
        switch (n2) {
            case 0: {
                this.lastMethod = 13;
                this.nParam = 4;
                break;
            }
            case 1: {
                this.lastMethod = 14;
                this.nParam = 3;
                break;
            }
            case 2: {
                this.lastMethod = 15;
                this.nParam = 2;
            }
        }
        if (!this.scaleFlag) {
            --this.nParam;
        }
        this.frechetWeibull = true;
        this.fitFrechetWeibull(n, n2);
    }

    protected void fitFrechetWeibull(int n, int n2) {
        RegressionFunction regressionFunction;
        RegressionFunction regressionFunction2;
        Object object;
        ArrayList<Object> arrayList;
        int n3;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double d = null;
        ArrayList<Object> arrayList2 = Regression.dataSign(this.yData);
        d = (Double)arrayList2.get(4);
        double d2 = d;
        Integer n4 = null;
        n4 = (Integer)arrayList2.get(5);
        int n5 = n4;
        d = (Double)arrayList2.get(8);
        double d3 = d;
        boolean bl = true;
        double d4 = this.degreesOfFreedom;
        while (bl) {
            if (this.infinityCheck(d2, n5)) {
                if ((d4 -= 1.0) < 1.0 && !this.ignoreDofFcheck) {
                    throw new IllegalArgumentException("The effective degrees of freedom have been reduced to zero");
                }
                arrayList2 = Regression.dataSign(this.yData);
                d = (Double)arrayList2.get(4);
                d2 = d;
                n4 = (Integer)arrayList2.get(5);
                n5 = n4;
                d = (Double)arrayList2.get(8);
                d3 = d;
                continue;
            }
            bl = false;
        }
        String string = "Weibull";
        if (this.frechetWeibull) {
            string = "Frechet";
        }
        boolean bl2 = false;
        if (d2 < 0.0) {
            this.reverseYsign(string);
            arrayList2 = Regression.dataSign(this.yData);
            d2 = -d2;
            bl2 = true;
        }
        boolean bl3 = false;
        double d5 = this.checkYallSmall(d2, string);
        if (d5 != 1.0) {
            bl3 = true;
            d2 = 1.0;
        }
        ArrayList<Object> arrayList3 = Regression.dataSign(this.xData[0]);
        d = (Double)arrayList3.get(0);
        double d6 = d;
        d = (Double)arrayList3.get(2);
        double d7 = d;
        double d8 = this.xData[0][n5];
        double d9 = Math.log(2.0) * Regression.halfWidth(this.xData[0], this.yData);
        double[] dArray = new double[this.nData];
        double[] dArray2 = new double[this.nData];
        double[] dArray3 = new double[this.nData];
        for (int j = 0; j < this.nData; ++j) {
            dArray[j] = this.xData[0][j];
            dArray2[j] = this.yData[j];
            dArray3[j] = this.weight[j];
        }
        double[] dArray4 = new double[this.nData];
        double[] dArray5 = new double[this.nData];
        double[] dArray6 = new double[this.nData];
        ErrorProp[] errorPropArray = ErrorProp.oneDarray(this.nData);
        double d10 = this.calculateCumulativeValues(dArray4, dArray5, dArray6, errorPropArray, n5, d2, d8, string);
        if (this.frechetWeibull) {
            for (n3 = 0; n3 < this.nData; ++n3) {
                errorPropArray[n3] = ErrorProp.over(1.0, errorPropArray[n3]);
                errorPropArray[n3] = ErrorProp.log(errorPropArray[n3]);
                errorPropArray[n3] = ErrorProp.log(errorPropArray[n3]);
                dArray5[n3] = errorPropArray[n3].getValue();
                dArray6[n3] = errorPropArray[n3].getError();
            }
        } else {
            for (n3 = 0; n3 < this.nData; ++n3) {
                errorPropArray[n3] = ErrorProp.minus(1.0, errorPropArray[n3]);
                errorPropArray[n3] = ErrorProp.over(1.0, errorPropArray[n3]);
                errorPropArray[n3] = ErrorProp.log(errorPropArray[n3]);
                errorPropArray[n3] = ErrorProp.log(errorPropArray[n3]);
                dArray5[n3] = errorPropArray[n3].getValue();
                dArray6[n3] = errorPropArray[n3].getError();
            }
        }
        for (n3 = 0; n3 < this.nData; ++n3) {
            this.xData[0][n3] = dArray4[n3];
            this.yData[n3] = dArray5[n3];
            this.weight[n3] = dArray6[n3];
        }
        n3 = this.weightOpt ? 1 : 0;
        this.weightOpt = true;
        boolean bl4 = this.statFlag;
        this.statFlag = false;
        double[] dArray7 = new double[this.nParam];
        double[] dArray8 = new double[this.nParam];
        for (int j = 0; j < this.nParam; ++j) {
            dArray7[j] = 1.0;
            dArray8[j] = 0.2;
        }
        Object var41_34 = null;
        double d11 = 0.0;
        switch (n2) {
            case 0: {
                dArray7[0] = d6 - Math.abs(0.1 * d6);
                dArray7[1] = d9;
                dArray7[2] = 4.0;
                dArray8[0] = 0.2 * dArray7[0];
                if (dArray8[0] == 0.0) {
                    arrayList = Regression.dataSign(this.xData[0]);
                    object = null;
                    object = (Double)arrayList.get(2);
                    double d12 = (Double)object;
                    if (d12 == 0.0) {
                        object = (Double)arrayList.get(0);
                        d12 = (Double)object;
                    }
                    dArray8[0] = d12 * 0.1;
                }
                dArray8[1] = 0.2 * dArray7[1];
                dArray8[2] = 0.5 * dArray7[2];
                this.addConstraint(0, 1, d6);
                this.addConstraint(1, -1, 0.0);
                this.addConstraint(2, -1, 0.0);
                break;
            }
            case 1: {
                dArray7[0] = d9;
                dArray7[1] = 4.0;
                dArray8[0] = 0.2 * dArray7[0];
                dArray8[1] = 0.5 * dArray7[1];
                this.addConstraint(0, -1, 0.0);
                this.addConstraint(1, -1, 0.0);
                break;
            }
            case 2: {
                dArray7[0] = 4.0;
                dArray8[0] = 0.5 * dArray7[0];
                this.addConstraint(0, -1, 0.0);
            }
        }
        if (this.frechetWeibull) {
            arrayList = new FrechetFunctionTwo();
            ((FrechetFunctionTwo)((Object)arrayList)).setTypeFlag(n2);
            object = arrayList;
            this.simplexFlag = 1;
            this.nonLinStatsNeeded = true;
            this.dualErrorsRequired = false;
            this.nelderMead(object, null, dArray7, dArray8, this.fTol, this.nMax);
        } else {
            arrayList = new WeibullFunctionTwo();
            ((WeibullFunctionTwo)((Object)arrayList)).setTypeFlag(n2);
            object = arrayList;
            this.simplexFlag = 1;
            this.nonLinStatsNeeded = true;
            this.dualErrorsRequired = false;
            this.nelderMead(object, null, dArray7, dArray8, this.fTol, this.nMax);
        }
        arrayList = (ArrayList<Object>)Conv.copy(this.best);
        this.statFlag = bl4;
        this.weightOpt = n3;
        for (int j = 0; j < this.nData; ++j) {
            this.xData[0][j] = dArray[j];
            this.yData[j] = dArray2[j];
            this.weight[j] = dArray3[j];
        }
        switch (n2) {
            case 0: {
                dArray7[0] = (double)arrayList[0];
                dArray7[1] = (double)arrayList[1];
                dArray7[2] = (double)arrayList[2];
                if (this.scaleFlag) {
                    dArray7[3] = 1.0 / d10;
                }
                dArray8[0] = 0.1 * dArray7[0];
                if (dArray8[0] == 0.0) {
                    ArrayList<Object> arrayList4 = Regression.dataSign(this.xData[0]);
                    Double d13 = null;
                    d13 = (Double)arrayList4.get(2);
                    double d14 = d13;
                    if (d14 == 0.0) {
                        d13 = (Double)arrayList4.get(0);
                        d14 = d13;
                    }
                    dArray8[0] = d14 * 0.1;
                }
                dArray8[1] = 0.1 * dArray7[1];
                dArray8[2] = 0.1 * dArray7[2];
                if (!this.scaleFlag) break;
                dArray8[3] = 0.1 * dArray7[3];
                break;
            }
            case 1: {
                dArray7[0] = (double)arrayList[0];
                dArray7[1] = (double)arrayList[1];
                if (this.scaleFlag) {
                    dArray7[2] = 1.0 / d10;
                }
                dArray8[0] = 0.1 * dArray7[0];
                dArray8[1] = 0.1 * dArray7[1];
                if (!this.scaleFlag) break;
                dArray8[2] = 0.1 * dArray7[2];
                break;
            }
            case 2: {
                dArray7[0] = (double)arrayList[0];
                if (this.scaleFlag) {
                    dArray7[1] = 1.0 / d10;
                }
                dArray8[0] = 0.1 * dArray7[0];
                if (!this.scaleFlag) break;
                dArray8[1] = 0.1 * dArray7[1];
            }
        }
        if (this.frechetWeibull) {
            regressionFunction2 = new FrechetFunctionOne();
            ((FrechetFunctionOne)regressionFunction2).setScaleOption(this.scaleFlag);
            ((FrechetFunctionOne)regressionFunction2).setScaleFactor(this.yScaleFactor);
            ((FrechetFunctionOne)regressionFunction2).setTypeFlag(n2);
            regressionFunction = regressionFunction2;
            this.simplexFlag = 1;
            this.nonLinStatsNeeded = true;
            this.dualErrorsRequired = false;
            this.nelderMead(regressionFunction, null, dArray7, dArray8, this.fTol, this.nMax);
            if (n == 1) {
                int n6;
                if (!this.suppressPrint) {
                    this.print();
                }
                if ((n6 = this.plotXY(regressionFunction2)) != -2 && !this.suppressYYplot) {
                    this.plotYY();
                }
            }
        } else {
            regressionFunction2 = new WeibullFunctionOne();
            ((WeibullFunctionOne)regressionFunction2).setScaleOption(this.scaleFlag);
            ((WeibullFunctionOne)regressionFunction2).setScaleFactor(this.yScaleFactor);
            ((WeibullFunctionOne)regressionFunction2).setTypeFlag(n2);
            regressionFunction = regressionFunction2;
            this.simplexFlag = 1;
            this.nonLinStatsNeeded = true;
            this.dualErrorsRequired = false;
            this.nelderMead(regressionFunction, null, dArray7, dArray8, this.fTol, this.nMax);
            if (n == 1) {
                int n7;
                if (!this.suppressPrint) {
                    this.print();
                }
                if ((n7 = this.plotXY(regressionFunction2)) != -2 && !this.suppressYYplot) {
                    this.plotYY();
                }
            }
        }
        this.weightOpt = n3;
        if (bl3) {
            for (int j = 0; j < this.nData; ++j) {
                this.yData[j] = dArray2[j] / d5;
                if (!this.weightOpt) continue;
                this.weight[j] = dArray3[j] / d5;
            }
        }
        if (bl2) {
            for (int j = 0; j < this.nData; ++j) {
                this.yData[j] = -this.yData[j];
            }
        }
    }

    public boolean infinityCheck(double d, int n) {
        boolean bl = false;
        if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            int n2 = n + 1;
            if (n == this.nData - 1) {
                n2 = n - 1;
            }
            this.xData[0][n] = this.xData[0][n2];
            this.yData[n] = this.yData[n2];
            this.weight[n] = this.weight[n2];
            System.out.println("An infinty has been removed at point " + n);
            bl = true;
        }
        return bl;
    }

    public void reverseYsign(String string) {
        System.out.println("This implementation of the " + string + " distributions takes only positive y values\n(noise taking low values below zero are allowed)");
        System.out.println("All y values have been multiplied by -1 before fitting");
        for (int j = 0; j < this.nData; ++j) {
            this.yData[j] = -this.yData[j];
        }
    }

    public double checkYallSmall(double d, String string) {
        double d2 = 1.0;
        double d3 = Fmath.truncate(1.0 / d, 4);
        if (d < 1.0E-4) {
            System.out.println(string + " fitting: The ordinate axis (y axis) has been rescaled by " + d3 + " to reduce rounding errors");
            for (int j = 0; j < this.nData; ++j) {
                int n = j;
                this.yData[n] = this.yData[n] * d3;
                if (!this.weightOpt) continue;
                int n2 = j;
                this.weight[n2] = this.weight[n2] * d3;
            }
            d2 = d3;
        }
        return d2;
    }

    public double calculateCumulativeValues(double[] dArray, double[] dArray2, double[] dArray3, ErrorProp[] errorPropArray, int n, double d, double d2, String string) {
        int n2;
        int n3;
        dArray[0] = this.xData[0][0];
        for (int j = 1; j < this.nData; ++j) {
            dArray[j] = this.xData[0][j];
        }
        ErrorProp[] errorPropArray2 = ErrorProp.oneDarray(this.nData);
        for (int j = 0; j < this.nData; ++j) {
            errorPropArray2[j].reset(this.yData[j], this.weight[j]);
        }
        if (n != 0) {
            if (n == this.nData - 1) {
                System.out.println("The data does not cover a wide enough range of x values to fit to a " + string + " distribution with any accuracy");
                System.out.println("The regression will be attempted but you should treat any result with great caution");
            }
            if (this.yData[0] < this.yData[1] * 0.5 && this.yData[0] > d2 * 0.02) {
                ErrorProp errorProp = new ErrorProp(0.0, 0.0);
                errorProp = errorPropArray2[0].times(this.xData[0][1] - this.xData[0][0]);
                errorProp = errorProp.over(errorPropArray2[1].minus(errorPropArray2[0]));
                errorProp = ErrorProp.minus(this.xData[0][0], errorProp);
                if (this.yData[0] >= 0.9 * d) {
                    errorProp = errorProp.plus(this.xData[0][0]).over(2.0);
                }
                if (errorProp.getValue() < 0.0) {
                    errorProp.reset(0.0, 0.0);
                }
                errorPropArray[0] = errorPropArray2[0].over(2.0);
                errorPropArray[0] = errorPropArray[0].times(ErrorProp.minus(this.xData[0][0], errorProp));
            } else {
                errorPropArray[0].reset(0.0, this.weight[0]);
            }
        } else {
            errorPropArray[0].reset(0.0, this.weight[0]);
        }
        for (int j = 1; j < this.nData; ++j) {
            errorPropArray[j] = errorPropArray2[j].plus(errorPropArray2[j - 1]);
            errorPropArray[j] = errorPropArray[j].over(2.0);
            errorPropArray[j] = errorPropArray[j].times(this.xData[0][j] - this.xData[0][j - 1]);
            errorPropArray[j] = errorPropArray[j].plus(errorPropArray[j - 1]);
        }
        ErrorProp errorProp = errorPropArray[this.nData - 1].copy();
        if (n == this.nData - 1) {
            errorProp = errorProp.times(2.0);
        } else if (this.yData[this.nData - 1] < this.yData[this.nData - 2] * 0.5 && this.yData[this.nData - 1] > d2 * 0.02) {
            ErrorProp errorProp2 = new ErrorProp();
            errorProp2 = errorPropArray2[this.nData - 1].times(this.xData[0][this.nData - 2] - this.xData[0][this.nData - 1]);
            errorProp2 = errorProp2.over(errorPropArray2[this.nData - 2].minus(errorPropArray2[this.nData - 1]));
            errorProp2 = ErrorProp.minus(this.xData[0][this.nData - 1], errorProp2);
            if (this.yData[0] >= 0.9 * d) {
                errorProp2 = errorProp2.plus(this.xData[0][this.nData - 1]).over(2.0);
            }
            errorProp = errorProp.plus(ErrorProp.times(0.5, errorPropArray2[this.nData - 1].times(errorProp2.minus(this.xData[0][this.nData - 1]))));
        }
        for (int j = 0; j < this.nData; ++j) {
            dArray2[j] = errorPropArray[j].getValue();
            dArray3[j] = errorPropArray[j].getError();
        }
        double d3 = 1.0 / errorProp.getValue();
        for (n3 = 0; n3 < this.nData; ++n3) {
            errorPropArray[n3] = errorPropArray[n3].over(errorProp);
        }
        n3 = 0;
        boolean bl = true;
        for (n2 = 0; n2 < this.nData; ++n2) {
            if (!(errorPropArray[n2].getValue() <= 0.0)) continue;
            if (n2 <= n3) {
                bl = true;
                n3 = n2;
                while (bl) {
                    if (++n3 >= this.nData) {
                        throw new ArithmeticException("all zero cumulative data!!");
                    }
                    if (!(errorPropArray[n3].getValue() > 0.0)) continue;
                    errorPropArray[n2] = errorPropArray[n3].copy();
                    dArray[n2] = dArray[n3];
                    bl = false;
                }
                continue;
            }
            if (n2 == this.nData - 1) {
                errorPropArray[n2] = errorPropArray[n2 - 1].copy();
                dArray[n2] = dArray[n2 - 1];
                continue;
            }
            errorPropArray[n2] = errorPropArray[n2 - 1].plus(errorPropArray[n2 + 1]);
            errorPropArray[n2] = errorPropArray[n2].over(2.0);
            dArray[n2] = (dArray[n2 - 1] + dArray[n2 + 1]) / 2.0;
        }
        n3 = this.nData - 1;
        for (n2 = this.nData - 1; n2 >= 0; --n2) {
            if (!(errorPropArray[n2].getValue() >= 1.0)) continue;
            if (n2 >= n3) {
                bl = true;
                n3 = this.nData - 1;
                while (bl) {
                    if (--n3 < 0) {
                        throw new ArithmeticException("all unity cumulative data!!");
                    }
                    if (!(errorPropArray[n3].getValue() < 1.0)) continue;
                    errorPropArray[n2] = errorPropArray[n3].copy();
                    dArray[n2] = dArray[n3];
                    bl = false;
                }
                continue;
            }
            if (n2 == 0) {
                errorPropArray[n2] = errorPropArray[n2 + 1].copy();
                dArray[n2] = dArray[n2 + 1];
                continue;
            }
            errorPropArray[n2] = errorPropArray[n2 - 1].plus(errorPropArray[n2 + 1]);
            errorPropArray[n2] = errorPropArray[n2].over(2.0);
            dArray[n2] = (dArray[n2 - 1] + dArray[n2 + 1]) / 2.0;
        }
        return d3;
    }

    public void weibull() {
        this.fitWeibull(0, 0);
    }

    public void weibullPlot() {
        this.fitWeibull(1, 0);
    }

    public void weibullTwoPar() {
        this.fitWeibull(0, 1);
    }

    public void weibullTwoParPlot() {
        this.fitWeibull(1, 1);
    }

    public void weibullStandard() {
        this.fitWeibull(0, 2);
    }

    public void weibullStandardPlot() {
        this.fitWeibull(1, 2);
    }

    protected void fitWeibull(int n, int n2) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.userSupplied = false;
        switch (n2) {
            case 0: {
                this.lastMethod = 16;
                this.nParam = 4;
                break;
            }
            case 1: {
                this.lastMethod = 17;
                this.nParam = 3;
                break;
            }
            case 2: {
                this.lastMethod = 18;
                this.nParam = 2;
            }
        }
        if (!this.scaleFlag) {
            --this.nParam;
        }
        this.frechetWeibull = false;
        this.fitFrechetWeibull(n, n2);
    }

    public void gumbelMin() {
        this.fitGumbel(0, 0);
    }

    public void gumbelMinPlot() {
        this.fitGumbel(1, 0);
    }

    public void gumbelMax() {
        this.fitGumbel(0, 1);
    }

    public void gumbelMaxPlot() {
        this.fitGumbel(1, 1);
    }

    public void gumbelMinOnePar() {
        this.fitGumbel(0, 2);
    }

    public void gumbelMinOneParPlot() {
        this.fitGumbel(1, 2);
    }

    public void gumbelMaxOnePar() {
        this.fitGumbel(0, 3);
    }

    public void gumbelMaxOneParPlot() {
        this.fitGumbel(1, 3);
    }

    public void gumbelMinStandard() {
        this.fitGumbel(0, 4);
    }

    public void gumbelMinStandardPlot() {
        this.fitGumbel(1, 4);
    }

    public void gumbelMaxStandard() {
        this.fitGumbel(0, 5);
    }

    public void gumbelMaxStandardPlot() {
        this.fitGumbel(1, 5);
    }

    protected void noParameters(String string) {
        System.out.println(string + " Regression");
        System.out.println("No parameters set for estimation");
        System.out.println("Theoretical curve obtained");
        String string2 = "RegressOutput.txt";
        String string3 = "RegressOutputN.txt";
        FileOutput fileOutput = new FileOutput(string2, 'n');
        System.out.println("Results printed to the file " + string3);
        fileOutput.dateAndTimeln(string2);
        fileOutput.println("No parameters set for estimation");
        switch (this.lastMethod) {
            case 11: {
                int n;
                fileOutput.println("Minimal Standard Gumbel p(x) = exp(x)exp(-exp(x))");
                for (n = 0; n < this.nData; ++n) {
                    this.yCalc[n] = Math.exp(this.xData[0][n]) * Math.exp(-Math.exp(this.xData[0][n]));
                }
                break;
            }
            case 12: {
                int n;
                fileOutput.println("Maximal Standard Gumbel p(x) = exp(-x)exp(-exp(-x))");
                for (n = 0; n < this.nData; ++n) {
                    this.yCalc[n] = Math.exp(-this.xData[0][n]) * Math.exp(-Math.exp(-this.xData[0][n]));
                }
                break;
            }
            case 21: {
                int n;
                fileOutput.println("Standard Exponential p(x) = exp(-x)");
                for (n = 0; n < this.nData; ++n) {
                    this.yCalc[n] = Math.exp(-this.xData[0][n]);
                }
                break;
            }
        }
        this.sumOfSquaresError = 0.0;
        this.chiSquare = 0.0;
        double d = 0.0;
        for (int j = 0; j < this.nData; ++j) {
            d = Fmath.square(this.yData[j] - this.yCalc[j]);
            this.sumOfSquaresError += d;
            this.chiSquare += d / Fmath.square(this.weight[j]);
        }
        double d2 = Stat.corrCoeff(this.yData, this.yCalc);
        fileOutput.printtab("Correlation Coefficient");
        fileOutput.println(Fmath.truncate(d2, this.prec));
        if (Math.abs(d2) <= 1.0) {
            fileOutput.printtab("Correlation Coefficient Probability");
            fileOutput.println(Fmath.truncate(1.0 - Stat.linearCorrCoeffProb(d2, this.degreesOfFreedom - 1), this.prec));
        }
        fileOutput.printtab("Sum of Squares");
        fileOutput.println(Fmath.truncate(this.sumOfSquaresError, this.prec));
        if (this.weightOpt || this.trueFreq) {
            fileOutput.printtab("Chi Square");
            fileOutput.println(Fmath.truncate(this.chiSquare, this.prec));
            fileOutput.printtab("chi square probability");
            fileOutput.println(Fmath.truncate(Stat.chiSquareProb(this.chiSquare, this.degreesOfFreedom - 1), this.prec));
        }
        fileOutput.println(" ");
        fileOutput.printtab("x", this.field);
        fileOutput.printtab("p(x) [expl]", this.field);
        fileOutput.printtab("p(x) [calc]", this.field);
        fileOutput.println("residual");
        for (int j = 0; j < this.nData; ++j) {
            fileOutput.printtab(Fmath.truncate(this.xData[0][j], this.prec), this.field);
            fileOutput.printtab(Fmath.truncate(this.yData[j], this.prec), this.field);
            fileOutput.printtab(Fmath.truncate(this.yCalc[j], this.prec), this.field);
            fileOutput.println(Fmath.truncate(this.yData[j] - this.yCalc[j], this.prec));
        }
        fileOutput.close();
        this.plotXY();
        if (!this.suppressYYplot) {
            this.plotYY();
        }
    }

    protected void fitGumbel(int n, int n2) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.userSupplied = false;
        switch (n2) {
            case 0: {
                this.lastMethod = 7;
                this.nParam = 3;
                break;
            }
            case 1: {
                this.lastMethod = 8;
                this.nParam = 3;
                break;
            }
            case 2: {
                this.lastMethod = 9;
                this.nParam = 2;
                break;
            }
            case 3: {
                this.lastMethod = 10;
                this.nParam = 2;
                break;
            }
            case 4: {
                this.lastMethod = 11;
                this.nParam = 1;
                break;
            }
            case 5: {
                this.lastMethod = 12;
                this.nParam = 1;
            }
        }
        if (!this.scaleFlag) {
            --this.nParam;
        }
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        if (this.nParam == 0) {
            this.noParameters("Gumbel");
        } else {
            double d;
            Object object;
            Object object2;
            Regression.sort(this.xData[0], this.yData, this.weight);
            Double d2 = null;
            ArrayList<Object> arrayList = Regression.dataSign(this.yData);
            d2 = (Double)arrayList.get(4);
            double d3 = d2;
            boolean bl = false;
            if (d3 < 0.0) {
                System.out.println("Regression.fitGumbel(): This implementation of the Gumbel distribution takes only positive y values\n(noise taking low values below zero are allowed)");
                System.out.println("All y values have been multiplied by -1 before fitting");
                for (int j = 0; j < this.nData; ++j) {
                    this.yData[j] = -this.yData[j];
                }
                arrayList = Regression.dataSign(this.yData);
                bl = true;
            }
            ArrayList<Object> arrayList2 = Regression.dataSign(this.xData[0]);
            Integer n3 = null;
            n3 = (Integer)arrayList.get(5);
            int n4 = n3;
            double d4 = this.xData[0][n4];
            double d5 = Regression.halfWidth(this.xData[0], this.yData);
            double[] dArray = new double[this.nParam];
            double[] dArray2 = new double[this.nParam];
            switch (n2) {
                case 0: 
                case 1: {
                    dArray[0] = d4;
                    dArray[1] = d5 * Math.sqrt(6.0) / Math.PI;
                    if (this.scaleFlag) {
                        dArray[2] = d3 * dArray[1] * Math.exp(1.0);
                    }
                    dArray2[0] = 0.1 * dArray[0];
                    if (dArray2[0] == 0.0) {
                        object2 = Regression.dataSign(this.xData[0]);
                        object = null;
                        object = (Double)((ArrayList)object2).get(2);
                        d = (Double)object;
                        if (d == 0.0) {
                            object = (Double)((ArrayList)object2).get(0);
                            d = (Double)object;
                        }
                        dArray2[0] = d * 0.1;
                    }
                    dArray2[1] = 0.1 * dArray[1];
                    if (this.scaleFlag) {
                        dArray2[2] = 0.1 * dArray[2];
                    }
                    this.addConstraint(1, -1, 0.0);
                    break;
                }
                case 2: 
                case 3: {
                    dArray[0] = d5 * Math.sqrt(6.0) / Math.PI;
                    if (this.scaleFlag) {
                        dArray[1] = d3 * dArray[0] * Math.exp(1.0);
                    }
                    dArray2[0] = 0.1 * dArray[0];
                    if (this.scaleFlag) {
                        dArray2[1] = 0.1 * dArray[1];
                    }
                    this.addConstraint(0, -1, 0.0);
                    break;
                }
                case 4: 
                case 5: {
                    if (!this.scaleFlag) break;
                    dArray[0] = d3 * Math.exp(1.0);
                    dArray2[0] = 0.1 * dArray[0];
                }
            }
            object2 = new GumbelFunction();
            ((GumbelFunction)object2).setTypeFlag(n2);
            ((GumbelFunction)object2).setScaleOption(this.scaleFlag);
            ((GumbelFunction)object2).setScaleFactor(this.yScaleFactor);
            if (n2 < 4) {
                object = object2;
                this.simplexFlag = 1;
                this.nonLinStatsNeeded = true;
                this.dualErrorsRequired = false;
                this.nelderMead(object, null, dArray, dArray2, this.fTol, this.nMax);
                if (n == 1) {
                    int n5;
                    if (!this.suppressPrint) {
                        this.print();
                    }
                    if ((n5 = this.plotXY((RegressionFunction)object2)) != -2 && !this.suppressYYplot) {
                        this.plotYY();
                    }
                }
            } else {
                object = new double[1][this.nData];
                d = 1.0;
                if (n2 == 5) {
                    d = -1.0;
                }
                for (int j = 0; j < this.nData; ++j) {
                    object[0][j] = Math.exp(d * this.xData[0][j]) * Math.exp(-Math.exp(d * this.xData[0][j]));
                }
                this.linNonLin = true;
                this.generalLinear((double[][])object);
                if (!this.suppressPrint) {
                    this.print();
                }
                if (!this.suppressYYplot) {
                    this.plotYY();
                }
                this.plotXY();
                this.linNonLin = false;
            }
            if (bl) {
                for (int j = 0; j < this.nData - 1; ++j) {
                    this.yData[j] = -this.yData[j];
                }
            }
        }
    }

    protected static void sort(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = 0;
        int n2 = -1;
        int n3 = dArray.length;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        while (n2 < n3 - 1) {
            n = n2 + 1;
            for (int j = n2 + 2; j < n3; ++j) {
                if (!(dArray[j] < dArray[n])) continue;
                n = j;
            }
            d = dArray[n];
            dArray[n] = dArray[++n2];
            dArray[n2] = d;
            d2 = dArray2[n];
            dArray2[n] = dArray2[n2];
            dArray2[n2] = d2;
            d3 = dArray3[n];
            dArray3[n] = dArray3[n2];
            dArray3[n2] = d3;
        }
    }

    protected static double halfWidth(double[] dArray, double[] dArray2) {
        double d = dArray2[0];
        int n = 0;
        int n2 = dArray.length;
        for (int j = 1; j < n2; ++j) {
            if (!(dArray2[j] > d)) continue;
            d = dArray2[j];
            n = j;
        }
        d /= 2.0;
        double d2 = -1.0;
        double d3 = -1.0;
        double d4 = -1.0;
        int n3 = -1;
        if (n > 0) {
            n3 = n - 1;
            d3 = Math.abs(d - dArray2[n3]);
            for (int j = n - 2; j >= 0; --j) {
                d4 = Math.abs(d - dArray2[j]);
                if (!(d4 < d3)) continue;
                d3 = d4;
                n3 = j;
            }
            d2 = Math.abs(dArray[n3] - dArray[n]);
        }
        double d5 = -1.0;
        double d6 = -1.0;
        d4 = -1.0;
        int n4 = -1;
        if (n < n2 - 1) {
            n4 = n + 1;
            d6 = Math.abs(d - dArray2[n4]);
            for (int j = n + 2; j < n2; ++j) {
                d4 = Math.abs(d - dArray2[j]);
                if (!(d4 < d6)) continue;
                d6 = d4;
                n4 = j;
            }
            d5 = Math.abs(dArray[n4] - dArray[n]);
        }
        double d7 = 0.0;
        if (n3 != -1) {
            d7 += d2;
        }
        if (n4 != -1) {
            d7 += d5;
        }
        return d7;
    }

    public void exponentialSimple() {
        this.fitsexponentialSimple(0);
    }

    public void exponentialSimplePlot() {
        this.fitsexponentialSimple(1);
    }

    protected void fitsexponentialSimple(int n) {
        Object object;
        Object object2;
        int n2;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 43;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 2;
        if (!this.scaleFlag) {
            this.nParam = 1;
        }
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        int n3 = n2 = this.yData.length;
        boolean[] blArray = new boolean[n2];
        for (int j = 0; j < n2; ++j) {
            blArray[j] = true;
            if (!(this.xData[0][j] <= 0.0) && !(this.yData[j] <= 0.0)) continue;
            blArray[j] = false;
            --n3;
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        int n4 = 0;
        for (int j = 0; j < n2; ++j) {
            if (!blArray[j]) continue;
            dArray[n4] = Math.log(this.xData[0][j]);
            dArray2[n4] = Math.log(this.yData[j]);
            dArray3[n4] = Math.abs(this.weight[j] / this.yData[j]);
            ++n4;
        }
        Regression regression = new Regression(dArray, dArray2, dArray3);
        double[] dArray4 = new double[this.nParam];
        double[] dArray5 = new double[this.nParam];
        if (this.scaleFlag) {
            regression.linear();
            object2 = regression.getBestEstimates();
            object = regression.getBestEstimatesErrors();
            dArray4[0] = object2[1];
            dArray4[1] = Math.exp(object2[0]);
            dArray5[0] = object[1] / 2.0;
            dArray5[1] = object[0] * dArray4[0] / 2.0;
            if (dArray5[0] <= 0.0 || Fmath.isNaN(dArray5[0])) {
                dArray5[0] = Math.abs(dArray4[0] * 0.1);
            }
            if (dArray5[1] <= 0.0 || Fmath.isNaN(dArray5[1])) {
                dArray5[1] = Math.abs(dArray4[1] * 0.1);
            }
        } else {
            regression.linearGeneral();
            object2 = regression.getBestEstimates();
            object = regression.getBestEstimatesErrors();
            dArray4[0] = object2[1];
            dArray5[0] = object[1] / 2.0;
            if (dArray5[0] <= 0.0 || Fmath.isNaN(dArray5[0])) {
                dArray5[0] = Math.abs(dArray4[0] * 0.1);
            }
        }
        object2 = new ExponentialSimpleFunction();
        ((ExponentialSimpleFunction)object2).setScaleOption(this.scaleFlag);
        ((ExponentialSimpleFunction)object2).setScaleFactor(this.yScaleFactor);
        object = object2;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.nelderMead(object, null, dArray4, dArray5, this.fTol, this.nMax);
        if (n == 1) {
            int n5;
            if (!this.suppressPrint) {
                this.print();
            }
            if ((n5 = this.plotXY((RegressionFunction)object2)) != -2 && !this.suppressYYplot) {
                this.plotYY();
            }
        }
    }

    public void exponentialMultiple(int n) {
        this.userSupplied = false;
        this.fitsexponentialMultiple(n, 0);
    }

    public void exponentialMultiplePlot(int n) {
        this.userSupplied = false;
        this.fitsexponentialMultiple(n, 1);
    }

    public void exponentialMultiple(int n, double[] dArray) {
        this.userSupplied = true;
        this.fitsexponentialMultiple(n, 0, dArray);
    }

    public void exponentialMultiplePlot(int n, double[] dArray) {
        this.userSupplied = true;
        this.fitsexponentialMultiple(n, 1, dArray);
    }

    protected void fitsexponentialMultiple(int n, int n2) {
        int n3;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 44;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 2 * n;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        int n4 = n3 = this.yData.length;
        boolean[] blArray = new boolean[n3];
        for (int j = 0; j < n3; ++j) {
            blArray[j] = true;
            if (!(this.xData[0][j] <= 0.0) && !(this.yData[j] <= 0.0)) continue;
            blArray[j] = false;
            --n4;
        }
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        double[] dArray3 = new double[n4];
        int n5 = 0;
        for (int j = 0; j < n3; ++j) {
            if (!blArray[j]) continue;
            dArray[n5] = Math.log(this.xData[0][j]);
            dArray2[n5] = Math.log(this.yData[j]);
            dArray3[n5] = Math.abs(this.weight[j] / this.yData[j]);
            ++n5;
        }
        Regression regression = new Regression(dArray, dArray2, dArray3);
        double[] dArray4 = new double[this.nParam];
        double[] dArray5 = new double[this.nParam];
        regression.linear();
        double[] dArray6 = regression.getBestEstimates();
        double[] dArray7 = regression.getBestEstimatesErrors();
        for (int j = 0; j < this.nParam; j += 2) {
            dArray4[j] = Math.exp(dArray6[0]) / (double)this.nParam;
            dArray4[j + 1] = dArray6[1];
            dArray5[j] = dArray7[0] * dArray4[j] / 2.0;
            dArray5[j + 1] = dArray7[1] / 2.0;
            if (dArray5[j] <= 0.0 || Fmath.isNaN(dArray5[j])) {
                dArray5[j] = Math.abs(dArray4[j] * 0.1);
            }
            if (!(dArray5[j + 1] <= 0.0) && !Fmath.isNaN(dArray5[j + 1])) continue;
            dArray5[j + 1] = Math.abs(dArray4[j + 1] * 0.1);
        }
        ExponentialMultipleFunction exponentialMultipleFunction = new ExponentialMultipleFunction();
        exponentialMultipleFunction.setNexps(this.nParam);
        ExponentialMultipleFunction exponentialMultipleFunction2 = exponentialMultipleFunction;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.nelderMead(exponentialMultipleFunction2, null, dArray4, dArray5, this.fTol, this.nMax);
        if (n2 == 1) {
            int n6;
            if (!this.suppressPrint) {
                this.print();
            }
            if ((n6 = this.plotXY(exponentialMultipleFunction)) != -2 && !this.suppressYYplot) {
                this.plotYY();
            }
        }
    }

    protected void fitsexponentialMultiple(int n, int n2, double[] dArray) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 44;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 2 * n;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        if (dArray.length != this.nParam) {
            throw new IllegalArgumentException(" Number of A and Bs, " + dArray.length + ", does not match the number of exponentials, " + n);
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        double[] dArray2 = new double[this.nParam];
        double[] dArray3 = new double[this.nParam];
        for (int j = 0; j < this.nParam; ++j) {
            dArray2[j] = dArray[j];
            dArray3[j] = Math.abs(dArray2[j] * 0.1);
        }
        ExponentialMultipleFunction exponentialMultipleFunction = new ExponentialMultipleFunction();
        exponentialMultipleFunction.setNexps(this.nParam);
        ExponentialMultipleFunction exponentialMultipleFunction2 = exponentialMultipleFunction;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.nelderMead(exponentialMultipleFunction2, null, dArray2, dArray3, this.fTol, this.nMax);
        if (n2 == 1) {
            int n3;
            if (!this.suppressPrint) {
                this.print();
            }
            if ((n3 = this.plotXY(exponentialMultipleFunction)) != -2 && !this.suppressYYplot) {
                this.plotYY();
            }
        }
    }

    public void oneMinusExponential() {
        this.fitsoneMinusExponential(0);
    }

    public void oneMinusExponentialPlot() {
        this.fitsoneMinusExponential(1);
    }

    protected void fitsoneMinusExponential(int n) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 45;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 2;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        ArrayMaths arrayMaths = new ArrayMaths(this.yData);
        double d = arrayMaths.maximum();
        double d2 = arrayMaths.minimum();
        double d3 = 1.0;
        double d4 = d / 2.0;
        if (Math.abs(d2) > Math.abs(d)) {
            d3 = -1.0;
            d = d2;
            d4 = d2 / 2.0;
        }
        double d5 = Double.NaN;
        boolean bl = true;
        int n2 = 0;
        while (bl) {
            if (this.yData[n2] == d4) {
                d5 = this.xData[0][n2] - this.xData[0][0];
                bl = false;
                continue;
            }
            if (this.yData[n2] < d4 && this.yData[n2 + 1] > d4) {
                d5 = (this.xData[0][n2] + this.xData[0][n2 + 1]) / 2.0 - this.xData[0][0];
                bl = false;
                continue;
            }
            if (this.yData[n2] > d4 && this.yData[n2 + 1] < d4) {
                d5 = (this.xData[0][n2] + this.xData[0][n2 + 1]) / 2.0 - this.xData[0][0];
                bl = false;
                continue;
            }
            if (++n2 < this.nData - 1) continue;
            bl = false;
        }
        if (d5 != d5) {
            d5 = arrayMaths.maximumDifference();
        }
        double d6 = -d3 / d5;
        double[] dArray = new double[]{d, d6};
        double[] dArray2 = new double[]{Math.abs(dArray[0] / 5.0), Math.abs(dArray[1] / 5.0)};
        OneMinusExponentialFunction oneMinusExponentialFunction = new OneMinusExponentialFunction();
        oneMinusExponentialFunction.setScaleOption(this.scaleFlag);
        oneMinusExponentialFunction.setScaleFactor(this.yScaleFactor);
        OneMinusExponentialFunction oneMinusExponentialFunction2 = oneMinusExponentialFunction;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.nelderMead(oneMinusExponentialFunction2, null, dArray, dArray2, this.fTol, this.nMax);
        double d7 = this.sumOfSquaresError;
        double[] dArray3 = this.best;
        dArray[0] = -d;
        dArray[1] = -d6;
        dArray2[0] = Math.abs(dArray[0] / 5.0);
        dArray2[1] = Math.abs(dArray[1] / 5.0);
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.nelderMead(oneMinusExponentialFunction2, null, dArray, dArray2, this.fTol, this.nMax);
        if (this.sumOfSquaresError > d7) {
            dArray[0] = dArray3[0];
            dArray[1] = dArray3[1];
            dArray2[0] = Math.abs(dArray[0] / 20.0);
            dArray2[1] = Math.abs(dArray[1] / 20.0);
            this.simplexFlag = 1;
            this.nonLinStatsNeeded = true;
            this.dualErrorsRequired = false;
            this.nelderMead(oneMinusExponentialFunction2, null, dArray, dArray2, this.fTol, this.nMax);
        }
        if (n == 1) {
            int n3;
            if (!this.suppressPrint) {
                this.print();
            }
            if ((n3 = this.plotXY(oneMinusExponentialFunction)) != -2 && !this.suppressYYplot) {
                this.plotYY();
            }
        }
    }

    public void exponential() {
        this.fitExponential(0, 0);
    }

    public void exponentialPlot() {
        this.fitExponential(1, 0);
    }

    public void exponentialOnePar() {
        this.fitExponential(0, 1);
    }

    public void exponentialOneParPlot() {
        this.fitExponential(1, 1);
    }

    public void exponentialStandard() {
        this.fitExponential(0, 2);
    }

    public void exponentialStandardPlot() {
        this.fitExponential(1, 2);
    }

    protected void fitExponential(int n, int n2) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.userSupplied = false;
        switch (n2) {
            case 0: {
                this.lastMethod = 19;
                this.nParam = 3;
                break;
            }
            case 1: {
                this.lastMethod = 20;
                this.nParam = 2;
                break;
            }
            case 2: {
                this.lastMethod = 21;
                this.nParam = 1;
            }
        }
        if (!this.scaleFlag) {
            --this.nParam;
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        if (this.nParam == 0) {
            this.noParameters("Exponential");
        } else {
            Object object;
            Object object2;
            double[] dArray = new double[this.nData];
            double[] dArray2 = new double[this.nData];
            double[] dArray3 = new double[this.nData];
            for (int j = 0; j < this.nData; ++j) {
                dArray[j] = this.xData[0][j];
                dArray2[j] = this.yData[j];
                dArray3[j] = this.weight[j];
            }
            Regression.sort(this.xData[0], this.yData, this.weight);
            Double d = null;
            ArrayList<Object> arrayList = Regression.dataSign(this.yData);
            d = (Double)arrayList.get(4);
            double d2 = d;
            Integer n3 = null;
            n3 = (Integer)arrayList.get(5);
            int n4 = n3;
            String string = "Exponential";
            boolean bl = false;
            if (d2 < 0.0) {
                this.reverseYsign(string);
                arrayList = Regression.dataSign(this.yData);
                d2 = -d2;
                bl = true;
            }
            boolean bl2 = false;
            double d3 = this.checkYallSmall(d2, string);
            if (d3 != 1.0) {
                bl2 = true;
                d2 = 1.0;
            }
            ArrayList<Object> arrayList2 = Regression.dataSign(this.xData[0]);
            d = (Double)arrayList2.get(0);
            double d4 = d;
            double d5 = d2 / Math.exp(1.0);
            if (this.yData[0] < d2) {
                d5 = (d2 + this.yData[0]) / (2.0 * Math.exp(1.0));
            }
            double d6 = Math.abs(this.yData[0] - d5);
            double d7 = 0.0;
            int n5 = 0;
            for (int j = 1; j < this.nData; ++j) {
                d7 = Math.abs(this.yData[j] - d5);
                if (!(d7 < d6)) continue;
                d6 = d7;
                n5 = j;
            }
            double d8 = this.xData[0][n5] - this.xData[0][0];
            double[] dArray4 = new double[this.nParam];
            double[] dArray5 = new double[this.nParam];
            switch (n2) {
                case 0: {
                    dArray4[0] = d4 * 0.9;
                    dArray4[1] = d8;
                    if (this.scaleFlag) {
                        dArray4[2] = d2 * d8;
                    }
                    dArray5[0] = 0.1 * dArray4[0];
                    if (dArray5[0] == 0.0) {
                        object2 = Regression.dataSign(this.xData[0]);
                        object = null;
                        object = (Double)((ArrayList)object2).get(2);
                        double d9 = (Double)object;
                        if (d9 == 0.0) {
                            object = (Double)((ArrayList)object2).get(0);
                            d9 = (Double)object;
                        }
                        dArray5[0] = d9 * 0.1;
                    }
                    dArray5[1] = 0.1 * dArray4[1];
                    if (!this.scaleFlag) break;
                    dArray5[2] = 0.1 * dArray4[2];
                    break;
                }
                case 1: {
                    dArray4[0] = d8;
                    if (this.scaleFlag) {
                        dArray4[1] = d2 * d8;
                    }
                    dArray5[0] = 0.1 * dArray4[0];
                    if (!this.scaleFlag) break;
                    dArray5[1] = 0.1 * dArray4[1];
                    break;
                }
                case 2: {
                    if (!this.scaleFlag) break;
                    dArray4[0] = d2;
                    dArray5[0] = 0.1 * dArray4[0];
                }
            }
            object2 = new ExponentialFunction();
            ((ExponentialFunction)object2).setScaleOption(this.scaleFlag);
            ((ExponentialFunction)object2).setScaleFactor(this.yScaleFactor);
            ((ExponentialFunction)object2).setTypeFlag(n2);
            object = object2;
            this.simplexFlag = 1;
            this.nonLinStatsNeeded = true;
            this.dualErrorsRequired = false;
            this.nelderMead(object, null, dArray4, dArray5, this.fTol, this.nMax);
            if (n == 1) {
                int n6;
                if (!this.suppressPrint) {
                    this.print();
                }
                if ((n6 = this.plotXY((RegressionFunction)object2)) != -2 && !this.suppressYYplot) {
                    this.plotYY();
                }
            }
            if (bl2) {
                for (int j = 0; j < this.nData; ++j) {
                    this.yData[j] = dArray2[j] / d3;
                    if (!this.weightOpt) continue;
                    this.weight[j] = dArray3[j] / d3;
                }
            }
            if (bl) {
                for (int j = 0; j < this.nData; ++j) {
                    this.yData[j] = -this.yData[j];
                }
            }
        }
    }

    public void checkZeroNeg(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = 0;
        boolean bl = true;
        for (int j = 0; j < this.nData; ++j) {
            if (!(dArray2[j] <= 0.0)) continue;
            if (j <= n) {
                bl = true;
                n = j;
                while (bl) {
                    if (++n >= this.nData) {
                        throw new ArithmeticException("all zero cumulative data!!");
                    }
                    if (!(dArray2[n] > 0.0)) continue;
                    dArray2[j] = dArray2[n];
                    dArray[j] = dArray[n];
                    dArray3[j] = dArray3[n];
                    bl = false;
                }
                continue;
            }
            if (j == this.nData - 1) {
                dArray2[j] = dArray2[j - 1];
                dArray[j] = dArray[j - 1];
                dArray3[j] = dArray3[j - 1];
                continue;
            }
            dArray2[j] = (dArray2[j - 1] + dArray2[j + 1]) / 2.0;
            dArray[j] = (dArray[j - 1] + dArray[j + 1]) / 2.0;
            dArray3[j] = (dArray3[j - 1] + dArray3[j + 1]) / 2.0;
        }
    }

    public void rayleigh() {
        this.fitRayleigh(0, 0);
    }

    public void rayleighPlot() {
        this.fitRayleigh(1, 0);
    }

    protected void fitRayleigh(int n, int n2) {
        int n3;
        RayleighFunctionTwo rayleighFunctionTwo;
        int n4;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 22;
        this.userSupplied = false;
        this.nParam = 2;
        if (!this.scaleFlag) {
            --this.nParam;
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double d = null;
        ArrayList<Object> arrayList = Regression.dataSign(this.yData);
        d = (Double)arrayList.get(4);
        double d2 = d;
        Integer n5 = null;
        n5 = (Integer)arrayList.get(5);
        int n6 = n5;
        String string = "Rayleigh";
        boolean bl = false;
        if (d2 < 0.0) {
            this.reverseYsign(string);
            arrayList = Regression.dataSign(this.yData);
            d2 = -d2;
            bl = true;
        }
        boolean bl2 = false;
        double d3 = this.checkYallSmall(d2, string);
        if (d3 != 1.0) {
            bl2 = true;
            d2 = 1.0;
        }
        double[] dArray = new double[this.nData];
        double[] dArray2 = new double[this.nData];
        double[] dArray3 = new double[this.nData];
        for (int j = 0; j < this.nData; ++j) {
            dArray[j] = this.xData[0][j];
            dArray2[j] = this.yData[j];
            dArray3[j] = this.weight[j];
        }
        ArrayList<Object> arrayList2 = Regression.dataSign(this.xData[0]);
        d = (Double)arrayList2.get(0);
        double d4 = d;
        d = (Double)arrayList2.get(2);
        double d5 = d;
        double d6 = this.xData[0][n6];
        double d7 = Math.log(2.0) * Regression.halfWidth(this.xData[0], this.yData);
        double[] dArray4 = new double[this.nData];
        double[] dArray5 = new double[this.nData];
        double[] dArray6 = new double[this.nData];
        ErrorProp[] errorPropArray = ErrorProp.oneDarray(this.nData);
        double d8 = this.calculateCumulativeValues(dArray4, dArray5, dArray6, errorPropArray, n6, d2, d6, string);
        for (n4 = 0; n4 < this.nData; ++n4) {
            errorPropArray[n4] = ErrorProp.minus(1.0, errorPropArray[n4]);
            errorPropArray[n4] = ErrorProp.over(1.0, errorPropArray[n4]);
            errorPropArray[n4] = ErrorProp.log(errorPropArray[n4]);
            dArray5[n4] = errorPropArray[n4].getValue();
            dArray6[n4] = errorPropArray[n4].getError();
        }
        for (n4 = 0; n4 < this.nData; ++n4) {
            this.xData[0][n4] = dArray4[n4];
            this.yData[n4] = dArray5[n4];
            this.weight[n4] = dArray6[n4];
        }
        n4 = this.weightOpt ? 1 : 0;
        this.weightOpt = true;
        this.statFlag = false;
        double[] dArray7 = new double[this.nParam];
        double[] dArray8 = new double[this.nParam];
        for (int j = 0; j < this.nParam; ++j) {
            dArray7[j] = 1.0;
            dArray8[j] = 0.2;
        }
        dArray7[0] = d7;
        dArray8[0] = 0.2;
        this.addConstraint(0, -1, 0.0);
        RayleighFunctionTwo rayleighFunctionTwo2 = rayleighFunctionTwo = new RayleighFunctionTwo();
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.nelderMead(rayleighFunctionTwo2, null, dArray7, dArray8, this.fTol, this.nMax);
        double[] dArray9 = Conv.copy(this.best);
        this.statFlag = true;
        this.weightOpt = n4;
        for (int j = 0; j < this.nData; ++j) {
            this.xData[0][j] = dArray[j];
            this.yData[j] = dArray2[j];
            this.weight[j] = dArray3[j];
        }
        dArray7[0] = dArray9[0];
        if (this.scaleFlag) {
            dArray7[1] = 1.0 / d8;
        }
        dArray8[0] = 0.1 * dArray7[0];
        if (this.scaleFlag) {
            dArray8[1] = 0.1 * dArray7[1];
        }
        RayleighFunctionOne rayleighFunctionOne = new RayleighFunctionOne();
        rayleighFunctionOne.setScaleOption(this.scaleFlag);
        rayleighFunctionOne.setScaleFactor(this.yScaleFactor);
        RayleighFunctionOne rayleighFunctionOne2 = rayleighFunctionOne;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.nelderMead(rayleighFunctionOne2, null, dArray7, dArray8, this.fTol, this.nMax);
        if (n == 1) {
            if (!this.suppressPrint) {
                this.print();
            }
            if ((n3 = this.plotXY(rayleighFunctionOne)) != -2 && !this.suppressYYplot) {
                this.plotYY();
            }
        }
        if (bl2) {
            for (n3 = 0; n3 < this.nData; ++n3) {
                this.yData[n3] = dArray2[n3] / d3;
                if (!this.weightOpt) continue;
                this.weight[n3] = dArray3[n3] / d3;
            }
        }
        if (bl) {
            for (n3 = 0; n3 < this.nData; ++n3) {
                this.yData[n3] = -this.yData[n3];
            }
        }
    }

    public void paretoShifted() {
        this.fitPareto(0, 3);
    }

    public void paretoThreePar() {
        this.fitPareto(0, 3);
    }

    public void paretoShiftedPlot() {
        this.fitPareto(1, 3);
    }

    public void paretoThreeParPlot() {
        this.fitPareto(1, 3);
    }

    public void paretoTwoPar() {
        this.fitPareto(0, 2);
    }

    public void paretoTwoParPlot() {
        this.fitPareto(1, 2);
    }

    public void paretoOnePar() {
        this.fitPareto(0, 1);
    }

    public void paretoOneParPlot() {
        this.fitPareto(1, 1);
    }

    protected void fitPareto(int n, int n2) {
        int n3;
        int n4;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.userSupplied = false;
        switch (n2) {
            case 3: {
                this.lastMethod = 29;
                this.nParam = 4;
                break;
            }
            case 2: {
                this.lastMethod = 23;
                this.nParam = 3;
                break;
            }
            case 1: {
                this.lastMethod = 24;
                this.nParam = 2;
            }
        }
        if (!this.scaleFlag) {
            --this.nParam;
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        String string = "Pareto";
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double d = null;
        ArrayList<Object> arrayList = Regression.dataSign(this.yData);
        d = (Double)arrayList.get(4);
        double d2 = d;
        Integer n5 = null;
        n5 = (Integer)arrayList.get(5);
        int n6 = n5;
        if (this.infinityCheck(d2, n6)) {
            arrayList = Regression.dataSign(this.yData);
            d = (Double)arrayList.get(4);
            d2 = d;
            n5 = null;
            n5 = (Integer)arrayList.get(5);
            n6 = n5;
        }
        boolean bl = false;
        if (d2 < 0.0) {
            this.reverseYsign(string);
            arrayList = Regression.dataSign(this.yData);
            d2 = -d2;
            bl = true;
        }
        boolean bl2 = false;
        double d3 = this.checkYallSmall(d2, string);
        if (d3 != 1.0) {
            bl2 = true;
            d2 = 1.0;
        }
        ArrayList<Object> arrayList2 = Regression.dataSign(this.xData[0]);
        d = (Double)arrayList2.get(0);
        double d4 = d;
        d = (Double)arrayList2.get(2);
        double d5 = d;
        double d6 = this.xData[0][n6];
        double d7 = Math.log(2.0) * Regression.halfWidth(this.xData[0], this.yData);
        double[] dArray = new double[this.nData];
        double[] dArray2 = new double[this.nData];
        double[] dArray3 = new double[this.nData];
        for (int j = 0; j < this.nData; ++j) {
            dArray[j] = this.xData[0][j];
            dArray2[j] = this.yData[j];
            dArray3[j] = this.weight[j];
        }
        double[] dArray4 = new double[this.nData];
        double[] dArray5 = new double[this.nData];
        double[] dArray6 = new double[this.nData];
        ErrorProp[] errorPropArray = ErrorProp.oneDarray(this.nData);
        double d8 = this.calculateCumulativeValues(dArray4, dArray5, dArray6, errorPropArray, n6, d2, d6, string);
        for (n4 = 0; n4 < this.nData; ++n4) {
            errorPropArray[n4] = ErrorProp.minus(1.0, errorPropArray[n4]);
            dArray5[n4] = errorPropArray[n4].getValue();
            dArray6[n4] = errorPropArray[n4].getError();
        }
        for (n4 = 0; n4 < this.nData; ++n4) {
            this.xData[0][n4] = dArray4[n4];
            this.yData[n4] = dArray5[n4];
            this.weight[n4] = dArray6[n4];
        }
        n4 = this.weightOpt ? 1 : 0;
        this.weightOpt = true;
        this.statFlag = false;
        double[] dArray7 = new double[this.nParam];
        double[] dArray8 = new double[this.nParam];
        for (int j = 0; j < this.nParam; ++j) {
            dArray7[j] = 1.0;
            dArray8[j] = 0.2;
        }
        switch (n2) {
            case 3: {
                dArray7[0] = 2.0;
                dArray7[1] = d4 * 0.9;
                dArray7[2] = d4 < 0.0 ? -d4 * 1.1 : d4 * 0.01;
                if (dArray7[1] < 0.0) {
                    dArray7[1] = 0.0;
                }
                dArray8[0] = 0.2 * dArray7[0];
                dArray8[1] = 0.2 * dArray7[1];
                if (dArray8[1] == 0.0) {
                    double d9 = d5;
                    if (d9 == 0.0) {
                        d9 = d4;
                    }
                    dArray8[1] = d9 * 0.1;
                }
                this.addConstraint(0, -1, 0.0);
                this.addConstraint(1, -1, 0.0);
                this.addConstraint(1, 1, d4);
                break;
            }
            case 2: {
                if (d4 < 0.0) {
                    System.out.println("Method: FitParetoTwoPar/FitParetoTwoParPlot\nNegative data values present\nFitParetoShifted/FitParetoShiftedPlot would have been more appropriate");
                }
                dArray7[0] = 2.0;
                dArray7[1] = d4 * 0.9;
                if (dArray7[1] < 0.0) {
                    dArray7[1] = 0.0;
                }
                dArray8[0] = 0.2 * dArray7[0];
                dArray8[1] = 0.2 * dArray7[1];
                if (dArray8[1] == 0.0) {
                    double d10 = d5;
                    if (d10 == 0.0) {
                        d10 = d4;
                    }
                    dArray8[1] = d10 * 0.1;
                }
                this.addConstraint(0, -1, 0.0);
                this.addConstraint(1, -1, 0.0);
                break;
            }
            case 1: {
                if (d4 < 0.0) {
                    System.out.println("Method: FitParetoOnePar/FitParetoOneParPlot\nNegative data values present\nFitParetoShifted/FitParetoShiftedPlot would have been more appropriate");
                }
                dArray7[0] = 2.0;
                dArray8[0] = 0.2 * dArray7[0];
                this.addConstraint(0, -1, 0.0);
                this.addConstraint(1, -1, 0.0);
            }
        }
        ParetoFunctionTwo paretoFunctionTwo = new ParetoFunctionTwo();
        paretoFunctionTwo.setTypeFlag(n2);
        ParetoFunctionTwo paretoFunctionTwo2 = paretoFunctionTwo;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.nelderMead(paretoFunctionTwo2, null, dArray7, dArray8, this.fTol, this.nMax);
        double[] dArray9 = Conv.copy(this.best);
        this.statFlag = true;
        this.weightOpt = n4;
        for (int j = 0; j < this.nData; ++j) {
            this.xData[0][j] = dArray[j];
            this.yData[j] = dArray2[j];
            this.weight[j] = dArray3[j];
        }
        switch (n2) {
            case 3: {
                dArray7[0] = dArray9[0];
                if (dArray7[0] <= 0.0) {
                    dArray7[0] = dArray7[0] == 0.0 ? 1.0 : Math.min(1.0, -dArray7[0]);
                }
                dArray7[1] = dArray9[1];
                if (dArray7[1] <= 0.0) {
                    dArray7[1] = dArray7[1] == 0.0 ? 1.0 : Math.min(1.0, -dArray7[1]);
                }
                dArray7[2] = dArray9[2];
                if (this.scaleFlag) {
                    dArray7[3] = 1.0 / d8;
                }
                dArray8[0] = 0.1 * dArray7[0];
                dArray8[1] = 0.1 * dArray7[1];
                if (dArray8[1] == 0.0) {
                    double d11 = d5;
                    if (d11 == 0.0) {
                        d11 = d4;
                    }
                    dArray8[1] = d11 * 0.1;
                }
                if (!this.scaleFlag) break;
                dArray8[2] = 0.1 * dArray7[2];
                break;
            }
            case 2: {
                dArray7[0] = dArray9[0];
                if (dArray7[0] <= 0.0) {
                    dArray7[0] = dArray7[0] == 0.0 ? 1.0 : Math.min(1.0, -dArray7[0]);
                }
                dArray7[1] = dArray9[1];
                if (dArray7[1] <= 0.0) {
                    dArray7[1] = dArray7[1] == 0.0 ? 1.0 : Math.min(1.0, -dArray7[1]);
                }
                if (this.scaleFlag) {
                    dArray7[2] = 1.0 / d8;
                }
                dArray8[0] = 0.1 * dArray7[0];
                dArray8[1] = 0.1 * dArray7[1];
                if (dArray8[1] == 0.0) {
                    double d12 = d5;
                    if (d12 == 0.0) {
                        d12 = d4;
                    }
                    dArray8[1] = d12 * 0.1;
                }
                if (!this.scaleFlag) break;
                dArray8[2] = 0.1 * dArray7[2];
                break;
            }
            case 1: {
                dArray7[0] = dArray9[0];
                if (dArray7[0] <= 0.0) {
                    dArray7[0] = dArray7[0] == 0.0 ? 1.0 : Math.min(1.0, -dArray7[0]);
                }
                if (this.scaleFlag) {
                    dArray7[1] = 1.0 / d8;
                }
                dArray8[0] = 0.1 * dArray7[0];
                if (!this.scaleFlag) break;
                dArray8[1] = 0.1 * dArray7[1];
            }
        }
        ParetoFunctionOne paretoFunctionOne = new ParetoFunctionOne();
        paretoFunctionOne.setScaleOption(this.scaleFlag);
        paretoFunctionOne.setScaleFactor(this.yScaleFactor);
        paretoFunctionOne.setTypeFlag(n2);
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        ParetoFunctionOne paretoFunctionOne2 = paretoFunctionOne;
        this.nelderMead(paretoFunctionOne2, null, dArray7, dArray8, this.fTol, this.nMax);
        if (n == 1) {
            if (!this.suppressPrint) {
                this.print();
            }
            if ((n3 = this.plotXY(paretoFunctionOne)) != -2 && !this.suppressYYplot) {
                this.plotYY();
            }
        }
        this.weightOpt = n4;
        if (bl2) {
            for (n3 = 0; n3 < this.nData; ++n3) {
                this.yData[n3] = dArray2[n3] / d3;
                if (!this.weightOpt) continue;
                this.weight[n3] = dArray3[n3] / d3;
            }
        }
        if (bl) {
            for (n3 = 0; n3 < this.nData; ++n3) {
                this.yData[n3] = -this.yData[n3];
            }
        }
    }

    public void sigmoidThreshold() {
        this.fitSigmoidThreshold(0);
    }

    public void sigmoidThresholdPlot() {
        this.fitSigmoidThreshold(1);
    }

    protected void fitSigmoidThreshold(int n) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 25;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 3;
        if (!this.scaleFlag) {
            this.nParam = 2;
        }
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        double d = Fmath.minimum(this.yData);
        double d2 = Fmath.maximum(this.yData);
        int n2 = 1;
        if (d < 0.0) {
            n2 = -1;
        }
        double d3 = (d2 - d) / 2.0;
        double d4 = this.xData[0][0];
        int n3 = 1;
        int n4 = this.yData.length;
        boolean bl = true;
        while (bl) {
            if (this.yData[n3] >= (double)n2 * d3) {
                d4 = this.xData[0][n3];
                bl = false;
                continue;
            }
            if (++n3 < n4) continue;
            d4 = Stat.mean(this.xData[0]);
            n3 = n4 - 1;
            bl = false;
        }
        double d5 = this.xData[0][n4 - 1];
        int n5 = n4 - 1;
        bl = true;
        while (bl) {
            if (this.yData[n5] <= (double)n2 * d3) {
                d5 = this.xData[0][n5];
                bl = false;
                continue;
            }
            if (--n5 >= 0) continue;
            d5 = Stat.mean(this.xData[0]);
            n5 = 1;
            bl = false;
        }
        int n6 = (n3 + n5) / 2;
        double d6 = this.xData[0][n6];
        double d7 = 2.0 * (this.yData[n4 - 1] - d6) / (this.xData[0][n4 - 1] - this.xData[0][n6]);
        double d8 = 2.0 * d6 / (this.xData[0][n6] - this.xData[0][n4 - 1]);
        double d9 = Math.max(d7, d8);
        double[] dArray = new double[this.nParam];
        dArray[0] = 4.0 * d9;
        dArray[0] = n2 == 1 ? dArray[0] / d2 : dArray[0] / d;
        dArray[1] = d6;
        if (this.scaleFlag) {
            dArray[2] = n2 == 1 ? d2 : d;
        }
        double[] dArray2 = new double[this.nParam];
        for (int j = 0; j < this.nParam; ++j) {
            dArray2[j] = 0.1 * dArray[j];
        }
        if (dArray2[0] == 0.0) {
            dArray2[0] = 0.1 * (this.xData[0][n4 - 1] - this.xData[0][0]) / (this.yData[n4 - 1] - this.yData[0]);
        }
        if (dArray2[1] == 0.0) {
            dArray2[1] = (this.xData[0][n4 - 1] - this.xData[0][0]) / 20.0;
        }
        if (this.scaleFlag && dArray2[2] == 0.0) {
            dArray2[2] = 0.1 * (this.yData[n4 - 1] - this.yData[0]);
        }
        if (this.xErrorsEntered) {
            this.dualErrorsRequired = true;
            this.nonLinStatsNeeded = true;
            this.simplexFlag = 3;
            SigmoidThresholdFunctionDual sigmoidThresholdFunctionDual = new SigmoidThresholdFunctionDual();
            sigmoidThresholdFunctionDual.setScaleOption(this.scaleFlag);
            sigmoidThresholdFunctionDual.setScaleFactor(this.yScaleFactor);
            sigmoidThresholdFunctionDual.setXerrors(this.xErrors);
            sigmoidThresholdFunctionDual.setYerrors(this.yErrors);
            SigmoidThresholdFunctionDual sigmoidThresholdFunctionDual2 = sigmoidThresholdFunctionDual;
            this.nelderMead(sigmoidThresholdFunctionDual2, null, dArray, dArray2, this.fTol, this.nMax);
            if (n == 1) {
                int n7;
                if (!this.suppressPrint) {
                    this.print();
                }
                if ((n7 = this.plotXY(sigmoidThresholdFunctionDual)) != -2 && !this.suppressYYplot) {
                    this.plotYY();
                }
            }
        } else {
            this.dualErrorsRequired = false;
            this.nonLinStatsNeeded = true;
            this.simplexFlag = 1;
            SigmoidThresholdFunction sigmoidThresholdFunction = new SigmoidThresholdFunction();
            sigmoidThresholdFunction.setScaleOption(this.scaleFlag);
            sigmoidThresholdFunction.setScaleFactor(this.yScaleFactor);
            SigmoidThresholdFunction sigmoidThresholdFunction2 = sigmoidThresholdFunction;
            this.nelderMead(sigmoidThresholdFunction2, null, dArray, dArray2, this.fTol, this.nMax);
            if (n == 1) {
                int n8;
                if (!this.suppressPrint) {
                    this.print();
                }
                if ((n8 = this.plotXY(sigmoidThresholdFunction)) != -2 && !this.suppressYYplot) {
                    this.plotYY();
                }
            }
        }
        this.dualErrorsRequired = false;
        this.nonLinStatsNeeded = true;
    }

    public void sigmoidHillSips() {
        this.fitsigmoidHillSips(0);
    }

    public void sigmoidHillSipsPlot() {
        this.fitsigmoidHillSips(1);
    }

    protected void fitsigmoidHillSips(int n) {
        int n2;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 28;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 3;
        if (!this.scaleFlag) {
            this.nParam = 2;
        }
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        double[] dArray = Conv.copy(this.xData[0]);
        double[] dArray2 = Conv.copy(this.yData);
        int n3 = 1;
        if (this.yData[0] > this.yData[this.nData - 1]) {
            n3 = -1;
            for (int j = 0; j < this.nData; ++j) {
                dArray2[j] = -dArray2[j];
            }
        }
        double d = Fmath.minimum(dArray2);
        double d2 = Fmath.maximum(dArray2);
        double d3 = 0.0;
        double d4 = d2 - d;
        if (d <= 0.0) {
            d3 = d - 0.01 * d4;
            for (int j = 0; j < this.nData; ++j) {
                dArray2[j] = dArray2[j] - d3;
            }
        }
        double d5 = Fmath.minimum(dArray);
        double d6 = Fmath.maximum(dArray);
        double d7 = 0.0;
        double d8 = d6 - d5;
        if (d5 <= 0.0) {
            d7 = d5 - 0.01 * d8;
            for (n2 = 0; n2 < this.nData; ++n2) {
                dArray[n2] = dArray[n2] - d7;
            }
        }
        for (n2 = 0; n2 < this.nData; ++n2) {
            dArray2[n2] = Math.log(d4 + 0.01 * d4 - dArray2[n2]) - Math.log(dArray2[n2]);
            dArray[n2] = Math.log(dArray[n2]);
        }
        Regression regression = new Regression(dArray, dArray2);
        regression.linear();
        double[] dArray3 = regression.getBestEstimates();
        double[] dArray4 = new double[this.nParam];
        dArray4[1] = -dArray3[1] * (double)n3;
        dArray4[0] = Math.exp(dArray3[0] / dArray4[1]) + d7;
        if (this.scaleFlag) {
            dArray4[2] = d4 * (double)n3;
        }
        int n4 = this.nData / 2;
        double[] dArray5 = new double[this.nParam];
        for (int j = 0; j < this.nParam; ++j) {
            dArray5[j] = 0.1 * dArray4[j];
        }
        if (dArray5[0] == 0.0) {
            dArray5[0] = 0.1 * (this.xData[0][n4 - 1] - this.xData[0][0]) / (this.yData[n4 - 1] - this.yData[0]);
        }
        if (dArray5[1] == 0.0) {
            dArray5[1] = (this.xData[0][n4 - 1] - this.xData[0][0]) / 20.0;
        }
        if (this.scaleFlag && dArray5[2] == 0.0) {
            dArray5[2] = 0.1 * (this.yData[n4 - 1] - this.yData[0]);
        }
        if (this.xErrorsEntered) {
            this.dualErrorsRequired = true;
            this.nonLinStatsNeeded = true;
            this.simplexFlag = 3;
            SigmoidHillSipsFunctionDual sigmoidHillSipsFunctionDual = new SigmoidHillSipsFunctionDual();
            sigmoidHillSipsFunctionDual.setScaleOption(this.scaleFlag);
            sigmoidHillSipsFunctionDual.setScaleFactor(this.yScaleFactor);
            sigmoidHillSipsFunctionDual.setXerrors(this.xErrors);
            sigmoidHillSipsFunctionDual.setYerrors(this.yErrors);
            SigmoidHillSipsFunctionDual sigmoidHillSipsFunctionDual2 = sigmoidHillSipsFunctionDual;
            this.nelderMead(sigmoidHillSipsFunctionDual2, null, dArray4, dArray5, this.fTol, this.nMax);
            if (n == 1) {
                int n5;
                if (!this.suppressPrint) {
                    this.print();
                }
                if ((n5 = this.plotXY(sigmoidHillSipsFunctionDual)) != -2 && !this.suppressYYplot) {
                    this.plotYY();
                }
            }
        } else {
            this.dualErrorsRequired = false;
            this.nonLinStatsNeeded = true;
            this.simplexFlag = 1;
            SigmoidHillSipsFunction sigmoidHillSipsFunction = new SigmoidHillSipsFunction();
            sigmoidHillSipsFunction.setScaleOption(this.scaleFlag);
            sigmoidHillSipsFunction.setScaleFactor(this.yScaleFactor);
            SigmoidHillSipsFunction sigmoidHillSipsFunction2 = sigmoidHillSipsFunction;
            this.nelderMead(sigmoidHillSipsFunction2, null, dArray4, dArray5, this.fTol, this.nMax);
            if (n == 1) {
                int n6;
                if (!this.suppressPrint) {
                    this.print();
                }
                if ((n6 = this.plotXY(sigmoidHillSipsFunction)) != -2 && !this.suppressYYplot) {
                    this.plotYY();
                }
            }
        }
        this.dualErrorsRequired = false;
        this.nonLinStatsNeeded = true;
    }

    public void ec50() {
        this.fitEC50(0);
    }

    public void ec50Plot() {
        this.fitEC50(1);
    }

    public void ec50constrained() {
        this.fitEC50(2);
    }

    public void ec50constrainedPlot() {
        this.fitEC50(3);
    }

    public void fourParameterLogistic() {
        this.fitEC50(0);
    }

    public void fourParameterLogisticPlot() {
        this.fitEC50(1);
    }

    public void fourParameterLogisticConstrained() {
        this.fitEC50(2);
    }

    public void fourParameterLogisticConstrainedPlot() {
        this.fitEC50(3);
    }

    protected void fitEC50(int n) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        boolean bl = false;
        boolean bl2 = false;
        this.userSupplied = false;
        switch (n) {
            case 0: {
                this.lastMethod = 39;
                bl = false;
                break;
            }
            case 1: {
                this.lastMethod = 39;
                bl = true;
                break;
            }
            case 2: {
                this.lastMethod = 41;
                bl = false;
                bl2 = true;
                break;
            }
            case 3: {
                this.lastMethod = 41;
                bl = true;
                bl2 = true;
            }
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 4;
        this.scaleFlag = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        int n2 = this.yData.length;
        this.midPoint();
        double d = 1.0;
        if (this.directionFlag == -1) {
            d = -1.0;
        }
        double[] dArray = new double[this.nParam];
        dArray[0] = this.topS;
        dArray[1] = this.bottomS;
        dArray[2] = this.midPointXvalue;
        dArray[3] = d;
        double[] dArray2 = new double[this.nParam];
        for (int j = 0; j < this.nParam; ++j) {
            dArray2[j] = 0.1 * Math.abs(dArray[j]);
        }
        if (dArray2[0] == 0.0) {
            dArray2[0] = 0.1 * (this.yData[n2 - 1] - this.yData[0]);
        }
        if (dArray2[1] == 0.0) {
            dArray2[1] = 0.1 * (this.yData[n2 - 1] - this.yData[0]);
        }
        if (dArray2[2] == 0.0) {
            dArray2[2] = 0.05 * (this.xData[0][n2 - 1] - this.xData[0][0]);
        }
        if (dArray2[3] == 0.0) {
            dArray2[3] = 0.1 * (this.xData[0][n2 - 1] - this.xData[0][0]) / (this.yData[n2 - 1] - this.yData[0]);
        }
        if (bl2) {
            this.addConstraint(0, -1, 0.0);
        }
        if (this.xErrorsEntered) {
            EC50FunctionDual eC50FunctionDual = new EC50FunctionDual();
            eC50FunctionDual.setXerrors(this.xErrors);
            eC50FunctionDual.setYerrors(this.yErrors);
            EC50FunctionDual eC50FunctionDual2 = eC50FunctionDual;
            this.simplexFlag = 3;
            this.nonLinStatsNeeded = true;
            this.dualErrorsRequired = true;
            this.nelderMead(eC50FunctionDual2, null, dArray, dArray2, this.fTol, this.nMax);
            if (bl) {
                int n3;
                if (!this.suppressPrint) {
                    this.print();
                }
                if ((n3 = this.plotXY(eC50FunctionDual)) != -2 && !this.suppressYYplot) {
                    this.plotYY();
                }
            }
        } else {
            EC50Function eC50Function;
            EC50Function eC50Function2 = eC50Function = new EC50Function();
            this.simplexFlag = 1;
            this.nonLinStatsNeeded = true;
            this.dualErrorsRequired = false;
            this.nelderMead(eC50Function2, null, dArray, dArray2, this.fTol, this.nMax);
            if (bl) {
                int n4;
                if (!this.suppressPrint) {
                    this.print();
                }
                if ((n4 = this.plotXY(eC50Function)) != -2 && !this.suppressYYplot) {
                    this.plotYY();
                }
            }
        }
    }

    protected void ec50(double d, double d2) {
        this.lastMethod = 40;
        this.fitEC50(d, d2, 0);
    }

    protected void fourParameterLogistic(double d, double d2) {
        this.lastMethod = 40;
        this.fitEC50(d, d2, 0);
    }

    protected void ec50Plot(double d, double d2) {
        this.lastMethod = 40;
        this.fitEC50(d, d2, 1);
    }

    protected void fourParameterLogisticPlot(double d, double d2) {
        this.lastMethod = 40;
        this.fitEC50(d, d2, 1);
    }

    private void fitEC50(double d, double d2, int n) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.bottom = d;
        this.top = d2;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 2;
        this.scaleFlag = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        int n2 = this.yData.length;
        this.midPoint();
        double d3 = 1.0;
        if (this.directionFlag == -1) {
            d3 = -1.0;
        }
        double[] dArray = new double[this.nParam];
        dArray[0] = this.midPointXvalue;
        dArray[1] = d3;
        double[] dArray2 = new double[this.nParam];
        for (int j = 0; j < this.nParam; ++j) {
            dArray2[j] = 0.1 * Math.abs(dArray[j]);
        }
        if (dArray2[0] == 0.0) {
            dArray2[0] = 0.05 * (this.xData[0][n2 - 1] - this.xData[0][0]);
        }
        if (dArray2[1] == 0.0) {
            dArray2[1] = 0.1 * (this.xData[0][n2 - 1] - this.xData[0][0]) / (this.yData[n2 - 1] - this.yData[0]);
        }
        if (this.xErrorsEntered) {
            EC50FixedFunctionDual eC50FixedFunctionDual = new EC50FixedFunctionDual();
            eC50FixedFunctionDual.setBottom(this.bottom);
            eC50FixedFunctionDual.setTop(this.top);
            eC50FixedFunctionDual.setXerrors(this.xErrors);
            eC50FixedFunctionDual.setYerrors(this.yErrors);
            EC50FixedFunctionDual eC50FixedFunctionDual2 = eC50FixedFunctionDual;
            this.simplexFlag = 3;
            this.nonLinStatsNeeded = true;
            this.dualErrorsRequired = true;
            this.nelderMead(eC50FixedFunctionDual2, null, dArray, dArray2, this.fTol, this.nMax);
            if (n == 1) {
                int n3;
                if (!this.suppressPrint) {
                    this.print();
                }
                if ((n3 = this.plotXY(eC50FixedFunctionDual)) != -2 && !this.suppressYYplot) {
                    this.plotYY();
                }
            }
        } else {
            EC50FixedFunction eC50FixedFunction = new EC50FixedFunction();
            eC50FixedFunction.setBottom(this.bottom);
            eC50FixedFunction.setTop(this.top);
            EC50FixedFunction eC50FixedFunction2 = eC50FixedFunction;
            this.simplexFlag = 1;
            this.nonLinStatsNeeded = true;
            this.dualErrorsRequired = false;
            this.nelderMead(eC50FixedFunction2, null, dArray, dArray2, this.fTol, this.nMax);
            if (n == 1) {
                int n4;
                if (!this.suppressPrint) {
                    this.print();
                }
                if ((n4 = this.plotXY(eC50FixedFunction)) != -2 && !this.suppressYYplot) {
                    this.plotYY();
                }
            }
        }
    }

    private void midPoint() {
        double d;
        this.bottomS = Fmath.minimum(this.yData);
        this.topS = Fmath.maximum(this.yData);
        this.bottomSindex = 0.0;
        this.topSindex = 0.0;
        int n = this.yData.length;
        int n2 = 0;
        boolean bl = true;
        while (bl) {
            if (this.bottomS == this.yData[n2]) {
                this.bottomSindex = n2;
                bl = false;
                continue;
            }
            if (++n2 < n) continue;
            throw new IllegalArgumentException("This should not be possible - check coding");
        }
        bl = true;
        n2 = 0;
        while (bl) {
            if (this.topS == this.yData[n2]) {
                this.topSindex = n2;
                bl = false;
                continue;
            }
            if (++n2 < n) continue;
            throw new IllegalArgumentException("This should not be possible - check coding");
        }
        this.directionFlag = 1;
        if (this.topSindex < this.bottomSindex) {
            this.directionFlag = -1;
        }
        this.midPointYvalue = d = this.topS - (this.topS - this.bottomS) / 2.0;
        double d2 = this.xData[0][0];
        n2 = 0;
        if (this.directionFlag == 1) {
            bl = true;
            while (bl) {
                if (this.yData[n2] >= d) {
                    d2 = this.xData[0][n2];
                    bl = false;
                    continue;
                }
                if (++n2 < n) continue;
                d2 = Stat.mean(this.xData[0]);
                n2 = n - 1;
                bl = false;
            }
            double d3 = this.xData[0][n - 1];
            int n3 = n - 1;
            bl = true;
            while (bl) {
                if (this.yData[n3] <= d) {
                    d3 = this.xData[0][n3];
                    bl = false;
                    continue;
                }
                if (--n3 >= 0) continue;
                d3 = Stat.mean(this.xData[0]);
                n3 = 1;
                bl = false;
            }
            if (n2 < n3) {
                int n4 = n3;
                n3 = n2;
                n2 = n4;
            }
            this.midPointLowerIndex = n3;
            this.midPointUpperIndex = n2;
            this.midPointXvalue = (this.xData[0][n2] + this.xData[0][n3]) / 2.0;
        } else {
            int n5;
            n2 = 0;
            bl = true;
            while (bl) {
                if (this.yData[n2] <= d) {
                    d2 = this.xData[0][n2];
                    bl = false;
                    continue;
                }
                if (++n2 < n) continue;
                d2 = Stat.mean(this.xData[0]);
                n2 = n - 1;
                bl = false;
            }
            double d4 = this.xData[0][n - 1];
            int n6 = n - 1;
            bl = true;
            while (bl) {
                if (this.yData[n6] >= d) {
                    d4 = this.xData[0][n6];
                    bl = false;
                    continue;
                }
                if (--n6 >= 0) continue;
                d4 = Stat.mean(this.xData[0]);
                n6 = 1;
                bl = false;
            }
            if (n2 > n6) {
                n5 = n6;
                n6 = n2;
                n2 = n5;
            }
            if (n2 < n6) {
                n5 = n6;
                n6 = n2;
                n2 = n5;
            }
            this.midPointLowerIndex = n6;
            this.midPointUpperIndex = n2;
            this.midPointXvalue = (this.xData[0][n2] + this.xData[0][n6]) / 2.0;
        }
    }

    public void fiveParameterLogistic() {
        this.fitfiveParameterLogistic(0);
    }

    public void fiveParameterLogisticPlot() {
        this.fitfiveParameterLogistic(1);
    }

    protected void fitfiveParameterLogistic(int n) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        boolean bl = false;
        this.userSupplied = false;
        this.lastMethod = 51;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 5;
        this.scaleFlag = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        int n2 = this.yData.length;
        this.midPoint();
        double d = 1.0;
        if (this.directionFlag == -1 && d >= 0.0) {
            d = -1.0;
        }
        double[] dArray = new double[this.nParam];
        dArray[0] = this.topS;
        dArray[1] = this.bottomS;
        dArray[2] = this.midPointXvalue;
        dArray[3] = d;
        dArray[4] = 1.0;
        double[] dArray2 = new double[this.nParam];
        for (int j = 0; j < this.nParam; ++j) {
            dArray2[j] = 0.1 * Math.abs(dArray[j]);
        }
        if (dArray2[0] == 0.0) {
            dArray2[0] = 0.1 * (this.yData[n2 - 1] - this.yData[0]);
        }
        if (dArray2[1] == 0.0) {
            dArray2[1] = 0.1 * (this.yData[n2 - 1] - this.yData[0]);
        }
        if (dArray2[2] == 0.0) {
            dArray2[2] = 0.05 * (this.xData[0][n2 - 1] - this.xData[0][0]);
        }
        if (dArray2[3] == 0.0) {
            dArray2[3] = 0.1 * (this.xData[0][n2 - 1] - this.xData[0][0]) / (this.yData[n2 - 1] - this.yData[0]);
        }
        if (this.xErrorsEntered) {
            Logistic5FunctionDual logistic5FunctionDual = new Logistic5FunctionDual();
            logistic5FunctionDual.setXerrors(this.xErrors);
            logistic5FunctionDual.setYerrors(this.yErrors);
            Logistic5FunctionDual logistic5FunctionDual2 = logistic5FunctionDual;
            this.simplexFlag = 3;
            this.nonLinStatsNeeded = true;
            this.dualErrorsRequired = true;
            this.nelderMead(logistic5FunctionDual2, null, dArray, dArray2, this.fTol, this.nMax);
            if (n == 1) {
                int n3;
                if (!this.suppressPrint) {
                    this.print();
                }
                if ((n3 = this.plotXY(logistic5FunctionDual)) != -2 && !this.suppressYYplot) {
                    this.plotYY();
                }
            }
        } else {
            Logistic5Function logistic5Function;
            Logistic5Function logistic5Function2 = logistic5Function = new Logistic5Function();
            this.simplexFlag = 1;
            this.nonLinStatsNeeded = true;
            this.dualErrorsRequired = false;
            this.nelderMead(logistic5Function2, null, dArray, dArray2, this.fTol, this.nMax);
            if (n == 1) {
                int n4;
                if (!this.suppressPrint) {
                    this.print();
                }
                if ((n4 = this.plotXY(logistic5Function)) != -2 && !this.suppressYYplot) {
                    this.plotYY();
                }
            }
        }
    }

    public void fiveParameterLogistic(double d, double d2) {
        this.lastMethod = 42;
        this.fitFiveParameterLogistic(d, d2, 0);
    }

    public void fiveParameterLogisticPlot(double d, double d2) {
        this.lastMethod = 42;
        this.fitFiveParameterLogistic(d, d2, 1);
    }

    protected void fitFiveParameterLogistic(double d, double d2, int n) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 3;
        this.scaleFlag = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        int n2 = this.yData.length;
        this.midPoint();
        double d3 = 1.0;
        if (this.directionFlag == -1) {
            d3 = -1.0;
        }
        double[] dArray = new double[this.nParam];
        dArray[0] = this.midPointXvalue;
        dArray[1] = d3;
        dArray[2] = 1.0;
        double[] dArray2 = new double[this.nParam];
        for (int j = 0; j < this.nParam; ++j) {
            dArray2[j] = 0.1 * Math.abs(dArray[j]);
        }
        if (dArray2[0] == 0.0) {
            dArray2[0] = 0.05 * (this.xData[0][n2 - 1] - this.xData[0][0]);
        }
        if (dArray2[1] == 0.0) {
            dArray2[1] = 0.1 * (this.xData[0][n2 - 1] - this.xData[0][0]) / (this.yData[n2 - 1] - this.yData[0]);
        }
        if (dArray2[2] == 0.0) {
            dArray2[2] = 0.1;
        }
        if (this.xErrorsEntered) {
            Logistic5FixedFunctionDual logistic5FixedFunctionDual = new Logistic5FixedFunctionDual();
            logistic5FixedFunctionDual.setBottom(d);
            logistic5FixedFunctionDual.setTop(d2);
            logistic5FixedFunctionDual.setXerrors(this.xErrors);
            logistic5FixedFunctionDual.setYerrors(this.yErrors);
            Logistic5FixedFunctionDual logistic5FixedFunctionDual2 = logistic5FixedFunctionDual;
            this.simplexFlag = 3;
            this.nonLinStatsNeeded = true;
            this.dualErrorsRequired = true;
            this.nelderMead(logistic5FixedFunctionDual2, null, dArray, dArray2, this.fTol, this.nMax);
            if (n == 1) {
                int n3;
                if (!this.suppressPrint) {
                    this.print();
                }
                if ((n3 = this.plotXY(logistic5FixedFunctionDual)) != -2 && !this.suppressYYplot) {
                    this.plotYY();
                }
            }
        } else {
            Logistic5FixedFunction logistic5FixedFunction = new Logistic5FixedFunction();
            logistic5FixedFunction.setBottom(d);
            logistic5FixedFunction.setTop(d2);
            Logistic5FixedFunction logistic5FixedFunction2 = logistic5FixedFunction;
            this.simplexFlag = 1;
            this.nonLinStatsNeeded = true;
            this.dualErrorsRequired = false;
            this.nelderMead(logistic5FixedFunction2, null, dArray, dArray2, this.fTol, this.nMax);
            if (n == 1) {
                int n4;
                if (!this.suppressPrint) {
                    this.print();
                }
                if ((n4 = this.plotXY(logistic5FixedFunction)) != -2 && !this.suppressYYplot) {
                    this.plotYY();
                }
            }
        }
    }

    public void rectangularHyperbola() {
        this.fitRectangularHyperbola(0);
    }

    public void rectangularHyperbolaPlot() {
        this.fitRectangularHyperbola(1);
    }

    protected void fitRectangularHyperbola(int n) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 26;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 2;
        if (!this.scaleFlag) {
            this.nParam = 1;
        }
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        double d = Fmath.minimum(this.yData);
        double d2 = Fmath.maximum(this.yData);
        int n2 = 1;
        if (d < 0.0) {
            n2 = -1;
        }
        double d3 = (d2 - d) / 2.0;
        double d4 = this.xData[0][0];
        int n3 = 1;
        int n4 = this.yData.length;
        boolean bl = true;
        while (bl) {
            if (this.yData[n3] >= (double)n2 * d3) {
                d4 = this.xData[0][n3];
                bl = false;
                continue;
            }
            if (++n3 < n4) continue;
            d4 = Stat.mean(this.xData[0]);
            n3 = n4 - 1;
            bl = false;
        }
        double d5 = this.xData[0][n4 - 1];
        int n5 = n4 - 1;
        bl = true;
        while (bl) {
            if (this.yData[n5] <= (double)n2 * d3) {
                d5 = this.xData[0][n5];
                bl = false;
                continue;
            }
            if (--n5 >= 0) continue;
            d5 = Stat.mean(this.xData[0]);
            n5 = 1;
            bl = false;
        }
        int n6 = (n3 + n5) / 2;
        double d6 = this.xData[0][n6];
        double[] dArray = new double[this.nParam];
        dArray[0] = d6;
        if (this.scaleFlag) {
            dArray[1] = n2 == 1 ? d2 : d;
        }
        double[] dArray2 = new double[this.nParam];
        for (int j = 0; j < this.nParam; ++j) {
            dArray2[j] = 0.1 * dArray[j];
        }
        if (dArray2[0] == 0.0) {
            dArray2[0] = (this.xData[0][n4 - 1] - this.xData[0][0]) / 20.0;
        }
        if (this.scaleFlag && dArray2[1] == 0.0) {
            dArray2[1] = 0.1 * (this.yData[n4 - 1] - this.yData[0]);
        }
        if (this.xErrorsEntered) {
            RectangularHyperbolaFunctionDual rectangularHyperbolaFunctionDual = new RectangularHyperbolaFunctionDual();
            rectangularHyperbolaFunctionDual.setScaleOption(this.scaleFlag);
            rectangularHyperbolaFunctionDual.setScaleFactor(this.yScaleFactor);
            rectangularHyperbolaFunctionDual.setXerrors(this.xErrors);
            rectangularHyperbolaFunctionDual.setYerrors(this.yErrors);
            RectangularHyperbolaFunctionDual rectangularHyperbolaFunctionDual2 = rectangularHyperbolaFunctionDual;
            this.simplexFlag = 3;
            this.nonLinStatsNeeded = true;
            this.dualErrorsRequired = true;
            this.nelderMead(rectangularHyperbolaFunctionDual2, null, dArray, dArray2, this.fTol, this.nMax);
            if (n == 1) {
                int n7;
                if (!this.suppressPrint) {
                    this.print();
                }
                if ((n7 = this.plotXY(rectangularHyperbolaFunctionDual)) != -2 && !this.suppressYYplot) {
                    this.plotYY();
                }
            }
        } else {
            RectangularHyperbolaFunction rectangularHyperbolaFunction = new RectangularHyperbolaFunction();
            rectangularHyperbolaFunction.setScaleOption(this.scaleFlag);
            rectangularHyperbolaFunction.setScaleFactor(this.yScaleFactor);
            RectangularHyperbolaFunction rectangularHyperbolaFunction2 = rectangularHyperbolaFunction;
            this.simplexFlag = 1;
            this.nonLinStatsNeeded = true;
            this.dualErrorsRequired = false;
            this.nelderMead(rectangularHyperbolaFunction2, null, dArray, dArray2, this.fTol, this.nMax);
            if (n == 1) {
                int n8;
                if (!this.suppressPrint) {
                    this.print();
                }
                if ((n8 = this.plotXY(rectangularHyperbolaFunction)) != -2 && !this.suppressYYplot) {
                    this.plotYY();
                }
            }
        }
    }

    public void shiftedRectangularHyperbola() {
        this.fitShiftedRectangularHyperbola(0);
    }

    public void shiftedRectangularHyperbolaPlot() {
        this.fitShiftedRectangularHyperbola(1);
    }

    protected void fitShiftedRectangularHyperbola(int n) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 52;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 3;
        boolean bl = this.scaleFlag;
        this.scaleFlag = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        double d = Fmath.minimum(this.yData);
        double d2 = Fmath.maximum(this.yData);
        int n2 = 1;
        if (d < 0.0) {
            n2 = -1;
        }
        double d3 = (d2 - d) / 2.0;
        double d4 = this.xData[0][0];
        int n3 = 1;
        int n4 = this.yData.length;
        boolean bl2 = true;
        while (bl2) {
            if (this.yData[n3] >= (double)n2 * d3) {
                d4 = this.xData[0][n3];
                bl2 = false;
                continue;
            }
            if (++n3 < n4) continue;
            d4 = Stat.mean(this.xData[0]);
            n3 = n4 - 1;
            bl2 = false;
        }
        double d5 = this.xData[0][n4 - 1];
        int n5 = n4 - 1;
        bl2 = true;
        while (bl2) {
            if (this.yData[n5] <= (double)n2 * d3) {
                d5 = this.xData[0][n5];
                bl2 = false;
                continue;
            }
            if (--n5 >= 0) continue;
            d5 = Stat.mean(this.xData[0]);
            n5 = 1;
            bl2 = false;
        }
        int n6 = (n3 + n5) / 2;
        double d6 = this.xData[0][n6];
        double[] dArray = new double[this.nParam];
        dArray[0] = d6;
        dArray[1] = this.yData[0];
        dArray[2] = n2 == 1 ? d2 : d;
        double[] dArray2 = new double[this.nParam];
        for (int j = 0; j < this.nParam; ++j) {
            dArray2[j] = 0.1 * dArray[j];
        }
        if (dArray2[0] == 0.0) {
            dArray2[0] = (this.xData[0][n4 - 1] - this.xData[0][0]) / 20.0;
        }
        if (dArray2[1] == 0.0) {
            dArray2[1] = Math.abs(this.yData[n4 - 1] - this.yData[0]) / 20.0;
        }
        if (dArray2[2] == 0.0) {
            dArray2[1] = 0.1 * (this.yData[n4 - 1] - this.yData[0]);
        }
        if (this.xErrorsEntered) {
            ShiftedRectangularHyperbolaFunctionDual shiftedRectangularHyperbolaFunctionDual = new ShiftedRectangularHyperbolaFunctionDual();
            shiftedRectangularHyperbolaFunctionDual.setYerrors(this.yErrors);
            shiftedRectangularHyperbolaFunctionDual.setXerrors(this.xErrors);
            ShiftedRectangularHyperbolaFunctionDual shiftedRectangularHyperbolaFunctionDual2 = shiftedRectangularHyperbolaFunctionDual;
            this.simplexFlag = 3;
            this.nonLinStatsNeeded = true;
            this.dualErrorsRequired = true;
            this.nelderMead(shiftedRectangularHyperbolaFunctionDual2, null, dArray, dArray2, this.fTol, this.nMax);
            if (n == 1) {
                int n7;
                if (!this.suppressPrint) {
                    this.print();
                }
                if ((n7 = this.plotXY(shiftedRectangularHyperbolaFunctionDual)) != -2 && !this.suppressYYplot) {
                    this.plotYY();
                }
            }
        } else {
            ShiftedRectangularHyperbolaFunction shiftedRectangularHyperbolaFunction;
            ShiftedRectangularHyperbolaFunction shiftedRectangularHyperbolaFunction2 = shiftedRectangularHyperbolaFunction = new ShiftedRectangularHyperbolaFunction();
            this.simplexFlag = 1;
            this.nonLinStatsNeeded = true;
            this.dualErrorsRequired = false;
            this.nelderMead(shiftedRectangularHyperbolaFunction2, null, dArray, dArray2, this.fTol, this.nMax);
            if (n == 1) {
                int n8;
                if (!this.suppressPrint) {
                    this.print();
                }
                if ((n8 = this.plotXY(shiftedRectangularHyperbolaFunction)) != -2 && !this.suppressYYplot) {
                    this.plotYY();
                }
            }
        }
        this.scaleFlag = bl;
    }

    public void stepFunction() {
        this.fitStepFunction(0);
    }

    public void stepFunctionPlot() {
        this.fitStepFunction(1);
    }

    protected void fitStepFunction(int n) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 27;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 2;
        if (!this.scaleFlag) {
            this.nParam = 1;
        }
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        double d = Fmath.minimum(this.yData);
        double d2 = Fmath.maximum(this.yData);
        int n2 = 1;
        if (d < 0.0) {
            n2 = -1;
        }
        double d3 = (d2 - d) / 2.0;
        double d4 = this.xData[0][0];
        int n3 = 1;
        int n4 = this.yData.length;
        boolean bl = true;
        while (bl) {
            if (this.yData[n3] >= (double)n2 * d3) {
                d4 = this.xData[0][n3];
                bl = false;
                continue;
            }
            if (++n3 < n4) continue;
            d4 = Stat.mean(this.xData[0]);
            n3 = n4 - 1;
            bl = false;
        }
        double d5 = this.xData[0][n4 - 1];
        int n5 = n4 - 1;
        bl = true;
        while (bl) {
            if (this.yData[n5] <= (double)n2 * d3) {
                d5 = this.xData[0][n5];
                bl = false;
                continue;
            }
            if (--n5 >= 0) continue;
            d5 = Stat.mean(this.xData[0]);
            n5 = 1;
            bl = false;
        }
        int n6 = (n3 + n5) / 2;
        double d6 = this.xData[0][n6];
        double[] dArray = new double[this.nParam];
        dArray[0] = d6;
        if (this.scaleFlag) {
            dArray[1] = n2 == 1 ? d2 : d;
        }
        double[] dArray2 = new double[this.nParam];
        for (int j = 0; j < this.nParam; ++j) {
            dArray2[j] = 0.1 * dArray[j];
        }
        if (dArray2[0] == 0.0) {
            dArray2[0] = (this.xData[0][n4 - 1] - this.xData[0][0]) / 20.0;
        }
        if (this.scaleFlag && dArray2[1] == 0.0) {
            dArray2[1] = 0.1 * (this.yData[n4 - 1] - this.yData[0]);
        }
        StepFunctionFunction stepFunctionFunction = new StepFunctionFunction();
        stepFunctionFunction.setScaleOption(this.scaleFlag);
        stepFunctionFunction.setScaleFactor(this.yScaleFactor);
        StepFunctionFunction stepFunctionFunction2 = stepFunctionFunction;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.nelderMead(stepFunctionFunction2, null, dArray, dArray2, this.fTol, this.nMax);
        if (n == 1) {
            int n7;
            if (!this.suppressPrint) {
                this.print();
            }
            if ((n7 = this.plotXY(stepFunctionFunction)) != -2 && !this.suppressYYplot) {
                this.plotYY();
            }
        }
    }

    public void logistic() {
        this.fitLogistic(0);
    }

    public void logisticPlot() {
        this.fitLogistic(1);
    }

    protected void fitLogistic(int n) {
        Object object;
        Object object2;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 30;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 3;
        if (!this.scaleFlag) {
            this.nParam = 2;
        }
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double d = null;
        ArrayList<Object> arrayList = Regression.dataSign(this.yData);
        d = (Double)arrayList.get(4);
        double d2 = d;
        boolean bl = false;
        if (d2 < 0.0) {
            System.out.println("Regression.fitLogistic(): This implementation of the Logistic distribution takes only positive y values\n(noise taking low values below zero are allowed)");
            System.out.println("All y values have been multiplied by -1 before fitting");
            for (int j = 0; j < this.nData; ++j) {
                this.yData[j] = -this.yData[j];
            }
            arrayList = Regression.dataSign(this.yData);
            bl = true;
        }
        ArrayList<Object> arrayList2 = Regression.dataSign(this.yData);
        Integer n2 = null;
        n2 = (Integer)arrayList2.get(5);
        int n3 = n2;
        double d3 = this.xData[0][n3];
        double d4 = Math.sqrt(6.0) * Regression.halfWidth(this.xData[0], this.yData) / Math.PI;
        d = (Double)arrayList2.get(4);
        double d5 = d;
        d5 = d5 * d4 * Math.sqrt(Math.PI * 2);
        double[] dArray = new double[this.nParam];
        double[] dArray2 = new double[this.nParam];
        dArray[0] = d3;
        dArray[1] = d4;
        if (this.scaleFlag) {
            dArray[2] = d5;
        }
        dArray2[0] = 0.1 * d4;
        dArray2[1] = 0.1 * dArray[1];
        if (dArray2[1] == 0.0) {
            object2 = Regression.dataSign(this.xData[0]);
            object = null;
            object = (Double)((ArrayList)object2).get(2);
            double d6 = (Double)object;
            if (d6 == 0.0) {
                object = (Double)((ArrayList)object2).get(0);
                d6 = (Double)object;
            }
            dArray2[0] = d6 * 0.1;
        }
        if (this.scaleFlag) {
            dArray2[2] = 0.1 * dArray[2];
        }
        object2 = new LogisticFunction();
        this.addConstraint(1, -1, 0.0);
        ((LogisticFunction)object2).setScaleOption(this.scaleFlag);
        ((LogisticFunction)object2).setScaleFactor(this.yScaleFactor);
        object = object2;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.nelderMead(object, null, dArray, dArray2, this.fTol, this.nMax);
        if (n == 1) {
            int n4;
            if (!this.suppressPrint) {
                this.print();
            }
            if ((n4 = this.plotXY((RegressionFunction)object2)) != -2 && !this.suppressYYplot) {
                this.plotYY();
            }
        }
        if (bl) {
            for (int j = 0; j < this.nData - 1; ++j) {
                this.yData[j] = -this.yData[j];
            }
        }
    }

    public void beta() {
        this.fitBeta(0, 0);
    }

    public void betaPlot() {
        this.fitBeta(1, 0);
    }

    public void betaMinMax() {
        this.fitBeta(0, 1);
    }

    public void betaMinMaxPlot() {
        this.fitBeta(1, 1);
    }

    protected void fitBeta(int n, int n2) {
        int n3;
        double d;
        double d2;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.userSupplied = false;
        switch (n2) {
            case 0: {
                this.lastMethod = 31;
                this.nParam = 3;
                break;
            }
            case 1: {
                this.lastMethod = 32;
                this.nParam = 5;
            }
        }
        if (!this.scaleFlag) {
            --this.nParam;
        }
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double d3 = null;
        ArrayList<Object> arrayList = Regression.dataSign(this.yData);
        d3 = (Double)arrayList.get(4);
        double d4 = d3;
        boolean bl = false;
        if (d4 < 0.0) {
            System.out.println("Regression.fitBeta(): This implementation of the Beta distribution takes only positive y values\n(noise taking low values below zero are allowed)");
            System.out.println("All y values have been multiplied by -1 before fitting");
            for (int j = 0; j < this.nData; ++j) {
                this.yData[j] = -this.yData[j];
            }
            arrayList = Regression.dataSign(this.yData);
            bl = true;
        }
        ArrayList<Object> arrayList2 = Regression.dataSign(this.xData[0]);
        Integer n4 = null;
        n4 = (Integer)arrayList.get(5);
        int n5 = n4;
        double d5 = this.xData[0][n5];
        d3 = (Double)arrayList2.get(0);
        double d6 = d3;
        d3 = (Double)arrayList2.get(2);
        double d7 = d3;
        d3 = (Double)arrayList2.get(8);
        double d8 = d3;
        if (n2 == 0) {
            if (d6 < 0.0) {
                System.out.println("Regression: beta: data points must be greater than or equal to 0");
                System.out.println("method betaMinMax used in place of method beta");
                n2 = 1;
                this.lastMethod = 32;
                this.nParam = 5;
            }
            if (d7 > 1.0) {
                System.out.println("Regression: beta: data points must be less than or equal to 1");
                System.out.println("method betaMinMax used in place of method beta");
                n2 = 1;
                this.lastMethod = 32;
                this.nParam = 5;
            }
        }
        double d9 = d5;
        double d10 = d8;
        if (n2 == 1) {
            d9 = (d5 - d6 * 0.9) / (d7 * 1.2 - d6 * 0.9);
            d10 = (d8 - d6 * 0.9) / (d7 * 1.2 - d6 * 0.9);
        }
        if ((d2 = 2.0 * d9 * d10 / (d9 - d10)) < 1.3) {
            d2 = 1.6;
        }
        if ((d = d2 * (1.0 - d10) / d10) <= 1.3) {
            d = 1.6;
        }
        double d11 = 0.0;
        d11 = n2 == 0 ? d4 / Stat.betaPDF(d2, d, d5) : d4 / Stat.betaPDF(d6, d7, d2, d, d5);
        if (d11 < 0.0) {
            d11 = 1.0;
        }
        double[] dArray = new double[this.nParam];
        double[] dArray2 = new double[this.nParam];
        switch (n2) {
            case 0: {
                dArray[0] = d2;
                dArray[1] = d;
                if (this.scaleFlag) {
                    dArray[2] = d11;
                }
                dArray2[0] = 0.1 * dArray[0];
                dArray2[1] = 0.1 * dArray[1];
                if (this.scaleFlag) {
                    dArray2[2] = 0.1 * dArray[2];
                }
                this.addConstraint(0, -1, 1.0);
                this.addConstraint(1, -1, 1.0);
                break;
            }
            case 1: {
                dArray[0] = d2;
                dArray[1] = d;
                dArray[2] = 0.9 * d6;
                dArray[3] = 1.1 * d7;
                if (this.scaleFlag) {
                    dArray[4] = d11;
                }
                dArray2[0] = 0.1 * dArray[0];
                dArray2[1] = 0.1 * dArray[1];
                dArray2[2] = 0.1 * dArray[2];
                dArray2[3] = 0.1 * dArray[3];
                if (this.scaleFlag) {
                    dArray2[4] = 0.1 * dArray[4];
                }
                this.addConstraint(0, -1, 1.0);
                this.addConstraint(1, -1, 1.0);
                this.addConstraint(2, 1, d6);
                this.addConstraint(3, -1, d7);
            }
        }
        BetaFunction betaFunction = new BetaFunction();
        betaFunction.setTypeFlag(n2);
        betaFunction.setScaleOption(this.scaleFlag);
        betaFunction.setScaleFactor(this.yScaleFactor);
        BetaFunction betaFunction2 = betaFunction;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.nelderMead(betaFunction2, null, dArray, dArray2, this.fTol, this.nMax);
        if (n == 1) {
            if (!this.suppressPrint) {
                this.print();
            }
            if ((n3 = this.plotXY(betaFunction)) != -2 && !this.suppressYYplot) {
                this.plotYY();
            }
        }
        if (bl) {
            for (n3 = 0; n3 < this.nData - 1; ++n3) {
                this.yData[n3] = -this.yData[n3];
            }
        }
    }

    public void gamma() {
        this.fitGamma(0, 0);
    }

    public void gammaPlot() {
        this.fitGamma(1, 0);
    }

    public void gammaStandard() {
        this.fitGamma(0, 1);
    }

    public void gammaStandardPlot() {
        this.fitGamma(1, 1);
    }

    protected void fitGamma(int n, int n2) {
        int n3;
        double d;
        double d2;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.userSupplied = false;
        switch (n2) {
            case 0: {
                this.lastMethod = 33;
                this.nParam = 4;
                break;
            }
            case 1: {
                this.lastMethod = 34;
                this.nParam = 2;
            }
        }
        if (!this.scaleFlag) {
            --this.nParam;
        }
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double d3 = null;
        ArrayList<Object> arrayList = Regression.dataSign(this.yData);
        d3 = (Double)arrayList.get(4);
        double d4 = d3;
        boolean bl = false;
        if (d4 < 0.0) {
            System.out.println("Regression.fitGamma(): This implementation of the Gamma distribution takes only positive y values\n(noise taking low values below zero are allowed)");
            System.out.println("All y values have been multiplied by -1 before fitting");
            for (int j = 0; j < this.nData; ++j) {
                this.yData[j] = -this.yData[j];
            }
            arrayList = Regression.dataSign(this.yData);
            bl = true;
        }
        ArrayList<Object> arrayList2 = Regression.dataSign(this.xData[0]);
        Integer n4 = null;
        n4 = (Integer)arrayList.get(5);
        int n5 = n4;
        double d5 = this.xData[0][n5];
        d3 = (Double)arrayList2.get(0);
        double d6 = d3;
        d3 = (Double)arrayList2.get(2);
        double d7 = d3;
        d3 = (Double)arrayList2.get(8);
        double d8 = d3;
        if (n2 == 1 && d6 < 0.0) {
            System.out.println("Regression: gammaStandard: data points must be greater than or equal to 0");
            System.out.println("method gamma used in place of method gammaStandard");
            n2 = 0;
            this.lastMethod = 33;
            this.nParam = 2;
        }
        if ((d2 = 0.8 * d6) == 0.0) {
            d2 = -0.1;
        }
        if ((d = d8 - d5) <= 0.0) {
            d = 1.0;
        }
        double d9 = (d8 + d2) / d;
        if (n2 == 1) {
            d9 = d8;
        }
        if (d9 <= 0.0) {
            d9 = 1.0;
        }
        double d10 = 0.0;
        d10 = n2 == 0 ? d4 / Stat.gammaPDF(d2, d, d9, d5) : d4 / Stat.gammaPDF(d9, d5);
        if (d10 < 0.0) {
            d10 = 1.0;
        }
        double[] dArray = new double[this.nParam];
        double[] dArray2 = new double[this.nParam];
        switch (n2) {
            case 1: {
                dArray[0] = d9;
                if (this.scaleFlag) {
                    dArray[1] = d10;
                }
                dArray2[0] = 0.1 * dArray[0];
                if (this.scaleFlag) {
                    dArray2[1] = 0.1 * dArray[1];
                }
                this.addConstraint(0, -1, 0.0);
                break;
            }
            case 0: {
                dArray[0] = d2;
                dArray[1] = d;
                dArray[2] = d9;
                if (this.scaleFlag) {
                    dArray[3] = d10;
                }
                dArray2[0] = 0.1 * dArray[0];
                dArray2[1] = 0.1 * dArray[1];
                dArray2[2] = 0.1 * dArray[2];
                if (this.scaleFlag) {
                    dArray2[3] = 0.1 * dArray[3];
                }
                this.addConstraint(1, -1, 0.0);
                this.addConstraint(2, -1, 0.0);
            }
        }
        GammaFunction gammaFunction = new GammaFunction();
        gammaFunction.setTypeFlag(n2);
        gammaFunction.setScaleOption(this.scaleFlag);
        gammaFunction.setScaleFactor(this.yScaleFactor);
        GammaFunction gammaFunction2 = gammaFunction;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.nelderMead(gammaFunction2, null, dArray, dArray2, this.fTol, this.nMax);
        if (n == 1) {
            if (!this.suppressPrint) {
                this.print();
            }
            if ((n3 = this.plotXY(gammaFunction)) != -2 && !this.suppressYYplot) {
                this.plotYY();
            }
        }
        if (bl) {
            for (n3 = 0; n3 < this.nData - 1; ++n3) {
                this.yData[n3] = -this.yData[n3];
            }
        }
    }

    public void erlang() {
        this.fitErlang(0, 0);
    }

    public void erlangPlot() {
        this.fitErlang(1, 0);
    }

    protected void fitErlang(int n, int n2) {
        int n3;
        double d;
        double d2;
        int n4;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 35;
        this.userSupplied = false;
        int n5 = 2;
        this.nParam = n4 = 4;
        if (!this.scaleFlag) {
            --this.nParam;
        }
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double d3 = null;
        ArrayList<Object> arrayList = Regression.dataSign(this.yData);
        d3 = (Double)arrayList.get(4);
        double d4 = d3;
        boolean bl = false;
        if (d4 < 0.0) {
            System.out.println("Regression.fitGamma(): This implementation of the Erlang distribution takes only positive y values\n(noise taking low values below zero are allowed)");
            System.out.println("All y values have been multiplied by -1 before fitting");
            for (int j = 0; j < this.nData; ++j) {
                this.yData[j] = -this.yData[j];
            }
            arrayList = Regression.dataSign(this.yData);
            bl = true;
        }
        ArrayList<Object> arrayList2 = Regression.dataSign(this.xData[0]);
        Integer n6 = null;
        n6 = (Integer)arrayList.get(5);
        int n7 = n6;
        double d5 = this.xData[0][n7];
        d3 = (Double)arrayList2.get(0);
        double d6 = d3;
        d3 = (Double)arrayList2.get(2);
        double d7 = d3;
        d3 = (Double)arrayList2.get(8);
        double d8 = d3;
        if (d6 < 0.0) {
            throw new IllegalArgumentException("data points must be greater than or equal to 0");
        }
        double d9 = 0.8 * d6;
        if (d9 == 0.0) {
            d9 = -0.1;
        }
        if ((d2 = d8 - d5) <= 0.0) {
            d2 = 1.0;
        }
        double d10 = (d8 + d9) / d2;
        if (n2 == 1) {
            d10 = d8;
        }
        if (d10 <= 0.0) {
            d10 = 1.0;
        }
        double d11 = 0.0;
        d11 = d4 / Stat.gammaPDF(d9, d2, d10, d5);
        if (d11 < 0.0) {
            d11 = 1.0;
        }
        double[] dArray = new double[this.nParam];
        double[] dArray2 = new double[this.nParam];
        dArray[0] = d9;
        dArray[1] = d2;
        dArray[2] = d10;
        if (this.scaleFlag) {
            dArray[3] = d11;
        }
        dArray2[0] = 0.1 * dArray[0];
        dArray2[1] = 0.1 * dArray[1];
        dArray2[2] = 0.1 * dArray[2];
        if (this.scaleFlag) {
            dArray2[3] = 0.1 * dArray[3];
        }
        this.addConstraint(1, -1, 0.0);
        this.addConstraint(2, -1, 0.0);
        GammaFunction gammaFunction = new GammaFunction();
        gammaFunction.setTypeFlag(n2);
        gammaFunction.setScaleOption(this.scaleFlag);
        gammaFunction.setScaleFactor(this.yScaleFactor);
        GammaFunction gammaFunction2 = gammaFunction;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.nelderMead(gammaFunction2, null, dArray, dArray2, this.fTol, this.nMax);
        this.removeConstraints();
        double[] dArray3 = this.getCoeff();
        this.nParam = n5;
        dArray = new double[this.nParam];
        dArray2 = new double[this.nParam];
        if (dArray3[3] < 0.0) {
            dArray3[3] = dArray3[3] * -1.0;
        }
        dArray[0] = 1.0 / dArray3[1];
        if (this.scaleFlag) {
            dArray[1] = dArray3[3];
        }
        dArray2[0] = 0.1 * dArray[0];
        if (this.scaleFlag) {
            dArray2[1] = 0.1 * dArray[1];
        }
        this.addConstraint(0, -1, 0.0);
        double d12 = d = (double)Math.round(dArray3[2]);
        ErlangFunction erlangFunction = new ErlangFunction();
        erlangFunction.setScaleOption(this.scaleFlag);
        erlangFunction.setScaleFactor(this.yScaleFactor);
        erlangFunction.setKay(d12);
        boolean bl2 = true;
        double d13 = Double.NaN;
        double d14 = Double.NaN;
        double d15 = Double.NaN;
        double d16 = Double.NaN;
        int n8 = 1;
        int n9 = 0;
        while (bl2) {
            ErlangFunction erlangFunction2 = erlangFunction;
            this.simplexFlag = 1;
            this.nonLinStatsNeeded = true;
            this.dualErrorsRequired = false;
            this.nelderMead(erlangFunction2, null, dArray, dArray2, this.fTol, this.nMax);
            double d17 = this.getSumOfSquares();
            if (n8 == 1) {
                n8 = 2;
                d13 = d17;
                d12 += 1.0;
                dArray[0] = 1.0 / dArray3[1];
                if (this.scaleFlag) {
                    dArray[1] = dArray3[3];
                }
                dArray2[0] = 0.1 * dArray[0];
                if (this.scaleFlag) {
                    dArray2[1] = 0.1 * dArray[1];
                }
                this.addConstraint(0, -1, 0.0);
                erlangFunction.setKay(d12);
                continue;
            }
            if (d17 <= d13) {
                if (d17 == d13 && ++n9 == 10) {
                    d14 = d13;
                    d15 = d12 - 5.0;
                    bl2 = false;
                }
                d13 = d17;
                d12 += 1.0;
                dArray[0] = 1.0 / dArray3[1];
                if (this.scaleFlag) {
                    dArray[1] = dArray3[3];
                }
                dArray2[0] = 0.1 * dArray[0];
                if (this.scaleFlag) {
                    dArray2[1] = 0.1 * dArray[1];
                }
                this.addConstraint(0, -1, 0.0);
                erlangFunction.setKay(d12);
                continue;
            }
            d14 = d13;
            d15 = d12 - 1.0;
            bl2 = false;
        }
        if (d == 1.0) {
            d16 = d15;
        } else {
            n8 = 1;
            bl2 = true;
            d13 = Double.NaN;
            double d18 = Double.NaN;
            double d19 = Double.NaN;
            dArray[0] = 1.0 / dArray3[1];
            if (this.scaleFlag) {
                dArray[1] = dArray3[3];
            }
            dArray2[0] = 0.1 * dArray[0];
            if (this.scaleFlag) {
                dArray2[1] = 0.1 * dArray[1];
            }
            this.addConstraint(0, -1, 0.0);
            d12 = d;
            erlangFunction.setKay(d12);
            while (bl2) {
                ErlangFunction erlangFunction3 = erlangFunction;
                this.simplexFlag = 1;
                this.nonLinStatsNeeded = true;
                this.dualErrorsRequired = false;
                this.nelderMead(erlangFunction3, null, dArray, dArray2, this.fTol, this.nMax);
                double d20 = this.getSumOfSquares();
                if (n8 == 1) {
                    n8 = 2;
                    d13 = d20;
                    if (Math.rint(d12 -= 1.0) < 1.0) {
                        d18 = d13;
                        d19 = d12 + 1.0;
                        bl2 = false;
                        continue;
                    }
                    dArray[0] = 1.0 / dArray3[1];
                    if (this.scaleFlag) {
                        dArray[1] = dArray3[3];
                    }
                    dArray2[0] = 0.1 * dArray[0];
                    if (this.scaleFlag) {
                        dArray2[1] = 0.1 * dArray[1];
                    }
                    this.addConstraint(0, -1, 0.0);
                    erlangFunction.setKay(d12);
                    continue;
                }
                if (d20 <= d13) {
                    d13 = d20;
                    if (Math.rint(d12 -= 1.0) < 1.0) {
                        d18 = d13;
                        d19 = d12 + 1.0;
                        bl2 = false;
                        continue;
                    }
                    dArray[0] = 1.0 / dArray3[1];
                    if (this.scaleFlag) {
                        dArray[1] = dArray3[3];
                    }
                    dArray2[0] = 0.1 * dArray[0];
                    if (this.scaleFlag) {
                        dArray2[1] = 0.1 * dArray[1];
                    }
                    this.addConstraint(0, -1, 0.0);
                    erlangFunction.setKay(d12);
                    continue;
                }
                d18 = d13;
                d19 = d12 + 1.0;
                bl2 = false;
            }
            d16 = d18 < d14 ? d19 : d15;
        }
        dArray[0] = 1.0 / dArray3[1];
        if (this.scaleFlag) {
            dArray[1] = dArray3[3];
        }
        dArray2[0] = 0.1 * dArray[0];
        if (this.scaleFlag) {
            dArray2[1] = 0.1 * dArray[1];
        }
        this.addConstraint(0, -1, 0.0);
        erlangFunction.setScaleOption(this.scaleFlag);
        erlangFunction.setScaleFactor(this.yScaleFactor);
        erlangFunction.setKay(Math.round(d16));
        this.kayValue = Math.round(d16);
        ErlangFunction erlangFunction4 = erlangFunction;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.nelderMead(erlangFunction4, null, dArray, dArray2, this.fTol, this.nMax);
        double[] dArray4 = this.getCoeff();
        dArray[0] = dArray4[0];
        if (this.scaleFlag) {
            dArray[1] = dArray4[1];
        }
        dArray2[0] = 0.1 * dArray[0];
        if (this.scaleFlag) {
            dArray2[1] = 0.1 * dArray[1];
        }
        this.addConstraint(0, -1, 0.0);
        erlangFunction.setScaleOption(this.scaleFlag);
        erlangFunction.setScaleFactor(this.yScaleFactor);
        erlangFunction.setKay(Math.round(d16));
        this.kayValue = Math.round(d16);
        ErlangFunction erlangFunction5 = erlangFunction;
        this.simplexFlag = 1;
        this.nonLinStatsNeeded = true;
        this.dualErrorsRequired = false;
        this.nelderMead(erlangFunction5, null, dArray, dArray2, this.fTol, this.nMax);
        if (n == 1) {
            if (!this.suppressPrint) {
                this.print();
            }
            if ((n3 = this.plotXY(erlangFunction)) != -2 && !this.suppressYYplot) {
                this.plotYY();
            }
        }
        if (bl) {
            for (n3 = 0; n3 < this.nData - 1; ++n3) {
                this.yData[n3] = -this.yData[n3];
            }
        }
    }

    public double getKayValue() {
        return this.kayValue;
    }

    public static double[][] histogramBins(double[] dArray, double d, double d2, double d3) {
        int n = 0;
        int n2 = dArray.length;
        for (int j = 0; j < n2; ++j) {
            if (!(dArray[j] <= d3)) continue;
            ++n;
        }
        if (n != n2) {
            double[] dArray2 = new double[n];
            int n3 = 0;
            for (int j = 0; j < n2; ++j) {
                if (!(dArray[j] <= d3)) continue;
                dArray2[n3] = dArray[j];
                ++n3;
            }
            System.out.println(n2 - n + " data points, above histogram upper limit, excluded in histogramBins");
            return Regression.histogramBins(dArray2, d, d2);
        }
        return Regression.histogramBins(dArray, d, d2);
    }

    public static double[][] histogramBins(double[] dArray, double d, double d2) {
        int n;
        int n2;
        int n3;
        double d3 = Fmath.maximum(dArray);
        int n4 = (int)Math.ceil((d3 - d2) / d);
        if (d2 + (double)n4 * d > d3) {
            ++n4;
        }
        int n5 = dArray.length;
        int[] nArray = new int[n5];
        for (int j = 0; j < n5; ++j) {
            nArray[j] = 0;
        }
        double[] dArray2 = new double[n4 + 1];
        dArray2[0] = d2;
        for (int j = 1; j <= n4; ++j) {
            dArray2[j] = dArray2[j - 1] + d;
        }
        double[][] dArray3 = new double[2][n4];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray3[0][n3] = (dArray2[n3] + dArray2[n3 + 1]) / 2.0;
            dArray3[1][n3] = 0.0;
        }
        n3 = 1;
        for (n2 = 0; n2 < n5; ++n2) {
            n3 = 1;
            n = 0;
            while (n3 != 0) {
                if (n == n4 - 1) {
                    if (dArray[n2] >= dArray2[n] && dArray[n2] <= dArray2[n + 1] * (1.0 + histTol)) {
                        double[] dArray4 = dArray3[1];
                        int n6 = n;
                        dArray4[n6] = dArray4[n6] + 1.0;
                        nArray[n2] = 1;
                        n3 = 0;
                    }
                } else if (dArray[n2] >= dArray2[n] && dArray[n2] < dArray2[n + 1]) {
                    double[] dArray5 = dArray3[1];
                    int n7 = n;
                    dArray5[n7] = dArray5[n7] + 1.0;
                    nArray[n2] = 1;
                    n3 = 0;
                }
                if (n3 == 0) continue;
                if (n == n4 - 1) {
                    n3 = 0;
                    continue;
                }
                ++n;
            }
        }
        n2 = 0;
        for (n = 0; n < n5; ++n) {
            if (nArray[n] != 0) continue;
            ++n2;
            System.out.println("p " + n + " " + dArray[n] + " " + dArray2[0] + " " + dArray2[n4]);
        }
        if (n2 > 0) {
            System.out.println(n2 + " data points, outside histogram limits, excluded in histogramBins");
        }
        return dArray3;
    }

    public static double[][] histogramBins(double[] dArray, double d) {
        double d2 = Fmath.minimum(dArray);
        double d3 = Fmath.maximum(dArray);
        double d4 = d3 - d2;
        double d5 = d2;
        int n = (int)Math.ceil(d4 / d);
        double d6 = (double)n * d;
        double d7 = d6 - d4;
        if (d7 >= 0.0) {
            d5 -= d7 / 2.0;
        } else if (Math.abs(d7) / d4 > histTol) {
            boolean bl = true;
            double d8 = histTol / (double)n;
            int n2 = 0;
            while (bl) {
                d6 = (double)n * (d += d8);
                d7 = d6 - d4;
                if (d7 < 0.0) {
                    if (++n2 <= 1000) continue;
                    bl = false;
                    System.out.println("histogram method could not encompass all data within histogram\nContact Michael thomas Flanagan");
                    continue;
                }
                bl = false;
            }
        }
        return Regression.histogramBins(dArray, d, d5);
    }

    public void simplex2(RegressionFunction2 regressionFunction2, double[] dArray, double[] dArray2, double d, int n) {
        this.simplex(regressionFunction2, dArray, dArray2, d, n);
    }

    public void simplex2(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2, double d, int n) {
        this.simplex(regressionFunction2, regressionDerivativeFunction2, dArray, dArray2, d, n);
    }

    public void simplexPlot2(RegressionFunction2 regressionFunction2, double[] dArray, double[] dArray2, double d, int n) {
        this.simplexPlot(regressionFunction2, dArray, dArray2, d, n);
    }

    public void simplexPlot2(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2, double d, int n) {
        this.simplexPlot(regressionFunction2, regressionDerivativeFunction2, dArray, dArray2, d, n);
    }

    public void simplex2(RegressionFunction2 regressionFunction2, double[] dArray, double[] dArray2, double d) {
        this.simplex(regressionFunction2, dArray, dArray2, d);
    }

    public void simplex2(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2, double d) {
        this.simplex(regressionFunction2, regressionDerivativeFunction2, dArray, dArray2, d);
    }

    public void simplexPlot2(RegressionFunction2 regressionFunction2, double[] dArray, double[] dArray2, double d) {
        this.simplexPlot(regressionFunction2, dArray, dArray2, d);
    }

    public void simplexPlot2(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2, double d) {
        this.simplexPlot(regressionFunction2, regressionDerivativeFunction2, dArray, dArray2, d);
    }

    public void simplex2(RegressionFunction2 regressionFunction2, double[] dArray, double[] dArray2, int n) {
        this.simplex(regressionFunction2, dArray, dArray2, n);
    }

    public void simplex2(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2, int n) {
        this.simplex(regressionFunction2, regressionDerivativeFunction2, dArray, dArray2, n);
    }

    public void simplexPlot2(RegressionFunction2 regressionFunction2, double[] dArray, double[] dArray2, int n) {
        this.simplexPlot(regressionFunction2, dArray, dArray2, n);
    }

    public void simplexPlot2(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2, int n) {
        this.simplexPlot(regressionFunction2, regressionDerivativeFunction2, dArray, dArray2, n);
    }

    public void simplex2(RegressionFunction2 regressionFunction2, double[] dArray, double[] dArray2) {
        this.simplex(regressionFunction2, dArray, dArray2);
    }

    public void simplex2(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2) {
        this.simplex(regressionFunction2, regressionDerivativeFunction2, dArray, dArray2);
    }

    public void simplexPlot2(RegressionFunction2 regressionFunction2, double[] dArray, double[] dArray2) {
        this.simplexPlot(regressionFunction2, dArray, dArray2);
    }

    public void simplexPlot2(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double[] dArray2) {
        this.simplexPlot(regressionFunction2, regressionDerivativeFunction2, dArray, dArray2);
    }

    public void simplex2(RegressionFunction2 regressionFunction2, double[] dArray, double d, int n) {
        this.simplex(regressionFunction2, dArray, d, n);
    }

    public void simplex2(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double d, int n) {
        this.simplex(regressionFunction2, regressionDerivativeFunction2, dArray, d, n);
    }

    public void simplexPlot2(RegressionFunction2 regressionFunction2, double[] dArray, double d, int n) {
        this.simplexPlot(regressionFunction2, dArray, d, n);
    }

    public void simplexPlot2(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double d, int n) {
        this.simplexPlot(regressionFunction2, regressionDerivativeFunction2, dArray, d, n);
    }

    public void simplex2(RegressionFunction2 regressionFunction2, double[] dArray, double d) {
        this.simplex(regressionFunction2, dArray, d);
    }

    public void simplex2(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double d) {
        this.simplex(regressionFunction2, regressionDerivativeFunction2, dArray, d);
    }

    public void simplexPlot2(RegressionFunction2 regressionFunction2, double[] dArray, double d) {
        this.simplexPlot(regressionFunction2, dArray, d);
    }

    public void simplexPlot2(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, double d) {
        this.simplexPlot(regressionFunction2, regressionDerivativeFunction2, dArray, d);
    }

    public void simplex2(RegressionFunction2 regressionFunction2, double[] dArray, int n) {
        this.simplex(regressionFunction2, dArray, n);
    }

    public void simplex2(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, int n) {
        this.simplex(regressionFunction2, regressionDerivativeFunction2, dArray, n);
    }

    public void simplexPlot2(RegressionFunction2 regressionFunction2, double[] dArray, int n) {
        this.simplexPlot(regressionFunction2, dArray, n);
    }

    public void simplexPlot2(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray, int n) {
        this.simplexPlot(regressionFunction2, regressionDerivativeFunction2, dArray, n);
    }

    public void simplex2(RegressionFunction2 regressionFunction2, double[] dArray) {
        this.simplex(regressionFunction2, dArray);
    }

    public void simplex2(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray) {
        this.simplex(regressionFunction2, regressionDerivativeFunction2, dArray);
    }

    public void simplexPlot2(RegressionFunction2 regressionFunction2, double[] dArray) {
        this.simplexPlot(regressionFunction2, dArray);
    }

    public void simplexPlot2(RegressionFunction2 regressionFunction2, RegressionDerivativeFunction2 regressionDerivativeFunction2, double[] dArray) {
        this.simplexPlot(regressionFunction2, regressionDerivativeFunction2, dArray);
    }

    protected int plotXY2(RegressionFunction2 regressionFunction2, String string) {
        return this.plotXY(regressionFunction2, string);
    }

    protected int plotXY2(RegressionFunction2 regressionFunction2) {
        return this.plotXY(regressionFunction2);
    }

    public void pareto() {
        this.fitPareto(0, 2);
    }

    public void paretoPlot() {
        this.fitPareto(1, 2);
    }
}

